var N = null;var searchIndex = {};
searchIndex["alloc"]={"doc":"The Rust core allocation and collections library","items":[[0,"alloc","alloc","Memory allocation APIs",N,N],[3,"Excess","alloc::alloc","Represents the combination of a starting address and a total capacity of the returned block.",N,N],[12,"0","","",0,N],[12,"1","","",0,N],[3,"Layout","","Layout of a block of memory.",N,N],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` or some other `Layout` constructor do not satisfy its documented constraints.",N,N],[3,"AllocErr","","The `AllocErr` error indicates an allocation failure that may be due to resource exhaustion or to something wrong when combining the given input arguments with this allocator.",N,N],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when `grow_in_place` or `shrink_in_place` were unable to reuse the given memory block for a requested layout.",N,N],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard library’s default though the `#[global_allocator]` attributes.",N,N],[10,"alloc","","Allocate memory as described by the given `layout`.",1,N],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer with the given `layout`.",1,N],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",1,N],[11,"realloc","","Shink or grow a block of memory to the given `new_size`. The block is described by the given `ptr` pointer and `layout`.",1,N],[8,"Alloc","","An implementation of `Alloc` can allocate, reallocate, and deallocate arbitrary blocks of data described via `Layout`.",N,N],[10,"alloc","","Returns a pointer meeting the size and alignment guarantees of `layout`.",2,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",2,N],[11,"usable_size","","Returns bounds on the guaranteed usable size of a successful allocation created with the specified `layout`.",2,N],[11,"realloc","","Returns a pointer suitable for holding data described by a new layout with `layout`’s alginment and a size given by `new_size`. To accomplish this, this may extend or shrink the allocation referenced by `ptr` to fit the new layout.",2,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",2,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[11,"alloc_excess","","Behaves like `alloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",2,[[["self"],["layout"]],["result",["excess","allocerr"]]]],[11,"realloc_excess","","Behaves like `realloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",2,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["excess","allocerr"]]]],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to fit `new_size`.",2,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["cannotreallocinplace"]]]],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to fit `new_size`.",2,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["cannotreallocinplace"]]]],[11,"alloc_one","","Allocates a block suitable for holding an instance of `T`.",2,[[["self"]],["result",["nonnull","allocerr"]]]],[11,"dealloc_one","","Deallocates a block suitable for holding an instance of `T`.",2,N],[11,"alloc_array","","Allocates a block suitable for holding `n` instances of `T`.",2,[[["self"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"realloc_array","","Reallocates a block previously suitable for holding `n_old` instances of `T`, returning a block suitable for holding `n_new` instances of `T`.",2,[[["self"],["nonnull"],["usize"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"dealloc_array","","Deallocates a block suitable for holding `n` instances of `T`.",2,[[["self"],["nonnull"],["usize"]],["result",["allocerr"]]]],[3,"Global","","The global memory allocator.",N,N],[5,"alloc","","Allocate memory with the global allocator.",N,N],[5,"dealloc","","Deallocate memory with the global allocator.",N,N],[5,"realloc","","Reallocate memory with the global allocator.",N,N],[5,"alloc_zeroed","","Allocate zero-initialized memory with the global allocator.",N,N],[5,"handle_alloc_error","","Abort on memory allocation error or failure.",N,N],[0,"task","alloc","Types and Traits for working with asynchronous tasks.",N,N],[3,"LocalWaker","alloc::task","A `LocalWaker` is a handle for waking up a task by notifying its executor that it is ready to be run.",N,N],[8,"UnsafeWake","","An unsafe trait for implementing custom memory management for a `Waker` or `LocalWaker`.",N,N],[10,"clone_raw","","Creates a clone of this `UnsafeWake` and stores it behind a `Waker`.",3,[[["self"]],["waker"]]],[10,"drop_raw","","Drops this instance of `UnsafeWake`, deallocating resources associated with it.",3,N],[10,"wake","","Indicates that the associated task is ready to make progress and should be `poll`ed.",3,N],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is the same as `wake`, but can only be called from the thread that this `UnsafeWake` is \"local\" to. This allows for implementors to provide specialized wakeup behavior specific to the current thread. This function is called by `LocalWaker::wake`.",3,N],[4,"Poll","","Indicates whether a value is available or if the current task has been scheduled to receive a wakeup instead.",N,N],[13,"Ready","","Represents that a value is immediately ready.",4,N],[13,"Pending","","Represents that a value is not ready yet.",4,N],[3,"Waker","","A `Waker` is a handle for waking up a task by notifying its executor that it is ready to be run.",N,N],[5,"local_waker","","Creates a `LocalWaker` from a local `wake`.",N,[[["arc"]],["localwaker"]]],[5,"local_waker_from_nonlocal","","Creates a `LocalWaker` from a non-local `wake`.",N,[[["arc"]],["localwaker"]]],[8,"Wake","","A way of waking up a specific task.",N,N],[10,"wake","","Indicates that the associated task is ready to make progress and should be `poll`ed.",5,[[["arc"]]]],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is like `wake`, but can only be called from the thread on which this `Wake` was created.",5,[[["arc"]]]],[0,"boxed","alloc","A pointer type for heap allocation.",N,N],[3,"Box","alloc::boxed","A pointer type for heap allocation.",N,N],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed closure objects. The idea is that where one would normally store a `Box<FnOnce()>` in a data structure, you should use `Box<FnBox()>`. The two traits behave essentially the same, except that a `FnBox` closure can only be called if it is boxed. (Note that `FnBox` may be deprecated in the future if `Box<FnOnce()>` closures become directly usable.)",N,N],[16,"Output","","",6,N],[10,"call_box","","",6,N],[11,"new","","Allocates memory on the heap and then places `x` into it.",7,[[["t"]],["box"]]],[11,"pinned","","",7,[[["t"]],["pin",["box"]]]],[11,"from_raw","","Constructs a box from a raw pointer.",7,N],[11,"into_raw","","Consumes the `Box`, returning a wrapped raw pointer.",7,N],[11,"into_raw_non_null","","Consumes the `Box`, returning the wrapped pointer as `NonNull<T>`.",7,[[["box"]],["nonnull"]]],[11,"leak","","Consumes and leaks the `Box`, returning a mutable reference, `&'a mut T`. Note that the type `T` must outlive the chosen lifetime `'a`. If the type has only static references, or none at all, then this may be chosen to be `'static`.",7,[[["box"]],["t"]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",7,[[["self"]],["result",["box","box"]]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",7,[[["self"]],["result",["box","box"]]]],[0,"collections","alloc","Collection types.",N,N],[4,"CollectionAllocErr","alloc::collections","Augments `AllocErr` with a CapacityOverflow variant.",N,N],[13,"CapacityOverflow","","Error due to the computed capacity exceeding the collection's maximum (usually `isize::MAX` bytes).",8,N],[13,"AllocErr","","Error due to the allocator (see the `AllocErr` type's docs).",8,N],[0,"binary_heap","","A priority queue implemented with a binary heap.",N,N],[3,"BinaryHeap","alloc::collections::binary_heap","A priority queue implemented with a binary heap.",N,N],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest item on a `BinaryHeap`.",N,N],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",N,N],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",N,N],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",N,N],[11,"pop","","Removes the peeked value from the heap and returns it.",9,[[["peekmut"]],["t"]]],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",10,[[],["binaryheap"]]],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity. This preallocates enough memory for `capacity` elements, so that the `BinaryHeap` does not have to be reallocated until it contains at least that many values.",10,[[["usize"]],["binaryheap"]]],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in arbitrary order.",10,[[["self"]],["iter"]]],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",10,[[["self"]],["option"]]],[11,"peek_mut","","Returns a mutable reference to the greatest item in the binary heap, or `None` if it is empty.",10,[[["self"]],["option",["peekmut"]]]],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",10,[[["self"]],["usize"]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `BinaryHeap`. Does nothing if the capacity is already sufficient.",10,[[["self"],["usize"]]]],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the `BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",10,[[["self"],["usize"]]]],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",10,[[["self"]]]],[11,"shrink_to","","Discards capacity with a lower bound.",10,[[["self"],["usize"]]]],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it is empty.",10,[[["self"]],["option"]]],[11,"push","","Pushes an item onto the binary heap.",10,[[["self"],["t"]]]],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector in arbitrary order.",10,[[["self"]],["vec"]]],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted (ascending) order.",10,[[["self"]],["vec"]]],[11,"len","","Returns the length of the binary heap.",10,[[["self"]],["usize"]]],[11,"is_empty","","Checks if the binary heap is empty.",10,[[["self"]],["bool"]]],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",10,[[["self"]],["drain"]]],[11,"clear","","Drops all items from the binary heap.",10,[[["self"]]]],[11,"append","","Moves all the elements of `other` into `self`, leaving `other` empty.",10,[[["self"],["self"]]]],[0,"linked_list","alloc::collections","A doubly-linked list with owned nodes.",N,N],[3,"LinkedList","alloc::collections::linked_list","A doubly-linked list with owned nodes.",N,N],[3,"Iter","","An iterator over the elements of a `LinkedList`.",N,N],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",N,N],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",N,N],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on LinkedList.",N,N],[11,"new","","Creates an empty `LinkedList`.",11,[[],["self"]]],[11,"append","","Moves all elements from `other` to the end of the list.",11,[[["self"],["self"]]]],[11,"iter","","Provides a forward iterator.",11,[[["self"]],["iter"]]],[11,"iter_mut","","Provides a forward iterator with mutable references.",11,[[["self"]],["itermut"]]],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",11,[[["self"]],["bool"]]],[11,"len","","Returns the length of the `LinkedList`.",11,[[["self"]],["usize"]]],[11,"clear","","Removes all elements from the `LinkedList`.",11,[[["self"]]]],[11,"contains","","Returns `true` if the `LinkedList` contains an element equal to the given value.",11,[[["self"],["t"]],["bool"]]],[11,"front","","Provides a reference to the front element, or `None` if the list is empty.",11,[[["self"]],["option"]]],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list is empty.",11,[[["self"]],["option"]]],[11,"back","","Provides a reference to the back element, or `None` if the list is empty.",11,[[["self"]],["option"]]],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list is empty.",11,[[["self"]],["option"]]],[11,"push_front","","Adds an element first in the list.",11,[[["self"],["t"]]]],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is empty.",11,[[["self"]],["option"]]],[11,"push_back","","Appends an element to the back of a list",11,[[["self"],["t"]]]],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if it is empty.",11,[[["self"]],["option"]]],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index, including the index.",11,[[["self"],["usize"]],["linkedlist"]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if an element should be removed.",11,[[["self"],["f"]],["drainfilter"]]],[11,"insert_next","","Inserts the given element just after the element most recently returned by `.next()`. The inserted element does not appear in the iteration.",12,[[["self"],["t"]]]],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",12,[[["self"]],["option"]]],[0,"vec_deque","alloc::collections","A double-ended queue implemented with a growable ring buffer.",N,N],[3,"VecDeque","alloc::collections::vec_deque","A double-ended queue implemented with a growable ring buffer.",N,N],[3,"Iter","","An iterator over the elements of a `VecDeque`.",N,N],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",N,N],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",N,N],[3,"Drain","","A draining iterator over the elements of a `VecDeque`.",N,N],[11,"new","","Creates an empty `VecDeque`.",13,[[],["vecdeque"]]],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",13,[[["usize"]],["vecdeque"]]],[11,"get","","Retrieves an element in the `VecDeque` by index.",13,[[["self"],["usize"]],["option"]]],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",13,[[["self"],["usize"]],["option"]]],[11,"swap","","Swaps elements at indices `i` and `j`.",13,[[["self"],["usize"],["usize"]]]],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without reallocating.",13,[[["self"]],["usize"]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque`. Does nothing if the capacity is already sufficient.",13,[[["self"],["usize"]]]],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `VecDeque`. The collection may reserve more space to avoid frequent reallocations.",13,[[["self"],["usize"]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `VecDeque<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",13,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `VecDeque<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",13,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",13,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of the `VecDeque` with a lower bound.",13,[[["self"],["usize"]]]],[11,"truncate","","Shortens the `VecDeque`, dropping excess elements from the back.",13,[[["self"],["usize"]]]],[11,"iter","","Returns a front-to-back iterator.",13,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",13,[[["self"]],["itermut"]]],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",13,N],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the `VecDeque`.",13,N],[11,"len","","Returns the number of elements in the `VecDeque`.",13,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the `VecDeque` is empty.",13,[[["self"]],["bool"]]],[11,"drain","","Create a draining iterator that removes the specified range in the `VecDeque` and yields the removed items.",13,[[["self"],["r"]],["drain"]]],[11,"clear","","Clears the `VecDeque`, removing all values.",13,[[["self"]]]],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal to the given value.",13,[[["self"],["t"]],["bool"]]],[11,"front","","Provides a reference to the front element, or `None` if the `VecDeque` is empty.",13,[[["self"]],["option"]]],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the `VecDeque` is empty.",13,[[["self"]],["option"]]],[11,"back","","Provides a reference to the back element, or `None` if the `VecDeque` is empty.",13,[[["self"]],["option"]]],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the `VecDeque` is empty.",13,[[["self"]],["option"]]],[11,"pop_front","","Removes the first element and returns it, or `None` if the `VecDeque` is empty.",13,[[["self"]],["option"]]],[11,"push_front","","Prepends an element to the `VecDeque`.",13,[[["self"],["t"]]]],[11,"push_back","","Appends an element to the back of the `VecDeque`.",13,[[["self"],["t"]]]],[11,"pop_back","","Removes the last element from the `VecDeque` and returns it, or `None` if it is empty.",13,[[["self"]],["option"]]],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the last element.",13,[[["self"],["usize"]],["option"]]],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the first element.",13,[[["self"],["usize"]],["option"]]],[11,"insert","","Inserts an element at `index` within the `VecDeque`, shifting all elements with indices greater than or equal to `index` towards the back.",13,[[["self"],["usize"],["t"]]]],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`. Whichever end is closer to the removal point will be moved to make room, and all the affected elements will be moved to new positions. Returns `None` if `index` is out of bounds.",13,[[["self"],["usize"]],["option"]]],[11,"split_off","","Splits the `VecDeque` into two at the given index.",13,[[["self"],["usize"]],["self"]]],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",13,[[["self"],["self"]]]],[11,"retain","","Retains only the elements specified by the predicate.",13,[[["self"],["f"]]]],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len, either by removing excess elements from the back or by appending clones of `value` to the back.",13,[[["self"],["usize"],["t"]]]],[0,"btree_map","alloc::collections","A map based on a B-Tree.",N,N],[3,"BTreeMap","alloc::collections::btree_map","A map based on a B-Tree.",N,N],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",N,N],[3,"IterMut","","A mutable iterator over the entries of a `BTreeMap`.",N,N],[3,"IntoIter","","An owning iterator over the entries of a `BTreeMap`.",N,N],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",N,N],[3,"Values","","An iterator over the values of a `BTreeMap`.",N,N],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",N,N],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",N,N],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a `BTreeMap`.",N,N],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of the [`Entry`] enum.",N,N],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part of the [`Entry`] enum.",N,N],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.",N,N],[13,"Vacant","","A vacant entry.",14,N],[13,"Occupied","","An occupied entry.",14,N],[0,"btree_set","alloc::collections","A set based on a B-Tree.",N,N],[3,"BTreeSet","alloc::collections::btree_set","A set based on a B-Tree.",N,N],[3,"Iter","","An iterator over the items of a `BTreeSet`.",N,N],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",N,N],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",N,N],[3,"Difference","","A lazy iterator producing elements in the difference of `BTreeSet`s.",N,N],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric difference of `BTreeSet`s.",N,N],[3,"Intersection","","A lazy iterator producing elements in the intersection of `BTreeSet`s.",N,N],[3,"Union","","A lazy iterator producing elements in the union of `BTreeSet`s.",N,N],[0,"sync","alloc","Thread-safe reference-counting pointers.",N,N],[3,"Arc","alloc::sync","A thread-safe reference-counting pointer. 'Arc' stands for 'Atomically Reference Counted'.",N,N],[3,"Weak","","`Weak` is a version of [`Arc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Arc`]`<T>>`.",N,N],[11,"new","","Constructs a new `Arc<T>`.",15,[[["t"]],["arc"]]],[11,"pinned","","",15,[[["t"]],["pin",["arc"]]]],[11,"try_unwrap","","Returns the contained value, if the `Arc` has exactly one strong reference.",15,[[["self"]],["result"]]],[11,"into_raw","","Consumes the `Arc`, returning the wrapped pointer.",15,N],[11,"from_raw","","Constructs an `Arc` from a raw pointer.",15,N],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",15,[[["self"]],["weak"]]],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",15,[[["self"]],["usize"]]],[11,"strong_count","","Gets the number of strong (`Arc`) pointers to this value.",15,[[["self"]],["usize"]]],[11,"ptr_eq","","Returns true if the two `Arc`s point to the same value (not just values that compare as equal).",15,[[["self"],["self"]],["bool"]]],[11,"make_mut","","Makes a mutable reference into the given `Arc`.",15,[[["self"]],["t"]]],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Arc` or [`Weak`][weak] pointers to the same value.",15,[[["self"]],["option"]]],[11,"downcast","","Attempt to downcast the `Arc<dyn Any + Send + Sync>` to a concrete type.",15,[[["self"]],["result",["arc"]]]],[11,"new","","Constructs a new `Weak<T>`, without allocating any memory. Calling [`upgrade`] on the return value always gives [`None`].",16,[[],["weak"]]],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Arc`], extending the lifetime of the value if successful.",16,[[["self"]],["option",["arc"]]]],[0,"rc","alloc","Single-threaded reference-counting pointers. 'Rc' stands for 'Reference Counted'.",N,N],[3,"Rc","alloc::rc","A single-threaded reference-counting pointer. 'Rc' stands for 'Reference Counted'.",N,N],[3,"Weak","","`Weak` is a version of [`Rc`] that holds a non-owning reference to the managed value. The value is accessed by calling [`upgrade`] on the `Weak` pointer, which returns an [`Option`]`<`[`Rc`]`<T>>`.",N,N],[11,"new","","Constructs a new `Rc<T>`.",17,[[["t"]],["rc"]]],[11,"pinned","","",17,[[["t"]],["pin",["rc"]]]],[11,"try_unwrap","","Returns the contained value, if the `Rc` has exactly one strong reference.",17,[[["self"]],["result"]]],[11,"into_raw","","Consumes the `Rc`, returning the wrapped pointer.",17,N],[11,"from_raw","","Constructs an `Rc` from a raw pointer.",17,N],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",17,[[["self"]],["weak"]]],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",17,[[["self"]],["usize"]]],[11,"strong_count","","Gets the number of strong (`Rc`) pointers to this value.",17,[[["self"]],["usize"]]],[11,"get_mut","","Returns a mutable reference to the inner value, if there are no other `Rc` or [`Weak`][weak] pointers to the same value.",17,[[["self"]],["option"]]],[11,"ptr_eq","","Returns true if the two `Rc`s point to the same value (not just values that compare as equal).",17,[[["self"],["self"]],["bool"]]],[11,"make_mut","","Makes a mutable reference into the given `Rc`.",17,[[["self"]],["t"]]],[11,"downcast","","Attempt to downcast the `Rc<Any>` to a concrete type.",17,[[["self"]],["result",["rc","rc"]]]],[11,"new","","Constructs a new `Weak<T>`, without allocating any memory. Calling [`upgrade`][Weak::upgrade] on the return value always gives [`None`].",18,[[],["weak"]]],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Rc`], extending the lifetime of the value if successful.",18,[[["self"]],["option",["rc"]]]],[0,"prelude","alloc","The alloc Prelude",N,N],[0,"borrow","","A module for working with borrowed data.",N,N],[8,"Borrow","alloc::borrow","A trait for borrowing data.",N,N],[10,"borrow","","Immutably borrows from an owned value.",19,[[["self"]],["borrowed"]]],[8,"BorrowMut","","A trait for mutably borrowing data.",N,N],[10,"borrow_mut","","Mutably borrows from an owned value.",20,[[["self"]],["borrowed"]]],[4,"Cow","","A clone-on-write smart pointer.",N,N],[13,"Borrowed","","Borrowed data.",21,N],[13,"Owned","","Owned data.",21,N],[8,"ToOwned","","A generalization of `Clone` to borrowed data.",N,N],[16,"Owned","","",22,N],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",22,N],[11,"clone_into","","Uses borrowed data to replace owned data, usually by cloning.",22,N],[11,"to_mut","","Acquires a mutable reference to the owned form of the data.",21,N],[11,"into_owned","","Extracts the owned data.",21,N],[0,"fmt","alloc","Utilities for formatting and printing `String`s.",N,N],[3,"Formatter","alloc::fmt","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",N,N],[6,"Result","","The type returned by formatter methods.",N,N],[8,"Write","","A collection of methods that are required to format a message into a stream.",N,N],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",23,[[["self"],["str"]],["result",["error"]]]],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",23,[[["self"],["char"]],["result",["error"]]]],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",23,[[["self"],["arguments"]],["result",["error"]]]],[8,"Binary","","`b` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",24,[[["self"],["formatter"]],["result",["error"]]]],[8,"Octal","","`o` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",25,[[["self"],["formatter"]],["result",["error"]]]],[8,"Debug","","`?` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",26,[[["self"],["formatter"]],["result",["error"]]]],[8,"Display","","Format trait for an empty format, `{}`.",N,N],[10,"fmt","","Formats the value using the given formatter.",27,[[["self"],["formatter"]],["result",["error"]]]],[8,"LowerHex","","`x` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",28,[[["self"],["formatter"]],["result",["error"]]]],[8,"Pointer","","`p` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",29,[[["self"],["formatter"]],["result",["error"]]]],[8,"UpperHex","","`X` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",30,[[["self"],["formatter"]],["result",["error"]]]],[8,"LowerExp","","`e` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",31,[[["self"],["formatter"]],["result",["error"]]]],[8,"UpperExp","","`E` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",32,[[["self"],["formatter"]],["result",["error"]]]],[3,"Error","","The error type which is returned from formatting a message into a stream.",N,N],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",N,[[["write"],["arguments"]],["result",["error"]]]],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",N,N],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",N,N],[4,"Alignment","","Possible alignments returned by `Formatter::align`",N,N],[13,"Left","","Indication that contents should be left-aligned.",33,N],[13,"Right","","Indication that contents should be right-aligned.",33,N],[13,"Center","","Indication that contents should be center-aligned.",33,N],[5,"format","","The `format` function takes an [`Arguments`] struct and returns the resulting formatted string.",N,[[["arguments"]],["string"]]],[0,"slice","alloc","A dynamically-sized view into a contiguous sequence, `[T]`.",N,N],[3,"Chunks","alloc::slice","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time), starting at the beginning of the slice.",N,N],[3,"Windows","","An iterator over overlapping subslices of length `size`.",N,N],[3,"Iter","","Immutable slice iterator",N,N],[3,"IterMut","","Mutable slice iterator.",N,N],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",N,N],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time), starting at the beginning of the slice.",N,N],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",N,N],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",N,N],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",N,N],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",N,N],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",N,N],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",N,N],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",N,N],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",N,N],[5,"from_raw_parts_mut","","Performs the same functionality as [`from_raw_parts`], except that a mutable slice is returned.",N,N],[5,"from_ref","","Converts a reference to T into a slice of length 1 (without copying).",N,N],[5,"from_mut","","Converts a reference to T into a slice of length 1 (without copying).",N,N],[8,"SliceIndex","","A helper trait used for indexing operations.",N,N],[16,"Output","","The output type returned by methods.",34,N],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",34,[[["self"],["t"]],["option"]]],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",34,[[["self"],["t"]],["option"]]],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",34,N],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",34,N],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",34,N],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",34,N],[3,"ChunksExact","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time), starting at the beginning of the slice.",N,N],[3,"ChunksExactMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time), starting at the beginning of the slice.",N,N],[3,"RChunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time), starting at the end of the slice.",N,N],[3,"RChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time), starting at the end of the slice.",N,N],[3,"RChunksExact","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time), starting at the end of the slice.",N,N],[3,"RChunksExactMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time), starting at the end of the slice.",N,N],[8,"SliceConcatExt","","An extension trait for concatenating slices",N,N],[16,"Output","","The resulting type after concatenation",35,N],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",35,N],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a given separator between each.",35,N],[10,"connect","","",35,N],[0,"str","alloc","Unicode string slices.",N,N],[8,"FromStr","alloc::str","A trait to abstract the idea of creating a new instance of a type from a string.",N,N],[16,"Err","","The associated error which can be returned from parsing.",36,N],[10,"from_str","","Parses a string `s` to return a value of this type.",36,[[["str"]],["result"]]],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",N,N],[3,"Lines","","An iterator over the lines of a string, as string slices.",N,N],[3,"LinesAny","","Created with the method [`lines_any`].",N,N],[3,"Split","","Created with the method [`split`].",N,N],[3,"RSplit","","Created with the method [`rsplit`].",N,N],[3,"SplitN","","Created with the method [`splitn`].",N,N],[3,"RSplitN","","Created with the method [`rsplitn`].",N,N],[3,"SplitTerminator","","Created with the method [`split_terminator`].",N,N],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",N,N],[3,"Matches","","Created with the method [`matches`].",N,N],[3,"RMatches","","Created with the method [`rmatches`].",N,N],[3,"MatchIndices","","Created with the method [`match_indices`].",N,N],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",N,N],[5,"from_utf8","","Converts a slice of bytes to a string slice.",N,N],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",N,N],[3,"Chars","","An iterator over the [`char`]s of a string slice.",N,N],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",N,N],[3,"Bytes","","An iterator over the bytes of a string slice.",N,N],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",N,N],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",N,N],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`] fails",N,N],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",N,N],[0,"pattern","","The string Pattern API.",N,N],[8,"Pattern","alloc::str::pattern","A string pattern.",N,N],[16,"Searcher","","Associated searcher for this pattern",37,N],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",37,N],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",37,[[["self"],["str"]],["bool"]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",37,[[["self"],["str"]],["bool"]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",37,[[["self"],["str"]],["bool"]]],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",N,N],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",38,N],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",38,N],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",38,N],[8,"Searcher","","A searcher for a string pattern.",N,N],[10,"haystack","","Getter for the underlying string to be searched in",39,[[["self"]],["str"]]],[10,"next","","Performs the next search step starting from the front.",39,[[["self"]],["searchstep"]]],[11,"next_match","","Find the next `Match` result. See `next()`",39,[[["self"]],["option"]]],[11,"next_reject","","Find the next `Reject` result. See `next()` and `next_match()`",39,[[["self"]],["option"]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",N,N],[10,"next_back","","Performs the next search step starting from the back.",40,[[["self"]],["searchstep"]]],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",40,[[["self"]],["option"]]],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",40,[[["self"]],["option"]]],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",N,N],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",N,N],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",N,N],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",N,N],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",N,N],[3,"EncodeUtf16","alloc::str","An iterator of [`u16`] over the string encoded as UTF-16.",N,N],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a string, separated by any amount of ASCII whitespace.",N,N],[5,"from_boxed_utf8_unchecked","","Converts a boxed slice of bytes to a boxed string slice without checking that the string contains valid UTF-8.",N,[[["box"]],["box",["str"]]]],[0,"string","alloc","A UTF-8 encoded, growable string.",N,N],[3,"String","alloc::string","A UTF-8 encoded, growable string.",N,N],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",N,N],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",N,N],[3,"Drain","","A draining iterator for `String`.",N,N],[4,"ParseError","","An error when parsing a `String`.",N,N],[8,"ToString","","A trait for converting a value to a `String`.",N,N],[10,"to_string","","Converts the given value to a `String`.",41,[[["self"]],["string"]]],[11,"new","","Creates a new empty `String`.",42,[[],["string"]]],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",42,[[["usize"]],["string"]]],[11,"from_utf8","","Converts a vector of bytes to a `String`.",42,[[["vec",["u8"]]],["result",["string","fromutf8error"]]]],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",42,N],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning [`Err`] if `v` contains any invalid data.",42,N],[11,"from_utf16_lossy","","Decode a UTF-16 encoded slice `v` into a `String`, replacing invalid data with [the replacement character (`U+FFFD`)][U+FFFD].",42,N],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",42,N],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the string contains valid UTF-8.",42,[[["vec",["u8"]]],["string"]]],[11,"into_bytes","","Converts a `String` into a byte vector.",42,[[["self"]],["vec",["u8"]]]],[11,"as_str","","Extracts a string slice containing the entire `String`.",42,[[["self"]],["str"]]],[11,"as_mut_str","","Converts a `String` into a mutable string slice.",42,[[["self"]],["str"]]],[11,"push_str","","Appends a given string slice onto the end of this `String`.",42,[[["self"],["str"]]]],[11,"capacity","","Returns this `String`'s capacity, in bytes.",42,[[["self"]],["usize"]]],[11,"reserve","","Ensures that this `String`'s capacity is at least `additional` bytes larger than its length.",42,[[["self"],["usize"]]]],[11,"reserve_exact","","Ensures that this `String`'s capacity is `additional` bytes larger than its length.",42,[[["self"],["usize"]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `String`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",42,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `String`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",42,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",42,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of this `String` with a lower bound.",42,[[["self"],["usize"]]]],[11,"push","","Appends the given [`char`] to the end of this `String`.",42,[[["self"],["char"]]]],[11,"as_bytes","","Returns a byte slice of this `String`'s contents.",42,N],[11,"truncate","","Shortens this `String` to the specified length.",42,[[["self"],["usize"]]]],[11,"pop","","Removes the last character from the string buffer and returns it.",42,[[["self"]],["option",["char"]]]],[11,"remove","","Removes a [`char`] from this `String` at a byte position and returns it.",42,[[["self"],["usize"]],["char"]]],[11,"retain","","Retains only the characters specified by the predicate.",42,[[["self"],["f"]]]],[11,"insert","","Inserts a character into this `String` at a byte position.",42,[[["self"],["usize"],["char"]]]],[11,"insert_str","","Inserts a string slice into this `String` at a byte position.",42,[[["self"],["usize"],["str"]]]],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",42,[[["self"]],["vec"]]],[11,"len","","Returns the length of this `String`, in bytes.",42,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",42,[[["self"]],["bool"]]],[11,"split_off","","Splits the string into two at the given index.",42,[[["self"],["usize"]],["string"]]],[11,"clear","","Truncates this `String`, removing all contents.",42,[[["self"]]]],[11,"drain","","Creates a draining iterator that removes the specified range in the `String` and yields the removed `chars`.",42,[[["self"],["r"]],["drain"]]],[11,"replace_range","","Removes the specified range in the string, and replaces it with the given string. The given string doesn't need to be the same length as the range.",42,[[["self"],["r"],["str"]]]],[11,"into_boxed_str","","Converts this `String` into a [`Box`]`<`[`str`]`>`.",42,[[["self"]],["box",["str"]]]],[11,"as_bytes","","Returns a slice of [`u8`]s bytes that were attempted to convert to a `String`.",43,N],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",43,[[["self"]],["vec",["u8"]]]],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",43,[[["self"]],["utf8error"]]],[0,"vec","alloc","A contiguous growable array type with heap-allocated contents, written `Vec<T>`.",N,N],[3,"Vec","alloc::vec","A contiguous growable array type, written `Vec<T>` but pronounced 'vector'.",N,N],[3,"IntoIter","","An iterator that moves out of a vector.",N,N],[3,"Drain","","A draining iterator for `Vec<T>`.",N,N],[3,"Splice","","A splicing iterator for `Vec`.",N,N],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",N,N],[11,"new","","Constructs a new, empty `Vec<T>`.",44,[[],["vec"]]],[11,"with_capacity","","Constructs a new, empty `Vec<T>` with the specified capacity.",44,[[["usize"]],["vec"]]],[11,"from_raw_parts","","Creates a `Vec<T>` directly from the raw components of another vector.",44,N],[11,"capacity","","Returns the number of elements the vector can hold without reallocating.",44,[[["self"]],["usize"]]],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",44,[[["self"],["usize"]]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",44,[[["self"],["usize"]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more elements to be inserted in the given `Vec<T>`. The collection may reserve more space to avoid frequent reallocations. After calling `reserve`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if capacity is already sufficient.",44,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly `additional` more elements to be inserted in the given `Vec<T>`. After calling `reserve_exact`, capacity will be greater than or equal to `self.len() + additional`. Does nothing if the capacity is already sufficient.",44,[[["self"],["usize"]],["result",["collectionallocerr"]]]],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",44,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of the vector with a lower bound.",44,[[["self"],["usize"]]]],[11,"into_boxed_slice","","Converts the vector into [`Box<[T]>`][owned slice].",44,[[["self"]],["box"]]],[11,"truncate","","Shortens the vector, keeping the first `len` elements and dropping the rest.",44,[[["self"],["usize"]]]],[11,"as_slice","","Extracts a slice containing the entire vector.",44,N],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",44,N],[11,"set_len","","Sets the length of a vector.",44,[[["self"],["usize"]]]],[11,"swap_remove","","Removes an element from the vector and returns it.",44,[[["self"],["usize"]],["t"]]],[11,"insert","","Inserts an element at position `index` within the vector, shifting all elements after it to the right.",44,[[["self"],["usize"],["t"]]]],[11,"remove","","Removes and returns the element at position `index` within the vector, shifting all elements after it to the left.",44,[[["self"],["usize"]],["t"]]],[11,"retain","","Retains only the elements specified by the predicate.",44,[[["self"],["f"]]]],[11,"dedup_by_key","","Removes all but the first of consecutive elements in the vector that resolve to the same key.",44,[[["self"],["f"]]]],[11,"dedup_by","","Removes all but the first of consecutive elements in the vector satisfying a given equality relation.",44,[[["self"],["f"]]]],[11,"push","","Appends an element to the back of a collection.",44,[[["self"],["t"]]]],[11,"pop","","Removes the last element from a vector and returns it, or [`None`] if it is empty.",44,[[["self"]],["option"]]],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",44,[[["self"],["self"]]]],[11,"drain","","Creates a draining iterator that removes the specified range in the vector and yields the removed items.",44,[[["self"],["r"]],["drain"]]],[11,"clear","","Clears the vector, removing all values.",44,[[["self"]]]],[11,"len","","Returns the number of elements in the vector, also referred to as its 'length'.",44,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the vector contains no elements.",44,[[["self"]],["bool"]]],[11,"split_off","","Splits the collection into two at the given index.",44,[[["self"],["usize"]],["self"]]],[11,"resize_with","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",44,[[["self"],["usize"],["f"]]]],[11,"resize","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",44,[[["self"],["usize"],["t"]]]],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",44,N],[11,"resize_default","","Resizes the `Vec` in-place so that `len` is equal to `new_len`.",44,[[["self"],["usize"]]]],[11,"dedup","","Removes consecutive repeated elements in the vector according to the [`PartialEq`] trait implementation.",44,[[["self"]]]],[11,"remove_item","","Removes the first instance of `item` from the vector if the item exists.",44,[[["self"],["t"]],["option"]]],[11,"splice","","Creates a splicing iterator that replaces the specified range in the vector with the given `replace_with` iterator and yields the removed items. `replace_with` does not need to be the same length as `range`.",44,[[["self"],["r"],["i"]],["splice"]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if an element should be removed.",44,[[["self"],["f"]],["drainfilter"]]],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",45,N],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable slice.",45,N],[14,"vec","alloc","Creates a [`Vec`] containing the arguments.",N,N],[14,"format","","Creates a `String` using interpolation of runtime expressions.",N,N],[11,"try_from","alloc::alloc","",0,[[["u"]],["result"]]],[11,"from","","",0,[[["t"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"to_owned","","",46,[[["self"]],["t"]]],[11,"clone_into","","",46,N],[11,"try_from","","",46,[[["u"]],["result"]]],[11,"from","","",46,[[["t"]],["t"]]],[11,"try_into","","",46,[[["self"]],["result"]]],[11,"into","","",46,[[["self"]],["u"]]],[11,"borrow","","",46,[[["self"]],["t"]]],[11,"borrow_mut","","",46,[[["self"]],["t"]]],[11,"get_type_id","","",46,[[["self"]],["typeid"]]],[11,"to_owned","","",47,[[["self"]],["t"]]],[11,"clone_into","","",47,N],[11,"to_string","","",47,[[["self"]],["string"]]],[11,"try_from","","",47,[[["u"]],["result"]]],[11,"from","","",47,[[["t"]],["t"]]],[11,"try_into","","",47,[[["self"]],["result"]]],[11,"into","","",47,[[["self"]],["u"]]],[11,"borrow","","",47,[[["self"]],["t"]]],[11,"borrow_mut","","",47,[[["self"]],["t"]]],[11,"get_type_id","","",47,[[["self"]],["typeid"]]],[11,"to_owned","","",48,[[["self"]],["t"]]],[11,"clone_into","","",48,N],[11,"to_string","","",48,[[["self"]],["string"]]],[11,"try_from","","",48,[[["u"]],["result"]]],[11,"from","","",48,[[["t"]],["t"]]],[11,"try_into","","",48,[[["self"]],["result"]]],[11,"into","","",48,[[["self"]],["u"]]],[11,"borrow","","",48,[[["self"]],["t"]]],[11,"borrow_mut","","",48,[[["self"]],["t"]]],[11,"get_type_id","","",48,[[["self"]],["typeid"]]],[11,"to_owned","","",49,[[["self"]],["t"]]],[11,"clone_into","","",49,N],[11,"to_string","","",49,[[["self"]],["string"]]],[11,"try_from","","",49,[[["u"]],["result"]]],[11,"from","","",49,[[["t"]],["t"]]],[11,"try_into","","",49,[[["self"]],["result"]]],[11,"into","","",49,[[["self"]],["u"]]],[11,"borrow","","",49,[[["self"]],["t"]]],[11,"borrow_mut","","",49,[[["self"]],["t"]]],[11,"get_type_id","","",49,[[["self"]],["typeid"]]],[11,"to_owned","","",50,[[["self"]],["t"]]],[11,"clone_into","","",50,N],[11,"try_from","","",50,[[["u"]],["result"]]],[11,"from","","",50,[[["t"]],["t"]]],[11,"try_into","","",50,[[["self"]],["result"]]],[11,"into","","",50,[[["self"]],["u"]]],[11,"borrow","","",50,[[["self"]],["t"]]],[11,"borrow_mut","","",50,[[["self"]],["t"]]],[11,"get_type_id","","",50,[[["self"]],["typeid"]]],[11,"to_owned","alloc::task","",51,[[["self"]],["t"]]],[11,"clone_into","","",51,N],[11,"try_from","","",51,[[["u"]],["result"]]],[11,"from","","",51,[[["t"]],["t"]]],[11,"try_into","","",51,[[["self"]],["result"]]],[11,"into","","",51,[[["self"]],["u"]]],[11,"borrow","","",51,[[["self"]],["t"]]],[11,"borrow_mut","","",51,[[["self"]],["t"]]],[11,"get_type_id","","",51,[[["self"]],["typeid"]]],[11,"to_owned","","",4,[[["self"]],["t"]]],[11,"clone_into","","",4,N],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"from","","",4,[[["t"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"to_owned","","",52,[[["self"]],["t"]]],[11,"clone_into","","",52,N],[11,"try_from","","",52,[[["u"]],["result"]]],[11,"from","","",52,[[["t"]],["t"]]],[11,"try_into","","",52,[[["self"]],["result"]]],[11,"into","","",52,[[["self"]],["u"]]],[11,"borrow","","",52,[[["self"]],["t"]]],[11,"borrow_mut","","",52,[[["self"]],["t"]]],[11,"get_type_id","","",52,[[["self"]],["typeid"]]],[11,"call_box","alloc::boxed","",7,N],[11,"to_owned","","",7,[[["self"]],["t"]]],[11,"clone_into","","",7,N],[11,"to_string","","",7,[[["self"]],["string"]]],[11,"into_iter","","",7,[[["self"]],["i"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"from","","",7,[[["t"]],["t"]]],[11,"try_into","","",7,[[["self"]],["result"]]],[11,"into","","",7,[[["self"]],["u"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"get_type_id","","",7,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections","",8,[[["self"]],["t"]]],[11,"clone_into","","",8,N],[11,"try_from","","",8,[[["u"]],["result"]]],[11,"from","","",8,[[["t"]],["t"]]],[11,"try_into","","",8,[[["self"]],["result"]]],[11,"into","","",8,[[["self"]],["u"]]],[11,"borrow","","",8,[[["self"]],["t"]]],[11,"borrow_mut","","",8,[[["self"]],["t"]]],[11,"get_type_id","","",8,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections::binary_heap","",10,[[["self"]],["t"]]],[11,"clone_into","","",10,N],[11,"into_iter","","",10,[[["self"]],["i"]]],[11,"try_from","","",10,[[["u"]],["result"]]],[11,"from","","",10,[[["t"]],["t"]]],[11,"try_into","","",10,[[["self"]],["result"]]],[11,"into","","",10,[[["self"]],["u"]]],[11,"borrow","","",10,[[["self"]],["t"]]],[11,"borrow_mut","","",10,[[["self"]],["t"]]],[11,"get_type_id","","",10,[[["self"]],["typeid"]]],[11,"try_from","","",9,[[["u"]],["result"]]],[11,"from","","",9,[[["t"]],["t"]]],[11,"try_into","","",9,[[["self"]],["result"]]],[11,"into","","",9,[[["self"]],["u"]]],[11,"borrow","","",9,[[["self"]],["t"]]],[11,"borrow_mut","","",9,[[["self"]],["t"]]],[11,"get_type_id","","",9,[[["self"]],["typeid"]]],[11,"to_owned","","",53,[[["self"]],["t"]]],[11,"clone_into","","",53,N],[11,"into_iter","","",53,[[["self"]],["i"]]],[11,"try_from","","",53,[[["u"]],["result"]]],[11,"from","","",53,[[["t"]],["t"]]],[11,"try_into","","",53,[[["self"]],["result"]]],[11,"into","","",53,[[["self"]],["u"]]],[11,"borrow","","",53,[[["self"]],["t"]]],[11,"borrow_mut","","",53,[[["self"]],["t"]]],[11,"get_type_id","","",53,[[["self"]],["typeid"]]],[11,"to_owned","","",54,[[["self"]],["t"]]],[11,"clone_into","","",54,N],[11,"into_iter","","",54,[[["self"]],["i"]]],[11,"try_from","","",54,[[["u"]],["result"]]],[11,"from","","",54,[[["t"]],["t"]]],[11,"try_into","","",54,[[["self"]],["result"]]],[11,"into","","",54,[[["self"]],["u"]]],[11,"borrow","","",54,[[["self"]],["t"]]],[11,"borrow_mut","","",54,[[["self"]],["t"]]],[11,"get_type_id","","",54,[[["self"]],["typeid"]]],[11,"into_iter","","",55,[[["self"]],["i"]]],[11,"try_from","","",55,[[["u"]],["result"]]],[11,"from","","",55,[[["t"]],["t"]]],[11,"try_into","","",55,[[["self"]],["result"]]],[11,"into","","",55,[[["self"]],["u"]]],[11,"borrow","","",55,[[["self"]],["t"]]],[11,"borrow_mut","","",55,[[["self"]],["t"]]],[11,"get_type_id","","",55,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections::btree_map","",56,[[["self"]],["t"]]],[11,"clone_into","","",56,N],[11,"into_iter","","",56,[[["self"]],["i"]]],[11,"try_from","","",56,[[["u"]],["result"]]],[11,"from","","",56,[[["t"]],["t"]]],[11,"try_into","","",56,[[["self"]],["result"]]],[11,"into","","",56,[[["self"]],["u"]]],[11,"borrow","","",56,[[["self"]],["t"]]],[11,"borrow_mut","","",56,[[["self"]],["t"]]],[11,"get_type_id","","",56,[[["self"]],["typeid"]]],[11,"to_owned","","",57,[[["self"]],["t"]]],[11,"clone_into","","",57,N],[11,"into_iter","","",57,[[["self"]],["i"]]],[11,"try_from","","",57,[[["u"]],["result"]]],[11,"from","","",57,[[["t"]],["t"]]],[11,"try_into","","",57,[[["self"]],["result"]]],[11,"into","","",57,[[["self"]],["u"]]],[11,"borrow","","",57,[[["self"]],["t"]]],[11,"borrow_mut","","",57,[[["self"]],["t"]]],[11,"get_type_id","","",57,[[["self"]],["typeid"]]],[11,"into_iter","","",58,[[["self"]],["i"]]],[11,"try_from","","",58,[[["u"]],["result"]]],[11,"from","","",58,[[["t"]],["t"]]],[11,"try_into","","",58,[[["self"]],["result"]]],[11,"into","","",58,[[["self"]],["u"]]],[11,"borrow","","",58,[[["self"]],["t"]]],[11,"borrow_mut","","",58,[[["self"]],["t"]]],[11,"get_type_id","","",58,[[["self"]],["typeid"]]],[11,"into_iter","","",59,[[["self"]],["i"]]],[11,"try_from","","",59,[[["u"]],["result"]]],[11,"from","","",59,[[["t"]],["t"]]],[11,"try_into","","",59,[[["self"]],["result"]]],[11,"into","","",59,[[["self"]],["u"]]],[11,"borrow","","",59,[[["self"]],["t"]]],[11,"borrow_mut","","",59,[[["self"]],["t"]]],[11,"get_type_id","","",59,[[["self"]],["typeid"]]],[11,"to_owned","","",60,[[["self"]],["t"]]],[11,"clone_into","","",60,N],[11,"into_iter","","",60,[[["self"]],["i"]]],[11,"try_from","","",60,[[["u"]],["result"]]],[11,"from","","",60,[[["t"]],["t"]]],[11,"try_into","","",60,[[["self"]],["result"]]],[11,"into","","",60,[[["self"]],["u"]]],[11,"borrow","","",60,[[["self"]],["t"]]],[11,"borrow_mut","","",60,[[["self"]],["t"]]],[11,"get_type_id","","",60,[[["self"]],["typeid"]]],[11,"to_owned","","",61,[[["self"]],["t"]]],[11,"clone_into","","",61,N],[11,"into_iter","","",61,[[["self"]],["i"]]],[11,"try_from","","",61,[[["u"]],["result"]]],[11,"from","","",61,[[["t"]],["t"]]],[11,"try_into","","",61,[[["self"]],["result"]]],[11,"into","","",61,[[["self"]],["u"]]],[11,"borrow","","",61,[[["self"]],["t"]]],[11,"borrow_mut","","",61,[[["self"]],["t"]]],[11,"get_type_id","","",61,[[["self"]],["typeid"]]],[11,"into_iter","","",62,[[["self"]],["i"]]],[11,"try_from","","",62,[[["u"]],["result"]]],[11,"from","","",62,[[["t"]],["t"]]],[11,"try_into","","",62,[[["self"]],["result"]]],[11,"into","","",62,[[["self"]],["u"]]],[11,"borrow","","",62,[[["self"]],["t"]]],[11,"borrow_mut","","",62,[[["self"]],["t"]]],[11,"get_type_id","","",62,[[["self"]],["typeid"]]],[11,"to_owned","","",63,[[["self"]],["t"]]],[11,"clone_into","","",63,N],[11,"into_iter","","",63,[[["self"]],["i"]]],[11,"try_from","","",63,[[["u"]],["result"]]],[11,"from","","",63,[[["t"]],["t"]]],[11,"try_into","","",63,[[["self"]],["result"]]],[11,"into","","",63,[[["self"]],["u"]]],[11,"borrow","","",63,[[["self"]],["t"]]],[11,"borrow_mut","","",63,[[["self"]],["t"]]],[11,"get_type_id","","",63,[[["self"]],["typeid"]]],[11,"into_iter","","",64,[[["self"]],["i"]]],[11,"try_from","","",64,[[["u"]],["result"]]],[11,"from","","",64,[[["t"]],["t"]]],[11,"try_into","","",64,[[["self"]],["result"]]],[11,"into","","",64,[[["self"]],["u"]]],[11,"borrow","","",64,[[["self"]],["t"]]],[11,"borrow_mut","","",64,[[["self"]],["t"]]],[11,"get_type_id","","",64,[[["self"]],["typeid"]]],[11,"try_from","","",65,[[["u"]],["result"]]],[11,"from","","",65,[[["t"]],["t"]]],[11,"try_into","","",65,[[["self"]],["result"]]],[11,"into","","",65,[[["self"]],["u"]]],[11,"borrow","","",65,[[["self"]],["t"]]],[11,"borrow_mut","","",65,[[["self"]],["t"]]],[11,"get_type_id","","",65,[[["self"]],["typeid"]]],[11,"try_from","","",66,[[["u"]],["result"]]],[11,"from","","",66,[[["t"]],["t"]]],[11,"try_into","","",66,[[["self"]],["result"]]],[11,"into","","",66,[[["self"]],["u"]]],[11,"borrow","","",66,[[["self"]],["t"]]],[11,"borrow_mut","","",66,[[["self"]],["t"]]],[11,"get_type_id","","",66,[[["self"]],["typeid"]]],[11,"try_from","","",14,[[["u"]],["result"]]],[11,"from","","",14,[[["t"]],["t"]]],[11,"try_into","","",14,[[["self"]],["result"]]],[11,"into","","",14,[[["self"]],["u"]]],[11,"borrow","","",14,[[["self"]],["t"]]],[11,"borrow_mut","","",14,[[["self"]],["t"]]],[11,"get_type_id","","",14,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections::btree_set","",67,[[["self"]],["t"]]],[11,"clone_into","","",67,N],[11,"into_iter","","",67,[[["self"]],["i"]]],[11,"try_from","","",67,[[["u"]],["result"]]],[11,"from","","",67,[[["t"]],["t"]]],[11,"try_into","","",67,[[["self"]],["result"]]],[11,"into","","",67,[[["self"]],["u"]]],[11,"borrow","","",67,[[["self"]],["t"]]],[11,"borrow_mut","","",67,[[["self"]],["t"]]],[11,"get_type_id","","",67,[[["self"]],["typeid"]]],[11,"to_owned","","",68,[[["self"]],["t"]]],[11,"clone_into","","",68,N],[11,"into_iter","","",68,[[["self"]],["i"]]],[11,"try_from","","",68,[[["u"]],["result"]]],[11,"from","","",68,[[["t"]],["t"]]],[11,"try_into","","",68,[[["self"]],["result"]]],[11,"into","","",68,[[["self"]],["u"]]],[11,"borrow","","",68,[[["self"]],["t"]]],[11,"borrow_mut","","",68,[[["self"]],["t"]]],[11,"get_type_id","","",68,[[["self"]],["typeid"]]],[11,"into_iter","","",69,[[["self"]],["i"]]],[11,"try_from","","",69,[[["u"]],["result"]]],[11,"from","","",69,[[["t"]],["t"]]],[11,"try_into","","",69,[[["self"]],["result"]]],[11,"into","","",69,[[["self"]],["u"]]],[11,"borrow","","",69,[[["self"]],["t"]]],[11,"borrow_mut","","",69,[[["self"]],["t"]]],[11,"get_type_id","","",69,[[["self"]],["typeid"]]],[11,"to_owned","","",70,[[["self"]],["t"]]],[11,"clone_into","","",70,N],[11,"into_iter","","",70,[[["self"]],["i"]]],[11,"try_from","","",70,[[["u"]],["result"]]],[11,"from","","",70,[[["t"]],["t"]]],[11,"try_into","","",70,[[["self"]],["result"]]],[11,"into","","",70,[[["self"]],["u"]]],[11,"borrow","","",70,[[["self"]],["t"]]],[11,"borrow_mut","","",70,[[["self"]],["t"]]],[11,"get_type_id","","",70,[[["self"]],["typeid"]]],[11,"to_owned","","",71,[[["self"]],["t"]]],[11,"clone_into","","",71,N],[11,"into_iter","","",71,[[["self"]],["i"]]],[11,"try_from","","",71,[[["u"]],["result"]]],[11,"from","","",71,[[["t"]],["t"]]],[11,"try_into","","",71,[[["self"]],["result"]]],[11,"into","","",71,[[["self"]],["u"]]],[11,"borrow","","",71,[[["self"]],["t"]]],[11,"borrow_mut","","",71,[[["self"]],["t"]]],[11,"get_type_id","","",71,[[["self"]],["typeid"]]],[11,"to_owned","","",72,[[["self"]],["t"]]],[11,"clone_into","","",72,N],[11,"into_iter","","",72,[[["self"]],["i"]]],[11,"try_from","","",72,[[["u"]],["result"]]],[11,"from","","",72,[[["t"]],["t"]]],[11,"try_into","","",72,[[["self"]],["result"]]],[11,"into","","",72,[[["self"]],["u"]]],[11,"borrow","","",72,[[["self"]],["t"]]],[11,"borrow_mut","","",72,[[["self"]],["t"]]],[11,"get_type_id","","",72,[[["self"]],["typeid"]]],[11,"to_owned","","",73,[[["self"]],["t"]]],[11,"clone_into","","",73,N],[11,"into_iter","","",73,[[["self"]],["i"]]],[11,"try_from","","",73,[[["u"]],["result"]]],[11,"from","","",73,[[["t"]],["t"]]],[11,"try_into","","",73,[[["self"]],["result"]]],[11,"into","","",73,[[["self"]],["u"]]],[11,"borrow","","",73,[[["self"]],["t"]]],[11,"borrow_mut","","",73,[[["self"]],["t"]]],[11,"get_type_id","","",73,[[["self"]],["typeid"]]],[11,"to_owned","","",74,[[["self"]],["t"]]],[11,"clone_into","","",74,N],[11,"into_iter","","",74,[[["self"]],["i"]]],[11,"try_from","","",74,[[["u"]],["result"]]],[11,"from","","",74,[[["t"]],["t"]]],[11,"try_into","","",74,[[["self"]],["result"]]],[11,"into","","",74,[[["self"]],["u"]]],[11,"borrow","","",74,[[["self"]],["t"]]],[11,"borrow_mut","","",74,[[["self"]],["t"]]],[11,"get_type_id","","",74,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections::linked_list","",11,[[["self"]],["t"]]],[11,"clone_into","","",11,N],[11,"into_iter","","",11,[[["self"]],["i"]]],[11,"try_from","","",11,[[["u"]],["result"]]],[11,"from","","",11,[[["t"]],["t"]]],[11,"try_into","","",11,[[["self"]],["result"]]],[11,"into","","",11,[[["self"]],["u"]]],[11,"borrow","","",11,[[["self"]],["t"]]],[11,"borrow_mut","","",11,[[["self"]],["t"]]],[11,"get_type_id","","",11,[[["self"]],["typeid"]]],[11,"to_owned","","",75,[[["self"]],["t"]]],[11,"clone_into","","",75,N],[11,"into_iter","","",75,[[["self"]],["i"]]],[11,"try_from","","",75,[[["u"]],["result"]]],[11,"from","","",75,[[["t"]],["t"]]],[11,"try_into","","",75,[[["self"]],["result"]]],[11,"into","","",75,[[["self"]],["u"]]],[11,"borrow","","",75,[[["self"]],["t"]]],[11,"borrow_mut","","",75,[[["self"]],["t"]]],[11,"get_type_id","","",75,[[["self"]],["typeid"]]],[11,"into_iter","","",12,[[["self"]],["i"]]],[11,"try_from","","",12,[[["u"]],["result"]]],[11,"from","","",12,[[["t"]],["t"]]],[11,"try_into","","",12,[[["self"]],["result"]]],[11,"into","","",12,[[["self"]],["u"]]],[11,"borrow","","",12,[[["self"]],["t"]]],[11,"borrow_mut","","",12,[[["self"]],["t"]]],[11,"get_type_id","","",12,[[["self"]],["typeid"]]],[11,"to_owned","","",76,[[["self"]],["t"]]],[11,"clone_into","","",76,N],[11,"into_iter","","",76,[[["self"]],["i"]]],[11,"try_from","","",76,[[["u"]],["result"]]],[11,"from","","",76,[[["t"]],["t"]]],[11,"try_into","","",76,[[["self"]],["result"]]],[11,"into","","",76,[[["self"]],["u"]]],[11,"borrow","","",76,[[["self"]],["t"]]],[11,"borrow_mut","","",76,[[["self"]],["t"]]],[11,"get_type_id","","",76,[[["self"]],["typeid"]]],[11,"into_iter","","",77,[[["self"]],["i"]]],[11,"try_from","","",77,[[["u"]],["result"]]],[11,"from","","",77,[[["t"]],["t"]]],[11,"try_into","","",77,[[["self"]],["result"]]],[11,"into","","",77,[[["self"]],["u"]]],[11,"borrow","","",77,[[["self"]],["t"]]],[11,"borrow_mut","","",77,[[["self"]],["t"]]],[11,"get_type_id","","",77,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections::vec_deque","",13,[[["self"]],["t"]]],[11,"clone_into","","",13,N],[11,"into_iter","","",13,[[["self"]],["i"]]],[11,"try_from","","",13,[[["u"]],["result"]]],[11,"from","","",13,[[["t"]],["t"]]],[11,"try_into","","",13,[[["self"]],["result"]]],[11,"into","","",13,[[["self"]],["u"]]],[11,"borrow","","",13,[[["self"]],["t"]]],[11,"borrow_mut","","",13,[[["self"]],["t"]]],[11,"get_type_id","","",13,[[["self"]],["typeid"]]],[11,"to_owned","","",78,[[["self"]],["t"]]],[11,"clone_into","","",78,N],[11,"into_iter","","",78,[[["self"]],["i"]]],[11,"try_from","","",78,[[["u"]],["result"]]],[11,"from","","",78,[[["t"]],["t"]]],[11,"try_into","","",78,[[["self"]],["result"]]],[11,"into","","",78,[[["self"]],["u"]]],[11,"borrow","","",78,[[["self"]],["t"]]],[11,"borrow_mut","","",78,[[["self"]],["t"]]],[11,"get_type_id","","",78,[[["self"]],["typeid"]]],[11,"into_iter","","",79,[[["self"]],["i"]]],[11,"try_from","","",79,[[["u"]],["result"]]],[11,"from","","",79,[[["t"]],["t"]]],[11,"try_into","","",79,[[["self"]],["result"]]],[11,"into","","",79,[[["self"]],["u"]]],[11,"borrow","","",79,[[["self"]],["t"]]],[11,"borrow_mut","","",79,[[["self"]],["t"]]],[11,"get_type_id","","",79,[[["self"]],["typeid"]]],[11,"to_owned","","",80,[[["self"]],["t"]]],[11,"clone_into","","",80,N],[11,"into_iter","","",80,[[["self"]],["i"]]],[11,"try_from","","",80,[[["u"]],["result"]]],[11,"from","","",80,[[["t"]],["t"]]],[11,"try_into","","",80,[[["self"]],["result"]]],[11,"into","","",80,[[["self"]],["u"]]],[11,"borrow","","",80,[[["self"]],["t"]]],[11,"borrow_mut","","",80,[[["self"]],["t"]]],[11,"get_type_id","","",80,[[["self"]],["typeid"]]],[11,"into_iter","","",81,[[["self"]],["i"]]],[11,"try_from","","",81,[[["u"]],["result"]]],[11,"from","","",81,[[["t"]],["t"]]],[11,"try_into","","",81,[[["self"]],["result"]]],[11,"into","","",81,[[["self"]],["u"]]],[11,"borrow","","",81,[[["self"]],["t"]]],[11,"borrow_mut","","",81,[[["self"]],["t"]]],[11,"get_type_id","","",81,[[["self"]],["typeid"]]],[11,"to_owned","alloc::sync","",15,[[["self"]],["t"]]],[11,"clone_into","","",15,N],[11,"to_string","","",15,[[["self"]],["string"]]],[11,"try_from","","",15,[[["u"]],["result"]]],[11,"from","","",15,[[["t"]],["t"]]],[11,"try_into","","",15,[[["self"]],["result"]]],[11,"into","","",15,[[["self"]],["u"]]],[11,"borrow","","",15,[[["self"]],["t"]]],[11,"borrow_mut","","",15,[[["self"]],["t"]]],[11,"get_type_id","","",15,[[["self"]],["typeid"]]],[11,"to_owned","","",16,[[["self"]],["t"]]],[11,"clone_into","","",16,N],[11,"try_from","","",16,[[["u"]],["result"]]],[11,"from","","",16,[[["t"]],["t"]]],[11,"try_into","","",16,[[["self"]],["result"]]],[11,"into","","",16,[[["self"]],["u"]]],[11,"borrow","","",16,[[["self"]],["t"]]],[11,"borrow_mut","","",16,[[["self"]],["t"]]],[11,"get_type_id","","",16,[[["self"]],["typeid"]]],[11,"to_owned","alloc::rc","",17,[[["self"]],["t"]]],[11,"clone_into","","",17,N],[11,"to_string","","",17,[[["self"]],["string"]]],[11,"try_from","","",17,[[["u"]],["result"]]],[11,"from","","",17,[[["t"]],["t"]]],[11,"try_into","","",17,[[["self"]],["result"]]],[11,"into","","",17,[[["self"]],["u"]]],[11,"borrow","","",17,[[["self"]],["t"]]],[11,"borrow_mut","","",17,[[["self"]],["t"]]],[11,"get_type_id","","",17,[[["self"]],["typeid"]]],[11,"to_owned","","",18,[[["self"]],["t"]]],[11,"clone_into","","",18,N],[11,"try_from","","",18,[[["u"]],["result"]]],[11,"from","","",18,[[["t"]],["t"]]],[11,"try_into","","",18,[[["self"]],["result"]]],[11,"into","","",18,[[["self"]],["u"]]],[11,"borrow","","",18,[[["self"]],["t"]]],[11,"borrow_mut","","",18,[[["self"]],["t"]]],[11,"get_type_id","","",18,[[["self"]],["typeid"]]],[11,"to_owned","alloc::borrow","",21,[[["self"]],["t"]]],[11,"clone_into","","",21,N],[11,"to_string","","",21,[[["self"]],["string"]]],[11,"try_from","","",21,[[["u"]],["result"]]],[11,"from","","",21,[[["t"]],["t"]]],[11,"try_into","","",21,[[["self"]],["result"]]],[11,"into","","",21,[[["self"]],["u"]]],[11,"borrow","","",21,[[["self"]],["t"]]],[11,"borrow_mut","","",21,[[["self"]],["t"]]],[11,"get_type_id","","",21,[[["self"]],["typeid"]]],[11,"try_from","alloc::fmt","",82,[[["u"]],["result"]]],[11,"from","","",82,[[["t"]],["t"]]],[11,"try_into","","",82,[[["self"]],["result"]]],[11,"into","","",82,[[["self"]],["u"]]],[11,"borrow","","",82,[[["self"]],["t"]]],[11,"borrow_mut","","",82,[[["self"]],["t"]]],[11,"get_type_id","","",82,[[["self"]],["typeid"]]],[11,"to_owned","","",83,[[["self"]],["t"]]],[11,"clone_into","","",83,N],[11,"to_string","","",83,[[["self"]],["string"]]],[11,"try_from","","",83,[[["u"]],["result"]]],[11,"from","","",83,[[["t"]],["t"]]],[11,"try_into","","",83,[[["self"]],["result"]]],[11,"into","","",83,[[["self"]],["u"]]],[11,"borrow","","",83,[[["self"]],["t"]]],[11,"borrow_mut","","",83,[[["self"]],["t"]]],[11,"get_type_id","","",83,[[["self"]],["typeid"]]],[11,"to_owned","","",84,[[["self"]],["t"]]],[11,"clone_into","","",84,N],[11,"to_string","","",84,[[["self"]],["string"]]],[11,"try_from","","",84,[[["u"]],["result"]]],[11,"from","","",84,[[["t"]],["t"]]],[11,"try_into","","",84,[[["self"]],["result"]]],[11,"into","","",84,[[["self"]],["u"]]],[11,"borrow","","",84,[[["self"]],["t"]]],[11,"borrow_mut","","",84,[[["self"]],["t"]]],[11,"get_type_id","","",84,[[["self"]],["typeid"]]],[11,"try_from","","",85,[[["u"]],["result"]]],[11,"from","","",85,[[["t"]],["t"]]],[11,"try_into","","",85,[[["self"]],["result"]]],[11,"into","","",85,[[["self"]],["u"]]],[11,"borrow","","",85,[[["self"]],["t"]]],[11,"borrow_mut","","",85,[[["self"]],["t"]]],[11,"get_type_id","","",85,[[["self"]],["typeid"]]],[11,"try_from","","",86,[[["u"]],["result"]]],[11,"from","","",86,[[["t"]],["t"]]],[11,"try_into","","",86,[[["self"]],["result"]]],[11,"into","","",86,[[["self"]],["u"]]],[11,"borrow","","",86,[[["self"]],["t"]]],[11,"borrow_mut","","",86,[[["self"]],["t"]]],[11,"get_type_id","","",86,[[["self"]],["typeid"]]],[11,"try_from","","",87,[[["u"]],["result"]]],[11,"from","","",87,[[["t"]],["t"]]],[11,"try_into","","",87,[[["self"]],["result"]]],[11,"into","","",87,[[["self"]],["u"]]],[11,"borrow","","",87,[[["self"]],["t"]]],[11,"borrow_mut","","",87,[[["self"]],["t"]]],[11,"get_type_id","","",87,[[["self"]],["typeid"]]],[11,"try_from","","",88,[[["u"]],["result"]]],[11,"from","","",88,[[["t"]],["t"]]],[11,"try_into","","",88,[[["self"]],["result"]]],[11,"into","","",88,[[["self"]],["u"]]],[11,"borrow","","",88,[[["self"]],["t"]]],[11,"borrow_mut","","",88,[[["self"]],["t"]]],[11,"get_type_id","","",88,[[["self"]],["typeid"]]],[11,"try_from","","",89,[[["u"]],["result"]]],[11,"from","","",89,[[["t"]],["t"]]],[11,"try_into","","",89,[[["self"]],["result"]]],[11,"into","","",89,[[["self"]],["u"]]],[11,"borrow","","",89,[[["self"]],["t"]]],[11,"borrow_mut","","",89,[[["self"]],["t"]]],[11,"get_type_id","","",89,[[["self"]],["typeid"]]],[11,"try_from","","",33,[[["u"]],["result"]]],[11,"from","","",33,[[["t"]],["t"]]],[11,"try_into","","",33,[[["self"]],["result"]]],[11,"into","","",33,[[["self"]],["u"]]],[11,"borrow","","",33,[[["self"]],["t"]]],[11,"borrow_mut","","",33,[[["self"]],["t"]]],[11,"get_type_id","","",33,[[["self"]],["typeid"]]],[11,"to_owned","alloc::slice","",90,[[["self"]],["t"]]],[11,"clone_into","","",90,N],[11,"into_iter","","",90,[[["self"]],["i"]]],[11,"try_from","","",90,[[["u"]],["result"]]],[11,"from","","",90,[[["t"]],["t"]]],[11,"try_into","","",90,[[["self"]],["result"]]],[11,"into","","",90,[[["self"]],["u"]]],[11,"borrow","","",90,[[["self"]],["t"]]],[11,"borrow_mut","","",90,[[["self"]],["t"]]],[11,"get_type_id","","",90,[[["self"]],["typeid"]]],[11,"to_owned","","",91,[[["self"]],["t"]]],[11,"clone_into","","",91,N],[11,"into_iter","","",91,[[["self"]],["i"]]],[11,"try_from","","",91,[[["u"]],["result"]]],[11,"from","","",91,[[["t"]],["t"]]],[11,"try_into","","",91,[[["self"]],["result"]]],[11,"into","","",91,[[["self"]],["u"]]],[11,"borrow","","",91,[[["self"]],["t"]]],[11,"borrow_mut","","",91,[[["self"]],["t"]]],[11,"get_type_id","","",91,[[["self"]],["typeid"]]],[11,"to_owned","","",92,[[["self"]],["t"]]],[11,"clone_into","","",92,N],[11,"into_iter","","",92,[[["self"]],["i"]]],[11,"try_from","","",92,[[["u"]],["result"]]],[11,"from","","",92,[[["t"]],["t"]]],[11,"try_into","","",92,[[["self"]],["result"]]],[11,"into","","",92,[[["self"]],["u"]]],[11,"borrow","","",92,[[["self"]],["t"]]],[11,"borrow_mut","","",92,[[["self"]],["t"]]],[11,"get_type_id","","",92,[[["self"]],["typeid"]]],[11,"into_iter","","",93,[[["self"]],["i"]]],[11,"try_from","","",93,[[["u"]],["result"]]],[11,"from","","",93,[[["t"]],["t"]]],[11,"try_into","","",93,[[["self"]],["result"]]],[11,"into","","",93,[[["self"]],["u"]]],[11,"borrow","","",93,[[["self"]],["t"]]],[11,"borrow_mut","","",93,[[["self"]],["t"]]],[11,"get_type_id","","",93,[[["self"]],["typeid"]]],[11,"into_iter","","",94,[[["self"]],["i"]]],[11,"try_from","","",94,[[["u"]],["result"]]],[11,"from","","",94,[[["t"]],["t"]]],[11,"try_into","","",94,[[["self"]],["result"]]],[11,"into","","",94,[[["self"]],["u"]]],[11,"borrow","","",94,[[["self"]],["t"]]],[11,"borrow_mut","","",94,[[["self"]],["t"]]],[11,"get_type_id","","",94,[[["self"]],["typeid"]]],[11,"into_iter","","",95,[[["self"]],["i"]]],[11,"try_from","","",95,[[["u"]],["result"]]],[11,"from","","",95,[[["t"]],["t"]]],[11,"try_into","","",95,[[["self"]],["result"]]],[11,"into","","",95,[[["self"]],["u"]]],[11,"borrow","","",95,[[["self"]],["t"]]],[11,"borrow_mut","","",95,[[["self"]],["t"]]],[11,"get_type_id","","",95,[[["self"]],["typeid"]]],[11,"to_owned","","",96,[[["self"]],["t"]]],[11,"clone_into","","",96,N],[11,"into_iter","","",96,[[["self"]],["i"]]],[11,"try_from","","",96,[[["u"]],["result"]]],[11,"from","","",96,[[["t"]],["t"]]],[11,"try_into","","",96,[[["self"]],["result"]]],[11,"into","","",96,[[["self"]],["u"]]],[11,"borrow","","",96,[[["self"]],["t"]]],[11,"borrow_mut","","",96,[[["self"]],["t"]]],[11,"get_type_id","","",96,[[["self"]],["typeid"]]],[11,"into_iter","","",97,[[["self"]],["i"]]],[11,"try_from","","",97,[[["u"]],["result"]]],[11,"from","","",97,[[["t"]],["t"]]],[11,"try_into","","",97,[[["self"]],["result"]]],[11,"into","","",97,[[["self"]],["u"]]],[11,"borrow","","",97,[[["self"]],["t"]]],[11,"borrow_mut","","",97,[[["self"]],["t"]]],[11,"get_type_id","","",97,[[["self"]],["typeid"]]],[11,"into_iter","","",98,[[["self"]],["i"]]],[11,"try_from","","",98,[[["u"]],["result"]]],[11,"from","","",98,[[["t"]],["t"]]],[11,"try_into","","",98,[[["self"]],["result"]]],[11,"into","","",98,[[["self"]],["u"]]],[11,"borrow","","",98,[[["self"]],["t"]]],[11,"borrow_mut","","",98,[[["self"]],["t"]]],[11,"get_type_id","","",98,[[["self"]],["typeid"]]],[11,"into_iter","","",99,[[["self"]],["i"]]],[11,"try_from","","",99,[[["u"]],["result"]]],[11,"from","","",99,[[["t"]],["t"]]],[11,"try_into","","",99,[[["self"]],["result"]]],[11,"into","","",99,[[["self"]],["u"]]],[11,"borrow","","",99,[[["self"]],["t"]]],[11,"borrow_mut","","",99,[[["self"]],["t"]]],[11,"get_type_id","","",99,[[["self"]],["typeid"]]],[11,"into_iter","","",100,[[["self"]],["i"]]],[11,"try_from","","",100,[[["u"]],["result"]]],[11,"from","","",100,[[["t"]],["t"]]],[11,"try_into","","",100,[[["self"]],["result"]]],[11,"into","","",100,[[["self"]],["u"]]],[11,"borrow","","",100,[[["self"]],["t"]]],[11,"borrow_mut","","",100,[[["self"]],["t"]]],[11,"get_type_id","","",100,[[["self"]],["typeid"]]],[11,"to_owned","","",101,[[["self"]],["t"]]],[11,"clone_into","","",101,N],[11,"into_iter","","",101,[[["self"]],["i"]]],[11,"try_from","","",101,[[["u"]],["result"]]],[11,"from","","",101,[[["t"]],["t"]]],[11,"try_into","","",101,[[["self"]],["result"]]],[11,"into","","",101,[[["self"]],["u"]]],[11,"borrow","","",101,[[["self"]],["t"]]],[11,"borrow_mut","","",101,[[["self"]],["t"]]],[11,"get_type_id","","",101,[[["self"]],["typeid"]]],[11,"into_iter","","",102,[[["self"]],["i"]]],[11,"try_from","","",102,[[["u"]],["result"]]],[11,"from","","",102,[[["t"]],["t"]]],[11,"try_into","","",102,[[["self"]],["result"]]],[11,"into","","",102,[[["self"]],["u"]]],[11,"borrow","","",102,[[["self"]],["t"]]],[11,"borrow_mut","","",102,[[["self"]],["t"]]],[11,"get_type_id","","",102,[[["self"]],["typeid"]]],[11,"to_owned","","",103,[[["self"]],["t"]]],[11,"clone_into","","",103,N],[11,"into_iter","","",103,[[["self"]],["i"]]],[11,"try_from","","",103,[[["u"]],["result"]]],[11,"from","","",103,[[["t"]],["t"]]],[11,"try_into","","",103,[[["self"]],["result"]]],[11,"into","","",103,[[["self"]],["u"]]],[11,"borrow","","",103,[[["self"]],["t"]]],[11,"borrow_mut","","",103,[[["self"]],["t"]]],[11,"get_type_id","","",103,[[["self"]],["typeid"]]],[11,"into_iter","","",104,[[["self"]],["i"]]],[11,"try_from","","",104,[[["u"]],["result"]]],[11,"from","","",104,[[["t"]],["t"]]],[11,"try_into","","",104,[[["self"]],["result"]]],[11,"into","","",104,[[["self"]],["u"]]],[11,"borrow","","",104,[[["self"]],["t"]]],[11,"borrow_mut","","",104,[[["self"]],["t"]]],[11,"get_type_id","","",104,[[["self"]],["typeid"]]],[11,"to_owned","","",105,[[["self"]],["t"]]],[11,"clone_into","","",105,N],[11,"into_iter","","",105,[[["self"]],["i"]]],[11,"try_from","","",105,[[["u"]],["result"]]],[11,"from","","",105,[[["t"]],["t"]]],[11,"try_into","","",105,[[["self"]],["result"]]],[11,"into","","",105,[[["self"]],["u"]]],[11,"borrow","","",105,[[["self"]],["t"]]],[11,"borrow_mut","","",105,[[["self"]],["t"]]],[11,"get_type_id","","",105,[[["self"]],["typeid"]]],[11,"into_iter","","",106,[[["self"]],["i"]]],[11,"try_from","","",106,[[["u"]],["result"]]],[11,"from","","",106,[[["t"]],["t"]]],[11,"try_into","","",106,[[["self"]],["result"]]],[11,"into","","",106,[[["self"]],["u"]]],[11,"borrow","","",106,[[["self"]],["t"]]],[11,"borrow_mut","","",106,[[["self"]],["t"]]],[11,"get_type_id","","",106,[[["self"]],["typeid"]]],[11,"to_owned","","",107,[[["self"]],["t"]]],[11,"clone_into","","",107,N],[11,"into_iter","","",107,[[["self"]],["i"]]],[11,"try_from","","",107,[[["u"]],["result"]]],[11,"from","","",107,[[["t"]],["t"]]],[11,"try_into","","",107,[[["self"]],["result"]]],[11,"into","","",107,[[["self"]],["u"]]],[11,"borrow","","",107,[[["self"]],["t"]]],[11,"borrow_mut","","",107,[[["self"]],["t"]]],[11,"get_type_id","","",107,[[["self"]],["typeid"]]],[11,"into_iter","","",108,[[["self"]],["i"]]],[11,"try_from","","",108,[[["u"]],["result"]]],[11,"from","","",108,[[["t"]],["t"]]],[11,"try_into","","",108,[[["self"]],["result"]]],[11,"into","","",108,[[["self"]],["u"]]],[11,"borrow","","",108,[[["self"]],["t"]]],[11,"borrow_mut","","",108,[[["self"]],["t"]]],[11,"get_type_id","","",108,[[["self"]],["typeid"]]],[11,"to_owned","alloc::str","",109,[[["self"]],["t"]]],[11,"clone_into","","",109,N],[11,"to_string","","",109,[[["self"]],["string"]]],[11,"try_from","","",109,[[["u"]],["result"]]],[11,"from","","",109,[[["t"]],["t"]]],[11,"try_into","","",109,[[["self"]],["result"]]],[11,"into","","",109,[[["self"]],["u"]]],[11,"borrow","","",109,[[["self"]],["t"]]],[11,"borrow_mut","","",109,[[["self"]],["t"]]],[11,"get_type_id","","",109,[[["self"]],["typeid"]]],[11,"to_owned","","",110,[[["self"]],["t"]]],[11,"clone_into","","",110,N],[11,"into_iter","","",110,[[["self"]],["i"]]],[11,"try_from","","",110,[[["u"]],["result"]]],[11,"from","","",110,[[["t"]],["t"]]],[11,"try_into","","",110,[[["self"]],["result"]]],[11,"into","","",110,[[["self"]],["u"]]],[11,"borrow","","",110,[[["self"]],["t"]]],[11,"borrow_mut","","",110,[[["self"]],["t"]]],[11,"get_type_id","","",110,[[["self"]],["typeid"]]],[11,"to_owned","","",111,[[["self"]],["t"]]],[11,"clone_into","","",111,N],[11,"into_iter","","",111,[[["self"]],["i"]]],[11,"try_from","","",111,[[["u"]],["result"]]],[11,"from","","",111,[[["t"]],["t"]]],[11,"try_into","","",111,[[["self"]],["result"]]],[11,"into","","",111,[[["self"]],["u"]]],[11,"borrow","","",111,[[["self"]],["t"]]],[11,"borrow_mut","","",111,[[["self"]],["t"]]],[11,"get_type_id","","",111,[[["self"]],["typeid"]]],[11,"to_owned","","",112,[[["self"]],["t"]]],[11,"clone_into","","",112,N],[11,"into_iter","","",112,[[["self"]],["i"]]],[11,"try_from","","",112,[[["u"]],["result"]]],[11,"from","","",112,[[["t"]],["t"]]],[11,"try_into","","",112,[[["self"]],["result"]]],[11,"into","","",112,[[["self"]],["u"]]],[11,"borrow","","",112,[[["self"]],["t"]]],[11,"borrow_mut","","",112,[[["self"]],["t"]]],[11,"get_type_id","","",112,[[["self"]],["typeid"]]],[11,"to_owned","","",113,[[["self"]],["t"]]],[11,"clone_into","","",113,N],[11,"into_iter","","",113,[[["self"]],["i"]]],[11,"try_from","","",113,[[["u"]],["result"]]],[11,"from","","",113,[[["t"]],["t"]]],[11,"try_into","","",113,[[["self"]],["result"]]],[11,"into","","",113,[[["self"]],["u"]]],[11,"borrow","","",113,[[["self"]],["t"]]],[11,"borrow_mut","","",113,[[["self"]],["t"]]],[11,"get_type_id","","",113,[[["self"]],["typeid"]]],[11,"to_owned","","",114,[[["self"]],["t"]]],[11,"clone_into","","",114,N],[11,"into_iter","","",114,[[["self"]],["i"]]],[11,"try_from","","",114,[[["u"]],["result"]]],[11,"from","","",114,[[["t"]],["t"]]],[11,"try_into","","",114,[[["self"]],["result"]]],[11,"into","","",114,[[["self"]],["u"]]],[11,"borrow","","",114,[[["self"]],["t"]]],[11,"borrow_mut","","",114,[[["self"]],["t"]]],[11,"get_type_id","","",114,[[["self"]],["typeid"]]],[11,"to_owned","","",115,[[["self"]],["t"]]],[11,"clone_into","","",115,N],[11,"into_iter","","",115,[[["self"]],["i"]]],[11,"try_from","","",115,[[["u"]],["result"]]],[11,"from","","",115,[[["t"]],["t"]]],[11,"try_into","","",115,[[["self"]],["result"]]],[11,"into","","",115,[[["self"]],["u"]]],[11,"borrow","","",115,[[["self"]],["t"]]],[11,"borrow_mut","","",115,[[["self"]],["t"]]],[11,"get_type_id","","",115,[[["self"]],["typeid"]]],[11,"to_owned","","",116,[[["self"]],["t"]]],[11,"clone_into","","",116,N],[11,"into_iter","","",116,[[["self"]],["i"]]],[11,"try_from","","",116,[[["u"]],["result"]]],[11,"from","","",116,[[["t"]],["t"]]],[11,"try_into","","",116,[[["self"]],["result"]]],[11,"into","","",116,[[["self"]],["u"]]],[11,"borrow","","",116,[[["self"]],["t"]]],[11,"borrow_mut","","",116,[[["self"]],["t"]]],[11,"get_type_id","","",116,[[["self"]],["typeid"]]],[11,"to_owned","","",117,[[["self"]],["t"]]],[11,"clone_into","","",117,N],[11,"into_iter","","",117,[[["self"]],["i"]]],[11,"try_from","","",117,[[["u"]],["result"]]],[11,"from","","",117,[[["t"]],["t"]]],[11,"try_into","","",117,[[["self"]],["result"]]],[11,"into","","",117,[[["self"]],["u"]]],[11,"borrow","","",117,[[["self"]],["t"]]],[11,"borrow_mut","","",117,[[["self"]],["t"]]],[11,"get_type_id","","",117,[[["self"]],["typeid"]]],[11,"to_owned","","",118,[[["self"]],["t"]]],[11,"clone_into","","",118,N],[11,"into_iter","","",118,[[["self"]],["i"]]],[11,"try_from","","",118,[[["u"]],["result"]]],[11,"from","","",118,[[["t"]],["t"]]],[11,"try_into","","",118,[[["self"]],["result"]]],[11,"into","","",118,[[["self"]],["u"]]],[11,"borrow","","",118,[[["self"]],["t"]]],[11,"borrow_mut","","",118,[[["self"]],["t"]]],[11,"get_type_id","","",118,[[["self"]],["typeid"]]],[11,"to_owned","","",119,[[["self"]],["t"]]],[11,"clone_into","","",119,N],[11,"into_iter","","",119,[[["self"]],["i"]]],[11,"try_from","","",119,[[["u"]],["result"]]],[11,"from","","",119,[[["t"]],["t"]]],[11,"try_into","","",119,[[["self"]],["result"]]],[11,"into","","",119,[[["self"]],["u"]]],[11,"borrow","","",119,[[["self"]],["t"]]],[11,"borrow_mut","","",119,[[["self"]],["t"]]],[11,"get_type_id","","",119,[[["self"]],["typeid"]]],[11,"to_owned","","",120,[[["self"]],["t"]]],[11,"clone_into","","",120,N],[11,"into_iter","","",120,[[["self"]],["i"]]],[11,"try_from","","",120,[[["u"]],["result"]]],[11,"from","","",120,[[["t"]],["t"]]],[11,"try_into","","",120,[[["self"]],["result"]]],[11,"into","","",120,[[["self"]],["u"]]],[11,"borrow","","",120,[[["self"]],["t"]]],[11,"borrow_mut","","",120,[[["self"]],["t"]]],[11,"get_type_id","","",120,[[["self"]],["typeid"]]],[11,"to_owned","","",121,[[["self"]],["t"]]],[11,"clone_into","","",121,N],[11,"into_iter","","",121,[[["self"]],["i"]]],[11,"try_from","","",121,[[["u"]],["result"]]],[11,"from","","",121,[[["t"]],["t"]]],[11,"try_into","","",121,[[["self"]],["result"]]],[11,"into","","",121,[[["self"]],["u"]]],[11,"borrow","","",121,[[["self"]],["t"]]],[11,"borrow_mut","","",121,[[["self"]],["t"]]],[11,"get_type_id","","",121,[[["self"]],["typeid"]]],[11,"to_owned","","",122,[[["self"]],["t"]]],[11,"clone_into","","",122,N],[11,"into_iter","","",122,[[["self"]],["i"]]],[11,"try_from","","",122,[[["u"]],["result"]]],[11,"from","","",122,[[["t"]],["t"]]],[11,"try_into","","",122,[[["self"]],["result"]]],[11,"into","","",122,[[["self"]],["u"]]],[11,"borrow","","",122,[[["self"]],["t"]]],[11,"borrow_mut","","",122,[[["self"]],["t"]]],[11,"get_type_id","","",122,[[["self"]],["typeid"]]],[11,"to_owned","","",123,[[["self"]],["t"]]],[11,"clone_into","","",123,N],[11,"into_iter","","",123,[[["self"]],["i"]]],[11,"try_from","","",123,[[["u"]],["result"]]],[11,"from","","",123,[[["t"]],["t"]]],[11,"try_into","","",123,[[["self"]],["result"]]],[11,"into","","",123,[[["self"]],["u"]]],[11,"borrow","","",123,[[["self"]],["t"]]],[11,"borrow_mut","","",123,[[["self"]],["t"]]],[11,"get_type_id","","",123,[[["self"]],["typeid"]]],[11,"to_owned","","",124,[[["self"]],["t"]]],[11,"clone_into","","",124,N],[11,"into_iter","","",124,[[["self"]],["i"]]],[11,"try_from","","",124,[[["u"]],["result"]]],[11,"from","","",124,[[["t"]],["t"]]],[11,"try_into","","",124,[[["self"]],["result"]]],[11,"into","","",124,[[["self"]],["u"]]],[11,"borrow","","",124,[[["self"]],["t"]]],[11,"borrow_mut","","",124,[[["self"]],["t"]]],[11,"get_type_id","","",124,[[["self"]],["typeid"]]],[11,"to_owned","","",125,[[["self"]],["t"]]],[11,"clone_into","","",125,N],[11,"to_string","","",125,[[["self"]],["string"]]],[11,"try_from","","",125,[[["u"]],["result"]]],[11,"from","","",125,[[["t"]],["t"]]],[11,"try_into","","",125,[[["self"]],["result"]]],[11,"into","","",125,[[["self"]],["u"]]],[11,"borrow","","",125,[[["self"]],["t"]]],[11,"borrow_mut","","",125,[[["self"]],["t"]]],[11,"get_type_id","","",125,[[["self"]],["typeid"]]],[11,"to_owned","","",126,[[["self"]],["t"]]],[11,"clone_into","","",126,N],[11,"into_iter","","",126,[[["self"]],["i"]]],[11,"try_from","","",126,[[["u"]],["result"]]],[11,"from","","",126,[[["t"]],["t"]]],[11,"try_into","","",126,[[["self"]],["result"]]],[11,"into","","",126,[[["self"]],["u"]]],[11,"borrow","","",126,[[["self"]],["t"]]],[11,"borrow_mut","","",126,[[["self"]],["t"]]],[11,"get_type_id","","",126,[[["self"]],["typeid"]]],[11,"to_owned","alloc::str::pattern","",38,[[["self"]],["t"]]],[11,"clone_into","","",38,N],[11,"try_from","","",38,[[["u"]],["result"]]],[11,"from","","",38,[[["t"]],["t"]]],[11,"try_into","","",38,[[["self"]],["result"]]],[11,"into","","",38,[[["self"]],["u"]]],[11,"borrow","","",38,[[["self"]],["t"]]],[11,"borrow_mut","","",38,[[["self"]],["t"]]],[11,"get_type_id","","",38,[[["self"]],["typeid"]]],[11,"to_owned","","",127,[[["self"]],["t"]]],[11,"clone_into","","",127,N],[11,"try_from","","",127,[[["u"]],["result"]]],[11,"from","","",127,[[["t"]],["t"]]],[11,"try_into","","",127,[[["self"]],["result"]]],[11,"into","","",127,[[["self"]],["u"]]],[11,"borrow","","",127,[[["self"]],["t"]]],[11,"borrow_mut","","",127,[[["self"]],["t"]]],[11,"get_type_id","","",127,[[["self"]],["typeid"]]],[11,"to_owned","","",128,[[["self"]],["t"]]],[11,"clone_into","","",128,N],[11,"try_from","","",128,[[["u"]],["result"]]],[11,"from","","",128,[[["t"]],["t"]]],[11,"try_into","","",128,[[["self"]],["result"]]],[11,"into","","",128,[[["self"]],["u"]]],[11,"borrow","","",128,[[["self"]],["t"]]],[11,"borrow_mut","","",128,[[["self"]],["t"]]],[11,"get_type_id","","",128,[[["self"]],["typeid"]]],[11,"to_owned","","",129,[[["self"]],["t"]]],[11,"clone_into","","",129,N],[11,"try_from","","",129,[[["u"]],["result"]]],[11,"from","","",129,[[["t"]],["t"]]],[11,"try_into","","",129,[[["self"]],["result"]]],[11,"into","","",129,[[["self"]],["u"]]],[11,"borrow","","",129,[[["self"]],["t"]]],[11,"borrow_mut","","",129,[[["self"]],["t"]]],[11,"get_type_id","","",129,[[["self"]],["typeid"]]],[11,"to_owned","","",130,[[["self"]],["t"]]],[11,"clone_into","","",130,N],[11,"try_from","","",130,[[["u"]],["result"]]],[11,"from","","",130,[[["t"]],["t"]]],[11,"try_into","","",130,[[["self"]],["result"]]],[11,"into","","",130,[[["self"]],["u"]]],[11,"borrow","","",130,[[["self"]],["t"]]],[11,"borrow_mut","","",130,[[["self"]],["t"]]],[11,"get_type_id","","",130,[[["self"]],["typeid"]]],[11,"to_owned","alloc::str","",131,[[["self"]],["t"]]],[11,"clone_into","","",131,N],[11,"into_iter","","",131,[[["self"]],["i"]]],[11,"try_from","","",131,[[["u"]],["result"]]],[11,"from","","",131,[[["t"]],["t"]]],[11,"try_into","","",131,[[["self"]],["result"]]],[11,"into","","",131,[[["self"]],["u"]]],[11,"borrow","","",131,[[["self"]],["t"]]],[11,"borrow_mut","","",131,[[["self"]],["t"]]],[11,"get_type_id","","",131,[[["self"]],["typeid"]]],[11,"to_owned","","",132,[[["self"]],["t"]]],[11,"clone_into","","",132,N],[11,"into_iter","","",132,[[["self"]],["i"]]],[11,"try_from","","",132,[[["u"]],["result"]]],[11,"from","","",132,[[["t"]],["t"]]],[11,"try_into","","",132,[[["self"]],["result"]]],[11,"into","","",132,[[["self"]],["u"]]],[11,"borrow","","",132,[[["self"]],["t"]]],[11,"borrow_mut","","",132,[[["self"]],["t"]]],[11,"get_type_id","","",132,[[["self"]],["typeid"]]],[11,"to_owned","alloc::string","",42,[[["self"]],["t"]]],[11,"clone_into","","",42,N],[11,"to_string","","",42,[[["self"]],["string"]]],[11,"try_from","","",42,[[["u"]],["result"]]],[11,"from","","",42,[[["t"]],["t"]]],[11,"try_into","","",42,[[["self"]],["result"]]],[11,"into","","",42,[[["self"]],["u"]]],[11,"borrow","","",42,[[["self"]],["t"]]],[11,"borrow_mut","","",42,[[["self"]],["t"]]],[11,"get_type_id","","",42,[[["self"]],["typeid"]]],[11,"to_string","","",43,[[["self"]],["string"]]],[11,"try_from","","",43,[[["u"]],["result"]]],[11,"from","","",43,[[["t"]],["t"]]],[11,"try_into","","",43,[[["self"]],["result"]]],[11,"into","","",43,[[["self"]],["u"]]],[11,"borrow","","",43,[[["self"]],["t"]]],[11,"borrow_mut","","",43,[[["self"]],["t"]]],[11,"get_type_id","","",43,[[["self"]],["typeid"]]],[11,"to_string","","",133,[[["self"]],["string"]]],[11,"try_from","","",133,[[["u"]],["result"]]],[11,"from","","",133,[[["t"]],["t"]]],[11,"try_into","","",133,[[["self"]],["result"]]],[11,"into","","",133,[[["self"]],["u"]]],[11,"borrow","","",133,[[["self"]],["t"]]],[11,"borrow_mut","","",133,[[["self"]],["t"]]],[11,"get_type_id","","",133,[[["self"]],["typeid"]]],[11,"into_iter","","",134,[[["self"]],["i"]]],[11,"try_from","","",134,[[["u"]],["result"]]],[11,"from","","",134,[[["t"]],["t"]]],[11,"try_into","","",134,[[["self"]],["result"]]],[11,"into","","",134,[[["self"]],["u"]]],[11,"borrow","","",134,[[["self"]],["t"]]],[11,"borrow_mut","","",134,[[["self"]],["t"]]],[11,"get_type_id","","",134,[[["self"]],["typeid"]]],[11,"to_owned","","",135,[[["self"]],["t"]]],[11,"clone_into","","",135,N],[11,"to_string","","",135,[[["self"]],["string"]]],[11,"try_from","","",135,[[["u"]],["result"]]],[11,"from","","",135,[[["t"]],["t"]]],[11,"try_into","","",135,[[["self"]],["result"]]],[11,"into","","",135,[[["self"]],["u"]]],[11,"borrow","","",135,[[["self"]],["t"]]],[11,"borrow_mut","","",135,[[["self"]],["t"]]],[11,"get_type_id","","",135,[[["self"]],["typeid"]]],[11,"to_owned","alloc::vec","",44,[[["self"]],["t"]]],[11,"clone_into","","",44,N],[11,"into_iter","","",44,[[["self"]],["i"]]],[11,"try_from","","",44,[[["u"]],["result"]]],[11,"from","","",44,[[["t"]],["t"]]],[11,"try_into","","",44,[[["self"]],["result"]]],[11,"into","","",44,[[["self"]],["u"]]],[11,"borrow","","",44,[[["self"]],["t"]]],[11,"borrow_mut","","",44,[[["self"]],["t"]]],[11,"get_type_id","","",44,[[["self"]],["typeid"]]],[11,"to_owned","","",45,[[["self"]],["t"]]],[11,"clone_into","","",45,N],[11,"into_iter","","",45,[[["self"]],["i"]]],[11,"try_from","","",45,[[["u"]],["result"]]],[11,"from","","",45,[[["t"]],["t"]]],[11,"try_into","","",45,[[["self"]],["result"]]],[11,"into","","",45,[[["self"]],["u"]]],[11,"borrow","","",45,[[["self"]],["t"]]],[11,"borrow_mut","","",45,[[["self"]],["t"]]],[11,"get_type_id","","",45,[[["self"]],["typeid"]]],[11,"into_iter","","",136,[[["self"]],["i"]]],[11,"try_from","","",136,[[["u"]],["result"]]],[11,"from","","",136,[[["t"]],["t"]]],[11,"try_into","","",136,[[["self"]],["result"]]],[11,"into","","",136,[[["self"]],["u"]]],[11,"borrow","","",136,[[["self"]],["t"]]],[11,"borrow_mut","","",136,[[["self"]],["t"]]],[11,"get_type_id","","",136,[[["self"]],["typeid"]]],[11,"into_iter","","",137,[[["self"]],["i"]]],[11,"try_from","","",137,[[["u"]],["result"]]],[11,"from","","",137,[[["t"]],["t"]]],[11,"try_into","","",137,[[["self"]],["result"]]],[11,"into","","",137,[[["self"]],["u"]]],[11,"borrow","","",137,[[["self"]],["t"]]],[11,"borrow_mut","","",137,[[["self"]],["t"]]],[11,"get_type_id","","",137,[[["self"]],["typeid"]]],[11,"into_iter","","",138,[[["self"]],["i"]]],[11,"try_from","","",138,[[["u"]],["result"]]],[11,"from","","",138,[[["t"]],["t"]]],[11,"try_into","","",138,[[["self"]],["result"]]],[11,"into","","",138,[[["self"]],["u"]]],[11,"borrow","","",138,[[["self"]],["t"]]],[11,"borrow_mut","","",138,[[["self"]],["t"]]],[11,"get_type_id","","",138,[[["self"]],["typeid"]]],[11,"len","alloc::str","",124,[[["self"]],["usize"]]],[11,"is_empty","","",124,[[["self"]],["bool"]]],[11,"is_empty","alloc::slice","",107,[[["self"]],["bool"]]],[11,"len","","",93,[[["self"]],["usize"]]],[11,"is_empty","","",93,[[["self"]],["bool"]]],[11,"is_empty","","",108,[[["self"]],["bool"]]],[11,"is_empty","","",104,[[["self"]],["bool"]]],[11,"len","","",92,[[["self"]],["usize"]]],[11,"is_empty","","",92,[[["self"]],["bool"]]],[11,"is_empty","","",103,[[["self"]],["bool"]]],[11,"from","alloc::task","Converts a `LocalWaker` into a `Waker`.",52,[[["localwaker"]],["waker"]]],[11,"from","","",4,[[["t"]],["poll"]]],[11,"as_ref","alloc::slice","",92,N],[11,"write_str","alloc::fmt","",82,[[["self"],["str"]],["result",["error"]]]],[11,"write_char","","",82,[[["self"],["char"]],["result",["error"]]]],[11,"write_fmt","","",82,[[["self"],["arguments"]],["result",["error"]]]],[11,"into_result","alloc::task","",4,[[["self"]],["result"]]],[11,"from_error","","",4,N],[11,"from_ok","","",4,N],[11,"into_result","","",4,[[["self"]],["result"]]],[11,"from_error","","",4,N],[11,"from_ok","","",4,N],[11,"drop","","",52,N],[11,"default","alloc::fmt","",83,[[],["error"]]],[11,"next_back","alloc::str::pattern","",128,[[["self"]],["searchstep"]]],[11,"next_match_back","","",128,[[["self"]],["option"]]],[11,"next_reject_back","","",128,[[["self"]],["option"]]],[11,"next_back","","",130,[[["self"]],["searchstep"]]],[11,"next_match_back","","",130,[[["self"]],["option"]]],[11,"next_back","","",129,[[["self"]],["searchstep"]]],[11,"next_match_back","","",129,[[["self"]],["option"]]],[11,"next_reject_back","","",129,[[["self"]],["option"]]],[11,"next_back","","",127,[[["self"]],["searchstep"]]],[11,"next_match_back","","",127,[[["self"]],["option"]]],[11,"fmt","alloc::alloc","",49,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",109,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",47,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::fmt","",83,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",125,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",48,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::fmt","",84,[[["self"],["formatter"]],["result",["error"]]]],[11,"next_back","alloc::slice","",107,[[["self"]],["option"]]],[11,"next_back","alloc::str","",118,[[["self"]],["option",["str"]]]],[11,"next_back","","",120,[[["self"]],["option"]]],[11,"next_back","alloc::slice","",94,[[["self"]],["option"]]],[11,"next_back","","",96,[[["self"]],["option"]]],[11,"next_back","alloc::str","",123,[[["self"]],["option"]]],[11,"next_back","alloc::slice","",95,[[["self"]],["option"]]],[11,"next_back","alloc::str","",124,[[["self"]],["option",["u8"]]]],[11,"rfind","","",124,[[["self"],["p"]],["option"]]],[11,"next_back","alloc::slice","",90,[[["self"]],["option"]]],[11,"next_back","alloc::str","",113,[[["self"]],["option",["str"]]]],[11,"next_back","","",116,[[["self"]],["option",["str"]]]],[11,"next_back","alloc::slice","",93,[[["self"]],["option"]]],[11,"try_rfold","","",93,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",93,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",101,[[["self"]],["option"]]],[11,"next_back","alloc::str","",117,[[["self"]],["option",["str"]]]],[11,"next_back","alloc::slice","",106,[[["self"]],["option"]]],[11,"next_back","alloc::str","",111,[[["self"]],["option",["str"]]]],[11,"next_back","","",132,[[["self"]],["option",["str"]]]],[11,"next_back","alloc::slice","",104,[[["self"]],["option"]]],[11,"next_back","","",102,[[["self"]],["option"]]],[11,"next_back","","",91,[[["self"]],["option"]]],[11,"next_back","alloc::str","",121,[[["self"]],["option"]]],[11,"next_back","alloc::slice","",108,[[["self"]],["option"]]],[11,"next_back","","",92,[[["self"]],["option"]]],[11,"try_rfold","","",92,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",92,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","alloc::str","",122,[[["self"]],["option",["char"]]]],[11,"next_back","","",110,[[["self"]],["option",["str"]]]],[11,"next_back","","",112,[[["self"]],["option",["str"]]]],[11,"next_back","alloc::slice","",105,[[["self"]],["option"]]],[11,"next_back","","",103,[[["self"]],["option"]]],[11,"next_back","alloc::str","",126,[[["self"]],["option",["str"]]]],[11,"next_back","","",119,[[["self"]],["option",["str"]]]],[11,"next","alloc::slice","",105,[[["self"]],["option"]]],[11,"size_hint","","",105,N],[11,"count","","",105,[[["self"]],["usize"]]],[11,"nth","","",105,[[["self"],["usize"]],["option"]]],[11,"last","","",105,[[["self"]],["option"]]],[11,"next","","",106,[[["self"]],["option"]]],[11,"size_hint","","",106,N],[11,"count","","",106,[[["self"]],["usize"]]],[11,"nth","","",106,[[["self"],["usize"]],["option"]]],[11,"last","","",106,[[["self"]],["option"]]],[11,"next","alloc::str","",114,[[["self"]],["option",["str"]]]],[11,"next","","",117,[[["self"]],["option",["str"]]]],[11,"next","alloc::slice","",100,[[["self"]],["option"]]],[11,"size_hint","","",100,N],[11,"next","alloc::str","",119,[[["self"]],["option",["str"]]]],[11,"next","alloc::slice","",107,[[["self"]],["option"]]],[11,"size_hint","","",107,N],[11,"count","","",107,[[["self"]],["usize"]]],[11,"nth","","",107,[[["self"],["usize"]],["option"]]],[11,"last","","",107,[[["self"]],["option"]]],[11,"next","alloc::str","",126,[[["self"]],["option",["str"]]]],[11,"size_hint","","",126,N],[11,"next","","",111,[[["self"]],["option",["str"]]]],[11,"size_hint","","",111,N],[11,"next","alloc::slice","",92,[[["self"]],["option"]]],[11,"size_hint","","",92,N],[11,"count","","",92,[[["self"]],["usize"]]],[11,"nth","","",92,[[["self"],["usize"]],["option"]]],[11,"last","","",92,[[["self"]],["option"]]],[11,"try_fold","","",92,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",92,[[["self"],["acc"],["fold"]],["acc"]]],[11,"position","","",92,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",92,[[["self"],["p"]],["option",["usize"]]]],[11,"next","alloc::str","",115,[[["self"]],["option",["str"]]]],[11,"next","alloc::slice","",108,[[["self"]],["option"]]],[11,"size_hint","","",108,N],[11,"count","","",108,[[["self"]],["usize"]]],[11,"nth","","",108,[[["self"],["usize"]],["option"]]],[11,"last","","",108,[[["self"]],["option"]]],[11,"next","alloc::str","",121,[[["self"]],["option"]]],[11,"next","","",123,[[["self"]],["option"]]],[11,"count","","",123,[[["self"]],["usize"]]],[11,"size_hint","","",123,N],[11,"last","","",123,[[["self"]],["option"]]],[11,"next","alloc::slice","",99,[[["self"]],["option"]]],[11,"size_hint","","",99,N],[11,"next","","",98,[[["self"]],["option"]]],[11,"size_hint","","",98,N],[11,"next","alloc::str","",122,[[["self"]],["option",["char"]]]],[11,"count","","",122,[[["self"]],["usize"]]],[11,"size_hint","","",122,N],[11,"last","","",122,[[["self"]],["option",["char"]]]],[11,"next","alloc::slice","",95,[[["self"]],["option"]]],[11,"size_hint","","",95,N],[11,"count","","",95,[[["self"]],["usize"]]],[11,"nth","","",95,[[["self"],["usize"]],["option"]]],[11,"last","","",95,[[["self"]],["option"]]],[11,"next","","",101,[[["self"]],["option"]]],[11,"size_hint","","",101,N],[11,"next","","",91,[[["self"]],["option"]]],[11,"size_hint","","",91,N],[11,"count","","",91,[[["self"]],["usize"]]],[11,"nth","","",91,[[["self"],["usize"]],["option"]]],[11,"last","","",91,[[["self"]],["option"]]],[11,"next","","",103,[[["self"]],["option"]]],[11,"size_hint","","",103,N],[11,"count","","",103,[[["self"]],["usize"]]],[11,"nth","","",103,[[["self"],["usize"]],["option"]]],[11,"last","","",103,[[["self"]],["option"]]],[11,"next","","",104,[[["self"]],["option"]]],[11,"size_hint","","",104,N],[11,"count","","",104,[[["self"]],["usize"]]],[11,"nth","","",104,[[["self"],["usize"]],["option"]]],[11,"last","","",104,[[["self"]],["option"]]],[11,"next","","",102,[[["self"]],["option"]]],[11,"size_hint","","",102,N],[11,"next","alloc::str","",110,[[["self"]],["option",["str"]]]],[11,"size_hint","","",110,N],[11,"next","alloc::slice","",94,[[["self"]],["option"]]],[11,"size_hint","","",94,N],[11,"next","","",93,[[["self"]],["option"]]],[11,"size_hint","","",93,N],[11,"count","","",93,[[["self"]],["usize"]]],[11,"nth","","",93,[[["self"],["usize"]],["option"]]],[11,"last","","",93,[[["self"]],["option"]]],[11,"try_fold","","",93,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",93,[[["self"],["acc"],["fold"]],["acc"]]],[11,"position","","",93,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",93,[[["self"],["p"]],["option",["usize"]]]],[11,"next","alloc::str","",118,[[["self"]],["option",["str"]]]],[11,"next","alloc::slice","",97,[[["self"]],["option"]]],[11,"size_hint","","",97,N],[11,"next","alloc::str","",113,[[["self"]],["option",["str"]]]],[11,"next","","",131,[[["self"]],["option",["u16"]]]],[11,"size_hint","","",131,N],[11,"next","alloc::slice","",96,[[["self"]],["option"]]],[11,"size_hint","","",96,N],[11,"next","alloc::str","",124,[[["self"]],["option",["u8"]]]],[11,"size_hint","","",124,N],[11,"count","","",124,[[["self"]],["usize"]]],[11,"last","","",124,[[["self"]],["option"]]],[11,"nth","","",124,[[["self"],["usize"]],["option"]]],[11,"all","","",124,[[["self"],["f"]],["bool"]]],[11,"any","","",124,[[["self"],["f"]],["bool"]]],[11,"find","","",124,[[["self"],["p"]],["option"]]],[11,"position","","",124,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",124,[[["self"],["p"]],["option",["usize"]]]],[11,"next","","",112,[[["self"]],["option",["str"]]]],[11,"next","alloc::slice","",90,[[["self"]],["option"]]],[11,"size_hint","","",90,N],[11,"count","","",90,[[["self"]],["usize"]]],[11,"nth","","",90,[[["self"],["usize"]],["option"]]],[11,"last","","",90,[[["self"]],["option"]]],[11,"next","alloc::str","",116,[[["self"]],["option",["str"]]]],[11,"next","","",120,[[["self"]],["option"]]],[11,"next","","",132,[[["self"]],["option",["str"]]]],[11,"size_hint","","",132,N],[11,"hash","alloc::task","",4,N],[11,"hash","alloc::fmt","",83,N],[11,"clone","alloc::task","",52,[[["self"]],["waker"]]],[11,"clone","alloc::str","",124,[[["self"]],["bytes"]]],[11,"clone","alloc::alloc","",47,[[["self"]],["layouterr"]]],[11,"clone","alloc::str::pattern","",130,[[["self"]],["strsearcher"]]],[11,"clone","","",129,[[["self"]],["charpredicatesearcher"]]],[11,"clone","alloc::slice","",105,[[["self"]],["rchunks"]]],[11,"clone","alloc::str","",120,[[["self"]],["matchindices"]]],[11,"clone","","",117,[[["self"]],["rsplitterminator"]]],[11,"clone","alloc::str::pattern","",127,[[["self"]],["charsearcher"]]],[11,"clone","alloc::alloc","",46,[[["self"]],["layout"]]],[11,"clone","alloc::slice","",103,[[["self"]],["chunksexact"]]],[11,"clone","alloc::str","",116,[[["self"]],["splitterminator"]]],[11,"clone","alloc::task","",4,[[["self"]],["poll"]]],[11,"clone","alloc::alloc","",48,[[["self"]],["allocerr"]]],[11,"clone","alloc::str","",132,[[["self"]],["splitasciiwhitespace"]]],[11,"clone","","",121,[[["self"]],["rmatchindices"]]],[11,"clone","","",109,[[["self"]],["utf8error"]]],[11,"clone","","",123,[[["self"]],["charindices"]]],[11,"clone","","",115,[[["self"]],["rsplitn"]]],[11,"clone","","",114,[[["self"]],["splitn"]]],[11,"clone","alloc::str::pattern","",38,[[["self"]],["searchstep"]]],[11,"clone","alloc::slice","",90,[[["self"]],["chunks"]]],[11,"clone","alloc::task","",51,[[["self"]],["localwaker"]]],[11,"clone","alloc::slice","",92,[[["self"]],["iter"]]],[11,"clone","","",91,[[["self"]],["windows"]]],[11,"clone","alloc::str","",118,[[["self"]],["matches"]]],[11,"clone","","",131,[[["self"]],["encodeutf16"]]],[11,"clone","alloc::str::pattern","",128,[[["self"]],["charslicesearcher"]]],[11,"clone","alloc::slice","",101,[[["self"]],["rsplit"]]],[11,"clone","alloc::str","",113,[[["self"]],["rsplit"]]],[11,"clone","","",122,[[["self"]],["chars"]]],[11,"clone","","",110,[[["self"]],["lines"]]],[11,"clone","alloc::fmt","",83,[[["self"]],["error"]]],[11,"clone","alloc::alloc","",49,[[["self"]],["cannotreallocinplace"]]],[11,"clone","alloc::str","",119,[[["self"]],["rmatches"]]],[11,"clone","alloc::slice","",96,[[["self"]],["split"]]],[11,"clone","","",107,[[["self"]],["rchunksexact"]]],[11,"clone","alloc::str","",112,[[["self"]],["split"]]],[11,"clone","","",111,[[["self"]],["linesany"]]],[11,"clone","","",125,[[["self"]],["parseboolerror"]]],[11,"clone","alloc::fmt","",84,[[["self"]],["arguments"]]],[11,"clone","alloc::str","",126,[[["self"]],["splitwhitespace"]]],[11,"partial_cmp","alloc::task","",4,[[["self"],["poll"]],["option",["ordering"]]]],[11,"lt","","",4,[[["self"],["poll"]],["bool"]]],[11,"le","","",4,[[["self"],["poll"]],["bool"]]],[11,"gt","","",4,[[["self"],["poll"]],["bool"]]],[11,"ge","","",4,[[["self"],["poll"]],["bool"]]],[11,"partial_cmp","alloc::fmt","",83,[[["self"],["error"]],["option",["ordering"]]]],[11,"cmp","","",83,[[["self"],["error"]],["ordering"]]],[11,"cmp","alloc::task","",4,[[["self"],["poll"]],["ordering"]]],[11,"fmt","alloc::str","",120,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",93,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",99,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",92,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",101,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",119,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",48,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",114,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",124,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",116,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::task","",52,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",108,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str::pattern","",38,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",115,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",110,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::fmt","",33,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",112,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",126,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str::pattern","",127,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",132,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",46,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",111,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",104,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",97,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",90,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str::pattern","",128,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",121,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",105,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",95,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",49,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",125,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",118,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str::pattern","",130,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",102,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::alloc","",47,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",106,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str::pattern","",129,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",117,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",107,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",91,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",109,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::fmt","",84,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",83,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",94,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::task","",51,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",100,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::task","",4,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",98,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",113,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",96,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",122,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","","",131,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::slice","",103,[[["self"],["formatter"]],["result",["error"]]]],[11,"fmt","alloc::str","",123,[[["self"],["formatter"]],["result",["error"]]]],[11,"haystack","alloc::str::pattern","",130,[[["self"]],["str"]]],[11,"next","","",130,[[["self"]],["searchstep"]]],[11,"next_match","","",130,[[["self"]],["option"]]],[11,"haystack","","",129,[[["self"]],["str"]]],[11,"next","","",129,[[["self"]],["searchstep"]]],[11,"next_match","","",129,[[["self"]],["option"]]],[11,"next_reject","","",129,[[["self"]],["option"]]],[11,"haystack","","",127,[[["self"]],["str"]]],[11,"next","","",127,[[["self"]],["searchstep"]]],[11,"next_match","","",127,[[["self"]],["option"]]],[11,"haystack","","",128,[[["self"]],["str"]]],[11,"next","","",128,[[["self"]],["searchstep"]]],[11,"next_match","","",128,[[["self"]],["option"]]],[11,"next_reject","","",128,[[["self"]],["option"]]],[11,"eq","alloc::str","",125,[[["self"],["parseboolerror"]],["bool"]]],[11,"ne","","",125,[[["self"],["parseboolerror"]],["bool"]]],[11,"eq","alloc::task","",4,[[["self"],["poll"]],["bool"]]],[11,"ne","","",4,[[["self"],["poll"]],["bool"]]],[11,"eq","alloc::alloc","",48,[[["self"],["allocerr"]],["bool"]]],[11,"eq","","",47,[[["self"],["layouterr"]],["bool"]]],[11,"ne","","",47,[[["self"],["layouterr"]],["bool"]]],[11,"eq","alloc::str","",109,[[["self"],["utf8error"]],["bool"]]],[11,"ne","","",109,[[["self"],["utf8error"]],["bool"]]],[11,"eq","alloc::alloc","",46,[[["self"],["layout"]],["bool"]]],[11,"ne","","",46,[[["self"],["layout"]],["bool"]]],[11,"eq","","",49,[[["self"],["cannotreallocinplace"]],["bool"]]],[11,"eq","alloc::fmt","",83,[[["self"],["error"]],["bool"]]],[11,"eq","alloc::str::pattern","",38,[[["self"],["searchstep"]],["bool"]]],[11,"ne","","",38,[[["self"],["searchstep"]],["bool"]]],[11,"to_string","alloc::borrow","",21,[[["self"]],["string"]]],[11,"to_string","alloc::string","",42,[[["self"]],["string"]]],[11,"deref","alloc::boxed","",7,[[["self"]],["t"]]],[11,"deref","alloc::collections::binary_heap","",9,[[["self"]],["t"]]],[11,"deref","alloc::sync","",15,[[["self"]],["t"]]],[11,"deref","alloc::rc","",17,[[["self"]],["t"]]],[11,"deref","alloc::borrow","",21,[[["self"]],["b"]]],[11,"deref","alloc::string","",42,[[["self"]],["str"]]],[11,"deref","alloc::vec","",44,N],[11,"fmt","alloc::alloc","",50,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::boxed","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::collections::binary_heap","",9,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",53,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",54,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",55,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::collections::btree_map","",57,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",58,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",59,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",60,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",61,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",62,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",63,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",64,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",65,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",66,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",56,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::collections::btree_set","",68,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",69,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",70,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",71,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",72,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",73,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",74,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",67,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::collections::linked_list","",75,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",76,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",77,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::collections::vec_deque","",78,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",79,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",80,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",81,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::collections","",8,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::sync","",16,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",15,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::rc","",17,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",18,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::borrow","",21,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::string","",43,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",133,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",42,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",135,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",134,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::vec","",44,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",45,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",136,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",137,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",138,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::boxed","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::sync","",15,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::rc","",17,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::borrow","",21,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::string","",43,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",133,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",42,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",135,[[["self"],["formatter"]],["result"]]],[11,"eq","alloc::boxed","",7,[[["self"],["box"]],["bool"]]],[11,"ne","","",7,[[["self"],["box"]],["bool"]]],[11,"eq","alloc::collections::btree_map","",56,[[["self"],["btreemap"]],["bool"]]],[11,"eq","alloc::collections::btree_set","",67,[[["self"],["btreeset"]],["bool"]]],[11,"ne","","",67,[[["self"],["btreeset"]],["bool"]]],[11,"eq","alloc::collections::linked_list","",11,[[["self"],["self"]],["bool"]]],[11,"ne","","",11,[[["self"],["self"]],["bool"]]],[11,"eq","alloc::collections::vec_deque","",13,[[["self"],["vecdeque"]],["bool"]]],[11,"eq","","",13,[[["self"],["vec"]],["bool"]]],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","","",13,N],[11,"eq","alloc::collections","",8,[[["self"],["collectionallocerr"]],["bool"]]],[11,"eq","alloc::sync","Equality for two `Arc`s.",15,[[["self"],["arc"]],["bool"]]],[11,"ne","","Inequality for two `Arc`s.",15,[[["self"],["arc"]],["bool"]]],[11,"eq","alloc::rc","Equality for two `Rc`s.",17,[[["self"],["rc"]],["bool"]]],[11,"ne","","Inequality for two `Rc`s.",17,[[["self"],["rc"]],["bool"]]],[11,"eq","alloc::borrow","",21,[[["self"],["cow"]],["bool"]]],[11,"eq","alloc::string","",42,[[["self"],["string"]],["bool"]]],[11,"ne","","",42,[[["self"],["string"]],["bool"]]],[11,"eq","","",42,[[["self"],["str"]],["bool"]]],[11,"ne","","",42,[[["self"],["str"]],["bool"]]],[11,"eq","","",42,[[["self"],["str"]],["bool"]]],[11,"ne","","",42,[[["self"],["str"]],["bool"]]],[11,"eq","alloc::borrow","",21,[[["self"],["str"]],["bool"]]],[11,"ne","","",21,[[["self"],["str"]],["bool"]]],[11,"eq","","",21,[[["self"],["str"]],["bool"]]],[11,"ne","","",21,[[["self"],["str"]],["bool"]]],[11,"eq","","",21,[[["self"],["string"]],["bool"]]],[11,"ne","","",21,[[["self"],["string"]],["bool"]]],[11,"eq","alloc::string","",42,[[["self"],["cow"]],["bool"]]],[11,"ne","","",42,[[["self"],["cow"]],["bool"]]],[11,"eq","","",135,[[["self"],["parseerror"]],["bool"]]],[11,"eq","alloc::vec","",44,[[["self"],["vec"]],["bool"]]],[11,"ne","","",44,[[["self"],["vec"]],["bool"]]],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","alloc::borrow","",21,N],[11,"ne","","",21,N],[11,"eq","","",21,N],[11,"ne","","",21,N],[11,"eq","","",21,[[["self"],["vec"]],["bool"]]],[11,"ne","","",21,[[["self"],["vec"]],["bool"]]],[11,"eq","alloc::vec","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"eq","","",44,N],[11,"ne","","",44,N],[11,"cmp","alloc::boxed","",7,[[["self"],["box"]],["ordering"]]],[11,"cmp","alloc::collections::btree_map","",56,[[["self"],["btreemap"]],["ordering"]]],[11,"cmp","alloc::collections::btree_set","",67,[[["self"],["btreeset"]],["ordering"]]],[11,"cmp","alloc::collections::linked_list","",11,[[["self"],["self"]],["ordering"]]],[11,"cmp","alloc::collections::vec_deque","",13,[[["self"],["vecdeque"]],["ordering"]]],[11,"cmp","alloc::sync","Comparison for two `Arc`s.",15,[[["self"],["arc"]],["ordering"]]],[11,"cmp","alloc::rc","Comparison for two `Rc`s.",17,[[["self"],["rc"]],["ordering"]]],[11,"cmp","alloc::borrow","",21,[[["self"],["cow"]],["ordering"]]],[11,"cmp","alloc::string","",42,[[["self"],["string"]],["ordering"]]],[11,"cmp","alloc::vec","",44,[[["self"],["vec"]],["ordering"]]],[11,"partial_cmp","alloc::boxed","",7,[[["self"],["box"]],["option",["ordering"]]]],[11,"lt","","",7,[[["self"],["box"]],["bool"]]],[11,"le","","",7,[[["self"],["box"]],["bool"]]],[11,"ge","","",7,[[["self"],["box"]],["bool"]]],[11,"gt","","",7,[[["self"],["box"]],["bool"]]],[11,"partial_cmp","alloc::collections::btree_map","",56,[[["self"],["btreemap"]],["option",["ordering"]]]],[11,"partial_cmp","alloc::collections::btree_set","",67,[[["self"],["btreeset"]],["option",["ordering"]]]],[11,"lt","","",67,[[["self"],["btreeset"]],["bool"]]],[11,"le","","",67,[[["self"],["btreeset"]],["bool"]]],[11,"gt","","",67,[[["self"],["btreeset"]],["bool"]]],[11,"ge","","",67,[[["self"],["btreeset"]],["bool"]]],[11,"partial_cmp","alloc::collections::linked_list","",11,[[["self"],["self"]],["option",["ordering"]]]],[11,"partial_cmp","alloc::collections::vec_deque","",13,[[["self"],["vecdeque"]],["option",["ordering"]]]],[11,"partial_cmp","alloc::sync","Partial comparison for two `Arc`s.",15,[[["self"],["arc"]],["option",["ordering"]]]],[11,"lt","","Less-than comparison for two `Arc`s.",15,[[["self"],["arc"]],["bool"]]],[11,"le","","'Less than or equal to' comparison for two `Arc`s.",15,[[["self"],["arc"]],["bool"]]],[11,"gt","","Greater-than comparison for two `Arc`s.",15,[[["self"],["arc"]],["bool"]]],[11,"ge","","'Greater than or equal to' comparison for two `Arc`s.",15,[[["self"],["arc"]],["bool"]]],[11,"partial_cmp","alloc::rc","Partial comparison for two `Rc`s.",17,[[["self"],["rc"]],["option",["ordering"]]]],[11,"lt","","Less-than comparison for two `Rc`s.",17,[[["self"],["rc"]],["bool"]]],[11,"le","","'Less than or equal to' comparison for two `Rc`s.",17,[[["self"],["rc"]],["bool"]]],[11,"gt","","Greater-than comparison for two `Rc`s.",17,[[["self"],["rc"]],["bool"]]],[11,"ge","","'Greater than or equal to' comparison for two `Rc`s.",17,[[["self"],["rc"]],["bool"]]],[11,"partial_cmp","alloc::borrow","",21,[[["self"],["cow"]],["option",["ordering"]]]],[11,"partial_cmp","alloc::string","",42,[[["self"],["string"]],["option",["ordering"]]]],[11,"lt","","",42,[[["self"],["string"]],["bool"]]],[11,"le","","",42,[[["self"],["string"]],["bool"]]],[11,"gt","","",42,[[["self"],["string"]],["bool"]]],[11,"ge","","",42,[[["self"],["string"]],["bool"]]],[11,"partial_cmp","alloc::vec","",44,[[["self"],["vec"]],["option",["ordering"]]]],[11,"add","alloc::borrow","",21,N],[11,"add","","",21,N],[11,"add","alloc::string","",42,[[["self"],["str"]],["string"]]],[11,"add_assign","alloc::borrow","",21,[[["self"],["str"]]]],[11,"add_assign","","",21,[[["self"],["cow",["str"]]]]],[11,"add_assign","alloc::string","",42,[[["self"],["str"]]]],[11,"deref_mut","alloc::boxed","",7,[[["self"]],["t"]]],[11,"deref_mut","alloc::collections::binary_heap","",9,[[["self"]],["t"]]],[11,"deref_mut","alloc::string","",42,[[["self"]],["str"]]],[11,"deref_mut","alloc::vec","",44,N],[11,"drop","alloc::boxed","",7,[[["self"]]]],[11,"drop","alloc::collections::binary_heap","",9,[[["self"]]]],[11,"drop","alloc::collections::btree_map","",56,[[["self"]]]],[11,"drop","","",59,[[["self"]]]],[11,"drop","alloc::collections::linked_list","",11,[[["self"]]]],[11,"drop","","",77,[[["self"]]]],[11,"drop","alloc::collections::vec_deque","",13,[[["self"]]]],[11,"drop","","",81,[[["self"]]]],[11,"drop","alloc::sync","Drops the `Arc`.",15,[[["self"]]]],[11,"drop","","Drops the `Weak` pointer.",16,[[["self"]]]],[11,"drop","alloc::rc","Drops the `Rc`.",17,[[["self"]]]],[11,"drop","","Drops the `Weak` pointer.",18,[[["self"]]]],[11,"drop","alloc::string","",134,[[["self"]]]],[11,"drop","alloc::vec","",44,[[["self"]]]],[11,"drop","","",45,[[["self"]]]],[11,"drop","","",136,[[["self"]]]],[11,"drop","","",137,[[["self"]]]],[11,"drop","","",138,[[["self"]]]],[11,"call_once","alloc::boxed","",7,[[["self"],["a"]],["r"]]],[11,"call_once","","",7,[[["self"],["a"]],["r"]]],[11,"resume","","",7,[[["self"]],["generatorstate"]]],[11,"index","alloc::collections::btree_map","Returns a reference to the value corresponding to the supplied key.",56,[[["self"],["q"]],["v"]]],[11,"index","alloc::collections::vec_deque","",13,[[["self"],["usize"]],["a"]]],[11,"index","alloc::string","",42,[[["self"],["range",["usize"]]],["str"]]],[11,"index","","",42,[[["self"],["rangeto",["usize"]]],["str"]]],[11,"index","","",42,[[["self"],["rangefrom",["usize"]]],["str"]]],[11,"index","","",42,[[["self"],["rangefull"]],["str"]]],[11,"index","","",42,[[["self"],["rangeinclusive",["usize"]]],["str"]]],[11,"index","","",42,[[["self"],["rangetoinclusive",["usize"]]],["str"]]],[11,"index","alloc::vec","",44,N],[11,"index_mut","alloc::collections::vec_deque","",13,[[["self"],["usize"]],["a"]]],[11,"index_mut","alloc::string","",42,[[["self"],["range",["usize"]]],["str"]]],[11,"index_mut","","",42,[[["self"],["rangeto",["usize"]]],["str"]]],[11,"index_mut","","",42,[[["self"],["rangefrom",["usize"]]],["str"]]],[11,"index_mut","","",42,[[["self"],["rangefull"]],["str"]]],[11,"index_mut","","",42,[[["self"],["rangeinclusive",["usize"]]],["str"]]],[11,"index_mut","","",42,[[["self"],["rangetoinclusive",["usize"]]],["str"]]],[11,"index_mut","alloc::vec","",44,N],[11,"finish","alloc::boxed","",7,[[["self"]],["u64"]]],[11,"write","","",7,N],[11,"write_u8","","",7,[[["self"],["u8"]]]],[11,"write_u16","","",7,[[["self"],["u16"]]]],[11,"write_u32","","",7,[[["self"],["u32"]]]],[11,"write_u64","","",7,[[["self"],["u64"]]]],[11,"write_u128","","",7,[[["self"],["u128"]]]],[11,"write_usize","","",7,[[["self"],["usize"]]]],[11,"write_i8","","",7,[[["self"],["i8"]]]],[11,"write_i16","","",7,[[["self"],["i16"]]]],[11,"write_i32","","",7,[[["self"],["i32"]]]],[11,"write_i64","","",7,[[["self"],["i64"]]]],[11,"write_i128","","",7,[[["self"],["i128"]]]],[11,"write_isize","","",7,[[["self"],["isize"]]]],[11,"hash","","",7,[[["self"],["h"]]]],[11,"hash","alloc::collections::btree_map","",56,[[["self"],["h"]]]],[11,"hash","alloc::collections::btree_set","",67,N],[11,"hash","alloc::collections::linked_list","",11,[[["self"],["h"]]]],[11,"hash","alloc::collections::vec_deque","",13,[[["self"],["h"]]]],[11,"hash","alloc::sync","",15,[[["self"],["h"]]]],[11,"hash","alloc::rc","",17,[[["self"],["h"]]]],[11,"hash","alloc::borrow","",21,[[["self"],["h"]]]],[11,"hash","alloc::string","",42,[[["self"],["h"]]]],[11,"hash","alloc::vec","",44,[[["self"],["h"]]]],[11,"into_iter","alloc::collections::binary_heap","Creates a consuming iterator, that is, one that moves each value out of the binary heap in arbitrary order. The binary heap cannot be used after calling this.",10,[[["self"]],["intoiter"]]],[11,"into_iter","alloc::collections::btree_map","",56,[[["self"]],["intoiter"]]],[11,"into_iter","alloc::collections::btree_set","Gets an iterator for moving out the `BTreeSet`'s contents.",67,[[["self"]],["intoiter"]]],[11,"into_iter","alloc::collections::linked_list","Consumes the list into an iterator yielding elements by value.",11,[[["self"]],["intoiter"]]],[11,"into_iter","alloc::collections::vec_deque","Consumes the `VecDeque` into a front-to-back iterator yielding elements by value.",13,[[["self"]],["intoiter"]]],[11,"into_iter","alloc::vec","Creates a consuming iterator, that is, one that moves each value out of the vector (from start to end). The vector cannot be used after calling this.",44,[[["self"]],["intoiter"]]],[11,"extend","alloc::collections::binary_heap","",10,[[["self"],["i"]]]],[11,"extend","","",10,[[["self"],["i"]]]],[11,"extend","alloc::collections::btree_map","",56,[[["self"],["t"]]]],[11,"extend","","",56,[[["self"],["i"]]]],[11,"extend","alloc::collections::btree_set","",67,[[["self"],["iter"]]]],[11,"extend","","",67,[[["self"],["i"]]]],[11,"extend","alloc::collections::linked_list","",11,[[["self"],["i"]]]],[11,"extend","","",11,[[["self"],["i"]]]],[11,"extend","alloc::collections::vec_deque","",13,[[["self"],["t"]]]],[11,"extend","","",13,[[["self"],["i"]]]],[11,"extend","alloc::string","",42,[[["self"],["i"]]]],[11,"extend","","",42,[[["self"],["i"]]]],[11,"extend","","",42,[[["self"],["i"]]]],[11,"extend","","",42,[[["self"],["i"]]]],[11,"extend","","",42,[[["self"],["i"]]]],[11,"extend","alloc::vec","",44,[[["self"],["i"]]]],[11,"extend","","",44,[[["self"],["i"]]]],[11,"next","alloc::boxed","",7,[[["self"]],["option"]]],[11,"size_hint","","",7,N],[11,"nth","","",7,[[["self"],["usize"]],["option"]]],[11,"next","alloc::collections::binary_heap","",53,[[["self"]],["option"]]],[11,"size_hint","","",53,N],[11,"next","","",54,[[["self"]],["option"]]],[11,"size_hint","","",54,N],[11,"next","","",55,[[["self"]],["option"]]],[11,"size_hint","","",55,N],[11,"next","alloc::collections::btree_map","",57,[[["self"]],["option"]]],[11,"size_hint","","",57,N],[11,"next","","",58,[[["self"]],["option"]]],[11,"size_hint","","",58,N],[11,"next","","",59,[[["self"]],["option"]]],[11,"size_hint","","",59,N],[11,"next","","",60,[[["self"]],["option"]]],[11,"size_hint","","",60,N],[11,"next","","",61,[[["self"]],["option"]]],[11,"size_hint","","",61,N],[11,"next","","",63,[[["self"]],["option"]]],[11,"next","","",62,[[["self"]],["option"]]],[11,"size_hint","","",62,N],[11,"next","","",64,[[["self"]],["option"]]],[11,"next","alloc::collections::btree_set","",68,[[["self"]],["option"]]],[11,"size_hint","","",68,N],[11,"next","","",69,[[["self"]],["option"]]],[11,"size_hint","","",69,N],[11,"next","","",70,[[["self"]],["option"]]],[11,"next","","",71,[[["self"]],["option"]]],[11,"size_hint","","",71,N],[11,"next","","",72,[[["self"]],["option"]]],[11,"size_hint","","",72,N],[11,"next","","",73,[[["self"]],["option"]]],[11,"size_hint","","",73,N],[11,"next","","",74,[[["self"]],["option"]]],[11,"size_hint","","",74,N],[11,"next","alloc::collections::linked_list","",75,[[["self"]],["option"]]],[11,"size_hint","","",75,N],[11,"next","","",12,[[["self"]],["option"]]],[11,"size_hint","","",12,N],[11,"next","","",77,[[["self"]],["option"]]],[11,"size_hint","","",77,N],[11,"next","","",76,[[["self"]],["option"]]],[11,"size_hint","","",76,N],[11,"next","alloc::collections::vec_deque","",78,[[["self"]],["option"]]],[11,"size_hint","","",78,N],[11,"fold","","",78,[[["self"],["acc"],["f"]],["acc"]]],[11,"next","","",79,[[["self"]],["option"]]],[11,"size_hint","","",79,N],[11,"fold","","",79,[[["self"],["acc"],["f"]],["acc"]]],[11,"next","","",80,[[["self"]],["option"]]],[11,"size_hint","","",80,N],[11,"next","","",81,[[["self"]],["option"]]],[11,"size_hint","","",81,N],[11,"next","alloc::string","",134,[[["self"]],["option",["char"]]]],[11,"size_hint","","",134,N],[11,"next","alloc::vec","",45,[[["self"]],["option"]]],[11,"size_hint","","",45,N],[11,"count","","",45,[[["self"]],["usize"]]],[11,"next","","",136,[[["self"]],["option"]]],[11,"size_hint","","",136,N],[11,"next","","",137,[[["self"]],["option"]]],[11,"size_hint","","",137,N],[11,"next","","",138,[[["self"]],["option"]]],[11,"size_hint","","",138,N],[11,"len","alloc::boxed","",7,[[["self"]],["usize"]]],[11,"is_empty","","",7,[[["self"]],["bool"]]],[11,"is_empty","alloc::collections::binary_heap","",53,[[["self"]],["bool"]]],[11,"is_empty","","",54,[[["self"]],["bool"]]],[11,"is_empty","","",55,[[["self"]],["bool"]]],[11,"len","alloc::collections::btree_map","",57,[[["self"]],["usize"]]],[11,"len","","",58,[[["self"]],["usize"]]],[11,"len","","",59,[[["self"]],["usize"]]],[11,"len","","",60,[[["self"]],["usize"]]],[11,"len","","",61,[[["self"]],["usize"]]],[11,"len","","",62,[[["self"]],["usize"]]],[11,"len","alloc::collections::btree_set","",68,[[["self"]],["usize"]]],[11,"len","","",69,[[["self"]],["usize"]]],[11,"is_empty","alloc::collections::vec_deque","",78,[[["self"]],["bool"]]],[11,"is_empty","","",79,[[["self"]],["bool"]]],[11,"is_empty","","",80,[[["self"]],["bool"]]],[11,"is_empty","alloc::vec","",45,[[["self"]],["bool"]]],[11,"is_empty","","",136,[[["self"]],["bool"]]],[11,"from_iter","alloc::collections::binary_heap","",10,[[["i"]],["binaryheap"]]],[11,"from_iter","alloc::collections::btree_map","",56,[[["t"]],["btreemap"]]],[11,"from_iter","alloc::collections::btree_set","",67,[[["i"]],["btreeset"]]],[11,"from_iter","alloc::collections::linked_list","",11,[[["i"]],["self"]]],[11,"from_iter","alloc::collections::vec_deque","",13,[[["t"]],["vecdeque"]]],[11,"from_iter","alloc::string","",42,[[["i"]],["string"]]],[11,"from_iter","","",42,[[["i"]],["string"]]],[11,"from_iter","","",42,[[["i"]],["string"]]],[11,"from_iter","","",42,[[["i"]],["string"]]],[11,"from_iter","","",42,[[["i"]],["string"]]],[11,"from_iter","alloc::borrow","",21,[[["i"]],["cow",["str"]]]],[11,"from_iter","","",21,[[["i"]],["cow",["str"]]]],[11,"from_iter","","",21,[[["i"]],["cow",["str"]]]],[11,"from_iter","alloc::vec","",44,[[["i"]],["vec"]]],[11,"from_iter","alloc::borrow","",21,[[["i"]],["cow"]]],[11,"next_back","alloc::boxed","",7,[[["self"]],["option"]]],[11,"next_back","alloc::collections::binary_heap","",53,[[["self"]],["option"]]],[11,"next_back","","",54,[[["self"]],["option"]]],[11,"next_back","","",55,[[["self"]],["option"]]],[11,"next_back","alloc::collections::btree_map","",57,[[["self"]],["option"]]],[11,"next_back","","",58,[[["self"]],["option"]]],[11,"next_back","","",59,[[["self"]],["option"]]],[11,"next_back","","",60,[[["self"]],["option"]]],[11,"next_back","","",61,[[["self"]],["option"]]],[11,"next_back","","",62,[[["self"]],["option"]]],[11,"next_back","","",63,[[["self"]],["option"]]],[11,"next_back","","",64,[[["self"]],["option"]]],[11,"next_back","alloc::collections::btree_set","",68,[[["self"]],["option"]]],[11,"next_back","","",69,[[["self"]],["option"]]],[11,"next_back","","",70,[[["self"]],["option"]]],[11,"next_back","alloc::collections::linked_list","",75,[[["self"]],["option"]]],[11,"next_back","","",12,[[["self"]],["option"]]],[11,"next_back","","",76,[[["self"]],["option"]]],[11,"next_back","alloc::collections::vec_deque","",78,[[["self"]],["option"]]],[11,"rfold","","",78,[[["self"],["acc"],["f"]],["acc"]]],[11,"next_back","","",79,[[["self"]],["option"]]],[11,"rfold","","",79,[[["self"],["acc"],["f"]],["acc"]]],[11,"next_back","","",80,[[["self"]],["option"]]],[11,"next_back","","",81,[[["self"]],["option"]]],[11,"next_back","alloc::string","",134,[[["self"]],["option",["char"]]]],[11,"next_back","alloc::vec","",45,[[["self"]],["option"]]],[11,"next_back","","",136,[[["self"]],["option"]]],[11,"next_back","","",137,[[["self"]],["option"]]],[11,"write_str","alloc::string","",42,[[["self"],["str"]],["result"]]],[11,"write_char","","",42,[[["self"],["char"]],["result"]]],[11,"from_str","","",42,[[["str"]],["result",["string","parseerror"]]]],[11,"fmt","alloc::boxed","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::sync","",15,[[["self"],["formatter"]],["result"]]],[11,"fmt","alloc::rc","",17,[[["self"],["formatter"]],["result"]]],[11,"from","alloc::task","",52,[[["arc"]],["self"]]],[11,"from","alloc::boxed","",7,[[["t"]],["self"]]],[11,"from","","",7,N],[11,"from","","",7,[[["str"]],["box",["str"]]]],[11,"from","","",7,[[["box",["str"]]],["self"]]],[11,"from","alloc::collections::binary_heap","",10,[[["vec"]],["binaryheap"]]],[11,"from","alloc::vec","",44,[[["binaryheap"]],["vec"]]],[11,"from","alloc::collections::vec_deque","",13,[[["vec"]],["self"]]],[11,"from","alloc::vec","",44,[[["vecdeque"]],["self"]]],[11,"from","alloc::collections","",8,[[["allocerr"]],["self"]]],[11,"from","","",8,[[["layouterr"]],["self"]]],[11,"from","alloc::sync","",15,[[["t"]],["self"]]],[11,"from","","",15,N],[11,"from","","",15,[[["str"]],["arc",["str"]]]],[11,"from","","",15,[[["string"]],["arc",["str"]]]],[11,"from","","",15,[[["box"]],["arc"]]],[11,"from","","",15,[[["vec"]],["arc"]]],[11,"from","alloc::rc","",17,[[["t"]],["self"]]],[11,"from","","",17,N],[11,"from","","",17,[[["str"]],["rc",["str"]]]],[11,"from","","",17,[[["string"]],["rc",["str"]]]],[11,"from","","",17,[[["box"]],["rc"]]],[11,"from","","",17,[[["vec"]],["rc"]]],[11,"from","alloc::string","",42,[[["str"]],["string"]]],[11,"from","","",42,[[["box",["str"]]],["string"]]],[11,"from","alloc::boxed","",7,[[["string"]],["box",["str"]]]],[11,"from","alloc::string","",42,[[["cow",["str"]]],["string"]]],[11,"from","alloc::borrow","",21,[[["str"]],["cow",["str"]]]],[11,"from","","",21,[[["string"]],["cow",["str"]]]],[11,"from","","",21,[[["string"]],["cow",["str"]]]],[11,"from","alloc::vec","",44,[[["string"]],["vec",["u8"]]]],[11,"from","","",44,N],[11,"from","","",44,N],[11,"from","","",44,[[["cow"]],["vec"]]],[11,"from","","",44,[[["box"]],["vec"]]],[11,"from","alloc::boxed","",7,[[["vec"]],["box"]]],[11,"from","alloc::vec","",44,[[["str"]],["vec",["u8"]]]],[11,"from","alloc::borrow","",21,N],[11,"from","","",21,[[["vec"]],["cow"]]],[11,"from","","",21,[[["vec"]],["cow"]]],[11,"clone","alloc::alloc","",50,[[["self"]],["global"]]],[11,"clone","alloc::boxed","Returns a new box with a `clone()` of this box's contents.",7,[[["self"]],["box"]]],[11,"clone_from","","Copies `source`'s contents into `self` without creating a new allocation.",7,[[["self"],["box"]]]],[11,"clone","","",7,[[["self"]],["self"]]],[11,"clone","","",7,[[["self"]],["self"]]],[11,"clone","alloc::collections::binary_heap","",10,[[["self"]],["self"]]],[11,"clone_from","","",10,[[["self"],["self"]]]],[11,"clone","","",53,[[["self"]],["iter"]]],[11,"clone","","",54,[[["self"]],["intoiter"]]],[11,"clone","alloc::collections::btree_map","",56,[[["self"]],["btreemap"]]],[11,"clone","","",57,[[["self"]],["iter"]]],[11,"clone","","",60,[[["self"]],["keys"]]],[11,"clone","","",61,[[["self"]],["values"]]],[11,"clone","","",63,[[["self"]],["range"]]],[11,"clone","alloc::collections::btree_set","",67,[[["self"]],["btreeset"]]],[11,"clone","","",68,[[["self"]],["iter"]]],[11,"clone","","",70,[[["self"]],["range"]]],[11,"clone","","",71,[[["self"]],["difference"]]],[11,"clone","","",72,[[["self"]],["symmetricdifference"]]],[11,"clone","","",73,[[["self"]],["intersection"]]],[11,"clone","","",74,[[["self"]],["union"]]],[11,"clone","alloc::collections::linked_list","",75,[[["self"]],["self"]]],[11,"clone","","",76,[[["self"]],["intoiter"]]],[11,"clone","","",11,[[["self"]],["self"]]],[11,"clone","alloc::collections::vec_deque","",13,[[["self"]],["vecdeque"]]],[11,"clone","","",78,[[["self"]],["iter"]]],[11,"clone","","",80,[[["self"]],["intoiter"]]],[11,"clone","alloc::collections","",8,[[["self"]],["collectionallocerr"]]],[11,"clone","alloc::sync","Makes a clone of the `Arc` pointer.",15,[[["self"]],["arc"]]],[11,"clone","","Makes a clone of the `Weak` pointer that points to the same value.",16,[[["self"]],["weak"]]],[11,"clone","alloc::rc","Makes a clone of the `Rc` pointer.",17,[[["self"]],["rc"]]],[11,"clone","","Makes a clone of the `Weak` pointer that points to the same value.",18,[[["self"]],["weak"]]],[11,"clone","alloc::borrow","",21,[[["self"]],["cow"]]],[11,"clone_from","","",21,[[["self"],["cow"]]]],[11,"clone","alloc::string","",42,[[["self"]],["self"]]],[11,"clone_from","","",42,[[["self"],["self"]]]],[11,"clone","","",135,[[["self"]],["parseerror"]]],[11,"clone","alloc::vec","",44,[[["self"]],["vec"]]],[11,"clone_from","","",44,[[["self"],["vec"]]]],[11,"clone","","",45,[[["self"]],["intoiter"]]],[11,"as_ref","alloc::boxed","",7,[[["self"]],["t"]]],[11,"as_ref","alloc::sync","",15,[[["self"]],["t"]]],[11,"as_ref","alloc::rc","",17,[[["self"]],["t"]]],[11,"as_ref","alloc::borrow","",21,[[["self"]],["t"]]],[11,"as_ref","alloc::string","",42,[[["self"]],["str"]]],[11,"as_ref","","",42,N],[11,"as_ref","alloc::vec","",44,[[["self"]],["vec"]]],[11,"as_ref","","",44,N],[11,"default","alloc::alloc","",50,[[],["global"]]],[11,"default","alloc::boxed","Creates a `Box<T>`, with the `Default` value for T.",7,[[],["box"]]],[11,"default","","",7,[[],["box"]]],[11,"default","","",7,[[],["box",["str"]]]],[11,"default","alloc::collections::binary_heap","Creates an empty `BinaryHeap<T>`.",10,[[],["binaryheap"]]],[11,"default","alloc::collections::btree_map","Creates an empty `BTreeMap<K, V>`.",56,[[],["btreemap"]]],[11,"default","alloc::collections::btree_set","Makes an empty `BTreeSet<T>` with a reasonable choice of B.",67,[[],["btreeset"]]],[11,"default","alloc::collections::linked_list","Creates an empty `LinkedList<T>`.",11,[[],["self"]]],[11,"default","alloc::collections::vec_deque","Creates an empty `VecDeque<T>`.",13,[[],["vecdeque"]]],[11,"default","alloc::sync","Constructs a new `Weak<T>`, without allocating memory. Calling [`upgrade`][Weak::upgrade] on the return value always gives [`None`].",16,[[],["weak"]]],[11,"default","","Creates a new `Arc<T>`, with the `Default` value for `T`.",15,[[],["arc"]]],[11,"default","alloc::rc","Creates a new `Rc<T>`, with the `Default` value for `T`.",17,[[],["rc"]]],[11,"default","","Constructs a new `Weak<T>`, allocating memory for `T` without initializing it. Calling [`upgrade`][Weak::upgrade] on the return value always gives [`None`].",18,[[],["weak"]]],[11,"default","alloc::borrow","Creates an owned Cow<'a, B> with the default value for the contained owned value.",21,[[],["cow"]]],[11,"default","alloc::string","Creates an empty `String`.",42,[[],["string"]]],[11,"default","alloc::vec","Creates an empty `Vec<T>`.",44,[[],["vec"]]],[11,"as_mut","alloc::boxed","",7,[[["self"]],["t"]]],[11,"as_mut","alloc::vec","",44,[[["self"]],["vec"]]],[11,"as_mut","","",44,N],[11,"borrow","alloc::boxed","",7,[[["self"]],["t"]]],[11,"borrow","alloc::sync","",15,[[["self"]],["t"]]],[11,"borrow","alloc::rc","",17,[[["self"]],["t"]]],[11,"borrow","alloc::borrow","",21,[[["self"]],["b"]]],[11,"borrow","alloc::vec","",44,N],[11,"borrow","alloc::string","",42,[[["self"]],["str"]]],[11,"borrow_mut","alloc::boxed","",7,[[["self"]],["t"]]],[11,"borrow_mut","alloc::vec","",44,N],[11,"poll","alloc::boxed","",7,[[["pin"],["localwaker"]],["poll"]]],[11,"alloc","alloc::alloc","",50,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[11,"dealloc","","",50,[[["self"],["nonnull",["u8"]],["layout"]]]],[11,"realloc","","",50,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"alloc_zeroed","","",50,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[11,"from_size_align","","Constructs a `Layout` from a given `size` and `align`, or returns `LayoutErr` if either of the following conditions are not met:",46,[[["usize"],["usize"]],["result",["layout","layouterr"]]]],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",46,[[["usize"],["usize"]],["layout"]]],[11,"size","","The minimum size in bytes for a memory block of this layout.",46,[[["self"]],["usize"]]],[11,"align","","The minimum byte alignment for a memory block of this layout.",46,[[["self"]],["usize"]]],[11,"new","","Constructs a `Layout` suitable for holding a value of type `T`.",46,[[],["layout"]]],[11,"for_value","","Produces layout describing a record that could be used to allocate backing structure for `T` (which could be a trait or other unsized type like a slice).",46,[[["t"]],["layout"]]],[11,"align_to","","Creates a layout describing the record that can hold a value of the same layout as `self`, but that also is aligned to alignment `align` (measured in bytes).",46,[[["self"],["usize"]],["layout"]]],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self` to ensure that the following address will satisfy `align` (measured in bytes).",46,[[["self"],["usize"]],["usize"]]],[11,"repeat","","Creates a layout describing the record for `n` instances of `self`, with a suitable amount of padding between each to ensure that each instance is given its requested size and alignment. On success, returns `(k, offs)` where `k` is the layout of the array and `offs` is the distance between the start of each element in the array.",46,[[["self"],["usize"]],["result",["layouterr"]]]],[11,"extend","","Creates a layout describing the record for `self` followed by `next`, including any necessary padding to ensure that `next` will be properly aligned. Note that the result layout will satisfy the alignment properties of both `self` and `next`.",46,[[["self"],["layout"]],["result",["layouterr"]]]],[11,"repeat_packed","","Creates a layout describing the record for `n` instances of `self`, with no padding between each instance.",46,[[["self"],["usize"]],["result",["layout","layouterr"]]]],[11,"extend_packed","","Creates a layout describing the record for `self` followed by `next` with no additional padding between the two. Since no padding is inserted, the alignment of `next` is irrelevant, and is not incorporated at all into the resulting layout.",46,[[["self"],["layout"]],["result",["layouterr"]]]],[11,"array","","Creates a layout describing the record for a `[T; n]`.",46,[[["usize"]],["result",["layout","layouterr"]]]],[11,"description","","",49,[[["self"]],["str"]]],[11,"new","alloc::task","Constructs a new `LocalWaker` directly.",51,[[["nonnull",["unsafewake"]]],["localwaker"]]],[11,"as_waker","","Borrows this `LocalWaker` as a `Waker`.",51,[[["self"]],["waker"]]],[11,"into_waker","","Converts this `LocalWaker` into a `Waker`.",51,[[["self"]],["waker"]]],[11,"wake","","Wake up the task associated with this `LocalWaker`.",51,N],[11,"will_wake","","Returns whether or not this `LocalWaker` and `other` `LocalWaker` awaken the same task.",51,[[["self"],["localwaker"]],["bool"]]],[11,"will_wake_nonlocal","","Returns whether or not this `LocalWaker` and `other` `Waker` awaken the same task.",51,[[["self"],["waker"]],["bool"]]],[11,"map","","Change the ready value of this `Poll` with the closure provided",4,[[["self"],["f"]],["poll"]]],[11,"is_ready","","Returns whether this is `Poll::Ready`",4,[[["self"]],["bool"]]],[11,"is_pending","","Returns whether this is `Poll::Pending`",4,[[["self"]],["bool"]]],[11,"map_ok","","Change the success value of this `Poll` with the closure provided",4,[[["self"],["f"]],["poll",["result"]]]],[11,"map_err","","Change the error value of this `Poll` with the closure provided",4,[[["self"],["f"]],["poll",["result"]]]],[11,"new","","Constructs a new `Waker` directly.",52,[[["nonnull",["unsafewake"]]],["waker"]]],[11,"wake","","Wake up the task associated with this `Waker`.",52,N],[11,"will_wake","","Returns whether or not this `Waker` and `other` awaken the same task.",52,[[["self"],["waker"]],["bool"]]],[11,"will_wake_local","","Returns whether or not this `Waker` and `other` `LocalWaker` awaken the same task.",52,[[["self"],["localwaker"]],["bool"]]],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is like `wake`, but can only be called from the thread on which this `Wake` was created.",5,[[["arc"]]]],[11,"new","alloc::collections::btree_map","Makes a new empty BTreeMap with a reasonable choice for B.",56,[[],["btreemap"]]],[11,"clear","","Clears the map, removing all values.",56,[[["self"]]]],[11,"get","","Returns a reference to the value corresponding to the key.",56,[[["self"],["q"]],["option"]]],[11,"get_key_value","","Returns the key-value pair corresponding to the supplied key.",56,[[["self"],["q"]],["option"]]],[11,"contains_key","","Returns `true` if the map contains a value for the specified key.",56,[[["self"],["q"]],["bool"]]],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",56,[[["self"],["q"]],["option"]]],[11,"insert","","Inserts a key-value pair into the map.",56,[[["self"],["k"],["v"]],["option"]]],[11,"remove","","Removes a key from the map, returning the value at the key if the key was previously in the map.",56,[[["self"],["q"]],["option"]]],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",56,[[["self"],["self"]]]],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",56,[[["self"],["r"]],["range"]]],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",56,[[["self"],["r"]],["rangemut"]]],[11,"entry","","Gets the given key's corresponding entry in the map for in-place manipulation.",56,[[["self"],["k"]],["entry"]]],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",56,[[["self"],["q"]],["self"]]],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",56,[[["self"]],["iter"]]],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",56,[[["self"]],["itermut"]]],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",56,[[["self"]],["keys"]]],[11,"values","","Gets an iterator over the values of the map, in order by key.",56,[[["self"]],["values"]]],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",56,[[["self"]],["valuesmut"]]],[11,"len","","Returns the number of elements in the map.",56,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the map contains no elements.",56,[[["self"]],["bool"]]],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns a mutable reference to the value in the entry.",14,[[["self"],["v"]],["v"]]],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty, and returns a mutable reference to the value in the entry.",14,[[["self"],["f"]],["v"]]],[11,"key","","Returns a reference to this entry's key.",14,[[["self"]],["k"]]],[11,"and_modify","","Provides in-place mutable access to an occupied entry before any potential inserts into the map.",14,[[["self"],["f"]],["self"]]],[11,"or_default","","Ensures a value is in the entry by inserting the default value if empty, and returns a mutable reference to the value in the entry.",14,[[["self"]],["v"]]],[11,"key","","Gets a reference to the key that would be used when inserting a value through the VacantEntry.",65,[[["self"]],["k"]]],[11,"into_key","","Take ownership of the key.",65,[[["self"]],["k"]]],[11,"insert","","Sets the value of the entry with the `VacantEntry`'s key, and returns a mutable reference to it.",65,[[["self"],["v"]],["v"]]],[11,"key","","Gets a reference to the key in the entry.",66,[[["self"]],["k"]]],[11,"remove_entry","","Take ownership of the key and value from the map.",66,N],[11,"get","","Gets a reference to the value in the entry.",66,[[["self"]],["v"]]],[11,"get_mut","","Gets a mutable reference to the value in the entry.",66,[[["self"]],["v"]]],[11,"into_mut","","Converts the entry into a mutable reference to its value.",66,[[["self"]],["v"]]],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`'s key, and returns the entry's old value.",66,[[["self"],["v"]],["v"]]],[11,"remove","","Takes the value of the entry out of the map, and returns it.",66,[[["self"]],["v"]]],[11,"new","alloc::collections::btree_set","Makes a new `BTreeSet` with a reasonable choice of B.",67,[[],["btreeset"]]],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set. The simplest way is to use the range syntax `min..max`, thus `range(min..max)` will yield elements from min (inclusive) to max (exclusive). The range may also be entered as `(Bound<T>, Bound<T>)`, so for example `range((Excluded(4), Included(10)))` will yield a left-exclusive, right-inclusive range from 4 to 10.",67,[[["self"],["r"]],["range"]]],[11,"difference","","Visits the values representing the difference, i.e. the values that are in `self` but not in `other`, in ascending order.",67,[[["self"],["btreeset"]],["difference"]]],[11,"symmetric_difference","","Visits the values representing the symmetric difference, i.e. the values that are in `self` or in `other` but not in both, in ascending order.",67,[[["self"],["btreeset"]],["symmetricdifference"]]],[11,"intersection","","Visits the values representing the intersection, i.e. the values that are both in `self` and `other`, in ascending order.",67,[[["self"],["btreeset"]],["intersection"]]],[11,"union","","Visits the values representing the union, i.e. all the values in `self` or `other`, without duplicates, in ascending order.",67,[[["self"],["btreeset"]],["union"]]],[11,"clear","","Clears the set, removing all values.",67,[[["self"]]]],[11,"contains","","Returns `true` if the set contains a value.",67,[[["self"],["q"]],["bool"]]],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",67,[[["self"],["q"]],["option"]]],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with `other`. This is equivalent to checking for an empty intersection.",67,[[["self"],["btreeset"]],["bool"]]],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e. `other` contains at least all the values in `self`.",67,[[["self"],["btreeset"]],["bool"]]],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e. `self` contains at least all the values in `other`.",67,[[["self"],["btreeset"]],["bool"]]],[11,"insert","","Adds a value to the set.",67,[[["self"],["t"]],["bool"]]],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given one. Returns the replaced value.",67,[[["self"],["t"]],["option"]]],[11,"remove","","Removes a value from the set. Returns `true` if the value was present in the set.",67,[[["self"],["q"]],["bool"]]],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",67,[[["self"],["q"]],["option"]]],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",67,[[["self"],["self"]]]],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key, including the key.",67,[[["self"],["q"]],["self"]]],[11,"iter","","Gets an iterator that visits the values in the `BTreeSet` in ascending order.",67,[[["self"]],["iter"]]],[11,"len","","Returns the number of elements in the set.",67,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the set contains no elements.",67,[[["self"]],["bool"]]],[11,"pad_integral","alloc::fmt","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",82,[[["self"],["bool"],["str"],["str"]],["result",["error"]]]],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",82,[[["self"],["str"]],["result",["error"]]]],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",82,[[["self"],["str"]],["result",["error"]]]],[11,"write_fmt","","Writes some formatted information into this instance.",82,[[["self"],["arguments"]],["result",["error"]]]],[11,"flags","","Flags for formatting",82,[[["self"]],["u32"]]],[11,"fill","","Character used as 'fill' whenever there is alignment.",82,[[["self"]],["char"]]],[11,"align","","Flag indicating what form of alignment was requested.",82,[[["self"]],["option",["alignment"]]]],[11,"width","","Optionally specified integer width that the output should be.",82,[[["self"]],["option",["usize"]]]],[11,"precision","","Optionally specified precision for numeric types.",82,[[["self"]],["option",["usize"]]]],[11,"sign_plus","","Determines if the `+` flag was specified.",82,[[["self"]],["bool"]]],[11,"sign_minus","","Determines if the `-` flag was specified.",82,[[["self"]],["bool"]]],[11,"alternate","","Determines if the `#` flag was specified.",82,[[["self"]],["bool"]]],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",82,[[["self"]],["bool"]]],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",82,[[["self"],["str"]],["debugstruct"]]],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",82,[[["self"],["str"]],["debugtuple"]]],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",82,[[["self"]],["debuglist"]]],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",82,[[["self"]],["debugset"]]],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",82,[[["self"]],["debugmap"]]],[11,"entry","","Adds a new entry to the list output.",85,[[["self"],["debug"]],["debuglist"]]],[11,"entries","","Adds the contents of an iterator of entries to the list output.",85,[[["self"],["i"]],["debuglist"]]],[11,"finish","","Finishes output and returns any error encountered.",85,[[["self"]],["result",["error"]]]],[11,"entry","","Adds a new entry to the map output.",86,[[["self"],["debug"],["debug"]],["debugmap"]]],[11,"entries","","Adds the contents of an iterator of entries to the map output.",86,[[["self"],["i"]],["debugmap"]]],[11,"finish","","Finishes output and returns any error encountered.",86,[[["self"]],["result",["error"]]]],[11,"entry","","Adds a new entry to the set output.",87,[[["self"],["debug"]],["debugset"]]],[11,"entries","","Adds the contents of an iterator of entries to the set output.",87,[[["self"],["i"]],["debugset"]]],[11,"finish","","Finishes output and returns any error encountered.",87,[[["self"]],["result",["error"]]]],[11,"field","","Adds a new field to the generated struct output.",88,[[["self"],["str"],["debug"]],["debugstruct"]]],[11,"finish","","Finishes output and returns any error encountered.",88,[[["self"]],["result",["error"]]]],[11,"field","","Adds a new field to the generated tuple struct output.",89,[[["self"],["debug"]],["debugtuple"]]],[11,"finish","","Finishes output and returns any error encountered.",89,[[["self"]],["result",["error"]]]],[11,"as_slice","alloc::slice","View the underlying data as a subslice of the original data.",92,N],[11,"into_slice","","View the underlying data as a subslice of the original data.",93,N],[11,"remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",103,N],[11,"into_remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",104,N],[11,"remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",107,N],[11,"into_remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",108,N],[11,"valid_up_to","alloc::str","Returns the index in the given string up to which valid UTF-8 was verified.",109,[[["self"]],["usize"]]],[11,"error_len","","Provide more information about the failure:",109,[[["self"]],["option",["usize"]]]],[11,"as_str","","View the underlying data as a subslice of the original data.",122,[[["self"]],["str"]]],[11,"as_str","","View the underlying data as a subslice of the original data.",123,[[["self"]],["str"]]]],"paths":[[3,"Excess"],[8,"GlobalAlloc"],[8,"Alloc"],[8,"UnsafeWake"],[4,"Poll"],[8,"Wake"],[8,"FnBox"],[3,"Box"],[4,"CollectionAllocErr"],[3,"PeekMut"],[3,"BinaryHeap"],[3,"LinkedList"],[3,"IterMut"],[3,"VecDeque"],[4,"Entry"],[3,"Arc"],[3,"Weak"],[3,"Rc"],[3,"Weak"],[8,"Borrow"],[8,"BorrowMut"],[4,"Cow"],[8,"ToOwned"],[8,"Write"],[8,"Binary"],[8,"Octal"],[8,"Debug"],[8,"Display"],[8,"LowerHex"],[8,"Pointer"],[8,"UpperHex"],[8,"LowerExp"],[8,"UpperExp"],[4,"Alignment"],[8,"SliceIndex"],[8,"SliceConcatExt"],[8,"FromStr"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[8,"ToString"],[3,"String"],[3,"FromUtf8Error"],[3,"Vec"],[3,"IntoIter"],[3,"Layout"],[3,"LayoutErr"],[3,"AllocErr"],[3,"CannotReallocInPlace"],[3,"Global"],[3,"LocalWaker"],[3,"Waker"],[3,"Iter"],[3,"IntoIter"],[3,"Drain"],[3,"BTreeMap"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"ValuesMut"],[3,"Range"],[3,"RangeMut"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"Iter"],[3,"IntoIter"],[3,"DrainFilter"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Drain"],[3,"Formatter"],[3,"Error"],[3,"Arguments"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"Chunks"],[3,"Windows"],[3,"Iter"],[3,"IterMut"],[3,"SplitMut"],[3,"ChunksMut"],[3,"Split"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"RSplit"],[3,"RSplitMut"],[3,"ChunksExact"],[3,"ChunksExactMut"],[3,"RChunks"],[3,"RChunksMut"],[3,"RChunksExact"],[3,"RChunksExactMut"],[3,"Utf8Error"],[3,"Lines"],[3,"LinesAny"],[3,"Split"],[3,"RSplit"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"Matches"],[3,"RMatches"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Chars"],[3,"CharIndices"],[3,"Bytes"],[3,"ParseBoolError"],[3,"SplitWhitespace"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"EncodeUtf16"],[3,"SplitAsciiWhitespace"],[3,"FromUtf16Error"],[3,"Drain"],[4,"ParseError"],[3,"Drain"],[3,"Splice"],[3,"DrainFilter"]]};
searchIndex["core"]={"doc":"The Rust Core Library","items":[[0,"isize","core","The pointer-sized signed integer type.",N,N],[17,"MIN","core::isize","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i8","core","The 8-bit signed integer type.",N,N],[17,"MIN","core::i8","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i16","core","The 16-bit signed integer type.",N,N],[17,"MIN","core::i16","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i32","core","The 32-bit signed integer type.",N,N],[17,"MIN","core::i32","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i64","core","The 64-bit signed integer type.",N,N],[17,"MIN","core::i64","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"i128","core","The 128-bit signed integer type.",N,N],[17,"MIN","core::i128","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"usize","core","The pointer-sized unsigned integer type.",N,N],[17,"MIN","core::usize","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u8","core","The 8-bit unsigned integer type.",N,N],[17,"MIN","core::u8","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u16","core","The 16-bit unsigned integer type.",N,N],[17,"MIN","core::u16","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u32","core","The 32-bit unsigned integer type.",N,N],[17,"MIN","core::u32","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u64","core","The 64-bit unsigned integer type.",N,N],[17,"MIN","core::u64","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"u128","core","The 128-bit unsigned integer type.",N,N],[17,"MIN","core::u128","The smallest value that can be represented by this integer type.",N,N],[17,"MAX","","The largest value that can be represented by this integer type.",N,N],[0,"f32","core","This module provides constants which are specific to the implementation of the `f32` floating point data type.",N,N],[0,"consts","core::f32","Basic mathematical constants.",N,N],[17,"PI","core::f32::consts","Archimedes' constant (π)",N,N],[17,"FRAC_PI_2","","π/2",N,N],[17,"FRAC_PI_3","","π/3",N,N],[17,"FRAC_PI_4","","π/4",N,N],[17,"FRAC_PI_6","","π/6",N,N],[17,"FRAC_PI_8","","π/8",N,N],[17,"FRAC_1_PI","","1/π",N,N],[17,"FRAC_2_PI","","2/π",N,N],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",N,N],[17,"SQRT_2","","sqrt(2)",N,N],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",N,N],[17,"E","","Euler's number (e)",N,N],[17,"LOG2_E","","log2(e)",N,N],[17,"LOG2_10","","log2(10)",N,N],[17,"LOG10_E","","log10(e)",N,N],[17,"LOG10_2","","log10(2)",N,N],[17,"LN_2","","ln(2)",N,N],[17,"LN_10","","ln(10)",N,N],[17,"RADIX","core::f32","The radix or base of the internal representation of `f32`.",N,N],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",N,N],[17,"DIGITS","","Approximate number of significant digits in base 10.",N,N],[17,"EPSILON","","[Machine epsilon] value for `f32`.",N,N],[17,"MIN","","Smallest finite `f32` value.",N,N],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",N,N],[17,"MAX","","Largest finite `f32` value.",N,N],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",N,N],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",N,N],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",N,N],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",N,N],[17,"NAN","","Not a Number (NaN).",N,N],[17,"INFINITY","","Infinity (∞).",N,N],[17,"NEG_INFINITY","","Negative infinity (-∞).",N,N],[0,"f64","core","This module provides constants which are specific to the implementation of the `f64` floating point data type.",N,N],[0,"consts","core::f64","Basic mathematical constants.",N,N],[17,"PI","core::f64::consts","Archimedes' constant (π)",N,N],[17,"FRAC_PI_2","","π/2",N,N],[17,"FRAC_PI_3","","π/3",N,N],[17,"FRAC_PI_4","","π/4",N,N],[17,"FRAC_PI_6","","π/6",N,N],[17,"FRAC_PI_8","","π/8",N,N],[17,"FRAC_1_PI","","1/π",N,N],[17,"FRAC_2_PI","","2/π",N,N],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",N,N],[17,"SQRT_2","","sqrt(2)",N,N],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",N,N],[17,"E","","Euler's number (e)",N,N],[17,"LOG2_10","","log2(10)",N,N],[17,"LOG2_E","","log2(e)",N,N],[17,"LOG10_2","","log10(2)",N,N],[17,"LOG10_E","","log10(e)",N,N],[17,"LN_2","","ln(2)",N,N],[17,"LN_10","","ln(10)",N,N],[17,"RADIX","core::f64","The radix or base of the internal representation of `f64`.",N,N],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",N,N],[17,"DIGITS","","Approximate number of significant digits in base 10.",N,N],[17,"EPSILON","","[Machine epsilon] value for `f64`.",N,N],[17,"MIN","","Smallest finite `f64` value.",N,N],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",N,N],[17,"MAX","","Largest finite `f64` value.",N,N],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",N,N],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",N,N],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",N,N],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",N,N],[17,"NAN","","Not a Number (NaN).",N,N],[17,"INFINITY","","Infinity (∞).",N,N],[17,"NEG_INFINITY","","Negative infinity (-∞).",N,N],[0,"num","core","Numeric traits and functions for the built-in numeric types.",N,N],[3,"NonZeroU8","core::num","An integer that is known not to equal zero.",N,N],[3,"NonZeroU16","","An integer that is known not to equal zero.",N,N],[3,"NonZeroU32","","An integer that is known not to equal zero.",N,N],[3,"NonZeroU64","","An integer that is known not to equal zero.",N,N],[3,"NonZeroU128","","An integer that is known not to equal zero.",N,N],[3,"NonZeroUsize","","An integer that is known not to equal zero.",N,N],[3,"Wrapping","","Provides intentionally-wrapped arithmetic on `T`.",N,N],[12,"0","","",0,N],[3,"TryFromIntError","","The error type returned when a checked integral type conversion fails.",N,N],[3,"ParseIntError","","An error which can be returned when parsing an integer.",N,N],[3,"ParseFloatError","","An error which can be returned when parsing a float.",N,N],[4,"FpCategory","","A classification of floating point numbers.",N,N],[13,"Nan","","\"Not a Number\", often obtained by dividing by zero.",1,N],[13,"Infinite","","Positive or negative infinity.",1,N],[13,"Zero","","Positive or negative zero.",1,N],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`).",1,N],[13,"Normal","","A regular floating point number.",1,N],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this integer type.",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`, wrapping the truncated bits to the end of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`, wrapping the truncated bits to the beginning of the resulting integer.",0,[[["self"],["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[["self"]],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[["self"]],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's endianness.",0,[[["self"]],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's endianness.",0,[[["self"]],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",0,[[["self"],["u32"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["isize"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["isize"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["i8"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["i8"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["i16"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["i16"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["i32"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["i32"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["i64"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["i64"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at the boundary of the type.",0,[[["self"]],["wrapping",["i128"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[["self"]],["wrapping",["i128"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number is zero or negative.",0,[[["self"]],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number is zero or positive.",0,[[["self"]],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation of `self`.",0,[[["self"]],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[["self"]],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.",0,[[["self"]],["self"]]],[11,"new_unchecked","","Create a non-zero without checking the value.",2,[[["u8"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",2,[[["u8"]],["option"]]],[11,"get","","Returns the value as a primitive type.",2,[[["self"]],["u8"]]],[11,"new_unchecked","","Create a non-zero without checking the value.",3,[[["u16"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",3,[[["u16"]],["option"]]],[11,"get","","Returns the value as a primitive type.",3,[[["self"]],["u16"]]],[11,"new_unchecked","","Create a non-zero without checking the value.",4,[[["u32"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",4,[[["u32"]],["option"]]],[11,"get","","Returns the value as a primitive type.",4,[[["self"]],["u32"]]],[11,"new_unchecked","","Create a non-zero without checking the value.",5,[[["u64"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",5,[[["u64"]],["option"]]],[11,"get","","Returns the value as a primitive type.",5,[[["self"]],["u64"]]],[11,"new_unchecked","","Create a non-zero without checking the value.",6,[[["u128"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",6,[[["u128"]],["option"]]],[11,"get","","Returns the value as a primitive type.",6,[[["self"]],["u128"]]],[11,"new_unchecked","","Create a non-zero without checking the value.",7,[[["usize"]],["self"]]],[11,"new","","Create a non-zero if the given value is not zero.",7,[[["usize"]],["option"]]],[11,"get","","Returns the value as a primitive type.",7,[[["self"]],["usize"]]],[0,"prelude","core","The libcore prelude",N,N],[0,"v1","core::prelude","The core prelude",N,N],[0,"intrinsics","core","rustc compiler intrinsics.",N,N],[5,"atomic_cxchg","core::intrinsics","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange`][compare_exchange].",N,N],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Release` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Relaxed` as both the `success` and `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::SeqCst` as the `success` and `Ordering::Acquire` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::Acquire` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `compare_exchange_weak` method by passing `Ordering::AcqRel` as the `success` and `Ordering::Relaxed` as the `failure` parameters. For example, [`AtomicBool::compare_exchange_weak`][cew].",N,N],[5,"atomic_load","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::load`.",N,N],[5,"atomic_load_acq","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::load`.",N,N],[5,"atomic_load_relaxed","","Loads the current value of the pointer. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `load` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::load`.",N,N],[5,"atomic_load_unordered","","",N,N],[5,"atomic_store","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::store`.",N,N],[5,"atomic_store_rel","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::store`.",N,N],[5,"atomic_store_relaxed","","Stores the value at the specified memory location. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `store` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::store`.",N,N],[5,"atomic_store_unordered","","",N,N],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `swap` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::swap`.",N,N],[5,"atomic_xadd","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_add` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_add`.",N,N],[5,"atomic_xsub","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Release` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_sub` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicIsize::fetch_sub`.",N,N],[5,"atomic_and","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_and` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_and`.",N,N],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_nand`.",N,N],[5,"atomic_or","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_or` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_or`.",N,N],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::SeqCst` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Acquire` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Release` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::AcqRel` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value. The stabilized version of this intrinsic is available on the `std::sync::atomic` types via the `fetch_xor` method by passing `Ordering::Relaxed` as the `order`. For example, `AtomicBool::fetch_xor`.",N,N],[5,"atomic_max","","",N,N],[5,"atomic_max_acq","","",N,N],[5,"atomic_max_rel","","",N,N],[5,"atomic_max_acqrel","","",N,N],[5,"atomic_max_relaxed","","",N,N],[5,"atomic_min","","",N,N],[5,"atomic_min_acq","","",N,N],[5,"atomic_min_rel","","",N,N],[5,"atomic_min_acqrel","","",N,N],[5,"atomic_min_relaxed","","",N,N],[5,"atomic_umin","","",N,N],[5,"atomic_umin_acq","","",N,N],[5,"atomic_umin_rel","","",N,N],[5,"atomic_umin_acqrel","","",N,N],[5,"atomic_umin_relaxed","","",N,N],[5,"atomic_umax","","",N,N],[5,"atomic_umax_acq","","",N,N],[5,"atomic_umax_rel","","",N,N],[5,"atomic_umax_acqrel","","",N,N],[5,"atomic_umax_relaxed","","",N,N],[5,"prefetch_read_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"prefetch_write_data","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"prefetch_read_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"prefetch_write_instruction","","The `prefetch` intrinsic is a hint to the code generator to insert a prefetch instruction if supported; otherwise, it is a noop. Prefetches have no effect on the behavior of the program but can change its performance characteristics.",N,N],[5,"atomic_fence","","",N,N],[5,"atomic_fence_acq","","",N,N],[5,"atomic_fence_rel","","",N,N],[5,"atomic_fence_acqrel","","",N,N],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",N,N],[5,"atomic_singlethreadfence_acq","","",N,N],[5,"atomic_singlethreadfence_rel","","",N,N],[5,"atomic_singlethreadfence_acqrel","","",N,N],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes attached to the function.",N,N],[5,"abort","","Aborts the execution of the process.",N,N],[5,"unreachable","","Tells LLVM that this point in the code is not reachable, enabling further optimizations.",N,N],[5,"assume","","Informs the optimizer that a condition is always true. If the condition is false, the behavior is undefined.",N,N],[5,"likely","","Hints to the compiler that branch condition is likely to be true. Returns the value passed to it.",N,N],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false. Returns the value passed to it.",N,N],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",N,N],[5,"size_of","","The size of a type in bytes.",N,N],[5,"move_val_init","","Moves a value to an uninitialized memory location.",N,N],[5,"min_align_of","","",N,N],[5,"pref_align_of","","",N,N],[5,"size_of_val","","The size of the referenced value in bytes.",N,N],[5,"min_align_of_val","","",N,N],[5,"type_name","","Gets a static string slice containing the name of a type.",N,N],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This function will return the same value for a type regardless of whichever crate it is invoked in.",N,N],[5,"init","","Creates a value initialized to zero.",N,N],[5,"uninit","","Creates an uninitialized value.",N,N],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",N,N],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop glue; returns `false` if the actual type provided for `T` implements `Copy`.",N,N],[5,"offset","","Calculates the offset from a pointer.",N,N],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",N,N],[5,"copy_nonoverlapping","","Copies `count * size_of::<T>()` bytes from `src` to `dst`. The source and destination must not overlap.",N,N],[5,"copy","","Copies `count * size_of::<T>()` bytes from `src` to `dst`. The source and destination may overlap.",N,N],[5,"write_bytes","","Sets `count * size_of::<T>()` bytes of memory starting at `dst` to `val`.",N,N],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",N,N],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`",N,N],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a size of `count` * `size_of::<T>()` and an alignment of `min_align_of::<T>()`.",N,N],[5,"volatile_load","","Perform a volatile load from the `src` pointer. The stabilized version of this intrinsic is `std::ptr::read_volatile`.",N,N],[5,"volatile_store","","Perform a volatile store to the `dst` pointer. The stabilized version of this intrinsic is `std::ptr::write_volatile`.",N,N],[5,"unaligned_volatile_load","","Perform a volatile load from the `src` pointer The pointer is not required to be aligned.",N,N],[5,"unaligned_volatile_store","","Perform a volatile store to the `dst` pointer. The pointer is not required to be aligned.",N,N],[5,"sqrtf32","","Returns the square root of an `f32`",N,N],[5,"sqrtf64","","Returns the square root of an `f64`",N,N],[5,"powif32","","Raises an `f32` to an integer power.",N,N],[5,"powif64","","Raises an `f64` to an integer power.",N,N],[5,"sinf32","","Returns the sine of an `f32`.",N,N],[5,"sinf64","","Returns the sine of an `f64`.",N,N],[5,"cosf32","","Returns the cosine of an `f32`.",N,N],[5,"cosf64","","Returns the cosine of an `f64`.",N,N],[5,"powf32","","Raises an `f32` to an `f32` power.",N,N],[5,"powf64","","Raises an `f64` to an `f64` power.",N,N],[5,"expf32","","Returns the exponential of an `f32`.",N,N],[5,"expf64","","Returns the exponential of an `f64`.",N,N],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",N,N],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",N,N],[5,"logf32","","Returns the natural logarithm of an `f32`.",N,N],[5,"logf64","","Returns the natural logarithm of an `f64`.",N,N],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",N,N],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",N,N],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",N,N],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",N,N],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",N,N],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",N,N],[5,"fabsf32","","Returns the absolute value of an `f32`.",N,N],[5,"fabsf64","","Returns the absolute value of an `f64`.",N,N],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",N,N],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",N,N],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",N,N],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",N,N],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",N,N],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",N,N],[5,"truncf32","","Returns the integer part of an `f32`.",N,N],[5,"truncf64","","Returns the integer part of an `f64`.",N,N],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception if the argument is not an integer.",N,N],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception if the argument is not an integer.",N,N],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",N,N],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",N,N],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",N,N],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",N,N],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules. May assume inputs are finite.",N,N],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules. May assume inputs are finite.",N,N],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules. May assume inputs are finite.",N,N],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules. May assume inputs are finite.",N,N],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules. May assume inputs are finite.",N,N],[5,"ctpop","","Returns the number of bits set in an integer type `T`",N,N],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an integer type `T`.",N,N],[5,"ctlz_nonzero","","Like `ctlz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",N,N],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an integer type `T`.",N,N],[5,"cttz_nonzero","","Like `cttz`, but extra-unsafe as it returns `undef` when given an `x` with value `0`.",N,N],[5,"bswap","","Reverses the bytes in an integer type `T`.",N,N],[5,"bitreverse","","Reverses the bits in an integer type `T`.",N,N],[5,"add_with_overflow","","Performs checked integer addition. The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_add` method. For example, `std::u32::overflowing_add`",N,N],[5,"sub_with_overflow","","Performs checked integer subtraction The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_sub` method. For example, `std::u32::overflowing_sub`",N,N],[5,"mul_with_overflow","","Performs checked integer multiplication The stabilized versions of this intrinsic are available on the integer primitives via the `overflowing_mul` method. For example, `std::u32::overflowing_mul`",N,N],[5,"exact_div","","Performs an exact division, resulting in undefined behavior where `x % y != 0` or `y == 0` or `x == T::min_value() && y == -1`",N,N],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",N,N],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in undefined behavior where y = 0 or x = `T::min_value()` and y = -1",N,N],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",N,N],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined behavior when y < 0 or y >= N, where N is the width of T in bits.",N,N],[5,"overflowing_add","","Returns (a + b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_add` method. For example, `std::u32::wrapping_add`",N,N],[5,"overflowing_sub","","Returns (a - b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_sub` method. For example, `std::u32::wrapping_sub`",N,N],[5,"overflowing_mul","","Returns (a * b) mod 2N, where N is the width of T in bits. The stabilized versions of this intrinsic are available on the integer primitives via the `wrapping_mul` method. For example, `std::u32::wrapping_mul`",N,N],[5,"discriminant_value","","Returns the value of the discriminant for the variant in 'v', cast to a `u64`; if `T` has no discriminant, returns 0.",N,N],[5,"try","","Rust's \"try catch\" construct which invokes the function pointer `f` with the data pointer `data`.",N,N],[5,"nontemporal_store","","Emits a `!nontemporal` store according to LLVM (see their docs). Probably will never become stable.",N,N],[0,"mem","core","Basic functions for dealing with memory.",N,N],[3,"Discriminant","core::mem","Opaque type representing the discriminant of an enum.",N,N],[3,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling `T`’s destructor.",N,N],[19,"MaybeUninit","","A newtype to construct uninitialized instances of `T`",N,N],[5,"forget","","Takes ownership and \"forgets\" about the value without running its destructor.",N,[[["t"]]]],[5,"size_of","","Returns the size of a type in bytes.",N,[[],["usize"]]],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",N,[[["t"]],["usize"]]],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",N,[[],["usize"]]],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",N,[[["t"]],["usize"]]],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",N,[[],["usize"]]],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",N,[[["t"]],["usize"]]],[5,"needs_drop","","Returns whether dropping values of type `T` matters.",N,[[],["bool"]]],[5,"zeroed","","Creates a value whose bytes are all zero.",N,[[],["t"]]],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by pretending to produce a value of type `T`, while doing nothing at all.",N,[[],["t"]]],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",N,[[["t"],["t"]]]],[5,"replace","","Moves `src` into the referenced `dest`, returning the previous `dest` value.",N,[[["t"],["t"]],["t"]]],[5,"drop","","Disposes of a value.",N,[[["t"]]]],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src` without moving the contained value.",N,[[["t"]],["u"]]],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",N,[[["t"]],["discriminant"]]],[11,"new","","Wrap a value to be manually dropped.",8,[[["t"]],["manuallydrop"]]],[11,"into_inner","","Extract the value from the `ManuallyDrop` container.",8,[[["manuallydrop"]],["t"]]],[11,"drop","","Manually drops the contained value.",8,[[["manuallydrop"]]]],[11,"uninitialized","","Create a new `MaybeUninit` in an uninitialized state.",9,[[],["maybeuninit"]]],[11,"zeroed","","Create a new `MaybeUninit` in an uninitialized state, with the memory being filled with `0` bytes.  It depends on `T` whether that already makes for proper initialization. For example, `MaybeUninit<usize>::zeroed()` is initialized, but `MaybeUninit<&'static i32>::zeroed()` is not because references must not be null.",9,[[],["maybeuninit"]]],[11,"set","","Set the value of the `MaybeUninit`. This overwrites any previous value without dropping it.",9,[[["self"],["t"]]]],[11,"into_inner","","Extract the value from the `MaybeUninit` container.  This is a great way to ensure that the data will get dropped, because the resulting `T` is subject to the usual drop handling.",9,[[["self"]],["t"]]],[11,"get_ref","","Get a reference to the contained value.",9,[[["self"]],["t"]]],[11,"get_mut","","Get a mutable reference to the contained value.",9,[[["self"]],["t"]]],[11,"as_ptr","","Get a pointer to the contained value. Reading from this pointer will be undefined behavior unless the `MaybeUninit` is initialized.",9,N],[11,"as_mut_ptr","","Get a mutable pointer to the contained value. Reading from this pointer will be undefined behavior unless the `MaybeUninit` is initialized.",9,N],[0,"ptr","core","Manually manage memory through raw pointers.",N,N],[3,"NonNull","core::ptr","`*mut T` but non-zero and covariant.",N,N],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",N,N],[5,"null","","Creates a null raw pointer.",N,N],[5,"null_mut","","Creates a null mutable raw pointer.",N,N],[5,"swap","","Swaps the values at two mutable locations of the same type, without deinitializing either.",N,N],[5,"swap_nonoverlapping","","Swaps `count * size_of::<T>()` bytes between the two regions of memory beginning at `x` and `y`. The two regions must not overlap.",N,N],[5,"replace","","Moves `src` into the pointed `dst`, returning the previous `dst` value.",N,N],[5,"read","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",N,N],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the memory in `src` unchanged.",N,N],[5,"write","","Overwrites a memory location with the given value without reading or dropping the old value.",N,N],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or dropping the old value.",N,N],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This leaves the memory in `src` unchanged.",N,N],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without reading or dropping the old value.",N,N],[5,"eq","","Compare raw pointers for equality.",N,N],[11,"dangling","","Creates a new `NonNull` that is dangling, but well-aligned.",10,[[],["self"]]],[11,"new_unchecked","","Creates a new `NonNull`.",10,N],[11,"new","","Creates a new `NonNull` if `ptr` is non-null.",10,N],[11,"as_ptr","","Acquires the underlying `*mut` pointer.",10,N],[11,"as_ref","","Dereferences the content.",10,[[["self"]],["t"]]],[11,"as_mut","","Mutably dereferences the content.",10,[[["self"]],["t"]]],[11,"cast","","Cast to a pointer of another type",10,[[["self"]],["nonnull"]]],[0,"hint","core","Hints to compiler that affects how code should be emitted or optimized.",N,N],[5,"unreachable_unchecked","core::hint","Informs the compiler that this point in the code is not reachable, enabling further optimizations.",N,N],[0,"marker","core","Primitive traits and types representing basic properties of types.",N,N],[3,"PhantomData","core::marker","Zero-sized type used to mark things that \"act like\" they own a `T`.",N,N],[3,"Pinned","","A type which does not implement `Unpin`.",N,N],[8,"Send","","Types that can be transferred across thread boundaries.",N,N],[8,"Sized","","Types with a constant size known at compile time.",N,N],[8,"Unsize","","Types that can be \"unsized\" to a dynamically-sized type.",N,N],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",N,N],[8,"Sync","","Types for which it is safe to share references between threads.",N,N],[8,"Unpin","","Types which can be safely moved after being pinned.",N,N],[0,"ops","core","Overloadable operators.",N,N],[3,"Range","core::ops","A (half-open) range bounded inclusively below and exclusively above (`start..end`).",N,N],[12,"start","","The lower bound of the range (inclusive).",11,N],[12,"end","","The upper bound of the range (exclusive).",11,N],[3,"RangeFrom","","A range only bounded inclusively below (`start..`).",N,N],[12,"start","","The lower bound of the range (inclusive).",12,N],[3,"RangeFull","","An unbounded range (`..`).",N,N],[3,"RangeTo","","A range only bounded exclusively above (`..end`).",N,N],[12,"end","","The upper bound of the range (exclusive).",13,N],[3,"RangeInclusive","","A range bounded inclusively below and above (`start..=end`).",N,N],[3,"RangeToInclusive","","A range only bounded inclusively above (`..=end`).",N,N],[12,"end","","The upper bound of the range (inclusive)",14,N],[4,"Bound","","An endpoint of a range of keys.",N,N],[13,"Included","","An inclusive bound.",15,N],[13,"Excluded","","An exclusive bound.",15,N],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",15,N],[4,"GeneratorState","","The result of a generator resumption.",N,N],[13,"Yielded","","The generator suspended with a value.",16,N],[13,"Complete","","The generator completed with a return value.",16,N],[11,"contains","","Returns `true` if `item` is contained in the range.",11,[[["self"],["u"]],["bool"]]],[11,"is_empty","","Returns `true` if the range contains no items.",11,[[["self"]],["bool"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",12,[[["self"],["u"]],["bool"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",13,[[["self"],["u"]],["bool"]]],[11,"new","","Creates a new inclusive range. Equivalent to writing `start..=end`.",17,[[["idx"],["idx"]],["self"]]],[11,"start","","Returns the lower bound of the range (inclusive).",17,[[["self"]],["idx"]]],[11,"end","","Returns the upper bound of the range (inclusive).",17,[[["self"]],["idx"]]],[11,"into_inner","","Destructures the `RangeInclusive` into (lower bound, upper (inclusive) bound).",17,N],[11,"contains","","Returns `true` if `item` is contained in the range.",17,[[["self"],["u"]],["bool"]]],[11,"is_empty","","Returns `true` if the range contains no items.",17,[[["self"]],["bool"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",14,[[["self"],["u"]],["bool"]]],[8,"Add","","The addition operator `+`.",N,N],[16,"Output","","The resulting type after applying the `+` operator.",18,N],[10,"add","","Performs the `+` operation.",18,N],[8,"Sub","","The subtraction operator `-`.",N,N],[16,"Output","","The resulting type after applying the `-` operator.",19,N],[10,"sub","","Performs the `-` operation.",19,N],[8,"Mul","","The multiplication operator `*`.",N,N],[16,"Output","","The resulting type after applying the `*` operator.",20,N],[10,"mul","","Performs the `*` operation.",20,N],[8,"Div","","The division operator `/`.",N,N],[16,"Output","","The resulting type after applying the `/` operator.",21,N],[10,"div","","Performs the `/` operation.",21,N],[8,"Rem","","The remainder operator `%`.",N,N],[16,"Output","","The resulting type after applying the `%` operator.",22,N],[10,"rem","","Performs the `%` operation.",22,N],[8,"Neg","","The unary negation operator `-`.",N,N],[16,"Output","","The resulting type after applying the `-` operator.",23,N],[10,"neg","","Performs the unary `-` operation.",23,N],[8,"AddAssign","","The addition assignment operator `+=`.",N,N],[10,"add_assign","","Performs the `+=` operation.",24,[[["self"],["rhs"]]]],[8,"SubAssign","","The subtraction assignment operator `-=`.",N,N],[10,"sub_assign","","Performs the `-=` operation.",25,[[["self"],["rhs"]]]],[8,"MulAssign","","The multiplication assignment operator `*=`.",N,N],[10,"mul_assign","","Performs the `*=` operation.",26,[[["self"],["rhs"]]]],[8,"DivAssign","","The division assignment operator `/=`.",N,N],[10,"div_assign","","Performs the `/=` operation.",27,[[["self"],["rhs"]]]],[8,"RemAssign","","The remainder assignment operator `%=`.",N,N],[10,"rem_assign","","Performs the `%=` operation.",28,[[["self"],["rhs"]]]],[8,"Not","","The unary logical negation operator `!`.",N,N],[16,"Output","","The resulting type after applying the `!` operator.",29,N],[10,"not","","Performs the unary `!` operation.",29,N],[8,"BitAnd","","The bitwise AND operator `&`.",N,N],[16,"Output","","The resulting type after applying the `&` operator.",30,N],[10,"bitand","","Performs the `&` operation.",30,N],[8,"BitOr","","The bitwise OR operator `|`.",N,N],[16,"Output","","The resulting type after applying the `|` operator.",31,N],[10,"bitor","","Performs the `|` operation.",31,N],[8,"BitXor","","The bitwise XOR operator `^`.",N,N],[16,"Output","","The resulting type after applying the `^` operator.",32,N],[10,"bitxor","","Performs the `^` operation.",32,N],[8,"Shl","","The left shift operator `<<`. Note that because this trait is implemented for all integer types with multiple right-hand-side types, Rust's type checker has special handling for `_ << _`, setting the result type for integer operations to the type of the left-hand-side operand. This means that though `a << b` and `a.shl(b)` are one and the same from an evaluation standpoint, they are different when it comes to type inference.",N,N],[16,"Output","","The resulting type after applying the `<<` operator.",33,N],[10,"shl","","Performs the `<<` operation.",33,N],[8,"Shr","","The right shift operator `>>`. Note that because this trait is implemented for all integer types with multiple right-hand-side types, Rust's type checker has special handling for `_ >> _`, setting the result type for integer operations to the type of the left-hand-side operand. This means that though `a >> b` and `a.shr(b)` are one and the same from an evaluation standpoint, they are different when it comes to type inference.",N,N],[16,"Output","","The resulting type after applying the `>>` operator.",34,N],[10,"shr","","Performs the `>>` operation.",34,N],[8,"BitAndAssign","","The bitwise AND assignment operator `&=`.",N,N],[10,"bitand_assign","","Performs the `&=` operation.",35,[[["self"],["rhs"]]]],[8,"BitOrAssign","","The bitwise OR assignment operator `|=`.",N,N],[10,"bitor_assign","","Performs the `|=` operation.",36,[[["self"],["rhs"]]]],[8,"BitXorAssign","","The bitwise XOR assignment operator `^=`.",N,N],[10,"bitxor_assign","","Performs the `^=` operation.",37,[[["self"],["rhs"]]]],[8,"ShlAssign","","The left shift assignment operator `<<=`.",N,N],[10,"shl_assign","","Performs the `<<=` operation.",38,[[["self"],["rhs"]]]],[8,"ShrAssign","","The right shift assignment operator `>>=`.",N,N],[10,"shr_assign","","Performs the `>>=` operation.",39,[[["self"],["rhs"]]]],[8,"Deref","","Used for immutable dereferencing operations, like `*v`.",N,N],[16,"Target","","The resulting type after dereferencing.",40,N],[10,"deref","","Dereferences the value.",40,N],[8,"DerefMut","","Used for mutable dereferencing operations, like in `*v = 1;`.",N,N],[10,"deref_mut","","Mutably dereferences the value.",41,N],[8,"Drop","","Used to run some code when a value goes out of scope. This is sometimes called a 'destructor'.",N,N],[10,"drop","","Executes the destructor for this type.",42,[[["self"]]]],[8,"Fn","","The version of the call operator that takes an immutable receiver.",N,N],[10,"call","","Performs the call operation.",43,N],[8,"FnMut","","The version of the call operator that takes a mutable receiver.",N,N],[10,"call_mut","","Performs the call operation.",44,N],[8,"FnOnce","","The version of the call operator that takes a by-value receiver.",N,N],[16,"Output","","The returned type after the call operator is used.",45,N],[10,"call_once","","Performs the call operation.",45,N],[8,"Index","","Used for indexing operations (`container[index]`) in immutable contexts.",N,N],[16,"Output","","The returned type after indexing.",46,N],[10,"index","","Performs the indexing (`container[index]`) operation.",46,N],[8,"IndexMut","","Used for indexing operations (`container[index]`) in mutable contexts.",N,N],[10,"index_mut","","Performs the mutable indexing (`container[index]`) operation.",47,N],[8,"RangeBounds","","`RangeBounds` is implemented by Rust's built-in range types, produced by range syntax like `..`, `a..`, `..b` or `c..d`.",N,N],[10,"start_bound","","Start index bound.",48,[[["self"]],["bound"]]],[10,"end_bound","","End index bound.",48,[[["self"]],["bound"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",48,[[["self"],["u"]],["bool"]]],[8,"Try","","A trait for customizing the behavior of the `?` operator.",N,N],[16,"Ok","","The type of this value when viewed as successful.",49,N],[16,"Error","","The type of this value when viewed as failed.",49,N],[10,"into_result","","Applies the \"?\" operator. A return of `Ok(t)` means that the execution should continue normally, and the result of `?` is the value `t`. A return of `Err(e)` means that execution should branch to the innermost enclosing `catch`, or return from the function.",49,[[["self"]],["result"]]],[10,"from_error","","Wrap an error value to construct the composite result. For example, `Result::Err(x)` and `Result::from_error(x)` are equivalent.",49,N],[10,"from_ok","","Wrap an OK value to construct the composite result. For example, `Result::Ok(x)` and `Result::from_ok(x)` are equivalent.",49,N],[8,"Generator","","The trait implemented by builtin generator types.",N,N],[16,"Yield","","The type of value this generator yields.",50,N],[16,"Return","","The type of value this generator returns.",50,N],[10,"resume","","Resumes the execution of this generator.",50,[[["self"]],["generatorstate"]]],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one, where unsizing can be performed on the pointee.",N,N],[0,"cmp","core","Functionality for ordering and comparison.",N,N],[3,"Reverse","core::cmp","A helper struct for reverse ordering.",N,N],[12,"0","","",51,N],[4,"Ordering","","An `Ordering` is the result of a comparison between two values.",N,N],[13,"Less","","An ordering where a compared value is less [than another].",52,N],[13,"Equal","","An ordering where a compared value is equal [to another].",52,N],[13,"Greater","","An ordering where a compared value is greater [than another].",52,N],[5,"min","","Compares and returns the minimum of two values.",N,[[["t"],["t"]],["t"]]],[5,"max","","Compares and returns the maximum of two values.",N,[[["t"],["t"]],["t"]]],[8,"PartialEq","","Trait for equality comparisons which are partial equivalence relations.",N,N],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used by `==`.",53,[[["self"],["rhs"]],["bool"]]],[11,"ne","","This method tests for `!=`.",53,[[["self"],["rhs"]],["bool"]]],[8,"Eq","","Trait for equality comparisons which are equivalence relations.",N,N],[8,"Ord","","Trait for types that form a total order.",N,N],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",54,[[["self"],["self"]],["ordering"]]],[11,"max","","Compares and returns the maximum of two values.",54,[[["self"],["self"]],["self"]]],[11,"min","","Compares and returns the minimum of two values.",54,[[["self"],["self"]],["self"]]],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",N,N],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",55,[[["self"],["rhs"]],["option",["ordering"]]]],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `<` operator.",55,[[["self"],["rhs"]],["bool"]]],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `<=` operator.",55,[[["self"],["rhs"]],["bool"]]],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `>` operator.",55,[[["self"],["rhs"]],["bool"]]],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `>=` operator.",55,[[["self"],["rhs"]],["bool"]]],[11,"reverse","","Reverses the `Ordering`.",52,[[["self"]],["ordering"]]],[11,"then","","Chains two orderings.",52,[[["self"],["ordering"]],["ordering"]]],[11,"then_with","","Chains the ordering with the given function.",52,[[["self"],["f"]],["ordering"]]],[0,"clone","core","The `Clone` trait for types that cannot be 'implicitly copied'.",N,N],[8,"Clone","core::clone","A common trait for the ability to explicitly duplicate an object.",N,N],[10,"clone","","Returns a copy of the value.",56,[[["self"]],["self"]]],[11,"clone_from","","Performs copy-assignment from `source`.",56,[[["self"],["self"]]]],[0,"default","core","The `Default` trait for types which may have meaningful default values.",N,N],[8,"Default","core::default","A trait for giving a type a useful default value.",N,N],[10,"default","","Returns the \"default value\" for a type.",57,[[],["self"]]],[0,"convert","core","Traits for conversions between types.",N,N],[5,"identity","core::convert","An identity function.",N,[[["t"]],["t"]]],[8,"AsRef","","A cheap reference-to-reference conversion. Used to convert a value to a reference value within generic code.",N,N],[10,"as_ref","","Performs the conversion.",58,[[["self"]],["t"]]],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",N,N],[10,"as_mut","","Performs the conversion.",59,[[["self"]],["t"]]],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive. The reciprocal of [`From`][From].",N,N],[10,"into","","Performs the conversion.",60,[[["self"]],["t"]]],[8,"From","","Simple and safe type conversions in to `Self`. It is the reciprocal of `Into`.",N,N],[10,"from","","Performs the conversion.",61,[[["t"]],["self"]]],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",N,N],[16,"Error","","The type returned in the event of a conversion error.",62,N],[10,"try_into","","Performs the conversion.",62,[[["self"]],["result"]]],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",N,N],[16,"Error","","The type returned in the event of a conversion error.",63,N],[10,"try_from","","Performs the conversion.",63,[[["t"]],["result"]]],[0,"borrow","core","A module for working with borrowed data.",N,N],[8,"Borrow","core::borrow","A trait for borrowing data.",N,N],[10,"borrow","","Immutably borrows from an owned value.",64,[[["self"]],["borrowed"]]],[8,"BorrowMut","","A trait for mutably borrowing data.",N,N],[10,"borrow_mut","","Mutably borrows from an owned value.",65,[[["self"]],["borrowed"]]],[0,"any","core","This module implements the `Any` trait, which enables dynamic typing of any `'static` type through runtime reflection.",N,N],[3,"TypeId","core::any","A `TypeId` represents a globally unique identifier for a type.",N,N],[8,"Any","","A type to emulate dynamic typing.",N,N],[10,"get_type_id","","Gets the `TypeId` of `self`.",66,[[["self"]],["typeid"]]],[11,"is","","Returns `true` if the boxed type is the same as `T`.",66,[[["self"]],["bool"]]],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or `None` if it isn't.",66,[[["self"]],["option"]]],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or `None` if it isn't.",66,[[["self"]],["option"]]],[11,"is","","Forwards to the method defined on the type `Any`.",66,[[["self"]],["bool"]]],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",66,[[["self"]],["option"]]],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",66,[[["self"]],["option"]]],[11,"is","","Forwards to the method defined on the type `Any`.",66,[[["self"]],["bool"]]],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",66,[[["self"]],["option"]]],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",66,[[["self"]],["option"]]],[11,"of","","Returns the `TypeId` of the type this generic function has been instantiated with.",67,[[],["typeid"]]],[0,"array","core","Implementations of things like `Eq` for fixed-length arrays up to a certain length. Eventually we should able to generalize to all lengths.",N,N],[3,"TryFromSliceError","core::array","The error type returned when a conversion from a slice to an array fails.",N,N],[8,"FixedSizeArray","","Utility trait implemented only on arrays of fixed size",N,N],[10,"as_slice","","Converts the array to immutable slice",68,N],[10,"as_mut_slice","","Converts the array to mutable slice",68,N],[0,"ascii","core","Operations on ASCII strings and characters.",N,N],[3,"EscapeDefault","core::ascii","An iterator over the escaped version of a byte.",N,N],[5,"escape_default","","Returns an iterator that produces an escaped version of a `u8`.",N,[[["u8"]],["escapedefault"]]],[0,"sync","core","Synchronization primitives",N,N],[0,"atomic","core::sync","Atomic types",N,N],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",N,N],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",N,N],[3,"AtomicI8","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicU8","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicI16","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicU16","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicI32","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicU32","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicI64","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicU64","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",N,N],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",N,N],[4,"Ordering","","Atomic memory orderings",N,N],[13,"Relaxed","","No ordering constraints, only atomic operations.",69,N],[13,"Release","","When coupled with a store, all previous operations become ordered before any load of this value with [`Acquire`] (or stronger) ordering. In particular, all previous writes become visible to all threads that perform an [`Acquire`] (or stronger) load of this value.",69,N],[13,"Acquire","","When coupled with a load, if the loaded value was written by a store operation with [`Release`] (or stronger) ordering, then all subsequent operations become ordered after that store. In particular, all subsequent loads will see data written before the store.",69,N],[13,"AcqRel","","Has the effects of both [`Acquire`] and [`Release`] together: For loads it uses [`Acquire`] ordering. For stores it uses the [`Release`] ordering.",69,N],[13,"SeqCst","","Like [`Acquire`]/[`Release`]/[`AcqRel`] (for load, store, and load-with-store operations, respectively) with the additional guarantee that all threads see all sequentially consistent operations in the same order.",69,N],[5,"spin_loop_hint","","Save power or switch hyperthreads in a busy-wait spin-loop.",N,[[]]],[5,"fence","","An atomic fence.",N,[[["ordering"]]]],[5,"compiler_fence","","A compiler memory fence.",N,[[["ordering"]]]],[17,"ATOMIC_BOOL_INIT","","An [`AtomicBool`] initialized to `false`.",N,N],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",N,N],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",N,N],[11,"new","","Creates a new `AtomicBool`.",70,[[["bool"]],["atomicbool"]]],[11,"get_mut","","Returns a mutable reference to the underlying [`bool`].",70,[[["self"]],["bool"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",70,[[["self"]],["bool"]]],[11,"load","","Loads a value from the bool.",70,[[["self"],["ordering"]],["bool"]]],[11,"store","","Stores a value into the bool.",70,[[["self"],["bool"],["ordering"]]]],[11,"swap","","Stores a value into the bool, returning the previous value.",70,[[["self"],["bool"],["ordering"]],["bool"]]],[11,"compare_and_swap","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",70,[[["self"],["bool"],["bool"],["ordering"]],["bool"]]],[11,"compare_exchange","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",70,[[["self"],["bool"],["bool"],["ordering"],["ordering"]],["result",["bool","bool"]]]],[11,"compare_exchange_weak","","Stores a value into the [`bool`] if the current value is the same as the `current` value.",70,[[["self"],["bool"],["bool"],["ordering"],["ordering"]],["result",["bool","bool"]]]],[11,"fetch_and","","Logical \"and\" with a boolean value.",70,[[["self"],["bool"],["ordering"]],["bool"]]],[11,"fetch_nand","","Logical \"nand\" with a boolean value.",70,[[["self"],["bool"],["ordering"]],["bool"]]],[11,"fetch_or","","Logical \"or\" with a boolean value.",70,[[["self"],["bool"],["ordering"]],["bool"]]],[11,"fetch_xor","","Logical \"xor\" with a boolean value.",70,[[["self"],["bool"],["ordering"]],["bool"]]],[11,"new","","Creates a new `AtomicPtr`.",71,N],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",71,N],[11,"into_inner","","Consumes the atomic and returns the contained value.",71,N],[11,"load","","Loads a value from the pointer.",71,N],[11,"store","","Stores a value into the pointer.",71,N],[11,"swap","","Stores a value into the pointer, returning the previous value.",71,N],[11,"compare_and_swap","","Stores a value into the pointer if the current value is the same as the `current` value.",71,N],[11,"compare_exchange","","Stores a value into the pointer if the current value is the same as the `current` value.",71,N],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is the same as the `current` value.",71,N],[11,"new","","Creates a new atomic integer.",72,[[["i8"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",72,[[["self"]],["i8"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",72,[[["self"]],["i8"]]],[11,"load","","Loads a value from the atomic integer.",72,[[["self"],["ordering"]],["i8"]]],[11,"store","","Stores a value into the atomic integer.",72,[[["self"],["i8"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",72,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",72,[[["self"],["i8"],["i8"],["ordering"]],["i8"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",72,[[["self"],["i8"],["i8"],["ordering"],["ordering"]],["result",["i8","i8"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",72,[[["self"],["i8"],["i8"],["ordering"],["ordering"]],["result",["i8","i8"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",72,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",72,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",72,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",72,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",72,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",72,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",72,[[["self"],["f"],["ordering"],["ordering"]],["result",["i8","i8"]]]],[11,"fetch_max","","Maximum with the current value.",72,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"fetch_min","","Minimum with the current value.",72,[[["self"],["i8"],["ordering"]],["i8"]]],[11,"new","","Creates a new atomic integer.",73,[[["u8"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",73,[[["self"]],["u8"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",73,[[["self"]],["u8"]]],[11,"load","","Loads a value from the atomic integer.",73,[[["self"],["ordering"]],["u8"]]],[11,"store","","Stores a value into the atomic integer.",73,[[["self"],["u8"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",73,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",73,[[["self"],["u8"],["u8"],["ordering"]],["u8"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",73,[[["self"],["u8"],["u8"],["ordering"],["ordering"]],["result",["u8","u8"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",73,[[["self"],["u8"],["u8"],["ordering"],["ordering"]],["result",["u8","u8"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",73,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",73,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",73,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",73,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",73,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",73,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",73,[[["self"],["f"],["ordering"],["ordering"]],["result",["u8","u8"]]]],[11,"fetch_max","","Maximum with the current value.",73,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"fetch_min","","Minimum with the current value.",73,[[["self"],["u8"],["ordering"]],["u8"]]],[11,"new","","Creates a new atomic integer.",74,[[["i16"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",74,[[["self"]],["i16"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",74,[[["self"]],["i16"]]],[11,"load","","Loads a value from the atomic integer.",74,[[["self"],["ordering"]],["i16"]]],[11,"store","","Stores a value into the atomic integer.",74,[[["self"],["i16"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",74,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",74,[[["self"],["i16"],["i16"],["ordering"]],["i16"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",74,[[["self"],["i16"],["i16"],["ordering"],["ordering"]],["result",["i16","i16"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",74,[[["self"],["i16"],["i16"],["ordering"],["ordering"]],["result",["i16","i16"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",74,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",74,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",74,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",74,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",74,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",74,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",74,[[["self"],["f"],["ordering"],["ordering"]],["result",["i16","i16"]]]],[11,"fetch_max","","Maximum with the current value.",74,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"fetch_min","","Minimum with the current value.",74,[[["self"],["i16"],["ordering"]],["i16"]]],[11,"new","","Creates a new atomic integer.",75,[[["u16"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",75,[[["self"]],["u16"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",75,[[["self"]],["u16"]]],[11,"load","","Loads a value from the atomic integer.",75,[[["self"],["ordering"]],["u16"]]],[11,"store","","Stores a value into the atomic integer.",75,[[["self"],["u16"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",75,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",75,[[["self"],["u16"],["u16"],["ordering"]],["u16"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",75,[[["self"],["u16"],["u16"],["ordering"],["ordering"]],["result",["u16","u16"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",75,[[["self"],["u16"],["u16"],["ordering"],["ordering"]],["result",["u16","u16"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",75,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",75,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",75,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",75,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",75,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",75,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",75,[[["self"],["f"],["ordering"],["ordering"]],["result",["u16","u16"]]]],[11,"fetch_max","","Maximum with the current value.",75,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"fetch_min","","Minimum with the current value.",75,[[["self"],["u16"],["ordering"]],["u16"]]],[11,"new","","Creates a new atomic integer.",76,[[["i32"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",76,[[["self"]],["i32"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",76,[[["self"]],["i32"]]],[11,"load","","Loads a value from the atomic integer.",76,[[["self"],["ordering"]],["i32"]]],[11,"store","","Stores a value into the atomic integer.",76,[[["self"],["i32"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",76,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",76,[[["self"],["i32"],["i32"],["ordering"]],["i32"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",76,[[["self"],["i32"],["i32"],["ordering"],["ordering"]],["result",["i32","i32"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",76,[[["self"],["i32"],["i32"],["ordering"],["ordering"]],["result",["i32","i32"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",76,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",76,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",76,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",76,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",76,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",76,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",76,[[["self"],["f"],["ordering"],["ordering"]],["result",["i32","i32"]]]],[11,"fetch_max","","Maximum with the current value.",76,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"fetch_min","","Minimum with the current value.",76,[[["self"],["i32"],["ordering"]],["i32"]]],[11,"new","","Creates a new atomic integer.",77,[[["u32"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",77,[[["self"]],["u32"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",77,[[["self"]],["u32"]]],[11,"load","","Loads a value from the atomic integer.",77,[[["self"],["ordering"]],["u32"]]],[11,"store","","Stores a value into the atomic integer.",77,[[["self"],["u32"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",77,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",77,[[["self"],["u32"],["u32"],["ordering"]],["u32"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",77,[[["self"],["u32"],["u32"],["ordering"],["ordering"]],["result",["u32","u32"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",77,[[["self"],["u32"],["u32"],["ordering"],["ordering"]],["result",["u32","u32"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",77,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",77,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",77,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",77,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",77,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",77,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",77,[[["self"],["f"],["ordering"],["ordering"]],["result",["u32","u32"]]]],[11,"fetch_max","","Maximum with the current value.",77,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"fetch_min","","Minimum with the current value.",77,[[["self"],["u32"],["ordering"]],["u32"]]],[11,"new","","Creates a new atomic integer.",78,[[["i64"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",78,[[["self"]],["i64"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",78,[[["self"]],["i64"]]],[11,"load","","Loads a value from the atomic integer.",78,[[["self"],["ordering"]],["i64"]]],[11,"store","","Stores a value into the atomic integer.",78,[[["self"],["i64"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",78,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",78,[[["self"],["i64"],["i64"],["ordering"]],["i64"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",78,[[["self"],["i64"],["i64"],["ordering"],["ordering"]],["result",["i64","i64"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",78,[[["self"],["i64"],["i64"],["ordering"],["ordering"]],["result",["i64","i64"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",78,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",78,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",78,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",78,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",78,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",78,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",78,[[["self"],["f"],["ordering"],["ordering"]],["result",["i64","i64"]]]],[11,"fetch_max","","Maximum with the current value.",78,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"fetch_min","","Minimum with the current value.",78,[[["self"],["i64"],["ordering"]],["i64"]]],[11,"new","","Creates a new atomic integer.",79,[[["u64"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",79,[[["self"]],["u64"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",79,[[["self"]],["u64"]]],[11,"load","","Loads a value from the atomic integer.",79,[[["self"],["ordering"]],["u64"]]],[11,"store","","Stores a value into the atomic integer.",79,[[["self"],["u64"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",79,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",79,[[["self"],["u64"],["u64"],["ordering"]],["u64"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",79,[[["self"],["u64"],["u64"],["ordering"],["ordering"]],["result",["u64","u64"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",79,[[["self"],["u64"],["u64"],["ordering"],["ordering"]],["result",["u64","u64"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",79,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",79,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",79,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",79,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",79,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",79,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",79,[[["self"],["f"],["ordering"],["ordering"]],["result",["u64","u64"]]]],[11,"fetch_max","","Maximum with the current value.",79,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"fetch_min","","Minimum with the current value.",79,[[["self"],["u64"],["ordering"]],["u64"]]],[11,"new","","Creates a new atomic integer.",80,[[["isize"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",80,[[["self"]],["isize"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",80,[[["self"]],["isize"]]],[11,"load","","Loads a value from the atomic integer.",80,[[["self"],["ordering"]],["isize"]]],[11,"store","","Stores a value into the atomic integer.",80,[[["self"],["isize"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",80,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",80,[[["self"],["isize"],["isize"],["ordering"]],["isize"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",80,[[["self"],["isize"],["isize"],["ordering"],["ordering"]],["result",["isize","isize"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",80,[[["self"],["isize"],["isize"],["ordering"],["ordering"]],["result",["isize","isize"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",80,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",80,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",80,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",80,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",80,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",80,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",80,[[["self"],["f"],["ordering"],["ordering"]],["result",["isize","isize"]]]],[11,"fetch_max","","Maximum with the current value.",80,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"fetch_min","","Minimum with the current value.",80,[[["self"],["isize"],["ordering"]],["isize"]]],[11,"new","","Creates a new atomic integer.",81,[[["usize"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",81,[[["self"]],["usize"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",81,[[["self"]],["usize"]]],[11,"load","","Loads a value from the atomic integer.",81,[[["self"],["ordering"]],["usize"]]],[11,"store","","Stores a value into the atomic integer.",81,[[["self"],["usize"],["ordering"]]]],[11,"swap","","Stores a value into the atomic integer, returning the previous value.",81,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,[[["self"],["usize"],["usize"],["ordering"]],["usize"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,[[["self"],["usize"],["usize"],["ordering"],["ordering"]],["result",["usize","usize"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the `current` value.",81,[[["self"],["usize"],["usize"],["ordering"],["ordering"]],["result",["usize","usize"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",81,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous value.",81,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",81,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",81,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",81,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",81,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that returns an optional new value. Returns a `Result` of `Ok(previous_value)` if the function returned `Some(_)`, else `Err(previous_value)`.",81,[[["self"],["f"],["ordering"],["ordering"]],["result",["usize","usize"]]]],[11,"fetch_max","","Maximum with the current value.",81,[[["self"],["usize"],["ordering"]],["usize"]]],[11,"fetch_min","","Minimum with the current value.",81,[[["self"],["usize"],["ordering"]],["usize"]]],[0,"cell","core","Shareable mutable containers.",N,N],[3,"Cell","core::cell","A mutable memory location.",N,N],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",N,N],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",N,N],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",N,N],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box. A wrapper type for an immutably borrowed value from a `RefCell<T>`.",N,N],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell<T>`.",N,N],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",N,N],[11,"get","","Returns a copy of the contained value.",82,[[["self"]],["t"]]],[11,"update","","Updates the contained value using a function and returns the new value.",82,[[["self"],["f"]],["t"]]],[11,"new","","Creates a new `Cell` containing the given value.",82,[[["t"]],["cell"]]],[11,"set","","Sets the contained value.",82,[[["self"],["t"]]]],[11,"swap","","Swaps the values of two Cells. Difference with `std::mem::swap` is that this function doesn't require `&mut` reference.",82,[[["self"],["self"]]]],[11,"replace","","Replaces the contained value, and returns it.",82,[[["self"],["t"]],["t"]]],[11,"into_inner","","Unwraps the value.",82,[[["self"]],["t"]]],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",82,N],[11,"get_mut","","Returns a mutable reference to the underlying data.",82,[[["self"]],["t"]]],[11,"from_mut","","Returns a `&Cell<T>` from a `&mut T`",82,[[["t"]],["cell"]]],[11,"take","","Takes the value of the cell, leaving `Default::default()` in its place.",82,[[["self"]],["t"]]],[11,"as_slice_of_cells","","Returns a `&[Cell<T>]` from a `&Cell<[T]>`",82,N],[11,"new","","Creates a new `RefCell` containing `value`.",83,[[["t"]],["refcell"]]],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",83,[[["self"]],["t"]]],[11,"replace","","Replaces the wrapped value with a new one, returning the old value, without deinitializing either one.",83,[[["self"],["t"]],["t"]]],[11,"replace_with","","Replaces the wrapped value with a new one computed from `f`, returning the old value, without deinitializing either one.",83,[[["self"],["f"]],["t"]]],[11,"swap","","Swaps the wrapped value of `self` with the wrapped value of `other`, without deinitializing either one.",83,[[["self"],["self"]]]],[11,"borrow","","Immutably borrows the wrapped value.",83,[[["self"]],["ref"]]],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error if the value is currently mutably borrowed.",83,[[["self"]],["result",["ref","borrowerror"]]]],[11,"borrow_mut","","Mutably borrows the wrapped value.",83,[[["self"]],["refmut"]]],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if the value is currently borrowed.",83,[[["self"]],["result",["refmut","borrowmuterror"]]]],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",83,N],[11,"get_mut","","Returns a mutable reference to the underlying data.",83,[[["self"]],["t"]]],[11,"clone","","Copies a `Ref`.",84,[[["ref"]],["ref"]]],[11,"map","","Make a new `Ref` for a component of the borrowed data.",84,[[["ref"],["f"]],["ref"]]],[11,"map_split","","Split a `Ref` into multiple `Ref`s for different components of the borrowed data.",84,N],[11,"map","","Make a new `RefMut` for a component of the borrowed data, e.g. an enum variant.",85,[[["refmut"],["f"]],["refmut"]]],[11,"map_split","","Split a `RefMut` into multiple `RefMut`s for different components of the borrowed data.",85,N],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap the specified value.",86,[[["t"]],["unsafecell"]]],[11,"into_inner","","Unwraps the value.",86,[[["self"]],["t"]]],[11,"get","","Gets a mutable pointer to the wrapped value.",86,N],[0,"char","core","A character type.",N,N],[3,"ParseCharError","core::char","An error which can be returned when parsing a char.",N,N],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char fails.",N,N],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",N,N],[3,"DecodeUtf16Error","","An error that can be returned when decoding UTF-16 code points.",N,N],[3,"UnicodeVersion","","Represents a Unicode Version.",N,N],[12,"major","","Major version.",87,N],[12,"minor","","Minor version.",87,N],[12,"micro","","Micro (or Update) version.",87,N],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a character, as `char`s.",N,N],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",N,N],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",N,N],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent of a `char`.",N,N],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",N,N],[5,"from_u32","","Converts a `u32` to a `char`.",N,[[["u32"]],["option",["char"]]]],[5,"from_digit","","Converts a digit in the given radix to a `char`.",N,[[["u32"],["u32"]],["option",["char"]]]],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",N,[[["u32"]],["char"]]],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`, returning unpaired surrogates as `Err`s.",N,[[["i"]],["decodeutf16"]]],[11,"unpaired_surrogate","","Returns the unpaired surrogate which caused this error.",88,[[["self"]],["u16"]]],[17,"UNICODE_VERSION","","The version of Unicode that the Unicode parts of `char` and `str` methods are based on.",N,N],[17,"MAX","","The highest valid code point a `char` can have.",N,N],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a decoding error.",N,N],[0,"panic","core","Panic support in the standard library.",N,N],[3,"PanicInfo","core::panic","A struct providing information about a panic.",N,N],[3,"Location","","A struct containing information about the location of a panic.",N,N],[11,"payload","","Returns the payload associated with the panic.",89,[[["self"]],["any"]]],[11,"message","","If the `panic!` macro from the `core` crate (not from `std`) was used with a formatting string and some additional arguments, returns that message ready to be used for example with [`fmt::write`]",89,[[["self"]],["option",["arguments"]]]],[11,"location","","Returns information about the location from which the panic originated, if available.",89,[[["self"]],["option",["location"]]]],[11,"file","","Returns the name of the source file from which the panic originated.",90,[[["self"]],["str"]]],[11,"line","","Returns the line number from which the panic originated.",90,[[["self"]],["u32"]]],[11,"column","","Returns the column from which the panic originated.",90,[[["self"]],["u32"]]],[0,"panicking","core","Panic support for libcore",N,N],[5,"panic","core::panicking","",N,N],[5,"panic_fmt","","",N,N],[0,"pin","core","Types which pin data to its location in memory",N,N],[3,"Pin","core::pin","A pinned pointer.",N,N],[8,"Unpin","","Types which can be safely moved after being pinned.",N,N],[11,"new","","Construct a new `Pin` around a pointer to some data of a type that implements `Unpin`.",91,[[["p"]],["pin"]]],[11,"new_unchecked","","Construct a new `Pin` around a reference to some data of a type that may or may not implement `Unpin`.",91,[[["p"]],["pin"]]],[11,"as_ref","","Get a pinned shared reference from this pinned pointer.",91,[[["pin"]],["pin"]]],[11,"as_mut","","Get a pinned mutable reference from this pinned pointer.",91,[[["pin"]],["pin"]]],[11,"set","","Assign a new value to the memory behind the pinned reference.",91,N],[11,"map_unchecked","","Construct a new pin by mapping the interior value.",91,[[["pin"],["f"]],["pin"]]],[11,"get_ref","","Get a shared reference out of a pin.",91,[[["pin"]],["t"]]],[11,"into_ref","","Convert this `Pin<&mut T>` into a `Pin<&T>` with the same lifetime.",91,[[["pin"]],["pin"]]],[11,"get_mut","","Get a mutable reference to the data inside of this `Pin`.",91,[[["pin"]],["t"]]],[11,"get_mut_unchecked","","Get a mutable reference to the data inside of this `Pin`.",91,[[["pin"]],["t"]]],[11,"map_unchecked_mut","","Construct a new pin by mapping the interior value.",91,[[["pin"],["f"]],["pin"]]],[0,"iter","core","Composable external iteration.",N,N],[3,"Repeat","core::iter","An iterator that repeats an element endlessly.",N,N],[3,"RepeatWith","","An iterator that repeats elements of type `A` endlessly by applying the provided closure `F: FnMut() -> A`.",N,N],[3,"Empty","","An iterator that yields nothing.",N,N],[3,"Once","","An iterator that yields an element exactly once.",N,N],[3,"Rev","","A double-ended iterator with the direction inverted.",N,N],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",N,N],[3,"Cycle","","An iterator that repeats endlessly.",N,N],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",N,N],[3,"Chain","","An iterator that strings two iterators together.",N,N],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",N,N],[3,"Map","","An iterator that maps the values of `iter` with `f`.",N,N],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",N,N],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",N,N],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",N,N],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next element.",N,N],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",N,N],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",N,N],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",N,N],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",N,N],[3,"Scan","","An iterator to maintain state while iterating another iterator.",N,N],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements of the produced iterators.",N,N],[3,"Flatten","","An iterator that flattens one level of nesting in an iterator of things that can be turned into iterators.",N,N],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator yields `None` once.",N,N],[3,"Inspect","","An iterator that calls a function with a reference to each element before yielding it.",N,N],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",N,[[["t"]],["repeat"]]],[5,"repeat_with","","Creates a new iterator that repeats elements of type `A` endlessly by applying the provided closure, the repeater, `F: FnMut() -> A`.",N,[[["f"]],["repeatwith"]]],[5,"empty","","Creates an iterator that yields nothing.",N,[[],["empty"]]],[5,"once","","Creates an iterator that yields an element exactly once.",N,[[["t"]],["once"]]],[8,"Iterator","","An interface for dealing with iterators.",N,N],[16,"Item","","The type of the elements being iterated over.",92,N],[10,"next","","Advances the iterator and returns the next value.",92,[[["self"]],["option"]]],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",92,N],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",92,[[["self"]],["usize"]]],[11,"last","","Consumes the iterator, returning the last element.",92,[[["self"]],["option"]]],[11,"nth","","Returns the `n`th element of the iterator.",92,[[["self"],["usize"]],["option"]]],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",92,[[["self"],["usize"]],["stepby"]]],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",92,[[["self"],["u"]],["chain"]]],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",92,[[["self"],["u"]],["zip"]]],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",92,[[["self"],["f"]],["map"]]],[11,"for_each","","Calls a closure on each element of an iterator.",92,[[["self"],["f"]]]],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",92,[[["self"],["p"]],["filter"]]],[11,"filter_map","","Creates an iterator that both filters and maps.",92,[[["self"],["f"]],["filtermap"]]],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",92,[[["self"]],["enumerate"]]],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",92,[[["self"]],["peekable"]]],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",92,[[["self"],["p"]],["skipwhile"]]],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",92,[[["self"],["p"]],["takewhile"]]],[11,"skip","","Creates an iterator that skips the first `n` elements.",92,[[["self"],["usize"]],["skip"]]],[11,"take","","Creates an iterator that yields its first `n` elements.",92,[[["self"],["usize"]],["take"]]],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",92,[[["self"],["st"],["f"]],["scan"]]],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",92,[[["self"],["f"]],["flatmap"]]],[11,"flatten","","Creates an iterator that flattens nested structure.",92,[[["self"]],["flatten"]]],[11,"fuse","","Creates an iterator which ends after the first [`None`].",92,[[["self"]],["fuse"]]],[11,"inspect","","Do something with each element of an iterator, passing the value on.",92,[[["self"],["f"]],["inspect"]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",92,[[["self"]],["self"]]],[11,"collect","","Transforms an iterator into a collection.",92,[[["self"]],["b"]]],[11,"partition","","Consumes an iterator, creating two collections from it.",92,N],[11,"try_fold","","An iterator method that applies a function as long as it returns successfully, producing a single, final value.",92,[[["self"],["b"],["f"]],["r"]]],[11,"try_for_each","","An iterator method that applies a fallible function to each item in the iterator, stopping at the first error and returning that error.",92,[[["self"],["f"]],["r"]]],[11,"fold","","An iterator method that applies a function, producing a single, final value.",92,[[["self"],["b"],["f"]],["b"]]],[11,"all","","Tests if every element of the iterator matches a predicate.",92,[[["self"],["f"]],["bool"]]],[11,"any","","Tests if any element of the iterator matches a predicate.",92,[[["self"],["f"]],["bool"]]],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",92,[[["self"],["p"]],["option"]]],[11,"find_map","","Applies function to the elements of iterator and returns the first non-none result.",92,[[["self"],["f"]],["option"]]],[11,"position","","Searches for an element in an iterator, returning its index.",92,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",92,[[["self"],["p"]],["option",["usize"]]]],[11,"max","","Returns the maximum element of an iterator.",92,[[["self"]],["option"]]],[11,"min","","Returns the minimum element of an iterator.",92,[[["self"]],["option"]]],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",92,[[["self"],["f"]],["option"]]],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",92,[[["self"],["f"]],["option"]]],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",92,[[["self"],["f"]],["option"]]],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",92,[[["self"],["f"]],["option"]]],[11,"rev","","Reverses an iterator's direction.",92,[[["self"]],["rev"]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",92,N],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",92,[[["self"]],["cloned"]]],[11,"cycle","","Repeats an iterator endlessly.",92,[[["self"]],["cycle"]]],[11,"sum","","Sums the elements of an iterator.",92,[[["self"]],["s"]]],[11,"product","","Iterates over the entire iterator, multiplying all the elements",92,[[["self"]],["p"]]],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",92,[[["self"],["i"]],["ordering"]]],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",92,[[["self"],["i"]],["option",["ordering"]]]],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",92,[[["self"],["i"]],["bool"]]],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",92,[[["self"],["i"]],["bool"]]],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",92,[[["self"],["i"]],["bool"]]],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",92,[[["self"],["i"]],["bool"]]],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",92,[[["self"],["i"]],["bool"]]],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",92,[[["self"],["i"]],["bool"]]],[8,"Step","","Objects that can be stepped over in both directions.",N,N],[10,"steps_between","","Returns the number of steps between two step objects. The count is inclusive of `start` and exclusive of `end`.",93,[[["self"],["self"]],["option",["usize"]]]],[10,"replace_one","","Replaces this step with `1`, returning itself",93,[[["self"]],["self"]]],[10,"replace_zero","","Replaces this step with `0`, returning itself",93,[[["self"]],["self"]]],[10,"add_one","","Adds one to this step, returning the result",93,[[["self"]],["self"]]],[10,"sub_one","","Subtracts one to this step, returning the result",93,[[["self"]],["self"]]],[10,"add_usize","","Add an usize, returning None on overflow",93,[[["self"],["usize"]],["option"]]],[8,"FromIterator","","Conversion from an `Iterator`.",N,N],[10,"from_iter","","Creates a value from an iterator.",94,[[["t"]],["self"]]],[8,"IntoIterator","","Conversion into an `Iterator`.",N,N],[16,"Item","","The type of the elements being iterated over.",95,N],[16,"IntoIter","","Which kind of iterator are we turning this into?",95,N],[10,"into_iter","","Creates an iterator from a value.",95,N],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",N,N],[10,"next_back","","Removes and returns an element from the end of the iterator.",96,[[["self"]],["option"]]],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes elements starting from the back of the iterator.",96,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",96,[[["self"],["b"],["f"]],["b"]]],[11,"rfind","","Searches for an element of an iterator from the back that satisfies a predicate.",96,[[["self"],["p"]],["option"]]],[8,"Extend","","Extend a collection with the contents of an iterator.",N,N],[10,"extend","","Extends a collection with the contents of an iterator.",97,[[["self"],["t"]]]],[8,"ExactSizeIterator","","An iterator that knows its exact length.",N,N],[11,"len","","Returns the exact number of times the iterator will iterate.",98,[[["self"]],["usize"]]],[11,"is_empty","","Returns whether the iterator is empty.",98,[[["self"]],["bool"]]],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",N,N],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by \"summing up\" the items.",99,[[["i"]],["self"]]],[8,"Product","","Trait to represent types that can be created by multiplying elements of an iterator.",N,N],[10,"product","","Method which takes an iterator and generates `Self` from the elements by multiplying the items.",100,[[["i"]],["self"]]],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",N,N],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",N,N],[11,"peek","","Returns a reference to the next() value without advancing the iterator.",101,[[["self"]],["option"]]],[0,"option","core","Optional values.",N,N],[3,"Iter","core::option","An iterator over a reference to the [`Some`] variant of an [`Option`].",N,N],[3,"IterMut","","An iterator over a mutable reference to the [`Some`] variant of an [`Option`].",N,N],[3,"IntoIter","","An iterator over the value in [`Some`] variant of an [`Option`].",N,N],[3,"NoneError","","The error type that results from applying the try operator (`?`) to a `None` value. If you wish to allow `x?` (where `x` is an `Option<T>`) to be converted into your error type, you can implement `impl From<NoneError>` for `YourErrorType`. In that case, `x?` within a function that returns `Result<_, YourErrorType>` will translate a `None` value into an `Err` result.",N,N],[4,"Option","","The `Option` type. See the module level documentation for more.",N,N],[13,"None","","No value",102,N],[13,"Some","","Some value `T`",102,N],[11,"is_some","","Returns `true` if the option is a [`Some`] value.",102,[[["self"]],["bool"]]],[11,"is_none","","Returns `true` if the option is a [`None`] value.",102,[[["self"]],["bool"]]],[11,"as_ref","","Converts from `Option<T>` to `Option<&T>`.",102,[[["self"]],["option"]]],[11,"as_mut","","Converts from `Option<T>` to `Option<&mut T>`.",102,[[["self"]],["option"]]],[11,"as_pin_ref","","Converts from `Pin<&Option<T>>` to `Option<Pin<&T>>`",102,[[["pin",["option"]]],["option",["pin"]]]],[11,"as_pin_mut","","Converts from `Pin<&mut Option<T>>` to `Option<Pin<&mut T>>`",102,[[["pin",["option"]]],["option",["pin"]]]],[11,"expect","","Unwraps an option, yielding the content of a [`Some`].",102,[[["self"],["str"]],["t"]]],[11,"unwrap","","Moves the value `v` out of the `Option<T>` if it is [`Some(v)`].",102,[[["self"]],["t"]]],[11,"unwrap_or","","Returns the contained value or a default.",102,[[["self"],["t"]],["t"]]],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",102,[[["self"],["f"]],["t"]]],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function to a contained value.",102,[[["self"],["f"]],["option"]]],[11,"map_or","","Applies a function to the contained value (if any), or returns the provided default (if not).",102,[[["self"],["u"],["f"]],["u"]]],[11,"map_or_else","","Applies a function to the contained value (if any), or computes a default (if not).",102,[[["self"],["d"],["f"]],["u"]]],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err)`].",102,[[["self"],["e"]],["result"]]],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`], mapping [`Some(v)`] to [`Ok(v)`] and [`None`] to [`Err(err())`].",102,[[["self"],["f"]],["result"]]],[11,"iter","","Returns an iterator over the possibly contained value.",102,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",102,[[["self"]],["itermut"]]],[11,"and","","Returns [`None`] if the option is [`None`], otherwise returns `optb`.",102,[[["self"],["option"]],["option"]]],[11,"and_then","","Returns [`None`] if the option is [`None`], otherwise calls `f` with the wrapped value and returns the result.",102,[[["self"],["f"]],["option"]]],[11,"filter","","Returns `None` if the option is `None`, otherwise calls `predicate` with the wrapped value and returns:",102,[[["self"],["p"]],["self"]]],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",102,[[["self"],["option"]],["option"]]],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and returns the result.",102,[[["self"],["f"]],["option"]]],[11,"xor","","Returns [`Some`] if exactly one of `self`, `optb` is [`Some`], otherwise returns `None`.",102,[[["self"],["option"]],["option"]]],[11,"get_or_insert","","Inserts `v` into the option if it is [`None`], then returns a mutable reference to the contained value.",102,[[["self"],["t"]],["t"]]],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is [`None`], then returns a mutable reference to the contained value.",102,[[["self"],["f"]],["t"]]],[11,"take","","Takes the value out of the option, leaving a [`None`] in its place.",102,[[["self"]],["option"]]],[11,"replace","","Replaces the actual value in the option by the value given in parameter, returning the old value if present, leaving a [`Some`] in its place without deinitializing either one.",102,[[["self"],["t"]],["option"]]],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the contents of the option.",102,[[["self"]],["option"]]],[11,"cloned","","Maps an `Option<&mut T>` to an `Option<T>` by cloning the contents of the option.",102,[[["self"]],["option"]]],[11,"unwrap_or_default","","Returns the contained value or a default",102,[[["self"]],["t"]]],[11,"deref","","Converts from `&Option<T>` to `Option<&T::Target>`.",102,[[["self"]],["option"]]],[11,"transpose","","Transposes an `Option` of a `Result` into a `Result` of an `Option`.",102,[[["self"]],["result",["option"]]]],[0,"raw","core","Contains struct definitions for the layout of compiler built-in types.",N,N],[3,"TraitObject","core::raw","The representation of a trait object like `&SomeTrait`.",N,N],[12,"data","","",103,N],[12,"vtable","","",103,N],[0,"result","core","Error handling with the `Result` type.",N,N],[3,"Iter","core::result","An iterator over a reference to the [`Ok`] variant of a [`Result`].",N,N],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",N,N],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`].",N,N],[4,"Result","","`Result` is a type that represents either success ([`Ok`]) or failure ([`Err`]).",N,N],[13,"Ok","","Contains the success value",104,N],[13,"Err","","Contains the error value",104,N],[11,"is_ok","","Returns `true` if the result is [`Ok`].",104,[[["self"]],["bool"]]],[11,"is_err","","Returns `true` if the result is [`Err`].",104,[[["self"]],["bool"]]],[11,"ok","","Converts from `Result<T, E>` to [`Option<T>`].",104,[[["self"]],["option"]]],[11,"err","","Converts from `Result<T, E>` to [`Option<E>`].",104,[[["self"]],["option"]]],[11,"as_ref","","Converts from `Result<T, E>` to `Result<&T, &E>`.",104,[[["self"]],["result"]]],[11,"as_mut","","Converts from `Result<T, E>` to `Result<&mut T, &mut E>`.",104,[[["self"]],["result"]]],[11,"map","","Maps a `Result<T, E>` to `Result<U, E>` by applying a function to a contained [`Ok`] value, leaving an [`Err`] value untouched.",104,[[["self"],["f"]],["result"]]],[11,"map_or_else","","Maps a `Result<T, E>` to `U` by applying a function to a contained [`Ok`] value, or a fallback function to a contained [`Err`] value.",104,[[["self"],["f"],["m"]],["u"]]],[11,"map_err","","Maps a `Result<T, E>` to `Result<T, F>` by applying a function to a contained [`Err`] value, leaving an [`Ok`] value untouched.",104,[[["self"],["o"]],["result"]]],[11,"iter","","Returns an iterator over the possibly contained value.",104,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",104,[[["self"]],["itermut"]]],[11,"and","","Returns `res` if the result is [`Ok`], otherwise returns the [`Err`] value of `self`.",104,[[["self"],["result"]],["result"]]],[11,"and_then","","Calls `op` if the result is [`Ok`], otherwise returns the [`Err`] value of `self`.",104,[[["self"],["f"]],["result"]]],[11,"or","","Returns `res` if the result is [`Err`], otherwise returns the [`Ok`] value of `self`.",104,[[["self"],["result"]],["result"]]],[11,"or_else","","Calls `op` if the result is [`Err`], otherwise returns the [`Ok`] value of `self`.",104,[[["self"],["o"]],["result"]]],[11,"unwrap_or","","Unwraps a result, yielding the content of an [`Ok`]. Else, it returns `optb`.",104,[[["self"],["t"]],["t"]]],[11,"unwrap_or_else","","Unwraps a result, yielding the content of an [`Ok`]. If the value is an [`Err`] then it calls `op` with its value.",104,[[["self"],["f"]],["t"]]],[11,"unwrap","","Unwraps a result, yielding the content of an [`Ok`].",104,[[["self"]],["t"]]],[11,"expect","","Unwraps a result, yielding the content of an [`Ok`].",104,[[["self"],["str"]],["t"]]],[11,"unwrap_err","","Unwraps a result, yielding the content of an [`Err`].",104,[[["self"]],["e"]]],[11,"expect_err","","Unwraps a result, yielding the content of an [`Err`].",104,[[["self"],["str"]],["e"]]],[11,"unwrap_or_default","","Returns the contained value or a default",104,[[["self"]],["t"]]],[11,"deref_ok","","Converts from `&Result<T, E>` to `Result<&T::Target, &E>`.",104,[[["self"]],["result"]]],[11,"deref_err","","Converts from `&Result<T, E>` to `Result<&T, &E::Target>`.",104,[[["self"]],["result"]]],[11,"deref","","Converts from `&Result<T, E>` to `Result<&T::Target, &E::Target>`.",104,[[["self"]],["result"]]],[11,"transpose","","Transposes a `Result` of an `Option` into an `Option` of a `Result`.",104,[[["self"]],["option",["result"]]]],[0,"ffi","core","Utilities related to FFI bindings.",N,N],[4,"c_void","core::ffi","Equivalent to C's `void` type when used as a [pointer].",N,N],[0,"slice","core","Slice management and manipulation",N,N],[3,"Iter","core::slice","Immutable slice iterator",N,N],[3,"IterMut","","Mutable slice iterator.",N,N],[3,"Split","","An iterator over subslices separated by elements that match a predicate function.",N,N],[3,"SplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`.",N,N],[3,"RSplit","","An iterator over subslices separated by elements that match a predicate function, starting from the end of the slice.",N,N],[3,"RSplitMut","","An iterator over the subslices of the vector which are separated by elements that match `pred`, starting from the end of the slice.",N,N],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",N,N],[3,"RSplitN","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",N,N],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits.",N,N],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a predicate function, limited to a given number of splits, starting from the end of the slice.",N,N],[3,"Windows","","An iterator over overlapping subslices of length `size`.",N,N],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time), starting at the beginning of the slice.",N,N],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time), starting at the beginning of the slice.",N,N],[3,"ChunksExact","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time), starting at the beginning of the slice.",N,N],[3,"ChunksExactMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time), starting at the beginning of the slice.",N,N],[3,"RChunks","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time), starting at the end of the slice.",N,N],[3,"RChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time), starting at the end of the slice.",N,N],[3,"RChunksExact","","An iterator over a slice in (non-overlapping) chunks (`chunk_size` elements at a time), starting at the end of the slice.",N,N],[3,"RChunksExactMut","","An iterator over a slice in (non-overlapping) mutable chunks (`chunk_size` elements at a time), starting at the end of the slice.",N,N],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",N,N],[5,"from_raw_parts_mut","","Performs the same functionality as [`from_raw_parts`], except that a mutable slice is returned.",N,N],[5,"from_ref","","Converts a reference to T into a slice of length 1 (without copying).",N,N],[5,"from_mut","","Converts a reference to T into a slice of length 1 (without copying).",N,N],[0,"memchr","","Pure rust memchr implementation, taken from rust-memchr",N,N],[5,"memchr","core::slice::memchr","Return the first index matching the byte `x` in `text`.",N,N],[5,"memrchr","","Return the last index matching the byte `x` in `text`.",N,N],[8,"SliceIndex","core::slice","A helper trait used for indexing operations.",N,N],[16,"Output","","The output type returned by methods.",105,N],[10,"get","","Returns a shared reference to the output at this location, if in bounds.",105,[[["self"],["t"]],["option"]]],[10,"get_mut","","Returns a mutable reference to the output at this location, if in bounds.",105,[[["self"],["t"]],["option"]]],[10,"get_unchecked","","Returns a shared reference to the output at this location, without performing any bounds checking.",105,N],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without performing any bounds checking.",105,N],[10,"index","","Returns a shared reference to the output at this location, panicking if out of bounds.",105,N],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking if out of bounds.",105,N],[11,"as_slice","","View the underlying data as a subslice of the original data.",106,N],[11,"into_slice","","View the underlying data as a subslice of the original data.",107,N],[11,"remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",108,N],[11,"into_remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",109,N],[11,"remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",110,N],[11,"into_remainder","","Return the remainder of the original slice that is not going to be returned by the iterator. The returned slice has at most `chunk_size-1` elements.",111,N],[0,"str","core","String manipulation",N,N],[3,"ParseBoolError","core::str","An error returned when parsing a `bool` using [`from_str`] fails",N,N],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of [`u8`] as a string.",N,N],[3,"Chars","","An iterator over the [`char`]s of a string slice.",N,N],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and their positions.",N,N],[3,"Bytes","","An iterator over the bytes of a string slice.",N,N],[3,"Split","","Created with the method [`split`].",N,N],[3,"RSplit","","Created with the method [`rsplit`].",N,N],[3,"SplitTerminator","","Created with the method [`split_terminator`].",N,N],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",N,N],[3,"SplitN","","Created with the method [`splitn`].",N,N],[3,"RSplitN","","Created with the method [`rsplitn`].",N,N],[3,"MatchIndices","","Created with the method [`match_indices`].",N,N],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",N,N],[3,"Matches","","Created with the method [`matches`].",N,N],[3,"RMatches","","Created with the method [`rmatches`].",N,N],[3,"Lines","","An iterator over the lines of a string, as string slices.",N,N],[3,"LinesAny","","Created with the method [`lines_any`].",N,N],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string, separated by any amount of whitespace.",N,N],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a string, separated by any amount of ASCII whitespace.",N,N],[3,"EncodeUtf16","","An iterator of [`u16`] over the string encoded as UTF-16.",N,N],[5,"from_utf8","","Converts a slice of bytes to a string slice.",N,N],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",N,N],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8.",N,N],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without checking that the string contains valid UTF-8; mutable version.",N,N],[5,"next_code_point","","Reads the next code point out of a byte iterator (assuming a UTF-8-like encoding).",N,[[["i"]],["option",["u32"]]]],[5,"utf8_char_width","","Given a first byte, determines how many bytes are in this UTF-8 character.",N,[[["u8"]],["usize"]]],[0,"pattern","","The string Pattern API.",N,N],[3,"CharSearcher","core::str::pattern","Associated type for `<char as Pattern<'a>>::Searcher`.",N,N],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",N,N],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",N,N],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",N,N],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",N,N],[13,"Match","","Expresses that a match of the pattern has been found at `haystack[a..b]`.",112,N],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match of the pattern.",112,N],[13,"Done","","Expresses that every byte of the haystack has been visited, ending the iteration.",112,N],[8,"Pattern","","A string pattern.",N,N],[16,"Searcher","","Associated searcher for this pattern",113,N],[10,"into_searcher","","Constructs the associated searcher from `self` and the `haystack` to search in.",113,N],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",113,[[["self"],["str"]],["bool"]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",113,[[["self"],["str"]],["bool"]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",113,[[["self"],["str"]],["bool"]]],[8,"Searcher","","A searcher for a string pattern.",N,N],[10,"haystack","","Getter for the underlying string to be searched in",114,[[["self"]],["str"]]],[10,"next","","Performs the next search step starting from the front.",114,[[["self"]],["searchstep"]]],[11,"next_match","","Find the next `Match` result. See `next()`",114,[[["self"]],["option"]]],[11,"next_reject","","Find the next `Reject` result. See `next()` and `next_match()`",114,[[["self"]],["option"]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",N,N],[10,"next_back","","Performs the next search step starting from the back.",115,[[["self"]],["searchstep"]]],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",115,[[["self"]],["option"]]],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",115,[[["self"]],["option"]]],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be used for a `DoubleEndedIterator` implementation.",N,N],[0,"lossy","core::str","",N,N],[3,"Utf8Lossy","core::str::lossy","Lossy UTF-8 string.",N,N],[3,"Utf8LossyChunksIter","","Iterator over lossy UTF-8 string",N,N],[3,"Utf8LossyChunk","","",N,N],[12,"valid","","Sequence of valid chars. Can be empty between broken UTF-8 chars.",116,N],[12,"broken","","Single broken char, empty if none. Empty iff iterator item is last.",116,N],[11,"from_str","","",117,[[["str"]],["utf8lossy"]]],[11,"from_bytes","","",117,N],[11,"chunks","","",117,[[["self"]],["utf8lossychunksiter"]]],[8,"FromStr","core::str","A trait to abstract the idea of creating a new instance of a type from a string.",N,N],[16,"Err","","The associated error which can be returned from parsing.",118,N],[10,"from_str","","Parses a string `s` to return a value of this type.",118,[[["str"]],["result"]]],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was verified.",119,[[["self"]],["usize"]]],[11,"error_len","","Provide more information about the failure:",119,[[["self"]],["option",["usize"]]]],[11,"as_str","","View the underlying data as a subslice of the original data.",120,[[["self"]],["str"]]],[11,"as_str","","View the underlying data as a subslice of the original data.",121,[[["self"]],["str"]]],[0,"hash","core","Generic hashing support.",N,N],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",N,N],[3,"BuildHasherDefault","","Used to create a default [`BuildHasher`] instance for types that implement [`Hasher`] and [`Default`].",N,N],[11,"new","","Creates a new `SipHasher` with the two initial keys set to 0.",122,[[],["siphasher"]]],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",122,[[["u64"],["u64"]],["siphasher"]]],[8,"Hash","","A hashable type.",N,N],[10,"hash","","Feeds this value into the given [`Hasher`].",123,[[["self"],["h"]]]],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",123,N],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",N,N],[10,"finish","","Returns the hash value for the values written so far.",124,[[["self"]],["u64"]]],[10,"write","","Writes some data into this `Hasher`.",124,N],[11,"write_u8","","Writes a single `u8` into this hasher.",124,[[["self"],["u8"]]]],[11,"write_u16","","Writes a single `u16` into this hasher.",124,[[["self"],["u16"]]]],[11,"write_u32","","Writes a single `u32` into this hasher.",124,[[["self"],["u32"]]]],[11,"write_u64","","Writes a single `u64` into this hasher.",124,[[["self"],["u64"]]]],[11,"write_u128","","Writes a single `u128` into this hasher.",124,[[["self"],["u128"]]]],[11,"write_usize","","Writes a single `usize` into this hasher.",124,[[["self"],["usize"]]]],[11,"write_i8","","Writes a single `i8` into this hasher.",124,[[["self"],["i8"]]]],[11,"write_i16","","Writes a single `i16` into this hasher.",124,[[["self"],["i16"]]]],[11,"write_i32","","Writes a single `i32` into this hasher.",124,[[["self"],["i32"]]]],[11,"write_i64","","Writes a single `i64` into this hasher.",124,[[["self"],["i64"]]]],[11,"write_i128","","Writes a single `i128` into this hasher.",124,[[["self"],["i128"]]]],[11,"write_isize","","Writes a single `isize` into this hasher.",124,[[["self"],["isize"]]]],[8,"BuildHasher","","A trait for creating instances of [`Hasher`].",N,N],[16,"Hasher","","Type of the hasher that will be created.",125,N],[10,"build_hasher","","Creates a new hasher.",125,N],[0,"fmt","core","Utilities for formatting and printing strings.",N,N],[3,"DebugStruct","core::fmt","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",N,N],[3,"Error","","The error type which is returned from formatting a message into a stream.",N,N],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they should be formatted. A mutable version of this is passed to all formatting traits.",N,N],[3,"Arguments","","This structure represents a safely precompiled version of a format string and its arguments. This cannot be generated at runtime because it cannot safely be done, so no constructors are given and the fields are private to prevent modification.",N,N],[4,"Alignment","","Possible alignments returned by `Formatter::align`",N,N],[13,"Left","","Indication that contents should be left-aligned.",126,N],[13,"Right","","Indication that contents should be right-aligned.",126,N],[13,"Center","","Indication that contents should be center-aligned.",126,N],[5,"write","","The `write` function takes an output stream, and an `Arguments` struct that can be precompiled with the `format_args!` macro.",N,[[["write"],["arguments"]],["result"]]],[11,"field","","Adds a new field to the generated struct output.",127,[[["self"],["str"],["debug"]],["debugstruct"]]],[11,"finish","","Finishes output and returns any error encountered.",127,[[["self"]],["result"]]],[11,"field","","Adds a new field to the generated tuple struct output.",128,[[["self"],["debug"]],["debugtuple"]]],[11,"finish","","Finishes output and returns any error encountered.",128,[[["self"]],["result"]]],[11,"entry","","Adds a new entry to the set output.",129,[[["self"],["debug"]],["debugset"]]],[11,"entries","","Adds the contents of an iterator of entries to the set output.",129,[[["self"],["i"]],["debugset"]]],[11,"finish","","Finishes output and returns any error encountered.",129,[[["self"]],["result"]]],[11,"entry","","Adds a new entry to the list output.",130,[[["self"],["debug"]],["debuglist"]]],[11,"entries","","Adds the contents of an iterator of entries to the list output.",130,[[["self"],["i"]],["debuglist"]]],[11,"finish","","Finishes output and returns any error encountered.",130,[[["self"]],["result"]]],[11,"entry","","Adds a new entry to the map output.",131,[[["self"],["debug"],["debug"]],["debugmap"]]],[11,"entries","","Adds the contents of an iterator of entries to the map output.",131,[[["self"],["i"]],["debugmap"]]],[11,"finish","","Finishes output and returns any error encountered.",131,[[["self"]],["result"]]],[6,"Result","","The type returned by formatter methods.",N,N],[8,"Write","","A collection of methods that are required to format a message into a stream.",N,N],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write succeeded.",132,[[["self"],["str"]],["result"]]],[11,"write_char","","Writes a [`char`] into this writer, returning whether the write succeeded.",132,[[["self"],["char"]],["result"]]],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors of this trait.",132,[[["self"],["arguments"]],["result"]]],[8,"Debug","","`?` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",133,[[["self"],["formatter"]],["result"]]],[8,"Display","","Format trait for an empty format, `{}`.",N,N],[10,"fmt","","Formats the value using the given formatter.",134,[[["self"],["formatter"]],["result"]]],[8,"Octal","","`o` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",135,[[["self"],["formatter"]],["result"]]],[8,"Binary","","`b` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",136,[[["self"],["formatter"]],["result"]]],[8,"LowerHex","","`x` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",137,[[["self"],["formatter"]],["result"]]],[8,"UpperHex","","`X` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",138,[[["self"],["formatter"]],["result"]]],[8,"Pointer","","`p` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",139,[[["self"],["formatter"]],["result"]]],[8,"LowerExp","","`e` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",140,[[["self"],["formatter"]],["result"]]],[8,"UpperExp","","`E` formatting.",N,N],[10,"fmt","","Formats the value using the given formatter.",141,[[["self"],["formatter"]],["result"]]],[11,"pad_integral","","Performs the correct padding for an integer which has already been emitted into a str. The str should not contain the sign for the integer, that will be added by this method.",142,[[["self"],["bool"],["str"],["str"]],["result"]]],[11,"pad","","This function takes a string slice and emits it to the internal buffer after applying the relevant formatting flags specified. The flags recognized for generic strings are:",142,[[["self"],["str"]],["result"]]],[11,"write_str","","Writes some data to the underlying buffer contained within this formatter.",142,[[["self"],["str"]],["result"]]],[11,"write_fmt","","Writes some formatted information into this instance.",142,[[["self"],["arguments"]],["result"]]],[11,"flags","","Flags for formatting",142,[[["self"]],["u32"]]],[11,"fill","","Character used as 'fill' whenever there is alignment.",142,[[["self"]],["char"]]],[11,"align","","Flag indicating what form of alignment was requested.",142,[[["self"]],["option",["alignment"]]]],[11,"width","","Optionally specified integer width that the output should be.",142,[[["self"]],["option",["usize"]]]],[11,"precision","","Optionally specified precision for numeric types.",142,[[["self"]],["option",["usize"]]]],[11,"sign_plus","","Determines if the `+` flag was specified.",142,[[["self"]],["bool"]]],[11,"sign_minus","","Determines if the `-` flag was specified.",142,[[["self"]],["bool"]]],[11,"alternate","","Determines if the `#` flag was specified.",142,[[["self"]],["bool"]]],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",142,[[["self"]],["bool"]]],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with creation of [`fmt::Debug`] implementations for structs.",142,[[["self"],["str"]],["debugstruct"]]],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of `fmt::Debug` implementations for tuple structs.",142,[[["self"],["str"]],["debugtuple"]]],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of `fmt::Debug` implementations for list-like structures.",142,[[["self"]],["debuglist"]]],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of `fmt::Debug` implementations for set-like structures.",142,[[["self"]],["debugset"]]],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of `fmt::Debug` implementations for map-like structures.",142,[[["self"]],["debugmap"]]],[0,"time","core","Temporal quantification.",N,N],[3,"Duration","core::time","A `Duration` type to represent a span of time, typically used for system timeouts.",N,N],[11,"new","","Creates a new `Duration` from the specified number of whole seconds and additional nanoseconds.",143,[[["u64"],["u32"]],["duration"]]],[11,"from_secs","","Creates a new `Duration` from the specified number of whole seconds.",143,[[["u64"]],["duration"]]],[11,"from_millis","","Creates a new `Duration` from the specified number of milliseconds.",143,[[["u64"]],["duration"]]],[11,"from_micros","","Creates a new `Duration` from the specified number of microseconds.",143,[[["u64"]],["duration"]]],[11,"from_nanos","","Creates a new `Duration` from the specified number of nanoseconds.",143,[[["u64"]],["duration"]]],[11,"as_secs","","Returns the number of whole seconds contained by this `Duration`.",143,[[["self"]],["u64"]]],[11,"subsec_millis","","Returns the fractional part of this `Duration`, in whole milliseconds.",143,[[["self"]],["u32"]]],[11,"subsec_micros","","Returns the fractional part of this `Duration`, in whole microseconds.",143,[[["self"]],["u32"]]],[11,"subsec_nanos","","Returns the fractional part of this `Duration`, in nanoseconds.",143,[[["self"]],["u32"]]],[11,"as_millis","","Returns the total number of whole milliseconds contained by this `Duration`.",143,[[["self"]],["u128"]]],[11,"as_micros","","Returns the total number of whole microseconds contained by this `Duration`.",143,[[["self"]],["u128"]]],[11,"as_nanos","","Returns the total number of nanoseconds contained by this `Duration`.",143,[[["self"]],["u128"]]],[11,"checked_add","","Checked `Duration` addition. Computes `self + other`, returning [`None`] if overflow occurred.",143,[[["self"],["duration"]],["option",["duration"]]]],[11,"checked_sub","","Checked `Duration` subtraction. Computes `self - other`, returning [`None`] if the result would be negative or if overflow occurred.",143,[[["self"],["duration"]],["option",["duration"]]]],[11,"checked_mul","","Checked `Duration` multiplication. Computes `self * other`, returning [`None`] if overflow occurred.",143,[[["self"],["u32"]],["option",["duration"]]]],[11,"checked_div","","Checked `Duration` division. Computes `self / other`, returning [`None`] if `other == 0`.",143,[[["self"],["u32"]],["option",["duration"]]]],[11,"as_float_secs","","Returns the number of seconds contained by this `Duration` as `f64`.",143,[[["self"]],["f64"]]],[11,"from_float_secs","","Creates a new `Duration` from the specified number of seconds.",143,[[["f64"]],["duration"]]],[11,"mul_f64","","Multiply `Duration` by `f64`.",143,[[["self"],["f64"]],["duration"]]],[11,"div_f64","","Divide `Duration` by `f64`.",143,[[["self"],["f64"]],["duration"]]],[11,"div_duration","","Divide `Duration` by `Duration` and return `f64`.",143,[[["self"],["duration"]],["f64"]]],[0,"unicode","core","",N,N],[0,"derived_property","core::unicode","",N,N],[5,"Case_Ignorable","core::unicode::derived_property","",N,[[["char"]],["bool"]]],[5,"Cased","","",N,[[["char"]],["bool"]]],[0,"conversions","core::unicode","",N,N],[5,"to_lower","core::unicode::conversions","",N,N],[5,"to_upper","","",N,N],[0,"property","core::unicode","",N,N],[5,"Pattern_White_Space","core::unicode::property","",N,[[["char"]],["bool"]]],[0,"future","core","Asynchronous values.",N,N],[8,"Future","core::future","A future represents an asychronous computation.",N,N],[16,"Output","","The result of the `Future`.",144,N],[10,"poll","","Attempt to resolve the future to a final value, registering the current task for wakeup if the value is not yet available.",144,[[["pin"],["localwaker"]],["poll"]]],[0,"task","core","Types and Traits for working with asynchronous tasks.",N,N],[3,"Waker","core::task","A `Waker` is a handle for waking up a task by notifying its executor that it is ready to be run.",N,N],[3,"LocalWaker","","A `LocalWaker` is a handle for waking up a task by notifying its executor that it is ready to be run.",N,N],[4,"Poll","","Indicates whether a value is available or if the current task has been scheduled to receive a wakeup instead.",N,N],[13,"Ready","","Represents that a value is immediately ready.",145,N],[13,"Pending","","Represents that a value is not ready yet.",145,N],[11,"map","","Change the ready value of this `Poll` with the closure provided",145,[[["self"],["f"]],["poll"]]],[11,"is_ready","","Returns whether this is `Poll::Ready`",145,[[["self"]],["bool"]]],[11,"is_pending","","Returns whether this is `Poll::Pending`",145,[[["self"]],["bool"]]],[11,"map_ok","","Change the success value of this `Poll` with the closure provided",145,[[["self"],["f"]],["poll",["result"]]]],[11,"map_err","","Change the error value of this `Poll` with the closure provided",145,[[["self"],["f"]],["poll",["result"]]]],[11,"new","","Constructs a new `Waker` directly.",146,[[["nonnull",["unsafewake"]]],["self"]]],[11,"wake","","Wake up the task associated with this `Waker`.",146,[[["self"]]]],[11,"will_wake","","Returns whether or not this `Waker` and `other` awaken the same task.",146,[[["self"],["waker"]],["bool"]]],[11,"will_wake_local","","Returns whether or not this `Waker` and `other` `LocalWaker` awaken the same task.",146,[[["self"],["localwaker"]],["bool"]]],[11,"new","","Constructs a new `LocalWaker` directly.",147,[[["nonnull",["unsafewake"]]],["self"]]],[11,"as_waker","","Borrows this `LocalWaker` as a `Waker`.",147,[[["self"]],["waker"]]],[11,"into_waker","","Converts this `LocalWaker` into a `Waker`.",147,[[["self"]],["waker"]]],[11,"wake","","Wake up the task associated with this `LocalWaker`.",147,[[["self"]]]],[11,"will_wake","","Returns whether or not this `LocalWaker` and `other` `LocalWaker` awaken the same task.",147,[[["self"],["localwaker"]],["bool"]]],[11,"will_wake_nonlocal","","Returns whether or not this `LocalWaker` and `other` `Waker` awaken the same task.",147,[[["self"],["waker"]],["bool"]]],[8,"UnsafeWake","","An unsafe trait for implementing custom memory management for a `Waker` or `LocalWaker`.",N,N],[10,"clone_raw","","Creates a clone of this `UnsafeWake` and stores it behind a `Waker`.",148,[[["self"]],["waker"]]],[10,"drop_raw","","Drops this instance of `UnsafeWake`, deallocating resources associated with it.",148,[[["self"]]]],[10,"wake","","Indicates that the associated task is ready to make progress and should be `poll`ed.",148,[[["self"]]]],[11,"wake_local","","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is the same as `wake`, but can only be called from the thread that this `UnsafeWake` is \"local\" to. This allows for implementors to provide specialized wakeup behavior specific to the current thread. This function is called by `LocalWaker::wake`.",148,[[["self"]]]],[0,"alloc","core","Memory allocation APIs",N,N],[3,"Excess","core::alloc","Represents the combination of a starting address and a total capacity of the returned block.",N,N],[12,"0","","",149,N],[12,"1","","",149,N],[3,"Layout","","Layout of a block of memory.",N,N],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` or some other `Layout` constructor do not satisfy its documented constraints.",N,N],[3,"AllocErr","","The `AllocErr` error indicates an allocation failure that may be due to resource exhaustion or to something wrong when combining the given input arguments with this allocator.",N,N],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when `grow_in_place` or `shrink_in_place` were unable to reuse the given memory block for a requested layout.",N,N],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard library’s default though the `#[global_allocator]` attributes.",N,N],[10,"alloc","","Allocate memory as described by the given `layout`.",150,N],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer with the given `layout`.",150,N],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",150,N],[11,"realloc","","Shink or grow a block of memory to the given `new_size`. The block is described by the given `ptr` pointer and `layout`.",150,N],[8,"Alloc","","An implementation of `Alloc` can allocate, reallocate, and deallocate arbitrary blocks of data described via `Layout`.",N,N],[10,"alloc","","Returns a pointer meeting the size and alignment guarantees of `layout`.",151,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",151,[[["self"],["nonnull",["u8"]],["layout"]]]],[11,"usable_size","","Returns bounds on the guaranteed usable size of a successful allocation created with the specified `layout`.",151,N],[11,"realloc","","Returns a pointer suitable for holding data described by a new layout with `layout`’s alginment and a size given by `new_size`. To accomplish this, this may extend or shrink the allocation referenced by `ptr` to fit the new layout.",151,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents are set to zero before being returned.",151,[[["self"],["layout"]],["result",["nonnull","allocerr"]]]],[11,"alloc_excess","","Behaves like `alloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",151,[[["self"],["layout"]],["result",["excess","allocerr"]]]],[11,"realloc_excess","","Behaves like `realloc`, but also returns the whole size of the returned block. For some `layout` inputs, like arrays, this may include extra storage usable for additional data.",151,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["excess","allocerr"]]]],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to fit `new_size`.",151,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["cannotreallocinplace"]]]],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to fit `new_size`.",151,[[["self"],["nonnull",["u8"]],["layout"],["usize"]],["result",["cannotreallocinplace"]]]],[11,"alloc_one","","Allocates a block suitable for holding an instance of `T`.",151,[[["self"]],["result",["nonnull","allocerr"]]]],[11,"dealloc_one","","Deallocates a block suitable for holding an instance of `T`.",151,[[["self"],["nonnull"]]]],[11,"alloc_array","","Allocates a block suitable for holding `n` instances of `T`.",151,[[["self"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"realloc_array","","Reallocates a block previously suitable for holding `n_old` instances of `T`, returning a block suitable for holding `n_new` instances of `T`.",151,[[["self"],["nonnull"],["usize"],["usize"]],["result",["nonnull","allocerr"]]]],[11,"dealloc_array","","Deallocates a block suitable for holding `n` instances of `T`.",151,[[["self"],["nonnull"],["usize"]],["result",["allocerr"]]]],[11,"from_size_align","","Constructs a `Layout` from a given `size` and `align`, or returns `LayoutErr` if either of the following conditions are not met:",152,[[["usize"],["usize"]],["result",["layouterr"]]]],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",152,[[["usize"],["usize"]],["self"]]],[11,"size","","The minimum size in bytes for a memory block of this layout.",152,[[["self"]],["usize"]]],[11,"align","","The minimum byte alignment for a memory block of this layout.",152,[[["self"]],["usize"]]],[11,"new","","Constructs a `Layout` suitable for holding a value of type `T`.",152,[[],["self"]]],[11,"for_value","","Produces layout describing a record that could be used to allocate backing structure for `T` (which could be a trait or other unsized type like a slice).",152,[[["t"]],["self"]]],[11,"align_to","","Creates a layout describing the record that can hold a value of the same layout as `self`, but that also is aligned to alignment `align` (measured in bytes).",152,[[["self"],["usize"]],["self"]]],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self` to ensure that the following address will satisfy `align` (measured in bytes).",152,[[["self"],["usize"]],["usize"]]],[11,"repeat","","Creates a layout describing the record for `n` instances of `self`, with a suitable amount of padding between each to ensure that each instance is given its requested size and alignment. On success, returns `(k, offs)` where `k` is the layout of the array and `offs` is the distance between the start of each element in the array.",152,[[["self"],["usize"]],["result",["layouterr"]]]],[11,"extend","","Creates a layout describing the record for `self` followed by `next`, including any necessary padding to ensure that `next` will be properly aligned. Note that the result layout will satisfy the alignment properties of both `self` and `next`.",152,[[["self"],["self"]],["result",["layouterr"]]]],[11,"repeat_packed","","Creates a layout describing the record for `n` instances of `self`, with no padding between each instance.",152,[[["self"],["usize"]],["result",["layouterr"]]]],[11,"extend_packed","","Creates a layout describing the record for `self` followed by `next` with no additional padding between the two. Since no padding is inserted, the alignment of `next` is irrelevant, and is not incorporated at all into the resulting layout.",152,[[["self"],["self"]],["result",["layouterr"]]]],[11,"array","","Creates a layout describing the record for a `[T; n]`.",152,[[["usize"]],["result",["layouterr"]]]],[11,"description","","",153,[[["self"]],["str"]]],[0,"arch","core","Platform dependent vendor intrinsics.",N,N],[0,"x86","core::arch","Platform-specific intrinsics for the `x86` platform.",N,N],[3,"__m64","core::arch::x86","64-bit wide integer vector type, x86-specific",N,N],[3,"__m128i","","128-bit wide integer vector type, x86-specific",N,N],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",N,N],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",N,N],[3,"__m256i","","256-bit wide integer vector type, x86-specific",N,N],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",N,N],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",N,N],[3,"CpuidResult","","Result of the `cpuid` instruction.",N,N],[12,"eax","","EAX register.",154,N],[12,"ebx","","EBX register.",154,N],[12,"ecx","","ECX register.",154,N],[12,"edx","","EDX register.",154,N],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_bswap","","Return an integer with the reversed byte order of x",N,[[["i32"]],["i32"]]],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp counter.",N,[[],["i64"]]],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp counter and the `IA32_TSC_AUX MSR`.",N,N],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given `leaf` (`EAX`) and `sub_leaf` (`ECX`).",N,[[["u32"],["u32"]],["cpuidresult"]]],[5,"__cpuid","","See `__cpuid_count`.",N,[[["u32"]],["cpuidresult"]]],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",N,[[],["bool"]]],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf (`ECX`) `cpuid` values.",N,N],[5,"_xsave","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xrstor","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_xsetbv","","Copy 64-bits from `val` to the extended control register (`XCR`) specified by `a`.",N,[[["u32"],["u64"]]]],[5,"_xgetbv","","Reads the contents of the extended control register `XCR` specified in `xcr_no`.",N,[[["u32"]],["u64"]]],[5,"_xsaveopt","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsavec","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsaves","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",N,N],[5,"_xrstors","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_add_ps","","Adds __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_div_ps","","Divides __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sqrt_ss","","Return the square root of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ss","","Return the approximate reciprocal of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ps","","Return the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ss","","Return the approximate reciprocal square root of the fist single-precision (32-bit) floating-point elements in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ps","","Return the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_min_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the minimum value in the first element of the return value, the other elements are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding minimum values.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_max_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the maximum value in the first element of the return value, the other elements are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding maximum values.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ss","","Compare the lowest `f32` of both inputs for equality. The lowest 32 bits of the result will be `0xffffffff` if the two inputs are equal, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmplt_ss","","Compare the lowest `f32` of both inputs for less than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmple_ss","","Compare the lowest `f32` of both inputs for less than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ss","","Compare the lowest `f32` of both inputs for greater than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpge_ss","","Compare the lowest `f32` of both inputs for greater than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ss","","Compare the lowest `f32` of both inputs for inequality. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ss","","Compare the lowest `f32` of both inputs for not-less-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ss","","Compare the lowest `f32` of both inputs for not-less-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ss","","Compare the lowest `f32` of both inputs for not-greater-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ss","","Compare the lowest `f32` of both inputs for not-greater-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpord_ss","","Check if the lowest `f32` of both inputs are ordered. The lowest 32 bits of the result will be `0xffffffff` if neither of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ss","","Check if the lowest `f32` of both inputs are unordered. The lowest 32 bits of the result will be `0xffffffff` if any of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements were equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmplt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmple_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements are not equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are ordered (i.e., neither of them is a NaN), or 0 otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are unordered (i.e., at least on of them is a NaN), or 0 otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_comieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_cvtss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvttss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer with truncation.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvtss_f32","","Extract the lowest 32 bit float from the input vector.",N,[[["__m128"]],["f32"]]],[5,"_mm_cvtsi32_ss","","Convert a 32 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a` and the rest set to zero.",N,[[["f32"]],["__m128"]]],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",N,[[["f32"]],["__m128"]]],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",N,[[["f32"]],["__m128"]]],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values highest to lowest.",N,[[["f32"],["f32"],["f32"],["f32"]],["__m128"]]],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values lowest to highest.",N,[[["f32"],["f32"],["f32"],["f32"]],["__m128"]]],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",N,[[],["__m128"]]],[5,"_MM_SHUFFLE","","A utility function for creating masks to use with Intel shuffle and permute intrinsics.",N,[[["u32"],["u32"],["u32"],["u32"]],["u32"]]],[5,"_mm_shuffle_ps","","Shuffle packed single-precision (32-bit) floating-point elements in `a` and `b` using `mask`.",N,[[["__m128"],["__m128"],["u32"]],["__m128"]]],[5,"_mm_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the higher half of `a` and `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the lower half of `a` and `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b` occupies the lower half of result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b` occupies the higher half of result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movemask_ps","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128"]],["i32"]]],[5,"_mm_loadh_pi","","Set the upper two single-precision floating-point values with 64 bits of data loaded from the address `p`; the lower two values are passed through from `a`.",N,N],[5,"_mm_loadl_pi","","Load two floats from `p` into the lower half of a `__m128`. The upper half is copied from the upper half of `a`.",N,N],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p` and the other elements set to zero.",N,N],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from `p` into all elements.",N,N],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",N,N],[5,"_mm_load_ps","","Load four `f32` values from aligned memory into a `__m128`. If the pointer is not aligned to a 128-bit boundary (16 bytes) a general protection fault will be triggered (fatal program crash).",N,N],[5,"_mm_loadu_ps","","Load four `f32` values from memory into a `__m128`. There are no restrictions on memory alignment. For aligned memory `_mm_load_ps` may be faster.",N,N],[5,"_mm_loadr_ps","","Load four `f32` values from aligned memory into a `__m128` in reverse order.",N,N],[5,"_mm_storeh_pi","","Store the upper half of `a` (64 bits) into memory.",N,N],[5,"_mm_storel_pi","","Store the lower half of `a` (64 bits) into memory.",N,N],[5,"_mm_store_ss","","Store the lowest 32 bit float of `a` into memory.",N,N],[5,"_mm_store1_ps","","Store the lowest 32 bit float of `a` repeated four times into aligned memory.",N,N],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",N,N],[5,"_mm_store_ps","","Store four 32-bit floats into aligned memory.",N,N],[5,"_mm_storeu_ps","","Store four 32-bit floats into memory. There are no restrictions on memory alignment. For aligned memory `_mm_store_ps` may be faster.",N,N],[5,"_mm_storer_ps","","Store four 32-bit floats into aligned memory in reverse order.",N,N],[5,"_mm_move_ss","","Return a `__m128` with the first component from `b` and the remaining components from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sfence","","Perform a serializing operation on all store-to-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_getcsr","","Get the unsigned 32-bit value of the MXCSR control and status register.",N,[[],["u32"]]],[5,"_mm_setcsr","","Set the MXCSR register with the 32-bit unsigned integer value.",N,[[["u32"]]]],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the given `strategy`.",N,N],[5,"_mm_undefined_ps","","Return vector of type __m128 with undefined elements.",N,[[],["__m128"]]],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in place.",N,[[["__m128"],["__m128"],["__m128"],["__m128"]]]],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a non-temporal memory hint.",N,N],[5,"_mm_stream_pi","","Store 64-bits of integer data from a into memory using a non-temporal memory hint.",N,N],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mullo_pi16","","Multiplies packed 16-bit integer values and writes the low-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",N,[[["__m128"],["__m64"]],["__m128"]]],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",N,[[["__m128"],["__m64"]],["__m128"]]],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each 64-bit vector operand of `[2 x i32]` into a 128-bit vector of `[4 x float]`.",N,[[["__m64"],["__m64"]],["__m128"]]],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",N,N],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",N,N],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",N,[[["__m64"],["i32"]],["i32"]]],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",N,[[["__m64"],["i32"]],["i32"]]],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",N,[[["__m64"],["i32"],["i32"]],["__m64"]]],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",N,[[["__m64"],["i32"],["i32"]],["__m64"]]],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",N,[[["__m64"]],["i32"]]],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",N,[[["__m64"]],["i32"]]],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",N,[[["__m64"],["i32"]],["__m64"]]],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",N,[[["__m64"],["i32"]],["__m64"]]],[5,"_mm_cvttps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi16","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 16-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi8","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 8-bit integers, and returns theem in the lower 4 elements of the result.",N,[[["__m128"]],["__m64"]]],[5,"_mm_pause","","Provide a hint to the processor that the code sequence is a spin-wait loop.",N,[[]]],[5,"_mm_clflush","","Invalidate and flush the cache line that contains `p` from all levels of the cache hierarchy.",N,N],[5,"_mm_lfence","","Perform a serializing operation on all load-from-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_mfence","","Perform a serializing operation on all load-from-memory and store-to-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_add_epi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi64","","Add packed 64-bit integers in `a` and \"b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_madd_epi16","","Multiply and then horizontally add signed 16 bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit integers.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bslli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bsrli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_and_si128","","Compute the bitwise AND of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_andnot_si128","","Compute the bitwise NOT of 128 bits (representing integer data) in `a` and then AND with `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_or_si128","","Compute the bitwise OR of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_xor_si128","","Compute the bitwise XOR of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi8","","Compare packed 8-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi16","","Compare packed 16-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi32","","Compare packed 32-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_pd","","Convert the lower two packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128i"]],["__m128d"]]],[5,"_mm_cvtsi32_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m128i"]],["__m128"]]],[5,"_mm_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_cvtsi32_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",N,[[["i32"]],["__m128i"]]],[5,"_mm_cvtsi128_si32","","Return the lowest element of `a`.",N,[[["__m128i"]],["i32"]]],[5,"_mm_set_epi64x","","Set packed 64-bit integers with the supplied values, from highest to lowest.",N,[[["i64"],["i64"]],["__m128i"]]],[5,"_mm_set_epi32","","Set packed 32-bit integers with the supplied values.",N,[[["i32"],["i32"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_set_epi16","","Set packed 16-bit integers with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m128i"]]],[5,"_mm_set_epi8","","Set packed 8-bit integers with the supplied values.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m128i"]]],[5,"_mm_set1_epi64x","","Broadcast 64-bit integer `a` to all elements.",N,[[["i64"]],["__m128i"]]],[5,"_mm_set1_epi32","","Broadcast 32-bit integer `a` to all elements.",N,[[["i32"]],["__m128i"]]],[5,"_mm_set1_epi16","","Broadcast 16-bit integer `a` to all elements.",N,[[["i16"]],["__m128i"]]],[5,"_mm_set1_epi8","","Broadcast 8-bit integer `a` to all elements.",N,[[["i8"]],["__m128i"]]],[5,"_mm_setr_epi32","","Set packed 32-bit integers with the supplied values in reverse order.",N,[[["i32"],["i32"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_setr_epi16","","Set packed 16-bit integers with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m128i"]]],[5,"_mm_setr_epi8","","Set packed 8-bit integers with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m128i"]]],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",N,[[],["__m128i"]]],[5,"_mm_loadl_epi64","","Load 64-bit integer from memory into first element of returned vector.",N,N],[5,"_mm_load_si128","","Load 128-bits of integer data from memory into a new vector.",N,N],[5,"_mm_loadu_si128","","Load 128-bits of integer data from memory into a new vector.",N,N],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into memory using `mask`.",N,N],[5,"_mm_store_si128","","Store 128-bits of integer data from `a` into memory.",N,N],[5,"_mm_storeu_si128","","Store 128-bits of integer data from `a` into memory.",N,N],[5,"_mm_storel_epi64","","Store the lower 64-bit integer `a` to a memory location.",N,N],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_move_epi64","","Return a vector where the low element is extracted from `a` and its upper element is zero.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_extract_epi16","","Return the `imm8` element of `a`.",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_epi16","","Return a new vector where the `imm8` element of `a` is replaced with `i`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_movemask_epi8","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128i"]],["i32"]]],[5,"_mm_shuffle_epi32","","Shuffle 32-bit integers in `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_sd","","Return a new vector with the low element of `a` replaced by the sum of the low elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_div_sd","","Return a new vector with the low element of `a` replaced by the result of diving the lower element of `a` by the lower element of `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point elements in `a` by packed elements in `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_max_sd","","Return a new vector with the low element of `a` replaced by the maximum of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_max_pd","","Return a new vector with the maximum values from corresponding elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_min_sd","","Return a new vector with the low element of `a` replaced by the minimum of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_min_pd","","Return a new vector with the minimum values from corresponding elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_mul_sd","","Return a new vector with the low element of `a` replaced by multiplying the low elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_mul_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_sd","","Return a new vector with the low element of `a` replaced by the square root of the lower element `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_pd","","Return a new vector with the square root of each of the values in `a`.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_sub_sd","","Return a new vector with the low element of `a` replaced by subtracting the low element by `b` from the low element of `a`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from `a`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_and_pd","","Compute the bitwise AND of packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_andnot_pd","","Compute the bitwise NOT of `a` and then AND with `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_or_pd","","Compute the bitwise OR of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_xor_pd","","Compute the bitwise OR of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_sd","","Return a new vector with the low element of `a` replaced by the equality comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_sd","","Return a new vector with the low element of `a` replaced by the less-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmple_sd","","Return a new vector with the low element of `a` replaced by the less-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_sd","","Return a new vector with the low element of `a` replaced by the greater-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_sd","","Return a new vector with the low element of `a` replaced by the greater-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If neither are equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If either is equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_sd","","Return a new vector with the low element of `a` replaced by the not-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_sd","","Return a new vector with the low element of `a` replaced by the not-less-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_sd","","Return a new vector with the low element of `a` replaced by the not-less-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_pd","","Compare corresponding elements in `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_pd","","Compare corresponding elements in `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmple_pd","","Compare corresponding elements in `a` and `b` for less-than-or-equal",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_pd","","Compare corresponding elements in `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_pd","","Compare corresponding elements in `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_pd","","Compare corresponding elements in `a` and `b` to see if neither is `NaN`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_pd","","Compare corresponding elements in `a` and `b` to see if either is `NaN`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_pd","","Compare corresponding elements in `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_pd","","Compare corresponding elements in `a` and `b` for not-less-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_pd","","Compare corresponding elements in `a` and `b` for not-less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_pd","","Compare corresponding elements in `a` and `b` for not-greater-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_pd","","Compare corresponding elements in `a` and `b` for not-greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_comieq_sd","","Compare the lower element of `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comilt_sd","","Compare the lower element of `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comigt_sd","","Compare the lower element of `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comineq_sd","","Compare the lower element of `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomieq_sd","","Compare the lower element of `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomilt_sd","","Compare the lower element of `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomigt_sd","","Compare the lower element of `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomineq_sd","","Compare the lower element of `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in \"a\" to packed single-precision (32-bit) floating-point elements",N,[[["__m128d"]],["__m128"]]],[5,"_mm_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128"]],["__m128d"]]],[5,"_mm_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvtsd_si32","","Convert the lower double-precision (64-bit) floating-point element in a to a 32-bit integer.",N,[[["__m128d"]],["i32"]]],[5,"_mm_cvtsd_ss","","Convert the lower double-precision (64-bit) floating-point element in `b` to a single-precision (32-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",N,[[["__m128"],["__m128d"]],["__m128"]]],[5,"_mm_cvtsd_f64","","Return the lower double-precision (64-bit) floating-point element of \"a\".",N,[[["__m128d"]],["f64"]]],[5,"_mm_cvtss_sd","","Convert the lower single-precision (32-bit) floating-point element in `b` to a double-precision (64-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",N,[[["__m128d"],["__m128"]],["__m128d"]]],[5,"_mm_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvttsd_si32","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 32-bit integer with truncation.",N,[[["__m128d"]],["i32"]]],[5,"_mm_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_set_sd","","Copy double-precision (64-bit) floating-point element `a` to the lower element of the packed 64-bit return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set1_pd","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd1","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values.",N,[[["f64"],["f64"]],["__m128d"]]],[5,"_mm_setr_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values in reverse order.",N,[[["f64"],["f64"]],["__m128d"]]],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point elements with all zeros.",N,[[],["__m128d"]]],[5,"_mm_movemask_pd","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128d"]],["i32"]]],[5,"_mm_load_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element of a 128-bit integer vector and clears the upper element.",N,N],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of a 128-bit vector of `[2 x double]`. The low-order bits are copied from the low-order bits of the first operand.",N,N],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of a 128-bit vector of `[2 x double]`. The high-order bits are copied from the high-order bits of the first operand.",N,N],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]` to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_store_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storeu_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm_store1_pd","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_store_pd1","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storer_pd","","Store 2 double-precision (64-bit) floating-point elements from `a` into memory in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_load1_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",N,N],[5,"_mm_load_pd1","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",N,N],[5,"_mm_loadr_pd","","Load 2 double-precision (64-bit) floating-point elements from memory into the returned vector in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_loadu_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x double]` from two 128-bit vector parameters of `[2 x double]`, using the immediate-value parameter as a specifier.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x double]`. The lower 64 bits are set to the lower 64 bits of the second parameter. The upper 64 bits are set to the upper 64 bits of the first parameter.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit floating-point vector of `[4 x float]`.",N,[[["__m128d"]],["__m128"]]],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit integer vector.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit floating-point vector of `[2 x double]`.",N,[[["__m128"]],["__m128d"]]],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit integer vector.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[2 x double]`.",N,[[["__m128i"]],["__m128d"]]],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[4 x float]`.",N,[[["__m128i"]],["__m128"]]],[5,"_mm_undefined_pd","","Return vector of type __m128d with undefined elements.",N,[[],["__m128d"]]],[5,"_mm_undefined_si128","","Return vector of type __m128i with undefined elements.",N,[[],["__m128i"]]],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the low-order values of the two `__m128d` interleaved input elements, i.e.:",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the high-order values of the two `__m128d` interleaved input elements, i.e.:",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values, returning the lower 64 bits of the sum.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the lower bits of the two 64-bit integer vectors and returns the 64-bit unsigned product.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and writes the difference to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a 64-bit vector of `[2 x i32]` into two double-precision floating-point values, returned in a 128-bit vector of `[2 x double]`.",N,[[["__m64"]],["__m128d"]]],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2 x i64]` with the specified 64-bit integer values.",N,[[["__m64"],["__m64"]],["__m128i"]]],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]` with the specified 64-bit value.",N,[[["__m64"]],["__m128i"]]],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in reverse order with the specified 64-bit integral values.",N,[[["__m64"],["__m64"]],["__m128i"]]],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a 64-bit integer.",N,[[["__m128i"]],["__m64"]]],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector, zeroing the upper bits.",N,[[["__m64"]],["__m128i"]]],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`.",N,[[["__m128d"]],["__m64"]]],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`. If the result of either conversion is inexact, the result is truncated (rounded towards zero) regardless of the current MXCSR setting.",N,[[["__m128d"]],["__m64"]]],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hadd_pd","","Horizontally add adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hadd_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hsub_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_lddqu_si128","","Load 128-bits of integer data from unaligned memory. This intrinsic may perform better than `_mm_loadu_si128` when the data crosses a cache line boundary.",N,N],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point element from `a`.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_loaddup_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of return vector.",N,N],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_abs_epi8","","Compute the absolute value of packed 8-bit signed integers in `a` and return the unsigned results.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi16","","Compute the absolute value of each of the packed 16-bit signed integers in `a` and return the 16-bit unsigned integer",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi32","","Compute the absolute value of each of the packed 32-bit signed integers in `a` and return the 32-bit unsigned integer",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_hadd_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hadds_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hadd_epi32","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_maddubs_epi16","","Multiply corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, add pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhrs_epi16","","Multiply packed 16-bit signed integer values, truncate the 32-bit product to the 18 most significant bits by right-shifting, round the truncated value by adding 1, and write bits `[16:1]` to the destination.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the result. Elements in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Elements in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_abs_pi8","","Compute the absolute value of packed 8-bit integers in `a` and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi16","","Compute the absolute value of packed 8-bit integers in `a`, and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi32","","Compute the absolute value of packed 32-bit integers in `a`, and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_shuffle_pi8","","Shuffle packed 8-bit integers in `a` according to shuffle control mask in the corresponding 8-bit element of `b`, and return the results",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and right-shifts the result by the number of bytes specified in the immediate operand.",N,[[["__m64"],["__m64"],["i32"]],["__m64"]]],[5,"_mm_hadd_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hadd_pi32","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hadds_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, adds pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates the 32-bit products to the 18 most significant bits by right-shifting, rounds the truncated value by adding 1, and writes bits `[16:1]` to the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",N,[[["__m128i"],["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the mask `imm8`.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `mask`",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `mask`",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm2`",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using mask `imm4`",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_extract_ps","","Extract a single-precision (32-bit) floating-point element from `a`, selected with `imm8`",N,[[["__m128"],["i32"]],["i32"]]],[5,"_mm_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_extract_epi32","","Extract an 32-bit integer from `a` selected with `imm8`",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in `b`, Then zero elements according to `imm8`.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_insert_epi8","","Return a copy of `a` with the 8-bit integer from `i` inserted at a location specified by `imm8`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_insert_epi32","","Return a copy of `a` with the 32-bit integer from `i` inserted at a location specified by `imm8`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_max_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed maximum values in dst.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed maximum.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed minimum values in dst.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed minimum.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in `a` to packed 16-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` down to an integer value, and store the results as packed double-precision floating-point elements.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` down to an integer value, and store the results as packed single-precision floating-point elements.",N,[[["__m128"]],["__m128"]]],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point element in `b` down to an integer value, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point element in `b` down to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` up to an integer value, and store the results as packed double-precision floating-point elements.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` up to an integer value, and store the results as packed single-precision floating-point elements.",N,[[["__m128"]],["__m128"]]],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point element in `b` up to an integer value, store the result as a double-precision floating-point element in the lower element of the intrisic result, and copy the upper element from `a` to the upper element of the intrinsic result.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point element in `b` up to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed double-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed single-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point element in `b` using the `rounding` parameter, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point element in `b` using the `rounding` parameter, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the instrinsic result. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit __m128i vector, returning a vector containing its value in its first position, and its index in its second position; all other elements are set to zero.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`, and return the signed 64-bit result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and returns the lowest 32-bit, whatever they might be, reinterpreted as a signed integer. While `pmulld __m128i::splat(2), __m128i::splat(2)` returns the obvious `__m128i::splat(4)`, due to wrapping arithmetic `pmulld __m128i::splat(i32::MAX), __m128i::splat(2)` would return a negative number.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the absolute values of the differences to the corresponding bits in the destination. Then sums of the absolute differences are returned according to the bit fields in the immediate operand.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer vector are all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer vector are all ones.",N,[[["__m128i"]],["i32"]]],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_cmpistrm","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return the generated mask.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_cmpistri","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpestri`] with the exception that [`_mm_cmpestri`] requires the lengths of `a` and `b` to be explicitly specified.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrz","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if any character in `b` was null. and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrc","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrs","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and returns `1` if any character in `a` was null, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistro","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return bit `0` of the resulting bit mask.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistra","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrm","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return the generated mask.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_cmpestri","","Compare packed strings `a` and `b` with lengths `la` and `lb` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpistri`] with the exception that [`_mm_cmpistri`] implicitly determines the length of `a` and `b`.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrz","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in `b` was null, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrc","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrs","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in a was null, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestro","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return bit `0` of the resulting bit mask.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestra","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 8-bit integer `v`.",N,[[["u32"],["u8"]],["u32"]]],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 16-bit integer `v`.",N,[[["u32"],["u16"]],["u32"]]],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 32-bit integer `v`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_mm_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than, return the results.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_add_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_and_pd","","Compute the bitwise AND of a packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_and_ps","","Compute the bitwise AND of packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_or_pd","","Compute the bitwise OR packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_or_ps","","Compute the bitwise OR packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements within 128-bit lanes using the control in `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_andnot_pd","","Compute the bitwise NOT of packed double-precision (64-bit) floating-point elements in `a` and then AND with `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_andnot_ps","","Compute the bitwise NOT of packed single-precision (32-bit) floating-point elements in `a` and then AND with `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_max_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed maximum values",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed maximum values",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_min_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed minimum values",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed minimum values",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_mul_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_mul_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from packed elements in `a`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_sub_ps","","Subtract packed single-precision (32-bit) floating-point elements in `b` from packed elements in `a`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_div_ps","","Compute the division of each of the 8 packed 32-bit floating-point elements in `a` by the corresponding packed elements in `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_div_pd","","Compute the division of each of the 4 packed 64-bit floating-point elements in `a` by the corresponding packed elements in `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_round_pd","","Round packed double-precision (64-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_ceil_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward positive infinity.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_floor_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward negative infinity.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_round_ps","","Round packed single-precision (32-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",N,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_ceil_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward positive infinity.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_floor_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward negative infinity.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating point elements in `a`.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_pd","","Return the square root of packed double-precision (64-bit) floating point elements in `a`.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using control mask `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `c` as a mask.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `c` as a mask.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_dp_ps","","Conditionally multiply the packed single-precision (32-bit) floating-point elements in `a` and `b` using the high 4 bits in `imm8`, sum the four products, and conditionally return the sum  using the low 4 bits of `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_xor_pd","","Compute the bitwise XOR of packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_xor_ps","","Compute the bitwise XOR of packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm256_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm_cmp_sd","","Compare the lower double-precision (64-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper element from `a` to the upper element of returned vector.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cmp_ss","","Compare the lower single-precision (32-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper 3 packed elements from `a` to the upper elements of returned vector.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm256_cvtepi32_pd","","Convert packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128i"]],["__m256d"]]],[5,"_mm256_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m256i"]],["__m256"]]],[5,"_mm256_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m256d"]],["__m128"]]],[5,"_mm256_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128"]],["__m256d"]]],[5,"_mm256_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_extractf128_ps","","Extract 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `a`, selected with `imm8`.",N,[[["__m256"],["i32"]],["__m128"]]],[5,"_mm256_extractf128_pd","","Extract 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a`, selected with `imm8`.",N,[[["__m256d"],["i32"]],["__m128d"]]],[5,"_mm256_extractf128_si256","","Extract 128 bits (composed of integer data) from `a`, selected with `imm8`.",N,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_zeroall","","Zero the contents of all XMM or YMM registers.",N,[[]]],[5,"_mm256_zeroupper","","Zero the upper 128 bits of all YMM registers; the lower 128-bits of the registers are unmodified.",N,[[]]],[5,"_mm256_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `b`.",N,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `b`.",N,[[["__m128"],["__m128i"]],["__m128"]]],[5,"_mm256_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `imm8`.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm256_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 256-bit lanes using the control in `b`.",N,[[["__m256d"],["__m256i"]],["__m256d"]]],[5,"_mm_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `b`.",N,[[["__m128d"],["__m128i"]],["__m128d"]]],[5,"_mm256_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `imm8`.",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_permute2f128_ps","","Shuffle 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) selected by `imm8` from `a` and `b`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_permute2f128_pd","","Shuffle 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) selected by `imm8` from `a` and `b`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_permute2f128_si256","","Shuffle 258-bits (composed of integer data) selected by `imm8` from `a` and `b`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f32"]],["__m256"]]],[5,"_mm_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f32"]],["__m128"]]],[5,"_mm256_broadcast_sd","","Broadcast a double-precision (64-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f64"]],["__m256d"]]],[5,"_mm256_broadcast_ps","","Broadcast 128 bits from memory (composed of 4 packed single-precision (32-bit) floating-point elements) to all elements of the returned vector.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_broadcast_pd","","Broadcast 128 bits from memory (composed of 2 packed double-precision (64-bit) floating-point elements) to all elements of the returned vector.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_insertf128_ps","","Copy `a` to result, then insert 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",N,[[["__m256"],["__m128"],["i32"]],["__m256"]]],[5,"_mm256_insertf128_pd","","Copy `a` to result, then insert 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",N,[[["__m256d"],["__m128d"],["i32"]],["__m256d"]]],[5,"_mm256_insertf128_si256","","Copy `a` to result, then insert 128 bits from `b` into result at the location specified by `imm8`.",N,[[["__m256i"],["__m128i"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi8","","Copy `a` to result, and insert the 8-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i8"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi16","","Copy `a` to result, and insert the 16-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i16"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi32","","Copy `a` to result, and insert the 32-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_load_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_load_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_loadu_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_load_si256","","Load 256-bits of integer data from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_si256","","Store 256-bits of integer data from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_loadu_si256","","Load 256-bits of integer data from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_si256","","Store 256-bits of integer data from `a` into memory.    `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm256_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm256_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm256_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit) floating-point elements from \"a\", and return the results.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_lddqu_si256","","Load 256-bits of integer data from unaligned memory into result. This intrinsic may perform better than `_mm256_loadu_si256` when the data crosses a cache line boundary.",N,N],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon)",N,N],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4 x double]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a 256-bit vector of `[8 x float]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm256_rcp_ps","","Compute the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_rsqrt_ps","","Compute the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_unpackhi_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_unpacklo_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_testz_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testnzc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testz_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm256_testc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm256_testnzc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm_testz_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_testc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_testnzc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm256_testz_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm256_testc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm256_testnzc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm_testz_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_testc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_testnzc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm256_movemask_pd","","Set each bit of the returned mask based on the most significant bit of the corresponding packed double-precision (64-bit) floating-point element in `a`.",N,[[["__m256d"]],["i32"]]],[5,"_mm256_movemask_ps","","Set each bit of the returned mask based on the most significant bit of the corresponding packed single-precision (32-bit) floating-point element in `a`.",N,[[["__m256"]],["i32"]]],[5,"_mm256_setzero_pd","","Return vector of type __m256d with all elements set to zero.",N,[[],["__m256d"]]],[5,"_mm256_setzero_ps","","Return vector of type __m256 with all elements set to zero.",N,[[],["__m256"]]],[5,"_mm256_setzero_si256","","Return vector of type __m256i with all elements set to zero.",N,[[],["__m256i"]]],[5,"_mm256_set_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values.",N,[[["f64"],["f64"],["f64"],["f64"]],["__m256d"]]],[5,"_mm256_set_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values.",N,[[["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"]],["__m256"]]],[5,"_mm256_set_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m256i"]]],[5,"_mm256_set_epi16","","Set packed 16-bit integers in returned vector with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m256i"]]],[5,"_mm256_set_epi32","","Set packed 32-bit integers in returned vector with the supplied values.",N,[[["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_set_epi64x","","Set packed 64-bit integers in returned vector with the supplied values.",N,[[["i64"],["i64"],["i64"],["i64"]],["__m256i"]]],[5,"_mm256_setr_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values in reverse order.",N,[[["f64"],["f64"],["f64"],["f64"]],["__m256d"]]],[5,"_mm256_setr_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values in reverse order.",N,[[["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"]],["__m256"]]],[5,"_mm256_setr_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m256i"]]],[5,"_mm256_setr_epi16","","Set packed 16-bit integers in returned vector with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m256i"]]],[5,"_mm256_setr_epi32","","Set packed 32-bit integers in returned vector with the supplied values in reverse order.",N,[[["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_setr_epi64x","","Set packed 64-bit integers in returned vector with the supplied values in reverse order.",N,[[["i64"],["i64"],["i64"],["i64"]],["__m256i"]]],[5,"_mm256_set1_pd","","Broadcast double-precision (64-bit) floating-point value `a` to all elements of returned vector.",N,[[["f64"]],["__m256d"]]],[5,"_mm256_set1_ps","","Broadcast single-precision (32-bit) floating-point value `a` to all elements of returned vector.",N,[[["f32"]],["__m256"]]],[5,"_mm256_set1_epi8","","Broadcast 8-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastb`.",N,[[["i8"]],["__m256i"]]],[5,"_mm256_set1_epi16","","Broadcast 16-bit integer `a` to all all elements of returned vector. This intrinsic may generate the `vpbroadcastw`.",N,[[["i16"]],["__m256i"]]],[5,"_mm256_set1_epi32","","Broadcast 32-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastd`.",N,[[["i32"]],["__m256i"]]],[5,"_mm256_set1_epi64x","","Broadcast 64-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastq`.",N,[[["i64"]],["__m256i"]]],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",N,[[["__m256d"]],["__m256"]]],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",N,[[["__m256"]],["__m256d"]]],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",N,[[["__m256i"]],["__m256"]]],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",N,[[["__m256d"]],["__m256i"]]],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",N,[[["__m256i"]],["__m256d"]]],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",N,[[["__m256"]],["__m128"]]],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",N,[[["__m256d"]],["__m128d"]]],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",N,[[["__m256i"]],["__m128i"]]],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128 bits of the result are undefined.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper 128 bits of the result are undefined.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper 128 bits of the result are undefined.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x float]` from a 128-bit floating-point vector of `[4 x float]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer vector. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x double]` from a 128-bit floating-point vector of `[2 x double]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_undefined_ps","","Return vector of type `__m256` with undefined elements.",N,[[],["__m256"]]],[5,"_mm256_undefined_pd","","Return vector of type `__m256d` with undefined elements.",N,[[],["__m256d"]]],[5,"_mm256_undefined_si256","","Return vector of type __m256i with undefined elements.",N,[[],["__m256i"]]],[5,"_mm256_set_m128","","Set packed __m256 returned vector with the supplied values.",N,[[["__m128"],["__m128"]],["__m256"]]],[5,"_mm256_set_m128d","","Set packed __m256d returned vector with the supplied values.",N,[[["__m128d"],["__m128d"]],["__m256d"]]],[5,"_mm256_set_m128i","","Set packed __m256i returned vector with the supplied values.",N,[[["__m128i"],["__m128i"]],["__m256i"]]],[5,"_mm256_setr_m128","","Set packed __m256 returned vector with the supplied values.",N,[[["__m128"],["__m128"]],["__m256"]]],[5,"_mm256_setr_m128d","","Set packed __m256d returned vector with the supplied values.",N,[[["__m128d"],["__m128d"]],["__m256d"]]],[5,"_mm256_setr_m128i","","Set packed __m256i returned vector with the supplied values.",N,[[["__m128i"],["__m128i"]],["__m256i"]]],[5,"_mm256_loadu2_m128","","Load two 128-bit values (composed of 4 packed single-precision (32-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu2_m128d","","Load two 128-bit values (composed of 2 packed double-precision (64-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu2_m128i","","Load two 128-bit values (composed of integer data) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128","","Store the high and low 128-bit halves (each composed of 4 packed single-precision (32-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128d","","Store the high and low 128-bit halves (each composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128i","","Store the high and low 128-bit halves (each composed of integer data) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x float]`.",N,[[["__m256"]],["f32"]]],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi64","","Add packed 64-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_alignr_epi8","","Concatenate pairs of 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_and_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_andnot_si256","","Compute the bitwise NOT of 256 bits (representing integer data) in `a` and then AND with `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm256_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`.",N,[[["__m256i"],["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 128-bit returned value.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm256_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 256-bit returned value.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_broadcastsi128_si256","","Broadcast 128 bits of integer data from a to all 128-bit lanes in the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 128-bit returned value.",N,[[["__m128"]],["__m128"]]],[5,"_mm256_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 256-bit returned value.",N,[[["__m128"]],["__m256"]]],[5,"_mm_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 128-bit returned value",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 256-bit returned value",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers, and store the results in dst.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a` to 64-bit integers. The upper four elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a` to 32-bit integers. The upper eight elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a` to 64-bit integers. The upper twelve elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_extracti128_si256","","Extract 128 bits (of integer data) from `a` selected with `imm8`.",N,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_hadd_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hadd_epi32","","Horizontally add adjacent pairs of 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hadds_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_inserti128_si256","","Copy `a` to `dst`, then insert 128 bits (of integer data) from `b` at the location specified by `imm8`.",N,[[["__m256i"],["__m128i"],["i32"]],["__m256i"]]],[5,"_mm256_madd_epi16","","Multiply packed signed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Horizontally add adjacent pairs of intermediate 32-bit integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_maddubs_epi16","","Vertically multiply each unsigned 8-bit integer from `a` with the corresponding signed 8-bit integer from `b`, producing intermediate signed 16-bit integers. Horizontally add adjacent pairs of intermediate signed 16-bit integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_movemask_epi8","","Create mask from the most significant bit of each 8-bit element in `a`, return the result.",N,[[["__m256i"]],["i32"]]],[5,"_mm256_mpsadbw_epu8","","Compute the sum of absolute differences (SADs) of quadruplets of unsigned 8-bit integers in `a` compared to those in `b`, and store the 16-bit results in dst. Eight SADs are performed for each 128-bit lane using one quadruplet from `b` and eight quadruplets from `a`. One quadruplet is selected from `b` starting at on the offset specified in `imm8`. Eight quadruplets are formed from sequential 8-bit integers selected from `a` starting at the offset specified in `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers, and return the low 16 bits of the intermediate integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and return the low 16 bits of the intermediate integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhrs_epi16","","Multiply packed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Truncate each intermediate integer to the 18 most significant bits, round by adding 1, and return bits `[16:1]`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_or_si256","","Compute the bitwise OR of 256 bits (representing integer data) in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the content of `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute2x128_si256","","Shuffle 128-bits of integer data selected by `imm8` from `a` and `b`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute4x64_pd","","Shuffle 64-bit floating-point elements in `a` across lanes using the control in `imm8`.",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_permutevar8x32_ps","","Shuffle eight 32-bit foating-point elements in `a` across lanes using the corresponding 32-bit integer index in `idx`.",N,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm256_sad_epu8","","Compute the absolute differences of packed unsigned 8-bit integers in `a` and `b`, then horizontally sum each consecutive 8 differences to produce four unsigned 16-bit integers, and pack these unsigned 16-bit integers in the low 16 bits of the 64-bit return value",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi32","","Shuffle 32-bit integers in 128-bit lanes of `a` using the control in `imm8`.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit lanes of `a` using the control in `imm8`. The low 64 bits of 128-bit lanes of `a` are copied to the output.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit lanes of `a` using the control in `imm8`. The high 64 bits of 128-bit lanes of `a` are copied to the output.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_si256","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bslli_epi128","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_srli_si256","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bsrli_epi128","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_xor_si256","","Compute the bitwise XOR of 256 bits (representing integer data) in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m256i"],["i32"]],["i8"]]],[5,"_mm256_extract_epi16","","Extract a 16-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m256i"],["i32"]],["i16"]]],[5,"_mm256_extract_epi32","","Extract a 32-bit integer from `a`, selected with `imm8`.",N,[[["__m256i"],["i32"]],["i32"]]],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x double]`.",N,[[["__m256d"]],["f64"]]],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x i32]`.",N,[[["__m256i"]],["i32"]]],[5,"_mm_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`,  and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fnmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fnmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",N,[[["u32"]],["u32"]]],[5,"_popcnt32","","Counts the bits that are set.",N,[[["i32"]],["i32"]]],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",N,[[["u32"],["u32"],["u32"]],["u32"]]],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",N,[[["u32"],["u32"]],["u32"]]],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_blsi_u32","","Extract lowest set isolated bit.",N,[[["u32"]],["u32"]]],[5,"_blsmsk_u32","","Get mask up to lowest set bit.",N,[[["u32"]],["u32"]]],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",N,[[["u32"]],["u32"]]],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",N,[[["u32"]],["i32"]]],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",N,[[["u32"],["u32"],["u32"]],["u32"]]],[5,"_bzhi_u32","","Zero higher bits of `a` >= `index`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",N,[[["u32"],["u32"]],["u32"]]],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64 bits of `x`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",N,N],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",N,N],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_blcfill_u64","","Clears all bits below the least significant zero bit of `x`.",N,[[["u64"]],["u64"]]],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant zero bit.",N,[[["u32"]],["u32"]]],[5,"_blci_u64","","Sets all bits of `x` to 1 except for the least significant zero bit.",N,[[["u64"]],["u64"]]],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all other bits.",N,[[["u32"]],["u32"]]],[5,"_blcic_u64","","Sets the least significant zero bit of `x` and clears all other bits.",N,[[["u64"]],["u64"]]],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all bits above that bit.",N,[[["u32"]],["u32"]]],[5,"_blcmsk_u64","","Sets the least significant zero bit of `x` and clears all bits above that bit.",N,[[["u64"]],["u64"]]],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_blcs_u64","","Sets the least significant zero bit of `x`.",N,[[["u64"]],["u64"]]],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",N,[[["u32"]],["u32"]]],[5,"_blsfill_u64","","Sets all bits of `x` below the least significant one.",N,[[["u64"]],["u64"]]],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",N,[[["u32"]],["u32"]]],[5,"_blsic_u64","","Clears least significant bit and sets all other bits.",N,[[["u64"]],["u64"]]],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x` and sets all other bits.",N,[[["u32"]],["u32"]]],[5,"_t1mskc_u64","","Clears all bits below the least significant zero of `x` and sets all other bits.",N,[[["u64"]],["u64"]]],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and clears all other bits.",N,[[["u32"]],["u32"]]],[5,"_tzmsk_u64","","Sets all bits below the least significant one of `x` and clears all other bits.",N,[[["u64"]],["u64"]]],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",N,[[],["__m64"]]],[5,"_mm_add_pi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddb","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_add_pi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddw","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_add_pi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddd","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddsb","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddsw","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddusb","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddusw","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_packs_pi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_packs_pi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors and interleaves them into the result: `[a.2, b.2, a.3, b.3]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors and interleaves them into the result: `[a.4, b.4, a.5, b.5, a.6, b.6, a.7, b.7]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors and interleaves them into the result: `[a.0, b.0, a.1, b.1, a.2, b.2, a.3, b.3]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors and interleaves them into the result: `[a.0 b.0 a.1 b.1]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and interleaves them into the result: `[a.1, b.1]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and interleaves them into the result: `[a.0, b.0]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_set_pi16","","Set packed 16-bit integers in dst with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"]],["__m64"]]],[5,"_mm_set_pi32","","Set packed 32-bit integers in dst with the supplied values.",N,[[["i32"],["i32"]],["__m64"]]],[5,"_mm_set_pi8","","Set packed 8-bit integers in dst with the supplied values.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m64"]]],[5,"_mm_set1_pi16","","Broadcast 16-bit integer a to all all elements of dst.",N,[[["i16"]],["__m64"]]],[5,"_mm_set1_pi32","","Broadcast 32-bit integer a to all all elements of dst.",N,[[["i32"]],["__m64"]]],[5,"_mm_set1_pi8","","Broadcast 8-bit integer a to all all elements of dst.",N,[[["i8"]],["__m64"]]],[5,"_mm_setr_pi16","","Set packed 16-bit integers in dst with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"]],["__m64"]]],[5,"_mm_setr_pi32","","Set packed 32-bit integers in dst with the supplied values in reverse order.",N,[[["i32"],["i32"]],["__m64"]]],[5,"_mm_setr_pi8","","Set packed 8-bit integers in dst with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m64"]]],[5,"_mm_clmulepi64_si128","","Perform a carry-less multiplication of two 64-bit polynomials over the finite field GF(2^k).",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_aesdec_si128","","Perform one round of an AES decryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesdeclast_si128","","Perform the last round of an AES decryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesenc_si128","","Perform one round of an AES encryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesenclast_si128","","Perform the last round of an AES encryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesimc_si128","","Perform the `InvMixColumns` transformation on `a`.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u16"]],["i32"]]],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u32"]],["i32"]]],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u16"]],["i32"]]],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u32"]],["i32"]]],[5,"_mm_sha1msg1_epu32","","Perform an intermediate calculation for the next four SHA1 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and returning the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1msg2_epu32","","Perform the final calculation for the next four SHA1 message values (unsigned 32-bit integers) using the intermediate result in `a` and the previous message values in `b`, and returns the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of operation from the current SHA1 state variable `a`, add that value to the scheduled values (unsigned 32-bit integers) in `b`, and returns the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1rnds4_epu32","","Perform four rounds of SHA1 operation using an initial SHA1 state (A,B,C,D) from `a` and some pre-computed sum of the next 4 round message values (unsigned 32-bit integers), and state variable E from `b`, and return the updated SHA1 state (A,B,C,D). `func` contains the logic functions and round constants.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sha256msg1_epu32","","Perform an intermediate calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha256msg2_epu32","","Perform the final calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha256rnds2_epu32","","Perform 2 rounds of SHA256 operation using an initial SHA256 state (C,D,G,H) from `a`, an initial SHA256 state (A,B,E,F) from `b`, and a pre-computed sum of the next 2 round message values (unsigned 32-bit integers) and the corresponding round constants from `k`, and store the updated SHA256 state (A,B,E,F) in dst.",N,[[["__m128i"],["__m128i"],["__m128i"]],["__m128i"]]],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",N,N],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",N,N],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",N,N],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",N,N],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",N,N],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",N,N],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",N,N],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",N,N],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",N,N],[17,"_MM_FROUND_TO_NEG_INF","","round down",N,N],[17,"_MM_FROUND_TO_POS_INF","","round up",N,N],[17,"_MM_FROUND_TO_ZERO","","truncate",N,N],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",N,N],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",N,N],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",N,N],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",N,N],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",N,N],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",N,N],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",N,N],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",N,N],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",N,N],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",N,N],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",N,N],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1] or b[1] <= c <= b[2]...`",N,N],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",N,N],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",N,N],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",N,N],[17,"_SIDD_NEGATIVE_POLARITY","","Negate results",N,N],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",N,N],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negate results only before the end of the string",N,N],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",N,N],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",N,N],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",N,N],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",N,N],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",N,N],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",N,N],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",N,N],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",N,N],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",N,N],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",N,N],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",N,N],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",N,N],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",N,N],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",N,N],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",N,N],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",N,N],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",N,N],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",N,N],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",N,N],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",N,N],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",N,N],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",N,N],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",N,N],[17,"_CMP_UNORD_S","","Unordered (signaling)",N,N],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",N,N],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",N,N],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",N,N],[17,"_CMP_ORD_S","","Ordered (signaling)",N,N],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",N,N],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",N,N],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",N,N],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",N,N],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",N,N],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",N,N],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",N,N],[17,"_CMP_TRUE_US","","True (unordered, signaling)",N,N],[0,"x86_64","core::arch","Platform-specific intrinsics for the `x86_64` platform.",N,N],[3,"__m64","core::arch::x86_64","64-bit wide integer vector type, x86-specific",N,N],[3,"__m128i","","128-bit wide integer vector type, x86-specific",N,N],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",N,N],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",N,N],[3,"__m256i","","256-bit wide integer vector type, x86-specific",N,N],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",N,N],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",N,N],[3,"CpuidResult","","Result of the `cpuid` instruction.",N,N],[12,"eax","","EAX register.",154,N],[12,"ebx","","EBX register.",154,N],[12,"ecx","","ECX register.",154,N],[12,"edx","","EDX register.",154,N],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_bswap","","Return an integer with the reversed byte order of x",N,[[["i32"]],["i32"]]],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp counter.",N,[[],["i64"]]],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp counter and the `IA32_TSC_AUX MSR`.",N,N],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given `leaf` (`EAX`) and `sub_leaf` (`ECX`).",N,[[["u32"],["u32"]],["cpuidresult"]]],[5,"__cpuid","","See `__cpuid_count`.",N,[[["u32"]],["cpuidresult"]]],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",N,[[],["bool"]]],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf (`ECX`) `cpuid` values.",N,N],[5,"_xsave","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xrstor","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_xsetbv","","Copy 64-bits from `val` to the extended control register (`XCR`) specified by `a`.",N,[[["u32"],["u64"]]]],[5,"_xgetbv","","Reads the contents of the extended control register `XCR` specified in `xcr_no`.",N,[[["u32"]],["u64"]]],[5,"_xsaveopt","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsavec","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsaves","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",N,N],[5,"_xrstors","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_add_ps","","Adds __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other components are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_div_ps","","Divides __m128 vectors.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sqrt_ss","","Return the square root of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ss","","Return the approximate reciprocal of the first single-precision (32-bit) floating-point element in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ps","","Return the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ss","","Return the approximate reciprocal square root of the fist single-precision (32-bit) floating-point elements in `a`, the other elements are unchanged.",N,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ps","","Return the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_min_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the minimum value in the first element of the return value, the other elements are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding minimum values.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_max_ss","","Compare the first single-precision (32-bit) floating-point element of `a` and `b`, and return the maximum value in the first element of the return value, the other elements are copied from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return the corresponding maximum values.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit) floating-point elements.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ss","","Compare the lowest `f32` of both inputs for equality. The lowest 32 bits of the result will be `0xffffffff` if the two inputs are equal, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmplt_ss","","Compare the lowest `f32` of both inputs for less than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmple_ss","","Compare the lowest `f32` of both inputs for less than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is less than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ss","","Compare the lowest `f32` of both inputs for greater than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpge_ss","","Compare the lowest `f32` of both inputs for greater than or equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is greater than or equal `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ss","","Compare the lowest `f32` of both inputs for inequality. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ss","","Compare the lowest `f32` of both inputs for not-less-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ss","","Compare the lowest `f32` of both inputs for not-less-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not less than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ss","","Compare the lowest `f32` of both inputs for not-greater-than. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ss","","Compare the lowest `f32` of both inputs for not-greater-than-or-equal. The lowest 32 bits of the result will be `0xffffffff` if `a.extract(0)` is not greater than or equal to `b.extract(0)`, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpord_ss","","Check if the lowest `f32` of both inputs are ordered. The lowest 32 bits of the result will be `0xffffffff` if neither of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ss","","Check if the lowest `f32` of both inputs are unordered. The lowest 32 bits of the result will be `0xffffffff` if any of `a.extract(0)` or `b.extract(0)` is a NaN, or `0` otherwise. The upper 96 bits of the result are the upper 96 bits of `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements were equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmplt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmple_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is less than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is greater than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input elements are not equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not less than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. The result in the output vector will be `0xffffffff` if the input element in `a` is not greater than or equal to the corresponding element in `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are ordered (i.e., neither of them is a NaN), or 0 otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ps","","Compare each of the four floats in `a` to the corresponding element in `b`. Returns four floats that have one of two possible bit patterns. The element in the output vector will be `0xffffffff` if the input elements in `a` and `b` are unordered (i.e., at least on of them is a NaN), or 0 otherwise.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_comieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_comineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomieq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomilt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomile_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is less than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomigt_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomige_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if the value from `a` is greater than or equal to the one from `b`, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_ucomineq_ss","","Compare two 32-bit floats from the low-order bits of `a` and `b`. Returns `1` if they are not equal, or `0` otherwise. This instruction will not signal an exception if either argument is a quiet NaN.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_cvtss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvttss_si32","","Convert the lowest 32 bit float in the input vector to a 32 bit integer with truncation.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",N,[[["__m128"]],["i32"]]],[5,"_mm_cvtss_f32","","Extract the lowest 32 bit float from the input vector.",N,[[["__m128"]],["f32"]]],[5,"_mm_cvtsi32_ss","","Convert a 32 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a` and the rest set to zero.",N,[[["f32"]],["__m128"]]],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",N,[[["f32"]],["__m128"]]],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",N,[[["f32"]],["__m128"]]],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values highest to lowest.",N,[[["f32"],["f32"],["f32"],["f32"]],["__m128"]]],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values lowest to highest.",N,[[["f32"],["f32"],["f32"],["f32"]],["__m128"]]],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",N,[[],["__m128"]]],[5,"_MM_SHUFFLE","","A utility function for creating masks to use with Intel shuffle and permute intrinsics.",N,[[["u32"],["u32"],["u32"],["u32"]],["u32"]]],[5,"_mm_shuffle_ps","","Shuffle packed single-precision (32-bit) floating-point elements in `a` and `b` using `mask`.",N,[[["__m128"],["__m128"],["u32"]],["__m128"]]],[5,"_mm_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the higher half of `a` and `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the lower half of `a` and `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b` occupies the lower half of result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b` occupies the higher half of result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_movemask_ps","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128"]],["i32"]]],[5,"_mm_loadh_pi","","Set the upper two single-precision floating-point values with 64 bits of data loaded from the address `p`; the lower two values are passed through from `a`.",N,N],[5,"_mm_loadl_pi","","Load two floats from `p` into the lower half of a `__m128`. The upper half is copied from the upper half of `a`.",N,N],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p` and the other elements set to zero.",N,N],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from `p` into all elements.",N,N],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",N,N],[5,"_mm_load_ps","","Load four `f32` values from aligned memory into a `__m128`. If the pointer is not aligned to a 128-bit boundary (16 bytes) a general protection fault will be triggered (fatal program crash).",N,N],[5,"_mm_loadu_ps","","Load four `f32` values from memory into a `__m128`. There are no restrictions on memory alignment. For aligned memory `_mm_load_ps` may be faster.",N,N],[5,"_mm_loadr_ps","","Load four `f32` values from aligned memory into a `__m128` in reverse order.",N,N],[5,"_mm_storeh_pi","","Store the upper half of `a` (64 bits) into memory.",N,N],[5,"_mm_storel_pi","","Store the lower half of `a` (64 bits) into memory.",N,N],[5,"_mm_store_ss","","Store the lowest 32 bit float of `a` into memory.",N,N],[5,"_mm_store1_ps","","Store the lowest 32 bit float of `a` repeated four times into aligned memory.",N,N],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",N,N],[5,"_mm_store_ps","","Store four 32-bit floats into aligned memory.",N,N],[5,"_mm_storeu_ps","","Store four 32-bit floats into memory. There are no restrictions on memory alignment. For aligned memory `_mm_store_ps` may be faster.",N,N],[5,"_mm_storer_ps","","Store four 32-bit floats into aligned memory in reverse order.",N,N],[5,"_mm_move_ss","","Return a `__m128` with the first component from `b` and the remaining components from `a`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_sfence","","Perform a serializing operation on all store-to-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_getcsr","","Get the unsigned 32-bit value of the MXCSR control and status register.",N,[[],["u32"]]],[5,"_mm_setcsr","","Set the MXCSR register with the 32-bit unsigned integer value.",N,[[["u32"]]]],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",N,[[],["u32"]]],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",N,[[["u32"]]]],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the given `strategy`.",N,N],[5,"_mm_undefined_ps","","Return vector of type __m128 with undefined elements.",N,[[],["__m128"]]],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in place.",N,[[["__m128"],["__m128"],["__m128"],["__m128"]]]],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a non-temporal memory hint.",N,N],[5,"_mm_stream_pi","","Store 64-bits of integer data from a into memory using a non-temporal memory hint.",N,N],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b` writing the greatest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b` writing the smallest value into the result.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mullo_pi16","","Multiplies packed 16-bit integer values and writes the low-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and writes the high-order 16 bits of each 32-bit product to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned 16-bit integer values and writes the averages to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values of the two 64-bit vector operands and computes the absolute value for each of the difference. Then sum of the 8 absolute differences is written to the bits `[15:0]` of the destination; the remaining bits `[63:16]` are cleared.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",N,[[["__m128"],["__m64"]],["__m128"]]],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]` into two floating point values and writes them to the lower 64-bits of the destination. The remaining higher order elements of the destination are copied from the corresponding elements in the first operand.",N,[[["__m128"],["__m64"]],["__m128"]]],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector of 4 `f32`s.",N,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each 64-bit vector operand of `[2 x i32]` into a 128-bit vector of `[4 x float]`.",N,[[["__m64"],["__m64"]],["__m128"]]],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",N,N],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in the first 64-bit integer vector operand to the specified memory location, as specified by the most significant bit in the corresponding element in the second 64-bit integer vector operand.",N,N],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",N,[[["__m64"],["i32"]],["i32"]]],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x i16]` and returns it, as specified by the immediate integer operand.",N,[[["__m64"],["i32"]],["i32"]]],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",N,[[["__m64"],["i32"],["i32"]],["__m64"]]],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the destination, and inserts the lower 16-bits of an integer operand at the 16-bit offset specified by the immediate operand `n`.",N,[[["__m64"],["i32"],["i32"]],["__m64"]]],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",N,[[["__m64"]],["i32"]]],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in a 64-bit integer vector to create a 16-bit mask value. Zero-extends the value to 32-bit integer and writes it to the destination.",N,[[["__m64"]],["i32"]]],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",N,[[["__m64"],["i32"]],["__m64"]]],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer vector to the destination, as specified by the immediate value operand.",N,[[["__m64"],["i32"]],["__m64"]]],[5,"_mm_cvttps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi32","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvt_ps2pi","","Convert the two lower packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi16","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 16-bit integers.",N,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi8","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 8-bit integers, and returns theem in the lower 4 elements of the result.",N,[[["__m128"]],["__m64"]]],[5,"_mm_pause","","Provide a hint to the processor that the code sequence is a spin-wait loop.",N,[[]]],[5,"_mm_clflush","","Invalidate and flush the cache line that contains `p` from all levels of the cache hierarchy.",N,N],[5,"_mm_lfence","","Perform a serializing operation on all load-from-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_mfence","","Perform a serializing operation on all load-from-memory and store-to-memory instructions that were issued prior to this instruction.",N,[[]]],[5,"_mm_add_epi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_epi64","","Add packed 64-bit integers in `a` and \"b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_madd_epi16","","Multiply and then horizontally add signed 16 bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit integers.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit integers in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bslli_si128","","Shift `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bsrli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_si128","","Shift `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_and_si128","","Compute the bitwise AND of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_andnot_si128","","Compute the bitwise NOT of 128 bits (representing integer data) in `a` and then AND with `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_or_si128","","Compute the bitwise OR of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_xor_si128","","Compute the bitwise XOR of 128 bits (representing integer data) in `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi8","","Compare packed 8-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi16","","Compare packed 16-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi32","","Compare packed 32-bit integers in `a` and `b` for less-than.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_pd","","Convert the lower two packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128i"]],["__m128d"]]],[5,"_mm_cvtsi32_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m128i"]],["__m128"]]],[5,"_mm_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_cvtsi32_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",N,[[["i32"]],["__m128i"]]],[5,"_mm_cvtsi128_si32","","Return the lowest element of `a`.",N,[[["__m128i"]],["i32"]]],[5,"_mm_set_epi64x","","Set packed 64-bit integers with the supplied values, from highest to lowest.",N,[[["i64"],["i64"]],["__m128i"]]],[5,"_mm_set_epi32","","Set packed 32-bit integers with the supplied values.",N,[[["i32"],["i32"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_set_epi16","","Set packed 16-bit integers with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m128i"]]],[5,"_mm_set_epi8","","Set packed 8-bit integers with the supplied values.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m128i"]]],[5,"_mm_set1_epi64x","","Broadcast 64-bit integer `a` to all elements.",N,[[["i64"]],["__m128i"]]],[5,"_mm_set1_epi32","","Broadcast 32-bit integer `a` to all elements.",N,[[["i32"]],["__m128i"]]],[5,"_mm_set1_epi16","","Broadcast 16-bit integer `a` to all elements.",N,[[["i16"]],["__m128i"]]],[5,"_mm_set1_epi8","","Broadcast 8-bit integer `a` to all elements.",N,[[["i8"]],["__m128i"]]],[5,"_mm_setr_epi32","","Set packed 32-bit integers with the supplied values in reverse order.",N,[[["i32"],["i32"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_setr_epi16","","Set packed 16-bit integers with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m128i"]]],[5,"_mm_setr_epi8","","Set packed 8-bit integers with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m128i"]]],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",N,[[],["__m128i"]]],[5,"_mm_loadl_epi64","","Load 64-bit integer from memory into first element of returned vector.",N,N],[5,"_mm_load_si128","","Load 128-bits of integer data from memory into a new vector.",N,N],[5,"_mm_loadu_si128","","Load 128-bits of integer data from memory into a new vector.",N,N],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into memory using `mask`.",N,N],[5,"_mm_store_si128","","Store 128-bits of integer data from `a` into memory.",N,N],[5,"_mm_storeu_si128","","Store 128-bits of integer data from `a` into memory.",N,N],[5,"_mm_storel_epi64","","Store the lower 64-bit integer `a` to a memory location.",N,N],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_move_epi64","","Return a vector where the low element is extracted from `a` and its upper element is zero.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_extract_epi16","","Return the `imm8` element of `a`.",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_epi16","","Return a new vector where the `imm8` element of `a` is replaced with `i`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_movemask_epi8","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128i"]],["i32"]]],[5,"_mm_shuffle_epi32","","Shuffle 32-bit integers in `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of `a` using the control in `imm8`.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of `a` and `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_add_sd","","Return a new vector with the low element of `a` replaced by the sum of the low elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_div_sd","","Return a new vector with the low element of `a` replaced by the result of diving the lower element of `a` by the lower element of `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point elements in `a` by packed elements in `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_max_sd","","Return a new vector with the low element of `a` replaced by the maximum of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_max_pd","","Return a new vector with the maximum values from corresponding elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_min_sd","","Return a new vector with the low element of `a` replaced by the minimum of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_min_pd","","Return a new vector with the minimum values from corresponding elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_mul_sd","","Return a new vector with the low element of `a` replaced by multiplying the low elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_mul_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_sd","","Return a new vector with the low element of `a` replaced by the square root of the lower element `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_pd","","Return a new vector with the square root of each of the values in `a`.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_sub_sd","","Return a new vector with the low element of `a` replaced by subtracting the low element by `b` from the low element of `a`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from `a`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_and_pd","","Compute the bitwise AND of packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_andnot_pd","","Compute the bitwise NOT of `a` and then AND with `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_or_pd","","Compute the bitwise OR of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_xor_pd","","Compute the bitwise OR of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_sd","","Return a new vector with the low element of `a` replaced by the equality comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_sd","","Return a new vector with the low element of `a` replaced by the less-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmple_sd","","Return a new vector with the low element of `a` replaced by the less-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_sd","","Return a new vector with the low element of `a` replaced by the greater-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_sd","","Return a new vector with the low element of `a` replaced by the greater-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If neither are equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_sd","","Return a new vector with the low element of `a` replaced by the result of comparing both of the lower elements of `a` and `b` to `NaN`. If either is equal to `NaN` then `0xFFFFFFFFFFFFFFFF` is used and `0` otherwise.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_sd","","Return a new vector with the low element of `a` replaced by the not-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_sd","","Return a new vector with the low element of `a` replaced by the not-less-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_sd","","Return a new vector with the low element of `a` replaced by the not-less-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_sd","","Return a new vector with the low element of `a` replaced by the not-greater-than-or-equal comparison of the lower elements of `a` and `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_pd","","Compare corresponding elements in `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_pd","","Compare corresponding elements in `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmple_pd","","Compare corresponding elements in `a` and `b` for less-than-or-equal",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_pd","","Compare corresponding elements in `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_pd","","Compare corresponding elements in `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_pd","","Compare corresponding elements in `a` and `b` to see if neither is `NaN`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_pd","","Compare corresponding elements in `a` and `b` to see if either is `NaN`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_pd","","Compare corresponding elements in `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_pd","","Compare corresponding elements in `a` and `b` for not-less-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_pd","","Compare corresponding elements in `a` and `b` for not-less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_pd","","Compare corresponding elements in `a` and `b` for not-greater-than.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_pd","","Compare corresponding elements in `a` and `b` for not-greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_comieq_sd","","Compare the lower element of `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comilt_sd","","Compare the lower element of `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comigt_sd","","Compare the lower element of `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_comineq_sd","","Compare the lower element of `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomieq_sd","","Compare the lower element of `a` and `b` for equality.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomilt_sd","","Compare the lower element of `a` and `b` for less-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomile_sd","","Compare the lower element of `a` and `b` for less-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomigt_sd","","Compare the lower element of `a` and `b` for greater-than.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomige_sd","","Compare the lower element of `a` and `b` for greater-than-or-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_ucomineq_sd","","Compare the lower element of `a` and `b` for not-equal.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in \"a\" to packed single-precision (32-bit) floating-point elements",N,[[["__m128d"]],["__m128"]]],[5,"_mm_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128"]],["__m128d"]]],[5,"_mm_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvtsd_si32","","Convert the lower double-precision (64-bit) floating-point element in a to a 32-bit integer.",N,[[["__m128d"]],["i32"]]],[5,"_mm_cvtsd_ss","","Convert the lower double-precision (64-bit) floating-point element in `b` to a single-precision (32-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",N,[[["__m128"],["__m128d"]],["__m128"]]],[5,"_mm_cvtsd_f64","","Return the lower double-precision (64-bit) floating-point element of \"a\".",N,[[["__m128d"]],["f64"]]],[5,"_mm_cvtss_sd","","Convert the lower single-precision (32-bit) floating-point element in `b` to a double-precision (64-bit) floating-point element, store the result in the lower element of the return value, and copy the upper element from `a` to the upper element the return value.",N,[[["__m128d"],["__m128"]],["__m128d"]]],[5,"_mm_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvttsd_si32","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 32-bit integer with truncation.",N,[[["__m128d"]],["i32"]]],[5,"_mm_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_set_sd","","Copy double-precision (64-bit) floating-point element `a` to the lower element of the packed 64-bit return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set1_pd","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd1","","Broadcast double-precision (64-bit) floating-point value a to all elements of the return value.",N,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values.",N,[[["f64"],["f64"]],["__m128d"]]],[5,"_mm_setr_pd","","Set packed double-precision (64-bit) floating-point elements in the return value with the supplied values in reverse order.",N,[[["f64"],["f64"]],["__m128d"]]],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point elements with all zeros.",N,[[],["__m128d"]]],[5,"_mm_movemask_pd","","Return a mask of the most significant bit of each element in `a`.",N,[[["__m128d"]],["i32"]]],[5,"_mm_load_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element of a 128-bit integer vector and clears the upper element.",N,N],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of a 128-bit vector of `[2 x double]`. The low-order bits are copied from the low-order bits of the first operand.",N,N],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of a 128-bit vector of `[2 x double]`. The high-order bits are copied from the high-order bits of the first operand.",N,N],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]` to a 128-bit aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_store_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storeu_pd","","Store 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm_store1_pd","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_store_pd1","","Store the lower double-precision (64-bit) floating-point element from `a` into 2 contiguous elements in memory. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storer_pd","","Store 2 double-precision (64-bit) floating-point elements from `a` into memory in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x double]` to a memory location.",N,N],[5,"_mm_load1_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",N,N],[5,"_mm_load_pd1","","Load a double-precision (64-bit) floating-point element from memory into both elements of returned vector.",N,N],[5,"_mm_loadr_pd","","Load 2 double-precision (64-bit) floating-point elements from memory into the returned vector in reverse order. `mem_addr` must be aligned on a 16-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm_loadu_pd","","Load 128-bits (composed of 2 packed double-precision (64-bit) floating-point elements) from memory into the returned vector. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x double]` from two 128-bit vector parameters of `[2 x double]`, using the immediate-value parameter as a specifier.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x double]`. The lower 64 bits are set to the lower 64 bits of the second parameter. The upper 64 bits are set to the upper 64 bits of the first parameter.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit floating-point vector of `[4 x float]`.",N,[[["__m128d"]],["__m128"]]],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]` into a 128-bit integer vector.",N,[[["__m128d"]],["__m128i"]]],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit floating-point vector of `[2 x double]`.",N,[[["__m128"]],["__m128d"]]],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]` into a 128-bit integer vector.",N,[[["__m128"]],["__m128i"]]],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[2 x double]`.",N,[[["__m128i"]],["__m128d"]]],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit floating-point vector of `[4 x float]`.",N,[[["__m128i"]],["__m128"]]],[5,"_mm_undefined_pd","","Return vector of type __m128d with undefined elements.",N,[[],["__m128d"]]],[5,"_mm_undefined_si128","","Return vector of type __m128i with undefined elements.",N,[[],["__m128i"]]],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the low-order values of the two `__m128d` interleaved input elements, i.e.:",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the high-order values of the two `__m128d` interleaved input elements, i.e.:",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values, returning the lower 64 bits of the sum.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the lower bits of the two 64-bit integer vectors and returns the 64-bit unsigned product.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and writes the difference to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a 64-bit vector of `[2 x i32]` into two double-precision floating-point values, returned in a 128-bit vector of `[2 x double]`.",N,[[["__m64"]],["__m128d"]]],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2 x i64]` with the specified 64-bit integer values.",N,[[["__m64"],["__m64"]],["__m128i"]]],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]` with the specified 64-bit value.",N,[[["__m64"]],["__m128i"]]],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in reverse order with the specified 64-bit integral values.",N,[[["__m64"],["__m64"]],["__m128i"]]],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a 64-bit integer.",N,[[["__m128i"]],["__m64"]]],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector, zeroing the upper bits.",N,[[["__m64"]],["__m128i"]]],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`.",N,[[["__m128d"]],["__m64"]]],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements of a 128-bit vector of `[2 x double]` into two signed 32-bit integer values, returned in a 64-bit vector of `[2 x i32]`. If the result of either conversion is inexact, the result is truncated (rounded towards zero) regardless of the current MXCSR setting.",N,[[["__m128d"]],["__m64"]]],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hadd_pd","","Horizontally add adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hadd_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision (64-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_hsub_ps","","Horizontally add adjacent pairs of single-precision (32-bit) floating-point elements in `a` and `b`, and pack the results.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_lddqu_si128","","Load 128-bits of integer data from unaligned memory. This intrinsic may perform better than `_mm_loadu_si128` when the data crosses a cache line boundary.",N,N],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point element from `a`.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_loaddup_pd","","Load a double-precision (64-bit) floating-point element from memory into both elements of return vector.",N,N],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`.",N,[[["__m128"]],["__m128"]]],[5,"_mm_abs_epi8","","Compute the absolute value of packed 8-bit signed integers in `a` and return the unsigned results.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi16","","Compute the absolute value of each of the packed 16-bit signed integers in `a` and return the 16-bit unsigned integer",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi32","","Compute the absolute value of each of the packed 32-bit signed integers in `a` and return the 32-bit unsigned integer",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_hadd_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hadds_epi16","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hadd_epi32","","Horizontally add the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[8 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values contained in 2 packed 128-bit vectors of `[4 x i32]`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_maddubs_epi16","","Multiply corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, add pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mulhrs_epi16","","Multiply packed 16-bit signed integer values, truncate the 32-bit product to the 18 most significant bits by right-shifting, round the truncated value by adding 1, and write bits `[16:1]` to the destination.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the result. Elements in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Elements in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_abs_pi8","","Compute the absolute value of packed 8-bit integers in `a` and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi16","","Compute the absolute value of packed 8-bit integers in `a`, and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi32","","Compute the absolute value of packed 32-bit integers in `a`, and return the unsigned results.",N,[[["__m64"]],["__m64"]]],[5,"_mm_shuffle_pi8","","Shuffle packed 8-bit integers in `a` according to shuffle control mask in the corresponding 8-bit element of `b`, and return the results",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and right-shifts the result by the number of bytes specified in the immediate operand.",N,[[["__m64"],["__m64"],["i32"]],["__m64"]]],[5,"_mm_hadd_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hadd_pi32","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hadds_pi16","","Horizontally add the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive sums greater than 7FFFh are saturated to 7FFFh. Negative sums less than 8000h are saturated to 8000h.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[2 x i32]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values contained in 2 packed 64-bit vectors of `[4 x i16]`. Positive differences greater than 7FFFh are saturated to 7FFFh. Negative differences less than 8000h are saturated to 8000h.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned integer values contained in the first source operand and packed 8-bit signed integer values contained in the second source operand, adds pairs of contiguous products with signed saturation, and writes the 16-bit sums to the corresponding bits in the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates the 32-bit products to the 18 most significant bits by right-shifting, rounds the truncated value by adding 1, and writes bits `[16:1]` to the destination.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sign_pi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Element in result are zeroed out when the corresponding element in `b` is zero.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",N,[[["__m128i"],["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the mask `imm8`.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `mask`",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `mask`",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm2`",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using mask `imm4`",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_extract_ps","","Extract a single-precision (32-bit) floating-point element from `a`, selected with `imm8`",N,[[["__m128"],["i32"]],["i32"]]],[5,"_mm_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_extract_epi32","","Extract an 32-bit integer from `a` selected with `imm8`",N,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in `b`, Then zero elements according to `imm8`.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_insert_epi8","","Return a copy of `a` with the 8-bit integer from `i` inserted at a location specified by `imm8`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_insert_epi32","","Return a copy of `a` with the 32-bit integer from `i` inserted at a location specified by `imm8`.",N,[[["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_max_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed maximum values in dst.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed maximum.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed maximum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi8","","Compare packed 8-bit integers in `a` and `b` and return packed minimum values in dst.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return packed minimum.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return packed minimum values.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in `a` to packed 16-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in `a` to packed 64-bit integers",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` down to an integer value, and store the results as packed double-precision floating-point elements.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` down to an integer value, and store the results as packed single-precision floating-point elements.",N,[[["__m128"]],["__m128"]]],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point element in `b` down to an integer value, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point element in `b` down to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` up to an integer value, and store the results as packed double-precision floating-point elements.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` up to an integer value, and store the results as packed single-precision floating-point elements.",N,[[["__m128"]],["__m128"]]],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point element in `b` up to an integer value, store the result as a double-precision floating-point element in the lower element of the intrisic result, and copy the upper element from `a` to the upper element of the intrinsic result.",N,[[["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point element in `b` up to an integer value, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the intrinsic result.",N,[[["__m128"],["__m128"]],["__m128"]]],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed double-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point elements in `a` using the `rounding` parameter, and store the results as packed single-precision floating-point elements. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point element in `b` using the `rounding` parameter, store the result as a double-precision floating-point element in the lower element of the intrinsic result, and copy the upper element from `a` to the upper element of the intrinsic result. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point element in `b` using the `rounding` parameter, store the result as a single-precision floating-point element in the lower element of the intrinsic result, and copy the upper 3 packed elements from `a` to the upper elements of the instrinsic result. Rounding is done according to the rounding parameter, which can be one of:",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit __m128i vector, returning a vector containing its value in its first position, and its index in its second position; all other elements are set to zero.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`, and return the signed 64-bit result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and returns the lowest 32-bit, whatever they might be, reinterpreted as a signed integer. While `pmulld __m128i::splat(2), __m128i::splat(2)` returns the obvious `__m128i::splat(4)`, due to wrapping arithmetic `pmulld __m128i::splat(i32::MAX), __m128i::splat(2)` would return a negative number.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the absolute values of the differences to the corresponding bits in the destination. Then sums of the absolute differences are returned according to the bit fields in the immediate operand.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer vector are all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer vector are all zeros.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer vector are all ones.",N,[[["__m128i"]],["i32"]]],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer vector are neither all zeros nor all ones.",N,[[["__m128i"],["__m128i"]],["i32"]]],[5,"_mm_cmpistrm","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return the generated mask.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_cmpistri","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpestri`] with the exception that [`_mm_cmpestri`] requires the lengths of `a` and `b` to be explicitly specified.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrz","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if any character in `b` was null. and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrc","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrs","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and returns `1` if any character in `a` was null, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistro","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return bit `0` of the resulting bit mask.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistra","","Compare packed strings with implicit lengths in `a` and `b` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",N,[[["__m128i"],["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrm","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return the generated mask.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["__m128i"]]],[5,"_mm_cmpestri","","Compare packed strings `a` and `b` with lengths `la` and `lb` using the control in `imm8` and return the generated index. Similar to [`_mm_cmpistri`] with the exception that [`_mm_cmpistri`] implicitly determines the length of `a` and `b`.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrz","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in `b` was null, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrc","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if the resulting mask was non-zero, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestrs","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if any character in a was null, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestro","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return bit `0` of the resulting bit mask.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_cmpestra","","Compare packed strings in `a` and `b` with lengths `la` and `lb` using the control in `imm8`, and return `1` if `b` did not contain a null character and the resulting mask was zero, and `0` otherwise.",N,[[["__m128i"],["i32"],["__m128i"],["i32"],["i32"]],["i32"]]],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 8-bit integer `v`.",N,[[["u32"],["u8"]],["u32"]]],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 16-bit integer `v`.",N,[[["u32"],["u16"]],["u32"]]],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 32-bit integer `v`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_mm_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than, return the results.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_add_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_add_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_and_pd","","Compute the bitwise AND of a packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_and_ps","","Compute the bitwise AND of packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_or_pd","","Compute the bitwise OR packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_or_ps","","Compute the bitwise OR packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements within 128-bit lanes using the control in `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_andnot_pd","","Compute the bitwise NOT of packed double-precision (64-bit) floating-point elements in `a` and then AND with `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_andnot_ps","","Compute the bitwise NOT of packed single-precision (32-bit) floating-point elements in `a` and then AND with `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_max_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed maximum values",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_max_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed maximum values",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_min_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b`, and return packed minimum values",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_min_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b`, and return packed minimum values",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_mul_pd","","Add packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_mul_ps","","Add packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_addsub_pd","","Alternatively add and subtract packed double-precision (64-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_addsub_ps","","Alternatively add and subtract packed single-precision (32-bit) floating-point elements in `a` to/from packed elements in `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_sub_pd","","Subtract packed double-precision (64-bit) floating-point elements in `b` from packed elements in `a`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_sub_ps","","Subtract packed single-precision (32-bit) floating-point elements in `b` from packed elements in `a`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_div_ps","","Compute the division of each of the 8 packed 32-bit floating-point elements in `a` by the corresponding packed elements in `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_div_pd","","Compute the division of each of the 4 packed 64-bit floating-point elements in `a` by the corresponding packed elements in `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_round_pd","","Round packed double-precision (64-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_ceil_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward positive infinity.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_floor_pd","","Round packed double-precision (64-bit) floating point elements in `a` toward negative infinity.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_round_ps","","Round packed single-precision (32-bit) floating point elements in `a` according to the flag `b`. The value of `b` may be as follows:",N,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_ceil_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward positive infinity.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_floor_ps","","Round packed single-precision (32-bit) floating point elements in `a` toward negative infinity.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_ps","","Return the square root of packed single-precision (32-bit) floating point elements in `a`.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_pd","","Return the square root of packed double-precision (64-bit) floating point elements in `a`.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_blend_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using control mask `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_blend_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using control mask `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_blendv_pd","","Blend packed double-precision (64-bit) floating-point elements from `a` and `b` using `c` as a mask.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_blendv_ps","","Blend packed single-precision (32-bit) floating-point elements from `a` and `b` using `c` as a mask.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_dp_ps","","Conditionally multiply the packed single-precision (32-bit) floating-point elements in `a` and `b` using the high 4 bits in `imm8`, sum the four products, and conditionally return the sum  using the low 4 bits of `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed vectors of 4 64-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in even locations, while sums of elements from `b` are returned in odd locations.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed vectors of 8 32-bit floating points `a` and `b`. In the result, sums of elements from `a` are returned in locations of indices 0, 1, 4, 5; while sums of elements from `b` are locations 2, 3, 6, 7.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_xor_pd","","Compute the bitwise XOR of packed double-precision (64-bit) floating-point elements in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_xor_ps","","Compute the bitwise XOR of packed single-precision (32-bit) floating-point elements in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_cmp_pd","","Compare packed double-precision (64-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm256_cmp_ps","","Compare packed single-precision (32-bit) floating-point elements in `a` and `b` based on the comparison operand specified by `imm8`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm_cmp_sd","","Compare the lower double-precision (64-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper element from `a` to the upper element of returned vector.",N,[[["__m128d"],["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cmp_ss","","Compare the lower single-precision (32-bit) floating-point element in `a` and `b` based on the comparison operand specified by `imm8`, store the result in the lower element of returned vector, and copy the upper 3 packed elements from `a` to the upper elements of returned vector.",N,[[["__m128"],["__m128"],["i32"]],["__m128"]]],[5,"_mm256_cvtepi32_pd","","Convert packed 32-bit integers in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128i"]],["__m256d"]]],[5,"_mm256_cvtepi32_ps","","Convert packed 32-bit integers in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m256i"]],["__m256"]]],[5,"_mm256_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed single-precision (32-bit) floating-point elements.",N,[[["__m256d"]],["__m128"]]],[5,"_mm256_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_cvtps_pd","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed double-precision (64-bit) floating-point elements.",N,[[["__m128"]],["__m256d"]]],[5,"_mm256_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvtpd_epi32","","Convert packed double-precision (64-bit) floating-point elements in `a` to packed 32-bit integers.",N,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point elements in `a` to packed 32-bit integers with truncation.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_extractf128_ps","","Extract 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `a`, selected with `imm8`.",N,[[["__m256"],["i32"]],["__m128"]]],[5,"_mm256_extractf128_pd","","Extract 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `a`, selected with `imm8`.",N,[[["__m256d"],["i32"]],["__m128d"]]],[5,"_mm256_extractf128_si256","","Extract 128 bits (composed of integer data) from `a`, selected with `imm8`.",N,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_zeroall","","Zero the contents of all XMM or YMM registers.",N,[[]]],[5,"_mm256_zeroupper","","Zero the upper 128 bits of all YMM registers; the lower 128-bits of the registers are unmodified.",N,[[]]],[5,"_mm256_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `b`.",N,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `b`.",N,[[["__m128"],["__m128i"]],["__m128"]]],[5,"_mm256_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm_permute_ps","","Shuffle single-precision (32-bit) floating-point elements in `a` using the control in `imm8`.",N,[[["__m128"],["i32"]],["__m128"]]],[5,"_mm256_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 256-bit lanes using the control in `b`.",N,[[["__m256d"],["__m256i"]],["__m256d"]]],[5,"_mm_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `b`.",N,[[["__m128d"],["__m128i"]],["__m128d"]]],[5,"_mm256_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` within 128-bit lanes using the control in `imm8`.",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm_permute_pd","","Shuffle double-precision (64-bit) floating-point elements in `a` using the control in `imm8`.",N,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_permute2f128_ps","","Shuffle 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) selected by `imm8` from `a` and `b`.",N,[[["__m256"],["__m256"],["i32"]],["__m256"]]],[5,"_mm256_permute2f128_pd","","Shuffle 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) selected by `imm8` from `a` and `b`.",N,[[["__m256d"],["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_permute2f128_si256","","Shuffle 258-bits (composed of integer data) selected by `imm8` from `a` and `b`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f32"]],["__m256"]]],[5,"_mm_broadcast_ss","","Broadcast a single-precision (32-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f32"]],["__m128"]]],[5,"_mm256_broadcast_sd","","Broadcast a double-precision (64-bit) floating-point element from memory to all elements of the returned vector.",N,[[["f64"]],["__m256d"]]],[5,"_mm256_broadcast_ps","","Broadcast 128 bits from memory (composed of 4 packed single-precision (32-bit) floating-point elements) to all elements of the returned vector.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_broadcast_pd","","Broadcast 128 bits from memory (composed of 2 packed double-precision (64-bit) floating-point elements) to all elements of the returned vector.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_insertf128_ps","","Copy `a` to result, then insert 128 bits (composed of 4 packed single-precision (32-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",N,[[["__m256"],["__m128"],["i32"]],["__m256"]]],[5,"_mm256_insertf128_pd","","Copy `a` to result, then insert 128 bits (composed of 2 packed double-precision (64-bit) floating-point elements) from `b` into result at the location specified by `imm8`.",N,[[["__m256d"],["__m128d"],["i32"]],["__m256d"]]],[5,"_mm256_insertf128_si256","","Copy `a` to result, then insert 128 bits from `b` into result at the location specified by `imm8`.",N,[[["__m256i"],["__m128i"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi8","","Copy `a` to result, and insert the 8-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i8"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi16","","Copy `a` to result, and insert the 16-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i16"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi32","","Copy `a` to result, and insert the 32-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_load_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_load_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_loadu_pd","","Load 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_pd","","Store 256-bits (composed of 4 packed double-precision (64-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu_ps","","Load 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_ps","","Store 256-bits (composed of 8 packed single-precision (32-bit) floating-point elements) from `a` into memory. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_load_si256","","Load 256-bits of integer data from memory into result. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_store_si256","","Store 256-bits of integer data from `a` into memory. `mem_addr` must be aligned on a 32-byte boundary or a general-protection exception may be generated.",N,N],[5,"_mm256_loadu_si256","","Load 256-bits of integer data from memory into result. `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu_si256","","Store 256-bits of integer data from `a` into memory.    `mem_addr` does not need to be aligned on any particular boundary.",N,N],[5,"_mm256_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm256_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm_maskload_pd","","Load packed double-precision (64-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm_maskstore_pd","","Store packed double-precision (64-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm256_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm256_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm_maskload_ps","","Load packed single-precision (32-bit) floating-point elements from memory into result using `mask` (elements are zeroed out when the high bit of the corresponding element is not set).",N,N],[5,"_mm_maskstore_ps","","Store packed single-precision (32-bit) floating-point elements from `a` into memory using `mask`.",N,N],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) floating-point elements from `a`, and return the results.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit) floating-point elements from \"a\", and return the results.",N,[[["__m256d"]],["__m256d"]]],[5,"_mm256_lddqu_si256","","Load 256-bits of integer data from unaligned memory into result. This intrinsic may perform better than `_mm256_loadu_si256` when the data crosses a cache line boundary.",N,N],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon)",N,N],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4 x double]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a 256-bit vector of `[8 x float]` to a 32-byte aligned memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm256_rcp_ps","","Compute the approximate reciprocal of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_rsqrt_ps","","Compute the approximate reciprocal square root of packed single-precision (32-bit) floating-point elements in `a`, and return the results. The maximum relative error for this approximation is less than 1.5*2^-12.",N,[[["__m256"]],["__m256"]]],[5,"_mm256_unpackhi_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_unpackhi_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_unpacklo_pd","","Unpack and interleave double-precision (64-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",N,[[["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm256_unpacklo_ps","","Unpack and interleave single-precision (32-bit) floating-point elements from the low half of each 128-bit lane in `a` and `b`.",N,[[["__m256"],["__m256"]],["__m256"]]],[5,"_mm256_testz_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testnzc_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`, and set `ZF` to 1 if the result is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, and set `CF` to 1 if the result is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256i"],["__m256i"]],["i32"]]],[5,"_mm256_testz_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm256_testc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm256_testnzc_pd","","Compute the bitwise AND of 256 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256d"],["__m256d"]],["i32"]]],[5,"_mm_testz_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_testc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm_testnzc_pd","","Compute the bitwise AND of 128 bits (representing double-precision (64-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 64-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m128d"],["__m128d"]],["i32"]]],[5,"_mm256_testz_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm256_testc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm256_testnzc_ps","","Compute the bitwise AND of 256 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 256-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m256"],["__m256"]],["i32"]]],[5,"_mm_testz_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `ZF` value.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_testc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return the `CF` value.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm_testnzc_ps","","Compute the bitwise AND of 128 bits (representing single-precision (32-bit) floating-point elements) in `a` and `b`, producing an intermediate 128-bit value, and set `ZF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `ZF` to 0. Compute the bitwise NOT of `a` and then AND with `b`, producing an intermediate value, and set `CF` to 1 if the sign bit of each 32-bit element in the intermediate value is zero, otherwise set `CF` to 0. Return 1 if both the `ZF` and `CF` values are zero, otherwise return 0.",N,[[["__m128"],["__m128"]],["i32"]]],[5,"_mm256_movemask_pd","","Set each bit of the returned mask based on the most significant bit of the corresponding packed double-precision (64-bit) floating-point element in `a`.",N,[[["__m256d"]],["i32"]]],[5,"_mm256_movemask_ps","","Set each bit of the returned mask based on the most significant bit of the corresponding packed single-precision (32-bit) floating-point element in `a`.",N,[[["__m256"]],["i32"]]],[5,"_mm256_setzero_pd","","Return vector of type __m256d with all elements set to zero.",N,[[],["__m256d"]]],[5,"_mm256_setzero_ps","","Return vector of type __m256 with all elements set to zero.",N,[[],["__m256"]]],[5,"_mm256_setzero_si256","","Return vector of type __m256i with all elements set to zero.",N,[[],["__m256i"]]],[5,"_mm256_set_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values.",N,[[["f64"],["f64"],["f64"],["f64"]],["__m256d"]]],[5,"_mm256_set_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values.",N,[[["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"]],["__m256"]]],[5,"_mm256_set_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m256i"]]],[5,"_mm256_set_epi16","","Set packed 16-bit integers in returned vector with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m256i"]]],[5,"_mm256_set_epi32","","Set packed 32-bit integers in returned vector with the supplied values.",N,[[["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_set_epi64x","","Set packed 64-bit integers in returned vector with the supplied values.",N,[[["i64"],["i64"],["i64"],["i64"]],["__m256i"]]],[5,"_mm256_setr_pd","","Set packed double-precision (64-bit) floating-point elements in returned vector with the supplied values in reverse order.",N,[[["f64"],["f64"],["f64"],["f64"]],["__m256d"]]],[5,"_mm256_setr_ps","","Set packed single-precision (32-bit) floating-point elements in returned vector with the supplied values in reverse order.",N,[[["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"],["f32"]],["__m256"]]],[5,"_mm256_setr_epi8","","Set packed 8-bit integers in returned vector with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m256i"]]],[5,"_mm256_setr_epi16","","Set packed 16-bit integers in returned vector with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"],["i16"]],["__m256i"]]],[5,"_mm256_setr_epi32","","Set packed 32-bit integers in returned vector with the supplied values in reverse order.",N,[[["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"],["i32"]],["__m256i"]]],[5,"_mm256_setr_epi64x","","Set packed 64-bit integers in returned vector with the supplied values in reverse order.",N,[[["i64"],["i64"],["i64"],["i64"]],["__m256i"]]],[5,"_mm256_set1_pd","","Broadcast double-precision (64-bit) floating-point value `a` to all elements of returned vector.",N,[[["f64"]],["__m256d"]]],[5,"_mm256_set1_ps","","Broadcast single-precision (32-bit) floating-point value `a` to all elements of returned vector.",N,[[["f32"]],["__m256"]]],[5,"_mm256_set1_epi8","","Broadcast 8-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastb`.",N,[[["i8"]],["__m256i"]]],[5,"_mm256_set1_epi16","","Broadcast 16-bit integer `a` to all all elements of returned vector. This intrinsic may generate the `vpbroadcastw`.",N,[[["i16"]],["__m256i"]]],[5,"_mm256_set1_epi32","","Broadcast 32-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastd`.",N,[[["i32"]],["__m256i"]]],[5,"_mm256_set1_epi64x","","Broadcast 64-bit integer `a` to all elements of returned vector. This intrinsic may generate the `vpbroadcastq`.",N,[[["i64"]],["__m256i"]]],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",N,[[["__m256d"]],["__m256"]]],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",N,[[["__m256"]],["__m256d"]]],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",N,[[["__m256"]],["__m256i"]]],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",N,[[["__m256i"]],["__m256"]]],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",N,[[["__m256d"]],["__m256i"]]],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",N,[[["__m256i"]],["__m256d"]]],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",N,[[["__m256"]],["__m128"]]],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",N,[[["__m256d"]],["__m128d"]]],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",N,[[["__m256i"]],["__m128i"]]],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128 bits of the result are undefined.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper 128 bits of the result are undefined.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper 128 bits of the result are undefined.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x float]` from a 128-bit floating-point vector of `[4 x float]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128"]],["__m256"]]],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer vector. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x double]` from a 128-bit floating-point vector of `[2 x double]`. The lower 128 bits contain the value of the source vector. The upper 128 bits are set to zero.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_undefined_ps","","Return vector of type `__m256` with undefined elements.",N,[[],["__m256"]]],[5,"_mm256_undefined_pd","","Return vector of type `__m256d` with undefined elements.",N,[[],["__m256d"]]],[5,"_mm256_undefined_si256","","Return vector of type __m256i with undefined elements.",N,[[],["__m256i"]]],[5,"_mm256_set_m128","","Set packed __m256 returned vector with the supplied values.",N,[[["__m128"],["__m128"]],["__m256"]]],[5,"_mm256_set_m128d","","Set packed __m256d returned vector with the supplied values.",N,[[["__m128d"],["__m128d"]],["__m256d"]]],[5,"_mm256_set_m128i","","Set packed __m256i returned vector with the supplied values.",N,[[["__m128i"],["__m128i"]],["__m256i"]]],[5,"_mm256_setr_m128","","Set packed __m256 returned vector with the supplied values.",N,[[["__m128"],["__m128"]],["__m256"]]],[5,"_mm256_setr_m128d","","Set packed __m256d returned vector with the supplied values.",N,[[["__m128d"],["__m128d"]],["__m256d"]]],[5,"_mm256_setr_m128i","","Set packed __m256i returned vector with the supplied values.",N,[[["__m128i"],["__m128i"]],["__m256i"]]],[5,"_mm256_loadu2_m128","","Load two 128-bit values (composed of 4 packed single-precision (32-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu2_m128d","","Load two 128-bit values (composed of 2 packed double-precision (64-bit) floating-point elements) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_loadu2_m128i","","Load two 128-bit values (composed of integer data) from memory, and combine them into a 256-bit value. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128","","Store the high and low 128-bit halves (each composed of 4 packed single-precision (32-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128d","","Store the high and low 128-bit halves (each composed of 2 packed double-precision (64-bit) floating-point elements) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_storeu2_m128i","","Store the high and low 128-bit halves (each composed of integer data) from `a` into memory two different 128-bit locations. `hiaddr` and `loaddr` do not need to be aligned on any particular boundary.",N,N],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x float]`.",N,[[["__m256"]],["f32"]]],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in `a`.",N,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi64","","Add packed 64-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_alignr_epi8","","Concatenate pairs of 16-byte blocks in `a` and `b` into a 32-byte temporary result, shift the result right by `n` bytes, and return the low 16 bytes.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_and_si256","","Compute the bitwise AND of 256 bits (representing integer data) in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_andnot_si256","","Compute the bitwise NOT of 256 bits (representing integer data) in `a` and then AND with `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu16","","Average packed unsigned 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu8","","Average packed unsigned 8-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm256_blend_epi32","","Blend packed 32-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using control mask `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`.",N,[[["__m256i"],["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastb_epi8","","Broadcast the low packed 8-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastd_epi32","","Broadcast the low packed 32-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 128-bit returned value.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastq_epi64","","Broadcast the low packed 64-bit integer from `a` to all elements of the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 128-bit returned value.",N,[[["__m128d"]],["__m128d"]]],[5,"_mm256_broadcastsd_pd","","Broadcast the low double-precision (64-bit) floating-point element from `a` to all elements of the 256-bit returned value.",N,[[["__m128d"]],["__m256d"]]],[5,"_mm256_broadcastsi128_si256","","Broadcast 128 bits of integer data from a to all 128-bit lanes in the 256-bit returned value.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 128-bit returned value.",N,[[["__m128"]],["__m128"]]],[5,"_mm256_broadcastss_ps","","Broadcast the low single-precision (32-bit) floating-point element from `a` to all elements of the 256-bit returned value.",N,[[["__m128"]],["__m256"]]],[5,"_mm_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 128-bit returned value",N,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all elements of the 256-bit returned value",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi64","","Compare packed 64-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi32","","Compare packed 32-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi16","","Compare packed 16-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi8","","Compare packed 8-bit integers in `a` and `b` for equality.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi64","","Compare packed 64-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi32","","Compare packed 32-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi16","","Compare packed 16-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi8","","Compare packed 8-bit integers in `a` and `b` for greater-than.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in `a` to packed 32-bit integers, and store the results in dst.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a` to 64-bit integers. The upper four elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit integers.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a` to 32-bit integers. The upper eight elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a` to 64-bit integers. The upper twelve elements of `a` are unused.",N,[[["__m128i"]],["__m256i"]]],[5,"_mm256_extracti128_si256","","Extract 128 bits (of integer data) from `a` selected with `imm8`.",N,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_hadd_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hadd_epi32","","Horizontally add adjacent pairs of 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hadds_epi16","","Horizontally add adjacent pairs of 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in `a` and `b` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i32gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_epi32","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_ps","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_epi64","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8.",N,N],[5,"_mm256_mask_i64gather_pd","","Return values from `slice` at offsets determined by `offsets * scale`, where `scale` is between 1 and 8. If mask is set, load the value from `src` in that position instead.",N,N],[5,"_mm256_inserti128_si256","","Copy `a` to `dst`, then insert 128 bits (of integer data) from `b` at the location specified by `imm8`.",N,[[["__m256i"],["__m128i"],["i32"]],["__m256i"]]],[5,"_mm256_madd_epi16","","Multiply packed signed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Horizontally add adjacent pairs of intermediate 32-bit integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_maddubs_epi16","","Vertically multiply each unsigned 8-bit integer from `a` with the corresponding signed 8-bit integer from `b`, producing intermediate signed 16-bit integers. Horizontally add adjacent pairs of intermediate signed 16-bit integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskload_epi32","","Load packed 32-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskload_epi64","","Load packed 64-bit integers from memory pointed by `mem_addr` using `mask` (elements are zeroed out when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskstore_epi32","","Store packed 32-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_maskstore_epi64","","Store packed 64-bit integers from `a` into memory pointed by `mem_addr` using `mask` (elements are not stored when the highest bit is not set in the corresponding element).",N,N],[5,"_mm256_max_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed maximum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi16","","Compare packed 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi32","","Compare packed 32-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi8","","Compare packed 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu16","","Compare packed unsigned 16-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu32","","Compare packed unsigned 32-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu8","","Compare packed unsigned 8-bit integers in `a` and `b`, and return the packed minimum values.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_movemask_epi8","","Create mask from the most significant bit of each 8-bit element in `a`, return the result.",N,[[["__m256i"]],["i32"]]],[5,"_mm256_mpsadbw_epu8","","Compute the sum of absolute differences (SADs) of quadruplets of unsigned 8-bit integers in `a` compared to those in `b`, and store the 16-bit results in dst. Eight SADs are performed for each 128-bit lane using one quadruplet from `b` and eight quadruplets from `a`. One quadruplet is selected from `b` starting at on the offset specified in `imm8`. Eight quadruplets are formed from sequential 8-bit integers selected from `a` starting at the offset specified in `imm8`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_mul_epi32","","Multiply the low 32-bit integers from each packed 64-bit element in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mul_epu32","","Multiply the low unsigned 32-bit integers from each packed 64-bit element in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in `a` and `b`, producing intermediate 32-bit integers and returning the high 16 bits of the intermediate integers.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi16","","Multiply the packed 16-bit integers in `a` and `b`, producing intermediate 32-bit integers, and return the low 16 bits of the intermediate integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi32","","Multiply the packed 32-bit integers in `a` and `b`, producing intermediate 64-bit integers, and return the low 16 bits of the intermediate integers",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_mulhrs_epi16","","Multiply packed 16-bit integers in `a` and `b`, producing intermediate signed 32-bit integers. Truncate each intermediate integer to the 18 most significant bits, round by adding 1, and return bits `[16:1]`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_or_si256","","Compute the bitwise OR of 256 bits (representing integer data) in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using unsigned saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using unsigned saturation",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the content of `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute2x128_si256","","Shuffle 128-bits of integer data selected by `imm8` from `a` and `b`.",N,[[["__m256i"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute4x64_pd","","Shuffle 64-bit floating-point elements in `a` across lanes using the control in `imm8`.",N,[[["__m256d"],["i32"]],["__m256d"]]],[5,"_mm256_permutevar8x32_ps","","Shuffle eight 32-bit foating-point elements in `a` across lanes using the corresponding 32-bit integer index in `idx`.",N,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm256_sad_epu8","","Compute the absolute differences of packed unsigned 8-bit integers in `a` and `b`, then horizontally sum each consecutive 8 differences to produce four unsigned 16-bit integers, and pack these unsigned 16-bit integers in the low 16 bits of the 64-bit return value",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi8","","Shuffle bytes from `a` according to the content of `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi32","","Shuffle 32-bit integers in 128-bit lanes of `a` using the control in `imm8`.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit lanes of `a` using the control in `imm8`. The low 64 bits of 128-bit lanes of `a` are copied to the output.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit lanes of `a` using the control in `imm8`. The high 64 bits of 128-bit lanes of `a` are copied to the output.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_sign_epi16","","Negate packed 16-bit integers in `a` when the corresponding signed 16-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi32","","Negate packed 32-bit integers in `a` when the corresponding signed 32-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi8","","Negate packed 8-bit integers in `a` when the corresponding signed 8-bit integer in `b` is negative, and return the results. Results are zeroed out when the corresponding element in `b` is zero.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sll_epi16","","Shift packed 16-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi32","","Shift packed 32-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi64","","Shift packed 64-bit integers in `a` left by `count` while shifting in zeros, and return the result",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_slli_epi16","","Shift packed 16-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi32","","Shift packed 32-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi64","","Shift packed 64-bit integers in `a` left by `imm8` while shifting in zeros, return the results;",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_si256","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bslli_epi128","","Shift 128-bit lanes in `a` left by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi32","","Shift packed 32-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi64","","Shift packed 64-bit integers in `a` left by the amount specified by the corresponding element in `count` while shifting in zeros, and return the result.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sra_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sra_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in sign bits.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srai_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srai_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in sign bits.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srav_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in sign bits.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_srli_si256","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bsrli_epi128","","Shift 128-bit lanes in `a` right by `imm8` bytes while shifting in zeros.",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srl_epi16","","Shift packed 16-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi32","","Shift packed 32-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi64","","Shift packed 64-bit integers in `a` right by `count` while shifting in zeros.",N,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srli_epi16","","Shift packed 16-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi32","","Shift packed 32-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi64","","Shift packed 64-bit integers in `a` right by `imm8` while shifting in zeros",N,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi32","","Shift packed 32-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi64","","Shift packed 64-bit integers in `a` right by the amount specified by the corresponding element in `count` while shifting in zeros,",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit integers in `a`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half of each 128-bit lane in `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half of each 128-bit lane of `a` and `b`.",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_xor_si256","","Compute the bitwise XOR of 256 bits (representing integer data) in `a` and `b`",N,[[["__m256i"],["__m256i"]],["__m256i"]]],[5,"_mm256_extract_epi8","","Extract an 8-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m256i"],["i32"]],["i8"]]],[5,"_mm256_extract_epi16","","Extract a 16-bit integer from `a`, selected with `imm8`. Returns a 32-bit integer containing the zero-extended integer data.",N,[[["__m256i"],["i32"]],["i16"]]],[5,"_mm256_extract_epi32","","Extract a 32-bit integer from `a`, selected with `imm8`.",N,[[["__m256i"],["i32"]],["i32"]]],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x double]`.",N,[[["__m256d"]],["f64"]]],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x i32]`.",N,[[["__m256i"]],["i32"]]],[5,"_mm_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to packed elements in `c`.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively add and subtract packed elements in `c` to/from the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`,  and subtract the lower element in `c` from the intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and alternatively subtract and add packed elements in `c` from/to the intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to packed elements in `c`.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmadd_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fnmadd_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and add the negated intermediate result to the lower element in `c`. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm256_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m256d"],["__m256d"],["__m256d"]],["__m256d"]]],[5,"_mm_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_mm256_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result.",N,[[["__m256"],["__m256"],["__m256"]],["__m256"]]],[5,"_mm_fnmsub_sd","","Multiply the lower double-precision (64-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the upper element from `a` to the upper elements of the result.",N,[[["__m128d"],["__m128d"],["__m128d"]],["__m128d"]]],[5,"_mm_fnmsub_ss","","Multiply the lower single-precision (32-bit) floating-point elements in `a` and `b`, and subtract packed elements in `c` from the negated intermediate result. Store the result in the lower element of the returned value, and copy the 3 upper elements from `a` to the upper elements of the result.",N,[[["__m128"],["__m128"],["__m128"]],["__m128"]]],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",N,[[["u32"]],["u32"]]],[5,"_popcnt32","","Counts the bits that are set.",N,[[["i32"]],["i32"]]],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",N,[[["u32"],["u32"],["u32"]],["u32"]]],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",N,[[["u32"],["u32"]],["u32"]]],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_blsi_u32","","Extract lowest set isolated bit.",N,[[["u32"]],["u32"]]],[5,"_blsmsk_u32","","Get mask up to lowest set bit.",N,[[["u32"]],["u32"]]],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",N,[[["u32"]],["u32"]]],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",N,[[["u32"]],["i32"]]],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",N,[[["u32"],["u32"],["u32"]],["u32"]]],[5,"_bzhi_u32","","Zero higher bits of `a` >= `index`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",N,[[["u32"],["u32"]],["u32"]]],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",N,[[["u32"],["u32"]],["u32"]]],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64 bits of `x`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",N,N],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",N,N],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_blcfill_u64","","Clears all bits below the least significant zero bit of `x`.",N,[[["u64"]],["u64"]]],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant zero bit.",N,[[["u32"]],["u32"]]],[5,"_blci_u64","","Sets all bits of `x` to 1 except for the least significant zero bit.",N,[[["u64"]],["u64"]]],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all other bits.",N,[[["u32"]],["u32"]]],[5,"_blcic_u64","","Sets the least significant zero bit of `x` and clears all other bits.",N,[[["u64"]],["u64"]]],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all bits above that bit.",N,[[["u32"]],["u32"]]],[5,"_blcmsk_u64","","Sets the least significant zero bit of `x` and clears all bits above that bit.",N,[[["u64"]],["u64"]]],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",N,[[["u32"]],["u32"]]],[5,"_blcs_u64","","Sets the least significant zero bit of `x`.",N,[[["u64"]],["u64"]]],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",N,[[["u32"]],["u32"]]],[5,"_blsfill_u64","","Sets all bits of `x` below the least significant one.",N,[[["u64"]],["u64"]]],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",N,[[["u32"]],["u32"]]],[5,"_blsic_u64","","Clears least significant bit and sets all other bits.",N,[[["u64"]],["u64"]]],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x` and sets all other bits.",N,[[["u32"]],["u32"]]],[5,"_t1mskc_u64","","Clears all bits below the least significant zero of `x` and sets all other bits.",N,[[["u64"]],["u64"]]],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and clears all other bits.",N,[[["u32"]],["u32"]]],[5,"_tzmsk_u64","","Sets all bits below the least significant one of `x` and clears all other bits.",N,[[["u64"]],["u64"]]],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",N,[[],["__m64"]]],[5,"_mm_add_pi8","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddb","","Add packed 8-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_add_pi16","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddw","","Add packed 16-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_add_pi32","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddd","","Add packed 32-bit integers in `a` and `b`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pi8","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddsb","","Add packed 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pi16","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddsw","","Add packed 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pu8","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddusb","","Add packed unsigned 8-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_adds_pu16","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_paddusw","","Add packed unsigned 16-bit integers in `a` and `b` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit integers in `a`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed unsigned 8-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from packed unsigned 16-bit integers in `a` using saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_packs_pi16","","Convert packed 16-bit integers from `a` and `b` to packed 8-bit integers using signed saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_packs_pi32","","Convert packed 32-bit integers from `a` and `b` to packed 16-bit integers using signed saturation.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the corresponding element of `b` returning `0` for `false` and `-1` for `true`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors and interleaves them into the result: `[a.2, b.2, a.3, b.3]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors and interleaves them into the result: `[a.4, b.4, a.5, b.5, a.6, b.6, a.7, b.7]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors and interleaves them into the result: `[a.0, b.0, a.1, b.1, a.2, b.2, a.3, b.3]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors and interleaves them into the result: `[a.0 b.0 a.1 b.1]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and interleaves them into the result: `[a.1, b.1]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and interleaves them into the result: `[a.0, b.0]`.",N,[[["__m64"],["__m64"]],["__m64"]]],[5,"_mm_set_pi16","","Set packed 16-bit integers in dst with the supplied values.",N,[[["i16"],["i16"],["i16"],["i16"]],["__m64"]]],[5,"_mm_set_pi32","","Set packed 32-bit integers in dst with the supplied values.",N,[[["i32"],["i32"]],["__m64"]]],[5,"_mm_set_pi8","","Set packed 8-bit integers in dst with the supplied values.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m64"]]],[5,"_mm_set1_pi16","","Broadcast 16-bit integer a to all all elements of dst.",N,[[["i16"]],["__m64"]]],[5,"_mm_set1_pi32","","Broadcast 32-bit integer a to all all elements of dst.",N,[[["i32"]],["__m64"]]],[5,"_mm_set1_pi8","","Broadcast 8-bit integer a to all all elements of dst.",N,[[["i8"]],["__m64"]]],[5,"_mm_setr_pi16","","Set packed 16-bit integers in dst with the supplied values in reverse order.",N,[[["i16"],["i16"],["i16"],["i16"]],["__m64"]]],[5,"_mm_setr_pi32","","Set packed 32-bit integers in dst with the supplied values in reverse order.",N,[[["i32"],["i32"]],["__m64"]]],[5,"_mm_setr_pi8","","Set packed 8-bit integers in dst with the supplied values in reverse order.",N,[[["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"],["i8"]],["__m64"]]],[5,"_mm_clmulepi64_si128","","Perform a carry-less multiplication of two 64-bit polynomials over the finite field GF(2^k).",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_aesdec_si128","","Perform one round of an AES decryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesdeclast_si128","","Perform the last round of an AES decryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesenc_si128","","Perform one round of an AES encryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesenclast_si128","","Perform the last round of an AES encryption flow on data (state) in `a`.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_aesimc_si128","","Perform the `InvMixColumns` transformation on `a`.",N,[[["__m128i"]],["__m128i"]]],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",N,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u16"]],["i32"]]],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u32"]],["i32"]]],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u16"]],["i32"]]],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u32"]],["i32"]]],[5,"_mm_sha1msg1_epu32","","Perform an intermediate calculation for the next four SHA1 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and returning the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1msg2_epu32","","Perform the final calculation for the next four SHA1 message values (unsigned 32-bit integers) using the intermediate result in `a` and the previous message values in `b`, and returns the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of operation from the current SHA1 state variable `a`, add that value to the scheduled values (unsigned 32-bit integers) in `b`, and returns the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha1rnds4_epu32","","Perform four rounds of SHA1 operation using an initial SHA1 state (A,B,C,D) from `a` and some pre-computed sum of the next 4 round message values (unsigned 32-bit integers), and state variable E from `b`, and return the updated SHA1 state (A,B,C,D). `func` contains the logic functions and round constants.",N,[[["__m128i"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sha256msg1_epu32","","Perform an intermediate calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha256msg2_epu32","","Perform the final calculation for the next four SHA256 message values (unsigned 32-bit integers) using previous message values from `a` and `b`, and return the result.",N,[[["__m128i"],["__m128i"]],["__m128i"]]],[5,"_mm_sha256rnds2_epu32","","Perform 2 rounds of SHA256 operation using an initial SHA256 state (C,D,G,H) from `a`, an initial SHA256 state (A,B,E,F) from `b`, and a pre-computed sum of the next 2 round message values (unsigned 32-bit integers) and the corresponding round constants from `k`, and store the updated SHA256 state (A,B,E,F) in dst.",N,[[["__m128i"],["__m128i"],["__m128i"]],["__m128i"]]],[5,"_fxsave64","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR` registers to the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_fxrstor64","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU registers from the 512-byte-long 16-byte-aligned memory region `mem_addr`.",N,N],[5,"_mm_cvtss_si64","","Convert the lowest 32 bit float in the input vector to a 64 bit integer.",N,[[["__m128"]],["i64"]]],[5,"_mm_cvttss_si64","","Convert the lowest 32 bit float in the input vector to a 64 bit integer with truncation.",N,[[["__m128"]],["i64"]]],[5,"_mm_cvtsi64_ss","","Convert a 64 bit integer to a 32 bit float. The result vector is the input vector `a` with the lowest 32 bit float replaced by the converted integer.",N,[[["__m128"],["i64"]],["__m128"]]],[5,"_mm_cvtsd_si64","","Convert the lower double-precision (64-bit) floating-point element in a to a 64-bit integer.",N,[[["__m128d"]],["i64"]]],[5,"_mm_cvtsd_si64x","","Alias for `_mm_cvtsd_si64`",N,[[["__m128d"]],["i64"]]],[5,"_mm_cvttsd_si64","","Convert the lower double-precision (64-bit) floating-point element in `a` to a 64-bit integer with truncation.",N,[[["__m128d"]],["i64"]]],[5,"_mm_cvttsd_si64x","","Alias for `_mm_cvttsd_si64`",N,[[["__m128d"]],["i64"]]],[5,"_mm_stream_si64","","Stores a 64-bit integer value in the specified memory location. To minimize caching, the data is flagged as non-temporal (unlikely to be used again soon).",N,N],[5,"_mm_cvtsi64_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",N,[[["i64"]],["__m128i"]]],[5,"_mm_cvtsi64x_si128","","Return a vector whose lowest element is `a` and all higher elements are `0`.",N,[[["i64"]],["__m128i"]]],[5,"_mm_cvtsi128_si64","","Return the lowest element of `a`.",N,[[["__m128i"]],["i64"]]],[5,"_mm_cvtsi128_si64x","","Return the lowest element of `a`.",N,[[["__m128i"]],["i64"]]],[5,"_mm_cvtsi64_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",N,[[["__m128d"],["i64"]],["__m128d"]]],[5,"_mm_cvtsi64x_sd","","Return `a` with its lower element replaced by `b` after converting it to an `f64`.",N,[[["__m128d"],["i64"]],["__m128d"]]],[5,"_mm_extract_epi64","","Extract an 64-bit integer from `a` selected with `imm8`",N,[[["__m128i"],["i32"]],["i64"]]],[5,"_mm_insert_epi64","","Return a copy of `a` with the 64-bit integer from `i` inserted at a location specified by `imm8`.",N,[[["__m128i"],["i64"],["i32"]],["__m128i"]]],[5,"_mm_crc32_u64","","Starting with the initial value in `crc`, return the accumulated CRC32 value for unsigned 64-bit integer `v`.",N,[[["u64"],["u64"]],["u64"]]],[5,"_xsave64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xrstor64","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_xsaveopt64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsavec64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`.",N,N],[5,"_xsaves64","","Perform a full or partial save of the enabled processor states to memory at `mem_addr`",N,N],[5,"_xrstors64","","Perform a full or partial restore of the enabled processor states using the state information stored in memory at `mem_addr`.",N,N],[5,"_lzcnt_u64","","Counts the leading most significant zero bits.",N,[[["u64"]],["u64"]]],[5,"_popcnt64","","Counts the bits that are set.",N,[[["i64"]],["i32"]]],[5,"_mm256_insert_epi64","","Copy `a` to result, and insert the 64-bit integer `i` into result at the location specified by `index`.",N,[[["__m256i"],["i64"],["i32"]],["__m256i"]]],[5,"_bextr_u64","","Extracts bits in range [`start`, `start` + `length`) from `a` into the least significant bits of the result.",N,[[["u64"],["u32"],["u32"]],["u64"]]],[5,"_bextr2_u64","","Extracts bits of `a` specified by `control` into the least significant bits of the result.",N,[[["u64"],["u64"]],["u64"]]],[5,"_andn_u64","","Bitwise logical `AND` of inverted `a` with `b`.",N,[[["u64"],["u64"]],["u64"]]],[5,"_blsi_u64","","Extract lowest set isolated bit.",N,[[["u64"]],["u64"]]],[5,"_blsmsk_u64","","Get mask up to lowest set bit.",N,[[["u64"]],["u64"]]],[5,"_blsr_u64","","Resets the lowest set bit of `x`.",N,[[["u64"]],["u64"]]],[5,"_tzcnt_u64","","Counts the number of trailing least significant zero bits.",N,[[["u64"]],["u64"]]],[5,"_mm_tzcnt_64","","Counts the number of trailing least significant zero bits.",N,[[["u64"]],["i64"]]],[5,"_mulx_u64","","Unsigned multiply without affecting flags.",N,[[["u64"],["u64"],["u64"]],["u64"]]],[5,"_bzhi_u64","","Zero higher bits of `a` >= `index`.",N,[[["u64"],["u32"]],["u64"]]],[5,"_pdep_u64","","Scatter contiguous low order bits of `a` to the result at the positions specified by the `mask`.",N,[[["u64"],["u64"]],["u64"]]],[5,"_pext_u64","","Gathers the bits of `x` specified by the `mask` into the contiguous low order bit positions of the result.",N,[[["u64"],["u64"]],["u64"]]],[5,"_mm256_extract_epi64","","Extract a 64-bit integer from `a`, selected with `imm8`.",N,[[["__m256i"],["i32"]],["i64"]]],[5,"_bswap64","","Return an integer with the reversed byte order of x",N,[[["i64"]],["i64"]]],[5,"_rdrand64_step","","Read a hardware generated 64-bit random value and store the result in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u64"]],["i32"]]],[5,"_rdseed64_step","","Read a 64-bit NIST SP800-90B and SP800-90C compliant random value and store in val. Return 1 if a random value was generated, and 0 otherwise.",N,[[["u64"]],["i32"]]],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",N,N],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",N,N],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",N,N],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",N,N],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",N,N],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",N,N],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",N,N],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",N,N],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",N,N],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",N,N],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",N,N],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",N,N],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",N,N],[17,"_MM_FROUND_TO_NEG_INF","","round down",N,N],[17,"_MM_FROUND_TO_POS_INF","","round up",N,N],[17,"_MM_FROUND_TO_ZERO","","truncate",N,N],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",N,N],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",N,N],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",N,N],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",N,N],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",N,N],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",N,N],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see `vendor::_MM_SET_ROUNDING_MODE`",N,N],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",N,N],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",N,N],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",N,N],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",N,N],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",N,N],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1] or b[1] <= c <= b[2]...`",N,N],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",N,N],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",N,N],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",N,N],[17,"_SIDD_NEGATIVE_POLARITY","","Negate results",N,N],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",N,N],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negate results only before the end of the string",N,N],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",N,N],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",N,N],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",N,N],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",N,N],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",N,N],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",N,N],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",N,N],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",N,N],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",N,N],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",N,N],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",N,N],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",N,N],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",N,N],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",N,N],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",N,N],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",N,N],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",N,N],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",N,N],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",N,N],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",N,N],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",N,N],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",N,N],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",N,N],[17,"_CMP_UNORD_S","","Unordered (signaling)",N,N],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",N,N],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",N,N],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",N,N],[17,"_CMP_ORD_S","","Ordered (signaling)",N,N],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",N,N],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",N,N],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",N,N],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",N,N],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",N,N],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",N,N],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",N,N],[17,"_CMP_TRUE_US","","True (unordered, signaling)",N,N],[0,"arm","core::arch","Platform-specific intrinsics for the `arm` platform.",N,N],[3,"int8x4_t","core::arch::arm","ARM-specific 32-bit wide vector of four packed `i8`.",N,N],[3,"uint8x4_t","","ARM-specific 32-bit wide vector of four packed `u8`.",N,N],[3,"int16x2_t","","ARM-specific 32-bit wide vector of two packed `i16`.",N,N],[3,"uint16x2_t","","ARM-specific 32-bit wide vector of two packed `u16`.",N,N],[3,"int8x8_t","","ARM-specific 64-bit wide vector of eight packed `i8`.",N,N],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",N,N],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed `u8`.",N,N],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",N,N],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",N,N],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",N,N],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",N,N],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",N,N],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",N,N],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",N,N],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",N,N],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `i8`.",N,N],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",N,N],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",N,N],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",N,N],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",N,N],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",N,N],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",N,N],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",N,N],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",N,N],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",N,N],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",N,N],[3,"int8x8x2_t","","ARM-specific type containing two `int8x8_t` vectors.",N,N],[12,"0","","",155,N],[12,"1","","",155,N],[3,"int8x8x3_t","","ARM-specific type containing three `int8x8_t` vectors.",N,N],[12,"0","","",156,N],[12,"1","","",156,N],[12,"2","","",156,N],[3,"int8x8x4_t","","ARM-specific type containing four `int8x8_t` vectors.",N,N],[12,"0","","",157,N],[12,"1","","",157,N],[12,"2","","",157,N],[12,"3","","",157,N],[3,"uint8x8x2_t","","ARM-specific type containing two `uint8x8_t` vectors.",N,N],[12,"0","","",158,N],[12,"1","","",158,N],[3,"uint8x8x3_t","","ARM-specific type containing three `uint8x8_t` vectors.",N,N],[12,"0","","",159,N],[12,"1","","",159,N],[12,"2","","",159,N],[3,"uint8x8x4_t","","ARM-specific type containing four `uint8x8_t` vectors.",N,N],[12,"0","","",160,N],[12,"1","","",160,N],[12,"2","","",160,N],[12,"3","","",160,N],[3,"poly8x8x2_t","","ARM-specific type containing two `poly8x8_t` vectors.",N,N],[12,"0","","",161,N],[12,"1","","",161,N],[3,"poly8x8x3_t","","ARM-specific type containing three `poly8x8_t` vectors.",N,N],[12,"0","","",162,N],[12,"1","","",162,N],[12,"2","","",162,N],[3,"poly8x8x4_t","","ARM-specific type containing four `poly8x8_t` vectors.",N,N],[12,"0","","",163,N],[12,"1","","",163,N],[12,"2","","",163,N],[12,"3","","",163,N],[5,"__enable_irq","","Enable IRQ Interrupts",N,[[]]],[5,"__disable_irq","","Disable IRQ Interrupts",N,[[]]],[5,"__get_CONTROL","","Get Control Register",N,[[],["u32"]]],[5,"__set_CONTROL","","Set Control Register",N,[[["u32"]]]],[5,"__get_IPSR","","Get IPSR Register",N,[[],["u32"]]],[5,"__get_APSR","","Get APSR Register",N,[[],["u32"]]],[5,"__get_xPSR","","Get xPSR Register",N,[[],["u32"]]],[5,"__get_PSP","","Get Process Stack Pointer",N,[[],["u32"]]],[5,"__set_PSP","","Set Process Stack Pointer",N,[[["u32"]]]],[5,"__get_MSP","","Get Main Stack Pointer",N,[[],["u32"]]],[5,"__set_MSP","","Set Main Stack Pointer",N,[[["u32"]]]],[5,"__get_PRIMASK","","Get Priority Mask",N,[[],["u32"]]],[5,"__set_PRIMASK","","Set Priority Mask",N,[[["u32"]]]],[5,"__enable_fault_irq","","Enable FIQ",N,[[]]],[5,"__disable_fault_irq","","Disable FIQ",N,[[]]],[5,"__get_BASEPRI","","Get Base Priority",N,[[],["u32"]]],[5,"__set_BASEPRI","","Set Base Priority",N,[[["u32"]]]],[5,"__set_BASEPRI_MAX","","Set Base Priority with condition",N,[[["u32"]]]],[5,"__get_FAULTMASK","","Get Fault Mask",N,[[],["u32"]]],[5,"__set_FAULTMASK","","Set Fault Mask",N,[[["u32"]]]],[5,"__NOP","","No Operation",N,[[]]],[5,"__WFI","","Wait For Interrupt",N,[[]]],[5,"__WFE","","Wait For Event",N,[[]]],[5,"__SEV","","Send Event",N,[[]]],[5,"__ISB","","Instruction Synchronization Barrier",N,[[]]],[5,"__DSB","","Data Synchronization Barrier",N,[[]]],[5,"__DMB","","Data Memory Barrier",N,[[]]],[5,"_rev_u16","","Reverse the order of the bytes.",N,[[["u16"]],["u16"]]],[5,"_rev_u32","","Reverse the order of the bytes.",N,[[["u32"]],["u32"]]],[5,"_rev_u16","","Reverse the order of the bytes.",N,[[["u16"]],["u16"]]],[5,"_rev_u32","","Reverse the order of the bytes.",N,[[["u32"]],["u32"]]],[5,"_clz_u8","","Count Leading Zeros.",N,[[["u8"]],["u8"]]],[5,"_clz_u16","","Count Leading Zeros.",N,[[["u16"]],["u16"]]],[5,"_clz_u32","","Count Leading Zeros.",N,[[["u32"]],["u32"]]],[5,"_rbit_u32","","Reverse the bit order.",N,[[["u32"]],["u32"]]],[5,"qadd","","Signed saturating addition",N,[[["i32"],["i32"]],["i32"]]],[5,"qsub","","Signed saturating subtraction",N,[[["i32"],["i32"]],["i32"]]],[5,"qadd8","","Saturating four 8-bit integer additions",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"qsub8","","Saturating two 8-bit integer subtraction",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"qsub16","","Saturating two 16-bit integer subtraction",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qadd16","","Saturating two 16-bit integer additions",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qasx","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qsax","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sadd16","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sadd8","","Returns the 8-bit signed saturated equivalent of",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"smlad","","Dual 16-bit Signed Multiply with Addition of products and 32-bit accumulation.",N,[[["int16x2_t"],["int16x2_t"],["i32"]],["i32"]]],[5,"smlsd","","Dual 16-bit Signed Multiply with Subtraction  of products and 32-bit accumulation and overflow detection.",N,[[["int16x2_t"],["int16x2_t"],["i32"]],["i32"]]],[5,"sasx","","Returns the 16-bit signed equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sel","","Select bytes from each operand according to APSR GE flags",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shadd8","","Signed halving parallel byte-wise addition.",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shadd16","","Signed halving parallel halfword-wise addition.",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"shsub8","","Signed halving parallel byte-wise subtraction.",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shsub16","","Signed halving parallel halfword-wise subtraction.",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"smuad","","Signed Dual Multiply Add.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smuadx","","Signed Dual Multiply Add Reversed.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smusd","","Signed Dual Multiply Subtract.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smusdx","","Signed Dual Multiply Subtract Reversed.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"usad8","","Sum of 8-bit absolute differences.",N,[[["int8x4_t"],["int8x4_t"]],["u32"]]],[5,"usad8a","","Sum of 8-bit absolute differences and constant.",N,[[["int8x4_t"],["int8x4_t"],["u32"]],["u32"]]],[5,"vadd_s8","","Vector add.",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vaddq_s8","","Vector add.",N,[[["int8x16_t"],["int8x16_t"]],["int8x16_t"]]],[5,"vadd_s16","","Vector add.",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vaddq_s16","","Vector add.",N,[[["int16x8_t"],["int16x8_t"]],["int16x8_t"]]],[5,"vadd_s32","","Vector add.",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vaddq_s32","","Vector add.",N,[[["int32x4_t"],["int32x4_t"]],["int32x4_t"]]],[5,"vaddq_s64","","Vector add.",N,[[["int64x2_t"],["int64x2_t"]],["int64x2_t"]]],[5,"vadd_u8","","Vector add.",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vaddq_u8","","Vector add.",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vadd_u16","","Vector add.",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vaddq_u16","","Vector add.",N,[[["uint16x8_t"],["uint16x8_t"]],["uint16x8_t"]]],[5,"vadd_u32","","Vector add.",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vaddq_u32","","Vector add.",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vaddq_u64","","Vector add.",N,[[["uint64x2_t"],["uint64x2_t"]],["uint64x2_t"]]],[5,"vadd_f32","","Vector add.",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[5,"vaddq_f32","","Vector add.",N,[[["float32x4_t"],["float32x4_t"]],["float32x4_t"]]],[5,"vaddl_s8","","Vector long add.",N,[[["int8x8_t"],["int8x8_t"]],["int16x8_t"]]],[5,"vaddl_s16","","Vector long add.",N,[[["int16x4_t"],["int16x4_t"]],["int32x4_t"]]],[5,"vaddl_s32","","Vector long add.",N,[[["int32x2_t"],["int32x2_t"]],["int64x2_t"]]],[5,"vaddl_u8","","Vector long add.",N,[[["uint8x8_t"],["uint8x8_t"]],["uint16x8_t"]]],[5,"vaddl_u16","","Vector long add.",N,[[["uint16x4_t"],["uint16x4_t"]],["uint32x4_t"]]],[5,"vaddl_u32","","Vector long add.",N,[[["uint32x2_t"],["uint32x2_t"]],["uint64x2_t"]]],[5,"vmovn_s16","","Vector narrow integer.",N,[[["int16x8_t"]],["int8x8_t"]]],[5,"vmovn_s32","","Vector narrow integer.",N,[[["int32x4_t"]],["int16x4_t"]]],[5,"vmovn_s64","","Vector narrow integer.",N,[[["int64x2_t"]],["int32x2_t"]]],[5,"vmovn_u16","","Vector narrow integer.",N,[[["uint16x8_t"]],["uint8x8_t"]]],[5,"vmovn_u32","","Vector narrow integer.",N,[[["uint32x4_t"]],["uint16x4_t"]]],[5,"vmovn_u64","","Vector narrow integer.",N,[[["uint64x2_t"]],["uint32x2_t"]]],[5,"vmovl_s8","","Vector long move.",N,[[["int8x8_t"]],["int16x8_t"]]],[5,"vmovl_s16","","Vector long move.",N,[[["int16x4_t"]],["int32x4_t"]]],[5,"vmovl_s32","","Vector long move.",N,[[["int32x2_t"]],["int64x2_t"]]],[5,"vmovl_u8","","Vector long move.",N,[[["uint8x8_t"]],["uint16x8_t"]]],[5,"vmovl_u16","","Vector long move.",N,[[["uint16x4_t"]],["uint32x4_t"]]],[5,"vmovl_u32","","Vector long move.",N,[[["uint32x2_t"]],["uint64x2_t"]]],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",N,[[["float32x2_t"]],["float32x2_t"]]],[5,"vpmin_s8","","Folding minimum of adjacent pairs",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vpmin_s16","","Folding minimum of adjacent pairs",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vpmin_s32","","Folding minimum of adjacent pairs",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vpmin_u8","","Folding minimum of adjacent pairs",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmin_u16","","Folding minimum of adjacent pairs",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmin_u32","","Folding minimum of adjacent pairs",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmin_f32","","Folding minimum of adjacent pairs",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[5,"vpmax_s8","","Folding maximum of adjacent pairs",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vpmax_s16","","Folding maximum of adjacent pairs",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vpmax_s32","","Folding maximum of adjacent pairs",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vpmax_u8","","Folding maximum of adjacent pairs",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmax_u16","","Folding maximum of adjacent pairs",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmax_u32","","Folding maximum of adjacent pairs",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmax_f32","","Folding maximum of adjacent pairs",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[5,"vtbl1_s8","","Table look-up",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbl1_u8","","Table look-up",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbl1_p8","","Table look-up",N,[[["poly8x8_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vtbl2_s8","","Table look-up",N,[[["int8x8x2_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbl2_u8","","Table look-up",N,[[["uint8x8x2_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbl2_p8","","Table look-up",N,[[["poly8x8x2_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbl3_s8","","Table look-up",N,[[["int8x8x3_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbl3_u8","","Table look-up",N,[[["uint8x8x3_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbl3_p8","","Table look-up",N,[[["poly8x8x3_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbl4_s8","","Table look-up",N,[[["int8x8x4_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbl4_u8","","Table look-up",N,[[["uint8x8x4_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbl4_p8","","Table look-up",N,[[["poly8x8x4_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbx1_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbx1_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbx1_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x8_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbx2_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x8x2_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbx2_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x8x2_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbx2_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x8x2_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbx3_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x8x3_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbx3_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x8x3_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbx3_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x8x3_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbx4_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x8x4_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbx4_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x8x4_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbx4_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x8x4_t"],["uint8x8_t"]],["poly8x8_t"]]],[0,"aarch64","core::arch","Platform-specific intrinsics for the `aarch64` platform.",N,N],[3,"float64x1_t","core::arch::aarch64","ARM-specific 64-bit wide vector of one packed `f64`.",N,N],[3,"float64x2_t","","ARM-specific 128-bit wide vector of two packed `f64`.",N,N],[3,"poly64x1_t","","ARM-specific 64-bit wide vector of one packed `p64`.",N,N],[3,"poly64x2_t","","ARM-specific 64-bit wide vector of two packed `p64`.",N,N],[3,"int8x16x2_t","","ARM-specific type containing two `int8x16_t` vectors.",N,N],[12,"0","","",164,N],[12,"1","","",164,N],[3,"int8x16x3_t","","ARM-specific type containing three `int8x16_t` vectors.",N,N],[12,"0","","",165,N],[12,"1","","",165,N],[12,"2","","",165,N],[3,"int8x16x4_t","","ARM-specific type containing four `int8x16_t` vectors.",N,N],[12,"0","","",166,N],[12,"1","","",166,N],[12,"2","","",166,N],[12,"3","","",166,N],[3,"uint8x16x2_t","","ARM-specific type containing two `uint8x16_t` vectors.",N,N],[12,"0","","",167,N],[12,"1","","",167,N],[3,"uint8x16x3_t","","ARM-specific type containing three `uint8x16_t` vectors.",N,N],[12,"0","","",168,N],[12,"1","","",168,N],[12,"2","","",168,N],[3,"uint8x16x4_t","","ARM-specific type containing four `uint8x16_t` vectors.",N,N],[12,"0","","",169,N],[12,"1","","",169,N],[12,"2","","",169,N],[12,"3","","",169,N],[3,"poly8x16x2_t","","ARM-specific type containing two `poly8x16_t` vectors.",N,N],[12,"0","","",170,N],[12,"1","","",170,N],[3,"poly8x16x3_t","","ARM-specific type containing three `poly8x16_t` vectors.",N,N],[12,"0","","",171,N],[12,"1","","",171,N],[12,"2","","",171,N],[3,"poly8x16x4_t","","ARM-specific type containing four `poly8x16_t` vectors.",N,N],[12,"0","","",172,N],[12,"1","","",172,N],[12,"2","","",172,N],[12,"3","","",172,N],[3,"int8x4_t","","ARM-specific 32-bit wide vector of four packed `i8`.",N,N],[3,"uint8x4_t","","ARM-specific 32-bit wide vector of four packed `u8`.",N,N],[3,"int16x2_t","","ARM-specific 32-bit wide vector of two packed `i16`.",N,N],[3,"uint16x2_t","","ARM-specific 32-bit wide vector of two packed `u16`.",N,N],[3,"int8x8_t","","ARM-specific 64-bit wide vector of eight packed `i8`.",N,N],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",N,N],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed `u8`.",N,N],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",N,N],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",N,N],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",N,N],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",N,N],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",N,N],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",N,N],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",N,N],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",N,N],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `i8`.",N,N],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",N,N],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",N,N],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",N,N],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",N,N],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",N,N],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",N,N],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",N,N],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",N,N],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",N,N],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",N,N],[3,"int8x8x2_t","","ARM-specific type containing two `int8x8_t` vectors.",N,N],[12,"0","","",155,N],[12,"1","","",155,N],[3,"int8x8x3_t","","ARM-specific type containing three `int8x8_t` vectors.",N,N],[12,"0","","",156,N],[12,"1","","",156,N],[12,"2","","",156,N],[3,"int8x8x4_t","","ARM-specific type containing four `int8x8_t` vectors.",N,N],[12,"0","","",157,N],[12,"1","","",157,N],[12,"2","","",157,N],[12,"3","","",157,N],[3,"uint8x8x2_t","","ARM-specific type containing two `uint8x8_t` vectors.",N,N],[12,"0","","",158,N],[12,"1","","",158,N],[3,"uint8x8x3_t","","ARM-specific type containing three `uint8x8_t` vectors.",N,N],[12,"0","","",159,N],[12,"1","","",159,N],[12,"2","","",159,N],[3,"uint8x8x4_t","","ARM-specific type containing four `uint8x8_t` vectors.",N,N],[12,"0","","",160,N],[12,"1","","",160,N],[12,"2","","",160,N],[12,"3","","",160,N],[3,"poly8x8x2_t","","ARM-specific type containing two `poly8x8_t` vectors.",N,N],[12,"0","","",161,N],[12,"1","","",161,N],[3,"poly8x8x3_t","","ARM-specific type containing three `poly8x8_t` vectors.",N,N],[12,"0","","",162,N],[12,"1","","",162,N],[12,"2","","",162,N],[3,"poly8x8x4_t","","ARM-specific type containing four `poly8x8_t` vectors.",N,N],[12,"0","","",163,N],[12,"1","","",163,N],[12,"2","","",163,N],[12,"3","","",163,N],[5,"_rev_u64","","Reverse the order of the bytes.",N,[[["u64"]],["u64"]]],[5,"_clz_u64","","Count Leading Zeros.",N,[[["u64"]],["u64"]]],[5,"_rbit_u64","","Reverse the bit order.",N,[[["u64"]],["u64"]]],[5,"_cls_u32","","Counts the leading most significant bits set.",N,[[["u32"]],["u32"]]],[5,"_cls_u64","","Counts the leading most significant bits set.",N,[[["u64"]],["u64"]]],[5,"vadd_f64","","Vector add.",N,[[["float64x1_t"],["float64x1_t"]],["float64x1_t"]]],[5,"vaddq_f64","","Vector add.",N,[[["float64x2_t"],["float64x2_t"]],["float64x2_t"]]],[5,"vaddd_s64","","Vector add.",N,[[["int64x1_t"],["int64x1_t"]],["int64x1_t"]]],[5,"vaddd_u64","","Vector add.",N,[[["uint64x1_t"],["uint64x1_t"]],["uint64x1_t"]]],[5,"vmaxv_s8","","Horizontal vector max.",N,[[["int8x8_t"]],["i8"]]],[5,"vmaxvq_s8","","Horizontal vector max.",N,[[["int8x16_t"]],["i8"]]],[5,"vmaxv_s16","","Horizontal vector max.",N,[[["int16x4_t"]],["i16"]]],[5,"vmaxvq_s16","","Horizontal vector max.",N,[[["int16x8_t"]],["i16"]]],[5,"vmaxv_s32","","Horizontal vector max.",N,[[["int32x2_t"]],["i32"]]],[5,"vmaxvq_s32","","Horizontal vector max.",N,[[["int32x4_t"]],["i32"]]],[5,"vmaxv_u8","","Horizontal vector max.",N,[[["uint8x8_t"]],["u8"]]],[5,"vmaxvq_u8","","Horizontal vector max.",N,[[["uint8x16_t"]],["u8"]]],[5,"vmaxv_u16","","Horizontal vector max.",N,[[["uint16x4_t"]],["u16"]]],[5,"vmaxvq_u16","","Horizontal vector max.",N,[[["uint16x8_t"]],["u16"]]],[5,"vmaxv_u32","","Horizontal vector max.",N,[[["uint32x2_t"]],["u32"]]],[5,"vmaxvq_u32","","Horizontal vector max.",N,[[["uint32x4_t"]],["u32"]]],[5,"vmaxv_f32","","Horizontal vector max.",N,[[["float32x2_t"]],["f32"]]],[5,"vmaxvq_f32","","Horizontal vector max.",N,[[["float32x4_t"]],["f32"]]],[5,"vmaxvq_f64","","Horizontal vector max.",N,[[["float64x2_t"]],["f64"]]],[5,"vminv_s8","","Horizontal vector min.",N,[[["int8x8_t"]],["i8"]]],[5,"vminvq_s8","","Horizontal vector min.",N,[[["int8x16_t"]],["i8"]]],[5,"vminv_s16","","Horizontal vector min.",N,[[["int16x4_t"]],["i16"]]],[5,"vminvq_s16","","Horizontal vector min.",N,[[["int16x8_t"]],["i16"]]],[5,"vminv_s32","","Horizontal vector min.",N,[[["int32x2_t"]],["i32"]]],[5,"vminvq_s32","","Horizontal vector min.",N,[[["int32x4_t"]],["i32"]]],[5,"vminv_u8","","Horizontal vector min.",N,[[["uint8x8_t"]],["u8"]]],[5,"vminvq_u8","","Horizontal vector min.",N,[[["uint8x16_t"]],["u8"]]],[5,"vminv_u16","","Horizontal vector min.",N,[[["uint16x4_t"]],["u16"]]],[5,"vminvq_u16","","Horizontal vector min.",N,[[["uint16x8_t"]],["u16"]]],[5,"vminv_u32","","Horizontal vector min.",N,[[["uint32x2_t"]],["u32"]]],[5,"vminvq_u32","","Horizontal vector min.",N,[[["uint32x4_t"]],["u32"]]],[5,"vminv_f32","","Horizontal vector min.",N,[[["float32x2_t"]],["f32"]]],[5,"vminvq_f32","","Horizontal vector min.",N,[[["float32x4_t"]],["f32"]]],[5,"vminvq_f64","","Horizontal vector min.",N,[[["float64x2_t"]],["f64"]]],[5,"vpminq_s8","","Folding minimum of adjacent pairs",N,[[["int8x16_t"],["int8x16_t"]],["int8x16_t"]]],[5,"vpminq_s16","","Folding minimum of adjacent pairs",N,[[["int16x8_t"],["int16x8_t"]],["int16x8_t"]]],[5,"vpminq_s32","","Folding minimum of adjacent pairs",N,[[["int32x4_t"],["int32x4_t"]],["int32x4_t"]]],[5,"vpminq_u8","","Folding minimum of adjacent pairs",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vpminq_u16","","Folding minimum of adjacent pairs",N,[[["uint16x8_t"],["uint16x8_t"]],["uint16x8_t"]]],[5,"vpminq_u32","","Folding minimum of adjacent pairs",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vpminq_f32","","Folding minimum of adjacent pairs",N,[[["float32x4_t"],["float32x4_t"]],["float32x4_t"]]],[5,"vpminq_f64","","Folding minimum of adjacent pairs",N,[[["float64x2_t"],["float64x2_t"]],["float64x2_t"]]],[5,"vpmaxq_s8","","Folding maximum of adjacent pairs",N,[[["int8x16_t"],["int8x16_t"]],["int8x16_t"]]],[5,"vpmaxq_s16","","Folding maximum of adjacent pairs",N,[[["int16x8_t"],["int16x8_t"]],["int16x8_t"]]],[5,"vpmaxq_s32","","Folding maximum of adjacent pairs",N,[[["int32x4_t"],["int32x4_t"]],["int32x4_t"]]],[5,"vpmaxq_u8","","Folding maximum of adjacent pairs",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vpmaxq_u16","","Folding maximum of adjacent pairs",N,[[["uint16x8_t"],["uint16x8_t"]],["uint16x8_t"]]],[5,"vpmaxq_u32","","Folding maximum of adjacent pairs",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vpmaxq_f32","","Folding maximum of adjacent pairs",N,[[["float32x4_t"],["float32x4_t"]],["float32x4_t"]]],[5,"vpmaxq_f64","","Folding maximum of adjacent pairs",N,[[["float64x2_t"],["float64x2_t"]],["float64x2_t"]]],[5,"vcombine_s8","","Vector combine",N,[[["int8x8_t"],["int8x8_t"]],["int8x16_t"]]],[5,"vcombine_s16","","Vector combine",N,[[["int16x4_t"],["int16x4_t"]],["int16x8_t"]]],[5,"vcombine_s32","","Vector combine",N,[[["int32x2_t"],["int32x2_t"]],["int32x4_t"]]],[5,"vcombine_s64","","Vector combine",N,[[["int64x1_t"],["int64x1_t"]],["int64x2_t"]]],[5,"vcombine_u8","","Vector combine",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x16_t"]]],[5,"vcombine_u16","","Vector combine",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x8_t"]]],[5,"vcombine_u32","","Vector combine",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x4_t"]]],[5,"vcombine_u64","","Vector combine",N,[[["uint64x1_t"],["uint64x1_t"]],["uint64x2_t"]]],[5,"vcombine_p64","","Vector combine",N,[[["poly64x1_t"],["poly64x1_t"]],["poly64x2_t"]]],[5,"vcombine_f32","","Vector combine",N,[[["float32x2_t"],["float32x2_t"]],["float32x4_t"]]],[5,"vcombine_p8","","Vector combine",N,[[["poly8x8_t"],["poly8x8_t"]],["poly8x16_t"]]],[5,"vcombine_p16","","Vector combine",N,[[["poly16x4_t"],["poly16x4_t"]],["poly16x8_t"]]],[5,"vcombine_f64","","Vector combine",N,[[["float64x1_t"],["float64x1_t"]],["float64x2_t"]]],[5,"vqtbl1_s8","","Table look-up",N,[[["int8x16_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbl1q_s8","","Table look-up",N,[[["int8x16_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbl1_u8","","Table look-up",N,[[["uint8x16_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vqtbl1q_u8","","Table look-up",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbl1_p8","","Table look-up",N,[[["poly8x16_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vqtbl1q_p8","","Table look-up",N,[[["poly8x16_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vqtbx1_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x16_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbx1q_s8","","Extended table look-up",N,[[["int8x16_t"],["int8x16_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbx1_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x16_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vqtbx1q_u8","","Extended table look-up",N,[[["uint8x16_t"],["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbx1_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x16_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vqtbx1q_p8","","Extended table look-up",N,[[["poly8x16_t"],["poly8x16_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vqtbl2_s8","","Table look-up",N,[[["int8x16x2_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbl2q_s8","","Table look-up",N,[[["int8x16x2_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbl2_u8","","Table look-up",N,[[["uint8x16x2_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vqtbl2q_u8","","Table look-up",N,[[["uint8x16x2_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbl2_p8","","Table look-up",N,[[["poly8x16x2_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vqtbl2q_p8","","Table look-up",N,[[["poly8x16x2_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vqtbx2_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x16x2_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbx2q_s8","","Extended table look-up",N,[[["int8x16_t"],["int8x16x2_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbx2_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x16x2_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vqtbx2q_u8","","Extended table look-up",N,[[["uint8x16_t"],["uint8x16x2_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbx2_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x16x2_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vqtbx2q_p8","","Extended table look-up",N,[[["poly8x16_t"],["poly8x16x2_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vqtbl3_s8","","Table look-up",N,[[["int8x16x3_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbl3q_s8","","Table look-up",N,[[["int8x16x3_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbl3_u8","","Table look-up",N,[[["uint8x16x3_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vqtbl3q_u8","","Table look-up",N,[[["uint8x16x3_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbl3_p8","","Table look-up",N,[[["poly8x16x3_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vqtbl3q_p8","","Table look-up",N,[[["poly8x16x3_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vqtbx3_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x16x3_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbx3q_s8","","Extended table look-up",N,[[["int8x16_t"],["int8x16x3_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbx3_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x16x3_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vqtbx3q_u8","","Extended table look-up",N,[[["uint8x16_t"],["uint8x16x3_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbx3_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x16x3_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vqtbx3q_p8","","Extended table look-up",N,[[["poly8x16_t"],["poly8x16x3_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vqtbl4_s8","","Table look-up",N,[[["int8x16x4_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbl4q_s8","","Table look-up",N,[[["int8x16x4_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbl4_u8","","Table look-up",N,[[["uint8x16x4_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vqtbl4q_u8","","Table look-up",N,[[["uint8x16x4_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbl4_p8","","Table look-up",N,[[["poly8x16x4_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vqtbl4q_p8","","Table look-up",N,[[["poly8x16x4_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vqtbx4_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x16x4_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbx4q_s8","","Extended table look-up",N,[[["int8x16_t"],["int8x16x4_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbx4_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x16x4_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vqtbx4q_u8","","Extended table look-up",N,[[["uint8x16_t"],["uint8x16x4_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbx4_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x16x4_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vqtbx4q_p8","","Extended table look-up",N,[[["poly8x16_t"],["poly8x16x4_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vaeseq_u8","","AES single round encryption.",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vaesdq_u8","","AES single round decryption.",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vaesmcq_u8","","AES mix columns.",N,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vaesimcq_u8","","AES inverse mix columns.",N,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vsha1h_u32","","SHA1 fixed rotate.",N,[[["u32"]],["u32"]]],[5,"vsha1cq_u32","","SHA1 hash update accelerator, choose.",N,[[["uint32x4_t"],["u32"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1mq_u32","","SHA1 hash update accelerator, majority.",N,[[["uint32x4_t"],["u32"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1pq_u32","","SHA1 hash update accelerator, parity.",N,[[["uint32x4_t"],["u32"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1su0q_u32","","SHA1 schedule update accelerator, first part.",N,[[["uint32x4_t"],["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1su1q_u32","","SHA1 schedule update accelerator, second part.",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256hq_u32","","SHA256 hash update accelerator.",N,[[["uint32x4_t"],["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256h2q_u32","","SHA256 hash update accelerator, upper part.",N,[[["uint32x4_t"],["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256su0q_u32","","SHA256 schedule update accelerator, first part.",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256su1q_u32","","SHA256 schedule update accelerator, second part.",N,[[["uint32x4_t"],["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"__enable_irq","","Enable IRQ Interrupts",N,[[]]],[5,"__disable_irq","","Disable IRQ Interrupts",N,[[]]],[5,"__get_CONTROL","","Get Control Register",N,[[],["u32"]]],[5,"__set_CONTROL","","Set Control Register",N,[[["u32"]]]],[5,"__get_IPSR","","Get IPSR Register",N,[[],["u32"]]],[5,"__get_APSR","","Get APSR Register",N,[[],["u32"]]],[5,"__get_xPSR","","Get xPSR Register",N,[[],["u32"]]],[5,"__get_PSP","","Get Process Stack Pointer",N,[[],["u32"]]],[5,"__set_PSP","","Set Process Stack Pointer",N,[[["u32"]]]],[5,"__get_MSP","","Get Main Stack Pointer",N,[[],["u32"]]],[5,"__set_MSP","","Set Main Stack Pointer",N,[[["u32"]]]],[5,"__get_PRIMASK","","Get Priority Mask",N,[[],["u32"]]],[5,"__set_PRIMASK","","Set Priority Mask",N,[[["u32"]]]],[5,"__enable_fault_irq","","Enable FIQ",N,[[]]],[5,"__disable_fault_irq","","Disable FIQ",N,[[]]],[5,"__get_BASEPRI","","Get Base Priority",N,[[],["u32"]]],[5,"__set_BASEPRI","","Set Base Priority",N,[[["u32"]]]],[5,"__set_BASEPRI_MAX","","Set Base Priority with condition",N,[[["u32"]]]],[5,"__get_FAULTMASK","","Get Fault Mask",N,[[],["u32"]]],[5,"__set_FAULTMASK","","Set Fault Mask",N,[[["u32"]]]],[5,"__NOP","","No Operation",N,[[]]],[5,"__WFI","","Wait For Interrupt",N,[[]]],[5,"__WFE","","Wait For Event",N,[[]]],[5,"__SEV","","Send Event",N,[[]]],[5,"__ISB","","Instruction Synchronization Barrier",N,[[]]],[5,"__DSB","","Data Synchronization Barrier",N,[[]]],[5,"__DMB","","Data Memory Barrier",N,[[]]],[5,"_rev_u16","","Reverse the order of the bytes.",N,[[["u16"]],["u16"]]],[5,"_rev_u32","","Reverse the order of the bytes.",N,[[["u32"]],["u32"]]],[5,"_rev_u16","","Reverse the order of the bytes.",N,[[["u16"]],["u16"]]],[5,"_rev_u32","","Reverse the order of the bytes.",N,[[["u32"]],["u32"]]],[5,"_clz_u8","","Count Leading Zeros.",N,[[["u8"]],["u8"]]],[5,"_clz_u16","","Count Leading Zeros.",N,[[["u16"]],["u16"]]],[5,"_clz_u32","","Count Leading Zeros.",N,[[["u32"]],["u32"]]],[5,"_rbit_u32","","Reverse the bit order.",N,[[["u32"]],["u32"]]],[5,"qadd","","Signed saturating addition",N,[[["i32"],["i32"]],["i32"]]],[5,"qsub","","Signed saturating subtraction",N,[[["i32"],["i32"]],["i32"]]],[5,"qadd8","","Saturating four 8-bit integer additions",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"qsub8","","Saturating two 8-bit integer subtraction",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"qsub16","","Saturating two 16-bit integer subtraction",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qadd16","","Saturating two 16-bit integer additions",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qasx","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"qsax","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sadd16","","Returns the 16-bit signed saturated equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sadd8","","Returns the 8-bit signed saturated equivalent of",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"smlad","","Dual 16-bit Signed Multiply with Addition of products and 32-bit accumulation.",N,[[["int16x2_t"],["int16x2_t"],["i32"]],["i32"]]],[5,"smlsd","","Dual 16-bit Signed Multiply with Subtraction  of products and 32-bit accumulation and overflow detection.",N,[[["int16x2_t"],["int16x2_t"],["i32"]],["i32"]]],[5,"sasx","","Returns the 16-bit signed equivalent of",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"sel","","Select bytes from each operand according to APSR GE flags",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shadd8","","Signed halving parallel byte-wise addition.",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shadd16","","Signed halving parallel halfword-wise addition.",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"shsub8","","Signed halving parallel byte-wise subtraction.",N,[[["int8x4_t"],["int8x4_t"]],["int8x4_t"]]],[5,"shsub16","","Signed halving parallel halfword-wise subtraction.",N,[[["int16x2_t"],["int16x2_t"]],["int16x2_t"]]],[5,"smuad","","Signed Dual Multiply Add.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smuadx","","Signed Dual Multiply Add Reversed.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smusd","","Signed Dual Multiply Subtract.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"smusdx","","Signed Dual Multiply Subtract Reversed.",N,[[["int16x2_t"],["int16x2_t"]],["i32"]]],[5,"usad8","","Sum of 8-bit absolute differences.",N,[[["int8x4_t"],["int8x4_t"]],["u32"]]],[5,"usad8a","","Sum of 8-bit absolute differences and constant.",N,[[["int8x4_t"],["int8x4_t"],["u32"]],["u32"]]],[5,"vadd_s8","","Vector add.",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vaddq_s8","","Vector add.",N,[[["int8x16_t"],["int8x16_t"]],["int8x16_t"]]],[5,"vadd_s16","","Vector add.",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vaddq_s16","","Vector add.",N,[[["int16x8_t"],["int16x8_t"]],["int16x8_t"]]],[5,"vadd_s32","","Vector add.",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vaddq_s32","","Vector add.",N,[[["int32x4_t"],["int32x4_t"]],["int32x4_t"]]],[5,"vaddq_s64","","Vector add.",N,[[["int64x2_t"],["int64x2_t"]],["int64x2_t"]]],[5,"vadd_u8","","Vector add.",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vaddq_u8","","Vector add.",N,[[["uint8x16_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vadd_u16","","Vector add.",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vaddq_u16","","Vector add.",N,[[["uint16x8_t"],["uint16x8_t"]],["uint16x8_t"]]],[5,"vadd_u32","","Vector add.",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vaddq_u32","","Vector add.",N,[[["uint32x4_t"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vaddq_u64","","Vector add.",N,[[["uint64x2_t"],["uint64x2_t"]],["uint64x2_t"]]],[5,"vadd_f32","","Vector add.",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[5,"vaddq_f32","","Vector add.",N,[[["float32x4_t"],["float32x4_t"]],["float32x4_t"]]],[5,"vaddl_s8","","Vector long add.",N,[[["int8x8_t"],["int8x8_t"]],["int16x8_t"]]],[5,"vaddl_s16","","Vector long add.",N,[[["int16x4_t"],["int16x4_t"]],["int32x4_t"]]],[5,"vaddl_s32","","Vector long add.",N,[[["int32x2_t"],["int32x2_t"]],["int64x2_t"]]],[5,"vaddl_u8","","Vector long add.",N,[[["uint8x8_t"],["uint8x8_t"]],["uint16x8_t"]]],[5,"vaddl_u16","","Vector long add.",N,[[["uint16x4_t"],["uint16x4_t"]],["uint32x4_t"]]],[5,"vaddl_u32","","Vector long add.",N,[[["uint32x2_t"],["uint32x2_t"]],["uint64x2_t"]]],[5,"vmovn_s16","","Vector narrow integer.",N,[[["int16x8_t"]],["int8x8_t"]]],[5,"vmovn_s32","","Vector narrow integer.",N,[[["int32x4_t"]],["int16x4_t"]]],[5,"vmovn_s64","","Vector narrow integer.",N,[[["int64x2_t"]],["int32x2_t"]]],[5,"vmovn_u16","","Vector narrow integer.",N,[[["uint16x8_t"]],["uint8x8_t"]]],[5,"vmovn_u32","","Vector narrow integer.",N,[[["uint32x4_t"]],["uint16x4_t"]]],[5,"vmovn_u64","","Vector narrow integer.",N,[[["uint64x2_t"]],["uint32x2_t"]]],[5,"vmovl_s8","","Vector long move.",N,[[["int8x8_t"]],["int16x8_t"]]],[5,"vmovl_s16","","Vector long move.",N,[[["int16x4_t"]],["int32x4_t"]]],[5,"vmovl_s32","","Vector long move.",N,[[["int32x2_t"]],["int64x2_t"]]],[5,"vmovl_u8","","Vector long move.",N,[[["uint8x8_t"]],["uint16x8_t"]]],[5,"vmovl_u16","","Vector long move.",N,[[["uint16x4_t"]],["uint32x4_t"]]],[5,"vmovl_u32","","Vector long move.",N,[[["uint32x2_t"]],["uint64x2_t"]]],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",N,[[["float32x2_t"]],["float32x2_t"]]],[5,"vpmin_s8","","Folding minimum of adjacent pairs",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vpmin_s16","","Folding minimum of adjacent pairs",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vpmin_s32","","Folding minimum of adjacent pairs",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vpmin_u8","","Folding minimum of adjacent pairs",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmin_u16","","Folding minimum of adjacent pairs",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmin_u32","","Folding minimum of adjacent pairs",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmin_f32","","Folding minimum of adjacent pairs",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[5,"vpmax_s8","","Folding maximum of adjacent pairs",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vpmax_s16","","Folding maximum of adjacent pairs",N,[[["int16x4_t"],["int16x4_t"]],["int16x4_t"]]],[5,"vpmax_s32","","Folding maximum of adjacent pairs",N,[[["int32x2_t"],["int32x2_t"]],["int32x2_t"]]],[5,"vpmax_u8","","Folding maximum of adjacent pairs",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmax_u16","","Folding maximum of adjacent pairs",N,[[["uint16x4_t"],["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmax_u32","","Folding maximum of adjacent pairs",N,[[["uint32x2_t"],["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmax_f32","","Folding maximum of adjacent pairs",N,[[["float32x2_t"],["float32x2_t"]],["float32x2_t"]]],[5,"vtbl1_s8","","Table look-up",N,[[["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbl1_u8","","Table look-up",N,[[["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbl1_p8","","Table look-up",N,[[["poly8x8_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vtbl2_s8","","Table look-up",N,[[["int8x8x2_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbl2_u8","","Table look-up",N,[[["uint8x8x2_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbl2_p8","","Table look-up",N,[[["poly8x8x2_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbl3_s8","","Table look-up",N,[[["int8x8x3_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbl3_u8","","Table look-up",N,[[["uint8x8x3_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbl3_p8","","Table look-up",N,[[["poly8x8x3_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbl4_s8","","Table look-up",N,[[["int8x8x4_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbl4_u8","","Table look-up",N,[[["uint8x8x4_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbl4_p8","","Table look-up",N,[[["poly8x8x4_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbx1_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x8_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbx1_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x8_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbx1_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x8_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbx2_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x8x2_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbx2_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x8x2_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbx2_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x8x2_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbx3_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x8x3_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbx3_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x8x3_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbx3_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x8x3_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbx4_s8","","Extended table look-up",N,[[["int8x8_t"],["int8x8x4_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbx4_u8","","Extended table look-up",N,[[["uint8x8_t"],["uint8x8x4_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbx4_p8","","Extended table look-up",N,[[["poly8x8_t"],["poly8x8x4_t"],["uint8x8_t"]],["poly8x8_t"]]],[0,"wasm32","core::arch","Platform-specific intrinsics for the `wasm32` platform.",N,N],[0,"atomic","core::arch::wasm32","Intrinsics associated with WebAssembly's upcoming threads proposal.",N,N],[5,"wait_i32","core::arch::wasm32::atomic","Corresponding intrinsic to wasm's [`i32.atomic.wait` instruction][instr]",N,N],[5,"wait_i64","","Corresponding intrinsic to wasm's [`i64.atomic.wait` instruction][instr]",N,N],[5,"wake","","Corresponding intrinsic to wasm's [`atomic.wake` instruction][instr]",N,N],[0,"memory","core::arch::wasm32","",N,N],[5,"size","core::arch::wasm32::memory","Corresponding intrinsic to wasm's [`memory.size` instruction][instr]",N,[[["i32"]],["i32"]]],[5,"grow","","Corresponding intrinsic to wasm's [`memory.grow` instruction][instr]",N,[[["i32"],["i32"]],["i32"]]],[0,"mips","core::arch","Platform-specific intrinsics for the `mips` platform.",N,N],[3,"i8x16","core::arch::mips","MIPS-specific 128-bit wide vector of 16 packed `i8`.",N,N],[5,"__msa_add_a_b","","Vector Add Absolute Values.",N,[[["i8x16"],["i8x16"]],["i8x16"]]],[0,"mips64","core::arch","Platform-specific intrinsics for the `mips64` platform.",N,N],[3,"i8x16","core::arch::mips64","MIPS-specific 128-bit wide vector of 16 packed `i8`.",N,N],[5,"__msa_add_a_b","","Vector Add Absolute Values.",N,[[["i8x16"],["i8x16"]],["i8x16"]]],[0,"powerpc","core::arch","Platform-specific intrinsics for the `PowerPC` platform.",N,N],[3,"vector_signed_long","core::arch::powerpc","PowerPC-specific 128-bit wide vector of two packed `i64`",N,N],[3,"vector_unsigned_long","","PowerPC-specific 128-bit wide vector of two packed `u64`",N,N],[3,"vector_bool_long","","PowerPC-specific 128-bit wide vector mask of two elements",N,N],[3,"vector_double","","PowerPC-specific 128-bit wide vector of two packed `f64`",N,N],[5,"vec_xxpermdi","","Vector permute.",N,[[["t"],["t"],["u8"]],["t"]]],[0,"powerpc64","core::arch","Platform-specific intrinsics for the `PowerPC64` platform.",N,N],[3,"vector_signed_long","core::arch::powerpc64","PowerPC-specific 128-bit wide vector of two packed `i64`",N,N],[3,"vector_unsigned_long","","PowerPC-specific 128-bit wide vector of two packed `u64`",N,N],[3,"vector_bool_long","","PowerPC-specific 128-bit wide vector mask of two elements",N,N],[3,"vector_double","","PowerPC-specific 128-bit wide vector of two packed `f64`",N,N],[5,"vec_xxpermdi","","Vector permute.",N,[[["t"],["t"],["u8"]],["t"]]],[0,"nvptx","core::arch","Platform-specific intrinsics for the `NVPTX` platform.",N,N],[5,"_syncthreads","core::arch::nvptx","Synchronizes all threads in the block.",N,N],[5,"_block_dim_x","","x-th thread-block dimension.",N,[[],["i32"]]],[5,"_block_dim_y","","y-th thread-block dimension.",N,[[],["i32"]]],[5,"_block_dim_z","","z-th thread-block dimension.",N,[[],["i32"]]],[5,"_block_idx_x","","x-th thread-block index.",N,[[],["i32"]]],[5,"_block_idx_y","","y-th thread-block index.",N,[[],["i32"]]],[5,"_block_idx_z","","z-th thread-block index.",N,[[],["i32"]]],[5,"_grid_dim_x","","x-th block-grid dimension.",N,[[],["i32"]]],[5,"_grid_dim_y","","y-th block-grid dimension.",N,[[],["i32"]]],[5,"_grid_dim_z","","z-th block-grid dimension.",N,[[],["i32"]]],[5,"_thread_idx_x","","x-th thread index.",N,[[],["i32"]]],[5,"_thread_idx_y","","y-th thread index.",N,[[],["i32"]]],[5,"_thread_idx_z","","z-th thread index.",N,[[],["i32"]]],[14,"panic","core","Entry point of thread panic, for details, see std::macros",N,N],[14,"assert_eq","","Asserts that two expressions are equal to each other (using [`PartialEq`]).",N,N],[14,"assert_ne","","Asserts that two expressions are not equal to each other (using [`PartialEq`]).",N,N],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",N,N],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",N,N],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",N,N],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together with converting downstream errors.",N,N],[14,"write","","Write formatted data into a buffer.",N,N],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",N,N],[14,"unreachable","","A utility macro for indicating unreachable code.",N,N],[14,"unimplemented","","A standardized placeholder for marking unfinished code.",N,N],[14,"compile_error","","Unconditionally causes compilation to fail with the given error message when encountered.",N,N],[14,"format_args","","The core macro for formatted string creation & output.",N,N],[14,"env","","Inspect an environment variable at compile time.",N,N],[14,"option_env","","Optionally inspect an environment variable at compile time.",N,N],[14,"concat_idents","","Concatenate identifiers into one identifier.",N,N],[14,"concat","","Concatenates literals into a static string slice.",N,N],[14,"line","","A macro which expands to the line number on which it was invoked.",N,N],[14,"column","","A macro which expands to the column number on which it was invoked.",N,N],[14,"file","","A macro which expands to the file name from which it was invoked.",N,N],[14,"stringify","","A macro which stringifies its arguments.",N,N],[14,"include_str","","Includes a utf8-encoded file as a string.",N,N],[14,"include_bytes","","Includes a file as a reference to a byte array.",N,N],[14,"module_path","","Expands to a string that represents the current module path.",N,N],[14,"cfg","","Boolean evaluation of configuration flags, at compile-time.",N,N],[14,"include","","Parse a file as an expression or an item according to the context.",N,N],[14,"assert","","Ensure that a boolean expression is `true` at runtime.",N,N],[11,"into","core::num","",2,[[["self"]],["u"]]],[11,"from","","",2,[[["t"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"from","","",3,[[["t"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"from","","",4,[[["t"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"into","","",5,[[["self"]],["u"]]],[11,"from","","",5,[[["t"]],["t"]]],[11,"try_into","","",5,[[["self"]],["result"]]],[11,"try_from","","",5,[[["u"]],["result"]]],[11,"borrow","","",5,[[["self"]],["t"]]],[11,"borrow_mut","","",5,[[["self"]],["t"]]],[11,"get_type_id","","",5,[[["self"]],["typeid"]]],[11,"into","","",6,[[["self"]],["u"]]],[11,"from","","",6,[[["t"]],["t"]]],[11,"try_into","","",6,[[["self"]],["result"]]],[11,"try_from","","",6,[[["u"]],["result"]]],[11,"borrow","","",6,[[["self"]],["t"]]],[11,"borrow_mut","","",6,[[["self"]],["t"]]],[11,"get_type_id","","",6,[[["self"]],["typeid"]]],[11,"into","","",7,[[["self"]],["u"]]],[11,"from","","",7,[[["t"]],["t"]]],[11,"try_into","","",7,[[["self"]],["result"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"get_type_id","","",7,[[["self"]],["typeid"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"from","","",0,[[["t"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"into","","",173,[[["self"]],["u"]]],[11,"from","","",173,[[["t"]],["t"]]],[11,"try_into","","",173,[[["self"]],["result"]]],[11,"try_from","","",173,[[["u"]],["result"]]],[11,"borrow","","",173,[[["self"]],["t"]]],[11,"borrow_mut","","",173,[[["self"]],["t"]]],[11,"get_type_id","","",173,[[["self"]],["typeid"]]],[11,"into","","",174,[[["self"]],["u"]]],[11,"from","","",174,[[["t"]],["t"]]],[11,"try_into","","",174,[[["self"]],["result"]]],[11,"try_from","","",174,[[["u"]],["result"]]],[11,"borrow","","",174,[[["self"]],["t"]]],[11,"borrow_mut","","",174,[[["self"]],["t"]]],[11,"get_type_id","","",174,[[["self"]],["typeid"]]],[11,"into","","",175,[[["self"]],["u"]]],[11,"from","","",175,[[["t"]],["t"]]],[11,"try_into","","",175,[[["self"]],["result"]]],[11,"try_from","","",175,[[["u"]],["result"]]],[11,"borrow","","",175,[[["self"]],["t"]]],[11,"borrow_mut","","",175,[[["self"]],["t"]]],[11,"get_type_id","","",175,[[["self"]],["typeid"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"from","","",1,[[["t"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"into","core::mem","",176,[[["self"]],["u"]]],[11,"from","","",176,[[["t"]],["t"]]],[11,"try_into","","",176,[[["self"]],["result"]]],[11,"try_from","","",176,[[["u"]],["result"]]],[11,"borrow","","",176,[[["self"]],["t"]]],[11,"borrow_mut","","",176,[[["self"]],["t"]]],[11,"get_type_id","","",176,[[["self"]],["typeid"]]],[11,"into","","",8,[[["self"]],["u"]]],[11,"from","","",8,[[["t"]],["t"]]],[11,"try_into","","",8,[[["self"]],["result"]]],[11,"try_from","","",8,[[["u"]],["result"]]],[11,"borrow","","",8,[[["self"]],["t"]]],[11,"borrow_mut","","",8,[[["self"]],["t"]]],[11,"get_type_id","","",8,[[["self"]],["typeid"]]],[11,"into","","",9,[[["self"]],["u"]]],[11,"from","","",9,[[["t"]],["t"]]],[11,"try_into","","",9,[[["self"]],["result"]]],[11,"try_from","","",9,[[["u"]],["result"]]],[11,"borrow","","",9,[[["self"]],["t"]]],[11,"borrow_mut","","",9,[[["self"]],["t"]]],[11,"get_type_id","","",9,[[["self"]],["typeid"]]],[11,"into","core::ptr","",10,[[["self"]],["u"]]],[11,"from","","",10,[[["t"]],["t"]]],[11,"try_into","","",10,[[["self"]],["result"]]],[11,"try_from","","",10,[[["u"]],["result"]]],[11,"borrow","","",10,[[["self"]],["t"]]],[11,"borrow_mut","","",10,[[["self"]],["t"]]],[11,"get_type_id","","",10,[[["self"]],["typeid"]]],[11,"into","core::marker","",177,[[["self"]],["u"]]],[11,"from","","",177,[[["t"]],["t"]]],[11,"try_into","","",177,[[["self"]],["result"]]],[11,"try_from","","",177,[[["u"]],["result"]]],[11,"borrow","","",177,[[["self"]],["t"]]],[11,"borrow_mut","","",177,[[["self"]],["t"]]],[11,"get_type_id","","",177,[[["self"]],["typeid"]]],[11,"into","","",178,[[["self"]],["u"]]],[11,"from","","",178,[[["t"]],["t"]]],[11,"try_into","","",178,[[["self"]],["result"]]],[11,"try_from","","",178,[[["u"]],["result"]]],[11,"borrow","","",178,[[["self"]],["t"]]],[11,"borrow_mut","","",178,[[["self"]],["t"]]],[11,"get_type_id","","",178,[[["self"]],["typeid"]]],[11,"into","core::ops","",11,[[["self"]],["u"]]],[11,"from","","",11,[[["t"]],["t"]]],[11,"try_into","","",11,[[["self"]],["result"]]],[11,"try_from","","",11,[[["u"]],["result"]]],[11,"borrow","","",11,[[["self"]],["t"]]],[11,"borrow_mut","","",11,[[["self"]],["t"]]],[11,"get_type_id","","",11,[[["self"]],["typeid"]]],[11,"into","","",12,[[["self"]],["u"]]],[11,"from","","",12,[[["t"]],["t"]]],[11,"try_into","","",12,[[["self"]],["result"]]],[11,"try_from","","",12,[[["u"]],["result"]]],[11,"borrow","","",12,[[["self"]],["t"]]],[11,"borrow_mut","","",12,[[["self"]],["t"]]],[11,"get_type_id","","",12,[[["self"]],["typeid"]]],[11,"into","","",179,[[["self"]],["u"]]],[11,"from","","",179,[[["t"]],["t"]]],[11,"try_into","","",179,[[["self"]],["result"]]],[11,"try_from","","",179,[[["u"]],["result"]]],[11,"borrow","","",179,[[["self"]],["t"]]],[11,"borrow_mut","","",179,[[["self"]],["t"]]],[11,"get_type_id","","",179,[[["self"]],["typeid"]]],[11,"into","","",13,[[["self"]],["u"]]],[11,"from","","",13,[[["t"]],["t"]]],[11,"try_into","","",13,[[["self"]],["result"]]],[11,"try_from","","",13,[[["u"]],["result"]]],[11,"borrow","","",13,[[["self"]],["t"]]],[11,"borrow_mut","","",13,[[["self"]],["t"]]],[11,"get_type_id","","",13,[[["self"]],["typeid"]]],[11,"into","","",17,[[["self"]],["u"]]],[11,"from","","",17,[[["t"]],["t"]]],[11,"try_into","","",17,[[["self"]],["result"]]],[11,"try_from","","",17,[[["u"]],["result"]]],[11,"borrow","","",17,[[["self"]],["t"]]],[11,"borrow_mut","","",17,[[["self"]],["t"]]],[11,"get_type_id","","",17,[[["self"]],["typeid"]]],[11,"into","","",14,[[["self"]],["u"]]],[11,"from","","",14,[[["t"]],["t"]]],[11,"try_into","","",14,[[["self"]],["result"]]],[11,"try_from","","",14,[[["u"]],["result"]]],[11,"borrow","","",14,[[["self"]],["t"]]],[11,"borrow_mut","","",14,[[["self"]],["t"]]],[11,"get_type_id","","",14,[[["self"]],["typeid"]]],[11,"into","","",15,[[["self"]],["u"]]],[11,"from","","",15,[[["t"]],["t"]]],[11,"try_into","","",15,[[["self"]],["result"]]],[11,"try_from","","",15,[[["u"]],["result"]]],[11,"borrow","","",15,[[["self"]],["t"]]],[11,"borrow_mut","","",15,[[["self"]],["t"]]],[11,"get_type_id","","",15,[[["self"]],["typeid"]]],[11,"into","","",16,[[["self"]],["u"]]],[11,"from","","",16,[[["t"]],["t"]]],[11,"try_into","","",16,[[["self"]],["result"]]],[11,"try_from","","",16,[[["u"]],["result"]]],[11,"borrow","","",16,[[["self"]],["t"]]],[11,"borrow_mut","","",16,[[["self"]],["t"]]],[11,"get_type_id","","",16,[[["self"]],["typeid"]]],[11,"into","core::cmp","",51,[[["self"]],["u"]]],[11,"from","","",51,[[["t"]],["t"]]],[11,"try_into","","",51,[[["self"]],["result"]]],[11,"try_from","","",51,[[["u"]],["result"]]],[11,"borrow","","",51,[[["self"]],["t"]]],[11,"borrow_mut","","",51,[[["self"]],["t"]]],[11,"get_type_id","","",51,[[["self"]],["typeid"]]],[11,"into","","",52,[[["self"]],["u"]]],[11,"from","","",52,[[["t"]],["t"]]],[11,"try_into","","",52,[[["self"]],["result"]]],[11,"try_from","","",52,[[["u"]],["result"]]],[11,"borrow","","",52,[[["self"]],["t"]]],[11,"borrow_mut","","",52,[[["self"]],["t"]]],[11,"get_type_id","","",52,[[["self"]],["typeid"]]],[11,"into","core::any","",67,[[["self"]],["u"]]],[11,"from","","",67,[[["t"]],["t"]]],[11,"try_into","","",67,[[["self"]],["result"]]],[11,"try_from","","",67,[[["u"]],["result"]]],[11,"borrow","","",67,[[["self"]],["t"]]],[11,"borrow_mut","","",67,[[["self"]],["t"]]],[11,"get_type_id","","",67,[[["self"]],["typeid"]]],[11,"into","core::array","",180,[[["self"]],["u"]]],[11,"from","","",180,[[["t"]],["t"]]],[11,"try_into","","",180,[[["self"]],["result"]]],[11,"try_from","","",180,[[["u"]],["result"]]],[11,"borrow","","",180,[[["self"]],["t"]]],[11,"borrow_mut","","",180,[[["self"]],["t"]]],[11,"get_type_id","","",180,[[["self"]],["typeid"]]],[11,"into","core::ascii","",181,[[["self"]],["u"]]],[11,"from","","",181,[[["t"]],["t"]]],[11,"try_into","","",181,[[["self"]],["result"]]],[11,"try_from","","",181,[[["u"]],["result"]]],[11,"borrow","","",181,[[["self"]],["t"]]],[11,"borrow_mut","","",181,[[["self"]],["t"]]],[11,"get_type_id","","",181,[[["self"]],["typeid"]]],[11,"into","core::sync::atomic","",70,[[["self"]],["u"]]],[11,"from","","",70,[[["t"]],["t"]]],[11,"try_into","","",70,[[["self"]],["result"]]],[11,"try_from","","",70,[[["u"]],["result"]]],[11,"borrow","","",70,[[["self"]],["t"]]],[11,"borrow_mut","","",70,[[["self"]],["t"]]],[11,"get_type_id","","",70,[[["self"]],["typeid"]]],[11,"into","","",71,[[["self"]],["u"]]],[11,"from","","",71,[[["t"]],["t"]]],[11,"try_into","","",71,[[["self"]],["result"]]],[11,"try_from","","",71,[[["u"]],["result"]]],[11,"borrow","","",71,[[["self"]],["t"]]],[11,"borrow_mut","","",71,[[["self"]],["t"]]],[11,"get_type_id","","",71,[[["self"]],["typeid"]]],[11,"into","","",72,[[["self"]],["u"]]],[11,"from","","",72,[[["t"]],["t"]]],[11,"try_into","","",72,[[["self"]],["result"]]],[11,"try_from","","",72,[[["u"]],["result"]]],[11,"borrow","","",72,[[["self"]],["t"]]],[11,"borrow_mut","","",72,[[["self"]],["t"]]],[11,"get_type_id","","",72,[[["self"]],["typeid"]]],[11,"into","","",73,[[["self"]],["u"]]],[11,"from","","",73,[[["t"]],["t"]]],[11,"try_into","","",73,[[["self"]],["result"]]],[11,"try_from","","",73,[[["u"]],["result"]]],[11,"borrow","","",73,[[["self"]],["t"]]],[11,"borrow_mut","","",73,[[["self"]],["t"]]],[11,"get_type_id","","",73,[[["self"]],["typeid"]]],[11,"into","","",74,[[["self"]],["u"]]],[11,"from","","",74,[[["t"]],["t"]]],[11,"try_into","","",74,[[["self"]],["result"]]],[11,"try_from","","",74,[[["u"]],["result"]]],[11,"borrow","","",74,[[["self"]],["t"]]],[11,"borrow_mut","","",74,[[["self"]],["t"]]],[11,"get_type_id","","",74,[[["self"]],["typeid"]]],[11,"into","","",75,[[["self"]],["u"]]],[11,"from","","",75,[[["t"]],["t"]]],[11,"try_into","","",75,[[["self"]],["result"]]],[11,"try_from","","",75,[[["u"]],["result"]]],[11,"borrow","","",75,[[["self"]],["t"]]],[11,"borrow_mut","","",75,[[["self"]],["t"]]],[11,"get_type_id","","",75,[[["self"]],["typeid"]]],[11,"into","","",76,[[["self"]],["u"]]],[11,"from","","",76,[[["t"]],["t"]]],[11,"try_into","","",76,[[["self"]],["result"]]],[11,"try_from","","",76,[[["u"]],["result"]]],[11,"borrow","","",76,[[["self"]],["t"]]],[11,"borrow_mut","","",76,[[["self"]],["t"]]],[11,"get_type_id","","",76,[[["self"]],["typeid"]]],[11,"into","","",77,[[["self"]],["u"]]],[11,"from","","",77,[[["t"]],["t"]]],[11,"try_into","","",77,[[["self"]],["result"]]],[11,"try_from","","",77,[[["u"]],["result"]]],[11,"borrow","","",77,[[["self"]],["t"]]],[11,"borrow_mut","","",77,[[["self"]],["t"]]],[11,"get_type_id","","",77,[[["self"]],["typeid"]]],[11,"into","","",78,[[["self"]],["u"]]],[11,"from","","",78,[[["t"]],["t"]]],[11,"try_into","","",78,[[["self"]],["result"]]],[11,"try_from","","",78,[[["u"]],["result"]]],[11,"borrow","","",78,[[["self"]],["t"]]],[11,"borrow_mut","","",78,[[["self"]],["t"]]],[11,"get_type_id","","",78,[[["self"]],["typeid"]]],[11,"into","","",79,[[["self"]],["u"]]],[11,"from","","",79,[[["t"]],["t"]]],[11,"try_into","","",79,[[["self"]],["result"]]],[11,"try_from","","",79,[[["u"]],["result"]]],[11,"borrow","","",79,[[["self"]],["t"]]],[11,"borrow_mut","","",79,[[["self"]],["t"]]],[11,"get_type_id","","",79,[[["self"]],["typeid"]]],[11,"into","","",80,[[["self"]],["u"]]],[11,"from","","",80,[[["t"]],["t"]]],[11,"try_into","","",80,[[["self"]],["result"]]],[11,"try_from","","",80,[[["u"]],["result"]]],[11,"borrow","","",80,[[["self"]],["t"]]],[11,"borrow_mut","","",80,[[["self"]],["t"]]],[11,"get_type_id","","",80,[[["self"]],["typeid"]]],[11,"into","","",81,[[["self"]],["u"]]],[11,"from","","",81,[[["t"]],["t"]]],[11,"try_into","","",81,[[["self"]],["result"]]],[11,"try_from","","",81,[[["u"]],["result"]]],[11,"borrow","","",81,[[["self"]],["t"]]],[11,"borrow_mut","","",81,[[["self"]],["t"]]],[11,"get_type_id","","",81,[[["self"]],["typeid"]]],[11,"into","","",69,[[["self"]],["u"]]],[11,"from","","",69,[[["t"]],["t"]]],[11,"try_into","","",69,[[["self"]],["result"]]],[11,"try_from","","",69,[[["u"]],["result"]]],[11,"borrow","","",69,[[["self"]],["t"]]],[11,"borrow_mut","","",69,[[["self"]],["t"]]],[11,"get_type_id","","",69,[[["self"]],["typeid"]]],[11,"into","core::cell","",82,[[["self"]],["u"]]],[11,"from","","",82,[[["t"]],["t"]]],[11,"try_into","","",82,[[["self"]],["result"]]],[11,"try_from","","",82,[[["u"]],["result"]]],[11,"borrow","","",82,[[["self"]],["t"]]],[11,"borrow_mut","","",82,[[["self"]],["t"]]],[11,"get_type_id","","",82,[[["self"]],["typeid"]]],[11,"into","","",83,[[["self"]],["u"]]],[11,"from","","",83,[[["t"]],["t"]]],[11,"try_into","","",83,[[["self"]],["result"]]],[11,"try_from","","",83,[[["u"]],["result"]]],[11,"borrow","","",83,[[["self"]],["t"]]],[11,"borrow_mut","","",83,[[["self"]],["t"]]],[11,"get_type_id","","",83,[[["self"]],["typeid"]]],[11,"into","","",182,[[["self"]],["u"]]],[11,"from","","",182,[[["t"]],["t"]]],[11,"try_into","","",182,[[["self"]],["result"]]],[11,"try_from","","",182,[[["u"]],["result"]]],[11,"borrow","","",182,[[["self"]],["t"]]],[11,"borrow_mut","","",182,[[["self"]],["t"]]],[11,"get_type_id","","",182,[[["self"]],["typeid"]]],[11,"into","","",183,[[["self"]],["u"]]],[11,"from","","",183,[[["t"]],["t"]]],[11,"try_into","","",183,[[["self"]],["result"]]],[11,"try_from","","",183,[[["u"]],["result"]]],[11,"borrow","","",183,[[["self"]],["t"]]],[11,"borrow_mut","","",183,[[["self"]],["t"]]],[11,"get_type_id","","",183,[[["self"]],["typeid"]]],[11,"into","","",84,[[["self"]],["u"]]],[11,"from","","",84,[[["t"]],["t"]]],[11,"try_into","","",84,[[["self"]],["result"]]],[11,"try_from","","",84,[[["u"]],["result"]]],[11,"borrow","","",84,[[["self"]],["t"]]],[11,"borrow_mut","","",84,[[["self"]],["t"]]],[11,"get_type_id","","",84,[[["self"]],["typeid"]]],[11,"into","","",85,[[["self"]],["u"]]],[11,"from","","",85,[[["t"]],["t"]]],[11,"try_into","","",85,[[["self"]],["result"]]],[11,"try_from","","",85,[[["u"]],["result"]]],[11,"borrow","","",85,[[["self"]],["t"]]],[11,"borrow_mut","","",85,[[["self"]],["t"]]],[11,"get_type_id","","",85,[[["self"]],["typeid"]]],[11,"into","","",86,[[["self"]],["u"]]],[11,"from","","",86,[[["t"]],["t"]]],[11,"try_into","","",86,[[["self"]],["result"]]],[11,"try_from","","",86,[[["u"]],["result"]]],[11,"borrow","","",86,[[["self"]],["t"]]],[11,"borrow_mut","","",86,[[["self"]],["t"]]],[11,"get_type_id","","",86,[[["self"]],["typeid"]]],[11,"into","core::char","",184,[[["self"]],["u"]]],[11,"from","","",184,[[["t"]],["t"]]],[11,"try_into","","",184,[[["self"]],["result"]]],[11,"try_from","","",184,[[["u"]],["result"]]],[11,"borrow","","",184,[[["self"]],["t"]]],[11,"borrow_mut","","",184,[[["self"]],["t"]]],[11,"get_type_id","","",184,[[["self"]],["typeid"]]],[11,"into","","",185,[[["self"]],["u"]]],[11,"from","","",185,[[["t"]],["t"]]],[11,"try_into","","",185,[[["self"]],["result"]]],[11,"try_from","","",185,[[["u"]],["result"]]],[11,"borrow","","",185,[[["self"]],["t"]]],[11,"borrow_mut","","",185,[[["self"]],["t"]]],[11,"get_type_id","","",185,[[["self"]],["typeid"]]],[11,"into","","",186,[[["self"]],["u"]]],[11,"from","","",186,[[["t"]],["t"]]],[11,"try_into","","",186,[[["self"]],["result"]]],[11,"try_from","","",186,[[["u"]],["result"]]],[11,"borrow","","",186,[[["self"]],["t"]]],[11,"borrow_mut","","",186,[[["self"]],["t"]]],[11,"get_type_id","","",186,[[["self"]],["typeid"]]],[11,"into","","",88,[[["self"]],["u"]]],[11,"from","","",88,[[["t"]],["t"]]],[11,"try_into","","",88,[[["self"]],["result"]]],[11,"try_from","","",88,[[["u"]],["result"]]],[11,"borrow","","",88,[[["self"]],["t"]]],[11,"borrow_mut","","",88,[[["self"]],["t"]]],[11,"get_type_id","","",88,[[["self"]],["typeid"]]],[11,"into","","",87,[[["self"]],["u"]]],[11,"from","","",87,[[["t"]],["t"]]],[11,"try_into","","",87,[[["self"]],["result"]]],[11,"try_from","","",87,[[["u"]],["result"]]],[11,"borrow","","",87,[[["self"]],["t"]]],[11,"borrow_mut","","",87,[[["self"]],["t"]]],[11,"get_type_id","","",87,[[["self"]],["typeid"]]],[11,"into","","",187,[[["self"]],["u"]]],[11,"from","","",187,[[["t"]],["t"]]],[11,"try_into","","",187,[[["self"]],["result"]]],[11,"try_from","","",187,[[["u"]],["result"]]],[11,"borrow","","",187,[[["self"]],["t"]]],[11,"borrow_mut","","",187,[[["self"]],["t"]]],[11,"get_type_id","","",187,[[["self"]],["typeid"]]],[11,"into","","",188,[[["self"]],["u"]]],[11,"from","","",188,[[["t"]],["t"]]],[11,"try_into","","",188,[[["self"]],["result"]]],[11,"try_from","","",188,[[["u"]],["result"]]],[11,"borrow","","",188,[[["self"]],["t"]]],[11,"borrow_mut","","",188,[[["self"]],["t"]]],[11,"get_type_id","","",188,[[["self"]],["typeid"]]],[11,"into","","",189,[[["self"]],["u"]]],[11,"from","","",189,[[["t"]],["t"]]],[11,"try_into","","",189,[[["self"]],["result"]]],[11,"try_from","","",189,[[["u"]],["result"]]],[11,"borrow","","",189,[[["self"]],["t"]]],[11,"borrow_mut","","",189,[[["self"]],["t"]]],[11,"get_type_id","","",189,[[["self"]],["typeid"]]],[11,"into","","",190,[[["self"]],["u"]]],[11,"from","","",190,[[["t"]],["t"]]],[11,"try_into","","",190,[[["self"]],["result"]]],[11,"try_from","","",190,[[["u"]],["result"]]],[11,"borrow","","",190,[[["self"]],["t"]]],[11,"borrow_mut","","",190,[[["self"]],["t"]]],[11,"get_type_id","","",190,[[["self"]],["typeid"]]],[11,"into","","",191,[[["self"]],["u"]]],[11,"from","","",191,[[["t"]],["t"]]],[11,"try_into","","",191,[[["self"]],["result"]]],[11,"try_from","","",191,[[["u"]],["result"]]],[11,"borrow","","",191,[[["self"]],["t"]]],[11,"borrow_mut","","",191,[[["self"]],["t"]]],[11,"get_type_id","","",191,[[["self"]],["typeid"]]],[11,"into","core::panic","",89,[[["self"]],["u"]]],[11,"from","","",89,[[["t"]],["t"]]],[11,"try_into","","",89,[[["self"]],["result"]]],[11,"try_from","","",89,[[["u"]],["result"]]],[11,"borrow","","",89,[[["self"]],["t"]]],[11,"borrow_mut","","",89,[[["self"]],["t"]]],[11,"get_type_id","","",89,[[["self"]],["typeid"]]],[11,"into","","",90,[[["self"]],["u"]]],[11,"from","","",90,[[["t"]],["t"]]],[11,"try_into","","",90,[[["self"]],["result"]]],[11,"try_from","","",90,[[["u"]],["result"]]],[11,"borrow","","",90,[[["self"]],["t"]]],[11,"borrow_mut","","",90,[[["self"]],["t"]]],[11,"get_type_id","","",90,[[["self"]],["typeid"]]],[11,"into","core::pin","",91,[[["self"]],["u"]]],[11,"from","","",91,[[["t"]],["t"]]],[11,"try_into","","",91,[[["self"]],["result"]]],[11,"try_from","","",91,[[["u"]],["result"]]],[11,"borrow","","",91,[[["self"]],["t"]]],[11,"borrow_mut","","",91,[[["self"]],["t"]]],[11,"get_type_id","","",91,[[["self"]],["typeid"]]],[11,"into","core::iter","",192,[[["self"]],["u"]]],[11,"from","","",192,[[["t"]],["t"]]],[11,"try_into","","",192,[[["self"]],["result"]]],[11,"try_from","","",192,[[["u"]],["result"]]],[11,"borrow","","",192,[[["self"]],["t"]]],[11,"borrow_mut","","",192,[[["self"]],["t"]]],[11,"get_type_id","","",192,[[["self"]],["typeid"]]],[11,"into","","",193,[[["self"]],["u"]]],[11,"from","","",193,[[["t"]],["t"]]],[11,"try_into","","",193,[[["self"]],["result"]]],[11,"try_from","","",193,[[["u"]],["result"]]],[11,"borrow","","",193,[[["self"]],["t"]]],[11,"borrow_mut","","",193,[[["self"]],["t"]]],[11,"get_type_id","","",193,[[["self"]],["typeid"]]],[11,"into","","",194,[[["self"]],["u"]]],[11,"from","","",194,[[["t"]],["t"]]],[11,"try_into","","",194,[[["self"]],["result"]]],[11,"try_from","","",194,[[["u"]],["result"]]],[11,"borrow","","",194,[[["self"]],["t"]]],[11,"borrow_mut","","",194,[[["self"]],["t"]]],[11,"get_type_id","","",194,[[["self"]],["typeid"]]],[11,"into","","",195,[[["self"]],["u"]]],[11,"from","","",195,[[["t"]],["t"]]],[11,"try_into","","",195,[[["self"]],["result"]]],[11,"try_from","","",195,[[["u"]],["result"]]],[11,"borrow","","",195,[[["self"]],["t"]]],[11,"borrow_mut","","",195,[[["self"]],["t"]]],[11,"get_type_id","","",195,[[["self"]],["typeid"]]],[11,"into","","",196,[[["self"]],["u"]]],[11,"from","","",196,[[["t"]],["t"]]],[11,"try_into","","",196,[[["self"]],["result"]]],[11,"try_from","","",196,[[["u"]],["result"]]],[11,"borrow","","",196,[[["self"]],["t"]]],[11,"borrow_mut","","",196,[[["self"]],["t"]]],[11,"get_type_id","","",196,[[["self"]],["typeid"]]],[11,"into","","",197,[[["self"]],["u"]]],[11,"from","","",197,[[["t"]],["t"]]],[11,"try_into","","",197,[[["self"]],["result"]]],[11,"try_from","","",197,[[["u"]],["result"]]],[11,"borrow","","",197,[[["self"]],["t"]]],[11,"borrow_mut","","",197,[[["self"]],["t"]]],[11,"get_type_id","","",197,[[["self"]],["typeid"]]],[11,"into","","",198,[[["self"]],["u"]]],[11,"from","","",198,[[["t"]],["t"]]],[11,"try_into","","",198,[[["self"]],["result"]]],[11,"try_from","","",198,[[["u"]],["result"]]],[11,"borrow","","",198,[[["self"]],["t"]]],[11,"borrow_mut","","",198,[[["self"]],["t"]]],[11,"get_type_id","","",198,[[["self"]],["typeid"]]],[11,"into","","",199,[[["self"]],["u"]]],[11,"from","","",199,[[["t"]],["t"]]],[11,"try_into","","",199,[[["self"]],["result"]]],[11,"try_from","","",199,[[["u"]],["result"]]],[11,"borrow","","",199,[[["self"]],["t"]]],[11,"borrow_mut","","",199,[[["self"]],["t"]]],[11,"get_type_id","","",199,[[["self"]],["typeid"]]],[11,"into","","",200,[[["self"]],["u"]]],[11,"from","","",200,[[["t"]],["t"]]],[11,"try_into","","",200,[[["self"]],["result"]]],[11,"try_from","","",200,[[["u"]],["result"]]],[11,"borrow","","",200,[[["self"]],["t"]]],[11,"borrow_mut","","",200,[[["self"]],["t"]]],[11,"get_type_id","","",200,[[["self"]],["typeid"]]],[11,"into","","",201,[[["self"]],["u"]]],[11,"from","","",201,[[["t"]],["t"]]],[11,"try_into","","",201,[[["self"]],["result"]]],[11,"try_from","","",201,[[["u"]],["result"]]],[11,"borrow","","",201,[[["self"]],["t"]]],[11,"borrow_mut","","",201,[[["self"]],["t"]]],[11,"get_type_id","","",201,[[["self"]],["typeid"]]],[11,"into","","",202,[[["self"]],["u"]]],[11,"from","","",202,[[["t"]],["t"]]],[11,"try_into","","",202,[[["self"]],["result"]]],[11,"try_from","","",202,[[["u"]],["result"]]],[11,"borrow","","",202,[[["self"]],["t"]]],[11,"borrow_mut","","",202,[[["self"]],["t"]]],[11,"get_type_id","","",202,[[["self"]],["typeid"]]],[11,"into","","",203,[[["self"]],["u"]]],[11,"from","","",203,[[["t"]],["t"]]],[11,"try_into","","",203,[[["self"]],["result"]]],[11,"try_from","","",203,[[["u"]],["result"]]],[11,"borrow","","",203,[[["self"]],["t"]]],[11,"borrow_mut","","",203,[[["self"]],["t"]]],[11,"get_type_id","","",203,[[["self"]],["typeid"]]],[11,"into","","",204,[[["self"]],["u"]]],[11,"from","","",204,[[["t"]],["t"]]],[11,"try_into","","",204,[[["self"]],["result"]]],[11,"try_from","","",204,[[["u"]],["result"]]],[11,"borrow","","",204,[[["self"]],["t"]]],[11,"borrow_mut","","",204,[[["self"]],["t"]]],[11,"get_type_id","","",204,[[["self"]],["typeid"]]],[11,"into","","",205,[[["self"]],["u"]]],[11,"from","","",205,[[["t"]],["t"]]],[11,"try_into","","",205,[[["self"]],["result"]]],[11,"try_from","","",205,[[["u"]],["result"]]],[11,"borrow","","",205,[[["self"]],["t"]]],[11,"borrow_mut","","",205,[[["self"]],["t"]]],[11,"get_type_id","","",205,[[["self"]],["typeid"]]],[11,"into","","",101,[[["self"]],["u"]]],[11,"from","","",101,[[["t"]],["t"]]],[11,"try_into","","",101,[[["self"]],["result"]]],[11,"try_from","","",101,[[["u"]],["result"]]],[11,"borrow","","",101,[[["self"]],["t"]]],[11,"borrow_mut","","",101,[[["self"]],["t"]]],[11,"get_type_id","","",101,[[["self"]],["typeid"]]],[11,"into","","",206,[[["self"]],["u"]]],[11,"from","","",206,[[["t"]],["t"]]],[11,"try_into","","",206,[[["self"]],["result"]]],[11,"try_from","","",206,[[["u"]],["result"]]],[11,"borrow","","",206,[[["self"]],["t"]]],[11,"borrow_mut","","",206,[[["self"]],["t"]]],[11,"get_type_id","","",206,[[["self"]],["typeid"]]],[11,"into","","",207,[[["self"]],["u"]]],[11,"from","","",207,[[["t"]],["t"]]],[11,"try_into","","",207,[[["self"]],["result"]]],[11,"try_from","","",207,[[["u"]],["result"]]],[11,"borrow","","",207,[[["self"]],["t"]]],[11,"borrow_mut","","",207,[[["self"]],["t"]]],[11,"get_type_id","","",207,[[["self"]],["typeid"]]],[11,"into","","",208,[[["self"]],["u"]]],[11,"from","","",208,[[["t"]],["t"]]],[11,"try_into","","",208,[[["self"]],["result"]]],[11,"try_from","","",208,[[["u"]],["result"]]],[11,"borrow","","",208,[[["self"]],["t"]]],[11,"borrow_mut","","",208,[[["self"]],["t"]]],[11,"get_type_id","","",208,[[["self"]],["typeid"]]],[11,"into","","",209,[[["self"]],["u"]]],[11,"from","","",209,[[["t"]],["t"]]],[11,"try_into","","",209,[[["self"]],["result"]]],[11,"try_from","","",209,[[["u"]],["result"]]],[11,"borrow","","",209,[[["self"]],["t"]]],[11,"borrow_mut","","",209,[[["self"]],["t"]]],[11,"get_type_id","","",209,[[["self"]],["typeid"]]],[11,"into","","",210,[[["self"]],["u"]]],[11,"from","","",210,[[["t"]],["t"]]],[11,"try_into","","",210,[[["self"]],["result"]]],[11,"try_from","","",210,[[["u"]],["result"]]],[11,"borrow","","",210,[[["self"]],["t"]]],[11,"borrow_mut","","",210,[[["self"]],["t"]]],[11,"get_type_id","","",210,[[["self"]],["typeid"]]],[11,"into","","",211,[[["self"]],["u"]]],[11,"from","","",211,[[["t"]],["t"]]],[11,"try_into","","",211,[[["self"]],["result"]]],[11,"try_from","","",211,[[["u"]],["result"]]],[11,"borrow","","",211,[[["self"]],["t"]]],[11,"borrow_mut","","",211,[[["self"]],["t"]]],[11,"get_type_id","","",211,[[["self"]],["typeid"]]],[11,"into","","",212,[[["self"]],["u"]]],[11,"from","","",212,[[["t"]],["t"]]],[11,"try_into","","",212,[[["self"]],["result"]]],[11,"try_from","","",212,[[["u"]],["result"]]],[11,"borrow","","",212,[[["self"]],["t"]]],[11,"borrow_mut","","",212,[[["self"]],["t"]]],[11,"get_type_id","","",212,[[["self"]],["typeid"]]],[11,"into","","",213,[[["self"]],["u"]]],[11,"from","","",213,[[["t"]],["t"]]],[11,"try_into","","",213,[[["self"]],["result"]]],[11,"try_from","","",213,[[["u"]],["result"]]],[11,"borrow","","",213,[[["self"]],["t"]]],[11,"borrow_mut","","",213,[[["self"]],["t"]]],[11,"get_type_id","","",213,[[["self"]],["typeid"]]],[11,"into","","",214,[[["self"]],["u"]]],[11,"from","","",214,[[["t"]],["t"]]],[11,"try_into","","",214,[[["self"]],["result"]]],[11,"try_from","","",214,[[["u"]],["result"]]],[11,"borrow","","",214,[[["self"]],["t"]]],[11,"borrow_mut","","",214,[[["self"]],["t"]]],[11,"get_type_id","","",214,[[["self"]],["typeid"]]],[11,"into","core::option","",215,[[["self"]],["u"]]],[11,"from","","",215,[[["t"]],["t"]]],[11,"try_into","","",215,[[["self"]],["result"]]],[11,"try_from","","",215,[[["u"]],["result"]]],[11,"borrow","","",215,[[["self"]],["t"]]],[11,"borrow_mut","","",215,[[["self"]],["t"]]],[11,"get_type_id","","",215,[[["self"]],["typeid"]]],[11,"into","","",216,[[["self"]],["u"]]],[11,"from","","",216,[[["t"]],["t"]]],[11,"try_into","","",216,[[["self"]],["result"]]],[11,"try_from","","",216,[[["u"]],["result"]]],[11,"borrow","","",216,[[["self"]],["t"]]],[11,"borrow_mut","","",216,[[["self"]],["t"]]],[11,"get_type_id","","",216,[[["self"]],["typeid"]]],[11,"into","","",217,[[["self"]],["u"]]],[11,"from","","",217,[[["t"]],["t"]]],[11,"try_into","","",217,[[["self"]],["result"]]],[11,"try_from","","",217,[[["u"]],["result"]]],[11,"borrow","","",217,[[["self"]],["t"]]],[11,"borrow_mut","","",217,[[["self"]],["t"]]],[11,"get_type_id","","",217,[[["self"]],["typeid"]]],[11,"into","","",218,[[["self"]],["u"]]],[11,"from","","",218,[[["t"]],["t"]]],[11,"try_into","","",218,[[["self"]],["result"]]],[11,"try_from","","",218,[[["u"]],["result"]]],[11,"borrow","","",218,[[["self"]],["t"]]],[11,"borrow_mut","","",218,[[["self"]],["t"]]],[11,"get_type_id","","",218,[[["self"]],["typeid"]]],[11,"into","","",102,[[["self"]],["u"]]],[11,"from","","",102,[[["t"]],["t"]]],[11,"try_into","","",102,[[["self"]],["result"]]],[11,"try_from","","",102,[[["u"]],["result"]]],[11,"borrow","","",102,[[["self"]],["t"]]],[11,"borrow_mut","","",102,[[["self"]],["t"]]],[11,"get_type_id","","",102,[[["self"]],["typeid"]]],[11,"into","core::raw","",103,[[["self"]],["u"]]],[11,"from","","",103,[[["t"]],["t"]]],[11,"try_into","","",103,[[["self"]],["result"]]],[11,"try_from","","",103,[[["u"]],["result"]]],[11,"borrow","","",103,[[["self"]],["t"]]],[11,"borrow_mut","","",103,[[["self"]],["t"]]],[11,"get_type_id","","",103,[[["self"]],["typeid"]]],[11,"into","core::result","",219,[[["self"]],["u"]]],[11,"from","","",219,[[["t"]],["t"]]],[11,"try_into","","",219,[[["self"]],["result"]]],[11,"try_from","","",219,[[["u"]],["result"]]],[11,"borrow","","",219,[[["self"]],["t"]]],[11,"borrow_mut","","",219,[[["self"]],["t"]]],[11,"get_type_id","","",219,[[["self"]],["typeid"]]],[11,"into","","",220,[[["self"]],["u"]]],[11,"from","","",220,[[["t"]],["t"]]],[11,"try_into","","",220,[[["self"]],["result"]]],[11,"try_from","","",220,[[["u"]],["result"]]],[11,"borrow","","",220,[[["self"]],["t"]]],[11,"borrow_mut","","",220,[[["self"]],["t"]]],[11,"get_type_id","","",220,[[["self"]],["typeid"]]],[11,"into","","",221,[[["self"]],["u"]]],[11,"from","","",221,[[["t"]],["t"]]],[11,"try_into","","",221,[[["self"]],["result"]]],[11,"try_from","","",221,[[["u"]],["result"]]],[11,"borrow","","",221,[[["self"]],["t"]]],[11,"borrow_mut","","",221,[[["self"]],["t"]]],[11,"get_type_id","","",221,[[["self"]],["typeid"]]],[11,"into","","",104,[[["self"]],["u"]]],[11,"from","","",104,[[["t"]],["t"]]],[11,"try_into","","",104,[[["self"]],["result"]]],[11,"try_from","","",104,[[["u"]],["result"]]],[11,"borrow","","",104,[[["self"]],["t"]]],[11,"borrow_mut","","",104,[[["self"]],["t"]]],[11,"get_type_id","","",104,[[["self"]],["typeid"]]],[11,"into","core::ffi","",222,[[["self"]],["u"]]],[11,"from","","",222,[[["t"]],["t"]]],[11,"try_into","","",222,[[["self"]],["result"]]],[11,"try_from","","",222,[[["u"]],["result"]]],[11,"borrow","","",222,[[["self"]],["t"]]],[11,"borrow_mut","","",222,[[["self"]],["t"]]],[11,"get_type_id","","",222,[[["self"]],["typeid"]]],[11,"into","core::slice","",106,[[["self"]],["u"]]],[11,"from","","",106,[[["t"]],["t"]]],[11,"try_into","","",106,[[["self"]],["result"]]],[11,"try_from","","",106,[[["u"]],["result"]]],[11,"borrow","","",106,[[["self"]],["t"]]],[11,"borrow_mut","","",106,[[["self"]],["t"]]],[11,"get_type_id","","",106,[[["self"]],["typeid"]]],[11,"into","","",107,[[["self"]],["u"]]],[11,"from","","",107,[[["t"]],["t"]]],[11,"try_into","","",107,[[["self"]],["result"]]],[11,"try_from","","",107,[[["u"]],["result"]]],[11,"borrow","","",107,[[["self"]],["t"]]],[11,"borrow_mut","","",107,[[["self"]],["t"]]],[11,"get_type_id","","",107,[[["self"]],["typeid"]]],[11,"into","","",223,[[["self"]],["u"]]],[11,"from","","",223,[[["t"]],["t"]]],[11,"try_into","","",223,[[["self"]],["result"]]],[11,"try_from","","",223,[[["u"]],["result"]]],[11,"borrow","","",223,[[["self"]],["t"]]],[11,"borrow_mut","","",223,[[["self"]],["t"]]],[11,"get_type_id","","",223,[[["self"]],["typeid"]]],[11,"into","","",224,[[["self"]],["u"]]],[11,"from","","",224,[[["t"]],["t"]]],[11,"try_into","","",224,[[["self"]],["result"]]],[11,"try_from","","",224,[[["u"]],["result"]]],[11,"borrow","","",224,[[["self"]],["t"]]],[11,"borrow_mut","","",224,[[["self"]],["t"]]],[11,"get_type_id","","",224,[[["self"]],["typeid"]]],[11,"into","","",225,[[["self"]],["u"]]],[11,"from","","",225,[[["t"]],["t"]]],[11,"try_into","","",225,[[["self"]],["result"]]],[11,"try_from","","",225,[[["u"]],["result"]]],[11,"borrow","","",225,[[["self"]],["t"]]],[11,"borrow_mut","","",225,[[["self"]],["t"]]],[11,"get_type_id","","",225,[[["self"]],["typeid"]]],[11,"into","","",226,[[["self"]],["u"]]],[11,"from","","",226,[[["t"]],["t"]]],[11,"try_into","","",226,[[["self"]],["result"]]],[11,"try_from","","",226,[[["u"]],["result"]]],[11,"borrow","","",226,[[["self"]],["t"]]],[11,"borrow_mut","","",226,[[["self"]],["t"]]],[11,"get_type_id","","",226,[[["self"]],["typeid"]]],[11,"into","","",227,[[["self"]],["u"]]],[11,"from","","",227,[[["t"]],["t"]]],[11,"try_into","","",227,[[["self"]],["result"]]],[11,"try_from","","",227,[[["u"]],["result"]]],[11,"borrow","","",227,[[["self"]],["t"]]],[11,"borrow_mut","","",227,[[["self"]],["t"]]],[11,"get_type_id","","",227,[[["self"]],["typeid"]]],[11,"into","","",228,[[["self"]],["u"]]],[11,"from","","",228,[[["t"]],["t"]]],[11,"try_into","","",228,[[["self"]],["result"]]],[11,"try_from","","",228,[[["u"]],["result"]]],[11,"borrow","","",228,[[["self"]],["t"]]],[11,"borrow_mut","","",228,[[["self"]],["t"]]],[11,"get_type_id","","",228,[[["self"]],["typeid"]]],[11,"into","","",229,[[["self"]],["u"]]],[11,"from","","",229,[[["t"]],["t"]]],[11,"try_into","","",229,[[["self"]],["result"]]],[11,"try_from","","",229,[[["u"]],["result"]]],[11,"borrow","","",229,[[["self"]],["t"]]],[11,"borrow_mut","","",229,[[["self"]],["t"]]],[11,"get_type_id","","",229,[[["self"]],["typeid"]]],[11,"into","","",230,[[["self"]],["u"]]],[11,"from","","",230,[[["t"]],["t"]]],[11,"try_into","","",230,[[["self"]],["result"]]],[11,"try_from","","",230,[[["u"]],["result"]]],[11,"borrow","","",230,[[["self"]],["t"]]],[11,"borrow_mut","","",230,[[["self"]],["t"]]],[11,"get_type_id","","",230,[[["self"]],["typeid"]]],[11,"into","","",231,[[["self"]],["u"]]],[11,"from","","",231,[[["t"]],["t"]]],[11,"try_into","","",231,[[["self"]],["result"]]],[11,"try_from","","",231,[[["u"]],["result"]]],[11,"borrow","","",231,[[["self"]],["t"]]],[11,"borrow_mut","","",231,[[["self"]],["t"]]],[11,"get_type_id","","",231,[[["self"]],["typeid"]]],[11,"into","","",232,[[["self"]],["u"]]],[11,"from","","",232,[[["t"]],["t"]]],[11,"try_into","","",232,[[["self"]],["result"]]],[11,"try_from","","",232,[[["u"]],["result"]]],[11,"borrow","","",232,[[["self"]],["t"]]],[11,"borrow_mut","","",232,[[["self"]],["t"]]],[11,"get_type_id","","",232,[[["self"]],["typeid"]]],[11,"into","","",233,[[["self"]],["u"]]],[11,"from","","",233,[[["t"]],["t"]]],[11,"try_into","","",233,[[["self"]],["result"]]],[11,"try_from","","",233,[[["u"]],["result"]]],[11,"borrow","","",233,[[["self"]],["t"]]],[11,"borrow_mut","","",233,[[["self"]],["t"]]],[11,"get_type_id","","",233,[[["self"]],["typeid"]]],[11,"into","","",108,[[["self"]],["u"]]],[11,"from","","",108,[[["t"]],["t"]]],[11,"try_into","","",108,[[["self"]],["result"]]],[11,"try_from","","",108,[[["u"]],["result"]]],[11,"borrow","","",108,[[["self"]],["t"]]],[11,"borrow_mut","","",108,[[["self"]],["t"]]],[11,"get_type_id","","",108,[[["self"]],["typeid"]]],[11,"into","","",109,[[["self"]],["u"]]],[11,"from","","",109,[[["t"]],["t"]]],[11,"try_into","","",109,[[["self"]],["result"]]],[11,"try_from","","",109,[[["u"]],["result"]]],[11,"borrow","","",109,[[["self"]],["t"]]],[11,"borrow_mut","","",109,[[["self"]],["t"]]],[11,"get_type_id","","",109,[[["self"]],["typeid"]]],[11,"into","","",234,[[["self"]],["u"]]],[11,"from","","",234,[[["t"]],["t"]]],[11,"try_into","","",234,[[["self"]],["result"]]],[11,"try_from","","",234,[[["u"]],["result"]]],[11,"borrow","","",234,[[["self"]],["t"]]],[11,"borrow_mut","","",234,[[["self"]],["t"]]],[11,"get_type_id","","",234,[[["self"]],["typeid"]]],[11,"into","","",235,[[["self"]],["u"]]],[11,"from","","",235,[[["t"]],["t"]]],[11,"try_into","","",235,[[["self"]],["result"]]],[11,"try_from","","",235,[[["u"]],["result"]]],[11,"borrow","","",235,[[["self"]],["t"]]],[11,"borrow_mut","","",235,[[["self"]],["t"]]],[11,"get_type_id","","",235,[[["self"]],["typeid"]]],[11,"into","","",110,[[["self"]],["u"]]],[11,"from","","",110,[[["t"]],["t"]]],[11,"try_into","","",110,[[["self"]],["result"]]],[11,"try_from","","",110,[[["u"]],["result"]]],[11,"borrow","","",110,[[["self"]],["t"]]],[11,"borrow_mut","","",110,[[["self"]],["t"]]],[11,"get_type_id","","",110,[[["self"]],["typeid"]]],[11,"into","","",111,[[["self"]],["u"]]],[11,"from","","",111,[[["t"]],["t"]]],[11,"try_into","","",111,[[["self"]],["result"]]],[11,"try_from","","",111,[[["u"]],["result"]]],[11,"borrow","","",111,[[["self"]],["t"]]],[11,"borrow_mut","","",111,[[["self"]],["t"]]],[11,"get_type_id","","",111,[[["self"]],["typeid"]]],[11,"into","core::str","",236,[[["self"]],["u"]]],[11,"from","","",236,[[["t"]],["t"]]],[11,"try_into","","",236,[[["self"]],["result"]]],[11,"try_from","","",236,[[["u"]],["result"]]],[11,"borrow","","",236,[[["self"]],["t"]]],[11,"borrow_mut","","",236,[[["self"]],["t"]]],[11,"get_type_id","","",236,[[["self"]],["typeid"]]],[11,"into","","",119,[[["self"]],["u"]]],[11,"from","","",119,[[["t"]],["t"]]],[11,"try_into","","",119,[[["self"]],["result"]]],[11,"try_from","","",119,[[["u"]],["result"]]],[11,"borrow","","",119,[[["self"]],["t"]]],[11,"borrow_mut","","",119,[[["self"]],["t"]]],[11,"get_type_id","","",119,[[["self"]],["typeid"]]],[11,"into","","",120,[[["self"]],["u"]]],[11,"from","","",120,[[["t"]],["t"]]],[11,"try_into","","",120,[[["self"]],["result"]]],[11,"try_from","","",120,[[["u"]],["result"]]],[11,"borrow","","",120,[[["self"]],["t"]]],[11,"borrow_mut","","",120,[[["self"]],["t"]]],[11,"get_type_id","","",120,[[["self"]],["typeid"]]],[11,"into","","",121,[[["self"]],["u"]]],[11,"from","","",121,[[["t"]],["t"]]],[11,"try_into","","",121,[[["self"]],["result"]]],[11,"try_from","","",121,[[["u"]],["result"]]],[11,"borrow","","",121,[[["self"]],["t"]]],[11,"borrow_mut","","",121,[[["self"]],["t"]]],[11,"get_type_id","","",121,[[["self"]],["typeid"]]],[11,"into","","",237,[[["self"]],["u"]]],[11,"from","","",237,[[["t"]],["t"]]],[11,"try_into","","",237,[[["self"]],["result"]]],[11,"try_from","","",237,[[["u"]],["result"]]],[11,"borrow","","",237,[[["self"]],["t"]]],[11,"borrow_mut","","",237,[[["self"]],["t"]]],[11,"get_type_id","","",237,[[["self"]],["typeid"]]],[11,"into","","",238,[[["self"]],["u"]]],[11,"from","","",238,[[["t"]],["t"]]],[11,"try_into","","",238,[[["self"]],["result"]]],[11,"try_from","","",238,[[["u"]],["result"]]],[11,"borrow","","",238,[[["self"]],["t"]]],[11,"borrow_mut","","",238,[[["self"]],["t"]]],[11,"get_type_id","","",238,[[["self"]],["typeid"]]],[11,"into","","",239,[[["self"]],["u"]]],[11,"from","","",239,[[["t"]],["t"]]],[11,"try_into","","",239,[[["self"]],["result"]]],[11,"try_from","","",239,[[["u"]],["result"]]],[11,"borrow","","",239,[[["self"]],["t"]]],[11,"borrow_mut","","",239,[[["self"]],["t"]]],[11,"get_type_id","","",239,[[["self"]],["typeid"]]],[11,"into","","",240,[[["self"]],["u"]]],[11,"from","","",240,[[["t"]],["t"]]],[11,"try_into","","",240,[[["self"]],["result"]]],[11,"try_from","","",240,[[["u"]],["result"]]],[11,"borrow","","",240,[[["self"]],["t"]]],[11,"borrow_mut","","",240,[[["self"]],["t"]]],[11,"get_type_id","","",240,[[["self"]],["typeid"]]],[11,"into","","",241,[[["self"]],["u"]]],[11,"from","","",241,[[["t"]],["t"]]],[11,"try_into","","",241,[[["self"]],["result"]]],[11,"try_from","","",241,[[["u"]],["result"]]],[11,"borrow","","",241,[[["self"]],["t"]]],[11,"borrow_mut","","",241,[[["self"]],["t"]]],[11,"get_type_id","","",241,[[["self"]],["typeid"]]],[11,"into","","",242,[[["self"]],["u"]]],[11,"from","","",242,[[["t"]],["t"]]],[11,"try_into","","",242,[[["self"]],["result"]]],[11,"try_from","","",242,[[["u"]],["result"]]],[11,"borrow","","",242,[[["self"]],["t"]]],[11,"borrow_mut","","",242,[[["self"]],["t"]]],[11,"get_type_id","","",242,[[["self"]],["typeid"]]],[11,"into","","",243,[[["self"]],["u"]]],[11,"from","","",243,[[["t"]],["t"]]],[11,"try_into","","",243,[[["self"]],["result"]]],[11,"try_from","","",243,[[["u"]],["result"]]],[11,"borrow","","",243,[[["self"]],["t"]]],[11,"borrow_mut","","",243,[[["self"]],["t"]]],[11,"get_type_id","","",243,[[["self"]],["typeid"]]],[11,"into","","",244,[[["self"]],["u"]]],[11,"from","","",244,[[["t"]],["t"]]],[11,"try_into","","",244,[[["self"]],["result"]]],[11,"try_from","","",244,[[["u"]],["result"]]],[11,"borrow","","",244,[[["self"]],["t"]]],[11,"borrow_mut","","",244,[[["self"]],["t"]]],[11,"get_type_id","","",244,[[["self"]],["typeid"]]],[11,"into","","",245,[[["self"]],["u"]]],[11,"from","","",245,[[["t"]],["t"]]],[11,"try_into","","",245,[[["self"]],["result"]]],[11,"try_from","","",245,[[["u"]],["result"]]],[11,"borrow","","",245,[[["self"]],["t"]]],[11,"borrow_mut","","",245,[[["self"]],["t"]]],[11,"get_type_id","","",245,[[["self"]],["typeid"]]],[11,"into","","",246,[[["self"]],["u"]]],[11,"from","","",246,[[["t"]],["t"]]],[11,"try_into","","",246,[[["self"]],["result"]]],[11,"try_from","","",246,[[["u"]],["result"]]],[11,"borrow","","",246,[[["self"]],["t"]]],[11,"borrow_mut","","",246,[[["self"]],["t"]]],[11,"get_type_id","","",246,[[["self"]],["typeid"]]],[11,"into","","",247,[[["self"]],["u"]]],[11,"from","","",247,[[["t"]],["t"]]],[11,"try_into","","",247,[[["self"]],["result"]]],[11,"try_from","","",247,[[["u"]],["result"]]],[11,"borrow","","",247,[[["self"]],["t"]]],[11,"borrow_mut","","",247,[[["self"]],["t"]]],[11,"get_type_id","","",247,[[["self"]],["typeid"]]],[11,"into","","",248,[[["self"]],["u"]]],[11,"from","","",248,[[["t"]],["t"]]],[11,"try_into","","",248,[[["self"]],["result"]]],[11,"try_from","","",248,[[["u"]],["result"]]],[11,"borrow","","",248,[[["self"]],["t"]]],[11,"borrow_mut","","",248,[[["self"]],["t"]]],[11,"get_type_id","","",248,[[["self"]],["typeid"]]],[11,"into","","",249,[[["self"]],["u"]]],[11,"from","","",249,[[["t"]],["t"]]],[11,"try_into","","",249,[[["self"]],["result"]]],[11,"try_from","","",249,[[["u"]],["result"]]],[11,"borrow","","",249,[[["self"]],["t"]]],[11,"borrow_mut","","",249,[[["self"]],["t"]]],[11,"get_type_id","","",249,[[["self"]],["typeid"]]],[11,"into","","",250,[[["self"]],["u"]]],[11,"from","","",250,[[["t"]],["t"]]],[11,"try_into","","",250,[[["self"]],["result"]]],[11,"try_from","","",250,[[["u"]],["result"]]],[11,"borrow","","",250,[[["self"]],["t"]]],[11,"borrow_mut","","",250,[[["self"]],["t"]]],[11,"get_type_id","","",250,[[["self"]],["typeid"]]],[11,"into","","",251,[[["self"]],["u"]]],[11,"from","","",251,[[["t"]],["t"]]],[11,"try_into","","",251,[[["self"]],["result"]]],[11,"try_from","","",251,[[["u"]],["result"]]],[11,"borrow","","",251,[[["self"]],["t"]]],[11,"borrow_mut","","",251,[[["self"]],["t"]]],[11,"get_type_id","","",251,[[["self"]],["typeid"]]],[11,"into","","",252,[[["self"]],["u"]]],[11,"from","","",252,[[["t"]],["t"]]],[11,"try_into","","",252,[[["self"]],["result"]]],[11,"try_from","","",252,[[["u"]],["result"]]],[11,"borrow","","",252,[[["self"]],["t"]]],[11,"borrow_mut","","",252,[[["self"]],["t"]]],[11,"get_type_id","","",252,[[["self"]],["typeid"]]],[11,"into","core::str::pattern","",253,[[["self"]],["u"]]],[11,"from","","",253,[[["t"]],["t"]]],[11,"try_into","","",253,[[["self"]],["result"]]],[11,"try_from","","",253,[[["u"]],["result"]]],[11,"borrow","","",253,[[["self"]],["t"]]],[11,"borrow_mut","","",253,[[["self"]],["t"]]],[11,"get_type_id","","",253,[[["self"]],["typeid"]]],[11,"into","","",254,[[["self"]],["u"]]],[11,"from","","",254,[[["t"]],["t"]]],[11,"try_into","","",254,[[["self"]],["result"]]],[11,"try_from","","",254,[[["u"]],["result"]]],[11,"borrow","","",254,[[["self"]],["t"]]],[11,"borrow_mut","","",254,[[["self"]],["t"]]],[11,"get_type_id","","",254,[[["self"]],["typeid"]]],[11,"into","","",255,[[["self"]],["u"]]],[11,"from","","",255,[[["t"]],["t"]]],[11,"try_into","","",255,[[["self"]],["result"]]],[11,"try_from","","",255,[[["u"]],["result"]]],[11,"borrow","","",255,[[["self"]],["t"]]],[11,"borrow_mut","","",255,[[["self"]],["t"]]],[11,"get_type_id","","",255,[[["self"]],["typeid"]]],[11,"into","","",256,[[["self"]],["u"]]],[11,"from","","",256,[[["t"]],["t"]]],[11,"try_into","","",256,[[["self"]],["result"]]],[11,"try_from","","",256,[[["u"]],["result"]]],[11,"borrow","","",256,[[["self"]],["t"]]],[11,"borrow_mut","","",256,[[["self"]],["t"]]],[11,"get_type_id","","",256,[[["self"]],["typeid"]]],[11,"into","","",112,[[["self"]],["u"]]],[11,"from","","",112,[[["t"]],["t"]]],[11,"try_into","","",112,[[["self"]],["result"]]],[11,"try_from","","",112,[[["u"]],["result"]]],[11,"borrow","","",112,[[["self"]],["t"]]],[11,"borrow_mut","","",112,[[["self"]],["t"]]],[11,"get_type_id","","",112,[[["self"]],["typeid"]]],[11,"borrow","core::str::lossy","",117,[[["self"]],["t"]]],[11,"borrow_mut","","",117,[[["self"]],["t"]]],[11,"get_type_id","","",117,[[["self"]],["typeid"]]],[11,"into","","",257,[[["self"]],["u"]]],[11,"from","","",257,[[["t"]],["t"]]],[11,"try_into","","",257,[[["self"]],["result"]]],[11,"try_from","","",257,[[["u"]],["result"]]],[11,"borrow","","",257,[[["self"]],["t"]]],[11,"borrow_mut","","",257,[[["self"]],["t"]]],[11,"get_type_id","","",257,[[["self"]],["typeid"]]],[11,"into","","",116,[[["self"]],["u"]]],[11,"from","","",116,[[["t"]],["t"]]],[11,"try_into","","",116,[[["self"]],["result"]]],[11,"try_from","","",116,[[["u"]],["result"]]],[11,"borrow","","",116,[[["self"]],["t"]]],[11,"borrow_mut","","",116,[[["self"]],["t"]]],[11,"get_type_id","","",116,[[["self"]],["typeid"]]],[11,"into","core::hash","",122,[[["self"]],["u"]]],[11,"from","","",122,[[["t"]],["t"]]],[11,"try_into","","",122,[[["self"]],["result"]]],[11,"try_from","","",122,[[["u"]],["result"]]],[11,"borrow","","",122,[[["self"]],["t"]]],[11,"borrow_mut","","",122,[[["self"]],["t"]]],[11,"get_type_id","","",122,[[["self"]],["typeid"]]],[11,"into","","",258,[[["self"]],["u"]]],[11,"from","","",258,[[["t"]],["t"]]],[11,"try_into","","",258,[[["self"]],["result"]]],[11,"try_from","","",258,[[["u"]],["result"]]],[11,"borrow","","",258,[[["self"]],["t"]]],[11,"borrow_mut","","",258,[[["self"]],["t"]]],[11,"get_type_id","","",258,[[["self"]],["typeid"]]],[11,"into","core::fmt","",127,[[["self"]],["u"]]],[11,"from","","",127,[[["t"]],["t"]]],[11,"try_into","","",127,[[["self"]],["result"]]],[11,"try_from","","",127,[[["u"]],["result"]]],[11,"borrow","","",127,[[["self"]],["t"]]],[11,"borrow_mut","","",127,[[["self"]],["t"]]],[11,"get_type_id","","",127,[[["self"]],["typeid"]]],[11,"into","","",128,[[["self"]],["u"]]],[11,"from","","",128,[[["t"]],["t"]]],[11,"try_into","","",128,[[["self"]],["result"]]],[11,"try_from","","",128,[[["u"]],["result"]]],[11,"borrow","","",128,[[["self"]],["t"]]],[11,"borrow_mut","","",128,[[["self"]],["t"]]],[11,"get_type_id","","",128,[[["self"]],["typeid"]]],[11,"into","","",129,[[["self"]],["u"]]],[11,"from","","",129,[[["t"]],["t"]]],[11,"try_into","","",129,[[["self"]],["result"]]],[11,"try_from","","",129,[[["u"]],["result"]]],[11,"borrow","","",129,[[["self"]],["t"]]],[11,"borrow_mut","","",129,[[["self"]],["t"]]],[11,"get_type_id","","",129,[[["self"]],["typeid"]]],[11,"into","","",130,[[["self"]],["u"]]],[11,"from","","",130,[[["t"]],["t"]]],[11,"try_into","","",130,[[["self"]],["result"]]],[11,"try_from","","",130,[[["u"]],["result"]]],[11,"borrow","","",130,[[["self"]],["t"]]],[11,"borrow_mut","","",130,[[["self"]],["t"]]],[11,"get_type_id","","",130,[[["self"]],["typeid"]]],[11,"into","","",131,[[["self"]],["u"]]],[11,"from","","",131,[[["t"]],["t"]]],[11,"try_into","","",131,[[["self"]],["result"]]],[11,"try_from","","",131,[[["u"]],["result"]]],[11,"borrow","","",131,[[["self"]],["t"]]],[11,"borrow_mut","","",131,[[["self"]],["t"]]],[11,"get_type_id","","",131,[[["self"]],["typeid"]]],[11,"into","","",259,[[["self"]],["u"]]],[11,"from","","",259,[[["t"]],["t"]]],[11,"try_into","","",259,[[["self"]],["result"]]],[11,"try_from","","",259,[[["u"]],["result"]]],[11,"borrow","","",259,[[["self"]],["t"]]],[11,"borrow_mut","","",259,[[["self"]],["t"]]],[11,"get_type_id","","",259,[[["self"]],["typeid"]]],[11,"into","","",142,[[["self"]],["u"]]],[11,"from","","",142,[[["t"]],["t"]]],[11,"try_into","","",142,[[["self"]],["result"]]],[11,"try_from","","",142,[[["u"]],["result"]]],[11,"borrow","","",142,[[["self"]],["t"]]],[11,"borrow_mut","","",142,[[["self"]],["t"]]],[11,"get_type_id","","",142,[[["self"]],["typeid"]]],[11,"into","","",260,[[["self"]],["u"]]],[11,"from","","",260,[[["t"]],["t"]]],[11,"try_into","","",260,[[["self"]],["result"]]],[11,"try_from","","",260,[[["u"]],["result"]]],[11,"borrow","","",260,[[["self"]],["t"]]],[11,"borrow_mut","","",260,[[["self"]],["t"]]],[11,"get_type_id","","",260,[[["self"]],["typeid"]]],[11,"into","","",126,[[["self"]],["u"]]],[11,"from","","",126,[[["t"]],["t"]]],[11,"try_into","","",126,[[["self"]],["result"]]],[11,"try_from","","",126,[[["u"]],["result"]]],[11,"borrow","","",126,[[["self"]],["t"]]],[11,"borrow_mut","","",126,[[["self"]],["t"]]],[11,"get_type_id","","",126,[[["self"]],["typeid"]]],[11,"into","core::time","",143,[[["self"]],["u"]]],[11,"from","","",143,[[["t"]],["t"]]],[11,"try_into","","",143,[[["self"]],["result"]]],[11,"try_from","","",143,[[["u"]],["result"]]],[11,"borrow","","",143,[[["self"]],["t"]]],[11,"borrow_mut","","",143,[[["self"]],["t"]]],[11,"get_type_id","","",143,[[["self"]],["typeid"]]],[11,"into","core::task","",146,[[["self"]],["u"]]],[11,"from","","",146,[[["t"]],["t"]]],[11,"try_into","","",146,[[["self"]],["result"]]],[11,"try_from","","",146,[[["u"]],["result"]]],[11,"borrow","","",146,[[["self"]],["t"]]],[11,"borrow_mut","","",146,[[["self"]],["t"]]],[11,"get_type_id","","",146,[[["self"]],["typeid"]]],[11,"into","","",147,[[["self"]],["u"]]],[11,"from","","",147,[[["t"]],["t"]]],[11,"try_into","","",147,[[["self"]],["result"]]],[11,"try_from","","",147,[[["u"]],["result"]]],[11,"borrow","","",147,[[["self"]],["t"]]],[11,"borrow_mut","","",147,[[["self"]],["t"]]],[11,"get_type_id","","",147,[[["self"]],["typeid"]]],[11,"into","","",145,[[["self"]],["u"]]],[11,"from","","",145,[[["t"]],["t"]]],[11,"try_into","","",145,[[["self"]],["result"]]],[11,"try_from","","",145,[[["u"]],["result"]]],[11,"borrow","","",145,[[["self"]],["t"]]],[11,"borrow_mut","","",145,[[["self"]],["t"]]],[11,"get_type_id","","",145,[[["self"]],["typeid"]]],[11,"into","core::alloc","",149,[[["self"]],["u"]]],[11,"from","","",149,[[["t"]],["t"]]],[11,"try_into","","",149,[[["self"]],["result"]]],[11,"try_from","","",149,[[["u"]],["result"]]],[11,"borrow","","",149,[[["self"]],["t"]]],[11,"borrow_mut","","",149,[[["self"]],["t"]]],[11,"get_type_id","","",149,[[["self"]],["typeid"]]],[11,"into","","",152,[[["self"]],["u"]]],[11,"from","","",152,[[["t"]],["t"]]],[11,"try_into","","",152,[[["self"]],["result"]]],[11,"try_from","","",152,[[["u"]],["result"]]],[11,"borrow","","",152,[[["self"]],["t"]]],[11,"borrow_mut","","",152,[[["self"]],["t"]]],[11,"get_type_id","","",152,[[["self"]],["typeid"]]],[11,"into","","",261,[[["self"]],["u"]]],[11,"from","","",261,[[["t"]],["t"]]],[11,"try_into","","",261,[[["self"]],["result"]]],[11,"try_from","","",261,[[["u"]],["result"]]],[11,"borrow","","",261,[[["self"]],["t"]]],[11,"borrow_mut","","",261,[[["self"]],["t"]]],[11,"get_type_id","","",261,[[["self"]],["typeid"]]],[11,"into","","",262,[[["self"]],["u"]]],[11,"from","","",262,[[["t"]],["t"]]],[11,"try_into","","",262,[[["self"]],["result"]]],[11,"try_from","","",262,[[["u"]],["result"]]],[11,"borrow","","",262,[[["self"]],["t"]]],[11,"borrow_mut","","",262,[[["self"]],["t"]]],[11,"get_type_id","","",262,[[["self"]],["typeid"]]],[11,"into","","",153,[[["self"]],["u"]]],[11,"from","","",153,[[["t"]],["t"]]],[11,"try_into","","",153,[[["self"]],["result"]]],[11,"try_from","","",153,[[["u"]],["result"]]],[11,"borrow","","",153,[[["self"]],["t"]]],[11,"borrow_mut","","",153,[[["self"]],["t"]]],[11,"get_type_id","","",153,[[["self"]],["typeid"]]],[11,"into","core::arch::x86","",263,[[["self"]],["u"]]],[11,"from","","",263,[[["t"]],["t"]]],[11,"try_into","","",263,[[["self"]],["result"]]],[11,"try_from","","",263,[[["u"]],["result"]]],[11,"borrow","","",263,[[["self"]],["t"]]],[11,"borrow_mut","","",263,[[["self"]],["t"]]],[11,"get_type_id","","",263,[[["self"]],["typeid"]]],[11,"into","","",264,[[["self"]],["u"]]],[11,"from","","",264,[[["t"]],["t"]]],[11,"try_into","","",264,[[["self"]],["result"]]],[11,"try_from","","",264,[[["u"]],["result"]]],[11,"borrow","","",264,[[["self"]],["t"]]],[11,"borrow_mut","","",264,[[["self"]],["t"]]],[11,"get_type_id","","",264,[[["self"]],["typeid"]]],[11,"into","","",265,[[["self"]],["u"]]],[11,"from","","",265,[[["t"]],["t"]]],[11,"try_into","","",265,[[["self"]],["result"]]],[11,"try_from","","",265,[[["u"]],["result"]]],[11,"borrow","","",265,[[["self"]],["t"]]],[11,"borrow_mut","","",265,[[["self"]],["t"]]],[11,"get_type_id","","",265,[[["self"]],["typeid"]]],[11,"into","","",266,[[["self"]],["u"]]],[11,"from","","",266,[[["t"]],["t"]]],[11,"try_into","","",266,[[["self"]],["result"]]],[11,"try_from","","",266,[[["u"]],["result"]]],[11,"borrow","","",266,[[["self"]],["t"]]],[11,"borrow_mut","","",266,[[["self"]],["t"]]],[11,"get_type_id","","",266,[[["self"]],["typeid"]]],[11,"into","","",267,[[["self"]],["u"]]],[11,"from","","",267,[[["t"]],["t"]]],[11,"try_into","","",267,[[["self"]],["result"]]],[11,"try_from","","",267,[[["u"]],["result"]]],[11,"borrow","","",267,[[["self"]],["t"]]],[11,"borrow_mut","","",267,[[["self"]],["t"]]],[11,"get_type_id","","",267,[[["self"]],["typeid"]]],[11,"into","","",268,[[["self"]],["u"]]],[11,"from","","",268,[[["t"]],["t"]]],[11,"try_into","","",268,[[["self"]],["result"]]],[11,"try_from","","",268,[[["u"]],["result"]]],[11,"borrow","","",268,[[["self"]],["t"]]],[11,"borrow_mut","","",268,[[["self"]],["t"]]],[11,"get_type_id","","",268,[[["self"]],["typeid"]]],[11,"into","","",269,[[["self"]],["u"]]],[11,"from","","",269,[[["t"]],["t"]]],[11,"try_into","","",269,[[["self"]],["result"]]],[11,"try_from","","",269,[[["u"]],["result"]]],[11,"borrow","","",269,[[["self"]],["t"]]],[11,"borrow_mut","","",269,[[["self"]],["t"]]],[11,"get_type_id","","",269,[[["self"]],["typeid"]]],[11,"into","","",154,[[["self"]],["u"]]],[11,"from","","",154,[[["t"]],["t"]]],[11,"try_into","","",154,[[["self"]],["result"]]],[11,"try_from","","",154,[[["u"]],["result"]]],[11,"borrow","","",154,[[["self"]],["t"]]],[11,"borrow_mut","","",154,[[["self"]],["t"]]],[11,"get_type_id","","",154,[[["self"]],["typeid"]]],[11,"into","core::arch::aarch64","",270,[[["self"]],["u"]]],[11,"from","","",270,[[["t"]],["t"]]],[11,"try_into","","",270,[[["self"]],["result"]]],[11,"try_from","","",270,[[["u"]],["result"]]],[11,"borrow","","",270,[[["self"]],["t"]]],[11,"borrow_mut","","",270,[[["self"]],["t"]]],[11,"get_type_id","","",270,[[["self"]],["typeid"]]],[11,"into","","",271,[[["self"]],["u"]]],[11,"from","","",271,[[["t"]],["t"]]],[11,"try_into","","",271,[[["self"]],["result"]]],[11,"try_from","","",271,[[["u"]],["result"]]],[11,"borrow","","",271,[[["self"]],["t"]]],[11,"borrow_mut","","",271,[[["self"]],["t"]]],[11,"get_type_id","","",271,[[["self"]],["typeid"]]],[11,"into","","",272,[[["self"]],["u"]]],[11,"from","","",272,[[["t"]],["t"]]],[11,"try_into","","",272,[[["self"]],["result"]]],[11,"try_from","","",272,[[["u"]],["result"]]],[11,"borrow","","",272,[[["self"]],["t"]]],[11,"borrow_mut","","",272,[[["self"]],["t"]]],[11,"get_type_id","","",272,[[["self"]],["typeid"]]],[11,"into","","",273,[[["self"]],["u"]]],[11,"from","","",273,[[["t"]],["t"]]],[11,"try_into","","",273,[[["self"]],["result"]]],[11,"try_from","","",273,[[["u"]],["result"]]],[11,"borrow","","",273,[[["self"]],["t"]]],[11,"borrow_mut","","",273,[[["self"]],["t"]]],[11,"get_type_id","","",273,[[["self"]],["typeid"]]],[11,"into","","",164,[[["self"]],["u"]]],[11,"from","","",164,[[["t"]],["t"]]],[11,"try_into","","",164,[[["self"]],["result"]]],[11,"try_from","","",164,[[["u"]],["result"]]],[11,"borrow","","",164,[[["self"]],["t"]]],[11,"borrow_mut","","",164,[[["self"]],["t"]]],[11,"get_type_id","","",164,[[["self"]],["typeid"]]],[11,"into","","",165,[[["self"]],["u"]]],[11,"from","","",165,[[["t"]],["t"]]],[11,"try_into","","",165,[[["self"]],["result"]]],[11,"try_from","","",165,[[["u"]],["result"]]],[11,"borrow","","",165,[[["self"]],["t"]]],[11,"borrow_mut","","",165,[[["self"]],["t"]]],[11,"get_type_id","","",165,[[["self"]],["typeid"]]],[11,"into","","",166,[[["self"]],["u"]]],[11,"from","","",166,[[["t"]],["t"]]],[11,"try_into","","",166,[[["self"]],["result"]]],[11,"try_from","","",166,[[["u"]],["result"]]],[11,"borrow","","",166,[[["self"]],["t"]]],[11,"borrow_mut","","",166,[[["self"]],["t"]]],[11,"get_type_id","","",166,[[["self"]],["typeid"]]],[11,"into","","",167,[[["self"]],["u"]]],[11,"from","","",167,[[["t"]],["t"]]],[11,"try_into","","",167,[[["self"]],["result"]]],[11,"try_from","","",167,[[["u"]],["result"]]],[11,"borrow","","",167,[[["self"]],["t"]]],[11,"borrow_mut","","",167,[[["self"]],["t"]]],[11,"get_type_id","","",167,[[["self"]],["typeid"]]],[11,"into","","",168,[[["self"]],["u"]]],[11,"from","","",168,[[["t"]],["t"]]],[11,"try_into","","",168,[[["self"]],["result"]]],[11,"try_from","","",168,[[["u"]],["result"]]],[11,"borrow","","",168,[[["self"]],["t"]]],[11,"borrow_mut","","",168,[[["self"]],["t"]]],[11,"get_type_id","","",168,[[["self"]],["typeid"]]],[11,"into","","",169,[[["self"]],["u"]]],[11,"from","","",169,[[["t"]],["t"]]],[11,"try_into","","",169,[[["self"]],["result"]]],[11,"try_from","","",169,[[["u"]],["result"]]],[11,"borrow","","",169,[[["self"]],["t"]]],[11,"borrow_mut","","",169,[[["self"]],["t"]]],[11,"get_type_id","","",169,[[["self"]],["typeid"]]],[11,"into","","",170,[[["self"]],["u"]]],[11,"from","","",170,[[["t"]],["t"]]],[11,"try_into","","",170,[[["self"]],["result"]]],[11,"try_from","","",170,[[["u"]],["result"]]],[11,"borrow","","",170,[[["self"]],["t"]]],[11,"borrow_mut","","",170,[[["self"]],["t"]]],[11,"get_type_id","","",170,[[["self"]],["typeid"]]],[11,"into","","",171,[[["self"]],["u"]]],[11,"from","","",171,[[["t"]],["t"]]],[11,"try_into","","",171,[[["self"]],["result"]]],[11,"try_from","","",171,[[["u"]],["result"]]],[11,"borrow","","",171,[[["self"]],["t"]]],[11,"borrow_mut","","",171,[[["self"]],["t"]]],[11,"get_type_id","","",171,[[["self"]],["typeid"]]],[11,"into","","",172,[[["self"]],["u"]]],[11,"from","","",172,[[["t"]],["t"]]],[11,"try_into","","",172,[[["self"]],["result"]]],[11,"try_from","","",172,[[["u"]],["result"]]],[11,"borrow","","",172,[[["self"]],["t"]]],[11,"borrow_mut","","",172,[[["self"]],["t"]]],[11,"get_type_id","","",172,[[["self"]],["typeid"]]],[11,"into","core::arch::arm","",274,[[["self"]],["u"]]],[11,"from","","",274,[[["t"]],["t"]]],[11,"try_into","","",274,[[["self"]],["result"]]],[11,"try_from","","",274,[[["u"]],["result"]]],[11,"borrow","","",274,[[["self"]],["t"]]],[11,"borrow_mut","","",274,[[["self"]],["t"]]],[11,"get_type_id","","",274,[[["self"]],["typeid"]]],[11,"into","","",275,[[["self"]],["u"]]],[11,"from","","",275,[[["t"]],["t"]]],[11,"try_into","","",275,[[["self"]],["result"]]],[11,"try_from","","",275,[[["u"]],["result"]]],[11,"borrow","","",275,[[["self"]],["t"]]],[11,"borrow_mut","","",275,[[["self"]],["t"]]],[11,"get_type_id","","",275,[[["self"]],["typeid"]]],[11,"into","","",276,[[["self"]],["u"]]],[11,"from","","",276,[[["t"]],["t"]]],[11,"try_into","","",276,[[["self"]],["result"]]],[11,"try_from","","",276,[[["u"]],["result"]]],[11,"borrow","","",276,[[["self"]],["t"]]],[11,"borrow_mut","","",276,[[["self"]],["t"]]],[11,"get_type_id","","",276,[[["self"]],["typeid"]]],[11,"into","","",277,[[["self"]],["u"]]],[11,"from","","",277,[[["t"]],["t"]]],[11,"try_into","","",277,[[["self"]],["result"]]],[11,"try_from","","",277,[[["u"]],["result"]]],[11,"borrow","","",277,[[["self"]],["t"]]],[11,"borrow_mut","","",277,[[["self"]],["t"]]],[11,"get_type_id","","",277,[[["self"]],["typeid"]]],[11,"into","","",278,[[["self"]],["u"]]],[11,"from","","",278,[[["t"]],["t"]]],[11,"try_into","","",278,[[["self"]],["result"]]],[11,"try_from","","",278,[[["u"]],["result"]]],[11,"borrow","","",278,[[["self"]],["t"]]],[11,"borrow_mut","","",278,[[["self"]],["t"]]],[11,"get_type_id","","",278,[[["self"]],["typeid"]]],[11,"into","","",279,[[["self"]],["u"]]],[11,"from","","",279,[[["t"]],["t"]]],[11,"try_into","","",279,[[["self"]],["result"]]],[11,"try_from","","",279,[[["u"]],["result"]]],[11,"borrow","","",279,[[["self"]],["t"]]],[11,"borrow_mut","","",279,[[["self"]],["t"]]],[11,"get_type_id","","",279,[[["self"]],["typeid"]]],[11,"into","","",280,[[["self"]],["u"]]],[11,"from","","",280,[[["t"]],["t"]]],[11,"try_into","","",280,[[["self"]],["result"]]],[11,"try_from","","",280,[[["u"]],["result"]]],[11,"borrow","","",280,[[["self"]],["t"]]],[11,"borrow_mut","","",280,[[["self"]],["t"]]],[11,"get_type_id","","",280,[[["self"]],["typeid"]]],[11,"into","","",281,[[["self"]],["u"]]],[11,"from","","",281,[[["t"]],["t"]]],[11,"try_into","","",281,[[["self"]],["result"]]],[11,"try_from","","",281,[[["u"]],["result"]]],[11,"borrow","","",281,[[["self"]],["t"]]],[11,"borrow_mut","","",281,[[["self"]],["t"]]],[11,"get_type_id","","",281,[[["self"]],["typeid"]]],[11,"into","","",282,[[["self"]],["u"]]],[11,"from","","",282,[[["t"]],["t"]]],[11,"try_into","","",282,[[["self"]],["result"]]],[11,"try_from","","",282,[[["u"]],["result"]]],[11,"borrow","","",282,[[["self"]],["t"]]],[11,"borrow_mut","","",282,[[["self"]],["t"]]],[11,"get_type_id","","",282,[[["self"]],["typeid"]]],[11,"into","","",283,[[["self"]],["u"]]],[11,"from","","",283,[[["t"]],["t"]]],[11,"try_into","","",283,[[["self"]],["result"]]],[11,"try_from","","",283,[[["u"]],["result"]]],[11,"borrow","","",283,[[["self"]],["t"]]],[11,"borrow_mut","","",283,[[["self"]],["t"]]],[11,"get_type_id","","",283,[[["self"]],["typeid"]]],[11,"into","","",284,[[["self"]],["u"]]],[11,"from","","",284,[[["t"]],["t"]]],[11,"try_into","","",284,[[["self"]],["result"]]],[11,"try_from","","",284,[[["u"]],["result"]]],[11,"borrow","","",284,[[["self"]],["t"]]],[11,"borrow_mut","","",284,[[["self"]],["t"]]],[11,"get_type_id","","",284,[[["self"]],["typeid"]]],[11,"into","","",285,[[["self"]],["u"]]],[11,"from","","",285,[[["t"]],["t"]]],[11,"try_into","","",285,[[["self"]],["result"]]],[11,"try_from","","",285,[[["u"]],["result"]]],[11,"borrow","","",285,[[["self"]],["t"]]],[11,"borrow_mut","","",285,[[["self"]],["t"]]],[11,"get_type_id","","",285,[[["self"]],["typeid"]]],[11,"into","","",286,[[["self"]],["u"]]],[11,"from","","",286,[[["t"]],["t"]]],[11,"try_into","","",286,[[["self"]],["result"]]],[11,"try_from","","",286,[[["u"]],["result"]]],[11,"borrow","","",286,[[["self"]],["t"]]],[11,"borrow_mut","","",286,[[["self"]],["t"]]],[11,"get_type_id","","",286,[[["self"]],["typeid"]]],[11,"into","","",287,[[["self"]],["u"]]],[11,"from","","",287,[[["t"]],["t"]]],[11,"try_into","","",287,[[["self"]],["result"]]],[11,"try_from","","",287,[[["u"]],["result"]]],[11,"borrow","","",287,[[["self"]],["t"]]],[11,"borrow_mut","","",287,[[["self"]],["t"]]],[11,"get_type_id","","",287,[[["self"]],["typeid"]]],[11,"into","","",288,[[["self"]],["u"]]],[11,"from","","",288,[[["t"]],["t"]]],[11,"try_into","","",288,[[["self"]],["result"]]],[11,"try_from","","",288,[[["u"]],["result"]]],[11,"borrow","","",288,[[["self"]],["t"]]],[11,"borrow_mut","","",288,[[["self"]],["t"]]],[11,"get_type_id","","",288,[[["self"]],["typeid"]]],[11,"into","","",289,[[["self"]],["u"]]],[11,"from","","",289,[[["t"]],["t"]]],[11,"try_into","","",289,[[["self"]],["result"]]],[11,"try_from","","",289,[[["u"]],["result"]]],[11,"borrow","","",289,[[["self"]],["t"]]],[11,"borrow_mut","","",289,[[["self"]],["t"]]],[11,"get_type_id","","",289,[[["self"]],["typeid"]]],[11,"into","","",290,[[["self"]],["u"]]],[11,"from","","",290,[[["t"]],["t"]]],[11,"try_into","","",290,[[["self"]],["result"]]],[11,"try_from","","",290,[[["u"]],["result"]]],[11,"borrow","","",290,[[["self"]],["t"]]],[11,"borrow_mut","","",290,[[["self"]],["t"]]],[11,"get_type_id","","",290,[[["self"]],["typeid"]]],[11,"into","","",291,[[["self"]],["u"]]],[11,"from","","",291,[[["t"]],["t"]]],[11,"try_into","","",291,[[["self"]],["result"]]],[11,"try_from","","",291,[[["u"]],["result"]]],[11,"borrow","","",291,[[["self"]],["t"]]],[11,"borrow_mut","","",291,[[["self"]],["t"]]],[11,"get_type_id","","",291,[[["self"]],["typeid"]]],[11,"into","","",292,[[["self"]],["u"]]],[11,"from","","",292,[[["t"]],["t"]]],[11,"try_into","","",292,[[["self"]],["result"]]],[11,"try_from","","",292,[[["u"]],["result"]]],[11,"borrow","","",292,[[["self"]],["t"]]],[11,"borrow_mut","","",292,[[["self"]],["t"]]],[11,"get_type_id","","",292,[[["self"]],["typeid"]]],[11,"into","","",293,[[["self"]],["u"]]],[11,"from","","",293,[[["t"]],["t"]]],[11,"try_into","","",293,[[["self"]],["result"]]],[11,"try_from","","",293,[[["u"]],["result"]]],[11,"borrow","","",293,[[["self"]],["t"]]],[11,"borrow_mut","","",293,[[["self"]],["t"]]],[11,"get_type_id","","",293,[[["self"]],["typeid"]]],[11,"into","","",294,[[["self"]],["u"]]],[11,"from","","",294,[[["t"]],["t"]]],[11,"try_into","","",294,[[["self"]],["result"]]],[11,"try_from","","",294,[[["u"]],["result"]]],[11,"borrow","","",294,[[["self"]],["t"]]],[11,"borrow_mut","","",294,[[["self"]],["t"]]],[11,"get_type_id","","",294,[[["self"]],["typeid"]]],[11,"into","","",295,[[["self"]],["u"]]],[11,"from","","",295,[[["t"]],["t"]]],[11,"try_into","","",295,[[["self"]],["result"]]],[11,"try_from","","",295,[[["u"]],["result"]]],[11,"borrow","","",295,[[["self"]],["t"]]],[11,"borrow_mut","","",295,[[["self"]],["t"]]],[11,"get_type_id","","",295,[[["self"]],["typeid"]]],[11,"into","","",296,[[["self"]],["u"]]],[11,"from","","",296,[[["t"]],["t"]]],[11,"try_into","","",296,[[["self"]],["result"]]],[11,"try_from","","",296,[[["u"]],["result"]]],[11,"borrow","","",296,[[["self"]],["t"]]],[11,"borrow_mut","","",296,[[["self"]],["t"]]],[11,"get_type_id","","",296,[[["self"]],["typeid"]]],[11,"into","","",297,[[["self"]],["u"]]],[11,"from","","",297,[[["t"]],["t"]]],[11,"try_into","","",297,[[["self"]],["result"]]],[11,"try_from","","",297,[[["u"]],["result"]]],[11,"borrow","","",297,[[["self"]],["t"]]],[11,"borrow_mut","","",297,[[["self"]],["t"]]],[11,"get_type_id","","",297,[[["self"]],["typeid"]]],[11,"into","","",298,[[["self"]],["u"]]],[11,"from","","",298,[[["t"]],["t"]]],[11,"try_into","","",298,[[["self"]],["result"]]],[11,"try_from","","",298,[[["u"]],["result"]]],[11,"borrow","","",298,[[["self"]],["t"]]],[11,"borrow_mut","","",298,[[["self"]],["t"]]],[11,"get_type_id","","",298,[[["self"]],["typeid"]]],[11,"into","","",299,[[["self"]],["u"]]],[11,"from","","",299,[[["t"]],["t"]]],[11,"try_into","","",299,[[["self"]],["result"]]],[11,"try_from","","",299,[[["u"]],["result"]]],[11,"borrow","","",299,[[["self"]],["t"]]],[11,"borrow_mut","","",299,[[["self"]],["t"]]],[11,"get_type_id","","",299,[[["self"]],["typeid"]]],[11,"into","","",155,[[["self"]],["u"]]],[11,"from","","",155,[[["t"]],["t"]]],[11,"try_into","","",155,[[["self"]],["result"]]],[11,"try_from","","",155,[[["u"]],["result"]]],[11,"borrow","","",155,[[["self"]],["t"]]],[11,"borrow_mut","","",155,[[["self"]],["t"]]],[11,"get_type_id","","",155,[[["self"]],["typeid"]]],[11,"into","","",156,[[["self"]],["u"]]],[11,"from","","",156,[[["t"]],["t"]]],[11,"try_into","","",156,[[["self"]],["result"]]],[11,"try_from","","",156,[[["u"]],["result"]]],[11,"borrow","","",156,[[["self"]],["t"]]],[11,"borrow_mut","","",156,[[["self"]],["t"]]],[11,"get_type_id","","",156,[[["self"]],["typeid"]]],[11,"into","","",157,[[["self"]],["u"]]],[11,"from","","",157,[[["t"]],["t"]]],[11,"try_into","","",157,[[["self"]],["result"]]],[11,"try_from","","",157,[[["u"]],["result"]]],[11,"borrow","","",157,[[["self"]],["t"]]],[11,"borrow_mut","","",157,[[["self"]],["t"]]],[11,"get_type_id","","",157,[[["self"]],["typeid"]]],[11,"into","","",158,[[["self"]],["u"]]],[11,"from","","",158,[[["t"]],["t"]]],[11,"try_into","","",158,[[["self"]],["result"]]],[11,"try_from","","",158,[[["u"]],["result"]]],[11,"borrow","","",158,[[["self"]],["t"]]],[11,"borrow_mut","","",158,[[["self"]],["t"]]],[11,"get_type_id","","",158,[[["self"]],["typeid"]]],[11,"into","","",159,[[["self"]],["u"]]],[11,"from","","",159,[[["t"]],["t"]]],[11,"try_into","","",159,[[["self"]],["result"]]],[11,"try_from","","",159,[[["u"]],["result"]]],[11,"borrow","","",159,[[["self"]],["t"]]],[11,"borrow_mut","","",159,[[["self"]],["t"]]],[11,"get_type_id","","",159,[[["self"]],["typeid"]]],[11,"into","","",160,[[["self"]],["u"]]],[11,"from","","",160,[[["t"]],["t"]]],[11,"try_into","","",160,[[["self"]],["result"]]],[11,"try_from","","",160,[[["u"]],["result"]]],[11,"borrow","","",160,[[["self"]],["t"]]],[11,"borrow_mut","","",160,[[["self"]],["t"]]],[11,"get_type_id","","",160,[[["self"]],["typeid"]]],[11,"into","","",161,[[["self"]],["u"]]],[11,"from","","",161,[[["t"]],["t"]]],[11,"try_into","","",161,[[["self"]],["result"]]],[11,"try_from","","",161,[[["u"]],["result"]]],[11,"borrow","","",161,[[["self"]],["t"]]],[11,"borrow_mut","","",161,[[["self"]],["t"]]],[11,"get_type_id","","",161,[[["self"]],["typeid"]]],[11,"into","","",162,[[["self"]],["u"]]],[11,"from","","",162,[[["t"]],["t"]]],[11,"try_into","","",162,[[["self"]],["result"]]],[11,"try_from","","",162,[[["u"]],["result"]]],[11,"borrow","","",162,[[["self"]],["t"]]],[11,"borrow_mut","","",162,[[["self"]],["t"]]],[11,"get_type_id","","",162,[[["self"]],["typeid"]]],[11,"into","","",163,[[["self"]],["u"]]],[11,"from","","",163,[[["t"]],["t"]]],[11,"try_into","","",163,[[["self"]],["result"]]],[11,"try_from","","",163,[[["u"]],["result"]]],[11,"borrow","","",163,[[["self"]],["t"]]],[11,"borrow_mut","","",163,[[["self"]],["t"]]],[11,"get_type_id","","",163,[[["self"]],["typeid"]]],[11,"into","core::arch::mips","",300,[[["self"]],["u"]]],[11,"from","","",300,[[["t"]],["t"]]],[11,"try_into","","",300,[[["self"]],["result"]]],[11,"try_from","","",300,[[["u"]],["result"]]],[11,"borrow","","",300,[[["self"]],["t"]]],[11,"borrow_mut","","",300,[[["self"]],["t"]]],[11,"get_type_id","","",300,[[["self"]],["typeid"]]],[11,"into","core::arch::powerpc","",301,[[["self"]],["u"]]],[11,"from","","",301,[[["t"]],["t"]]],[11,"try_into","","",301,[[["self"]],["result"]]],[11,"try_from","","",301,[[["u"]],["result"]]],[11,"borrow","","",301,[[["self"]],["t"]]],[11,"borrow_mut","","",301,[[["self"]],["t"]]],[11,"get_type_id","","",301,[[["self"]],["typeid"]]],[11,"into","","",302,[[["self"]],["u"]]],[11,"from","","",302,[[["t"]],["t"]]],[11,"try_into","","",302,[[["self"]],["result"]]],[11,"try_from","","",302,[[["u"]],["result"]]],[11,"borrow","","",302,[[["self"]],["t"]]],[11,"borrow_mut","","",302,[[["self"]],["t"]]],[11,"get_type_id","","",302,[[["self"]],["typeid"]]],[11,"into","","",303,[[["self"]],["u"]]],[11,"from","","",303,[[["t"]],["t"]]],[11,"try_into","","",303,[[["self"]],["result"]]],[11,"try_from","","",303,[[["u"]],["result"]]],[11,"borrow","","",303,[[["self"]],["t"]]],[11,"borrow_mut","","",303,[[["self"]],["t"]]],[11,"get_type_id","","",303,[[["self"]],["typeid"]]],[11,"into","","",304,[[["self"]],["u"]]],[11,"from","","",304,[[["t"]],["t"]]],[11,"try_into","","",304,[[["self"]],["result"]]],[11,"try_from","","",304,[[["u"]],["result"]]],[11,"borrow","","",304,[[["self"]],["t"]]],[11,"borrow_mut","","",304,[[["self"]],["t"]]],[11,"get_type_id","","",304,[[["self"]],["typeid"]]],[11,"add","core::num","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"add","","",0,N],[11,"add","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"add","","",0,N],[11,"add","core::time","",143,[[["self"],["duration"]],["duration"]]],[11,"sub","core::num","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"sub","","",0,N],[11,"sub","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"sub","","",0,N],[11,"sub","core::time","",143,[[["self"],["duration"]],["duration"]]],[11,"mul","core::num","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"mul","","",0,N],[11,"mul","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"mul","","",0,N],[11,"mul","core::time","",143,[[["self"],["u32"]],["duration"]]],[11,"div","core::num","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"div","","",0,N],[11,"div","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"div","","",0,N],[11,"div","core::time","",143,[[["self"],["u32"]],["duration"]]],[11,"rem","core::num","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"rem","","",0,N],[11,"rem","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"rem","","",0,N],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"neg","","",0,[[["self"]],["self"]]],[11,"add_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","core::time","",143,[[["self"],["duration"]]]],[11,"sub_assign","core::num","",0,[[["self"],["wrapping",["usize"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","core::time","",143,[[["self"],["duration"]]]],[11,"mul_assign","core::num","",0,[[["self"],["wrapping",["usize"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","core::time","",143,[[["self"],["u32"]]]],[11,"div_assign","core::num","",0,[[["self"],["wrapping",["usize"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","core::time","",143,[[["self"],["u32"]]]],[11,"rem_assign","core::num","",0,[[["self"],["wrapping",["usize"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[["self"]],["wrapping",["usize"]]]],[11,"not","","",0,[[["self"]],["wrapping",["u8"]]]],[11,"not","","",0,[[["self"]],["wrapping",["u16"]]]],[11,"not","","",0,[[["self"]],["wrapping",["u32"]]]],[11,"not","","",0,[[["self"]],["wrapping",["u64"]]]],[11,"not","","",0,[[["self"]],["wrapping",["u128"]]]],[11,"not","","",0,[[["self"]],["wrapping",["isize"]]]],[11,"not","","",0,[[["self"]],["wrapping",["i8"]]]],[11,"not","","",0,[[["self"]],["wrapping",["i16"]]]],[11,"not","","",0,[[["self"]],["wrapping",["i32"]]]],[11,"not","","",0,[[["self"]],["wrapping",["i64"]]]],[11,"not","","",0,[[["self"]],["wrapping",["i128"]]]],[11,"bitand","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"bitand","","",0,N],[11,"bitand","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"bitand","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"bitor","","",0,N],[11,"bitor","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"bitor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["usize"]]],["wrapping",["usize"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["u8"]]],["wrapping",["u8"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["u16"]]],["wrapping",["u16"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["u32"]]],["wrapping",["u32"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["u64"]]],["wrapping",["u64"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["u128"]]],["wrapping",["u128"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["isize"]]],["wrapping",["isize"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["i8"]]],["wrapping",["i8"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["i16"]]],["wrapping",["i16"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["i32"]]],["wrapping",["i32"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["i64"]]],["wrapping",["i64"]]]],[11,"bitxor","","",0,N],[11,"bitxor","","",0,[[["self"],["wrapping",["i128"]]],["wrapping",["i128"]]]],[11,"bitxor","","",0,N],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["u8"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["u16"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["u32"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["u64"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["u128"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["usize"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["i8"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["i16"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["i32"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["i64"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["i128"]]]],[11,"shl","","",0,[[["self"],["usize"]],["wrapping",["isize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["u8"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["u16"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["u32"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["u64"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["u128"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["usize"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["i8"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["i16"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["i32"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["i64"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["i128"]]]],[11,"shr","","",0,[[["self"],["usize"]],["wrapping",["isize"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["usize"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u8"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u16"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u32"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u64"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u128"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["isize"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i8"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i16"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i32"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i64"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i128"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"deref","core::mem","",8,N],[11,"deref","core::cell","",84,[[["self"]],["t"]]],[11,"deref","","",85,[[["self"]],["t"]]],[11,"deref","core::pin","",91,N],[11,"deref_mut","core::mem","",8,N],[11,"deref_mut","core::cell","",85,[[["self"]],["t"]]],[11,"deref_mut","core::pin","",91,N],[11,"drop","core::task","",146,[[["self"]]]],[11,"start_bound","core::ops","",179,[[["self"]],["bound"]]],[11,"end_bound","","",179,[[["self"]],["bound"]]],[11,"start_bound","","",12,[[["self"]],["bound"]]],[11,"end_bound","","",12,[[["self"]],["bound"]]],[11,"start_bound","","",13,[[["self"]],["bound"]]],[11,"end_bound","","",13,[[["self"]],["bound"]]],[11,"start_bound","","",11,[[["self"]],["bound"]]],[11,"end_bound","","",11,[[["self"]],["bound"]]],[11,"start_bound","","",17,[[["self"]],["bound"]]],[11,"end_bound","","",17,[[["self"]],["bound"]]],[11,"start_bound","","",14,[[["self"]],["bound"]]],[11,"end_bound","","",14,[[["self"]],["bound"]]],[11,"start_bound","","",12,[[["self"]],["bound"]]],[11,"end_bound","","",12,[[["self"]],["bound"]]],[11,"start_bound","","",13,[[["self"]],["bound"]]],[11,"end_bound","","",13,[[["self"]],["bound"]]],[11,"start_bound","","",11,[[["self"]],["bound"]]],[11,"end_bound","","",11,[[["self"]],["bound"]]],[11,"start_bound","","",17,[[["self"]],["bound"]]],[11,"end_bound","","",17,[[["self"]],["bound"]]],[11,"start_bound","","",14,[[["self"]],["bound"]]],[11,"end_bound","","",14,[[["self"]],["bound"]]],[11,"into_result","core::option","",102,[[["self"]],["result",["noneerror"]]]],[11,"from_ok","","",102,[[["t"]],["self"]]],[11,"from_error","","",102,[[["noneerror"]],["self"]]],[11,"into_result","core::result","",104,[[["self"]],["self"]]],[11,"from_ok","","",104,[[["t"]],["self"]]],[11,"from_error","","",104,[[["e"]],["self"]]],[11,"into_result","core::task","",145,[[["self"]],["result"]]],[11,"from_error","","",145,N],[11,"from_ok","","",145,N],[11,"into_result","","",145,[[["self"]],["result"]]],[11,"from_error","","",145,N],[11,"from_ok","","",145,N],[11,"eq","core::num","",2,[[["self"],["nonzerou8"]],["bool"]]],[11,"ne","","",2,[[["self"],["nonzerou8"]],["bool"]]],[11,"eq","","",3,[[["self"],["nonzerou16"]],["bool"]]],[11,"ne","","",3,[[["self"],["nonzerou16"]],["bool"]]],[11,"eq","","",4,[[["self"],["nonzerou32"]],["bool"]]],[11,"ne","","",4,[[["self"],["nonzerou32"]],["bool"]]],[11,"eq","","",5,[[["self"],["nonzerou64"]],["bool"]]],[11,"ne","","",5,[[["self"],["nonzerou64"]],["bool"]]],[11,"eq","","",6,[[["self"],["nonzerou128"]],["bool"]]],[11,"ne","","",6,[[["self"],["nonzerou128"]],["bool"]]],[11,"eq","","",7,[[["self"],["nonzerousize"]],["bool"]]],[11,"ne","","",7,[[["self"],["nonzerousize"]],["bool"]]],[11,"eq","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"ne","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"eq","","",175,[[["self"],["parsefloaterror"]],["bool"]]],[11,"ne","","",175,[[["self"],["parsefloaterror"]],["bool"]]],[11,"eq","","",1,[[["self"],["fpcategory"]],["bool"]]],[11,"eq","","",173,[[["self"],["tryfrominterror"]],["bool"]]],[11,"ne","","",173,[[["self"],["tryfrominterror"]],["bool"]]],[11,"eq","","",174,[[["self"],["parseinterror"]],["bool"]]],[11,"ne","","",174,[[["self"],["parseinterror"]],["bool"]]],[11,"eq","core::mem","",176,[[["self"],["self"]],["bool"]]],[11,"eq","","",8,[[["self"],["manuallydrop"]],["bool"]]],[11,"ne","","",8,[[["self"],["manuallydrop"]],["bool"]]],[11,"eq","core::ptr","",10,[[["self"],["self"]],["bool"]]],[11,"eq","core::marker","",177,[[["self"],["phantomdata"]],["bool"]]],[11,"eq","","",178,[[["self"],["pinned"]],["bool"]]],[11,"eq","core::ops","",16,[[["self"],["generatorstate"]],["bool"]]],[11,"ne","","",16,[[["self"],["generatorstate"]],["bool"]]],[11,"eq","","",179,[[["self"],["rangefull"]],["bool"]]],[11,"eq","","",11,[[["self"],["range"]],["bool"]]],[11,"ne","","",11,[[["self"],["range"]],["bool"]]],[11,"eq","","",12,[[["self"],["rangefrom"]],["bool"]]],[11,"ne","","",12,[[["self"],["rangefrom"]],["bool"]]],[11,"eq","","",13,[[["self"],["rangeto"]],["bool"]]],[11,"ne","","",13,[[["self"],["rangeto"]],["bool"]]],[11,"eq","","",17,[[["self"],["self"]],["bool"]]],[11,"eq","","",14,[[["self"],["rangetoinclusive"]],["bool"]]],[11,"ne","","",14,[[["self"],["rangetoinclusive"]],["bool"]]],[11,"eq","","",15,[[["self"],["bound"]],["bool"]]],[11,"ne","","",15,[[["self"],["bound"]],["bool"]]],[11,"eq","core::cmp","",52,[[["self"],["ordering"]],["bool"]]],[11,"eq","","",51,[[["self"],["reverse"]],["bool"]]],[11,"ne","","",51,[[["self"],["reverse"]],["bool"]]],[11,"eq","core::any","",67,[[["self"],["typeid"]],["bool"]]],[11,"ne","","",67,[[["self"],["typeid"]],["bool"]]],[11,"eq","core::cell","",82,[[["self"],["cell"]],["bool"]]],[11,"eq","","Panics",83,[[["self"],["refcell"]],["bool"]]],[11,"eq","core::char","",184,[[["self"],["parsecharerror"]],["bool"]]],[11,"ne","","",184,[[["self"],["parsecharerror"]],["bool"]]],[11,"eq","","",185,[[["self"],["chartryfromerror"]],["bool"]]],[11,"ne","","",185,[[["self"],["chartryfromerror"]],["bool"]]],[11,"eq","","",88,[[["self"],["decodeutf16error"]],["bool"]]],[11,"ne","","",88,[[["self"],["decodeutf16error"]],["bool"]]],[11,"eq","core::pin","",91,[[["self"],["pin"]],["bool"]]],[11,"ne","","",91,[[["self"],["pin"]],["bool"]]],[11,"eq","core::option","",102,[[["self"],["option"]],["bool"]]],[11,"ne","","",102,[[["self"],["option"]],["bool"]]],[11,"eq","","",218,[[["self"],["noneerror"]],["bool"]]],[11,"eq","core::result","",104,[[["self"],["result"]],["bool"]]],[11,"ne","","",104,[[["self"],["result"]],["bool"]]],[11,"eq","core::str::pattern","",112,[[["self"],["searchstep"]],["bool"]]],[11,"ne","","",112,[[["self"],["searchstep"]],["bool"]]],[11,"eq","core::str::lossy","",116,[[["self"],["utf8lossychunk"]],["bool"]]],[11,"ne","","",116,[[["self"],["utf8lossychunk"]],["bool"]]],[11,"eq","core::str","",236,[[["self"],["parseboolerror"]],["bool"]]],[11,"ne","","",236,[[["self"],["parseboolerror"]],["bool"]]],[11,"eq","","",119,[[["self"],["utf8error"]],["bool"]]],[11,"ne","","",119,[[["self"],["utf8error"]],["bool"]]],[11,"eq","core::hash","",258,[[["self"],["buildhasherdefault"]],["bool"]]],[11,"eq","core::fmt","",259,[[["self"],["error"]],["bool"]]],[11,"eq","core::time","",143,[[["self"],["duration"]],["bool"]]],[11,"ne","","",143,[[["self"],["duration"]],["bool"]]],[11,"eq","core::char","",87,[[["self"],["unicodeversion"]],["bool"]]],[11,"ne","","",87,[[["self"],["unicodeversion"]],["bool"]]],[11,"eq","core::task","",145,[[["self"],["poll"]],["bool"]]],[11,"ne","","",145,[[["self"],["poll"]],["bool"]]],[11,"eq","core::alloc","",152,[[["self"],["layout"]],["bool"]]],[11,"ne","","",152,[[["self"],["layout"]],["bool"]]],[11,"eq","","",261,[[["self"],["layouterr"]],["bool"]]],[11,"ne","","",261,[[["self"],["layouterr"]],["bool"]]],[11,"eq","","",262,[[["self"],["allocerr"]],["bool"]]],[11,"eq","","",153,[[["self"],["cannotreallocinplace"]],["bool"]]],[11,"eq","core::arch::x86","",154,[[["self"],["cpuidresult"]],["bool"]]],[11,"ne","","",154,[[["self"],["cpuidresult"]],["bool"]]],[11,"cmp","core::num","",2,[[["self"],["nonzerou8"]],["ordering"]]],[11,"cmp","","",3,[[["self"],["nonzerou16"]],["ordering"]]],[11,"cmp","","",4,[[["self"],["nonzerou32"]],["ordering"]]],[11,"cmp","","",5,[[["self"],["nonzerou64"]],["ordering"]]],[11,"cmp","","",6,[[["self"],["nonzerou128"]],["ordering"]]],[11,"cmp","","",7,[[["self"],["nonzerousize"]],["ordering"]]],[11,"cmp","","",0,[[["self"],["wrapping"]],["ordering"]]],[11,"cmp","core::mem","",8,[[["self"],["manuallydrop"]],["ordering"]]],[11,"cmp","core::ptr","",10,[[["self"],["self"]],["ordering"]]],[11,"cmp","core::marker","",177,[[["self"],["phantomdata"]],["ordering"]]],[11,"cmp","","",178,[[["self"],["pinned"]],["ordering"]]],[11,"cmp","core::ops","",16,[[["self"],["generatorstate"]],["ordering"]]],[11,"cmp","core::cmp","",51,[[["self"],["reverse"]],["ordering"]]],[11,"cmp","","",52,[[["self"],["ordering"]],["ordering"]]],[11,"cmp","core::any","",67,[[["self"],["typeid"]],["ordering"]]],[11,"cmp","core::cell","",82,[[["self"],["cell"]],["ordering"]]],[11,"cmp","","Panics",83,[[["self"],["refcell"]],["ordering"]]],[11,"cmp","core::pin","",91,[[["self"],["pin"]],["ordering"]]],[11,"cmp","core::option","",102,[[["self"],["option"]],["ordering"]]],[11,"cmp","","",218,[[["self"],["noneerror"]],["ordering"]]],[11,"cmp","core::result","",104,[[["self"],["result"]],["ordering"]]],[11,"cmp","core::fmt","",259,[[["self"],["error"]],["ordering"]]],[11,"cmp","core::time","",143,[[["self"],["duration"]],["ordering"]]],[11,"cmp","core::char","",87,[[["self"],["unicodeversion"]],["ordering"]]],[11,"cmp","core::task","",145,[[["self"],["poll"]],["ordering"]]],[11,"cmp","core::arch::x86","",154,[[["self"],["cpuidresult"]],["ordering"]]],[11,"partial_cmp","core::num","",2,[[["self"],["nonzerou8"]],["option",["ordering"]]]],[11,"lt","","",2,[[["self"],["nonzerou8"]],["bool"]]],[11,"le","","",2,[[["self"],["nonzerou8"]],["bool"]]],[11,"gt","","",2,[[["self"],["nonzerou8"]],["bool"]]],[11,"ge","","",2,[[["self"],["nonzerou8"]],["bool"]]],[11,"partial_cmp","","",3,[[["self"],["nonzerou16"]],["option",["ordering"]]]],[11,"lt","","",3,[[["self"],["nonzerou16"]],["bool"]]],[11,"le","","",3,[[["self"],["nonzerou16"]],["bool"]]],[11,"gt","","",3,[[["self"],["nonzerou16"]],["bool"]]],[11,"ge","","",3,[[["self"],["nonzerou16"]],["bool"]]],[11,"partial_cmp","","",4,[[["self"],["nonzerou32"]],["option",["ordering"]]]],[11,"lt","","",4,[[["self"],["nonzerou32"]],["bool"]]],[11,"le","","",4,[[["self"],["nonzerou32"]],["bool"]]],[11,"gt","","",4,[[["self"],["nonzerou32"]],["bool"]]],[11,"ge","","",4,[[["self"],["nonzerou32"]],["bool"]]],[11,"partial_cmp","","",5,[[["self"],["nonzerou64"]],["option",["ordering"]]]],[11,"lt","","",5,[[["self"],["nonzerou64"]],["bool"]]],[11,"le","","",5,[[["self"],["nonzerou64"]],["bool"]]],[11,"gt","","",5,[[["self"],["nonzerou64"]],["bool"]]],[11,"ge","","",5,[[["self"],["nonzerou64"]],["bool"]]],[11,"partial_cmp","","",6,[[["self"],["nonzerou128"]],["option",["ordering"]]]],[11,"lt","","",6,[[["self"],["nonzerou128"]],["bool"]]],[11,"le","","",6,[[["self"],["nonzerou128"]],["bool"]]],[11,"gt","","",6,[[["self"],["nonzerou128"]],["bool"]]],[11,"ge","","",6,[[["self"],["nonzerou128"]],["bool"]]],[11,"partial_cmp","","",7,[[["self"],["nonzerousize"]],["option",["ordering"]]]],[11,"lt","","",7,[[["self"],["nonzerousize"]],["bool"]]],[11,"le","","",7,[[["self"],["nonzerousize"]],["bool"]]],[11,"gt","","",7,[[["self"],["nonzerousize"]],["bool"]]],[11,"ge","","",7,[[["self"],["nonzerousize"]],["bool"]]],[11,"partial_cmp","","",0,[[["self"],["wrapping"]],["option",["ordering"]]]],[11,"lt","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"le","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"gt","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"ge","","",0,[[["self"],["wrapping"]],["bool"]]],[11,"partial_cmp","core::mem","",8,[[["self"],["manuallydrop"]],["option",["ordering"]]]],[11,"lt","","",8,[[["self"],["manuallydrop"]],["bool"]]],[11,"le","","",8,[[["self"],["manuallydrop"]],["bool"]]],[11,"gt","","",8,[[["self"],["manuallydrop"]],["bool"]]],[11,"ge","","",8,[[["self"],["manuallydrop"]],["bool"]]],[11,"partial_cmp","core::ptr","",10,[[["self"],["self"]],["option",["ordering"]]]],[11,"partial_cmp","core::marker","",177,[[["self"],["phantomdata"]],["option",["ordering"]]]],[11,"partial_cmp","","",178,[[["self"],["pinned"]],["option",["ordering"]]]],[11,"partial_cmp","core::ops","",16,[[["self"],["generatorstate"]],["option",["ordering"]]]],[11,"lt","","",16,[[["self"],["generatorstate"]],["bool"]]],[11,"le","","",16,[[["self"],["generatorstate"]],["bool"]]],[11,"gt","","",16,[[["self"],["generatorstate"]],["bool"]]],[11,"ge","","",16,[[["self"],["generatorstate"]],["bool"]]],[11,"partial_cmp","core::cmp","",51,[[["self"],["reverse"]],["option",["ordering"]]]],[11,"lt","","",51,[[["self"],["self"]],["bool"]]],[11,"le","","",51,[[["self"],["self"]],["bool"]]],[11,"ge","","",51,[[["self"],["self"]],["bool"]]],[11,"gt","","",51,[[["self"],["self"]],["bool"]]],[11,"partial_cmp","","",52,[[["self"],["ordering"]],["option",["ordering"]]]],[11,"partial_cmp","core::any","",67,[[["self"],["typeid"]],["option",["ordering"]]]],[11,"lt","","",67,[[["self"],["typeid"]],["bool"]]],[11,"le","","",67,[[["self"],["typeid"]],["bool"]]],[11,"gt","","",67,[[["self"],["typeid"]],["bool"]]],[11,"ge","","",67,[[["self"],["typeid"]],["bool"]]],[11,"partial_cmp","core::cell","",82,[[["self"],["cell"]],["option",["ordering"]]]],[11,"lt","","",82,[[["self"],["cell"]],["bool"]]],[11,"le","","",82,[[["self"],["cell"]],["bool"]]],[11,"gt","","",82,[[["self"],["cell"]],["bool"]]],[11,"ge","","",82,[[["self"],["cell"]],["bool"]]],[11,"partial_cmp","","Panics",83,[[["self"],["refcell"]],["option",["ordering"]]]],[11,"lt","","Panics",83,[[["self"],["refcell"]],["bool"]]],[11,"le","","Panics",83,[[["self"],["refcell"]],["bool"]]],[11,"gt","","Panics",83,[[["self"],["refcell"]],["bool"]]],[11,"ge","","Panics",83,[[["self"],["refcell"]],["bool"]]],[11,"partial_cmp","core::pin","",91,[[["self"],["pin"]],["option",["ordering"]]]],[11,"lt","","",91,[[["self"],["pin"]],["bool"]]],[11,"le","","",91,[[["self"],["pin"]],["bool"]]],[11,"gt","","",91,[[["self"],["pin"]],["bool"]]],[11,"ge","","",91,[[["self"],["pin"]],["bool"]]],[11,"partial_cmp","core::option","",102,[[["self"],["option"]],["option",["ordering"]]]],[11,"lt","","",102,[[["self"],["option"]],["bool"]]],[11,"le","","",102,[[["self"],["option"]],["bool"]]],[11,"gt","","",102,[[["self"],["option"]],["bool"]]],[11,"ge","","",102,[[["self"],["option"]],["bool"]]],[11,"partial_cmp","","",218,[[["self"],["noneerror"]],["option",["ordering"]]]],[11,"partial_cmp","core::result","",104,[[["self"],["result"]],["option",["ordering"]]]],[11,"lt","","",104,[[["self"],["result"]],["bool"]]],[11,"le","","",104,[[["self"],["result"]],["bool"]]],[11,"gt","","",104,[[["self"],["result"]],["bool"]]],[11,"ge","","",104,[[["self"],["result"]],["bool"]]],[11,"partial_cmp","core::fmt","",259,[[["self"],["error"]],["option",["ordering"]]]],[11,"partial_cmp","core::time","",143,[[["self"],["duration"]],["option",["ordering"]]]],[11,"lt","","",143,[[["self"],["duration"]],["bool"]]],[11,"le","","",143,[[["self"],["duration"]],["bool"]]],[11,"gt","","",143,[[["self"],["duration"]],["bool"]]],[11,"ge","","",143,[[["self"],["duration"]],["bool"]]],[11,"partial_cmp","core::char","",87,[[["self"],["unicodeversion"]],["option",["ordering"]]]],[11,"lt","","",87,[[["self"],["unicodeversion"]],["bool"]]],[11,"le","","",87,[[["self"],["unicodeversion"]],["bool"]]],[11,"gt","","",87,[[["self"],["unicodeversion"]],["bool"]]],[11,"ge","","",87,[[["self"],["unicodeversion"]],["bool"]]],[11,"partial_cmp","core::task","",145,[[["self"],["poll"]],["option",["ordering"]]]],[11,"lt","","",145,[[["self"],["poll"]],["bool"]]],[11,"le","","",145,[[["self"],["poll"]],["bool"]]],[11,"gt","","",145,[[["self"],["poll"]],["bool"]]],[11,"ge","","",145,[[["self"],["poll"]],["bool"]]],[11,"partial_cmp","core::arch::x86","",154,[[["self"],["cpuidresult"]],["option",["ordering"]]]],[11,"lt","","",154,[[["self"],["cpuidresult"]],["bool"]]],[11,"le","","",154,[[["self"],["cpuidresult"]],["bool"]]],[11,"gt","","",154,[[["self"],["cpuidresult"]],["bool"]]],[11,"ge","","",154,[[["self"],["cpuidresult"]],["bool"]]],[11,"clone","core::num","",2,[[["self"]],["nonzerou8"]]],[11,"clone","","",3,[[["self"]],["nonzerou16"]]],[11,"clone","","",4,[[["self"]],["nonzerou32"]]],[11,"clone","","",5,[[["self"]],["nonzerou64"]]],[11,"clone","","",6,[[["self"]],["nonzerou128"]]],[11,"clone","","",7,[[["self"]],["nonzerousize"]]],[11,"clone","","",0,[[["self"]],["wrapping"]]],[11,"clone","","",175,[[["self"]],["parsefloaterror"]]],[11,"clone","","",1,[[["self"]],["fpcategory"]]],[11,"clone","","",173,[[["self"]],["tryfrominterror"]]],[11,"clone","","",174,[[["self"]],["parseinterror"]]],[11,"clone","core::mem","",176,[[["self"]],["self"]]],[11,"clone","","",8,[[["self"]],["manuallydrop"]]],[11,"clone","core::ptr","",10,[[["self"]],["self"]]],[11,"clone","core::marker","",177,[[["self"]],["phantomdata"]]],[11,"clone","","",178,[[["self"]],["pinned"]]],[11,"clone","core::ops","",16,[[["self"]],["generatorstate"]]],[11,"clone","","",179,[[["self"]],["rangefull"]]],[11,"clone","","",11,[[["self"]],["range"]]],[11,"clone","","",12,[[["self"]],["rangefrom"]]],[11,"clone","","",13,[[["self"]],["rangeto"]]],[11,"clone","","",17,[[["self"]],["rangeinclusive"]]],[11,"clone","","",14,[[["self"]],["rangetoinclusive"]]],[11,"clone","","",15,[[["self"]],["bound"]]],[11,"clone","core::cmp","",52,[[["self"]],["ordering"]]],[11,"clone","","",51,[[["self"]],["reverse"]]],[11,"clone","core::any","",67,[[["self"]],["typeid"]]],[11,"clone","core::array","",180,[[["self"]],["tryfromsliceerror"]]],[11,"clone","core::sync::atomic","",69,[[["self"]],["ordering"]]],[11,"clone","core::cell","",82,[[["self"]],["cell"]]],[11,"clone","","Panics",83,[[["self"]],["refcell"]]],[11,"clone","core::char","",184,[[["self"]],["parsecharerror"]]],[11,"clone","","",185,[[["self"]],["chartryfromerror"]]],[11,"clone","","",186,[[["self"]],["decodeutf16"]]],[11,"clone","","",88,[[["self"]],["decodeutf16error"]]],[11,"clone","","",187,[[["self"]],["escapeunicode"]]],[11,"clone","","",188,[[["self"]],["escapedefault"]]],[11,"clone","","",189,[[["self"]],["escapedebug"]]],[11,"clone","","",190,[[["self"]],["tolowercase"]]],[11,"clone","","",191,[[["self"]],["touppercase"]]],[11,"clone","core::pin","",91,[[["self"]],["pin"]]],[11,"clone","core::iter","",192,[[["self"]],["repeat"]]],[11,"clone","","",193,[[["self"]],["repeatwith"]]],[11,"clone","","",194,[[["self"]],["empty"]]],[11,"clone","","",195,[[["self"]],["once"]]],[11,"clone","","",196,[[["self"]],["rev"]]],[11,"clone","","",197,[[["self"]],["cloned"]]],[11,"clone","","",198,[[["self"]],["cycle"]]],[11,"clone","","",199,[[["self"]],["stepby"]]],[11,"clone","","",200,[[["self"]],["chain"]]],[11,"clone","","",201,[[["self"]],["zip"]]],[11,"clone","","",202,[[["self"]],["map"]]],[11,"clone","","",203,[[["self"]],["filter"]]],[11,"clone","","",204,[[["self"]],["filtermap"]]],[11,"clone","","",205,[[["self"]],["enumerate"]]],[11,"clone","","",101,[[["self"]],["peekable"]]],[11,"clone","","",206,[[["self"]],["skipwhile"]]],[11,"clone","","",207,[[["self"]],["takewhile"]]],[11,"clone","","",208,[[["self"]],["skip"]]],[11,"clone","","",209,[[["self"]],["take"]]],[11,"clone","","",210,[[["self"]],["scan"]]],[11,"clone","","",211,[[["self"]],["self"]]],[11,"clone","","",212,[[["self"]],["self"]]],[11,"clone","","",213,[[["self"]],["fuse"]]],[11,"clone","","",214,[[["self"]],["inspect"]]],[11,"clone","core::option","",102,[[["self"]],["option"]]],[11,"clone","","",215,[[["self"]],["self"]]],[11,"clone","","",217,[[["self"]],["intoiter"]]],[11,"clone","","",218,[[["self"]],["noneerror"]]],[11,"clone","core::raw","",103,[[["self"]],["traitobject"]]],[11,"clone","core::result","",104,[[["self"]],["result"]]],[11,"clone","","",219,[[["self"]],["self"]]],[11,"clone","","",221,[[["self"]],["intoiter"]]],[11,"clone","core::slice","",106,[[["self"]],["self"]]],[11,"clone","","",223,[[["self"]],["self"]]],[11,"clone","","",225,[[["self"]],["rsplit"]]],[11,"clone","","",231,[[["self"]],["self"]]],[11,"clone","","",232,[[["self"]],["self"]]],[11,"clone","","",108,[[["self"]],["self"]]],[11,"clone","","",234,[[["self"]],["rchunks"]]],[11,"clone","","",110,[[["self"]],["rchunksexact"]]],[11,"clone","core::str::pattern","",112,[[["self"]],["searchstep"]]],[11,"clone","","",253,[[["self"]],["charsearcher"]]],[11,"clone","","",254,[[["self"]],["charslicesearcher"]]],[11,"clone","","",255,[[["self"]],["charpredicatesearcher"]]],[11,"clone","","",256,[[["self"]],["strsearcher"]]],[11,"clone","core::str","",236,[[["self"]],["parseboolerror"]]],[11,"clone","","",119,[[["self"]],["utf8error"]]],[11,"clone","","",120,[[["self"]],["chars"]]],[11,"clone","","",121,[[["self"]],["charindices"]]],[11,"clone","","",237,[[["self"]],["bytes"]]],[11,"clone","","",238,[[["self"]],["self"]]],[11,"clone","","",239,[[["self"]],["self"]]],[11,"clone","","",240,[[["self"]],["self"]]],[11,"clone","","",241,[[["self"]],["self"]]],[11,"clone","","",242,[[["self"]],["self"]]],[11,"clone","","",243,[[["self"]],["self"]]],[11,"clone","","",244,[[["self"]],["self"]]],[11,"clone","","",245,[[["self"]],["self"]]],[11,"clone","","",246,[[["self"]],["self"]]],[11,"clone","","",247,[[["self"]],["self"]]],[11,"clone","","",248,[[["self"]],["lines"]]],[11,"clone","","",249,[[["self"]],["linesany"]]],[11,"clone","","",250,[[["self"]],["splitwhitespace"]]],[11,"clone","","",251,[[["self"]],["splitasciiwhitespace"]]],[11,"clone","","",252,[[["self"]],["encodeutf16"]]],[11,"clone","core::hash","",122,[[["self"]],["siphasher"]]],[11,"clone","","",258,[[["self"]],["buildhasherdefault"]]],[11,"clone","core::fmt","",259,[[["self"]],["error"]]],[11,"clone","","",260,[[["self"]],["arguments"]]],[11,"clone","core::time","",143,[[["self"]],["duration"]]],[11,"clone","core::char","",87,[[["self"]],["unicodeversion"]]],[11,"clone","core::task","",145,[[["self"]],["poll"]]],[11,"clone","","",146,[[["self"]],["self"]]],[11,"clone","","",147,[[["self"]],["localwaker"]]],[11,"clone","core::alloc","",152,[[["self"]],["layout"]]],[11,"clone","","",261,[[["self"]],["layouterr"]]],[11,"clone","","",262,[[["self"]],["allocerr"]]],[11,"clone","","",153,[[["self"]],["cannotreallocinplace"]]],[11,"clone","core::arch::x86","",263,[[["self"]],["__m64"]]],[11,"clone","","",264,[[["self"]],["__m128i"]]],[11,"clone","","",265,[[["self"]],["__m128"]]],[11,"clone","","",266,[[["self"]],["__m128d"]]],[11,"clone","","",267,[[["self"]],["__m256i"]]],[11,"clone","","",268,[[["self"]],["__m256"]]],[11,"clone","","",269,[[["self"]],["__m256d"]]],[11,"clone","","",154,[[["self"]],["cpuidresult"]]],[11,"clone","core::arch::aarch64","",270,[[["self"]],["float64x1_t"]]],[11,"clone","","",271,[[["self"]],["float64x2_t"]]],[11,"clone","","",272,[[["self"]],["poly64x1_t"]]],[11,"clone","","",273,[[["self"]],["poly64x2_t"]]],[11,"clone","","",164,[[["self"]],["int8x16x2_t"]]],[11,"clone","","",165,[[["self"]],["int8x16x3_t"]]],[11,"clone","","",166,[[["self"]],["int8x16x4_t"]]],[11,"clone","","",167,[[["self"]],["uint8x16x2_t"]]],[11,"clone","","",168,[[["self"]],["uint8x16x3_t"]]],[11,"clone","","",169,[[["self"]],["uint8x16x4_t"]]],[11,"clone","","",170,[[["self"]],["poly8x16x2_t"]]],[11,"clone","","",171,[[["self"]],["poly8x16x3_t"]]],[11,"clone","","",172,[[["self"]],["poly8x16x4_t"]]],[11,"clone","core::arch::arm","",274,[[["self"]],["int8x4_t"]]],[11,"clone","","",275,[[["self"]],["uint8x4_t"]]],[11,"clone","","",276,[[["self"]],["int16x2_t"]]],[11,"clone","","",277,[[["self"]],["uint16x2_t"]]],[11,"clone","","",278,[[["self"]],["int8x8_t"]]],[11,"clone","","",279,[[["self"]],["uint8x8_t"]]],[11,"clone","","",280,[[["self"]],["poly8x8_t"]]],[11,"clone","","",281,[[["self"]],["int16x4_t"]]],[11,"clone","","",282,[[["self"]],["uint16x4_t"]]],[11,"clone","","",283,[[["self"]],["poly16x4_t"]]],[11,"clone","","",284,[[["self"]],["int32x2_t"]]],[11,"clone","","",285,[[["self"]],["uint32x2_t"]]],[11,"clone","","",286,[[["self"]],["float32x2_t"]]],[11,"clone","","",287,[[["self"]],["int64x1_t"]]],[11,"clone","","",288,[[["self"]],["uint64x1_t"]]],[11,"clone","","",289,[[["self"]],["int8x16_t"]]],[11,"clone","","",290,[[["self"]],["uint8x16_t"]]],[11,"clone","","",291,[[["self"]],["poly8x16_t"]]],[11,"clone","","",292,[[["self"]],["int16x8_t"]]],[11,"clone","","",293,[[["self"]],["uint16x8_t"]]],[11,"clone","","",294,[[["self"]],["poly16x8_t"]]],[11,"clone","","",295,[[["self"]],["int32x4_t"]]],[11,"clone","","",296,[[["self"]],["uint32x4_t"]]],[11,"clone","","",297,[[["self"]],["float32x4_t"]]],[11,"clone","","",298,[[["self"]],["int64x2_t"]]],[11,"clone","","",299,[[["self"]],["uint64x2_t"]]],[11,"clone","","",155,[[["self"]],["int8x8x2_t"]]],[11,"clone","","",156,[[["self"]],["int8x8x3_t"]]],[11,"clone","","",157,[[["self"]],["int8x8x4_t"]]],[11,"clone","","",158,[[["self"]],["uint8x8x2_t"]]],[11,"clone","","",159,[[["self"]],["uint8x8x3_t"]]],[11,"clone","","",160,[[["self"]],["uint8x8x4_t"]]],[11,"clone","","",161,[[["self"]],["poly8x8x2_t"]]],[11,"clone","","",162,[[["self"]],["poly8x8x3_t"]]],[11,"clone","","",163,[[["self"]],["poly8x8x4_t"]]],[11,"clone","core::arch::mips","",300,[[["self"]],["i8x16"]]],[11,"clone","core::arch::powerpc","",301,[[["self"]],["vector_signed_long"]]],[11,"clone","","",302,[[["self"]],["vector_unsigned_long"]]],[11,"clone","","",303,[[["self"]],["vector_bool_long"]]],[11,"clone","","",304,[[["self"]],["vector_double"]]],[11,"default","core::num","",0,[[],["wrapping"]]],[11,"default","core::mem","",8,[[],["manuallydrop"]]],[11,"default","core::marker","",177,[[],["phantomdata"]]],[11,"default","core::cmp","",51,[[],["reverse"]]],[11,"default","core::sync::atomic","Creates an `AtomicBool` initialized to `false`.",70,[[],["self"]]],[11,"default","","Creates a null `AtomicPtr<T>`.",71,[[],["atomicptr"]]],[11,"default","","",72,[[],["self"]]],[11,"default","","",73,[[],["self"]]],[11,"default","","",74,[[],["self"]]],[11,"default","","",75,[[],["self"]]],[11,"default","","",76,[[],["self"]]],[11,"default","","",77,[[],["self"]]],[11,"default","","",78,[[],["self"]]],[11,"default","","",79,[[],["self"]]],[11,"default","","",80,[[],["self"]]],[11,"default","","",81,[[],["self"]]],[11,"default","core::cell","Creates a `Cell<T>`, with the `Default` value for T.",82,[[],["cell"]]],[11,"default","","Creates a `RefCell<T>`, with the `Default` value for T.",83,[[],["refcell"]]],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",86,[[],["unsafecell"]]],[11,"default","core::iter","",194,[[],["empty"]]],[11,"default","core::option","Returns [`None`][Option::None].",102,[[],["option"]]],[11,"default","core::hash","",122,[[],["siphasher"]]],[11,"default","","",258,[[],["buildhasherdefault"]]],[11,"default","core::fmt","",259,[[],["error"]]],[11,"default","core::time","",143,[[],["duration"]]],[11,"as_ref","core::slice","",106,N],[11,"from","core::num","",173,N],[11,"from","core::ptr","",10,[[["t"]],["self"]]],[11,"from","","",10,[[["t"]],["self"]]],[11,"from","core::sync::atomic","",70,[[["bool"]],["self"]]],[11,"from","","",71,N],[11,"from","","",72,[[["i8"]],["self"]]],[11,"from","","",73,[[["u8"]],["self"]]],[11,"from","","",74,[[["i16"]],["self"]]],[11,"from","","",75,[[["u16"]],["self"]]],[11,"from","","",76,[[["i32"]],["self"]]],[11,"from","","",77,[[["u32"]],["self"]]],[11,"from","","",78,[[["i64"]],["self"]]],[11,"from","","",79,[[["u64"]],["self"]]],[11,"from","","",80,[[["isize"]],["self"]]],[11,"from","","",81,[[["usize"]],["self"]]],[11,"from","core::cell","",82,[[["t"]],["cell"]]],[11,"from","","",83,[[["t"]],["refcell"]]],[11,"from","","",86,[[["t"]],["unsafecell"]]],[11,"from","core::option","",102,[[["t"]],["option"]]],[11,"from","","",102,[[["option"]],["option"]]],[11,"from","","",102,[[["option"]],["option"]]],[11,"from","core::task","",145,[[["t"]],["poll"]]],[11,"from","","Converts a `LocalWaker` into a `Waker`.",146,[[["localwaker"]],["self"]]],[11,"next","core::ascii","",181,[[["self"]],["option",["u8"]]]],[11,"size_hint","","",181,N],[11,"next","core::char","",186,[[["self"]],["option",["result"]]]],[11,"size_hint","","",186,N],[11,"next","","",187,[[["self"]],["option",["char"]]]],[11,"size_hint","","",187,N],[11,"count","","",187,[[["self"]],["usize"]]],[11,"last","","",187,[[["self"]],["option",["char"]]]],[11,"next","","",188,[[["self"]],["option",["char"]]]],[11,"size_hint","","",188,N],[11,"count","","",188,[[["self"]],["usize"]]],[11,"nth","","",188,[[["self"],["usize"]],["option",["char"]]]],[11,"last","","",188,[[["self"]],["option",["char"]]]],[11,"next","","",189,[[["self"]],["option",["char"]]]],[11,"size_hint","","",189,N],[11,"next","","",190,[[["self"]],["option",["char"]]]],[11,"next","","",191,[[["self"]],["option",["char"]]]],[11,"next","core::ops","",11,[[["self"]],["option"]]],[11,"size_hint","","",11,N],[11,"nth","","",11,[[["self"],["usize"]],["option"]]],[11,"last","","",11,[[["self"]],["option"]]],[11,"min","","",11,[[["self"]],["option"]]],[11,"max","","",11,[[["self"]],["option"]]],[11,"next","","",12,[[["self"]],["option"]]],[11,"size_hint","","",12,N],[11,"nth","","",12,[[["self"],["usize"]],["option"]]],[11,"next","","",17,[[["self"]],["option"]]],[11,"size_hint","","",17,N],[11,"nth","","",17,[[["self"],["usize"]],["option"]]],[11,"last","","",17,[[["self"]],["option"]]],[11,"min","","",17,[[["self"]],["option"]]],[11,"max","","",17,[[["self"]],["option"]]],[11,"next","core::iter","",192,[[["self"]],["option"]]],[11,"size_hint","","",192,N],[11,"next","","",193,[[["self"]],["option"]]],[11,"size_hint","","",193,N],[11,"next","","",194,[[["self"]],["option"]]],[11,"size_hint","","",194,N],[11,"next","","",195,[[["self"]],["option"]]],[11,"size_hint","","",195,N],[11,"next","","",196,[[["self"]],["option"]]],[11,"size_hint","","",196,N],[11,"try_fold","","",196,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",196,[[["self"],["acc"],["f"]],["acc"]]],[11,"find","","",196,[[["self"],["p"]],["option"]]],[11,"rposition","","",196,[[["self"],["p"]],["option",["usize"]]]],[11,"next","","",197,[[["self"]],["option"]]],[11,"size_hint","","",197,N],[11,"try_fold","","",197,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",197,[[["self"],["acc"],["f"]],["acc"]]],[11,"next","","",198,[[["self"]],["option"]]],[11,"size_hint","","",198,N],[11,"next","","",199,[[["self"]],["option"]]],[11,"size_hint","","",199,N],[11,"nth","","",199,[[["self"],["usize"]],["option"]]],[11,"next","","",200,[[["self"]],["option"]]],[11,"count","","",200,[[["self"]],["usize"]]],[11,"try_fold","","",200,[[["self"],["acc"],["f"]],["r"]]],[11,"fold","","",200,[[["self"],["acc"],["f"]],["acc"]]],[11,"nth","","",200,[[["self"],["usize"]],["option"]]],[11,"find","","",200,[[["self"],["p"]],["option"]]],[11,"last","","",200,[[["self"]],["option"]]],[11,"size_hint","","",200,N],[11,"next","","",201,[[["self"]],["option"]]],[11,"size_hint","","",201,N],[11,"nth","","",201,[[["self"],["usize"]],["option"]]],[11,"next","","",202,[[["self"]],["option"]]],[11,"size_hint","","",202,N],[11,"try_fold","","",202,[[["self"],["acc"],["g"]],["r"]]],[11,"fold","","",202,[[["self"],["acc"],["g"]],["acc"]]],[11,"next","","",203,[[["self"]],["option"]]],[11,"size_hint","","",203,N],[11,"count","","",203,[[["self"]],["usize"]]],[11,"try_fold","","",203,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",203,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","",204,[[["self"]],["option"]]],[11,"size_hint","","",204,N],[11,"try_fold","","",204,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",204,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","Overflow Behavior",205,[[["self"]],["option"]]],[11,"size_hint","","",205,N],[11,"nth","","",205,[[["self"],["usize"]],["option"]]],[11,"count","","",205,[[["self"]],["usize"]]],[11,"try_fold","","",205,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",205,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","",101,[[["self"]],["option"]]],[11,"count","","",101,[[["self"]],["usize"]]],[11,"nth","","",101,[[["self"],["usize"]],["option"]]],[11,"last","","",101,[[["self"]],["option"]]],[11,"size_hint","","",101,N],[11,"try_fold","","",101,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",101,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","",206,[[["self"]],["option"]]],[11,"size_hint","","",206,N],[11,"try_fold","","",206,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",206,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","",207,[[["self"]],["option"]]],[11,"size_hint","","",207,N],[11,"try_fold","","",207,[[["self"],["acc"],["fold"]],["r"]]],[11,"next","","",208,[[["self"]],["option"]]],[11,"nth","","",208,[[["self"],["usize"]],["option"]]],[11,"count","","",208,[[["self"]],["usize"]]],[11,"last","","",208,[[["self"]],["option"]]],[11,"size_hint","","",208,N],[11,"try_fold","","",208,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",208,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","",209,[[["self"]],["option"]]],[11,"nth","","",209,[[["self"],["usize"]],["option"]]],[11,"size_hint","","",209,N],[11,"try_fold","","",209,[[["self"],["acc"],["fold"]],["r"]]],[11,"next","","",210,[[["self"]],["option"]]],[11,"size_hint","","",210,N],[11,"try_fold","","",210,[[["self"],["acc"],["fold"]],["r"]]],[11,"next","","",211,[[["self"]],["option"]]],[11,"size_hint","","",211,N],[11,"try_fold","","",211,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",211,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","",212,[[["self"]],["option"]]],[11,"size_hint","","",212,N],[11,"try_fold","","",212,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",212,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","",213,[[["self"]],["option"]]],[11,"nth","","",213,[[["self"],["usize"]],["option"]]],[11,"last","","",213,[[["self"]],["option"]]],[11,"count","","",213,[[["self"]],["usize"]]],[11,"size_hint","","",213,N],[11,"try_fold","","",213,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",213,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","",213,[[["self"]],["option"]]],[11,"nth","","",213,[[["self"],["usize"]],["option"]]],[11,"last","","",213,[[["self"]],["option"]]],[11,"count","","",213,[[["self"]],["usize"]]],[11,"size_hint","","",213,N],[11,"try_fold","","",213,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",213,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","","",214,[[["self"]],["option"]]],[11,"size_hint","","",214,N],[11,"try_fold","","",214,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",214,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next","core::option","",215,[[["self"]],["option"]]],[11,"size_hint","","",215,N],[11,"next","","",216,[[["self"]],["option"]]],[11,"size_hint","","",216,N],[11,"next","","",217,[[["self"]],["option"]]],[11,"size_hint","","",217,N],[11,"next","core::result","",219,[[["self"]],["option"]]],[11,"size_hint","","",219,N],[11,"next","","",220,[[["self"]],["option"]]],[11,"size_hint","","",220,N],[11,"next","","",221,[[["self"]],["option"]]],[11,"size_hint","","",221,N],[11,"next","core::slice","",106,[[["self"]],["option"]]],[11,"size_hint","","",106,N],[11,"count","","",106,[[["self"]],["usize"]]],[11,"nth","","",106,[[["self"],["usize"]],["option"]]],[11,"last","","",106,[[["self"]],["option"]]],[11,"try_fold","","",106,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",106,[[["self"],["acc"],["fold"]],["acc"]]],[11,"position","","",106,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",106,[[["self"],["p"]],["option",["usize"]]]],[11,"next","","",107,[[["self"]],["option"]]],[11,"size_hint","","",107,N],[11,"count","","",107,[[["self"]],["usize"]]],[11,"nth","","",107,[[["self"],["usize"]],["option"]]],[11,"last","","",107,[[["self"]],["option"]]],[11,"try_fold","","",107,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",107,[[["self"],["acc"],["fold"]],["acc"]]],[11,"position","","",107,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",107,[[["self"],["p"]],["option",["usize"]]]],[11,"next","","",223,[[["self"]],["option"]]],[11,"size_hint","","",223,N],[11,"next","","",224,[[["self"]],["option"]]],[11,"size_hint","","",224,N],[11,"next","","",225,[[["self"]],["option"]]],[11,"size_hint","","",225,N],[11,"next","","",226,[[["self"]],["option"]]],[11,"size_hint","","",226,N],[11,"next","","",227,[[["self"]],["option"]]],[11,"size_hint","","",227,N],[11,"next","","",228,[[["self"]],["option"]]],[11,"size_hint","","",228,N],[11,"next","","",229,[[["self"]],["option"]]],[11,"size_hint","","",229,N],[11,"next","","",230,[[["self"]],["option"]]],[11,"size_hint","","",230,N],[11,"next","","",231,[[["self"]],["option"]]],[11,"size_hint","","",231,N],[11,"count","","",231,[[["self"]],["usize"]]],[11,"nth","","",231,[[["self"],["usize"]],["option"]]],[11,"last","","",231,[[["self"]],["option"]]],[11,"next","","",232,[[["self"]],["option"]]],[11,"size_hint","","",232,N],[11,"count","","",232,[[["self"]],["usize"]]],[11,"nth","","",232,[[["self"],["usize"]],["option"]]],[11,"last","","",232,[[["self"]],["option"]]],[11,"next","","",233,[[["self"]],["option"]]],[11,"size_hint","","",233,N],[11,"count","","",233,[[["self"]],["usize"]]],[11,"nth","","",233,[[["self"],["usize"]],["option"]]],[11,"last","","",233,[[["self"]],["option"]]],[11,"next","","",108,[[["self"]],["option"]]],[11,"size_hint","","",108,N],[11,"count","","",108,[[["self"]],["usize"]]],[11,"nth","","",108,[[["self"],["usize"]],["option"]]],[11,"last","","",108,[[["self"]],["option"]]],[11,"next","","",109,[[["self"]],["option"]]],[11,"size_hint","","",109,N],[11,"count","","",109,[[["self"]],["usize"]]],[11,"nth","","",109,[[["self"],["usize"]],["option"]]],[11,"last","","",109,[[["self"]],["option"]]],[11,"next","","",234,[[["self"]],["option"]]],[11,"size_hint","","",234,N],[11,"count","","",234,[[["self"]],["usize"]]],[11,"nth","","",234,[[["self"],["usize"]],["option"]]],[11,"last","","",234,[[["self"]],["option"]]],[11,"next","","",235,[[["self"]],["option"]]],[11,"size_hint","","",235,N],[11,"count","","",235,[[["self"]],["usize"]]],[11,"nth","","",235,[[["self"],["usize"]],["option"]]],[11,"last","","",235,[[["self"]],["option"]]],[11,"next","","",110,[[["self"]],["option"]]],[11,"size_hint","","",110,N],[11,"count","","",110,[[["self"]],["usize"]]],[11,"nth","","",110,[[["self"],["usize"]],["option"]]],[11,"last","","",110,[[["self"]],["option"]]],[11,"next","","",111,[[["self"]],["option"]]],[11,"size_hint","","",111,N],[11,"count","","",111,[[["self"]],["usize"]]],[11,"nth","","",111,[[["self"],["usize"]],["option"]]],[11,"last","","",111,[[["self"]],["option"]]],[11,"next","core::str::lossy","",257,[[["self"]],["option",["utf8lossychunk"]]]],[11,"next","core::str","",120,[[["self"]],["option",["char"]]]],[11,"count","","",120,[[["self"]],["usize"]]],[11,"size_hint","","",120,N],[11,"last","","",120,[[["self"]],["option",["char"]]]],[11,"next","","",121,[[["self"]],["option"]]],[11,"count","","",121,[[["self"]],["usize"]]],[11,"size_hint","","",121,N],[11,"last","","",121,[[["self"]],["option"]]],[11,"next","","",237,[[["self"]],["option",["u8"]]]],[11,"size_hint","","",237,N],[11,"count","","",237,[[["self"]],["usize"]]],[11,"last","","",237,[[["self"]],["option"]]],[11,"nth","","",237,[[["self"],["usize"]],["option"]]],[11,"all","","",237,[[["self"],["f"]],["bool"]]],[11,"any","","",237,[[["self"],["f"]],["bool"]]],[11,"find","","",237,[[["self"],["p"]],["option"]]],[11,"position","","",237,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","",237,[[["self"],["p"]],["option",["usize"]]]],[11,"next","","",238,[[["self"]],["option",["str"]]]],[11,"next","","",239,[[["self"]],["option",["str"]]]],[11,"next","","",240,[[["self"]],["option",["str"]]]],[11,"next","","",241,[[["self"]],["option",["str"]]]],[11,"next","","",242,[[["self"]],["option",["str"]]]],[11,"next","","",243,[[["self"]],["option",["str"]]]],[11,"next","","",244,[[["self"]],["option"]]],[11,"next","","",245,[[["self"]],["option"]]],[11,"next","","",246,[[["self"]],["option",["str"]]]],[11,"next","","",247,[[["self"]],["option",["str"]]]],[11,"next","","",248,[[["self"]],["option",["str"]]]],[11,"size_hint","","",248,N],[11,"next","","",249,[[["self"]],["option",["str"]]]],[11,"size_hint","","",249,N],[11,"next","","",250,[[["self"]],["option",["str"]]]],[11,"size_hint","","",250,N],[11,"next","","",251,[[["self"]],["option",["str"]]]],[11,"size_hint","","",251,N],[11,"next","","",252,[[["self"]],["option",["u16"]]]],[11,"size_hint","","",252,N],[11,"from_iter","core::option","Takes each element in the [`Iterator`]: if it is [`None`][Option::None], no further elements are taken, and the [`None`][Option::None] is returned. Should no [`None`][Option::None] occur, a container with the values of each [`Option`] is returned.",102,[[["i"]],["option"]]],[11,"from_iter","core::result","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, a container with the values of each `Result` is returned.",104,[[["i"]],["result"]]],[11,"into_iter","core::option","Returns a consuming iterator over the possibly contained value.",102,[[["self"]],["intoiter"]]],[11,"into_iter","core::result","Returns a consuming iterator over the possibly contained value.",104,[[["self"]],["intoiter"]]],[11,"next_back","core::ascii","",181,[[["self"]],["option",["u8"]]]],[11,"next_back","core::ops","",11,[[["self"]],["option"]]],[11,"next_back","","",17,[[["self"]],["option"]]],[11,"next_back","core::iter","",192,[[["self"]],["option"]]],[11,"next_back","","",194,[[["self"]],["option"]]],[11,"next_back","","",195,[[["self"]],["option"]]],[11,"next_back","","",196,[[["self"]],["option"]]],[11,"try_rfold","","",196,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",196,[[["self"],["acc"],["f"]],["acc"]]],[11,"rfind","","",196,[[["self"],["p"]],["option"]]],[11,"next_back","","",197,[[["self"]],["option"]]],[11,"try_rfold","","",197,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",197,[[["self"],["acc"],["f"]],["acc"]]],[11,"next_back","","",200,[[["self"]],["option"]]],[11,"try_rfold","","",200,[[["self"],["acc"],["f"]],["r"]]],[11,"rfold","","",200,[[["self"],["acc"],["f"]],["acc"]]],[11,"next_back","","",201,[[["self"]],["option"]]],[11,"next_back","","",202,[[["self"]],["option"]]],[11,"try_rfold","","",202,[[["self"],["acc"],["g"]],["r"]]],[11,"rfold","","",202,[[["self"],["acc"],["g"]],["acc"]]],[11,"next_back","","",203,[[["self"]],["option"]]],[11,"try_rfold","","",203,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",203,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",204,[[["self"]],["option"]]],[11,"try_rfold","","",204,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",204,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",205,[[["self"]],["option"]]],[11,"try_rfold","","",205,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",205,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",208,[[["self"]],["option"]]],[11,"try_rfold","","",208,[[["self"],["acc"],["fold"]],["r"]]],[11,"next_back","","",211,[[["self"]],["option"]]],[11,"try_rfold","","",211,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",211,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",212,[[["self"]],["option"]]],[11,"try_rfold","","",212,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",212,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",213,[[["self"]],["option"]]],[11,"try_rfold","","",213,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",213,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",213,[[["self"]],["option"]]],[11,"try_rfold","","",213,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",213,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",214,[[["self"]],["option"]]],[11,"try_rfold","","",214,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",214,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","core::option","",215,[[["self"]],["option"]]],[11,"next_back","","",216,[[["self"]],["option"]]],[11,"next_back","","",217,[[["self"]],["option"]]],[11,"next_back","core::result","",219,[[["self"]],["option"]]],[11,"next_back","","",220,[[["self"]],["option"]]],[11,"next_back","","",221,[[["self"]],["option"]]],[11,"next_back","core::slice","",106,[[["self"]],["option"]]],[11,"try_rfold","","",106,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",106,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",107,[[["self"]],["option"]]],[11,"try_rfold","","",107,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",107,[[["self"],["acc"],["fold"]],["acc"]]],[11,"next_back","","",223,[[["self"]],["option"]]],[11,"next_back","","",224,[[["self"]],["option"]]],[11,"next_back","","",225,[[["self"]],["option"]]],[11,"next_back","","",226,[[["self"]],["option"]]],[11,"next_back","","",231,[[["self"]],["option"]]],[11,"next_back","","",232,[[["self"]],["option"]]],[11,"next_back","","",233,[[["self"]],["option"]]],[11,"next_back","","",108,[[["self"]],["option"]]],[11,"next_back","","",109,[[["self"]],["option"]]],[11,"next_back","","",234,[[["self"]],["option"]]],[11,"next_back","","",235,[[["self"]],["option"]]],[11,"next_back","","",110,[[["self"]],["option"]]],[11,"next_back","","",111,[[["self"]],["option"]]],[11,"next_back","core::str","",120,[[["self"]],["option",["char"]]]],[11,"next_back","","",121,[[["self"]],["option"]]],[11,"next_back","","",237,[[["self"]],["option",["u8"]]]],[11,"rfind","","",237,[[["self"],["p"]],["option"]]],[11,"next_back","","",238,[[["self"]],["option",["str"]]]],[11,"next_back","","",239,[[["self"]],["option",["str"]]]],[11,"next_back","","",240,[[["self"]],["option",["str"]]]],[11,"next_back","","",241,[[["self"]],["option",["str"]]]],[11,"next_back","","",244,[[["self"]],["option"]]],[11,"next_back","","",245,[[["self"]],["option"]]],[11,"next_back","","",246,[[["self"]],["option",["str"]]]],[11,"next_back","","",247,[[["self"]],["option",["str"]]]],[11,"next_back","","",248,[[["self"]],["option",["str"]]]],[11,"next_back","","",249,[[["self"]],["option",["str"]]]],[11,"next_back","","",250,[[["self"]],["option",["str"]]]],[11,"next_back","","",251,[[["self"]],["option",["str"]]]],[11,"len","core::char","",187,[[["self"]],["usize"]]],[11,"len","","",188,[[["self"]],["usize"]]],[11,"len","core::iter","",194,[[["self"]],["usize"]]],[11,"len","","",195,[[["self"]],["usize"]]],[11,"len","","",196,[[["self"]],["usize"]]],[11,"is_empty","","",196,[[["self"]],["bool"]]],[11,"len","","",197,[[["self"]],["usize"]]],[11,"is_empty","","",197,[[["self"]],["bool"]]],[11,"len","","",202,[[["self"]],["usize"]]],[11,"is_empty","","",202,[[["self"]],["bool"]]],[11,"len","","",205,[[["self"]],["usize"]]],[11,"is_empty","","",205,[[["self"]],["bool"]]],[11,"len","","",213,[[["self"]],["usize"]]],[11,"is_empty","","",213,[[["self"]],["bool"]]],[11,"len","","",214,[[["self"]],["usize"]]],[11,"is_empty","","",214,[[["self"]],["bool"]]],[11,"len","core::slice","",106,[[["self"]],["usize"]]],[11,"is_empty","","",106,[[["self"]],["bool"]]],[11,"len","","",107,[[["self"]],["usize"]]],[11,"is_empty","","",107,[[["self"]],["bool"]]],[11,"is_empty","","",108,[[["self"]],["bool"]]],[11,"is_empty","","",109,[[["self"]],["bool"]]],[11,"is_empty","","",110,[[["self"]],["bool"]]],[11,"is_empty","","",111,[[["self"]],["bool"]]],[11,"len","core::str","",237,[[["self"]],["usize"]]],[11,"is_empty","","",237,[[["self"]],["bool"]]],[11,"sum","core::num","",0,[[["i"]],["wrapping",["i8"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i8"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i16"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i16"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i32"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i32"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i64"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i64"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i128"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["i128"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["isize"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["isize"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u8"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u8"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u16"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u16"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u32"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u32"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u64"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u64"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u128"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["u128"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["usize"]]]],[11,"sum","","",0,[[["i"]],["wrapping",["usize"]]]],[11,"sum","core::result","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, the sum of all elements is returned.",104,[[["i"]],["result"]]],[11,"sum","core::time","",143,[[["i"]],["duration"]]],[11,"sum","","",143,[[["i"]],["duration"]]],[11,"product","core::num","",0,[[["i"]],["wrapping",["i8"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i8"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i16"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i16"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i32"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i32"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i64"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i64"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i128"]]]],[11,"product","","",0,[[["i"]],["wrapping",["i128"]]]],[11,"product","","",0,[[["i"]],["wrapping",["isize"]]]],[11,"product","","",0,[[["i"]],["wrapping",["isize"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u8"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u8"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u16"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u16"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u32"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u32"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u64"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u64"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u128"]]]],[11,"product","","",0,[[["i"]],["wrapping",["u128"]]]],[11,"product","","",0,[[["i"]],["wrapping",["usize"]]]],[11,"product","","",0,[[["i"]],["wrapping",["usize"]]]],[11,"product","core::result","Takes each element in the `Iterator`: if it is an `Err`, no further elements are taken, and the `Err` is returned. Should no `Err` occur, the product of all elements is returned.",104,[[["i"]],["result"]]],[11,"get","core::ops","",11,N],[11,"get_mut","","",11,N],[11,"get_unchecked","","",11,N],[11,"get_unchecked_mut","","",11,N],[11,"index","","",11,N],[11,"index_mut","","",11,N],[11,"get","","",13,N],[11,"get_mut","","",13,N],[11,"get_unchecked","","",13,N],[11,"get_unchecked_mut","","",13,N],[11,"index","","",13,N],[11,"index_mut","","",13,N],[11,"get","","",12,N],[11,"get_mut","","",12,N],[11,"get_unchecked","","",12,N],[11,"get_unchecked_mut","","",12,N],[11,"index","","",12,N],[11,"index_mut","","",12,N],[11,"get","","",179,N],[11,"get_mut","","",179,N],[11,"get_unchecked","","",179,N],[11,"get_unchecked_mut","","",179,N],[11,"index","","",179,N],[11,"index_mut","","",179,N],[11,"get","","",17,N],[11,"get_mut","","",17,N],[11,"get_unchecked","","",17,N],[11,"get_unchecked_mut","","",17,N],[11,"index","","",17,N],[11,"index_mut","","",17,N],[11,"get","","",14,N],[11,"get_mut","","",14,N],[11,"get_unchecked","","",14,N],[11,"get_unchecked_mut","","",14,N],[11,"index","","",14,N],[11,"index_mut","","",14,N],[11,"get","","",179,[[["self"],["str"]],["option"]]],[11,"get_mut","","",179,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",179,N],[11,"get_unchecked_mut","","",179,N],[11,"index","","",179,N],[11,"index_mut","","",179,N],[11,"get","","",11,[[["self"],["str"]],["option"]]],[11,"get_mut","","",11,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",11,N],[11,"get_unchecked_mut","","",11,N],[11,"index","","",11,N],[11,"index_mut","","",11,N],[11,"get","","",13,[[["self"],["str"]],["option"]]],[11,"get_mut","","",13,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",13,N],[11,"get_unchecked_mut","","",13,N],[11,"index","","",13,N],[11,"index_mut","","",13,N],[11,"get","","",12,[[["self"],["str"]],["option"]]],[11,"get_mut","","",12,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",12,N],[11,"get_unchecked_mut","","",12,N],[11,"index","","",12,N],[11,"index_mut","","",12,N],[11,"get","","",17,[[["self"],["str"]],["option"]]],[11,"get_mut","","",17,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",17,N],[11,"get_unchecked_mut","","",17,N],[11,"index","","",17,N],[11,"index_mut","","",17,N],[11,"get","","",14,[[["self"],["str"]],["option"]]],[11,"get_mut","","",14,[[["self"],["str"]],["option"]]],[11,"get_unchecked","","",14,N],[11,"get_unchecked_mut","","",14,N],[11,"index","","",14,N],[11,"index_mut","","",14,N],[11,"haystack","core::str::pattern","",253,[[["self"]],["str"]]],[11,"next","","",253,[[["self"]],["searchstep"]]],[11,"next_match","","",253,[[["self"]],["option"]]],[11,"haystack","","",254,[[["self"]],["str"]]],[11,"next","","",254,[[["self"]],["searchstep"]]],[11,"next_match","","",254,[[["self"]],["option"]]],[11,"next_reject","","",254,[[["self"]],["option"]]],[11,"haystack","","",255,[[["self"]],["str"]]],[11,"next","","",255,[[["self"]],["searchstep"]]],[11,"next_match","","",255,[[["self"]],["option"]]],[11,"next_reject","","",255,[[["self"]],["option"]]],[11,"haystack","","",256,[[["self"]],["str"]]],[11,"next","","",256,[[["self"]],["searchstep"]]],[11,"next_match","","",256,[[["self"]],["option"]]],[11,"next_back","","",253,[[["self"]],["searchstep"]]],[11,"next_match_back","","",253,[[["self"]],["option"]]],[11,"next_back","","",254,[[["self"]],["searchstep"]]],[11,"next_match_back","","",254,[[["self"]],["option"]]],[11,"next_reject_back","","",254,[[["self"]],["option"]]],[11,"next_back","","",255,[[["self"]],["searchstep"]]],[11,"next_match_back","","",255,[[["self"]],["option"]]],[11,"next_reject_back","","",255,[[["self"]],["option"]]],[11,"next_back","","",256,[[["self"]],["searchstep"]]],[11,"next_match_back","","",256,[[["self"]],["option"]]],[11,"hash","core::num","",2,N],[11,"hash","","",3,N],[11,"hash","","",4,N],[11,"hash","","",5,N],[11,"hash","","",6,N],[11,"hash","","",7,N],[11,"hash","","",0,N],[11,"hash","core::mem","",176,[[["self"],["h"]]]],[11,"hash","","",8,N],[11,"hash","core::ptr","",10,[[["self"],["h"]]]],[11,"hash","core::marker","",177,[[["self"],["h"]]]],[11,"hash","","",178,N],[11,"hash","core::ops","",16,N],[11,"hash","","",179,N],[11,"hash","","",11,N],[11,"hash","","",12,N],[11,"hash","","",13,N],[11,"hash","","",17,[[["self"],["h"]]]],[11,"hash","","",14,N],[11,"hash","","",15,N],[11,"hash","core::cmp","",52,N],[11,"hash","","",51,N],[11,"hash","core::any","",67,N],[11,"hash","core::pin","",91,N],[11,"hash","core::option","",102,N],[11,"hash","","",218,N],[11,"hash","core::result","",104,N],[11,"hash","core::fmt","",259,N],[11,"hash","core::time","",143,N],[11,"hash","core::task","",145,N],[11,"write","core::hash","",122,N],[11,"finish","","",122,[[["self"]],["u64"]]],[11,"build_hasher","","",258,[[["self"]],["h"]]],[11,"write_str","core::fmt","",142,[[["self"],["str"]],["result"]]],[11,"write_char","","",142,[[["self"],["char"]],["result"]]],[11,"write_fmt","","",142,[[["self"],["arguments"]],["result"]]],[11,"fmt","core::num","",2,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",175,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",173,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",174,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::mem","",176,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::ptr","",10,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::marker","",178,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::ops","",16,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",179,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",17,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",15,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::cmp","",52,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",51,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::any","",66,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",66,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",66,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",67,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::array","",180,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::ascii","",181,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::sync::atomic","",69,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",72,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",73,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",74,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",75,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",76,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",77,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",78,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",79,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",80,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",81,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",70,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",71,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::cell","",182,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",183,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::char","",184,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",185,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",186,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",88,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",187,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",188,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",189,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",190,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",191,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::panic","",89,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",90,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::pin","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::iter","",192,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",193,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",194,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",195,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",196,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",197,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",198,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",199,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",200,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",201,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",202,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",203,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",204,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",205,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",101,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",206,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",207,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",208,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",209,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",210,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",211,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",212,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",213,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",214,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::option","",102,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",215,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",216,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",217,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",218,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::result","",104,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",219,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",220,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",221,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::ffi","",222,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::slice","",106,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",107,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",223,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",224,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",225,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",226,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",227,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",228,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",229,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",230,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",231,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",232,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",233,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",108,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",109,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",234,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",235,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",110,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",111,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::str::pattern","",112,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",253,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",254,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",255,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",256,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::str::lossy","",116,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",117,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::str","",236,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",119,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",120,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",121,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",237,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",238,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",239,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",240,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",241,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",242,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",243,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",244,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",245,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",246,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",247,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",248,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",249,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",250,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",251,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",252,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::hash","",122,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",258,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::fmt","",126,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",259,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",260,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::marker","",177,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::cell","",82,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",83,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",84,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",85,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",86,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::time","",143,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::char","",87,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::task","",145,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",146,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",147,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::alloc","",149,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",152,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",261,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",262,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",153,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::arch::x86","",263,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",264,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",265,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",266,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",267,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",268,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",269,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::arch::aarch64","",270,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",271,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",272,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",273,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::arch::arm","",274,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",275,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",276,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",277,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",278,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",279,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",280,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",281,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",282,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",283,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",284,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",285,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",286,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",287,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",288,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",289,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",290,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",291,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",292,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",293,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",294,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",295,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",296,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",297,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",298,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",299,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::arch::mips","",300,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::arch::powerpc","",301,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",302,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",303,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",304,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::num","",2,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",175,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",173,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",174,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::array","",180,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::cell","",182,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",183,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",84,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",85,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::char","",184,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",185,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",88,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",187,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",188,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",189,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",190,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",191,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::panic","",89,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",90,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::pin","",91,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::str::lossy","",117,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::str","",236,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",119,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::fmt","",260,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",259,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::alloc","",261,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",262,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",153,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::num","",2,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",6,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::ptr","",10,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::sync::atomic","",71,[[["self"],["formatter"]],["result"]]],[11,"fmt","core::pin","",91,[[["self"],["formatter"]],["result"]]],[11,"poll","","",91,[[["pin"],["localwaker"]],["poll"]]],[11,"contains","core::ops","Returns `true` if `item` is contained in the range.",48,[[["self"],["u"]],["bool"]]],[11,"size_hint","core::iter","Returns the bounds on the remaining length of the iterator.",92,N],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",92,[[["self"]],["usize"]]],[11,"last","","Consumes the iterator, returning the last element.",92,[[["self"]],["option"]]],[11,"nth","","Returns the `n`th element of the iterator.",92,[[["self"],["usize"]],["option"]]],[11,"step_by","","Creates an iterator starting at the same point, but stepping by the given amount at each iteration.",92,[[["self"],["usize"]],["stepby"]]],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",92,[[["self"],["u"]],["chain"]]],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",92,[[["self"],["u"]],["zip"]]],[11,"map","","Takes a closure and creates an iterator which calls that closure on each element.",92,[[["self"],["f"]],["map"]]],[11,"for_each","","Calls a closure on each element of an iterator.",92,[[["self"],["f"]]]],[11,"filter","","Creates an iterator which uses a closure to determine if an element should be yielded.",92,[[["self"],["p"]],["filter"]]],[11,"filter_map","","Creates an iterator that both filters and maps.",92,[[["self"],["f"]],["filtermap"]]],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as the next value.",92,[[["self"]],["enumerate"]]],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of the iterator without consuming it.",92,[[["self"]],["peekable"]]],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a predicate.",92,[[["self"],["p"]],["skipwhile"]]],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",92,[[["self"],["p"]],["takewhile"]]],[11,"skip","","Creates an iterator that skips the first `n` elements.",92,[[["self"],["usize"]],["skip"]]],[11,"take","","Creates an iterator that yields its first `n` elements.",92,[[["self"],["usize"]],["take"]]],[11,"scan","","An iterator adaptor similar to [`fold`] that holds internal state and produces a new iterator.",92,[[["self"],["st"],["f"]],["scan"]]],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",92,[[["self"],["f"]],["flatmap"]]],[11,"flatten","","Creates an iterator that flattens nested structure.",92,[[["self"]],["flatten"]]],[11,"fuse","","Creates an iterator which ends after the first [`None`].",92,[[["self"]],["fuse"]]],[11,"inspect","","Do something with each element of an iterator, passing the value on.",92,[[["self"],["f"]],["inspect"]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",92,[[["self"]],["self"]]],[11,"collect","","Transforms an iterator into a collection.",92,[[["self"]],["b"]]],[11,"partition","","Consumes an iterator, creating two collections from it.",92,N],[11,"try_fold","","An iterator method that applies a function as long as it returns successfully, producing a single, final value.",92,[[["self"],["b"],["f"]],["r"]]],[11,"try_for_each","","An iterator method that applies a fallible function to each item in the iterator, stopping at the first error and returning that error.",92,[[["self"],["f"]],["r"]]],[11,"fold","","An iterator method that applies a function, producing a single, final value.",92,[[["self"],["b"],["f"]],["b"]]],[11,"all","","Tests if every element of the iterator matches a predicate.",92,[[["self"],["f"]],["bool"]]],[11,"any","","Tests if any element of the iterator matches a predicate.",92,[[["self"],["f"]],["bool"]]],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",92,[[["self"],["p"]],["option"]]],[11,"find_map","","Applies function to the elements of iterator and returns the first non-none result.",92,[[["self"],["f"]],["option"]]],[11,"position","","Searches for an element in an iterator, returning its index.",92,[[["self"],["p"]],["option",["usize"]]]],[11,"rposition","","Searches for an element in an iterator from the right, returning its index.",92,[[["self"],["p"]],["option",["usize"]]]],[11,"max","","Returns the maximum element of an iterator.",92,[[["self"]],["option"]]],[11,"min","","Returns the minimum element of an iterator.",92,[[["self"]],["option"]]],[11,"max_by_key","","Returns the element that gives the maximum value from the specified function.",92,[[["self"],["f"]],["option"]]],[11,"max_by","","Returns the element that gives the maximum value with respect to the specified comparison function.",92,[[["self"],["f"]],["option"]]],[11,"min_by_key","","Returns the element that gives the minimum value from the specified function.",92,[[["self"],["f"]],["option"]]],[11,"min_by","","Returns the element that gives the minimum value with respect to the specified comparison function.",92,[[["self"],["f"]],["option"]]],[11,"rev","","Reverses an iterator's direction.",92,[[["self"]],["rev"]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",92,N],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",92,[[["self"]],["cloned"]]],[11,"cycle","","Repeats an iterator endlessly.",92,[[["self"]],["cycle"]]],[11,"sum","","Sums the elements of an iterator.",92,[[["self"]],["s"]]],[11,"product","","Iterates over the entire iterator, multiplying all the elements",92,[[["self"]],["p"]]],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",92,[[["self"],["i"]],["ordering"]]],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those of another.",92,[[["self"],["i"]],["option",["ordering"]]]],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of another.",92,[[["self"],["i"]],["bool"]]],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of another.",92,[[["self"],["i"]],["bool"]]],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically less than those of another.",92,[[["self"],["i"]],["bool"]]],[11,"le","","Determines if the elements of this `Iterator` are lexicographically less or equal to those of another.",92,[[["self"],["i"]],["bool"]]],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically greater than those of another.",92,[[["self"],["i"]],["bool"]]],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically greater than or equal to those of another.",92,[[["self"],["i"]],["bool"]]],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes elements starting from the back of the iterator.",96,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","An iterator method that reduces the iterator's elements to a single, final value, starting from the back.",96,[[["self"],["b"],["f"]],["b"]]],[11,"rfind","","Searches for an element of an iterator from the back that satisfies a predicate.",96,[[["self"],["p"]],["option"]]],[11,"len","","Returns the exact number of times the iterator will iterate.",98,[[["self"]],["usize"]]],[11,"is_empty","","Returns whether the iterator is empty.",98,[[["self"]],["bool"]]],[11,"wake_local","core::task","Indicates that the associated task is ready to make progress and should be `poll`ed. This function is the same as `wake`, but can only be called from the thread that this `UnsafeWake` is \"local\" to. This allows for implementors to provide specialized wakeup behavior specific to the current thread. This function is called by `LocalWaker::wake`.",148,[[["self"]]]]],"paths":[[3,"Wrapping"],[4,"FpCategory"],[3,"NonZeroU8"],[3,"NonZeroU16"],[3,"NonZeroU32"],[3,"NonZeroU64"],[3,"NonZeroU128"],[3,"NonZeroUsize"],[3,"ManuallyDrop"],[19,"MaybeUninit"],[3,"NonNull"],[3,"Range"],[3,"RangeFrom"],[3,"RangeTo"],[3,"RangeToInclusive"],[4,"Bound"],[4,"GeneratorState"],[3,"RangeInclusive"],[8,"Add"],[8,"Sub"],[8,"Mul"],[8,"Div"],[8,"Rem"],[8,"Neg"],[8,"AddAssign"],[8,"SubAssign"],[8,"MulAssign"],[8,"DivAssign"],[8,"RemAssign"],[8,"Not"],[8,"BitAnd"],[8,"BitOr"],[8,"BitXor"],[8,"Shl"],[8,"Shr"],[8,"BitAndAssign"],[8,"BitOrAssign"],[8,"BitXorAssign"],[8,"ShlAssign"],[8,"ShrAssign"],[8,"Deref"],[8,"DerefMut"],[8,"Drop"],[8,"Fn"],[8,"FnMut"],[8,"FnOnce"],[8,"Index"],[8,"IndexMut"],[8,"RangeBounds"],[8,"Try"],[8,"Generator"],[3,"Reverse"],[4,"Ordering"],[8,"PartialEq"],[8,"Ord"],[8,"PartialOrd"],[8,"Clone"],[8,"Default"],[8,"AsRef"],[8,"AsMut"],[8,"Into"],[8,"From"],[8,"TryInto"],[8,"TryFrom"],[8,"Borrow"],[8,"BorrowMut"],[8,"Any"],[3,"TypeId"],[8,"FixedSizeArray"],[4,"Ordering"],[3,"AtomicBool"],[3,"AtomicPtr"],[3,"AtomicI8"],[3,"AtomicU8"],[3,"AtomicI16"],[3,"AtomicU16"],[3,"AtomicI32"],[3,"AtomicU32"],[3,"AtomicI64"],[3,"AtomicU64"],[3,"AtomicIsize"],[3,"AtomicUsize"],[3,"Cell"],[3,"RefCell"],[3,"Ref"],[3,"RefMut"],[3,"UnsafeCell"],[3,"UnicodeVersion"],[3,"DecodeUtf16Error"],[3,"PanicInfo"],[3,"Location"],[3,"Pin"],[8,"Iterator"],[8,"Step"],[8,"FromIterator"],[8,"IntoIterator"],[8,"DoubleEndedIterator"],[8,"Extend"],[8,"ExactSizeIterator"],[8,"Sum"],[8,"Product"],[3,"Peekable"],[4,"Option"],[3,"TraitObject"],[4,"Result"],[8,"SliceIndex"],[3,"Iter"],[3,"IterMut"],[3,"ChunksExact"],[3,"ChunksExactMut"],[3,"RChunksExact"],[3,"RChunksExactMut"],[4,"SearchStep"],[8,"Pattern"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"Utf8LossyChunk"],[3,"Utf8Lossy"],[8,"FromStr"],[3,"Utf8Error"],[3,"Chars"],[3,"CharIndices"],[3,"SipHasher"],[8,"Hash"],[8,"Hasher"],[8,"BuildHasher"],[4,"Alignment"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"DebugSet"],[3,"DebugList"],[3,"DebugMap"],[8,"Write"],[8,"Debug"],[8,"Display"],[8,"Octal"],[8,"Binary"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Formatter"],[3,"Duration"],[8,"Future"],[4,"Poll"],[3,"Waker"],[3,"LocalWaker"],[8,"UnsafeWake"],[3,"Excess"],[8,"GlobalAlloc"],[8,"Alloc"],[3,"Layout"],[3,"CannotReallocInPlace"],[3,"CpuidResult"],[3,"int8x8x2_t"],[3,"int8x8x3_t"],[3,"int8x8x4_t"],[3,"uint8x8x2_t"],[3,"uint8x8x3_t"],[3,"uint8x8x4_t"],[3,"poly8x8x2_t"],[3,"poly8x8x3_t"],[3,"poly8x8x4_t"],[3,"int8x16x2_t"],[3,"int8x16x3_t"],[3,"int8x16x4_t"],[3,"uint8x16x2_t"],[3,"uint8x16x3_t"],[3,"uint8x16x4_t"],[3,"poly8x16x2_t"],[3,"poly8x16x3_t"],[3,"poly8x16x4_t"],[3,"TryFromIntError"],[3,"ParseIntError"],[3,"ParseFloatError"],[3,"Discriminant"],[3,"PhantomData"],[3,"Pinned"],[3,"RangeFull"],[3,"TryFromSliceError"],[3,"EscapeDefault"],[3,"BorrowError"],[3,"BorrowMutError"],[3,"ParseCharError"],[3,"CharTryFromError"],[3,"DecodeUtf16"],[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EscapeDebug"],[3,"ToLowercase"],[3,"ToUppercase"],[3,"Repeat"],[3,"RepeatWith"],[3,"Empty"],[3,"Once"],[3,"Rev"],[3,"Cloned"],[3,"Cycle"],[3,"StepBy"],[3,"Chain"],[3,"Zip"],[3,"Map"],[3,"Filter"],[3,"FilterMap"],[3,"Enumerate"],[3,"SkipWhile"],[3,"TakeWhile"],[3,"Skip"],[3,"Take"],[3,"Scan"],[3,"FlatMap"],[3,"Flatten"],[3,"Fuse"],[3,"Inspect"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"NoneError"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[4,"c_void"],[3,"Split"],[3,"SplitMut"],[3,"RSplit"],[3,"RSplitMut"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[3,"RChunks"],[3,"RChunksMut"],[3,"ParseBoolError"],[3,"Bytes"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"SplitN"],[3,"RSplitN"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"Lines"],[3,"LinesAny"],[3,"SplitWhitespace"],[3,"SplitAsciiWhitespace"],[3,"EncodeUtf16"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"Utf8LossyChunksIter"],[3,"BuildHasherDefault"],[3,"Error"],[3,"Arguments"],[3,"LayoutErr"],[3,"AllocErr"],[3,"__m64"],[3,"__m128i"],[3,"__m128"],[3,"__m128d"],[3,"__m256i"],[3,"__m256"],[3,"__m256d"],[3,"float64x1_t"],[3,"float64x2_t"],[3,"poly64x1_t"],[3,"poly64x2_t"],[3,"int8x4_t"],[3,"uint8x4_t"],[3,"int16x2_t"],[3,"uint16x2_t"],[3,"int8x8_t"],[3,"uint8x8_t"],[3,"poly8x8_t"],[3,"int16x4_t"],[3,"uint16x4_t"],[3,"poly16x4_t"],[3,"int32x2_t"],[3,"uint32x2_t"],[3,"float32x2_t"],[3,"int64x1_t"],[3,"uint64x1_t"],[3,"int8x16_t"],[3,"uint8x16_t"],[3,"poly8x16_t"],[3,"int16x8_t"],[3,"uint16x8_t"],[3,"poly16x8_t"],[3,"int32x4_t"],[3,"uint32x4_t"],[3,"float32x4_t"],[3,"int64x2_t"],[3,"uint64x2_t"],[3,"i8x16"],[3,"vector_signed_long"],[3,"vector_unsigned_long"],[3,"vector_bool_long"],[3,"vector_double"]]};
searchIndex["proc_macro"]={"doc":"A support library for macro authors when defining new macros.","items":[[3,"Diagnostic","proc_macro","A structure representing a diagnostic message and associated children messages.",N,N],[3,"TokenStream","","The main type provided by this crate, representing an abstract stream of tokens, or, more specifically, a sequence of token trees. The type provide interfaces for iterating over those token trees and, conversely, collecting a number of token trees into one stream.",N,N],[3,"LexError","","Error returned from `TokenStream::from_str`.",N,N],[3,"Span","","A region of source code, along with macro expansion information.",N,N],[3,"LineColumn","","A line-column pair representing the start or end of a `Span`.",N,N],[12,"line","","The 1-indexed line in the source file on which the span starts or ends (inclusive).",0,N],[12,"column","","The 0-indexed column (in UTF-8 characters) in the source file on which the span starts or ends (inclusive).",0,N],[3,"SourceFile","","The source file of a given `Span`.",N,N],[3,"Group","","A delimited token stream.",N,N],[3,"Punct","","An `Punct` is an single punctuation character like `+`, `-` or `#`.",N,N],[3,"Ident","","An identifier (`ident`).",N,N],[3,"Literal","","A literal string (`\"hello\"`), byte string (`b\"hello\"`), character (`'a'`), byte character (`b'a'`), an integer or floating point number with or without a suffix (`1`, `1u8`, `2.3`, `2.3f32`). Boolean literals like `true` and `false` do not belong here, they are `Ident`s.",N,N],[4,"Level","","An enum representing a diagnostic level.",N,N],[13,"Error","","An error.",1,N],[13,"Warning","","A warning.",1,N],[13,"Note","","A note.",1,N],[13,"Help","","A help message.",1,N],[4,"TokenTree","","A single token or a delimited sequence of token trees (e.g. `[1, (), ..]`).",N,N],[13,"Group","","A token stream surrounded by bracket delimiters.",2,N],[13,"Ident","","An identifier.",2,N],[13,"Punct","","A single punctuation character (`+`, `,`, `$`, etc.).",2,N],[13,"Literal","","A literal character (`'a'`), string (`\"hello\"`), number (`2.3`), etc.",2,N],[4,"Delimiter","","Describes how a sequence of token trees is delimited.",N,N],[13,"Parenthesis","","`( ... )`",3,N],[13,"Brace","","`{ ... }`",3,N],[13,"Bracket","","`[ ... ]`",3,N],[13,"None","","`Ø ... Ø` An implicit delimiter, that may, for example, appear around tokens coming from a \"macro variable\" `$var`. It is important to preserve operator priorities in cases like `$var * 3` where `$var` is `1 + 2`. Implicit delimiters may not survive roundtrip of a token stream through a string.",3,N],[4,"Spacing","","Whether an `Punct` is followed immediately by another `Punct` or followed by another token or whitespace.",N,N],[13,"Alone","","E.g. `+` is `Alone` in `+ =`, `+ident` or `+()`.",4,N],[13,"Joint","","E.g. `+` is `Joint` in `+=` or `'#`. Additionally, single quote `'` can join with identifiers to form lifetimes `'ident`.",4,N],[5,"quote","","Quote a `TokenStream` into a `TokenStream`. This is the actual `quote!()` proc macro.",N,[[["tokenstream"]],["tokenstream"]]],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to implement a custom quoter.",N,[[["span"]],["tokenstream"]]],[11,"new","","Create a new diagnostic with the given `level` and `message`.",5,[[["level"],["t"]],["diagnostic"]]],[11,"spanned","","Create a new diagnostic with the given `level` and `message` pointing to the given set of `spans`.",5,[[["s"],["level"],["t"]],["diagnostic"]]],[11,"span_error","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `spans` and `message`.",5,[[["self"],["s"],["t"]],["diagnostic"]]],[11,"error","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",5,[[["self"],["t"]],["diagnostic"]]],[11,"span_warning","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `spans` and `message`.",5,[[["self"],["s"],["t"]],["diagnostic"]]],[11,"warning","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",5,[[["self"],["t"]],["diagnostic"]]],[11,"span_note","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `spans` and `message`.",5,[[["self"],["s"],["t"]],["diagnostic"]]],[11,"note","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",5,[[["self"],["t"]],["diagnostic"]]],[11,"span_help","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `spans` and `message`.",5,[[["self"],["s"],["t"]],["diagnostic"]]],[11,"help","","Add a new child diagnostic message to `self` with the level identified by this method's name with the given `message`.",5,[[["self"],["t"]],["diagnostic"]]],[11,"level","","Returns the diagnostic `level` for `self`.",5,[[["self"]],["level"]]],[11,"set_level","","Sets the level in `self` to `level`.",5,[[["self"],["level"]]]],[11,"message","","Returns the message in `self`.",5,[[["self"]],["str"]]],[11,"set_message","","Sets the message in `self` to `message`.",5,[[["self"],["t"]]]],[11,"spans","","Returns the `Span`s in `self`.",5,N],[11,"set_spans","","Sets the `Span`s in `self` to `spans`.",5,[[["self"],["s"]]]],[11,"children","","Returns an iterator over the children diagnostics of `self`.",5,[[["self"]],["children"]]],[11,"emit","","Emit the diagnostic.",5,[[["self"]]]],[0,"token_stream","","Public implementation details for the `TokenStream` type, such as iterators.",N,N],[3,"IntoIter","proc_macro::token_stream","An iterator over `TokenStream`'s `TokenTree`s. The iteration is \"shallow\", e.g. the iterator doesn't recurse into delimited groups, and returns whole groups as token trees.",N,N],[8,"MultiSpan","proc_macro","Trait implemented by types that can be converted into a set of `Span`s.",N,N],[10,"into_spans","","Converts `self` into a `Vec<Span>`.",6,[[["self"]],["vec",["span"]]]],[11,"new","","Returns an empty `TokenStream` containing no token trees.",7,[[],["tokenstream"]]],[11,"is_empty","","Checks if this `TokenStream` is empty.",7,[[["self"]],["bool"]]],[11,"def_site","","A span that resolves at the macro definition site.",8,[[],["span"]]],[11,"call_site","","The span of the invocation of the current procedural macro. Identifiers created with this span will be resolved as if they were written directly at the macro call location (call-site hygiene) and other code at the macro call site will be able to refer to them as well.",8,[[],["span"]]],[11,"source_file","","The original source file into which this span points.",8,[[["self"]],["sourcefile"]]],[11,"parent","","The `Span` for the tokens in the previous macro expansion from which `self` was generated from, if any.",8,[[["self"]],["option",["span"]]]],[11,"source","","The span for the origin source code that `self` was generated from. If this `Span` wasn't generated from other macro expansions then the return value is the same as `*self`.",8,[[["self"]],["span"]]],[11,"start","","Get the starting line/column in the source file for this span.",8,[[["self"]],["linecolumn"]]],[11,"end","","Get the ending line/column in the source file for this span.",8,[[["self"]],["linecolumn"]]],[11,"join","","Create a new span encompassing `self` and `other`.",8,[[["self"],["span"]],["option",["span"]]]],[11,"resolved_at","","Creates a new span with the same line/column information as `self` but that resolves symbols as though it were at `other`.",8,[[["self"],["span"]],["span"]]],[11,"located_at","","Creates a new span with the same name resolution behavior as `self` but with the line/column information of `other`.",8,[[["self"],["span"]],["span"]]],[11,"eq","","Compares to spans to see if they're equal.",8,[[["self"],["span"]],["bool"]]],[11,"error","","Create a new `Diagnostic` with the given `message` at the span `self`.",8,[[["self"],["t"]],["diagnostic"]]],[11,"warning","","Create a new `Diagnostic` with the given `message` at the span `self`.",8,[[["self"],["t"]],["diagnostic"]]],[11,"note","","Create a new `Diagnostic` with the given `message` at the span `self`.",8,[[["self"],["t"]],["diagnostic"]]],[11,"help","","Create a new `Diagnostic` with the given `message` at the span `self`.",8,[[["self"],["t"]],["diagnostic"]]],[11,"path","","Get the path to this source file.",9,[[["self"]],["pathbuf"]]],[11,"is_real","","Returns `true` if this source file is a real source file, and not generated by an external macro's expansion.",9,[[["self"]],["bool"]]],[11,"span","","Returns the span of this tree, delegating to the `span` method of the contained token or a delimited stream.",2,[[["self"]],["span"]]],[11,"set_span","","Configures the span for only this token.",2,[[["self"],["span"]]]],[11,"new","","Creates a new `Group` with the given delimiter and token stream.",10,[[["delimiter"],["tokenstream"]],["group"]]],[11,"delimiter","","Returns the delimiter of this `Group`",10,[[["self"]],["delimiter"]]],[11,"stream","","Returns the `TokenStream` of tokens that are delimited in this `Group`.",10,[[["self"]],["tokenstream"]]],[11,"span","","Returns the span for the delimiters of this token stream, spanning the entire `Group`.",10,[[["self"]],["span"]]],[11,"span_open","","Returns the span pointing to the opening delimiter of this group.",10,[[["self"]],["span"]]],[11,"span_close","","Returns the span pointing to the closing delimiter of this group.",10,[[["self"]],["span"]]],[11,"set_span","","Configures the span for this `Group`'s delimiters, but not its internal tokens.",10,[[["self"],["span"]]]],[11,"new","","Creates a new `Punct` from the given character and spacing. The `ch` argument must be a valid punctuation character permitted by the language, otherwise the function will panic.",11,[[["char"],["spacing"]],["punct"]]],[11,"as_char","","Returns the value of this punctuation character as `char`.",11,[[["self"]],["char"]]],[11,"spacing","","Returns the spacing of this punctuation character, indicating whether it's immediately followed by another `Punct` in the token stream, so they can potentially be combined into a multicharacter operator (`Joint`), or it's followed by some other token or whitespace (`Alone`) so the operator has certainly ended.",11,[[["self"]],["spacing"]]],[11,"span","","Returns the span for this punctuation character.",11,[[["self"]],["span"]]],[11,"set_span","","Configure the span for this punctuation character.",11,[[["self"],["span"]]]],[11,"new","","Creates a new `Ident` with the given `string` as well as the specified `span`. The `string` argument must be a valid identifier permitted by the language, otherwise the function will panic.",12,[[["str"],["span"]],["ident"]]],[11,"new_raw","","Same as `Ident::new`, but creates a raw identifier (`r#ident`).",12,[[["str"],["span"]],["ident"]]],[11,"span","","Returns the span of this `Ident`, encompassing the entire string returned by `as_str`.",12,[[["self"]],["span"]]],[11,"set_span","","Configures the span of this `Ident`, possibly changing its hygiene context.",12,[[["self"],["span"]]]],[11,"u8_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["u8"]],["literal"]]],[11,"u16_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["u16"]],["literal"]]],[11,"u32_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["u32"]],["literal"]]],[11,"u64_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["u64"]],["literal"]]],[11,"u128_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["u128"]],["literal"]]],[11,"usize_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["usize"]],["literal"]]],[11,"i8_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["i8"]],["literal"]]],[11,"i16_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["i16"]],["literal"]]],[11,"i32_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["i32"]],["literal"]]],[11,"i64_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["i64"]],["literal"]]],[11,"i128_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["i128"]],["literal"]]],[11,"isize_suffixed","","Creates a new suffixed integer literal with the specified value.",13,[[["isize"]],["literal"]]],[11,"u8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["u8"]],["literal"]]],[11,"u16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["u16"]],["literal"]]],[11,"u32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["u32"]],["literal"]]],[11,"u64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["u64"]],["literal"]]],[11,"u128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["u128"]],["literal"]]],[11,"usize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["usize"]],["literal"]]],[11,"i8_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["i8"]],["literal"]]],[11,"i16_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["i16"]],["literal"]]],[11,"i32_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["i32"]],["literal"]]],[11,"i64_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["i64"]],["literal"]]],[11,"i128_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["i128"]],["literal"]]],[11,"isize_unsuffixed","","Creates a new unsuffixed integer literal with the specified value.",13,[[["isize"]],["literal"]]],[11,"f32_unsuffixed","","Creates a new unsuffixed floating-point literal.",13,[[["f32"]],["literal"]]],[11,"f32_suffixed","","Creates a new suffixed floating-point literal.",13,[[["f32"]],["literal"]]],[11,"f64_unsuffixed","","Creates a new unsuffixed floating-point literal.",13,[[["f64"]],["literal"]]],[11,"f64_suffixed","","Creates a new suffixed floating-point literal.",13,[[["f64"]],["literal"]]],[11,"string","","String literal.",13,[[["str"]],["literal"]]],[11,"character","","Character literal.",13,[[["char"]],["literal"]]],[11,"byte_string","","Byte string literal.",13,N],[11,"span","","Returns the span encompassing this literal.",13,[[["self"]],["span"]]],[11,"set_span","","Configures the span associated for this literal.",13,[[["self"],["span"]]]],[14,"quote","","`quote!(..)` accepts arbitrary tokens and expands into a `TokenStream` describing the input. For example, `quote!(a + b)` will produce a expression, that, when evaluated, constructs the `TokenStream` `[Ident(\"a\"), Punct('+', Alone), Ident(\"b\")]`.",N,N],[11,"from","","",5,[[["t"]],["t"]]],[11,"into","","",5,[[["self"]],["u"]]],[11,"to_owned","","",5,[[["self"]],["t"]]],[11,"clone_into","","",5,N],[11,"try_from","","",5,[[["u"]],["result"]]],[11,"borrow","","",5,[[["self"]],["t"]]],[11,"try_into","","",5,[[["self"]],["result"]]],[11,"borrow_mut","","",5,[[["self"]],["t"]]],[11,"get_type_id","","",5,[[["self"]],["typeid"]]],[11,"not_found","","",5,[[["str"],["str"]],["e"]]],[11,"from","","",7,[[["t"]],["t"]]],[11,"into","","",7,[[["self"]],["u"]]],[11,"to_string","","",7,[[["self"]],["string"]]],[11,"to_owned","","",7,[[["self"]],["t"]]],[11,"clone_into","","",7,N],[11,"into_iter","","",7,[[["self"]],["i"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"try_into","","",7,[[["self"]],["result"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"get_type_id","","",7,[[["self"]],["typeid"]]],[11,"not_found","","",7,[[["str"],["str"]],["e"]]],[11,"from","","",14,[[["t"]],["t"]]],[11,"into","","",14,[[["self"]],["u"]]],[11,"try_from","","",14,[[["u"]],["result"]]],[11,"borrow","","",14,[[["self"]],["t"]]],[11,"try_into","","",14,[[["self"]],["result"]]],[11,"borrow_mut","","",14,[[["self"]],["t"]]],[11,"get_type_id","","",14,[[["self"]],["typeid"]]],[11,"not_found","","",14,[[["str"],["str"]],["e"]]],[11,"from","","",8,[[["t"]],["t"]]],[11,"into","","",8,[[["self"]],["u"]]],[11,"to_owned","","",8,[[["self"]],["t"]]],[11,"clone_into","","",8,N],[11,"try_from","","",8,[[["u"]],["result"]]],[11,"borrow","","",8,[[["self"]],["t"]]],[11,"try_into","","",8,[[["self"]],["result"]]],[11,"borrow_mut","","",8,[[["self"]],["t"]]],[11,"get_type_id","","",8,[[["self"]],["typeid"]]],[11,"not_found","","",8,[[["str"],["str"]],["e"]]],[11,"from","","",0,[[["t"]],["t"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"to_owned","","",0,[[["self"]],["t"]]],[11,"clone_into","","",0,N],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"not_found","","",0,[[["str"],["str"]],["e"]]],[11,"from","","",9,[[["t"]],["t"]]],[11,"into","","",9,[[["self"]],["u"]]],[11,"to_owned","","",9,[[["self"]],["t"]]],[11,"clone_into","","",9,N],[11,"try_from","","",9,[[["u"]],["result"]]],[11,"borrow","","",9,[[["self"]],["t"]]],[11,"try_into","","",9,[[["self"]],["result"]]],[11,"borrow_mut","","",9,[[["self"]],["t"]]],[11,"get_type_id","","",9,[[["self"]],["typeid"]]],[11,"not_found","","",9,[[["str"],["str"]],["e"]]],[11,"from","","",10,[[["t"]],["t"]]],[11,"into","","",10,[[["self"]],["u"]]],[11,"to_string","","",10,[[["self"]],["string"]]],[11,"to_owned","","",10,[[["self"]],["t"]]],[11,"clone_into","","",10,N],[11,"try_from","","",10,[[["u"]],["result"]]],[11,"borrow","","",10,[[["self"]],["t"]]],[11,"try_into","","",10,[[["self"]],["result"]]],[11,"borrow_mut","","",10,[[["self"]],["t"]]],[11,"get_type_id","","",10,[[["self"]],["typeid"]]],[11,"not_found","","",10,[[["str"],["str"]],["e"]]],[11,"from","","",11,[[["t"]],["t"]]],[11,"into","","",11,[[["self"]],["u"]]],[11,"to_string","","",11,[[["self"]],["string"]]],[11,"to_owned","","",11,[[["self"]],["t"]]],[11,"clone_into","","",11,N],[11,"try_from","","",11,[[["u"]],["result"]]],[11,"borrow","","",11,[[["self"]],["t"]]],[11,"try_into","","",11,[[["self"]],["result"]]],[11,"borrow_mut","","",11,[[["self"]],["t"]]],[11,"get_type_id","","",11,[[["self"]],["typeid"]]],[11,"not_found","","",11,[[["str"],["str"]],["e"]]],[11,"from","","",12,[[["t"]],["t"]]],[11,"into","","",12,[[["self"]],["u"]]],[11,"to_string","","",12,[[["self"]],["string"]]],[11,"to_owned","","",12,[[["self"]],["t"]]],[11,"clone_into","","",12,N],[11,"try_from","","",12,[[["u"]],["result"]]],[11,"borrow","","",12,[[["self"]],["t"]]],[11,"try_into","","",12,[[["self"]],["result"]]],[11,"borrow_mut","","",12,[[["self"]],["t"]]],[11,"get_type_id","","",12,[[["self"]],["typeid"]]],[11,"not_found","","",12,[[["str"],["str"]],["e"]]],[11,"from","","",13,[[["t"]],["t"]]],[11,"into","","",13,[[["self"]],["u"]]],[11,"to_string","","",13,[[["self"]],["string"]]],[11,"to_owned","","",13,[[["self"]],["t"]]],[11,"clone_into","","",13,N],[11,"try_from","","",13,[[["u"]],["result"]]],[11,"borrow","","",13,[[["self"]],["t"]]],[11,"try_into","","",13,[[["self"]],["result"]]],[11,"borrow_mut","","",13,[[["self"]],["t"]]],[11,"get_type_id","","",13,[[["self"]],["typeid"]]],[11,"not_found","","",13,[[["str"],["str"]],["e"]]],[11,"from","","",1,[[["t"]],["t"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"to_owned","","",1,[[["self"]],["t"]]],[11,"clone_into","","",1,N],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"not_found","","",1,[[["str"],["str"]],["e"]]],[11,"from","","",2,[[["t"]],["t"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"to_string","","",2,[[["self"]],["string"]]],[11,"to_owned","","",2,[[["self"]],["t"]]],[11,"clone_into","","",2,N],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"not_found","","",2,[[["str"],["str"]],["e"]]],[11,"from","","",3,[[["t"]],["t"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"to_owned","","",3,[[["self"]],["t"]]],[11,"clone_into","","",3,N],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]],[11,"not_found","","",3,[[["str"],["str"]],["e"]]],[11,"from","","",4,[[["t"]],["t"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"to_owned","","",4,[[["self"]],["t"]]],[11,"clone_into","","",4,N],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"not_found","","",4,[[["str"],["str"]],["e"]]],[11,"from","proc_macro::token_stream","",15,[[["t"]],["t"]]],[11,"into","","",15,[[["self"]],["u"]]],[11,"to_owned","","",15,[[["self"]],["t"]]],[11,"clone_into","","",15,N],[11,"into_iter","","",15,[[["self"]],["i"]]],[11,"try_from","","",15,[[["u"]],["result"]]],[11,"borrow","","",15,[[["self"]],["t"]]],[11,"try_into","","",15,[[["self"]],["result"]]],[11,"borrow_mut","","",15,[[["self"]],["t"]]],[11,"get_type_id","","",15,[[["self"]],["typeid"]]],[11,"not_found","","",15,[[["str"],["str"]],["e"]]],[11,"into_spans","proc_macro","",8,[[["self"]],["vec",["span"]]]],[11,"clone","","",1,[[["self"]],["level"]]],[11,"clone","","",5,[[["self"]],["diagnostic"]]],[11,"clone","","",7,[[["self"]],["tokenstream"]]],[11,"clone","proc_macro::token_stream","",15,[[["self"]],["intoiter"]]],[11,"clone","proc_macro","",8,[[["self"]],["span"]]],[11,"clone","","",0,[[["self"]],["linecolumn"]]],[11,"clone","","",9,[[["self"]],["sourcefile"]]],[11,"clone","","",2,[[["self"]],["tokentree"]]],[11,"clone","","",10,[[["self"]],["group"]]],[11,"clone","","",3,[[["self"]],["delimiter"]]],[11,"clone","","",11,[[["self"]],["punct"]]],[11,"clone","","",4,[[["self"]],["spacing"]]],[11,"clone","","",12,[[["self"]],["ident"]]],[11,"clone","","",13,[[["self"]],["literal"]]],[11,"extend","","",7,[[["self"],["i"]]]],[11,"extend","","",7,[[["self"],["i"]]]],[11,"from","","",7,[[["tokentree"]],["tokenstream"]]],[11,"from","","",2,[[["group"]],["tokentree"]]],[11,"from","","",2,[[["ident"]],["tokentree"]]],[11,"from","","",2,[[["punct"]],["tokentree"]]],[11,"from","","",2,[[["literal"]],["tokentree"]]],[11,"next","proc_macro::token_stream","",15,[[["self"]],["option",["tokentree"]]]],[11,"eq","proc_macro","",0,[[["self"],["linecolumn"]],["bool"]]],[11,"ne","","",0,[[["self"],["linecolumn"]],["bool"]]],[11,"eq","","",9,[[["self"],["self"]],["bool"]]],[11,"eq","","",3,[[["self"],["delimiter"]],["bool"]]],[11,"eq","","",4,[[["self"],["spacing"]],["bool"]]],[11,"into_iter","","",7,[[["self"]],["intoiter"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",14,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",8,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",9,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",7,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",10,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",11,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",12,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",13,[[["self"],["formatter"]],["result"]]],[11,"from_iter","","",7,[[["i"]],["self"]]],[11,"from_iter","","",7,[[["i"]],["self"]]],[11,"from_str","","",7,[[["str"]],["result",["tokenstream","lexerror"]]]]],"paths":[[3,"LineColumn"],[4,"Level"],[4,"TokenTree"],[4,"Delimiter"],[4,"Spacing"],[3,"Diagnostic"],[8,"MultiSpan"],[3,"TokenStream"],[3,"Span"],[3,"SourceFile"],[3,"Group"],[3,"Punct"],[3,"Ident"],[3,"Literal"],[3,"LexError"],[3,"IntoIter"]]};
searchIndex["std"]={"doc":"The Rust Standard Library","items":[[14,"assert_eq","std","Asserts that two expressions are equal to each other (using [`PartialEq`]).",N,N],[14,"assert_ne","","Asserts that two expressions are not equal to each other (using [`PartialEq`]).",N,N],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",N,N],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",N,N],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",N,N],[14,"unreachable","","A utility macro for indicating unreachable code.",N,N],[14,"unimplemented","","A standardized placeholder for marking unfinished code.",N,N],[14,"write","","Write formatted data into a buffer.",N,N],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",N,N],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together with converting downstream errors.",N,N],[0,"any","","This module implements the `Any` trait, which enables dynamic typing of any `'static` type through runtime reflection.",N,N],[8,"Any","std::any","A type to emulate dynamic typing.",N,N],[10,"get_type_id","","Gets the `TypeId` of `self`.",0,[[["self"]],["typeid"]]],[3,"TypeId","","A `TypeId` represents a globally unique identifier for a type.",N,N],[0,"cell","std","Shareable mutable containers.",N,N],[3,"Cell","std::cell","A mutable memory location.",N,N],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",N,N],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",N,N],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",N,N],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box. A wrapper type for an immutably borrowed value from a `RefCell<T>`.",N,N],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell<T>`.",N,N],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",N,N],[0,"clone","std","The `Clone` trait for types that cannot be 'implicitly copied'.",N,N],[8,"Clone","std::clone","A common trait for the ability to explicitly duplicate an object.",N,N],[10,"clone","","Returns a copy of the value.",1,[[["self"]],["self"]]],[11,"clone_from","","Performs copy-assignment from `source`.",1,N],[0,"cmp","std","Functionality for ordering and comparison.",N,N],[8,"PartialEq","std::cmp","Trait for equality comparisons which are partial equivalence relations.",N,N],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used by `==`.",2,[[["self"],["rhs"]],["bool"]]],[11,"ne","","This method tests for `!=`.",2,[[["self"],["rhs"]],["bool"]]],[8,"Eq","","Trait for equality comparisons which are equivalence relations.",N,N],[4,"Ordering","","An `Ordering` is the result of a comparison between two values.",N,N],[13,"Less","","An ordering where a compared value is less [than another].",3,N],[13,"Equal","","An ordering where a compared value is equal [to another].",3,N],[13,"Greater","","An ordering where a compared value is greater [than another].",3,N],[3,"Reverse","","A helper struct for reverse ordering.",N,N],[12,"0","","",4,N],[8,"Ord","","Trait for types that form a total order.",N,N],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",5,[[["self"],["self"]],["ordering"]]],[11,"max","","Compares and returns the maximum of two values.",5,[[["self"],["self"]],["self"]]],[11,"min","","Compares and returns the minimum of two values.",5,[[["self"],["self"]],["self"]]],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",N,N],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",6,[[["self"],["rhs"]],["option",["ordering"]]]],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `<` operator.",6,[[["self"],["rhs"]],["bool"]]],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `<=` operator.",6,[[["self"],["rhs"]],["bool"]]],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `>` operator.",6,[[["self"],["rhs"]],["bool"]]],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `>=` operator.",6,[[["self"],["rhs"]],["bool"]]],[5,"min","","Compares and returns the minimum of two values.",N,[[["t"],["t"]],["t"]]],[5,"max","","Compares and returns the maximum of two values.",N,[[["t"],["t"]],["t"]]],[0,"convert","std","Traits for conversions between types.",N,N],[5,"identity","std::convert","An identity function.",N,[[["t"]],["t"]]],[8,"AsRef","","A cheap reference-to-reference conversion. Used to convert a value to a reference value within generic code.",N,N],[10,"as_ref","","Performs the conversion.",7,[[["self"]],["t"]]],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",N,N],[10,"as_mut","","Performs the conversion.",8,[[["self"]],["t"]]],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive. The reciprocal of [`From`][From].",N,N],[10,"into","","Performs the conversion.",9,[[["self"]],["t"]]],[8,"From","","Simple and safe type conversions in to `Self`. It is the reciprocal of `Into`.",N,N],[10,"from","","Performs the conversion.",10,[[["t"]],["self"]]],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",N,N],[16,"Error","","The type returned in the event of a conversion error.",11,N],[10,"try_into","","Performs the conversion.",11,[[["self"]],["result"]]],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",N,N],[16,"Error","","The type returned in the event of a conversion error.",12,N],[10,"try_from","","Performs the conversion.",12,[[["t"]],["result"]]],[0,"default","std","The `Default` trait for types which may have meaningful default values.",N,N],[8,"Default","std::default","A trait for giving a type a useful default value.",N,N],[10,"default","","Returns the \"default value\" for a type.",13,[[],["self"]]],[0,"hash","std","Generic hashing support.",N,N],[8,"Hash","std::hash","A hashable type.",N,N],[10,"hash","","Feeds this value into the given [`Hasher`].",14,N],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",14,N],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",N,N],[10,"finish","","Returns the hash value for the values written so far.",15,[[["self"]],["u64"]]],[10,"wri