#![allow(unused_variables)]

use std::mem;
use std::cell::Cell;

// Make sure &mut UnsafeCell also is exclusive
pub fn safe(x: &i32, y: &mut Cell<i32>) {} //~ ERROR barrier

fn main() {
    let mut x = 0;
    let xref = &mut x;
    let xraw: *mut i32 = unsafe { mem::transmute_copy(&xref) };
    let xshr = &*xref;
    // transmute fn ptr around so that we can avoid retagging
    let safe_raw: fn(x: *const i32, y: *mut Cell<i32>) = unsafe {
        mem::transmute::<fn(&i32, &mut Cell<i32>), _>(safe)
    };
    safe_raw(xshr, xraw as *mut _);
}
