# Command-line arguments

Here's a list of command-line arguments to `rustc` and what they do.

## `-h`/`--help`: get help

This flag will print out help information for `rustc`.

## `--cfg`: configure the compilation environment

This flag can turn on or off various `#[cfg]` settings.

The value can either be a single identifier or two identifiers separated by `=`.

For examples, `--cfg 'verbose'` or `--cfg 'feature="serde"'`. These correspond
to `#[cfg(verbose)]` and `#[cfg(feature = "serde")]` respectively.

## `-L`: add a directory to the library search path

When looking for external crates or libraries, a directory passed to this flag
will be searched.

The kind of search path can optionally be specified with the form `-L
KIND=PATH` where `KIND` may be one of:

- `dependency` — Only search for transitive dependencies in this directory.
- `crate` — Only search for this crate's direct dependencies in this
  directory.
- `native` — Only search for native libraries in this directory.
- `framework` — Only search for macOS frameworks in this directory.
- `all` — Search for all library kinds in this directory. This is the default
  if `KIND` is not specified.

## `-l`: link the generated crate to a native library

This flag allows you to specify linking to a specific native library when building
a crate.

The kind of library can optionally be specified with the form `-l KIND=lib`
where `KIND` may be one of:

- `dylib` — A native dynamic library.
- `static` — A native static library (such as a `.a` archive).
- `framework` — A macOS framework.

The kind of library can be specified in a [`#[link]`
attribute][link-attribute]. If the kind is not specified in the `link`
attribute or on the command-line, it will link a dynamic library if available,
otherwise it will use a static library. If the kind is specified on the
command-line, it will override the kind specified in a `link` attribute.

The name used in a `link` attribute may be overridden using the form `-l
ATTR_NAME:LINK_NAME` where `ATTR_NAME` is the name in the `link` attribute,
and `LINK_NAME` is the name of the actual library that will be linked.

[link-attribute]: ../reference/items/external-blocks.html#the-link-attribute

## `--crate-type`: a list of types of crates for the compiler to emit

This instructs `rustc` on which crate type to build. This flag accepts a
comma-separated list of values, and may be specified multiple times. The valid
crate types are:

- `lib` — Generates a library kind preferred by the compiler, currently
  defaults to `rlib`.
- `rlib` — A Rust static library.
- `staticlib` — A native static library.
- `dylib` — A Rust dynamic library.
- `cdylib` — A native dynamic library.
- `bin` — A runnable executable program.
- `proc-macro` — Generates a format suitable for a procedural macro library
  that may be loaded by the compiler.

The crate type may be specified with the [`crate_type` attribute][crate_type].
The `--crate-type` command-line value will override the `crate_type`
attribute.

More details may be found in the [linkage chapter] of the reference.

[linkage chapter]: ../reference/linkage.html
[crate_type]: ../reference/linkage.html

## `--crate-name`: specify the name of the crate being built

This informs `rustc` of the name of your crate.

## `--edition`: specify the edition to use

This flag takes a value of `2015` or `2018`. The default is `2015`. More
information about editions may be found in the [edition guide].

[edition guide]: ../edition-guide/introduction.html

## `--emit`: specifies the types of output files to generate

This flag controls the types of output files generated by the compiler. It
accepts a comma-separated list of values, and may be specified multiple times.
The valid emit kinds are:

- `asm` — Generates a file with the crate's assembly code. The default output
  filename is `CRATE_NAME.s`.
- `dep-info` — Generates a file with Makefile syntax that indicates all the
  source files that were loaded to generate the crate. The default output
  filename is `CRATE_NAME.d`.
- `link` — Generates the crates specified by `--crate-type`. The default
  output filenames depend on the crate type and platform. This is the default
  if `--emit` is not specified.
- `llvm-bc` — Generates a binary file containing the [LLVM bitcode]. The
  default output filename is `CRATE_NAME.bc`.
- `llvm-ir` — Generates a file containing [LLVM IR]. The default output
  filename is `CRATE_NAME.ll`.
- `metadata` — Generates a file containing metadata about the crate. The
  default output filename is `CRATE_NAME.rmeta`.
- `mir` — Generates a file containing rustc's mid-level intermediate
  representation. The default output filename is `CRATE_NAME.mir`.
- `obj` — Generates a native object file. The default output filename is
  `CRATE_NAME.o`.

The output filename can be set with the `-o` flag. A suffix may be added to
the filename with the `-C extra-filename` flag. The files are written to the
current directory unless the `--out-dir` flag is used. Each emission type may
also specify the output filename with the form `KIND=PATH`, which takes
precedence over the `-o` flag.

[LLVM bitcode]: https://llvm.org/docs/BitCodeFormat.html
[LLVM IR]: https://llvm.org/docs/LangRef.html

## `--print`: print compiler information

This flag prints out various information about the compiler. This flag may be
specified multiple times, and the information is printed in the order the
flags are specified. Specifying a `--print` flag will usually disable the
`--emit` step and will only print the requested information. The valid types
of print values are:

- `crate-name` — The name of the crate.
- `file-names` — The names of the files created by the `link` emit kind.
- `sysroot` — Path to the sysroot.
- `cfg` — List of cfg values. See [conditional compilation] for more
  information about cfg values.
- `target-list` — List of known targets. The target may be selected with the
  `--target` flag.
- `target-cpus` — List of available CPU values for the current target. The
  target CPU may be selected with the `-C target-cpu=val` flag.
- `target-features` — List of available target features for the current
  target. Target features may be enabled with the `-C target-feature=val`
  flag.
- `relocation-models` — List of relocation models. Relocation models may be
  selected with the `-C relocation-model=val` flag.
- `code-models` — List of code models. Code models may be selected with the
  `-C code-model=val` flag.
- `tls-models` — List of Thread Local Storage models supported. The model may
  be selected with the `-Z tls-model=val` flag.
- `native-static-libs` — This may be used when creating a `staticlib` crate
  type. If this is the only flag, it will perform a full compilation and
  include a diagnostic note that indicates the linker flags to use when
  linking the resulting static library. The note starts with the text
  `native-static-libs:` to make it easier to fetch the output.

[conditional compilation]: ../reference/conditional-compilation.html

## `-g`: include debug information

A synonym for `-C debuginfo=2`, for more see [here](codegen-options/index.html#debuginfo).

## `-O`: optimize your code

A synonym for `-C opt-level=2`, for more see [here](codegen-options/index.html#opt-level).

## `-o`: filename of the output

This flag controls the output filename.

## `--out-dir`: directory to write the output in

The outputted crate will be written to this directory. This flag is ignored if
the `-o` flag is used.

## `--explain`: provide a detailed explanation of an error message

Each error of `rustc`'s comes with an error code; this will print
out a longer explanation of a given error.

## `--test`: build a test harness

When compiling this crate, `rustc` will ignore your `main` function
and instead produce a test harness.

## `--target`: select a target triple to build

This controls which [target](targets/index.html) to produce.

## `-W`: set lint warnings

This flag will set which lints should be set to the [warn level](lints/levels.html#warn).

## `-A`: set lint allowed

This flag will set which lints should be set to the [allow level](lints/levels.html#allow).

## `-D`: set lint denied

This flag will set which lints should be set to the [deny level](lints/levels.html#deny).

## `-F`: set lint forbidden

This flag will set which lints should be set to the [forbid level](lints/levels.html#forbid).

## `-Z`: set unstable options

This flag will allow you to set unstable options of rustc. In order to set multiple options,
the -Z flag can be used multiple times. For example: `rustc -Z verbose -Z time`.
Specifying options with -Z is only available on nightly. To view all available options
run: `rustc -Z help`.

## `--cap-lints`: set the most restrictive lint level

This flag lets you 'cap' lints, for more, [see here](lints/levels.html#capping-lints).

## `-C`/`--codegen`: code generation options

This flag will allow you to set [codegen options](codegen-options/index.html).

## `-V`/`--version`: print a version

This flag will print out `rustc`'s version.

## `-v`/`--verbose`: use verbose output

This flag, when combined with other flags, makes them produce extra output.

## `--extern`: specify where an external library is located

This flag allows you to pass the name and location of an external crate that
will be linked into the crate you are building. This flag may be specified
multiple times. The format of the value should be `CRATENAME=PATH`.

## `--sysroot`: Override the system root

The "sysroot" is where `rustc` looks for the crates that come with the Rust
distribution; this flag allows that to be overridden.

## `--error-format`: control how errors are produced

This flag lets you control the format of messages. Messages are printed to
stderr. The valid options are:

- `human` — Human-readable output. This is the default.
- `json` — Structured JSON output.
- `short` — Short, one-line messages.

## `--color`: configure coloring of output

This flag lets you control color settings of the output. The valid options
are:

- `auto` — Use colors if output goes to a tty. This is the default.
- `always` — Always use colors.
- `never` — Never colorize output.

## `--remap-path-prefix`: remap source names in output

Remap source path prefixes in all output, including compiler diagnostics,
debug information, macro expansions, etc. It takes a value of the form
`FROM=TO` where a path prefix equal to `FROM` is rewritten to the value `TO`.
The `FROM` may itself contain an `=` symbol, but the `TO` value may not. This
flag may be specified multiple times.

This is useful for normalizing build products, for example by removing the
current directory out of pathnames emitted into the object files. The
replacement is purely textual, with no consideration of the current system's
pathname syntax. For example `--remap-path-prefix foo=bar` will match
`foo/lib.rs` but not `./foo/lib.rs`.
