Object.assign(window.search, {"doc_urls":["introduction.html#introduction","editions/index.html#what-are-editions","editions/index.html#compatibility","editions/creating-a-new-project.html#creating-a-new-project","editions/transitioning-an-existing-project-to-a-new-edition.html#transitioning-an-existing-project-to-a-new-edition","editions/transitioning-an-existing-project-to-a-new-edition.html#updating-your-code-to-be-compatible-with-the-new-edition","editions/transitioning-an-existing-project-to-a-new-edition.html#enabling-the-new-edition-to-use-new-features","editions/transitioning-an-existing-project-to-a-new-edition.html#writing-idiomatic-code-in-a-new-edition","rust-2015/index.html#rust-2015","rust-2018/index.html#rust-2018","rust-2018/edition-changes.html#2018-specific-changes","rust-2018/edition-changes.html#cargo","rust-2018/module-system/index.html#module-system","rust-2018/module-system/raw-identifiers.html#raw-identifiers","rust-2018/module-system/raw-identifiers.html#motivation","rust-2018/module-system/raw-identifiers.html#new-keywords","rust-2018/module-system/raw-identifiers.html#async-and-await","rust-2018/module-system/raw-identifiers.html#try","rust-2018/module-system/path-clarity.html#path-clarity","rust-2018/module-system/path-clarity.html#more-details","rust-2018/module-system/path-clarity.html#no-more-extern-crate","rust-2018/module-system/path-clarity.html#the-crate-keyword-refers-to-the-current-crate","rust-2018/module-system/path-clarity.html#extern-crate-paths","rust-2018/module-system/path-clarity.html#no-more-modrs","rust-2018/module-system/path-clarity.html#use-paths","rust-2018/module-system/more-visibility-modifiers.html#more-visibility-modifiers","rust-2018/module-system/nested-imports-with-use.html#nested-imports-with-use","rust-2018/error-handling-and-panics/index.html#error-handling-and-panics","rust-2018/error-handling-and-panics/the-question-mark-operator-for-easier-error-handling.html#the--operator-for-easier-error-handling","rust-2018/error-handling-and-panics/question-mark-in-main-and-tests.html#-in-main-and-tests","rust-2018/error-handling-and-panics/question-mark-in-main-and-tests.html#more-details","rust-2018/error-handling-and-panics/controlling-panics-with-std-panic.html#controlling-panics-with-stdpanic","rust-2018/error-handling-and-panics/aborting-on-panic.html#aborting-on-panic","rust-2018/control-flow/index.html#control-flow","rust-2018/control-flow/loops-can-break-with-a-value.html#loops-can-break-with-a-value","rust-2018/control-flow/async-await-for-easier-concurrency.html#asyncawait-for-easier-concurrency","rust-2018/trait-system/index.html#trait-system","rust-2018/trait-system/impl-trait-for-returning-complex-types-with-ease.html#impl-trait-for-returning-complex-types-with-ease","rust-2018/trait-system/impl-trait-for-returning-complex-types-with-ease.html#argument-position","rust-2018/trait-system/impl-trait-for-returning-complex-types-with-ease.html#return-position","rust-2018/trait-system/impl-trait-for-returning-complex-types-with-ease.html#impl-trait-and-closures","rust-2018/trait-system/impl-trait-for-returning-complex-types-with-ease.html#more-details","rust-2018/trait-system/impl-trait-for-returning-complex-types-with-ease.html#using-impl-trait-in-more-places","rust-2018/trait-system/dyn-trait-for-trait-objects.html#dyn-trait-for-trait-objects","rust-2018/trait-system/dyn-trait-for-trait-objects.html#more-details","rust-2018/trait-system/more-container-types-support-trait-objects.html#more-container-types-support-trait-objects","rust-2018/trait-system/associated-constants.html#associated-constants","rust-2018/trait-system/no-anon-params.html#no-more-anonymous-trait-parameters","rust-2018/slice-patterns.html#slice-patterns","rust-2018/slice-patterns.html#more-details","rust-2018/slice-patterns.html#exhaustive-patterns","rust-2018/slice-patterns.html#arrays-and-exact-lengths","rust-2018/slice-patterns.html#in-the-pipeline","rust-2018/ownership-and-lifetimes/index.html#ownership-and-lifetimes","rust-2018/ownership-and-lifetimes/non-lexical-lifetimes.html#non-lexical-lifetimes","rust-2018/ownership-and-lifetimes/non-lexical-lifetimes.html#better-errors","rust-2018/ownership-and-lifetimes/default-match-bindings.html#default-match-bindings","rust-2018/ownership-and-lifetimes/default-match-bindings.html#more-details","rust-2018/ownership-and-lifetimes/the-anonymous-lifetime.html#_-the-anonymous-lifetime","rust-2018/ownership-and-lifetimes/the-anonymous-lifetime.html#more-details","rust-2018/ownership-and-lifetimes/lifetime-elision-in-impl.html#lifetime-elision-in-impl","rust-2018/ownership-and-lifetimes/inference-in-structs.html#t-a-inference-in-structs","rust-2018/ownership-and-lifetimes/inference-in-structs.html#more-details","rust-2018/ownership-and-lifetimes/simpler-lifetimes-in-static-and-const.html#simpler-lifetimes-in-static-and-const","rust-2018/data-types/index.html#data-types","rust-2018/data-types/field-init-shorthand.html#field-init-shorthand","rust-2018/data-types/inclusive-ranges.html#-for-inclusive-ranges","rust-2018/data-types/128-bit-integers.html#128-bit-integers","rust-2018/data-types/operator-equals-are-now-implementable.html#operator-equals-are-now-implementable","rust-2018/data-types/union-for-an-unsafe-form-of-enum.html#union-for-an-unsafe-form-of-enum","rust-2018/data-types/choosing-alignment-with-the-repr-attribute.html#choosing-alignment-with-the-repr-attribute","rust-2018/simd-for-faster-computing.html#simd-for-faster-computing","rust-2018/macros/index.html#macros","rust-2018/macros/custom-derive.html#custom-derive","rust-2018/macros/macro-changes.html#macro-changes","rust-2018/macros/macro-changes.html#macro_rules-style-macros","rust-2018/macros/macro-changes.html#procedural-macros","rust-2018/macros/macro-changes.html#more-details","rust-2018/macros/macro-changes.html#local-helper-macros","rust-2018/macros/at-most-once.html#at-most-one-repetition","rust-2018/the-compiler/index.html#the-compiler","rust-2018/the-compiler/improved-error-messages.html#improved-error-messages","rust-2018/the-compiler/incremental-compilation-for-faster-compiles.html#incremental-compilation","rust-2018/the-compiler/an-attribute-for-deprecation.html#an-attribute-for-deprecation","rust-2018/rustup-for-managing-rust-versions.html#rustup-for-managing-rust-versions","rust-2018/rustup-for-managing-rust-versions.html#for-installing-rust","rust-2018/rustup-for-managing-rust-versions.html#for-updating-your-installation","rust-2018/rustup-for-managing-rust-versions.html#managing-versions","rust-2018/rustup-for-managing-rust-versions.html#installing-other-targets","rust-2018/rustup-for-managing-rust-versions.html#installing-components","rust-2018/rustup-for-managing-rust-versions.html#rust-docs-for-local-documentation","rust-2018/rustup-for-managing-rust-versions.html#rust-src-for-a-copy-of-rusts-source-code","rust-2018/rustup-for-managing-rust-versions.html#rustfmt-for-automatic-code-formatting","rust-2018/rustup-for-managing-rust-versions.html#rls-for-ide-integration","rust-2018/rustup-for-managing-rust-versions.html#clippy-for-more-lints","rust-2018/rustup-for-managing-rust-versions.html#the-preview-components","rust-2018/cargo-and-crates-io/index.html#cargo-and-cratesio","rust-2018/cargo-and-crates-io/cargo-check-for-faster-checking.html#cargo-check-for-faster-checking","rust-2018/cargo-and-crates-io/cargo-install-for-easy-installation-of-tools.html#cargo-install-for-easy-installation-of-tools","rust-2018/cargo-and-crates-io/cargo-install-for-easy-installation-of-tools.html#cargo-extensions","rust-2018/cargo-and-crates-io/cargo-new-defaults-to-a-binary-project.html#cargo-new-defaults-to-a-binary-project","rust-2018/cargo-and-crates-io/cargo-rustc-for-passing-arbitrary-flags-to-rustc.html#cargo-rustc-for-passing-arbitrary-flags-to-rustc","rust-2018/cargo-and-crates-io/cargo-rustc-for-passing-arbitrary-flags-to-rustc.html#note","rust-2018/cargo-and-crates-io/cargo-workspaces-for-multi-package-projects.html#cargo-workspaces-for-multi-package-projects","rust-2018/cargo-and-crates-io/multi-file-examples.html#multi-file-examples","rust-2018/cargo-and-crates-io/replacing-dependencies-with-patch.html#replacing-dependencies-with-patch","rust-2018/cargo-and-crates-io/cargo-can-use-a-local-registry-replacement.html#cargo-can-use-a-local-registry-replacement","rust-2018/cargo-and-crates-io/crates-io-disallows-wildcard-dependencies.html#cratesio-disallows-wildcard-dependencies","rust-2018/documentation/index.html#documentation","rust-2018/documentation/new-editions-of-the-book.html#new-editions-of-the-the-book","rust-2018/documentation/the-rust-bookshelf.html#the-rust-bookshelf","rust-2018/documentation/the-rust-bookshelf.html#the-cargo-book","rust-2018/documentation/the-rust-bookshelf.html#the-rustdoc-book","rust-2018/documentation/the-rust-bookshelf.html#rust-by-example","rust-2018/documentation/the-rustonomicon.html#the-rustonomicon","rust-2018/documentation/std-os-has-documentation-for-all-platforms.html#stdos-has-documentation-for-all-platforms","rust-2018/rustdoc/index.html#rustdoc","rust-2018/rustdoc/documentation-tests-can-now-compile-fail.html#documentation-tests-can-now-compile-fail","rust-2018/rustdoc/rustdoc-uses-commonmark.html#rustdoc-uses-commonmark","rust-2018/platform-and-target-support/index.html#platform-and-target-support","rust-2018/platform-and-target-support/libcore-for-low-level-rust.html#libcore-for-low-level-rust","rust-2018/platform-and-target-support/webassembly-support.html#webassembly-support","rust-2018/platform-and-target-support/global-allocators.html#global-allocators","rust-2018/platform-and-target-support/msvc-toolchain-support.html#msvc-toolchain-support","rust-2018/platform-and-target-support/musl-support-for-fully-static-binaries.html#musl-support-for-fully-static-binaries","rust-2018/platform-and-target-support/musl-support-for-fully-static-binaries.html#installing-musl-support","rust-2018/platform-and-target-support/musl-support-for-fully-static-binaries.html#building-with-musl","rust-2018/platform-and-target-support/cdylib-crates-for-c-interoperability.html#cdylib-crates-for-c-interoperability"],"index":{"documentStore":{"docInfo":{"0":{"body":55,"breadcrumbs":1,"title":1},"1":{"body":101,"breadcrumbs":1,"title":1},"10":{"body":63,"breadcrumbs":5,"title":3},"100":{"body":89,"breadcrumbs":9,"title":5},"101":{"body":45,"breadcrumbs":10,"title":6},"102":{"body":14,"breadcrumbs":5,"title":1},"103":{"body":68,"breadcrumbs":9,"title":5},"104":{"body":60,"breadcrumbs":7,"title":3},"105":{"body":81,"breadcrumbs":7,"title":3},"106":{"body":131,"breadcrumbs":9,"title":5},"107":{"body":42,"breadcrumbs":8,"title":4},"108":{"body":12,"breadcrumbs":3,"title":1},"109":{"body":146,"breadcrumbs":6,"title":3},"11":{"body":33,"breadcrumbs":3,"title":1},"110":{"body":36,"breadcrumbs":5,"title":2},"111":{"body":42,"breadcrumbs":5,"title":2},"112":{"body":11,"breadcrumbs":5,"title":2},"113":{"body":29,"breadcrumbs":5,"title":2},"114":{"body":32,"breadcrumbs":4,"title":1},"115":{"body":40,"breadcrumbs":6,"title":3},"116":{"body":13,"breadcrumbs":3,"title":1},"117":{"body":51,"breadcrumbs":8,"title":5},"118":{"body":62,"breadcrumbs":6,"title":3},"119":{"body":16,"breadcrumbs":5,"title":3},"12":{"body":11,"breadcrumbs":4,"title":2},"120":{"body":87,"breadcrumbs":9,"title":4},"121":{"body":91,"breadcrumbs":7,"title":2},"122":{"body":110,"breadcrumbs":7,"title":2},"123":{"body":76,"breadcrumbs":8,"title":3},"124":{"body":26,"breadcrumbs":10,"title":5},"125":{"body":70,"breadcrumbs":8,"title":3},"126":{"body":19,"breadcrumbs":7,"title":2},"127":{"body":50,"breadcrumbs":9,"title":4},"13":{"body":82,"breadcrumbs":6,"title":2},"14":{"body":30,"breadcrumbs":5,"title":1},"15":{"body":5,"breadcrumbs":6,"title":2},"16":{"body":25,"breadcrumbs":6,"title":2},"17":{"body":15,"breadcrumbs":5,"title":1},"18":{"body":111,"breadcrumbs":6,"title":2},"19":{"body":6,"breadcrumbs":6,"title":2},"2":{"body":97,"breadcrumbs":1,"title":1},"20":{"body":163,"breadcrumbs":7,"title":3},"21":{"body":43,"breadcrumbs":9,"title":5},"22":{"body":63,"breadcrumbs":7,"title":3},"23":{"body":66,"breadcrumbs":6,"title":2},"24":{"body":231,"breadcrumbs":6,"title":2},"25":{"body":42,"breadcrumbs":7,"title":3},"26":{"body":55,"breadcrumbs":7,"title":3},"27":{"body":11,"breadcrumbs":5,"title":3},"28":{"body":371,"breadcrumbs":9,"title":4},"29":{"body":160,"breadcrumbs":7,"title":2},"3":{"body":66,"breadcrumbs":4,"title":3},"30":{"body":112,"breadcrumbs":7,"title":2},"31":{"body":281,"breadcrumbs":8,"title":3},"32":{"body":41,"breadcrumbs":7,"title":2},"33":{"body":10,"breadcrumbs":4,"title":2},"34":{"body":50,"breadcrumbs":7,"title":3},"35":{"body":23,"breadcrumbs":7,"title":3},"36":{"body":10,"breadcrumbs":4,"title":2},"37":{"body":36,"breadcrumbs":10,"title":6},"38":{"body":76,"breadcrumbs":6,"title":2},"39":{"body":101,"breadcrumbs":6,"title":2},"4":{"body":85,"breadcrumbs":6,"title":5},"40":{"body":61,"breadcrumbs":7,"title":3},"41":{"body":127,"breadcrumbs":6,"title":2},"42":{"body":35,"breadcrumbs":9,"title":5},"43":{"body":44,"breadcrumbs":8,"title":4},"44":{"body":58,"breadcrumbs":6,"title":2},"45":{"body":59,"breadcrumbs":10,"title":6},"46":{"body":209,"breadcrumbs":6,"title":2},"47":{"body":38,"breadcrumbs":8,"title":4},"48":{"body":110,"breadcrumbs":4,"title":2},"49":{"body":0,"breadcrumbs":4,"title":2},"5":{"body":106,"breadcrumbs":6,"title":5},"50":{"body":43,"breadcrumbs":4,"title":2},"51":{"body":31,"breadcrumbs":5,"title":3},"52":{"body":13,"breadcrumbs":3,"title":1},"53":{"body":13,"breadcrumbs":4,"title":2},"54":{"body":98,"breadcrumbs":7,"title":3},"55":{"body":95,"breadcrumbs":6,"title":2},"56":{"body":56,"breadcrumbs":7,"title":3},"57":{"body":104,"breadcrumbs":6,"title":2},"58":{"body":88,"breadcrumbs":7,"title":3},"59":{"body":119,"breadcrumbs":6,"title":2},"6":{"body":45,"breadcrumbs":7,"title":6},"60":{"body":117,"breadcrumbs":7,"title":3},"61":{"body":120,"breadcrumbs":7,"title":3},"62":{"body":6,"breadcrumbs":6,"title":2},"63":{"body":75,"breadcrumbs":8,"title":4},"64":{"body":11,"breadcrumbs":4,"title":2},"65":{"body":71,"breadcrumbs":7,"title":3},"66":{"body":95,"breadcrumbs":6,"title":2},"67":{"body":33,"breadcrumbs":7,"title":3},"68":{"body":51,"breadcrumbs":8,"title":4},"69":{"body":145,"breadcrumbs":8,"title":4},"7":{"body":242,"breadcrumbs":6,"title":5},"70":{"body":201,"breadcrumbs":8,"title":4},"71":{"body":340,"breadcrumbs":5,"title":3},"72":{"body":14,"breadcrumbs":3,"title":1},"73":{"body":86,"breadcrumbs":5,"title":2},"74":{"body":4,"breadcrumbs":5,"title":2},"75":{"body":67,"breadcrumbs":6,"title":3},"76":{"body":48,"breadcrumbs":5,"title":2},"77":{"body":15,"breadcrumbs":5,"title":2},"78":{"body":381,"breadcrumbs":6,"title":3},"79":{"body":81,"breadcrumbs":5,"title":2},"8":{"body":89,"breadcrumbs":2,"title":2},"80":{"body":13,"breadcrumbs":3,"title":1},"81":{"body":127,"breadcrumbs":6,"title":3},"82":{"body":93,"breadcrumbs":5,"title":2},"83":{"body":61,"breadcrumbs":5,"title":2},"84":{"body":29,"breadcrumbs":6,"title":4},"85":{"body":49,"breadcrumbs":4,"title":2},"86":{"body":15,"breadcrumbs":4,"title":2},"87":{"body":80,"breadcrumbs":4,"title":2},"88":{"body":32,"breadcrumbs":4,"title":2},"89":{"body":71,"breadcrumbs":4,"title":2},"9":{"body":45,"breadcrumbs":2,"title":2},"90":{"body":20,"breadcrumbs":6,"title":4},"91":{"body":27,"breadcrumbs":8,"title":6},"92":{"body":29,"breadcrumbs":6,"title":4},"93":{"body":33,"breadcrumbs":5,"title":3},"94":{"body":23,"breadcrumbs":5,"title":3},"95":{"body":62,"breadcrumbs":4,"title":2},"96":{"body":14,"breadcrumbs":4,"title":2},"97":{"body":207,"breadcrumbs":8,"title":4},"98":{"body":41,"breadcrumbs":9,"title":5},"99":{"body":26,"breadcrumbs":6,"title":2}},"docs":{"0":{"body":"Welcome to the Rust Edition Guide! \"Editions\" are Rust's way of communicating large changes in the way that it feels to write Rust code. In this guide, we'll discuss: What editions are What each edition is about How to migrate your code from one edition to another Note that the standard library grows with each Rust release; there are many additions to the standard library that are not called out in this guide. Only the major ones are, but there's tons of medium and small things that are great too. You may want to check out the standard library documentation as well.","breadcrumbs":"Introduction","id":"0","title":"Introduction"},"1":{"body":"Rust ships releases on a six-week cycle. This means that users get a constant stream of new features. This is much faster than updates for other languages, but this also means that each update is smaller. After a while, all of those tiny changes add up. But, from release to release, it can be hard to look back and say \"Wow, between Rust 1.10 and Rust 1.20, Rust has changed a lot!\" Every two or three years, we'll be producing a new edition of Rust. Each edition brings together the features that have landed into a clear package, with fully updated documentation and tooling. New editions ship through the usual release process. This serves different purposes for different people: For active Rust users, it brings together incremental changes into an easy-to-understand package. For non-users, it signals that some major advancements have landed, which might make Rust worth another look. For those developing Rust itself, it provides a rallying point for the project as a whole.","breadcrumbs":"What are Editions?","id":"1","title":"What are Editions?"},"10":{"body":"The following is a summary of changes that only apply to code compiled with the 2018 edition compared to the 2015 edition. Path changes : Paths in use declarations work the same as other paths. Paths starting with :: must be followed with an external crate. Paths in pub(in path) visibility modifiers must start with crate, self, or super. Anonymous trait function parameters are not allowed. Trait function parameters may use any irrefutable pattern when the function has a body. dyn is a strict keyword , in 2015 it is a weak keyword . async, await, and try are reserved keywords . The following lints are now deny by default: tyvar_behind_raw_pointer","breadcrumbs":"Rust 2018 » 2018-Specific Changes","id":"10","title":"2018-Specific Changes"},"100":{"body":"Minimum Rust version: 1.25 cargo new will now default to generating a binary, rather than a library. We try to keep Cargo’s CLI quite stable, but this change is important, and is unlikely to cause breakage. For some background, cargo new accepts two flags: --lib, for creating libraries, and --bin, for creating binaries, or executables. If you don’t pass one of these flags, it used to default to --lib. At the time, we made this decision because each binary (often) depends on many libraries, and so we thought the library case would be more common. However, this is incorrect; each library is depended upon by many binaries. Furthermore, when getting started, what you often want is a program you can run and play around with. It’s not just new Rustaceans though; even very long-time community members have said that they find this default surprising. As such, we’ve changed it, and it now defaults to --bin.","breadcrumbs":"Rust 2018 » Cargo and crates.io » cargo new defaults to a binary project","id":"100","title":"cargo new defaults to a binary project"},"101":{"body":"Minimum Rust version: 1.1 cargo rustc is a new subcommand for Cargo that allows you to pass arbitrary rustc flags through Cargo. For example, Cargo does not have a way to pass unstable flags built-in. But if we'd like to use print-type-sizes to see what layout information our types have, we can run this: $ cargo rustc -- -Z print-type-sizes And we'll get a bunch of output describing the size of our types.","breadcrumbs":"Rust 2018 » Cargo and crates.io » cargo rustc for passing arbitrary flags to rustc","id":"101","title":"cargo rustc for passing arbitrary flags to rustc"},"102":{"body":"cargo rustc only passes these flags to invocations of your crate, and not to any rustc invocations used to build dependencies. If you'd like to do that, see $RUSTFLAGS.","breadcrumbs":"Rust 2018 » Cargo and crates.io » Note","id":"102","title":"Note"},"103":{"body":"Minimum Rust version: 1.12 Cargo used to have two levels of organization: A package contains one or more crates A crate has one or more modules Cargo now has an additional level: A workspace contains one or more packages This can be useful for larger projects. For example, the futures package is a workspace that contains many related packages: futures futures-util futures-io futures-channel and more. Workspaces allow these packages to be developed individually, but they share a single set of dependencies, and therefore have a single target directory and a single Cargo.lock. For more details about workspaces, please see the Cargo documentation .","breadcrumbs":"Rust 2018 » Cargo and crates.io » Cargo workspaces for multi-package projects","id":"103","title":"Cargo workspaces for multi-package projects"},"104":{"body":"Minimum Rust version: 1.22 Cargo has an examples feature for showing people how to use your package. By putting individual files inside of the top-level examples directory, you can create multiple examples. But what if your example is too big for a single file? Cargo supports adding sub-directories inside of examples, and looks for a main.rs inside of them to build the example. It looks like this: my-package └──src └── lib.rs // code here └──examples └── simple-example.rs // a single-file example └── complex-example └── helper.rs └── main.rs // a more complex example that also uses `helper` as a submodule","breadcrumbs":"Rust 2018 » Cargo and crates.io » Multi-file examples","id":"104","title":"Multi-file examples"},"105":{"body":"Minimum Rust version: 1.21 The [patch] section of your Cargo.toml can be used when you want to override certain parts of your dependency graph. Cargo has a [replace] feature that is similar; while we don't intend to deprecate or remove [replace], you should prefer [patch] in all circumstances. So what’s it look like? Let’s say we have a Cargo.toml that looks like this: [dependencies]\nfoo = \"1.2.3\" In addition, our foo package depends on a bar crate, and we find a bug in bar. To test this out, we’d download the source code for bar, and then update our Cargo.toml: [dependencies]\nfoo = \"1.2.3\" [patch.crates-io]\nbar = { path = '/path/to/bar' } Now, when you cargo build, it will use the local version of bar, rather than the one from crates.io that foo depends on. You can then try out your changes, and fix that bug! For more details, see the documentation for patch .","breadcrumbs":"Rust 2018 » Cargo and crates.io » Replacing dependencies with patch","id":"105","title":"Replacing dependencies with patch"},"106":{"body":"Minimum Rust version: 1.12 Cargo finds its packages in a \"source\". The default source is crates.io . However, you can choose a different source in your .cargo/config: [source.crates-io]\nreplace-with = 'my-awesome-registry' [source.my-awesome-registry]\nregistry = 'https://github.com/my-awesome/registry-index' This configuration means that instead of using crates.io, Cargo will query the my-awesome-registry source instead (configured to a different index here). This alternate source must be the exact same as the crates.io index. Cargo assumes that replacement sources are exact 1:1 mirrors in this respect, and the following support is designed around that assumption. When generating a lock file for crate using a replacement registry, the original registry will be encoded into the lock file. For example in the configuration above, all lock files will still mention crates.io as the registry that packages originated from. This semantically represents how crates.io is the source of truth for all crates, and this is upheld because all replacements have a 1:1 correspondance. Overall, this means that no matter what replacement source you're working with, you can ship your lock file to anyone else and you'll all still have verifiably reproducible builds! This has enabled tools like cargo-vendor and cargo-local-registry , which are often useful for \"offline builds.\" They prepare the list of all Rust dependencies ahead of time, which lets you ship them to a build machine with ease.","breadcrumbs":"Rust 2018 » Cargo and crates.io » Cargo can use a local registry replacement","id":"106","title":"Cargo can use a local registry replacement"},"107":{"body":"Minimum Rust version: 1.6 Crates.io will not allow you to upload a package with a wildcard dependency. In other words, these: [dependencies]\nregex = \"*\" A wildcard dependency means that you work with any possible version of your dependency. This is highly unlikely to be true, and would cause unnecessary breakage in the ecosystem. Instead, depend on a version range. For example, ^ is the default, so you could use [dependencies]\nregex = \"1.0.0\" instead. >, <=, and all of the other, non-* ranges work as well.","breadcrumbs":"Rust 2018 » Cargo and crates.io » Crates.io disallows wildcard dependencies","id":"107","title":"Crates.io disallows wildcard dependencies"},"108":{"body":"In this chapter of the guide, we discuss a few improvements to documentation. A notable addition here is the second edition of \"the book\" .","breadcrumbs":"Rust 2018 » Documentation","id":"108","title":"Documentation"},"109":{"body":"Minimum Rust version: 1.26 for the final version of the second edition Minimum Rust version: 1.31 for the 2018 edition We've distributed a copy of \"The Rust Programming Language,\" affectionately nicknamed \"the book\", with every version of Rust since Rust 1.0. However, because it was written before Rust 1.0, it started showing its age. Many parts of the book are vague, because it was written before the true details were nailed down for the 1.0 release. It didn't do a fantastic job of teaching lifetimes. Starting with Rust 1.18, we shipped drafts of a second edition of the book. The final version was shipped with Rust 1.26. The second edition is a complete re-write from the ground up, using the last two years of knowledge we’ve gained from teaching people Rust. You can purchase a printed version of the second edition from No Starch Press . Now that the print version has shipped, the second edition is frozen. As of 1.31, the book has been completely updated for the 2018 Edition release. It's still pretty close to the second edition, but contains information about newer features since the book's content was frozen. Additionally, instead of publishing separate editions of the book, only the latest version of the book is published online. You’ll find brand-new explanations for a lot of Rust’s core concepts, new projects to build, and all kinds of other good stuff. Please check it out and let us know what you think!","breadcrumbs":"Rust 2018 » Documentation » New editions of the \"the book\"","id":"109","title":"New editions of the \"the book\""},"11":{"body":"If there is a target definition in a Cargo.toml manifest, it no longer automatically disables automatic discovery of other targets. Target paths of the form src/{target_name}.rs are no longer inferred for targets where the path field is not set. cargo install for the current directory is no longer allowed, you must specify cargo install --path . to install the current package.","breadcrumbs":"Rust 2018 » Cargo","id":"11","title":"Cargo"},"110":{"body":"Minimum Rust version: various , each book is different. As Rust's documentation has grown, we've gained far more than just \"The book\" and the reference. We now have a collection of various long-form docs, nicknamed \"the Rust Bookshelf.\" Different resources are added at various times, and we're adding new ones as more get written.","breadcrumbs":"Rust 2018 » Documentation » The Rust Bookshelf","id":"110","title":"The Rust Bookshelf"},"111":{"body":"Minimum Rust version: 1.21 Historically, Cargo’s docs were hosted on http://doc.crates.io , which doesn’t follow the release train model, even though Cargo itself does. This led to situations where a feature would land in Cargo nightly, the docs would be updated, and then for up to twelve weeks, users would think that it should work, but it wouldn’t yet. https://doc.rust-lang.org/cargo is the new home of Cargo’s docs, and http://doc.crates.io now redirects there.","breadcrumbs":"Rust 2018 » Documentation » The Cargo book","id":"111","title":"The Cargo book"},"112":{"body":"Minimum Rust version: 1.21 Rustdoc, our documentation tool, now has a guide at https://doc.rust-lang.org/rustdoc .","breadcrumbs":"Rust 2018 » Documentation » The rustdoc book","id":"112","title":"The rustdoc book"},"113":{"body":"Minimum Rust version: 1.25 Rust by Example used to live at https://rustbyexample.com , but now is part of the Bookshelf! It can be found at https://doc.rust-lang.org/rust-by-example/ . RBE lets you learn Rust through short code examples and exercises, as opposed to the lengthy prose of The Book.","breadcrumbs":"Rust 2018 » Documentation » Rust By Example","id":"113","title":"Rust By Example"},"114":{"body":"Minimum Rust version: 1.3 We now have a draft book, The Rustonomicon: the Dark Arts of Advanced and Unsafe Rust Programming . From the title, I'm sure you can guess: this book discusses some advanced topics, including unsafe. It's a must-read for anyone who's working at the lowest levels with Rust.","breadcrumbs":"Rust 2018 » Documentation » The Rustonomicon","id":"114","title":"The Rustonomicon"},"115":{"body":"Minimum Rust version: 1.21 The std::os module contains operating system specific functionality. You’ll now see more than just linux, the platform we build the documentation on. We’ve long regretted that the hosted version of the documentation has been Linux-specific; this is a first step towards rectifying that. This is specific to the standard library and not for general use; we hope to improve this further in the future.","breadcrumbs":"Rust 2018 » Documentation » std::os has documentation for all platforms","id":"115","title":"std::os has documentation for all platforms"},"116":{"body":"In this chapter of the guide, we discuss a few improvements to rustdoc. A notable addition to it was that documentation tests can now compile-fail .","breadcrumbs":"Rust 2018 » rustdoc","id":"116","title":"rustdoc"},"117":{"body":"Minimum Rust version: 1.22 You can now create compile-fail tests in Rustdoc, like this: /// ```compile_fail\n/// let x = 5;\n/// x += 2; // shouldn't compile!\n/// ```\n# fn foo() {} Please note that these kinds of tests can be more fragile than others, as additions to Rust may cause code to compile when it previously would not. Consider the first release with ?, for example: code using ? would fail to compile on Rust 1.21, but compile successfully on Rust 1.22, causing your test suite to start failing.","breadcrumbs":"Rust 2018 » rustdoc » Documentation tests can now compile-fail","id":"117","title":"Documentation tests can now compile-fail"},"118":{"body":"Minimum Rust version: 1.25 for support by default Minimum Rust version: 1.23 for support via a flag Rustdoc lets you write documentation comments in Markdown. At Rust 1.0, we were using the hoedown markdown implementation, written in C. Markdown is more of a family of implementations of an idea, and so hoedown had its own dialect, like many parsers. The CommonMark project has attempted to define a more strict version of Markdown, and so now, Rustdoc uses it by default. As of Rust 1.23, we still defaulted to hoedown, but you could enable Commonmark via a flag, --enable-commonmark. Today, we only support CommonMark.","breadcrumbs":"Rust 2018 » rustdoc » Rustdoc uses CommonMark","id":"118","title":"Rustdoc uses CommonMark"},"119":{"body":"In this chapter of the guide, we discuss a few improvements to platform and target support. A notable addition to it was that the libcore library now works on stable Rust .","breadcrumbs":"Rust 2018 » Platform and target support","id":"119","title":"Platform and target support"},"12":{"body":"In this chapter of the guide, we discuss a few changes to the module system. The most notable of these are the path clarity changes .","breadcrumbs":"Rust 2018 » Module system","id":"12","title":"Module system"},"120":{"body":"Minimum Rust version: 1.6 Rust’s standard library is two-tiered: there’s a small core library, libcore, and the full standard library, libstd, that builds on top of it. libcore is completely platform agnostic, and requires only a handful of external symbols to be defined. Rust’s libstd builds on top of libcore, adding support for things like memory allocation and I/O. Applications using Rust in the embedded space, as well as those writing operating systems, often eschew libstd, using only libcore. As an additional note, while building libraries with libcore is supported today, building full applications is not yet stable. To use libcore, add this flag to your crate root: #![no_std] This will remove the standard library, and bring the core crate into your namespace for use: #![no_std] use core::cell::Cell; You can find libcore's documentation here .","breadcrumbs":"Rust 2018 » Platform and target support » libcore for low-level Rust","id":"120","title":"libcore for low-level Rust"},"121":{"body":"Minimum Rust version: 1.14 for emscripten Minimum Rust version: nightly for wasm32-unknown-unknown Rust has gained support for WebAssembly , meaning that you can run Rust code in your browser, client-side. In Rust 1.14, we gained support through emscripten . With it installed, you can write Rust code and have it produce asm.js (the precusor to wasm) and/or WebAssembly. Here's an example of using this support: $ rustup target add wasm32-unknown-emscripten\n$ echo 'fn main() { println!(\"Hello, Emscripten!\"); }' > hello.rs\n$ rustc --target=wasm32-unknown-emscripten hello.rs\n$ node hello.js However, in the meantime, Rust has also grown its own support, independent from Emscripten. This is known as \"the unknown target\", because instead of wasm32-unknown-emscripten, it's wasm32-unknown-unknown. This will be the preferred target to use once it's ready, but for now, it's really only well-supported in nightly.","breadcrumbs":"Rust 2018 » Platform and target support » WebAssembly support","id":"121","title":"WebAssembly support"},"122":{"body":"Minimum Rust version: 1.28 Allocators are the way that programs in Rust obtain memory from the system at runtime. Previously, Rust did not allow changing the way memory is obtained, which prevented some use cases. On some platforms, this meant using jemalloc, on others, the system allocator, but there was no way for users to control this key component. With 1.28.0, the #[global_allocator] attribute is now stable, which allows Rust programs to set their allocator to the system allocator, as well as define new allocators by implementing the GlobalAlloc trait. The default allocator for Rust programs on some platforms is jemalloc. The standard library now provides a handle to the system allocator, which can be used to switch to the system allocator when desired, by declaring a static and marking it with the #[global_allocator] attribute. use std::alloc::System; #[global_allocator]\nstatic GLOBAL: System = System; fn main() { let mut v = Vec::new(); // This will allocate memory using the system allocator. v.push(1);\n} However, sometimes you want to define a custom allocator for a given application domain. This is also relatively easy to do by implementing the GlobalAlloc trait. You can read more about how to do this in the documentation .","breadcrumbs":"Rust 2018 » Platform and target support » Global allocators","id":"122","title":"Global allocators"},"123":{"body":"Minimum Rust version: 1.2 At the release of Rust 1.0, we only supported the GNU toolchain on Windows. With the release of Rust 1.2, we introduced initial support for the MSVC toolchain. After that, as support matured, we eventually made it the default choice for Windows users. The difference between the two matters for interacting with C. If you're using a library built with one toolchain or another, you need to match that with the appropriate Rust toolchain. If you're not sure, go with MSVC; it's the default for good reason. To use this feature, simply use Rust on Windows, and the installer will default to it. If you'd prefer to switch to the GNU toolchain, you can install it with Rustup: $ rustup toolchain install stable-x86_64-pc-windows-gnu","breadcrumbs":"Rust 2018 » Platform and target support » MSVC toolchain support","id":"123","title":"MSVC toolchain support"},"124":{"body":"Minimum Rust version: 1.1 By default, Rust will statically link all Rust code. However, if you use the standard library, it will dynamically link to the system's libc implementation. If you'd like a 100% static binary, the MUSL libc can be used on Linux.","breadcrumbs":"Rust 2018 » Platform and target support » MUSL support for fully static binaries","id":"124","title":"MUSL support for fully static binaries"},"125":{"body":"To add support for MUSL, you need to choose the correct target. The forge has a full list of targets supported, with a number of ones using musl. If you're not sure what you want, it's probably x86_64-unknown-linux-musl, for 64-bit Linux. We'll be using this target in this guide, but the instructions remain the same for other targets, just change the name wherever we mention the target. To get support for this target, you use rustup: $ rustup target add x86_64-unknown-linux-musl This will install support for the default toolchain; to install for other toolchains, add the --toolchain flag. For example: $ rustup target add x86_64-unknown-linux-musl --toolchain=nightly","breadcrumbs":"Rust 2018 » Platform and target support » Installing MUSL support","id":"125","title":"Installing MUSL support"},"126":{"body":"To use this new target, pass the --target flag to Cargo: $ cargo build --target x86_64-unknown-linux-musl The binary produced will now be built with MUSL!","breadcrumbs":"Rust 2018 » Platform and target support » Building with MUSL","id":"126","title":"Building with MUSL"},"127":{"body":"Minimum Rust version: 1.10 for rustc Minimum Rust version: 1.11 for cargo If you're producing a library that you intend to be used from C (or another language through a C FFI), there's no need for Rust to include Rust-specific stuff in the final object code. For libraries like that, you'll want to use the cdylib crate type in your Cargo.toml: [lib]\ncrate-type = [\"cdylib\"] This will produce a smaller binary, with no Rust-specific information inside of it.","breadcrumbs":"Rust 2018 » Platform and target support » cdylib crates for C interoperability","id":"127","title":"cdylib crates for C interoperability"},"13":{"body":"Minimum Rust version: 1.30 Rust, like many programming languages, has the concept of \"keywords\". These identifiers mean something to the language, and so you cannot use them in places like variable names, function names, and other places. Raw identifiers let you use keywords where they would not normally be allowed. For example, match is a keyword. If you try to compile this function: fn match(needle: &str, haystack: &str) -> bool { haystack.contains(needle)\n} You'll get this error: error: expected identifier, found keyword `match` --> src/main.rs:4:4 |\n4 | fn match(needle: &str, haystack: &str) -> bool { | ^^^^^ expected identifier, found keyword You can write this with a raw identifier: fn r#match(needle: &str, haystack: &str) -> bool { haystack.contains(needle)\n} fn main() { assert!(r#match(\"foo\", \"foobar\"));\n} Note the r# prefix on both the function name as well as the call.","breadcrumbs":"Rust 2018 » Module system » Raw identifiers","id":"13","title":"Raw identifiers"},"14":{"body":"This feature is useful for a few reasons, but the primary motivation was inter-edition situations. For example, try is not a keyword in the 2015 edition, but is in the 2018 edition. So if you have a library that is written in Rust 2015 and has a try function, to call it in Rust 2018, you'll need to use the raw identifier.","breadcrumbs":"Rust 2018 » Module system » Motivation","id":"14","title":"Motivation"},"15":{"body":"The new confirmed keywords in edition 2018 are:","breadcrumbs":"Rust 2018 » Module system » New keywords","id":"15","title":"New keywords"},"16":{"body":"Here, async is reserved for use in async fn as well as in async || closures and async { .. } blocks. Meanwhile, await is reserved to keep our options open with respect to await!(expr) syntax. See RFC 2394 for more details.","breadcrumbs":"Rust 2018 » Module system » async and await","id":"16","title":"async and await"},"17":{"body":"The do catch { .. } blocks have been renamed to try { .. } and to support that, the keyword try is reserved in edition 2018. See RFC 2388 for more details.","breadcrumbs":"Rust 2018 » Module system » try","id":"17","title":"try"},"18":{"body":"Minimum Rust version: 1.31 The module system is often one of the hardest things for people new to Rust. Everyone has their own things that take time to master, of course, but there's a root cause for why it's so confusing to many: while there are simple and consistent rules defining the module system, their consequences can feel inconsistent, counterintuitive and mysterious. As such, the 2018 edition of Rust introduces a few new module system features, but they end up simplifying the module system, to make it more clear as to what is going on. Here's a brief summary: extern crate is no longer needed in 99% of circumstances. The crate keyword refers to the current crate. Paths may start with a crate name, even within submodules. Paths starting with :: must reference an external crate. A foo.rs and foo/ subdirectory may coexist; mod.rs is no longer needed when placing submodules in a subdirectory. Paths in use declarations work the same as other paths. These may seem like arbitrary new rules when put this way, but the mental model is now significantly simplified overall. Read on for more details!","breadcrumbs":"Rust 2018 » Module system » Path clarity","id":"18","title":"Path clarity"},"19":{"body":"Let's talk about each new feature in turn.","breadcrumbs":"Rust 2018 » Module system » More details","id":"19","title":"More details"},"2":{"body":"When a new edition becomes available in the compiler, crates must explicitly opt in to it to take full advantage. This opt in enables editions to contain incompatible changes, like adding a new keyword that might conflict with identifiers in code, or turning warnings into errors. A Rust compiler will support all editions that existed prior to the compiler's release, and can link crates of any supported editions together. Edition changes only affect the way the compiler initially parses the code. Therefore, if you're using Rust 2015, and one of your dependencies uses Rust 2018, it all works just fine. The opposite situation works as well. Just to be clear: most features will be available on all editions. People using any edition of Rust will continue to see improvements as new stable releases are made. In some cases however, mainly when new keywords are added, but sometimes for other reasons, there may be new features that are only available in later editions. You only need to upgrade if you want to take advantage of such features.","breadcrumbs":"Compatibility","id":"2","title":"Compatibility"},"20":{"body":"This one is quite straightforward: you no longer need to write extern crate to import a crate into your project. Before: // Rust 2015 extern crate futures; mod submodule { use futures::Future;\n} After: // Rust 2018 mod submodule { use futures::Future;\n} Now, to add a new crate to your project, you can add it to your Cargo.toml, and then there is no step two. If you're not using Cargo, you already had to pass --extern flags to give rustc the location of external crates, so you'd just keep doing what you were doing there as well. One small note here: cargo fix will not currently automate this change. We may have it do this for you in the future. An exception There's one exception to this rule, and that's the \"sysroot\" crates. These are the crates distributed with Rust itself. We'd eventually like to remove the requirement for extern crate for them as well, but it hasn't shipped yet. You'll need to use extern crate for: proc_macro Additionally, you would need to use it for: core std However, extern crate std; is already implicit, and with #![no_std], extern crate core; is already implicit. You'll only need these in highly specialized situations. Finally, on nightly, you'll need it for crates like: alloc test Macros One other use for extern crate was to import macros; that's no longer needed. Check the macro section for more. Renaming crates If you've been using as to rename your crate like this: extern crate futures as f; use f::Future; then removing the extern crate line on its own won't work. You'll need to do this: use futures as f; use self::f::Future; This change will need to happen in any module that uses f.","breadcrumbs":"Rust 2018 » Module system » No more extern crate","id":"20","title":"No more extern crate"},"21":{"body":"In use declarations and in other code, you can refer to the root of the current crate with the crate:: prefix. For instance, crate::foo::bar will always refer to the name bar inside the module foo, from anywhere else in the same crate. The prefix :: previously referred to either the crate root or an external crate; it now unambiguously refers to an external crate. For instance, ::foo::bar always refers to the name bar inside the external crate foo.","breadcrumbs":"Rust 2018 » Module system » The crate keyword refers to the current crate","id":"21","title":"The crate keyword refers to the current crate"},"22":{"body":"Previously, using an external crate in a module without a use import required a leading :: on the path. // Rust 2015 extern crate chrono; fn foo() { // this works in the crate root let x = chrono::Utc::now();\n} mod submodule { fn function() { // but in a submodule it requires a leading :: if not imported with `use` let x = ::chrono::Utc::now(); }\n} Now, extern crate names are in scope in the entire crate, including submodules. // Rust 2018 fn foo() { // this works in the crate root let x = chrono::Utc::now();\n} mod submodule { fn function() { // crates may be referenced directly, even in submodules let x = chrono::Utc::now(); }\n}","breadcrumbs":"Rust 2018 » Module system » Extern crate paths","id":"22","title":"Extern crate paths"},"23":{"body":"In Rust 2015, if you have a submodule: // This `mod` declaration looks for the `foo` module in\n// `foo.rs` or `foo/mod.rs`.\nmod foo; It can live in foo.rs or foo/mod.rs. If it has submodules of its own, it must be foo/mod.rs. So a bar submodule of foo would live at foo/bar.rs. In Rust 2018 the restriction that a module with submodules must be named mod.rs is lifted. foo.rs can just be foo.rs, and the submodule is still foo/bar.rs. This eliminates the special name, and if you have a bunch of files open in your editor, you can clearly see their names, instead of having a bunch of tabs named mod.rs. Rust 2015 Rust 2018 .\n├── lib.rs\n└── foo/ &nbsp;&nbsp; ├── mod.rs &nbsp;&nbsp; └── bar.rs .\n├── lib.rs\n├── foo.rs\n└── foo/ &nbsp;&nbsp; └── bar.rs","breadcrumbs":"Rust 2018 » Module system » No more mod.rs","id":"23","title":"No more mod.rs"},"24":{"body":"Minimum Rust version: 1.32 Rust 2018 simplifies and unifies path handling compared to Rust 2015. In Rust 2015, paths work differently in use declarations than they do elsewhere. In particular, paths in use declarations would always start from the crate root, while paths in other code implicitly started from the current scope. Those differences didn't have any effect in the top-level module, which meant that everything would seem straightforward until working on a project large enough to have submodules. In Rust 2018, paths in use declarations and in other code work the same way, both in the top-level module and in any submodule. You can use a relative path from the current scope, a path starting from an external crate name, or a path starting with crate, super, or self. Code that looked like this: // Rust 2015 extern crate futures; use futures::Future; mod foo { pub struct Bar;\n} use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String),\n} fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } }\n} will look exactly the same in Rust 2018, except that you can delete the extern crate line: // Rust 2018 use futures::Future; mod foo { pub struct Bar;\n} use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String),\n} fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } }\n} The same code will also work completely unmodified in a submodule: // Rust 2018 mod submodule { use futures::Future; mod foo { pub struct Bar; } use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String), } fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } } }\n} This makes it easy to move code around in a project, and avoids introducing additional complexity to multi-module projects. If a path is ambiguous, such as if you have an external crate and a local module or item with the same name, you'll get an error, and you'll need to either rename one of the conflicting names or explicitly disambiguate the path. To explicitly disambiguate a path, use ::name for an external crate name, or self::name for a local module or item.","breadcrumbs":"Rust 2018 » Module system » use paths","id":"24","title":"use paths"},"25":{"body":"Minimum Rust version: 1.18 You can use the pub keyword to make something a part of a module's public interface. But in addition, there are some new forms: pub(crate) struct Foo; pub(in a::b::c) struct Bar; The first form makes the Foo struct public to your entire crate, but not externally. The second form is similar, but makes Bar public for one other module, a::b::c in this case.","breadcrumbs":"Rust 2018 » Module system » More visibility modifiers","id":"25","title":"More visibility modifiers"},"26":{"body":"Minimum Rust version: 1.25 A new way to write use statements has been added to Rust: nested import groups. If you’ve ever written a set of imports like this: use std::fs::File;\nuse std::io::Read;\nuse std::path::{Path, PathBuf}; You can now write this: # mod foo {\n// on one line\nuse std::{fs::File, io::Read, path::{Path, PathBuf}};\n# } # mod bar {\n// with some more breathing room\nuse std::{ fs::File, io::Read, path::{ Path, PathBuf }\n};\n# } This can reduce some repetition, and make things a bit more clear.","breadcrumbs":"Rust 2018 » Module system » Nested imports with use","id":"26","title":"Nested imports with use"},"27":{"body":"In this chapter of the guide, we discuss a few improvements to error handling in Rust. The most notable of these is the introduction of the ? operator .","breadcrumbs":"Rust 2018 » Error handling and Panics","id":"27","title":"Error handling and Panics"},"28":{"body":"Minimum Rust version: 1.13 for Result<T, E> Minimum Rust version: 1.22 for Option<T> Rust has gained a new operator, ?, that makes error handling more pleasant by reducing the visual noise involved. It does this by solving one simple problem. To illustrate, imagine we had some code to read some data from a file: # use std::{io::{self, prelude::*}, fs::File};\nfn read_username_from_file() -> Result<String, io::Error> { let f = File::open(\"username.txt\"); let mut f = match f { Ok(file) => file, Err(e) => return Err(e), }; let mut s = String::new(); match f.read_to_string(&mut s) { Ok(_) => Ok(s), Err(e) => Err(e), }\n} Note: this code could be made simpler with a single call to std::fs::read_to_string , but we're writing it all out manually here to have an example with multiple errors. This code has two paths that can fail, opening the file and reading the data from it. If either of these fail to work, we'd like to return an error from read_username_from_file. Doing so involves matching on the result of the I/O operations. In simple cases like this though, where we are only propagating errors up the call stack, the matching is just boilerplate - seeing it written out, in the same pattern every time, doesn't provide the reader with a great deal of useful information. With ?, the above code looks like this: # use std::{io::{self, prelude::*}, fs::File};\nfn read_username_from_file() -> Result<String, io::Error> { let mut f = File::open(\"username.txt\")?; let mut s = String::new(); f.read_to_string(&mut s)?; Ok(s)\n} The ? is shorthand for the entire match statements we wrote earlier. In other words, ? applies to a Result value, and if it was an Ok, it unwraps it and gives the inner value. If it was an Err, it returns from the function you're currently in. Visually, it is much more straightforward. Instead of an entire match statement, now we are just using the single \"?\" character to indicate that here we are handling errors in the standard way, by passing them up the call stack. Seasoned Rustaceans may recognize that this is the same as the try! macro that's been available since Rust 1.0. And indeed, they are the same. Previously, read_username_from_file could have been implemented like this: # use std::{io::{self, prelude::*}, fs::File};\nfn read_username_from_file() -> Result<String, io::Error> { let mut f = try!(File::open(\"username.txt\")); let mut s = String::new(); try!(f.read_to_string(&mut s)); Ok(s)\n} So why extend the language when we already have a macro? There are multiple reasons. First, try! has proved to be extremely useful, and is used often in idiomatic Rust. It is used so often that we think it's worth having a sweet syntax. This sort of evolution is one of the great advantages of a powerful macro system: speculative extensions to the language syntax can be prototyped and iterated on without modifying the language itself, and in return, macros that turn out to be especially useful can indicate missing language features. This evolution, from try! to ? is a great example. One of the reasons try! needs a sweeter syntax is that it is quite unattractive when multiple invocations of try! are used in succession. Consider: try!(try!(try!(foo()).bar()).baz()) as opposed to foo()?.bar()?.baz()? The first is quite difficult to scan visually, and each layer of error handling prefixes the expression with an additional call to try!. This brings undue attention to the trivial error propagation, obscuring the main code path, in this example the calls to foo, bar and baz. This sort of method chaining with error handling occurs in situations like the builder pattern. Finally, the dedicated syntax will make it easier in the future to produce nicer error messages tailored specifically to ?, whereas it is difficult to produce nice errors for macro-expanded code generally. You can use ? with Result<T, E>s, but also with Option<T>. In that case, ? will return a value for Some(T) and return None for None. One current restriction is that you cannot use ? for both in the same function, as the return type needs to match the type you use ? on. In the future, this restriction will be lifted.","breadcrumbs":"Rust 2018 » Error handling and panics » The ? operator for easier error handling","id":"28","title":"The ? operator for easier error handling"},"29":{"body":"Minimum Rust version: 1.26 Rust's error handling revolves around returning Result<T, E> and using ? to propagate errors. For those who write many small programs and, hopefully, many tests, one common paper cut has been mixing entry points such as main and #[test]s with error handling. As an example, you might have tried to write: use std::fs::File; fn main() { let f = File::open(\"bar.txt\")?;\n} Since ? works by propagating the Result with an early return to the enclosing function, the snippet above does not work, and results today in the following error: error[E0277]: the `?` operator can only be used in a function that returns `Result` or `Option` (or another type that implements `std::ops::Try`) --> src/main.rs:5:13 |\n5 | let f = File::open(\"bar.txt\")?; | ^^^^^^^^^^^^^^^^^^^^^^ cannot use the `?` operator in a function that returns `()` | = help: the trait `std::ops::Try` is not implemented for `()` = note: required by `std::ops::Try::from_error` To solve this problem in Rust 2015, you might have written something like: // Rust 2015 # use std::process;\n# use std::error::Error; fn run() -> Result<(), Box<Error>> { // real logic.. Ok(())\n} fn main() { if let Err(e) = run() { println!(\"Application error: {}\", e); process::exit(1); }\n} However, in this case, the run function has all the interesting logic and main is just boilerplate. The problem is even worse for #[test]s, since there tend to be a lot more of them. In Rust 2018 you can instead let your #[test]s and main functions return a Result: // Rust 2018 use std::fs::File; fn main() -> Result<(), std::io::Error> { let f = File::open(\"bar.txt\")?; Ok(())\n} In this case, if say the file doesn't exist and there is an Err(err) somewhere, then main will exit with an error code (not 0) and print out a Debug representation of err.","breadcrumbs":"Rust 2018 » Error handling and panics » ? in main and tests","id":"29","title":"? in main and tests"},"3":{"body":"When you create a new project with Cargo, it will automatically add configuration for the latest edition: > cargo +nightly new foo Created binary (application) `foo` project\n> cat .\\foo\\Cargo.toml\n[package]\nname = \"foo\"\nversion = \"0.1.0\"\nauthors = [\"your name <you@example.com>\"]\nedition = \"2018\" [dependencies] That edition = \"2018\" setting will configure your package to use Rust 2018. No more configuration needed! If you'd prefer to use an older edition, you can change the value in that key, for example: [package]\nname = \"foo\"\nversion = \"0.1.0\"\nauthors = [\"your name <you@example.com>\"]\nedition = \"2015\" [dependencies] This will build your package in Rust 2015.","breadcrumbs":"What are editions? » Creating a new project","id":"3","title":"Creating a new project"},"30":{"body":"Getting -> Result<..> to work in the context of main and #[test]s is not magic. It is all backed up by a Termination trait which all valid return types of main and testing functions must implement. The trait is defined as: pub trait Termination { fn report(self) -> i32;\n} When setting up the entry point for your application, the compiler will use this trait and call .report() on the Result of the main function you have written. Two simplified example implementations of this trait for Result and () are: # #![feature(process_exitcode_placeholder, termination_trait_lib)]\n# use std::process::ExitCode;\n# use std::fmt;\n#\n# pub trait Termination { fn report(self) -> i32; } impl Termination for () { fn report(self) -> i32 { # use std::process::Termination; ExitCode::SUCCESS.report() }\n} impl<E: fmt::Debug> Termination for Result<(), E> { fn report(self) -> i32 { match self { Ok(()) => ().report(), Err(err) => { eprintln!(\"Error: {:?}\", err); # use std::process::Termination; ExitCode::FAILURE.report() } } }\n} As you can see in the case of (), a success code is simply returned. In the case of Result, the success case delegates to the implementation for () but prints out an error message and a failure exit code on Err(..). To learn more about the finer details, consult either the tracking issue or the RFC .","breadcrumbs":"Rust 2018 » Error handling and panics » More details","id":"30","title":"More details"},"31":{"body":"Minimum Rust version: 1.9 There is a std::panic module, which includes methods for halting the unwinding process started by a panic: use std::panic; let result = panic::catch_unwind(|| { println!(\"hello!\");\n});\nassert!(result.is_ok()); let result = panic::catch_unwind(|| { panic!(\"oh no!\");\n});\nassert!(result.is_err()); In general, Rust distinguishes between two ways that an operation can fail: Due to an expected problem , like a file not being found. Due to an unexpected problem , like an index being out of bounds for an array. Expected problems usually arise from conditions that are outside of your control; robust code should be prepared for anything its environment might throw at it. In Rust, expected problems are handled via the Result type , which allows a function to return information about the problem to its caller, which can then handle the error in a fine-grained way. Unexpected problems are bugs : they arise due to a contract or assertion being violated. Since they are unexpected, it doesn't make sense to handle them in a fine-grained way. Instead, Rust employs a \"fail fast\" approach by panicking , which by default unwinds the stack (running destructors but no other code) of the thread which discovered the error. Other threads continue running, but will discover the panic any time they try to communicate with the panicked thread (whether through channels or shared memory). Panics thus abort execution up to some \"isolation boundary\", with code on the other side of the boundary still able to run, and perhaps to \"recover\" from the panic in some very coarse-grained way. A server, for example, does not necessarily need to go down just because of an assertion failure in one of its threads. It's also worth noting that programs may choose to abort instead of unwind, and so catching panics may not work. If your code relies on catch_unwind, you should add this to your Cargo.toml: [profile.dev]\npanic = \"unwind\" [profile.release]\npanic = \"unwind\" If any of your users choose to abort, they'll get a compile-time failure. The catch_unwind API offers a way to introduce new isolation boundaries within a thread . There are a couple of key motivating examples: Embedding Rust in other languages Abstractions that manage threads Test frameworks, because tests may panic and you don't want that to kill the test runner For the first case, unwinding across a language boundary is undefined behavior, and often leads to segfaults in practice. Allowing panics to be caught means that you can safely expose Rust code via a C API, and translate unwinding into an error on the C side. For the second case, consider a threadpool library. If a thread in the pool panics, you generally don't want to kill the thread itself, but rather catch the panic and communicate it to the client of the pool. The catch_unwind API is paired with resume_unwind, which can then be used to restart the panicking process on the client of the pool, where it belongs. In both cases, you're introducing a new isolation boundary within a thread, and then translating the panic into some other form of error elsewhere.","breadcrumbs":"Rust 2018 » Error handling and panics » Controlling panics with std::panic","id":"31","title":"Controlling panics with std::panic"},"32":{"body":"Minimum Rust version: 1.10 By default, Rust programs will unwind the stack when a panic! happens. If you'd prefer an immediate abort instead, you can configure this in Cargo.toml: [profile.dev]\npanic = \"abort\" [profile.release]\npanic = \"abort\" Why might you choose to do this? By removing support for unwinding, you'll get smaller binaries. You will lose the ability to catch panics. Which choice is right for you depends on exactly what you're doing.","breadcrumbs":"Rust 2018 » Error handling and panics » Aborting on panic","id":"32","title":"Aborting on panic"},"33":{"body":"In this chapter of the guide, we discuss a few improvements to control flow. The most notable of these will be async and await .","breadcrumbs":"Rust 2018 » Control flow","id":"33","title":"Control flow"},"34":{"body":"Minimum Rust version: 1.19 loops can now break with a value: // old code\nlet x; loop { x = 7; break;\n} // new code\nlet x = loop { break 7; }; Rust has traditionally positioned itself as an “expression oriented language”, that is, most things are expressions that evaluate to a value, rather than statements. loop stuck out as strange in this way, as it was previously a statement. For now, this only applies to loop, and not things like while or for. See the rationale for this decision in RFC issue #1767 .","breadcrumbs":"Rust 2018 » Control flow » loops can break with a value","id":"34","title":"loops can break with a value"},"35":{"body":"Minimum Rust version: nightly The initial release of Rust 2018 won't ship with async/await support, but we have reserved the keywords so that a future release will contain them. We'll update this page when it's closer to shipping!","breadcrumbs":"Rust 2018 » Control flow » async/await for easier concurrency","id":"35","title":"async/await for easier concurrency"},"36":{"body":"In this chapter of the guide, we discuss a few improvements to the trait system. The most notable of these is impl Trait .","breadcrumbs":"Rust 2018 » Trait system","id":"36","title":"Trait system"},"37":{"body":"Minimum Rust version: 1.26 impl Trait is the new way to specify unnamed but concrete types that implement a specific trait. There are two places you can put it: argument position, and return position. trait Trait {} // argument position\nfn foo(arg: impl Trait) {\n} // return position\nfn foo() -> impl Trait {\n}","breadcrumbs":"Rust 2018 » Trait system » impl Trait for returning complex types with ease","id":"37","title":"impl Trait for returning complex types with ease"},"38":{"body":"In argument position, this feature is quite simple. These two forms are almost the same: trait Trait {} fn foo<T: Trait>(arg: T) {\n} fn foo(arg: impl Trait) {\n} That is, it's a slightly shorter syntax for a generic type parameter. It means, \"arg is an argument that takes any type that implements the Trait trait.\" However, there's also an important technical difference between T: Trait and impl Trait here. When you write the former, you can specify the type of T at the call site with turbo-fish syntax as with foo::<usize>(1). In the case of impl Trait, if it is used anywhere in the function definition, then you can't use turbo-fish at all. Therefore, you should be mindful that changing both from and to impl Trait can constitute a breaking change for the users of your code.","breadcrumbs":"Rust 2018 » Trait system » Argument Position","id":"38","title":"Argument Position"},"39":{"body":"In return position, this feature is more interesting. It means \"I am returning some type that implements the Trait trait, but I'm not going to tell you exactly what the type is.\" Before impl Trait, you could do this with trait objects: trait Trait {} impl Trait for i32 {} fn returns_a_trait_object() -> Box<dyn Trait> { Box::new(5)\n} However, this has some overhead: the Box<T> means that there's a heap allocation here, and this will use dynamic dispatch. See the dyn Trait section for an explanation of this syntax. But we only ever return one possible thing here, the Box<i32>. This means that we're paying for dynamic dispatch, even though we don't use it! With impl Trait, the code above could be written like this: trait Trait {} impl Trait for i32 {} fn returns_a_trait_object() -> impl Trait { 5\n} Here, we have no Box<T>, no trait object, and no dynamic dispatch. But we still can obscure the i32 return type. With i32, this isn't super useful. But there's one major place in Rust where this is much more useful: closures.","breadcrumbs":"Rust 2018 » Trait system » Return Position","id":"39","title":"Return Position"},"4":{"body":"New editions might change the way you write Rust – they add new syntax, language, and library features, and also remove features. For example, try, async, and await are keywords in Rust 2018, but not Rust 2015. If you have a project that's using Rust 2015, and you'd like to use Rust 2018 for it instead, there's a few steps that you need to take. It's our intention that the migration to new editions is as smooth an experience as possible. If it's difficult for you to upgrade to Rust 2018, we consider that a bug. If you run into problems with this process, please file a bug . Thank you! Here's an example. Imagine we have a crate that has this code in src/lib.rs: trait Foo { fn foo(&self, Box<Foo>);\n} This code uses an anonymous parameter, that Box<Foo>. This is not supported in Rust 2018 , and so this would fail to compile. Let's get this code up to date!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition","id":"4","title":"Transitioning an existing project to a new edition"},"40":{"body":"If you need to catch up on closures, check out their chapter in the book . In Rust, closures have a unique, un-writable type. They do implement the Fn family of traits, however. This means that previously, the only way to return a closure from a function was to use a trait object: fn returns_closure() -> Box<dyn Fn(i32) -> i32> { Box::new(|x| x + 1)\n} You couldn't write the type of the closure, only use the Fn trait. That means that the trait object is necessary. However, with impl Trait: fn returns_closure() -> impl Fn(i32) -> i32 { |x| x + 1\n} We can now return closures by value, just like any other type!","breadcrumbs":"Rust 2018 » Trait system » impl Trait and closures","id":"40","title":"impl Trait and closures"},"41":{"body":"The above is all you need to know to get going with impl Trait, but for some more nitty-gritty details: type parameters and impl Trait work slightly differently when they're in argument position versus return position. Consider this function: fn foo<T: Trait>(x: T) { When you call it, you set the type, T. \"you\" being the caller here. This signature says \"I accept any type that implements Trait.\" (\"any type\" == universal in the jargon) This version: fn foo<T: Trait>() -> T { is similar, but also different. You, the caller, provide the type you want, T, and then the function returns it. You can see this in Rust today with things like parse or collect: let x: i32 = \"5\".parse()?;\nlet x: u64 = \"5\".parse()?; Here, .parse has this signature: pub fn parse<F>(&self) -> Result<F, <F as FromStr>::Err> where F: FromStr, Same general idea, though with a result type and FromStr has an associated type... anyway, you can see how F is in the return position here. So you have the ability to choose. With impl Trait, you're saying \"hey, some type exists that implements this trait, but I'm not gonna tell you what it is.\" So now, the caller can't choose, and the function itself gets to choose. If we tried to define parse with Result<impl F,... as the return type, it wouldn't work.","breadcrumbs":"Rust 2018 » Trait system » More details","id":"41","title":"More details"},"42":{"body":"As previously mentioned, as a start, you will only be able to use impl Trait as the argument or return type of a free or inherent function. However, impl Trait can't be used inside implementations of traits, nor can it be used as the type of a let binding or inside a type alias. Some of these restrictions will eventually be lifted. For more information, see the tracking issue on impl Trait .","breadcrumbs":"Rust 2018 » Trait system » Using impl Trait in more places","id":"42","title":"Using impl Trait in more places"},"43":{"body":"Minimum Rust version: 1.27 The dyn Trait feature is the new syntax for using trait objects. In short: Box<Trait> becomes Box<dyn Trait> &Trait and &mut Trait become &dyn Trait and &mut dyn Trait And so on. In code: trait Trait {} impl Trait for i32 {} // old\nfn function1() -> Box<Trait> {\n# unimplemented!()\n} // new\nfn function2() -> Box<dyn Trait> {\n# unimplemented!()\n} That's it!","breadcrumbs":"Rust 2018 » Trait system » dyn Trait for trait objects","id":"43","title":"dyn Trait for trait objects"},"44":{"body":"Using just the trait name for trait objects turned out to be a bad decision. The current syntax is often ambiguous and confusing, even to veterans, and favors a feature that is not more frequently used than its alternatives, is sometimes slower, and often cannot be used at all when its alternatives can. Furthermore, with impl Trait arriving, \"impl Trait vs dyn Trait\" is much more symmetric, and therefore a bit nicer, than \"impl Trait vs Trait\". impl Trait is explained here . In the new edition, you should therefore prefer dyn Trait to just Trait where you need a trait object.","breadcrumbs":"Rust 2018 » Trait system » More details","id":"44","title":"More details"},"45":{"body":"Minimum Rust version: 1.2 In Rust 1.0, only certain, special types could be used to create trait objects . With Rust 1.2, that restriction was lifted, and more types became able to do this. For example, Rc<T>, one of Rust's reference-counted types: use std::rc::Rc; trait Foo {} impl Foo for i32 { } fn main() { let obj: Rc<dyn Foo> = Rc::new(5);\n} This code would not work with Rust 1.0, but now works. If you haven't seen the dyn syntax before, see the section on it . For versions that do not support it, replace Rc<dyn Foo> with Rc<Foo>.","breadcrumbs":"Rust 2018 » Trait system » More container types support trait objects","id":"45","title":"More container types support trait objects"},"46":{"body":"Minimum Rust version: 1.20 You can define traits, structs, and enums that have “associated functions”: struct Struct; impl Struct { fn foo() { println!(\"foo is an associated function of Struct\"); }\n} fn main() { Struct::foo();\n} These are called “associated functions” because they are functions that are associated with the type, that is, they’re attached to the type itself, and not any particular instance. Rust 1.20 adds the ability to define “associated constants” as well: struct Struct; impl Struct { const ID: u32 = 0;\n} fn main() { println!(\"the ID of Struct is: {}\", Struct::ID);\n} That is, the constant ID is associated with Struct. Like functions, associated constants work with traits and enums as well. Traits have an extra ability with associated constants that gives them some extra power. With a trait, you can use an associated constant in the same way you’d use an associated type: by declaring it, but not giving it a value. The implementor of the trait then declares its value upon implementation: trait Trait { const ID: u32;\n} struct Struct; impl Trait for Struct { const ID: u32 = 5;\n} fn main() { println!(\"{}\", Struct::ID);\n} Before this feature, if you wanted to make a trait that represented floating point numbers, you’d have to write this: trait Float { fn nan() -> Self; fn infinity() -> Self; // ...\n} This is slightly unwieldy, but more importantly, because they’re functions, they cannot be used in constant expressions, even though they only return a constant. Because of this, a design for Float would also have to include constants as well: mod f32 { const NAN: f32 = 0.0f32 / 0.0f32; const INFINITY: f32 = 1.0f32 / 0.0f32; impl Float for f32 { fn nan() -> Self { f32::NAN } fn infinity() -> Self { f32::INFINITY } }\n} Associated constants let you do this in a much cleaner way. This trait definition: trait Float { const NAN: Self; const INFINITY: Self; // ...\n} Leads to this implementation: mod f32 { impl Float for f32 { const NAN: f32 = 0.0f32 / 0.0f32; const INFINITY: f32 = 1.0f32 / 0.0f32; }\n} much cleaner, and more versatile.","breadcrumbs":"Rust 2018 » Trait system » Associated constants","id":"46","title":"Associated constants"},"47":{"body":"Minimum Rust version: 1.31 In accordance with RFC #1685 , parameters in trait method declarations are no longer allowed to be anonymous. For example, in the 2015 edition, this was allowed: trait Foo { fn foo(&self, u8);\n} In the 2018 edition, all parameters must be given an argument name (even if it's just _): trait Foo { fn foo(&self, baz: u8);\n}","breadcrumbs":"Rust 2018 » Trait system » No more anonymous trait parameters","id":"47","title":"No more anonymous trait parameters"},"48":{"body":"Minimum Rust version: 1.26 Have you ever tried to pattern match on the contents and structure of a slice? Rust 2018 will let you do just that. For example, say we want to accept a list of names and respond to that with a greeting. With slice patterns, we can do that easy as pie with: fn main() { greet(&[]); // output: Bummer, there's no one here :( greet(&[\"Alan\"]); // output: Hey, there Alan! You seem to be alone. greet(&[\"Joan\", \"Hugh\"]); // output: Hello, Joan and Hugh. Nice to see you are at least 2! greet(&[\"John\", \"Peter\", \"Stewart\"]); // output: Hey everyone, we seem to be 3 here today.\n} fn greet(people: &[&str]) { match people { [] => println!(\"Bummer, there's no one here :(\"), [only_one] => println!(\"Hey, there {}! You seem to be alone.\", only_one), [first, second] => println!( \"Hello, {} and {}. Nice to see you are at least 2!\", first, second ), _ => println!(\"Hey everyone, we seem to be {} here today.\", people.len()), }\n} Now, you don't have to check the length first. We can also match on arrays like so: let arr = [1, 2, 3]; assert_eq!(\"ends with 3\", match arr { [_, _, 3] => \"ends with 3\", [a, b, c] => \"ends with something else\",\n});","breadcrumbs":"Rust 2018 » Slice patterns","id":"48","title":"Slice patterns"},"49":{"body":"","breadcrumbs":"Rust 2018 » More details","id":"49","title":"More details"},"5":{"body":"Your code may or may not use features that are incompatible with the new edition. In order to help transition to Rust 2018, we've included a new subcommand with Cargo. To start, let's run it: > cargo fix --edition This will check your code, and automatically fix any issues that it can. Let's look at src/lib.rs again: trait Foo { fn foo(&self, _: Box<Foo>);\n} It's re-written our code to introduce a parameter name for that trait object. In this case, since it had no name, cargo fix will replace it with _, which is conventional for unused variables. cargo fix can't always fix your code automatically. If cargo fix can't fix something, it will print the warning that it cannot fix to the console. If you see one of these warnings, you'll have to update your code manually. See the corresponding section of this guide for help, and if you have problems, please seek help at the user's forums . Keep running cargo fix --edition until you have no more warnings. Congrats! Your code is now valid in both Rust 2015 and Rust 2018!","breadcrumbs":"What are editions? » Updating your code to be compatible with the new edition","id":"5","title":"Updating your code to be compatible with the new edition"},"50":{"body":"In the first example, note in particular the _ => ... pattern. Since we are matching on a slice, it could be of any length, so we need a \"catch all pattern\" to handle it. If we forgot the _ => ... or identifier => ... pattern, we would instead get an error saying: error[E0004]: non-exhaustive patterns: `&[_, _, _]` not covered If we added a case for a slice of size 3 we would instead get: error[E0004]: non-exhaustive patterns: `&[_, _, _, _]` not covered and so on...","breadcrumbs":"Rust 2018 » Exhaustive patterns","id":"50","title":"Exhaustive patterns"},"51":{"body":"In the second example above, since arrays in Rust are of known lengths, we have to match on exactly three elements. If we try to match on 2 or 4 elements,we get the errors: error[E0527]: pattern requires 2 elements but array has 3 and error[E0527]: pattern requires 4 elements but array has 3","breadcrumbs":"Rust 2018 » Arrays and exact lengths","id":"51","title":"Arrays and exact lengths"},"52":{"body":"When it comes to slice patterns, more advanced forms are planned but have not been stabilized yet. To learn more, follow the tracking issue .","breadcrumbs":"Rust 2018 » In the pipeline","id":"52","title":"In the pipeline"},"53":{"body":"In this chapter of the guide, we discuss a few improvements to ownership and lifetimes. One of the most notable of these is default match binding modes .","breadcrumbs":"Rust 2018 » Ownership and lifetimes","id":"53","title":"Ownership and lifetimes"},"54":{"body":"Minimum Rust version: 1.31 for 2018 edition Minimum Rust version: 1.36 for 2015 edition The borrow checker has been enhanced to accept more code, via a mechanism called \"non-lexical lifetimes.\" Consider this example: fn main() { let mut x = 5; let y = &x; let z = &mut x;\n} In older Rust, this is a compile-time error: error[E0502]: cannot borrow `x` as mutable because it is also borrowed as immutable --> src/main.rs:5:18 |\n4 | let y = &x; | - immutable borrow occurs here\n5 | let z = &mut x; | ^ mutable borrow occurs here\n6 | } | - immutable borrow ends here This is because lifetimes follow \"lexical scope\"; that is, the borrow from y is considered to be held until y goes out of scope at the end of main, even though we never use y again. This code is fine, but the borrow checker could not handle it. Today, this code will compile just fine.","breadcrumbs":"Rust 2018 » Ownership and lifetimes » Non-lexical lifetimes","id":"54","title":"Non-lexical lifetimes"},"55":{"body":"What if we did use y, like this? fn main() { let mut x = 5; let y = &x; let z = &mut x; println!(\"y: {}\", y);\n} Here's the error: error[E0502]: cannot borrow `x` as mutable because it is also borrowed as immutable --> src/main.rs:5:18 |\n4 | let y = &x; | - immutable borrow occurs here\n5 | let z = &mut x; | ^ mutable borrow occurs here\n...\n8 | } | - immutable borrow ends here With non-lexical lifetimes, the error changes slightly: error[E0502]: cannot borrow `x` as mutable because it is also borrowed as immutable --> src/main.rs:5:13 |\n4 | let y = &x; | -- immutable borrow occurs here\n5 | let z = &mut x; | ^^^^^^ mutable borrow occurs here\n6 |\n7 | println!(\"y: {}\", y); | - borrow later used here Instead of pointing to where y goes out of scope, it shows you where the conflicting borrow occurs. This makes these sorts of errors far easier to debug.","breadcrumbs":"Rust 2018 » Ownership and lifetimes » Better errors","id":"55","title":"Better errors"},"56":{"body":"Minimum Rust version: 1.26 Have you ever had a borrowed Option<T> and tried to match on it? You probably wrote this: let s: &Option<String> = &Some(\"hello\".to_string()); match s { Some(s) => println!(\"s is: {}\", s), _ => (),\n}; In Rust 2015, this would fail to compile, and you would have to write the following instead: // Rust 2015 let s: &Option<String> = &Some(\"hello\".to_string()); match s { &Some(ref s) => println!(\"s is: {}\", s), _ => (),\n}; Rust 2018, by contrast, will infer the &s and refs, and your original code will Just Work. This affects not just match, but patterns everywhere, such as in let statements, closure arguments, and for loops.","breadcrumbs":"Rust 2018 » Ownership and lifetimes » Default match bindings","id":"56","title":"Default match bindings"},"57":{"body":"The mental model of patterns has shifted a bit with this change, to bring it into line with other aspects of the language. For example, when writing a for loop, you can iterate over borrowed contents of a collection by borrowing the collection itself: let my_vec: Vec<i32> = vec![0, 1, 2]; for x in &my_vec { ... } The idea is that an &T can be understood as a borrowed view of T , and so when you iterate, match, or otherwise destructure a &T you get a borrowed view of its internals as well. More formally, patterns have a \"binding mode,\" which is either by value (x), by reference (ref x), or by mutable reference (ref mut x). In Rust 2015, match always started in by-value mode, and required you to explicitly write ref or ref mut in patterns to switch to a borrowing mode. In Rust 2018, the type of the value being matched informs the binding mode, so that if you match against an &Option<String> with a Some variant, you are put into ref mode automatically, giving you a borrowed view of the internal data. Similarly, &mut Option<String> would give you a ref mut view.","breadcrumbs":"Rust 2018 » Ownership and lifetimes » More details","id":"57","title":"More details"},"58":{"body":"Minimum Rust version: 1.31 Rust 2018 allows you to explicitly mark where a lifetime is elided, for types where this elision might otherwise be unclear. To do this, you can use the special lifetime '_ much like you can explicitly mark that a type is inferred with the syntax let x: _ = ..;. Let's say, for whatever reason, that we have a simple wrapper around &'a str: struct StrWrap<'a>(&'a str); In Rust 2015, you might have written: # use std::fmt;\n# struct StrWrap<'a>(&'a str);\n// Rust 2015 fn make_wrapper(string: &str) -> StrWrap { StrWrap(string)\n} impl<'a> fmt::Debug for StrWrap<'a> { fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result { fmt.write_str(self.0) }\n} In Rust 2018, you can instead write: # use std::fmt;\n# struct StrWrap<'a>(&'a str);\n// Rust 2018 fn make_wrapper(string: &str) -> StrWrap<'_> { StrWrap(string)\n} impl fmt::Debug for StrWrap<'_> { fn fmt(&self, fmt: &mut fmt::Formatter<'_>) -> fmt::Result { fmt.write_str(self.0) }\n}","breadcrumbs":"Rust 2018 » Ownership and lifetimes » '_, the anonymous lifetime","id":"58","title":"'_, the anonymous lifetime"},"59":{"body":"In the Rust 2015 snippet above, we've used -> StrWrap. However, unless you take a look at the definition of StrWrap, it is not clear that the returned value is actually borrowing something. Therefore, starting with Rust 2018, it is deprecated to leave off the lifetime parameters for non-reference-types (types other than & and &mut). Instead, where you previously wrote -> StrWrap, you should now write -> StrWrap<'_>, making clear that borrowing is occurring. What exactly does '_ mean? It depends on the context! In output contexts, as in the return type of make_wrapper, it refers to a single lifetime for all \"output\" locations. In input contexts, a fresh lifetime is generated for each \"input location\". More concretely, to understand input contexts, consider the following example: // Rust 2015 struct Foo<'a, 'b: 'a> { field: &'a &'b str,\n} impl<'a, 'b: 'a> Foo<'a, 'b> { // some methods...\n} We can rewrite this as: # struct Foo<'a, 'b: 'a> {\n# field: &'a &'b str,\n# } // Rust 2018 impl Foo<'_, '_> { // some methods...\n} This is the same, because for each '_, a fresh lifetime is generated. Finally, the relationship 'a: 'b which the struct requires must be upheld. For more details, see the tracking issue on In-band lifetime bindings .","breadcrumbs":"Rust 2018 » Ownership and lifetimes » More details","id":"59","title":"More details"},"6":{"body":"In order to use some new features, you must explicitly opt in to the new edition. Once you're ready to commit, change your Cargo.toml to add the new edition key/value pair. For example: [package]\nname = \"foo\"\nversion = \"0.1.0\"\nauthors = [\"Your Name <you@example.com>\"]\nedition = \"2018\" If there's no edition key, Cargo will default to Rust 2015. But in this case, we've chosen 2018, and so our code is compiling with Rust 2018!","breadcrumbs":"What are editions? » Enabling the new edition to use new features","id":"6","title":"Enabling the new edition to use new features"},"60":{"body":"Minimum Rust version: 1.31 When writing impl blocks, you can now elide lifetime annotations in some situations. Consider a trait like MyIterator: trait MyIterator { type Item; fn next(&mut self) -> Option<Self::Item>;\n} In Rust 2015, if we wanted to implement this iterator for mutable references to Iterators, we'd need to write this: impl<'a, I: MyIterator> MyIterator for &'a mut I { type Item = I::Item; fn next(&mut self) -> Option<Self::Item> { (*self).next() }\n} Note all of the 'a annotations. In Rust 2018, we can write this: impl<I: MyIterator> MyIterator for &mut I { type Item = I::Item; fn next(&mut self) -> Option<Self::Item> { (*self).next() }\n} Similarly, lifetime annotations can appear due to a struct that contains references: struct SetOnDrop<'a, T> { borrow: &'a mut T, value: Option<T>,\n} In Rust 2015, to implement Drop on this struct, we'd write: impl<'a, T> Drop for SetOnDrop<'a, T> { fn drop(&mut self) { if let Some(x) = self.value.take() { *self.borrow = x; } }\n} But in Rust 2018, we can combine elision with the anonymous lifetime and write this instead. impl<T> Drop for SetOnDrop<'_, T> { fn drop(&mut self) { if let Some(x) = self.value.take() { *self.borrow = x; } }\n}","breadcrumbs":"Rust 2018 » Ownership and lifetimes » Lifetime elision in impl","id":"60","title":"Lifetime elision in impl"},"61":{"body":"Minimum Rust version: 1.31 An annotation in the form of T: 'a, where T is either a type or another lifetime, is called an \"outlives\" requirement. Note that \"outlives\" also implies 'a: 'a. One way in which edition 2018 helps you out in maintaining flow when writing programs is by removing the need to explicitly annotate these T: 'a outlives requirements in struct definitions. Instead, the requirements will be inferred from the fields present in the definitions. Consider the following struct definitions in Rust 2015: // Rust 2015 struct Ref<'a, T: 'a> { field: &'a T\n} // or written with a `where` clause: struct WhereRef<'a, T> where T: 'a { data: &'a T\n} // with nested references: struct RefRef<'a, 'b: 'a, T: 'b> { field: &'a &'b T,\n} // using an associated type: struct ItemRef<'a, T: Iterator>\nwhere T::Item: 'a\n{ field: &'a T::Item\n} In Rust 2018, since the requirements are inferred, you can instead write: // Rust 2018 struct Ref<'a, T> { field: &'a T\n} struct WhereRef<'a, T> { data: &'a T\n} struct RefRef<'a, 'b, T> { field: &'a &'b T,\n} struct ItemRef<'a, T: Iterator> { field: &'a T::Item\n} If you prefer to be more explicit in some cases, that is still possible.","breadcrumbs":"Rust 2018 » Ownership and lifetimes » T: 'a inference in structs","id":"61","title":"T: 'a inference in structs"},"62":{"body":"For more details, see the tracking issue and the RFC .","breadcrumbs":"Rust 2018 » Ownership and lifetimes » More details","id":"62","title":"More details"},"63":{"body":"Minimum Rust version: 1.17 In older Rust, you had to explicitly write the 'static lifetime in any static or const that needed a lifetime: # mod foo {\nconst NAME: &'static str = \"Ferris\";\n# }\n# mod bar {\nstatic NAME: &'static str = \"Ferris\";\n# } But 'static is the only possible lifetime there. So Rust now assumes the 'static lifetime, and you don't have to write it out: # mod foo {\nconst NAME: &str = \"Ferris\";\n# }\n# mod bar {\nstatic NAME: &str = \"Ferris\";\n# } In some situations, this can remove a lot of boilerplate: # mod foo {\n// old\nconst NAMES: &'static [&'static str; 2] = &[\"Ferris\", \"Bors\"];\n# }\n# mod bar { // new\nconst NAMES: &[&str; 2] = &[\"Ferris\", \"Bors\"];\n# }","breadcrumbs":"Rust 2018 » Ownership and lifetimes » Simpler lifetimes in static and const","id":"63","title":"Simpler lifetimes in static and const"},"64":{"body":"In this chapter of the guide, we discuss a few improvements to data types. One of these are field-init-shorthand .","breadcrumbs":"Rust 2018 » Data types","id":"64","title":"Data types"},"65":{"body":"Minimum Rust version: 1.17 In older Rust, when initializing a struct, you must always give the full set of key: value pairs for its fields: struct Point { x: i32, y: i32,\n} let a = 5;\nlet b = 6; let p = Point { x: a, y: b,\n}; However, often these variables would have the same names as the fields. So you'd end up with code that looks like this: let p = Point { x: x, y: y,\n}; Now, if the variable is of the same name, you don't have to write out both, just write out the key: struct Point { x: i32, y: i32,\n} let x = 5;\nlet y = 6; // new\nlet p = Point { x, y,\n};","breadcrumbs":"Rust 2018 » Data types » Field init shorthand","id":"65","title":"Field init shorthand"},"66":{"body":"Minimum Rust version: 1.26 Since well before Rust 1.0, you’ve been able to create exclusive ranges with .. like this: for i in 1..3 { println!(\"i: {}\", i);\n} This will print i: 1 and then i: 2. Today, you can now create an inclusive range, like this: for i in 1..=3 { println!(\"i: {}\", i);\n} This will print i: 1 and then i: 2 like before, but also i: 3; the three is included in the range. Inclusive ranges are especially useful if you want to iterate over every possible value in a range. For example, this is a surprising Rust program: fn takes_u8(x: u8) { // ...\n} fn main() { for i in 0..256 { println!(\"i: {}\", i); takes_u8(i); }\n} What does this program do? The answer: it fails to compile. The error we get when compiling has a hint: error: literal out of range for u8 --> src/main.rs:6:17 |\n6 | for i in 0..256 { | ^^^ | = note: #[deny(overflowing_literals)] on by default That’s right, since i is a u8, this overflows, and the compiler produces an error. We can do this with inclusive ranges, however: fn takes_u8(x: u8) { // ...\n} fn main() { for i in 0..=255 { println!(\"i: {}\", i); takes_u8(i); }\n} This will produce those 256 lines of output you might have been expecting.","breadcrumbs":"Rust 2018 » Data types » ..= for inclusive ranges","id":"66","title":"..= for inclusive ranges"},"67":{"body":"Minimum Rust version: 1.26 A very simple feature: Rust now has 128 bit integers! let x: i128 = 0;\nlet y: u128 = 0; These are twice the size of u64, and so can hold more values. More specifically, u128: 0 - 340,282,366,920,938,463,463,374,607,431,768,211,455 i128: −170,141,183,460,469,231,731,687,303,715,884,105,728 - 170,141,183,460,469,231,731,687,303,715,884,105,727 Whew!","breadcrumbs":"Rust 2018 » Data types » 128 bit integers","id":"67","title":"128 bit integers"},"68":{"body":"Minimum Rust version: 1.8 The various “operator equals” operators, such as += and -=, are implementable via various traits. For example, to implement += on a type of your own: use std::ops::AddAssign; #[derive(Debug)]\nstruct Count { value: i32,\n} impl AddAssign for Count { fn add_assign(&mut self, other: Count) { self.value += other.value; }\n} fn main() { let mut c1 = Count { value: 1 }; let c2 = Count { value: 5 }; c1 += c2; println!(\"{:?}\", c1);\n} This will print Count { value: 6 }.","breadcrumbs":"Rust 2018 » Data types » \"Operator-equals\" are now implementable","id":"68","title":"\"Operator-equals\" are now implementable"},"69":{"body":"Minimum Rust version: 1.19 Rust now supports unions: union MyUnion { f1: u32, f2: f32,\n} Unions are kind of like enums, but they are “untagged”. Enums have a “tag” that stores which variant is the correct one at runtime; unions don't have this tag. Since we can interpret the data held in the union using the wrong variant and Rust can’t check this for us, that means reading a union’s field is unsafe: # union MyUnion {\n# f1: u32,\n# f2: f32,\n# }\nlet mut u = MyUnion { f1: 1 }; u.f1 = 5; let value = unsafe { u.f1 }; Pattern matching works too: # union MyUnion {\n# f1: u32,\n# f2: f32,\n# }\nfn f(u: MyUnion) { unsafe { match u { MyUnion { f1: 10 } => { println!(\"ten\"); } MyUnion { f2 } => { println!(\"{}\", f2); } } }\n} When are unions useful? One major use-case is interoperability with C. C APIs can (and depending on the area, often do) expose unions, and so this makes writing API wrappers for those libraries significantly easier. Additionally, unions also simplify Rust implementations of space-efficient or cache-efficient structures relying on value representation, such as machine-word-sized unions using the least-significant bits of aligned pointers to distinguish cases. There’s still more improvements to come. For now, unions can only include Copy types and may not implement Drop. We expect to lift these restrictions in the future.","breadcrumbs":"Rust 2018 » Data types » union for an unsafe form of enum","id":"69","title":"union for an unsafe form of enum"},"7":{"body":"Editions are not only about new features and removing old ones. In any programming language, idioms change over time, and Rust is no exception. While old code will continue to compile, it might be written with different idioms today. Our sample code contains an outdated idiom. Here it is again: trait Foo { fn foo(&self, _: Box<Foo>);\n} In Rust 2018, it's considered idiomatic to use the dyn keyword for trait objects. Eventually, we want cargo fix to fix all these idioms automatically in the same manner we did for upgrading to the 2018 edition. Currently, though, the \"idiom lints\" are not ready for widespread automatic fixing. The compiler isn't making cargo fix-compatible suggestions in many cases right now, and it is making incorrect suggestions in others. Enabling the idiom lints, even with cargo fix, is likely to leave your crate either broken or with many warnings still remaining. We have plans to make these idiom migrations a seamless part of the Rust 2018 experience, but we're not there yet. As a result the following instructions are recommended only for the intrepid who are willing to work through a few compiler/Cargo bugs! With that out of the way, we can instruct Cargo to fix our code snippet with: $ cargo fix --edition-idioms Afterwards, src/lib.rs looks like this: trait Foo { fn foo(&self, _: Box<dyn Foo>);\n} We're now more idiomatic, and we didn't have to fix our code manually! Note that cargo fix may still not be able to automatically update our code. If cargo fix can't fix something, it will print a warning to the console, and you'll have to fix it manually. As mentioned before, there are known bugs around the idiom lints which means they're not all ready for prime time yet. You may get a scary-looking warning to report a bug to Cargo, which happens whenever a fix proposed by rustc actually caused code to stop compiling by accident. If you'd like cargo fix to make as much progress as possible, even if it causes code to stop compiling, you can execute: $ cargo fix --edition-idioms --broken-code This will instruct cargo fix to apply automatic suggestions regardless of whether they work or not. Like usual, you'll see the compilation result after all fixes are applied. If you notice anything wrong or unusual, please feel free to report an issue to Cargo and we'll help prioritize and fix it. Enjoy the new edition!","breadcrumbs":"What are editions? » Writing idiomatic code in a new edition","id":"7","title":"Writing idiomatic code in a new edition"},"70":{"body":"Minimum Rust version: 1.25 From Wikipedia : The CPU in modern computer hardware performs reads and writes to memory most efficiently when the data is naturally aligned, which generally means that the data address is a multiple of the data size. Data alignment refers to aligning elements according to their natural alignment. To ensure natural alignment, it may be necessary to insert some padding between structure elements or after the last element of a structure. The #[repr] attribute has a new parameter, align, that sets the alignment of your struct: struct Number(i32); assert_eq!(std::mem::align_of::<Number>(), 4);\nassert_eq!(std::mem::size_of::<Number>(), 4); #[repr(align(16))]\nstruct Align16(i32); assert_eq!(std::mem::align_of::<Align16>(), 16);\nassert_eq!(std::mem::size_of::<Align16>(), 16); If you’re working with low-level stuff, control of these kinds of things can be very important! The alignment of a type is normally not worried about as the compiler will \"do the right thing\" of picking an appropriate alignment for general use cases. There are situations, however, where a nonstandard alignment may be desired when operating with foreign systems. For example these sorts of situations tend to necessitate or be much easier with a custom alignment: Hardware can often have obscure requirements such as \"this structure is aligned to 32 bytes\" when it in fact is only composed of 4-byte values. While this can typically be manually calculated and managed, it's often also useful to express this as a property of a type to get the compiler to do a little extra work instead. C compilers like gcc and clang offer the ability to specify a custom alignment for structures, and Rust can much more easily interoperate with these types if Rust can also mirror the request for a custom alignment (e.g. passing a structure to C correctly is much easier). Custom alignment can often be used for various tricks here and there and is often convenient as \"let's play around with an implementation\" tool. For example this can be used to statically allocate page tables in a kernel or create an at-least cache-line-sized structure easily for concurrent programming. The purpose of this feature is to provide a lightweight annotation to alter the compiler-inferred alignment of a structure to enable these situations much more easily.","breadcrumbs":"Rust 2018 » Data types » Choosing alignment with the repr attribute","id":"70","title":"Choosing alignment with the repr attribute"},"71":{"body":"Minimum Rust version: 1.27 The basics of SIMD are now available! SIMD stands for “single instruction, multiple data.” Consider a function like this: pub fn foo(a: &[u8], b: &[u8], c: &mut [u8]) { for ((a, b), c) in a.iter().zip(b).zip(c) { *c = *a + *b; }\n} Here, we’re taking two slices, and adding the numbers together, placing the result in a third slice. The simplest possible way to do this would be to do exactly what the code does, and loop through each set of elements, add them together, and store it in the result. However, compilers can often do better. LLVM will usually “autovectorize” code like this, which is a fancy term for “use SIMD.” Imagine that a and b were both 16 elements long. Each element is a u8, and so that means that each slice would be 128 bits of data. Using SIMD, we could put both a and b into 128 bit registers, add them together in a single instruction, and then copy the resulting 128 bits into c. That’d be much faster! While stable Rust has always been able to take advantage of autovectorization, sometimes, the compiler just isn’t smart enough to realize that we can do something like this. Additionally, not every CPU has these features, and so LLVM may not use them so your program can be used on a wide variety of hardware. The std::arch module allows us to use these kinds of instructions directly, which means we don’t need to rely on a smart compiler. Additionally, it includes some features that allow us to choose a particular implementation based on various criteria. For example: #[cfg(all(any(target_arch = \"x86\", target_arch = \"x86_64\"), target_feature = \"avx2\"))]\nfn foo() { #[cfg(target_arch = \"x86\")] use std::arch::x86::_mm256_add_epi64; #[cfg(target_arch = \"x86_64\")] use std::arch::x86_64::_mm256_add_epi64; unsafe { _mm256_add_epi64(...); }\n} Here, we use cfg flags to choose the correct version based on the machine we’re targeting; on x86 we use that version, and on x86_64 we use its version. We can also choose at runtime: fn foo() { #[cfg(any(target_arch = \"x86\", target_arch = \"x86_64\"))] { if is_x86_feature_detected!(\"avx2\") { return unsafe { foo_avx2() }; } } foo_fallback();\n} Here, we have two versions of the function: one which uses AVX2, a specific kind of SIMD feature that lets you do 256-bit operations. The is_x86_feature_detected! macro will generate code that detects if your CPU supports AVX2, and if so, calls the foo_avx2 function. If not, then we fall back to a non-AVX implementation, foo_fallback. This means that our code will run super fast on CPUs that support AVX2, but still work on ones that don’t, albeit slower. If all of this seems a bit low-level and fiddly, well, it is! std::arch is specifically primitives for building these kinds of things. We hope to eventually stabilize a std::simd module with higher-level stuff in the future. But landing the basics now lets the ecosystem experiment with higher level libraries starting today. For example, check out the faster crate. Here’s a code snippet with no SIMD: let lots_of_3s = (&[-123.456f32; 128][..]).iter() .map(|v| { 9.0 * v.abs().sqrt().sqrt().recip().ceil().sqrt() - 4.0 - 2.0 }) .collect::<Vec<f32>>(); To use SIMD with this code via faster, you’d change it to this: let lots_of_3s = (&[-123.456f32; 128][..]).simd_iter() .simd_map(f32s(0.0), |v| { f32s(9.0) * v.abs().sqrt().rsqrt().ceil().sqrt() - f32s(4.0) - f32s(2.0) }) .scalar_collect(); It looks almost the same: simd_iter instead of iter, simd_map instead of map, f32s(2.0) instead of 2.0. But you get a SIMD-ified version generated for you. Beyond that, you may never write any of this yourself, but as always, the libraries you depend on may. For example, the regex crate contains these SIMD speedups without you needing to do anything at all!","breadcrumbs":"Rust 2018 » SIMD for faster computing","id":"71","title":"SIMD for faster computing"},"72":{"body":"In this chapter of the guide, we discuss a few improvements to the macro system. A notable addition here is the introduction of custom derive macros .","breadcrumbs":"Rust 2018 » Macros","id":"72","title":"Macros"},"73":{"body":"Minimum Rust version: 1.15 In Rust, you’ve always been able to automatically implement some traits through the derive attribute: #[derive(Debug)]\nstruct Pet { name: String,\n} The Debug trait is then implemented for Pet, with vastly less boilerplate. For example, without derive, you'd have to write this: use std::fmt; struct Pet { name: String,\n} impl fmt::Debug for Pet { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { match self { Pet { name } => { let mut debug_trait_builder = f.debug_struct(\"Pet\"); let _ = debug_trait_builder.field(\"name\", name); debug_trait_builder.finish() } } }\n} Whew! However, this only worked for traits provided as part of the standard library; it was not customizable. But now, you can tell Rust what to do when someone wants to derive your trait. This is used heavily in popular crates like serde and Diesel . For more, including learning how to build your own custom derive, see The Rust Programming Language .","breadcrumbs":"Rust 2018 » Macros » Custom Derive","id":"73","title":"Custom Derive"},"74":{"body":"Minimum Rust version: 1.31","breadcrumbs":"Rust 2018 » Macros » Macro changes","id":"74","title":"Macro changes"},"75":{"body":"In Rust 2018, you can import specific macros from external crates via use statements, rather than the old #[macro_use] attribute. For example, consider a bar crate that implements a baz! macro. In src/lib.rs: #[macro_export]\nmacro_rules! baz { () => ()\n} In your crate, you would have written // Rust 2015 #[macro_use]\nextern crate bar; fn main() { baz!();\n} Now, you write: // Rust 2018 use bar::baz; fn main() { baz!();\n} This moves macro_rules macros to be a bit closer to other kinds of items. Note that you'll still need #[macro_use] to use macros you've defined in your own crate; this feature only works for importing macros from external crates.","breadcrumbs":"Rust 2018 » Macros » macro_rules! style macros","id":"75","title":"macro_rules! style macros"},"76":{"body":"When using procedural macros to derive traits, you will have to name the macro that provides the custom derive. This generally matches the name of the trait, but check with the documentation of the crate providing the derives to be sure. For example, with Serde you would have written // Rust 2015\nextern crate serde;\n#[macro_use] extern crate serde_derive; #[derive(Serialize, Deserialize)]\nstruct Bar; Now, you write instead: // Rust 2018\nuse serde_derive::{Serialize, Deserialize}; #[derive(Serialize, Deserialize)]\nstruct Bar;","breadcrumbs":"Rust 2018 » Macros » Procedural macros","id":"76","title":"Procedural macros"},"77":{"body":"This only works for macros defined in external crates. For macros defined locally, #[macro_use] mod foo; is still required, as it was in Rust 2015.","breadcrumbs":"Rust 2018 » Macros » More details","id":"77","title":"More details"},"78":{"body":"Sometimes it is helpful or necessary to have helper macros inside your module. This can make supporting both versions of rust more complicated. For example, let's make a simplified (and slightly contrived) version of the log crate in 2015 edition style: use std::fmt; /// How important/severe the log message is.\n#[derive(Copy, Clone)]\npub enum LogLevel { Warn, Error\n} impl fmt::Display for LogLevel { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { match self { LogLevel::Warn => write!(f, \"warning\"), LogLevel::Error => write!(f, \"error\"), } }\n} // A helper macro to log the message.\n#[doc(hidden)]\n#[macro_export]\nmacro_rules! __impl_log { ($level:expr, $msg:expr) => {{ println!(\"{}: {}\", $level, $msg) }}\n} /// Warn level log message\n#[macro_export]\nmacro_rules! warn { ($($args:tt)*) => { __impl_log!($crate::LogLevel::Warn, format_args!($($args)*)) }\n} /// Error level log message\n#[macro_export]\nmacro_rules! error { ($($args:tt)*) => { __impl_log!($crate::LogLevel::Error, format_args!($($args)*)) }\n} Our __impl_log! macro is private to our module, but needs to be exported as it is called by other macros, and in 2015 edition all used macros must be exported. Now, in 2018 this example will not compile: use log::error; fn main() { error!(\"error message\");\n} will give an error message about not finding the __impl_log! macro. This is because unlike in the 2015 edition, macros are namespaced and we must import them. We could do use log::{__impl_log, error}; which would make our code compile, but __impl_log is meant to be an implementation detail! Macros with $crate:: prefix. The cleanest way to handle this situation is to use the $crate:: prefix for macros, the same as you would for any other path. Versions of the compiler >= 1.30 will handle this in both editions: macro_rules! warn { ($($args:tt)*) => { $crate::__impl_log!($crate::LogLevel::Warn, format_args!($($args)*)) }\n} // ... However, this will not work for older versions of the compiler that don't understand the $crate:: prefix for macros. Macros using local_inner_macros We also have the local_inner_macros modifier that we can add to our #[macro_export] attribute. This has the advantage of working with older rustc versions (older versions just ignore the extra modifier). The downside is that it's a bit messier: #[macro_export(local_inner_macros)]\nmacro_rules! warn { ($($args:tt)*) => { __impl_log!($crate::LogLevel::Warn, format_args!($($args)*)) }\n} So the code knows to look for any macros used locally. But wait - this won't compile, because we use the format_args! macro that isn't in our local crate (hence the convoluted example). The solution is to add a level of indirection: we create a macro that wraps format_args, but is local to our crate. That way everything works in both editions (sadly we have to pollute the global namespace a bit, but that's ok). // I've used the pattern `_<my crate name>__<macro name>` to name this macro, hopefully avoiding\n// name clashes.\n#[doc(hidden)]\n#[macro_export]\nmacro_rules! _log__format_args { ($($inner:tt)*) => { format_args! { $($inner)* } }\n} Here we're using the most general macro pattern possible, a list of token trees. We just pass whatever tokens we get to the inner macro, and rely on it to report errors. So the full 2015/2018 working example would be: use std::fmt; /// How important/severe the log message is.\n#[derive(Debug, Copy, Clone)]\npub enum LogLevel { Warn, Error\n} impl fmt::Display for LogLevel { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { match self { LogLevel::Warn => write!(f, \"warning\"), LogLevel::Error => write!(f, \"error\"), } }\n} // A helper macro to log the message.\n#[doc(hidden)]\n#[macro_export]\nmacro_rules! __impl_log { ($level:expr, $msg:expr) => {{ println!(\"{}: {}\", $level, $msg) }}\n} /// Warn level log message\n#[macro_export(local_inner_macros)]\nmacro_rules! warn { ($($args:tt)*) => { __impl_log!($crate::LogLevel::Warn, _log__format_args!($($args)*)) }\n} /// Error level log message\n#[macro_export(local_inner_macros)]\nmacro_rules! error { ($($args:tt)*) => { __impl_log!($crate::LogLevel::Error, _log__format_args!($($args)*)) }\n} #[doc(hidden)]\n#[macro_export]\nmacro_rules! _log__format_args { ($($inner:tt)*) => { format_args! { $($inner)* } }\n} Once everyone is using a rustc version >= 1.30, we can all just use the $crate:: method (2015 crates are guaranteed to carry on compiling fine with later versions of the compiler). We need to wait for package managers and larger organisations to update their compilers before this happens, so in the mean time we can use the local_inner_macros method to support everybody. :)","breadcrumbs":"Rust 2018 » Macros » Local helper macros","id":"78","title":"Local helper macros"},"79":{"body":"Minimum Rust version: 1.32 for 2018 edition Minimum Rust version: 1.37 for 2015 edition In Rust 2018, we have made a couple of changes to the macros-by-example syntax. We have added a new Kleene operator ? which means \"at most one\" repetition. This operator does not accept a separator token. We have disallowed using ? as a separator to remove ambiguity with ?. For example, consider the following Rust 2015 code: macro_rules! foo { ($a:ident, $b:expr) => { println!(\"{}\", $a); println!(\"{}\", $b); }; ($a:ident) => { println!(\"{}\", $a); }\n} Macro foo can be called with 1 or 2 arguments; the second one is optional, but you need a whole other matcher to represent this possibility. This is annoying if your matchers are long. In Rust 2018, one can simply write the following: macro_rules! foo { ($a:ident $(, $b:expr)?) => { println!(\"{}\", $a); $( println!(\"{}\", $b); )? }\n}","breadcrumbs":"Rust 2018 » Macros » At most one repetition","id":"79","title":"At most one repetition"},"8":{"body":"Rust 2015 has a theme of \"stability\". It commenced with the release of 1.0, and is the \"default edition\". The edition system was conceived in late 2017, but Rust 1.0 was released in May of 2015. As such, 2015 is the edition that you get when you don't specify any particular edition, for backwards compatibility reasons. \"Stability\" is the theme of Rust 2015 because 1.0 marked a huge change in Rust development. Previous to Rust 1.0, Rust was changing on a daily basis. This made it very difficult to write large software in Rust, and made it difficult to learn. With the release of Rust 1.0 and Rust 2015, we committed to backwards compatibility, ensuring a solid foundation for people to build projects on top of. Since it's the default edition, there's no way to port your code to Rust 2015; it just is . You'll be transitioning away from 2015, but never really to 2015. As such, there's not much else to say about it!","breadcrumbs":"Rust 2015","id":"8","title":"Rust 2015"},"80":{"body":"In this chapter of the guide, we discuss a few improvements to the compiler. A notable addition here is our new and improved error messages .","breadcrumbs":"Rust 2018 » The compiler","id":"80","title":"The compiler"},"81":{"body":"Minimum Rust version: 1.12 We're always working on error improvements, and there are little improvements in almost every Rust version, but in Rust 1.12, a significant overhaul of the error message system was created. For example, here's some code that produces an error: fn main() { let mut x = 5; let y = &x; x += 1; println!(\"{} {}\", x, y);\n} Here's the error in Rust 1.11: foo.rs:4:5: 4:11 error: cannot assign to `x` because it is borrowed [E0506]\nfoo.rs:4 x += 1; ^~~~~~\nfoo.rs:3:14: 3:15 note: borrow of `x` occurs here\nfoo.rs:3 let y = &x; ^\nfoo.rs:4:5: 4:11 help: run `rustc --explain E0506` to see a detailed explanation\nerror: aborting due to previous error Here's the error in Rust 1.28: error[E0506]: cannot assign to `x` because it is borrowed --> foo.rs:4:5 |\n3 | let y = &x; | - borrow of `x` occurs here\n4 | x += 1; | ^^^^^^ assignment to borrowed `x` occurs here error: aborting due to previous error For more information about this error, try `rustc --explain E0506`. This error isn't terribly different, but shows off how the format has changed. It shows off your code in context, rather than just showing the text of the lines themselves.","breadcrumbs":"Rust 2018 » The compiler » Improved error messages","id":"81","title":"Improved error messages"},"82":{"body":"Minimum Rust version: 1.24 Back in September of 2016, we blogged about Incremental Compilation . While that post goes into the details, the idea is basically this: when you’re working on a project, you often compile it, then change something small, then compile again. Historically, the compiler has compiled your entire project, no matter how little you’ve changed the code. The idea with incremental compilation is that you only need to compile the code you’ve actually changed, which means that that second build is faster. This is now turned on by default. This means that your builds should be faster! Don’t forget about cargo check when trying to get the lowest possible build times. This is still not the end story for compiler performance generally, nor incremental compilation specifically. We have a lot more work planned in the future. One small note about this change: it makes builds faster, but makes the final binary a bit slower. For this reason, it's not turned on in release builds.","breadcrumbs":"Rust 2018 » The compiler » Incremental Compilation","id":"82","title":"Incremental Compilation"},"83":{"body":"Minimum Rust version: 1.9 If you're writing a library, and you'd like to deprecate something, you can use the deprecated attribute: #[deprecated( since = \"0.2.1\", note = \"Please use the bar function instead\"\n)]\npub fn foo() { // ...\n} This will give your users a warning if they use the deprecated functionality: Compiling playground v0.0.1 (file:///playground)\nwarning: use of deprecated item 'foo': Please use the bar function instead --> src/main.rs:10:5 |\n10 | foo(); | ^^^ | = note: #[warn(deprecated)] on by default Both since and note are optional. since can be in the future; you can put whatever you'd like, and what's put in there isn't checked.","breadcrumbs":"Rust 2018 » The compiler » An attribute for deprecation","id":"83","title":"An attribute for deprecation"},"84":{"body":"Minimum Rust version: various (this tool has its own versioning scheme and works with all Rust versions) The Rustup tool has become the recommended way to install Rust, and is advertised on our website. Its powers go further than that though, allowing you to manage various versions, components, and platforms.","breadcrumbs":"Rust 2018 » Rustup for managing Rust versions","id":"84","title":"Rustup for managing Rust versions"},"85":{"body":"To install Rust through Rustup, you can go to https://www.rust-lang.org/install.html , which will let you know how to do so on your platform. This will install both rustup itself and the stable version of rustc and cargo. To install a specific Rust version, you can use rustup install: $ rustup install 1.30.0 This works for a specific nightly, as well: $ rustup install nightly-2018-08-01 As well as any of our release channels: $ rustup install stable\n$ rustup install beta\n$ rustup install nightly","breadcrumbs":"Rust 2018 » For installing Rust","id":"85","title":"For installing Rust"},"86":{"body":"To update all of the various channels you may have installed: $ rustup update This will look at everything you've installed, and if there are new releases, will update anything that has one.","breadcrumbs":"Rust 2018 » For updating your installation","id":"86","title":"For updating your installation"},"87":{"body":"To set the default toolchain to something other than stable: $ rustup default nightly To use a toolchain other than the default, use rustup run: $ rustup run nightly cargo build There's also an alias for this that's a little shorter: $ cargo +nightly build If you'd like to have a different default per-directory, that's easy too! If you run this inside of a project: $ rustup override set nightly Or, if you'd like to target a different version of Rust: $ rustup override set 1.30.0 Then when you're in that directory, any invocations of rustc or cargo will use that toolchain. To share this with others, you can create a rust-toolchain file with the contents of a toolchain, and check it into source control. Now, when someone clones your project, they'll get the right version without needing to override set themselves.","breadcrumbs":"Rust 2018 » Managing versions","id":"87","title":"Managing versions"},"88":{"body":"Rust supports cross-compiling to other targets, and Rustup can help you manage them. For example, to use MUSL: $ rustup target add x86_64-unknown-linux-musl And then you can $ cargo build --target=x86_64-unknown-linux-musl To see the full list of targets you can install: $ rustup target list","breadcrumbs":"Rust 2018 » Installing other targets","id":"88","title":"Installing other targets"},"89":{"body":"Components are used to install certain kinds of tools. While cargo-install has you covered for most tools, some tools need deep integration into the compiler. Rustup knows exactly what version of the compiler you're using, and so it's got just the information that these tools need. Components are per-toolchain, so if you want them to be available to more than one toolchain, you'll need to install them multiple times. In the following examples, add a --toolchain flag, set to the toolchain you want to install for, nightly for example. Without this flag, it will install the component for the default toolchain. To see the full list of components you can install: $ rustup component list Next, let's talk about some popular components and when you might want to install them.","breadcrumbs":"Rust 2018 » Installing components","id":"89","title":"Installing components"},"9":{"body":"The edition system was created for the release of Rust 2018. The theme of Rust 2018 is productivity . Rust 2018 improves upon Rust 2015 through new features, simpler syntax in some cases, a smarter borrow-checker, and a host of other things. These are all in service of the productivity goal. Rust 2015 was a foundation; Rust 2018 smooths off rough edges, makes writing code simpler and easier, and removes some inconsistencies.","breadcrumbs":"Rust 2018","id":"9","title":"Rust 2018"},"90":{"body":"This first component is installed by default when you install a toolchain. It contains a copy of Rust's documentation, so that you can read it offline. This component cannot be removed for now; if that's of interest, please comment on this issue .","breadcrumbs":"Rust 2018 » rust-docs, for local documentation","id":"90","title":"rust-docs, for local documentation"},"91":{"body":"The rust-src component can give you a local copy of Rust's source code. Why might you need this? Well, autocompletion tools like Racer use this information to know more about the functions you're trying to call. $ rustup component add rust-src","breadcrumbs":"Rust 2018 » rust-src for a copy of Rust's source code","id":"91","title":"rust-src for a copy of Rust's source code"},"92":{"body":"Minimum Rust version: 1.24 If you'd like to have your code automatically formatted, you can install this component: $ rustup component add rustfmt This will install two tools, rustfmt and cargo-fmt, that will reformat your code for you! For example: $ cargo fmt will reformat your entire Cargo project.","breadcrumbs":"Rust 2018 » rustfmt for automatic code formatting","id":"92","title":"rustfmt for automatic code formatting"},"93":{"body":"Minimum Rust version: 1.21 Many IDE features are built off of the langserver protocol . To gain support for Rust with these IDEs, you'll need to install the Rust language sever, aka the \"RLS\": $ rustup component add rls For more information about integrating this into your IDE, see the RLS documentation .","breadcrumbs":"Rust 2018 » rls for IDE integration","id":"93","title":"rls for IDE integration"},"94":{"body":"For even more lints to help you write Rust code, you can install clippy: $ rustup component add clippy This will install cargo-clippy for you: $ cargo clippy For more, check out clippy's documentation .","breadcrumbs":"Rust 2018 » clippy for more lints","id":"94","title":"clippy for more lints"},"95":{"body":"There are several components in a \"preview\" stage. These components currently have -preview in their name, and this indicates that they're not quite 100% ready for general consumption yet. Please try them out and give us feedback, but know that they do not follow Rust's stability guarantees, and are still actively changing, possibly in backwards-incompatible ways. llvm-tools-preview for using extra LLVM tools If you'd like to use the lld linker, or other tools like llvm-objdump or llvm-objcopy, you can install this component: $ rustup component add llvm-tools-preview This is the newest component, and so doesn't have good documentation at the moment.","breadcrumbs":"Rust 2018 » The \"preview\" components","id":"95","title":"The \"preview\" components"},"96":{"body":"In this chapter of the guide, we discuss a few improvements to cargo and crates.io . A notable addition here is the new cargo check command.","breadcrumbs":"Rust 2018 » Cargo and crates.io","id":"96","title":"Cargo and crates.io"},"97":{"body":"Minimum Rust version: 1.16 cargo check is a new subcommand that should speed up the development workflow in many cases. What does it do? Let's take a step back and talk about how rustc compiles your code. Compilation has many \"passes\", that is, there are many distinct steps that the compiler takes on the road from your source code to producing the final binary. However, you can think of this process in two big steps: first, rustc does all of its safety checks, makes sure your syntax is correct, all that stuff. Second, once it's satisfied that everything is in order, it produces the actual binary code that you end up executing. It turns out that that second step takes a lot of time. And most of the time, it's not neccesary. That is, when you're working on some Rust code, many developers will get into a workflow like this: Write some code. Run cargo build to make sure it compiles. Repeat 1-2 as needed. Run cargo test to make sure your tests pass. Try the binary yourself GOTO 1. In step two, you never actually run your code. You're looking for feedback from the compiler, not to actually run the binary. cargo check supports exactly this use-case: it runs all of the compiler's checks, but doesn't produce the final binary. To use it: $ cargo check where you may normally cargo build. The workflow now looks like: Write some code. Run cargo check to make sure it compiles. Repeat 1-2 as needed. Run cargo test to make sure your tests pass. Run cargo build to build a binary and try it yourself GOTO 1. So how much speedup do you actually get? Like most performance related questions, the answer is \"it depends.\" Here are some very un-scientific benchmarks at the time of writing. use case build performance check performance speedup initial compile 11s 5.6s 1.96x second compile (no changes) 3s 1.9s 1.57x third compile with small change 5.8s 3s 1.93x","breadcrumbs":"Rust 2018 » Cargo and crates.io » cargo check for faster checking","id":"97","title":"cargo check for faster checking"},"98":{"body":"Minimum Rust version: 1.5 Cargo has grown a new install command. This is intended to be used for installing new subcommands for Cargo, or tools for Rust developers. This doesn't replace the need to build real, native packages for end-users on the platforms you support. For example, this guide is created with mdbook . You can install it on your system with $ cargo install mdbook And then use it with $ mdbook --help","breadcrumbs":"Rust 2018 » Cargo and crates.io » cargo install for easy installation of tools","id":"98","title":"cargo install for easy installation of tools"},"99":{"body":"As an example of extending Cargo, you can use the cargo-update package. To install it: $ cargo install cargo-update This will allow you to use cargo install-update -a command, which checks everything you've cargo install'd and updates it to the latest version.","breadcrumbs":"Rust 2018 » Cargo and crates.io » Cargo Extensions","id":"99","title":"Cargo Extensions"}},"length":128,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{"2":{"5":{"6":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"2":{"5":{"5":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"46":{"tf":2.449489742783178}}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{".":{"0":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"1":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"85":{"tf":1.0}}},"8":{"df":1,"docs":{"85":{"tf":1.0}}},"df":3,"docs":{"29":{"tf":1.0},"46":{"tf":1.0},"67":{"tf":1.7320508075688772}}},"1":{".":{".":{"3":{"df":1,"docs":{"66":{"tf":1.0}}},"=":{"3":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{".":{"0":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"df":7,"docs":{"109":{"tf":1.7320508075688772},"118":{"tf":1.0},"123":{"tf":1.0},"28":{"tf":1.0},"45":{"tf":1.4142135623730951},"66":{"tf":1.0},"8":{"tf":2.23606797749979}},"f":{"3":{"2":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{"0":{"df":3,"docs":{"1":{"tf":1.0},"127":{"tf":1.0},"32":{"tf":1.0}}},"1":{"df":2,"docs":{"127":{"tf":1.0},"81":{"tf":1.0}}},"2":{"df":3,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"81":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"28":{"tf":1.0}}},"4":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"73":{"tf":1.0}}},"6":{"df":1,"docs":{"97":{"tf":1.0}}},"7":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}},"8":{"df":2,"docs":{"109":{"tf":1.0},"25":{"tf":1.0}}},"9":{"df":2,"docs":{"34":{"tf":1.0},"69":{"tf":1.0}}},"df":2,"docs":{"101":{"tf":1.0},"124":{"tf":1.0}}},"2":{".":{"3":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"0":{"df":2,"docs":{"1":{"tf":1.0},"46":{"tf":1.4142135623730951}}},"1":{"df":6,"docs":{"105":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"93":{"tf":1.0}}},"2":{"df":3,"docs":{"104":{"tf":1.0},"117":{"tf":1.4142135623730951},"28":{"tf":1.0}}},"3":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}},"4":{"df":2,"docs":{"82":{"tf":1.0},"92":{"tf":1.0}}},"5":{"df":5,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"26":{"tf":1.0},"70":{"tf":1.0}}},"6":{"df":7,"docs":{"109":{"tf":1.4142135623730951},"29":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}},"7":{"df":2,"docs":{"43":{"tf":1.0},"71":{"tf":1.0}}},"8":{".":{"0":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"122":{"tf":1.0},"81":{"tf":1.0}}},"df":2,"docs":{"123":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951}}},"3":{"0":{".":{"0":{"df":2,"docs":{"85":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"13":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"1":{"df":8,"docs":{"109":{"tf":1.4142135623730951},"18":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"74":{"tf":1.0}}},"2":{"df":2,"docs":{"24":{"tf":1.0},"79":{"tf":1.0}}},"6":{"df":1,"docs":{"54":{"tf":1.0}}},"7":{"df":1,"docs":{"79":{"tf":1.0}}},"df":1,"docs":{"114":{"tf":1.0}}},"5":{"7":{"df":0,"docs":{},"x":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":1,"docs":{"98":{"tf":1.0}}},"6":{"df":2,"docs":{"107":{"tf":1.0},"120":{"tf":1.0}}},"8":{"df":1,"docs":{"68":{"tf":1.0}}},"9":{"3":{"df":0,"docs":{},"x":{"df":1,"docs":{"97":{"tf":1.0}}}},"6":{"df":0,"docs":{},"x":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":3,"docs":{"31":{"tf":1.0},"83":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":2,"docs":{"124":{"tf":1.0},"95":{"tf":1.0}}},"df":2,"docs":{"69":{"tf":1.0},"83":{"tf":1.0}}},"1":{"df":1,"docs":{"97":{"tf":1.0}}},"2":{"3":{".":{"4":{"5":{"6":{"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"]":{"[":{".":{".":{"]":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"67":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"6":{"8":{"5":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"70":{"tf":1.4142135623730951},"71":{"tf":1.0}}},"7":{"0":{",":{"1":{"4":{"1":{",":{"1":{"8":{"3":{",":{"4":{"6":{"0":{",":{"4":{"6":{"9":{",":{"2":{"3":{"1":{",":{"7":{"3":{"1":{",":{"6":{"8":{"7":{",":{"3":{"0":{"3":{",":{"7":{"1":{"5":{",":{"8":{"8":{"4":{",":{"1":{"0":{"5":{",":{"7":{"2":{"7":{"df":1,"docs":{"67":{"tf":1.0}}},"8":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"7":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"1":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":9,"docs":{"40":{"tf":1.4142135623730951},"48":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.7320508075688772},"97":{"tf":2.0}}},"2":{".":{"0":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"0":{"1":{"5":{"/":{"2":{"0":{"1":{"8":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":27,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":2.0},"79":{"tf":1.4142135623730951},"8":{"tf":3.0},"9":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"82":{"tf":1.0}}},"7":{"df":1,"docs":{"8":{"tf":1.0}}},"8":{"df":33,"docs":{"10":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":2.23606797749979},"29":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"35":{"tf":1.0},"4":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"85":{"tf":1.0},"9":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"8":{"8":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"9":{"4":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"6":{"df":2,"docs":{"66":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}},"df":8,"docs":{"117":{"tf":1.0},"48":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"57":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"79":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"70":{"tf":1.0}}},"4":{"0":{",":{"2":{"8":{"2":{",":{"3":{"6":{"6":{",":{"9":{"2":{"0":{",":{"9":{"3":{"8":{",":{"4":{"6":{"3":{",":{"4":{"6":{"3":{",":{"3":{"7":{"4":{",":{"6":{"0":{"7":{",":{"4":{"3":{"1":{",":{"7":{"6":{"8":{",":{"2":{"1":{"1":{",":{"4":{"5":{"5":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"1":{"5":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"48":{"tf":2.23606797749979},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"66":{"tf":1.0},"81":{"tf":1.0}},"s":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}},"4":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},":":{"1":{"1":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"13":{"tf":1.0},"51":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"81":{"tf":1.0}}},"5":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"6":{"df":1,"docs":{"97":{"tf":1.0}}},"8":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}},"df":10,"docs":{"117":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"81":{"tf":1.0}}},"6":{"4":{"df":1,"docs":{"125":{"tf":1.0}}},"df":5,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"68":{"tf":1.0}}},"7":{"df":2,"docs":{"34":{"tf":1.4142135623730951},"55":{"tf":1.0}}},"8":{"df":1,"docs":{"55":{"tf":1.0}}},"9":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"9":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"_":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"!":{"(":{"$":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}}}}},"df":9,"docs":{"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"50":{"tf":3.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"73":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"_":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.4142135623730951}},"s":{"!":{"(":{"$":{"(":{"$":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"m":{"2":{"5":{"6":{"_":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"b":{")":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"c":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},":":{":":{"b":{":":{":":{"c":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"79":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"32":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.7320508075688772},"32":{"tf":2.0},"81":{"tf":1.4142135623730951}}}},"v":{"df":7,"docs":{"106":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.0},"79":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"47":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"1":{"tf":1.0},"95":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"59":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":2.0}}}},"df":0,"docs":{}}}},"d":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"df":19,"docs":{"1":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":2.0},"20":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":14,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"109":{"tf":1.0},"20":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":8,"docs":{"104":{"tf":1.0},"110":{"tf":1.4142135623730951},"120":{"tf":1.0},"2":{"tf":1.4142135623730951},"26":{"tf":1.0},"50":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"1":{"tf":1.0},"114":{"tf":1.4142135623730951},"52":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"2":{"tf":1.4142135623730951},"28":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"56":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"5":{"tf":1.0},"54":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":1,"docs":{"109":{"tf":1.0}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"a":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"a":{"df":2,"docs":{"42":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"1":{"6":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"69":{"tf":1.0},"70":{"tf":4.123105625617661}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":5,"docs":{"120":{"tf":1.0},"122":{"tf":3.4641016151377544},"20":{"tf":1.0},"39":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":13,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":1.0},"122":{"tf":1.4142135623730951},"13":{"tf":1.0},"31":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"58":{"tf":1.0},"71":{"tf":1.4142135623730951},"84":{"tf":1.0},"99":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"20":{"tf":1.7320508075688772},"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}},"n":{"df":2,"docs":{"106":{"tf":1.0},"44":{"tf":1.4142135623730951}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":8,"docs":{"21":{"tf":1.4142135623730951},"24":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":3,"docs":{"24":{"tf":1.0},"44":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"70":{"tf":1.0}}},"y":{"df":1,"docs":{"79":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":5,"docs":{"10":{"tf":1.0},"4":{"tf":1.0},"47":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"123":{"tf":1.0},"127":{"tf":1.0},"29":{"tf":1.0},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"97":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"106":{"tf":1.0},"114":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"31":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"86":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"38":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"31":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"120":{"tf":1.4142135623730951},"122":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0}}},"df":4,"docs":{"10":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"123":{"tf":1.0},"70":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"38":{"tf":1.0}},"s":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"37":{"tf":1.4142135623730951},"38":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"31":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":2.0}}}},"df":1,"docs":{"48":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"44":{"tf":1.0}}}}},"t":{"df":1,"docs":{"114":{"tf":1.0}}}},"s":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"r":{"#":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"1":{"6":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"1":{"6":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.7320508075688772}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"41":{"tf":1.0},"46":{"tf":3.4641016151377544},"61":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"106":{"tf":1.0},"63":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"/":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":2.23606797749979},"33":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"122":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"11":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"57":{"tf":1.0},"7":{"tf":2.0},"73":{"tf":1.0},"92":{"tf":1.4142135623730951}}}},"df":1,"docs":{"20":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"2":{"tf":1.7320508075688772},"28":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"24":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"2":{"df":1,"docs":{"71":{"tf":2.0}}},"df":1,"docs":{"71":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"33":{"tf":1.0},"4":{"tf":1.0}}}},"y":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"106":{"tf":1.7320508075688772}},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}}}}}},"b":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"1":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"100":{"tf":1.0}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":11,"docs":{"105":{"tf":2.23606797749979},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"63":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"i":{"c":{"df":2,"docs":{"71":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":1,"docs":{"8":{"tf":1.0}}}},"z":{"df":3,"docs":{"28":{"tf":1.0},"47":{"tf":1.0},"75":{"tf":2.0}}}},"df":6,"docs":{"48":{"tf":1.0},"59":{"tf":2.6457513110645907},"61":{"tf":2.23606797749979},"65":{"tf":1.4142135623730951},"71":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951}},"e":{"c":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"2":{"tf":1.0},"43":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"df":3,"docs":{"31":{"tf":1.7320508075688772},"41":{"tf":1.0},"57":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"109":{"tf":1.4142135623730951},"20":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"55":{"tf":1.0},"71":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"1":{"tf":1.0},"123":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"70":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"104":{"tf":1.0},"97":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"100":{"tf":2.23606797749979},"124":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":2.449489742783178}}}}},"d":{"df":5,"docs":{"42":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.0}}},"df":1,"docs":{"100":{"tf":1.4142135623730951}}},"t":{"df":10,"docs":{"125":{"tf":1.0},"26":{"tf":1.0},"44":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":2.23606797749979},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"82":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"63":{"tf":1.0},"73":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"109":{"tf":1.0}}},"df":8,"docs":{"108":{"tf":1.0},"109":{"tf":2.6457513110645907},"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"40":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"110":{"tf":1.4142135623730951},"113":{"tf":1.0}}}}}}}},"l":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}}},"r":{"df":1,"docs":{"63":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":8,"docs":{"54":{"tf":2.8284271247461903},"55":{"tf":3.3166247903554},"56":{"tf":1.0},"57":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"81":{"tf":2.23606797749979},"9":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":11,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"83":{"tf":1.0},"85":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":2.23606797749979}}}}},"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":4,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":3,"docs":{"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0}}}}},"i":{"3":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"100":{"tf":1.0},"107":{"tf":1.0}}}},"df":2,"docs":{"34":{"tf":2.0},"38":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"18":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"120":{"tf":1.0},"28":{"tf":1.0},"57":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"31":{"tf":1.0},"4":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"l":{"d":{"df":17,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.7320508075688772},"109":{"tf":1.0},"115":{"tf":1.0},"120":{"tf":2.0},"126":{"tf":1.4142135623730951},"3":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":2.23606797749979},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"97":{"tf":2.23606797749979},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"123":{"tf":1.0},"126":{"tf":1.0},"93":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"101":{"tf":1.0},"23":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}},"c":{"1":{"df":1,"docs":{"68":{"tf":1.7320508075688772}}},"2":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"69":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":14,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"28":{"tf":2.23606797749979},"30":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"91":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"41":{"tf":1.7320508075688772}}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"38":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":7,"docs":{"105":{"tf":1.7320508075688772},"11":{"tf":1.0},"127":{"tf":1.0},"20":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"6":{"tf":1.0}}}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"106":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":27,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":2.449489742783178},"102":{"tf":1.0},"103":{"tf":2.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":2.449489742783178},"11":{"tf":1.7320508075688772},"111":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"20":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"6":{"tf":1.0},"7":{"tf":3.4641016151377544},"82":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772},"97":{"tf":3.1622776601683795},"98":{"tf":2.0},"99":{"tf":2.6457513110645907}},"’":{"df":2,"docs":{"100":{"tf":1.0},"111":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":18,"docs":{"100":{"tf":1.0},"122":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"38":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.7320508075688772}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}},"df":5,"docs":{"17":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"40":{"tf":1.0},"50":{"tf":1.0}}}},"df":1,"docs":{"3":{"tf":1.0}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"s":{"df":5,"docs":{"100":{"tf":1.0},"107":{"tf":1.0},"117":{"tf":1.4142135623730951},"18":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"127":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":8,"docs":{"118":{"tf":1.0},"123":{"tf":1.0},"127":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"48":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"105":{"tf":1.0},"45":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"71":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":25,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"10":{"tf":1.7320508075688772},"100":{"tf":1.4142135623730951},"105":{"tf":1.0},"12":{"tf":1.4142135623730951},"122":{"tf":1.0},"125":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"3":{"tf":1.0},"38":{"tf":1.4142135623730951},"4":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":2.0},"95":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"103":{"tf":1.0},"31":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":13,"docs":{"108":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":16,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"20":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":3.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"54":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"123":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":7,"docs":{"106":{"tf":1.0},"125":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"41":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"22":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"22":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"78":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"r":{"df":5,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"59":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"100":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"121":{"tf":1.0},"31":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"94":{"tf":2.23606797749979}}},"y":{"'":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"78":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"109":{"tf":1.0}},"r":{"df":2,"docs":{"35":{"tf":1.0},"75":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":2.449489742783178},"56":{"tf":1.0}}}}}}},"o":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":39,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"124":{"tf":1.0},"127":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"24":{"tf":2.23606797749979},"28":{"tf":2.449489742783178},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":2.23606797749979},"34":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.7320508075688772},"43":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":2.6457513110645907},"54":{"tf":1.7320508075688772},"56":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":3.0},"71":{"tf":2.449489742783178},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772},"94":{"tf":1.0},"97":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"110":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"52":{"tf":1.0},"69":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"96":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"90":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"100":{"tf":1.0},"29":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"118":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"31":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"24":{"tf":1.0}}},"t":{"df":4,"docs":{"2":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":22,"docs":{"10":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":2.449489742783178},"13":{"tf":1.0},"2":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"70":{"tf":2.0},"71":{"tf":1.7320508075688772},"78":{"tf":2.8284271247461903},"80":{"tf":1.4142135623730951},"82":{"tf":3.1622776601683795},"83":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"97":{"tf":3.0}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"117":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"2":{"tf":1.0},"97":{"tf":1.0}}},"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.4142135623730951},"120":{"tf":1.0},"24":{"tf":1.0}}},"x":{"df":3,"docs":{"104":{"tf":1.4142135623730951},"24":{"tf":1.0},"37":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"122":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":2.6457513110645907},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":2.449489742783178}}},"s":{"df":1,"docs":{"70":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"13":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"59":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"35":{"tf":1.0},"70":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"106":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"32":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"24":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"18":{"tf":1.0},"44":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"18":{"tf":1.0}}}}},"i":{"d":{"df":13,"docs":{"117":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"46":{"tf":3.1622776601683795}}}}},"df":2,"docs":{"46":{"tf":3.0},"63":{"tf":2.449489742783178}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":10,"docs":{"103":{"tf":1.7320508075688772},"109":{"tf":1.0},"115":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0},"45":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"90":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"109":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.0},"87":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"59":{"tf":2.0},"81":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"2":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"122":{"tf":1.0},"31":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"70":{"tf":1.0},"87":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":6,"docs":{"109":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{":":{":":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"109":{"tf":1.0},"120":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"125":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"106":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"68":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}}}}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"31":{"tf":1.0},"79":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"18":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"50":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.7320508075688772}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"_":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"!":{"(":{"$":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":22,"docs":{"10":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"127":{"tf":1.7320508075688772},"18":{"tf":2.23606797749979},"2":{"tf":1.4142135623730951},"20":{"tf":4.242640687119285},"21":{"tf":3.0},"22":{"tf":2.8284271247461903},"24":{"tf":2.6457513110645907},"25":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":2.449489742783178},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":3.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":4,"docs":{"105":{"tf":1.0},"106":{"tf":2.23606797749979},"107":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":12,"docs":{"100":{"tf":1.4142135623730951},"104":{"tf":1.0},"117":{"tf":1.0},"3":{"tf":1.7320508075688772},"45":{"tf":1.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.4142135623730951},"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"44":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":5,"docs":{"122":{"tf":1.0},"70":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"114":{"tf":1.0}}}},"t":{"a":{"df":7,"docs":{"28":{"tf":1.4142135623730951},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":3,"docs":{"29":{"tf":1.0},"55":{"tf":1.0},"73":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"100":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":8,"docs":{"10":{"tf":1.0},"122":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"47":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"89":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":21,"docs":{"10":{"tf":1.0},"100":{"tf":2.23606797749979},"106":{"tf":1.0},"107":{"tf":1.0},"118":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.7320508075688772},"124":{"tf":1.0},"125":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":2.0},"89":{"tf":1.0},"90":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"118":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.4142135623730951},"18":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"75":{"tf":1.0},"77":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.7320508075688772}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}},"y":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":13,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":2.449489742783178},"106":{"tf":1.0},"107":{"tf":2.6457513110645907},"2":{"tf":1.0},"3":{"tf":1.4142135623730951},"32":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":3,"docs":{"105":{"tf":1.0},"59":{"tf":1.0},"83":{"tf":2.449489742783178}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"72":{"tf":1.0},"73":{"tf":2.23606797749979},"76":{"tf":1.7320508075688772}},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"68":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"106":{"tf":1.0},"46":{"tf":1.0}}}},"r":{"df":2,"docs":{"122":{"tf":1.0},"70":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":18,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":5,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"8":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.0},"24":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"123":{"tf":1.0},"24":{"tf":1.4142135623730951},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"7":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"4":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"22":{"tf":1.0},"71":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"11":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"107":{"tf":1.0},"79":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"31":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":14,"docs":{"0":{"tf":1.0},"108":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"31":{"tf":1.0},"69":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"c":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"110":{"tf":1.0},"111":{"tf":1.7320508075688772},"90":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":18,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.4142135623730951},"110":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.7320508075688772},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"76":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}}}}},"df":3,"docs":{"20":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"122":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":9,"docs":{"105":{"tf":1.0},"31":{"tf":1.4142135623730951},"39":{"tf":1.0},"48":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"71":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"109":{"tf":1.0},"31":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"114":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"60":{"tf":1.7320508075688772},"69":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"31":{"tf":1.7320508075688772},"60":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"124":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"df":6,"docs":{"10":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}},"0":{"5":{"0":{"6":{"df":1,"docs":{"81":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"df":1,"docs":{"28":{"tf":1.0}}},"a":{"c":{"df":0,"docs":{},"h":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"100":{"tf":1.4142135623730951},"110":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"s":{"df":2,"docs":{"106":{"tf":1.0},"37":{"tf":1.0}},"i":{"df":6,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":1.0},"87":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"28":{"tf":1.4142135623730951},"35":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"121":{"tf":1.0}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"107":{"tf":1.0},"71":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"9":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":23,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":2.0},"10":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":3.1622776601683795},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":2.8284271247461903},"3":{"tf":2.23606797749979},"4":{"tf":1.7320508075688772},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"5":{"tf":2.0},"54":{"tf":1.4142135623730951},"6":{"tf":2.23606797749979},"61":{"tf":1.0},"7":{"tf":2.449489742783178},"78":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979},"9":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"51":{"tf":1.7320508075688772},"70":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772}},"s":{",":{"df":0,"docs":{},"w":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"i":{"d":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}},"s":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"31":{"tf":1.0}}}}}}}}},"m":{"b":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"120":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":2.6457513110645907}}}}}}}}},"df":0,"docs":{}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"106":{"tf":1.0},"118":{"tf":1.4142135623730951},"2":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}},"o":{"d":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":8,"docs":{"18":{"tf":1.0},"48":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"65":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"24":{"tf":1.0},"71":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"70":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"82":{"tf":1.0},"92":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"24":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"(":{"df":2,"docs":{"28":{"tf":2.0},"29":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}}},"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{"df":0,"docs":{},"e":{"0":{"0":{"0":{"4":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"7":{"7":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"2":{"df":2,"docs":{"54":{"tf":1.0},"55":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}},"2":{"7":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":16,"docs":{"13":{"tf":1.4142135623730951},"2":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":3.3166247903554},"29":{"tf":2.449489742783178},"30":{"tf":1.0},"31":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.0},"66":{"tf":1.7320508075688772},"78":{"tf":3.3166247903554},"80":{"tf":1.0},"81":{"tf":3.605551275463989}}}}}},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"120":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"28":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"100":{"tf":1.0},"111":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0},"7":{"tf":1.4142135623730951},"94":{"tf":1.0}},"t":{"df":0,"docs":{},"u":{"df":5,"docs":{"123":{"tf":1.0},"20":{"tf":1.0},"42":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.0},"48":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"24":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":1.4142135623730951},"51":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"24":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":41,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":3.3166247903554},"106":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":2.0},"117":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":2.0},"79":{"tf":1.4142135623730951},"81":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"7":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"100":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"2":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"66":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"4":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"44":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"n":{"df":3,"docs":{"109":{"tf":1.0},"39":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"2":{"tf":1.0},"24":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"s":{"df":2,"docs":{"31":{"tf":1.0},"69":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"28":{"tf":1.0},"34":{"tf":1.4142135623730951},"46":{"tf":1.0},"70":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"28":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":11,"docs":{"10":{"tf":1.0},"120":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":3.4641016151377544},"21":{"tf":1.7320508075688772},"22":{"tf":2.0},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"r":{"a":{"df":4,"docs":{"46":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"f":{"(":{"df":0,"docs":{},"u":{"df":1,"docs":{"69":{"tf":1.0}}}},".":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{"df":1,"docs":{"69":{"tf":2.23606797749979}}},"2":{"df":1,"docs":{"69":{"tf":2.23606797749979}}},"3":{"2":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"46":{"tf":2.8284271247461903},"69":{"tf":1.7320508075688772}},"s":{"(":{"2":{".":{"0":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"116":{"tf":1.0},"117":{"tf":2.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"4":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.0},"31":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"118":{"tf":1.0},"40":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":2,"docs":{"110":{"tf":1.0},"55":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"71":{"tf":2.0},"82":{"tf":1.7320508075688772},"97":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":6,"docs":{"20":{"tf":1.7320508075688772},"28":{"tf":2.23606797749979},"29":{"tf":1.7320508075688772},"41":{"tf":2.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":26,"docs":{"1":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"123":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"28":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"75":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"95":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":2.449489742783178}}}}},"w":{"df":16,"docs":{"108":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"127":{"tf":1.0}}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"11":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":2.6457513110645907},"64":{"tf":1.0},"65":{"tf":1.7320508075688772},"69":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{":":{"/":{"/":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"\"":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":8,"docs":{"104":{"tf":2.0},"106":{"tf":2.0},"23":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"87":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"109":{"tf":1.4142135623730951},"127":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"d":{"df":6,"docs":{"100":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"120":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":4,"docs":{"2":{"tf":1.0},"31":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"78":{"tf":1.0}},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"115":{"tf":1.0},"117":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"48":{"tf":1.7320508075688772},"50":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}},"x":{"df":4,"docs":{"105":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":3.0},"7":{"tf":4.242640687119285}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":10,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.7320508075688772},"102":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"20":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":2.449489742783178}}}},"df":0,"docs":{},"w":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"58":{"tf":1.4142135623730951},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},":":{":":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"30":{"tf":1.0},"58":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":3,"docs":{"58":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"<":{"'":{"_":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"58":{"tf":1.4142135623730951},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"58":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951}}}},"n":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":36,"docs":{"117":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"13":{"tf":2.0},"16":{"tf":1.0},"22":{"tf":2.0},"24":{"tf":2.449489742783178},"28":{"tf":1.7320508075688772},"29":{"tf":2.0},"30":{"tf":2.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":2.0},"41":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":2.8284271247461903},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":2.0},"60":{"tf":2.23606797749979},"66":{"tf":2.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"81":{"tf":1.0},"83":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":13,"docs":{"10":{"tf":1.7320508075688772},"106":{"tf":1.0},"111":{"tf":1.0},"29":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.4142135623730951},"89":{"tf":1.0},"95":{"tf":1.0}}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"4":{"tf":1.0},"47":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},")":{"?":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{"?":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"71":{"tf":1.0}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"37":{"tf":1.0},"38":{"tf":1.0}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.0},"23":{"tf":2.23606797749979}},"s":{":":{"3":{":":{"1":{"4":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"81":{"tf":1.0}}},"4":{":":{"5":{"df":1,"docs":{"81":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"/":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"<":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{">":{"(":{"1":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"24":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"'":{"_":{"df":1,"docs":{"59":{"tf":1.0}}},"a":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"41":{"tf":1.4142135623730951}}}},"\\":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"2":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":24,"docs":{"105":{"tf":2.0},"117":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":2.23606797749979},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":2.0},"37":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"g":{"df":1,"docs":{"125":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":2.0}},"s":{"!":{"(":{"$":{"(":{"$":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"81":{"tf":1.0},"92":{"tf":1.4142135623730951}}}},"df":8,"docs":{"11":{"tf":1.0},"110":{"tf":1.0},"25":{"tf":1.7320508075688772},"31":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":3,"docs":{"113":{"tf":1.0},"13":{"tf":1.4142135623730951},"31":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"117":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":2,"docs":{"42":{"tf":1.0},"7":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{">":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}}}}},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"120":{"tf":1.4142135623730951},"125":{"tf":1.0},"2":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":2,"docs":{"1":{"tf":1.0},"124":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"24":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"2":{"df":1,"docs":{"43":{"tf":1.0}}},"df":17,"docs":{"10":{"tf":1.7320508075688772},"115":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"22":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":2.23606797749979},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"46":{"tf":2.449489742783178},"71":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"91":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"84":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"100":{"tf":1.0},"44":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":10,"docs":{"103":{"tf":2.23606797749979},"115":{"tf":1.0},"20":{"tf":2.0},"24":{"tf":1.0},"28":{"tf":1.4142135623730951},"35":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"121":{"tf":1.4142135623730951},"28":{"tf":1.0},"93":{"tf":1.0}}}}},"c":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"115":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"38":{"tf":1.0},"41":{"tf":1.0},"59":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}}}},"t":{"df":3,"docs":{"100":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":9,"docs":{"20":{"tf":1.0},"28":{"tf":1.0},"46":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"65":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}},"n":{"df":2,"docs":{"122":{"tf":1.0},"47":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"122":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":2,"docs":{"122":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"123":{"tf":1.7320508075688772}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":7,"docs":{"123":{"tf":1.0},"18":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}},"e":{"df":3,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"82":{"tf":1.0}}},"n":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"d":{"df":3,"docs":{"109":{"tf":1.0},"123":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"28":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"[":{"\"":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":1,"docs":{"0":{"tf":1.0}},"n":{"df":3,"docs":{"110":{"tf":1.0},"121":{"tf":1.0},"98":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"78":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"114":{"tf":1.0}}}}},"i":{"d":{"df":17,"docs":{"0":{"tf":1.7320508075688772},"108":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"125":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"120":{"tf":1.0}},"l":{"df":9,"docs":{"122":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.23606797749979},"29":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"50":{"tf":1.0},"54":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"1":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.0},"28":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"54":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"121":{"tf":1.0}}},"r":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}},"df":1,"docs":{"48":{"tf":1.4142135623730951}}}},"p":{"df":9,"docs":{"29":{"tf":1.0},"5":{"tf":1.7320508075688772},"61":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":2,"docs":{"104":{"tf":1.0},"78":{"tf":2.0}}}}}},"n":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":5,"docs":{"121":{"tf":1.0},"18":{"tf":1.0},"4":{"tf":1.0},"55":{"tf":1.0},"81":{"tf":1.7320508075688772}}},"df":23,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"120":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"44":{"tf":1.0},"48":{"tf":2.0},"54":{"tf":1.7320508075688772},"55":{"tf":2.449489742783178},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"96":{"tf":1.0},"97":{"tf":1.0}},"’":{"df":1,"docs":{"71":{"tf":1.0}}}}},"y":{"df":2,"docs":{"41":{"tf":1.0},"48":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"107":{"tf":1.0},"20":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"111":{"tf":1.0},"82":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"l":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"111":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"115":{"tf":1.0},"71":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"78":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"111":{"tf":1.0},"115":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"113":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}},"h":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}},"i":{"'":{"df":0,"docs":{},"m":{"df":3,"docs":{"114":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0}}},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"/":{"df":0,"docs":{},"o":{"df":2,"docs":{"120":{"tf":1.0},"28":{"tf":1.0}}}},"1":{"2":{"8":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"df":8,"docs":{"30":{"tf":2.0},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"65":{"tf":2.0},"68":{"tf":1.0}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"d":{"df":2,"docs":{"46":{"tf":2.23606797749979},"93":{"tf":2.0}},"e":{"a":{"df":4,"docs":{"118":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":2.449489742783178},"14":{"tf":1.0},"2":{"tf":1.0},"50":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"df":1,"docs":{"7":{"tf":3.1622776601683795}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.0},"4":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.7320508075688772},"55":{"tf":2.23606797749979}}}}},"p":{"df":0,"docs":{},"l":{"<":{"'":{"a":{"df":3,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":1,"docs":{"60":{"tf":1.0}}},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":18,"docs":{"30":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":2.0},"38":{"tf":2.0},"39":{"tf":2.23606797749979},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":21,"docs":{"118":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"124":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":1,"docs":{"61":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":8,"docs":{"100":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"38":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":16,"docs":{"108":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"9":{"tf":1.0},"96":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":10,"docs":{"114":{"tf":1.0},"127":{"tf":1.0},"22":{"tf":1.0},"31":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"5":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"9":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"82":{"tf":2.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":2,"docs":{"106":{"tf":1.7320508075688772},"31":{"tf":1.0}}}},"i":{"c":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"103":{"tf":1.0},"104":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"11":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.7320508075688772},"70":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":2.23606797749979}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":11,"docs":{"101":{"tf":1.0},"109":{"tf":1.0},"127":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"42":{"tf":1.0},"57":{"tf":1.0},"81":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.0},"65":{"tf":1.0}},"i":{"df":5,"docs":{"123":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0},"65":{"tf":1.0},"97":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"28":{"tf":1.0},"78":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"i":{"d":{"df":6,"docs":{"104":{"tf":1.7320508075688772},"127":{"tf":1.0},"21":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"78":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":16,"docs":{"11":{"tf":1.7320508075688772},"121":{"tf":1.0},"123":{"tf":1.7320508075688772},"125":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":3.1622776601683795},"86":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"89":{"tf":2.8284271247461903},"90":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"98":{"tf":2.449489742783178},"99":{"tf":1.7320508075688772}},"l":{"'":{"d":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"c":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":21,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"109":{"tf":1.0},"121":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"4":{"tf":1.0},"50":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"76":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"125":{"tf":1.0},"7":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.4142135623730951}},"r":{"df":2,"docs":{"89":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"n":{"d":{"df":3,"docs":{"105":{"tf":1.0},"127":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"14":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"29":{"tf":1.0},"39":{"tf":1.0},"90":{"tf":1.0}}}}},"f":{"a":{"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"127":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"123":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.4142135623730951},"5":{"tf":1.0}},"t":{"df":3,"docs":{"0":{"tf":1.0},"27":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"c":{"df":3,"docs":{"102":{"tf":1.4142135623730951},"28":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}}},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"s":{"_":{"df":0,"docs":{},"x":{"8":{"6":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}},"e":{"d":{"!":{"(":{"\"":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"39":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"u":{"df":9,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0},"90":{"tf":1.0}}}}},"t":{"'":{"df":20,"docs":{"109":{"tf":1.0},"114":{"tf":1.0},"121":{"tf":1.7320508075688772},"123":{"tf":1.0},"125":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"24":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"75":{"tf":1.0},"83":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"<":{"'":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":6,"docs":{"28":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"66":{"tf":1.0},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":10,"docs":{"1":{"tf":1.0},"111":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"85":{"tf":1.0}}}}}},"’":{"df":1,"docs":{"100":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"b":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"100":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"y":{"/":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":5,"docs":{"122":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.4142135623730951}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":12,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"25":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"n":{"d":{"df":7,"docs":{"109":{"tf":1.0},"117":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"75":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"109":{"tf":1.0},"41":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":3,"docs":{"121":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"111":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"g":{"df":12,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"127":{"tf":1.0},"13":{"tf":1.4142135623730951},"28":{"tf":2.0},"31":{"tf":1.4142135623730951},"34":{"tf":1.0},"4":{"tf":1.0},"57":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"0":{"tf":1.0},"24":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"78":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"70":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}},"r":{"df":3,"docs":{"2":{"tf":1.0},"55":{"tf":1.0},"78":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.0},"3":{"tf":1.0},"99":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"22":{"tf":1.4142135623730951},"31":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"113":{"tf":1.0},"30":{"tf":1.0},"52":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0}}}},"v":{"df":2,"docs":{"59":{"tf":1.0},"7":{"tf":1.0}}}},"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.0}}}},"t":{"'":{"df":8,"docs":{"19":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"58":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.0}}},"df":4,"docs":{"106":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"71":{"tf":1.4142135623730951}},"’":{"df":1,"docs":{"105":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}},"df":8,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"114":{"tf":1.0},"120":{"tf":1.0},"24":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"78":{"tf":2.6457513110645907}}}}},"x":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"54":{"tf":1.7320508075688772},"55":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"104":{"tf":1.0},"23":{"tf":1.4142135623730951}}}},"c":{"df":1,"docs":{"124":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"119":{"tf":1.0},"120":{"tf":2.6457513110645907}},"e":{"'":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":2,"docs":{"100":{"tf":1.4142135623730951},"127":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":16,"docs":{"0":{"tf":1.7320508075688772},"100":{"tf":2.23606797749979},"115":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":2.23606797749979},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"14":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"120":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":9,"docs":{"109":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":2.23606797749979},"60":{"tf":2.0},"61":{"tf":1.0},"63":{"tf":2.23606797749979}}}}}},"t":{"df":5,"docs":{"23":{"tf":1.0},"28":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"69":{"tf":1.0}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":7,"docs":{"20":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"81":{"tf":1.0}}},"k":{"df":2,"docs":{"124":{"tf":1.4142135623730951},"2":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}},"t":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"x":{"df":5,"docs":{"115":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":2.0},"126":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"106":{"tf":1.0},"125":{"tf":1.0},"48":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":4,"docs":{"70":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"113":{"tf":1.0},"23":{"tf":1.4142135623730951}}}}},"l":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":2,"docs":{"71":{"tf":1.4142135623730951},"95":{"tf":2.23606797749979}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":7,"docs":{"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":2.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"t":{"df":2,"docs":{"20":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"106":{"tf":2.0}}}},"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"{":{"_":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":3.0}},"i":{"c":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":2.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"100":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"47":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":14,"docs":{"1":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"28":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"p":{"df":4,"docs":{"34":{"tf":2.449489742783178},"56":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"t":{"df":6,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"29":{"tf":1.0},"63":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"3":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"w":{"df":3,"docs":{"120":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"106":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"75":{"tf":1.0},"78":{"tf":2.6457513110645907}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"75":{"tf":1.7320508075688772},"78":{"tf":3.1622776601683795},"79":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.0}}}}},"df":10,"docs":{"20":{"tf":1.7320508075688772},"28":{"tf":2.23606797749979},"71":{"tf":1.0},"72":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":2.449489742783178},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"78":{"tf":4.358898943540674},"79":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"100":{"tf":1.0},"123":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}}},"df":16,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"13":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.8284271247461903},"30":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"39":{"tf":1.0},"69":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":16,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.0},"78":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"9":{"tf":1.0},"97":{"tf":2.23606797749979}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"31":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":11,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"109":{"tf":1.0},"118":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.0},"29":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":2.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"28":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"v":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":1,"docs":{"71":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":2.0}}}}}},"df":3,"docs":{"122":{"tf":1.0},"58":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":15,"docs":{"123":{"tf":1.0},"13":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"28":{"tf":2.6457513110645907},"30":{"tf":1.0},"48":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":2.23606797749979},"57":{"tf":2.0},"69":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"106":{"tf":1.0},"123":{"tf":1.0},"82":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"98":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":17,"docs":{"1":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"121":{"tf":1.0},"13":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"59":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951}},"t":{"df":3,"docs":{"122":{"tf":1.0},"24":{"tf":1.0},"78":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"121":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"100":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"120":{"tf":1.0},"122":{"tf":1.7320508075688772},"31":{"tf":1.0},"70":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"106":{"tf":1.0},"125":{"tf":1.0},"42":{"tf":1.0},"7":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"28":{"tf":1.0},"30":{"tf":1.0},"78":{"tf":3.1622776601683795},"80":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":5,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":63,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"70":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"x":{"df":1,"docs":{"29":{"tf":1.0}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.0},"23":{"tf":2.0}}}},"df":8,"docs":{"20":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":2.0},"26":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"77":{"tf":1.0}},"e":{"df":2,"docs":{"53":{"tf":1.0},"57":{"tf":2.23606797749979}},"l":{"df":3,"docs":{"111":{"tf":1.0},"18":{"tf":1.0},"57":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":13,"docs":{"103":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":1.4142135623730951},"18":{"tf":2.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"31":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}},"e":{"'":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":49,"docs":{"100":{"tf":1.0},"103":{"tf":2.23606797749979},"104":{"tf":1.0},"105":{"tf":1.0},"110":{"tf":1.4142135623730951},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"122":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"31":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"24":{"tf":1.0},"75":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"g":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"v":{"c":{"df":1,"docs":{"123":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"h":{"df":11,"docs":{"1":{"tf":1.0},"28":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"58":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.0},"8":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"24":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"104":{"tf":1.0},"28":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"l":{"df":4,"docs":{"124":{"tf":1.4142135623730951},"125":{"tf":2.449489742783178},"126":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"54":{"tf":1.4142135623730951},"55":{"tf":2.0},"57":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":15,"docs":{"122":{"tf":1.0},"28":{"tf":2.449489742783178},"43":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"55":{"tf":2.0},"57":{"tf":2.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"81":{"tf":1.0}}}},"y":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":2.6457513110645907}}}}}}}}},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"109":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{">":{"_":{"_":{"<":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":19,"docs":{"125":{"tf":1.0},"13":{"tf":1.7320508075688772},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":2.23606797749979},"3":{"tf":2.0},"44":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"65":{"tf":1.4142135623730951},"73":{"tf":2.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"95":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"120":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"46":{"tf":2.23606797749979}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"98":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}}}}},"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{";":{"&":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"23":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"40":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"d":{"df":30,"docs":{"123":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":2.8284271247461903},"24":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.7320508075688772},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"61":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"54":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"97":{"tf":1.0}}}}},"w":{"df":36,"docs":{"1":{"tf":1.7320508075688772},"100":{"tf":2.0},"101":{"tf":1.0},"109":{"tf":1.7320508075688772},"110":{"tf":1.0},"111":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"15":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":2.23606797749979},"20":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":2.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"5":{"tf":1.7320508075688772},"6":{"tf":2.23606797749979},"63":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":1,"docs":{"89":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"48":{"tf":1.4142135623730951}},"r":{"df":2,"docs":{"28":{"tf":1.0},"44":{"tf":1.0}}}},"k":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"109":{"tf":1.0},"110":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"111":{"tf":1.0},"121":{"tf":1.4142135623730951},"20":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"85":{"tf":1.7320508075688772},"87":{"tf":2.0},"89":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":2,"docs":{"120":{"tf":1.4142135623730951},"20":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"n":{"df":7,"docs":{"1":{"tf":1.0},"107":{"tf":1.0},"50":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"70":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"108":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"53":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":18,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"117":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.7320508075688772}}},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":48,"docs":{"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"126":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"125":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":1,"docs":{"45":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"127":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"28":{"tf":1.0},"39":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"28":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":2.23606797749979},"59":{"tf":1.0},"81":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"70":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"106":{"tf":1.0},"90":{"tf":1.0}}}}}}},"k":{"(":{"_":{"df":1,"docs":{"28":{"tf":1.0}}},"df":1,"docs":{"28":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":4,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"78":{"tf":1.0}}},"l":{"d":{"df":5,"docs":{"34":{"tf":1.0},"43":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.4142135623730951},"75":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"3":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"n":{"c":{"df":4,"docs":{"121":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.0},"97":{"tf":1.0}}},"df":30,"docs":{"0":{"tf":1.4142135623730951},"100":{"tf":1.0},"103":{"tf":1.7320508075688772},"105":{"tf":1.0},"110":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":2.0},"29":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.4142135623730951},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"79":{"tf":2.0},"82":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"16":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0}}},"r":{"df":10,"docs":{"115":{"tf":1.0},"120":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"68":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"113":{"tf":1.0},"28":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"t":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"6":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}}}}},"t":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0}}}},"df":4,"docs":{"16":{"tf":1.0},"29":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"106":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":4,"docs":{"117":{"tf":1.0},"122":{"tf":1.0},"7":{"tf":1.0},"87":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":21,"docs":{"0":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"109":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"48":{"tf":2.0},"59":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"106":{"tf":1.0},"18":{"tf":1.0}}}},"df":3,"docs":{"57":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"105":{"tf":1.0},"87":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":12,"docs":{"1":{"tf":1.4142135623730951},"103":{"tf":2.449489742783178},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"11":{"tf":1.0},"3":{"tf":2.0},"6":{"tf":1.0},"78":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"35":{"tf":1.0},"70":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"31":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"c":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"27":{"tf":1.0},"31":{"tf":3.605551275463989},"32":{"tf":2.23606797749979}},"k":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.7320508075688772},"5":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"41":{"tf":1.7320508075688772}},"e":{"<":{"df":0,"docs":{},"f":{">":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}},"t":{"df":6,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"25":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"24":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":9,"docs":{"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"102":{"tf":1.0},"126":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"97":{"tf":1.7320508075688772}}}},"t":{"c":{"df":0,"docs":{},"h":{".":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":2.0}}}},"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.7320508075688772}}}}},"df":10,"docs":{"10":{"tf":2.449489742783178},"105":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"18":{"tf":2.23606797749979},"22":{"tf":1.4142135623730951},"24":{"tf":3.4641016151377544},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"78":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":10,"docs":{"10":{"tf":1.0},"28":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"50":{"tf":2.449489742783178},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"69":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}}},"y":{"df":1,"docs":{"39":{"tf":1.0}}}},"c":{"df":1,"docs":{"123":{"tf":1.0}}},"df":1,"docs":{"65":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":7,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"48":{"tf":1.0},"8":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"df":2,"docs":{"87":{"tf":1.0},"89":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"70":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.7320508075688772}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"73":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"48":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":6,"docs":{"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"52":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":7,"docs":{"115":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"122":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"98":{"tf":1.0}}}}}}},"y":{"df":2,"docs":{"100":{"tf":1.0},"70":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":9,"docs":{"103":{"tf":1.0},"109":{"tf":1.0},"117":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"83":{"tf":1.4142135623730951},"90":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"65":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"73":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"34":{"tf":1.0},"37":{"tf":2.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"107":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"28":{"tf":1.0},"46":{"tf":1.0},"84":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"105":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":1.0},"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":4,"docs":{"13":{"tf":1.0},"21":{"tf":1.4142135623730951},"28":{"tf":1.0},"78":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"s":{"df":1,"docs":{"109":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"95":{"tf":2.23606797749979}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"8":{"tf":1.0},"81":{"tf":1.4142135623730951}},"s":{"df":9,"docs":{"117":{"tf":1.0},"122":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"59":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"101":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"7":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":1,"docs":{"56":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"121":{"tf":1.0},"31":{"tf":1.0}}}}},"y":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"i":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"66":{"tf":2.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"h":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"46":{"tf":1.0},"48":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":2.23606797749979},"81":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"125":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":2.449489742783178},"4":{"tf":1.0},"5":{"tf":1.0}}}}}},"c":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"1":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"1":{"tf":1.0},"31":{"tf":1.4142135623730951},"4":{"tf":1.0},"97":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":8,"docs":{"1":{"tf":1.0},"121":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"81":{"tf":1.0},"97":{"tf":1.7320508075688772}},"t":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"31":{"tf":1.0},"32":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"31":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":14,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"122":{"tf":1.7320508075688772},"13":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"103":{"tf":1.4142135623730951},"109":{"tf":1.0},"118":{"tf":1.0},"20":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"92":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"113":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}},"i":{"d":{"df":7,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"28":{"tf":1.0},"41":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"25":{"tf":1.0}}}}},"df":7,"docs":{"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"30":{"tf":1.4142135623730951},"41":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"83":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"25":{"tf":1.7320508075688772}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"70":{"tf":1.0}}}}}},"t":{"df":6,"docs":{"104":{"tf":1.0},"18":{"tf":1.0},"37":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.4142135623730951},"38":{"tf":1.0},"95":{"tf":1.0}}}}}},"r":{"#":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"107":{"tf":1.4142135623730951},"66":{"tf":2.8284271247461903}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":2,"docs":{"13":{"tf":1.7320508075688772},"14":{"tf":1.0}}}},"b":{"df":0,"docs":{},"e":{"df":1,"docs":{"113":{"tf":1.0}}}},"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"45":{"tf":1.0}}}}},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"a":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":7,"docs":{"114":{"tf":1.0},"122":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0},"90":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}},"i":{"df":4,"docs":{"121":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":2,"docs":{"29":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"71":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"121":{"tf":1.0},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"123":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.4142135623730951},"58":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"7":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":1,"docs":{"31":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"115":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"c":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"109":{"tf":1.0},"5":{"tf":1.0}},"f":{"<":{"'":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"110":{"tf":1.0},"18":{"tf":1.4142135623730951},"21":{"tf":2.449489742783178},"45":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"<":{"'":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"107":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":3.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}}}}},"df":2,"docs":{"122":{"tf":1.0},"24":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":13,"docs":{"0":{"tf":1.0},"1":{"tf":2.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"117":{"tf":1.0},"123":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":4,"docs":{"31":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"125":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":11,"docs":{"105":{"tf":1.0},"120":{"tf":1.0},"20":{"tf":1.4142135623730951},"32":{"tf":1.0},"4":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"24":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}},"l":{"a":{"c":{"df":5,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":2.449489742783178},"45":{"tf":1.0},"5":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"30":{"tf":2.0}}}}}}},"df":3,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"r":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"1":{"6":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"106":{"tf":1.0},"46":{"tf":1.0},"79":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"69":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":10,"docs":{"120":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"29":{"tf":1.0},"51":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":2.0},"70":{"tf":1.0},"77":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"35":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"23":{"tf":1.0},"28":{"tf":1.4142135623730951},"42":{"tf":1.0},"45":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}}},"t":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.0}}}},"df":7,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":2.449489742783178},"30":{"tf":2.23606797749979},"31":{"tf":1.7320508075688772},"41":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}}},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":12,"docs":{"28":{"tf":2.6457513110645907},"29":{"tf":2.23606797749979},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"37":{"tf":1.7320508075688772},"39":{"tf":2.23606797749979},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.4142135623730951},"71":{"tf":1.0}},"s":{"_":{"a":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"f":{"c":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"47":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":5,"docs":{"32":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"87":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"93":{"tf":2.0}}},"o":{"a":{"d":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}},"t":{"df":5,"docs":{"120":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"20":{"tf":1.0}}}},"n":{"df":11,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"121":{"tf":1.0},"29":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"71":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.7320508075688772},"97":{"tf":2.8284271247461903}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"122":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":7,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"29":{"tf":1.0},"45":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"a":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"100":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":11,"docs":{"101":{"tf":2.23606797749979},"102":{"tf":1.4142135623730951},"121":{"tf":1.0},"127":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"85":{"tf":1.0},"87":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"d":{"df":0,"docs":{},"o":{"c":{"df":4,"docs":{"112":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":95,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":2.8284271247461903},"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"109":{"tf":3.0},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":2.0},"114":{"tf":1.7320508075688772},"115":{"tf":1.0},"117":{"tf":2.0},"118":{"tf":2.0},"119":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":2.6457513110645907},"122":{"tf":2.23606797749979},"123":{"tf":2.23606797749979},"124":{"tf":1.7320508075688772},"127":{"tf":2.23606797749979},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"2":{"tf":2.0},"20":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":2.0},"24":{"tf":3.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":2.23606797749979},"29":{"tf":2.23606797749979},"3":{"tf":1.4142135623730951},"31":{"tf":2.449489742783178},"32":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":2.6457513110645907},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"51":{"tf":1.0},"54":{"tf":1.7320508075688772},"56":{"tf":2.0},"57":{"tf":1.4142135623730951},"58":{"tf":2.449489742783178},"59":{"tf":2.0},"6":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":2.23606797749979},"63":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":2.0},"7":{"tf":1.7320508075688772},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"73":{"tf":2.0},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":2.23606797749979},"8":{"tf":3.3166247903554},"81":{"tf":2.23606797749979},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.0},"85":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":2.6457513110645907},"90":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":14,"docs":{"121":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"85":{"tf":2.8284271247461903},"86":{"tf":1.0},"87":{"tf":2.23606797749979},"88":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"’":{"df":2,"docs":{"109":{"tf":1.0},"120":{"tf":1.4142135623730951}}}}}}},"s":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":15,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"125":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":2.0},"28":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"y":{"df":2,"docs":{"41":{"tf":1.0},"50":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":1,"docs":{"28":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}},"df":2,"docs":{"28":{"tf":2.449489742783178},"56":{"tf":2.8284271247461903}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"108":{"tf":1.0},"109":{"tf":2.449489742783178},"25":{"tf":1.0},"31":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"105":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":26,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"115":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}},"k":{"df":1,"docs":{"5":{"tf":1.0}}},"m":{"df":4,"docs":{"18":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":2.0},"71":{"tf":1.0}}},"n":{"df":1,"docs":{"45":{"tf":1.0}}}},"g":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"f":{")":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"68":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},":":{":":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":8,"docs":{"10":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":2.449489742783178},"60":{"tf":2.23606797749979},"68":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"109":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":2,"docs":{"73":{"tf":1.0},"76":{"tf":1.4142135623730951}},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":12,"docs":{"103":{"tf":1.0},"11":{"tf":1.0},"122":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"87":{"tf":2.0},"89":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"<":{"'":{"_":{"df":1,"docs":{"60":{"tf":1.0}}},"a":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"93":{"tf":1.0},"95":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"103":{"tf":1.0},"31":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"p":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"109":{"tf":1.7320508075688772},"20":{"tf":1.0},"35":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":1.0},"43":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"87":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"28":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":4,"docs":{"104":{"tf":1.0},"109":{"tf":1.0},"55":{"tf":1.0},"81":{"tf":1.7320508075688772}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"121":{"tf":1.0},"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"18":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"f":{"3":{"2":{"df":0,"docs":{},"s":{"(":{"0":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"71":{"tf":3.1622776601683795}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"105":{"tf":1.0},"25":{"tf":1.0},"41":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"104":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"38":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"28":{"tf":1.0},"63":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"i":{"df":3,"docs":{"123":{"tf":1.0},"30":{"tf":1.0},"79":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":5,"docs":{"18":{"tf":1.4142135623730951},"24":{"tf":1.0},"30":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"103":{"tf":1.7320508075688772},"104":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"59":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"t":{"df":9,"docs":{"111":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.7320508075688772},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"1":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":5,"docs":{"101":{"tf":1.7320508075688772},"50":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"48":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"71":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"38":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"44":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"120":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0},"82":{"tf":1.4142135623730951},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"127":{"tf":1.0},"32":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"29":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"v":{"df":2,"docs":{"28":{"tf":1.0},"29":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"56":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"56":{"tf":1.0}}}}},"t":{"df":1,"docs":{"28":{"tf":1.0}}},"x":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":2.449489742783178}}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"73":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":11,"docs":{"13":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"122":{"tf":1.0},"2":{"tf":1.0},"44":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"55":{"tf":1.0},"70":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":5,"docs":{"105":{"tf":1.0},"106":{"tf":2.8284271247461903},"87":{"tf":1.0},"91":{"tf":1.4142135623730951},"97":{"tf":1.0}},"e":{".":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"120":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"45":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":10,"docs":{"10":{"tf":1.0},"115":{"tf":1.7320508075688772},"127":{"tf":1.4142135623730951},"28":{"tf":1.0},"37":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.4142135623730951},"75":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.4142135623730951}},"i":{"df":5,"docs":{"11":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"97":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"71":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{"0":{":":{"5":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"4":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{":":{"1":{"3":{"df":2,"docs":{"29":{"tf":1.0},"55":{"tf":1.0}}},"8":{"df":2,"docs":{"54":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{":":{"1":{"7":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"104":{"tf":1.0},"91":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"52":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"l":{"df":9,"docs":{"100":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"2":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":7,"docs":{"0":{"tf":1.7320508075688772},"115":{"tf":1.0},"120":{"tf":1.7320508075688772},"122":{"tf":1.0},"124":{"tf":1.0},"28":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":12,"docs":{"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"109":{"tf":1.4142135623730951},"117":{"tf":1.0},"18":{"tf":1.4142135623730951},"24":{"tf":2.0},"31":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"56":{"tf":1.0},"75":{"tf":1.0}}}}}}},"i":{"c":{"df":4,"docs":{"122":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"63":{"tf":3.3166247903554},"70":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"c":{"df":0,"docs":{},"h":{":":{":":{"df":0,"docs":{},"x":{"8":{"6":{":":{":":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"2":{"5":{"6":{"_":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"6":{"4":{":":{":":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"2":{"5":{"6":{"_":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":4,"docs":{"30":{"tf":1.0},"58":{"tf":1.4142135623730951},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"29":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":1,"docs":{"115":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"s":{":":{":":{"a":{"d":{"d":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"y":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"c":{":":{":":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"{":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.4142135623730951},"26":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"115":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0},"97":{"tf":2.23606797749979}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":14,"docs":{"106":{"tf":1.4142135623730951},"109":{"tf":1.0},"118":{"tf":1.0},"23":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.0}}},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"20":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":5,"docs":{"13":{"tf":2.449489742783178},"48":{"tf":1.0},"58":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"118":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":12,"docs":{"24":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"46":{"tf":3.605551275463989},"58":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":3.3166247903554},"65":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"48":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"<":{"'":{"_":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"59":{"tf":1.0}}},"a":{">":{"(":{"&":{"'":{"a":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":5,"docs":{"109":{"tf":1.0},"127":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"75":{"tf":1.0},"78":{"tf":1.0}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"101":{"tf":1.0},"5":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"104":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"104":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"23":{"tf":2.23606797749979},"24":{"tf":2.0}}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"30":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":10,"docs":{"100":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"18":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"24":{"tf":1.0},"39":{"tf":1.0},"71":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":22,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":2.449489742783178},"123":{"tf":2.0},"124":{"tf":1.0},"125":{"tf":2.23606797749979},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"88":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"114":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"76":{"tf":1.0},"97":{"tf":2.23606797749979}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"100":{"tf":1.0},"66":{"tf":1.0}}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":12,"docs":{"16":{"tf":1.0},"28":{"tf":2.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"58":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"124":{"tf":1.0}}},"df":13,"docs":{"115":{"tf":1.0},"12":{"tf":1.4142135623730951},"120":{"tf":1.0},"122":{"tf":2.8284271247461903},"18":{"tf":2.0},"28":{"tf":1.0},"36":{"tf":1.4142135623730951},"70":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}}}}}}},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"a":{"b":{"df":1,"docs":{"23":{"tf":1.0}},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":7,"docs":{"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772}},"s":{"_":{"df":0,"docs":{},"u":{"8":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"k":{"df":3,"docs":{"19":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"103":{"tf":1.0},"11":{"tf":2.0},"119":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"125":{"tf":2.8284271247461903},"126":{"tf":1.7320508075688772},"71":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":2.23606797749979}}}}}}},"df":5,"docs":{"38":{"tf":1.7320508075688772},"41":{"tf":2.0},"57":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979},"61":{"tf":4.358898943540674}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"39":{"tf":1.0},"41":{"tf":1.0},"73":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"29":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"71":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"30":{"tf":2.23606797749979}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"]":{"df":2,"docs":{"29":{"tf":1.7320508075688772},"30":{"tf":1.0}}},"df":8,"docs":{"105":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":2.0},"20":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"97":{"tf":2.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.0}}}},"t":{"'":{"df":7,"docs":{"20":{"tf":1.4142135623730951},"28":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.4142135623730951},"90":{"tf":1.0}}},"df":0,"docs":{},"’":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"81":{"tf":1.0},"87":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":11,"docs":{"0":{"tf":1.0},"127":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"48":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"103":{"tf":1.0},"2":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}},"’":{"df":2,"docs":{"120":{"tf":1.0},"69":{"tf":1.0}}}}},"y":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"31":{"tf":1.0},"87":{"tf":1.0}}}},"r":{"df":3,"docs":{"41":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":10,"docs":{"0":{"tf":1.0},"120":{"tf":1.0},"18":{"tf":1.4142135623730951},"26":{"tf":1.0},"34":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"9":{"tf":1.0}}},"k":{"df":4,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"28":{"tf":1.0},"97":{"tf":1.0}}}},"r":{"d":{"df":2,"docs":{"71":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"120":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":9,"docs":{"100":{"tf":1.0},"111":{"tf":1.0},"28":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"7":{"tf":1.0},"84":{"tf":1.0}},"t":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"31":{"tf":3.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"51":{"tf":1.0},"66":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":11,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"113":{"tf":1.0},"121":{"tf":1.0},"127":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0}}}}},"w":{"df":1,"docs":{"31":{"tf":1.0}}}}},"u":{"df":1,"docs":{"31":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":12,"docs":{"100":{"tf":1.4142135623730951},"106":{"tf":1.0},"110":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"54":{"tf":1.0},"7":{"tf":1.4142135623730951},"78":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.0}}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":9,"docs":{"118":{"tf":1.0},"120":{"tf":1.0},"29":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.4142135623730951},"54":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"71":{"tf":1.7320508075688772}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"78":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}},"n":{"df":1,"docs":{"0":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"125":{"tf":1.0}}}}}}}}}},"df":5,"docs":{"123":{"tf":2.6457513110645907},"125":{"tf":1.7320508075688772},"87":{"tf":2.23606797749979},"89":{"tf":2.23606797749979},"90":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":10,"docs":{"1":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"70":{"tf":1.0},"84":{"tf":1.4142135623730951},"89":{"tf":2.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":2.0},"98":{"tf":1.4142135623730951}}}},"p":{"df":4,"docs":{"104":{"tf":1.0},"120":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"30":{"tf":1.0},"42":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.0}}},"t":{">":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":23,"docs":{"10":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":2.449489742783178},"36":{"tf":1.7320508075688772},"37":{"tf":2.6457513110645907},"38":{"tf":3.0},"39":{"tf":3.872983346207417},"4":{"tf":1.0},"40":{"tf":2.449489742783178},"41":{"tf":2.449489742783178},"42":{"tf":2.23606797749979},"43":{"tf":3.605551275463989},"44":{"tf":3.3166247903554},"45":{"tf":1.7320508075688772},"46":{"tf":3.4641016151377544},"47":{"tf":2.0},"5":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"7":{"tf":1.7320508075688772},"73":{"tf":2.0},"76":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"4":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":19,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"105":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"28":{"tf":2.449489742783178},"29":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.4142135623730951}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"107":{"tf":1.0},"109":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"106":{"tf":1.0}}}}},"y":{"!":{"(":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"!":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"!":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"(":{")":{")":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{")":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":6,"docs":{"19":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"44":{"tf":1.0},"82":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"111":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":15,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"103":{"tf":1.0},"109":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"71":{"tf":1.4142135623730951},"92":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":23,"docs":{"101":{"tf":2.0},"127":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":3.0},"42":{"tf":1.7320508075688772},"45":{"tf":2.0},"46":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.7320508075688772}}},"i":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{".":{"df":0,"docs":{},"f":{"1":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"1":{"2":{"8":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"df":2,"docs":{"46":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"6":{"4":{"df":2,"docs":{"41":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"66":{"tf":2.0},"71":{"tf":2.0}}},"df":1,"docs":{"69":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"1":{"tf":1.0},"59":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"u":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":2,"docs":{"40":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":3.605551275463989}},"’":{"df":1,"docs":{"69":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"40":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":4,"docs":{"121":{"tf":2.8284271247461903},"125":{"tf":1.7320508075688772},"126":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"59":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"100":{"tf":1.0},"107":{"tf":1.0},"78":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"107":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":3,"docs":{"114":{"tf":1.4142135623730951},"69":{"tf":2.0},"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"24":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":2,"docs":{"31":{"tf":2.6457513110645907},"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.7320508075688772},"105":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":2.0},"99":{"tf":2.0}}}},"df":0,"docs":{}},"df":11,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"65":{"tf":1.0},"97":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"106":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.0},"46":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"df":75,"docs":{"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":2.0},"107":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"120":{"tf":2.23606797749979},"121":{"tf":1.4142135623730951},"122":{"tf":2.23606797749979},"123":{"tf":1.7320508075688772},"124":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":3.3166247903554},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"24":{"tf":3.872983346207417},"25":{"tf":1.0},"26":{"tf":2.6457513110645907},"28":{"tf":3.605551275463989},"29":{"tf":2.6457513110645907},"3":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"31":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":2.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"42":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.0},"7":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":3.4641016151377544},"73":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"78":{"tf":3.7416573867739413},"79":{"tf":1.0},"83":{"tf":2.23606797749979},"85":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"91":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"5":{"tf":1.0}}},"df":8,"docs":{"1":{"tf":1.7320508075688772},"111":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"83":{"tf":1.0},"98":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"103":{"tf":1.0}}}}}},"v":{".":{"a":{"b":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{")":{".":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{")":{".":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"1":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"0":{".":{"0":{".":{"1":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"2":{"(":{"df":1,"docs":{"24":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"109":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"30":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":14,"docs":{"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"34":{"tf":1.7320508075688772},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":6,"docs":{"110":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"df":2,"docs":{"122":{"tf":1.0},"71":{"tf":1.0}},"e":{"c":{"!":{"[":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"100":{"tf":1.0},"31":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"97":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":71,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.7320508075688772},"109":{"tf":2.8284271247461903},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.449489742783178},"73":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":2.8284271247461903},"79":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.23606797749979},"85":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"u":{"df":1,"docs":{"41":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"a":{"df":6,"docs":{"118":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"54":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"57":{"tf":2.0}}}},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"25":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"105":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.4142135623730951},"41":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"n":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":5,"docs":{"2":{"tf":1.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"78":{"tf":3.1622776601683795},"83":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":1,"docs":{"121":{"tf":2.0}}},"df":0,"docs":{}},"df":1,"docs":{"121":{"tf":1.0}}}},"y":{"df":21,"docs":{"0":{"tf":1.4142135623730951},"101":{"tf":1.0},"122":{"tf":1.7320508075688772},"18":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":2.23606797749979},"34":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"61":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"d":{"df":4,"docs":{"101":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"101":{"tf":1.0},"125":{"tf":1.0},"35":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":6,"docs":{"110":{"tf":1.0},"28":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0}}},"v":{"df":5,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0}}}},"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"121":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":2,"docs":{"1":{"tf":1.0},"111":{"tf":1.0}}}},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":15,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"57":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"’":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"v":{"df":3,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"115":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":3,"docs":{"58":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.0}}}},"’":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"<":{"'":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":1,"docs":{"125":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"7":{"tf":1.0}}}}}},"w":{"df":2,"docs":{"67":{"tf":1.0},"73":{"tf":1.0}}}},"o":{"'":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"1":{"tf":1.0},"79":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"107":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"123":{"tf":2.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"31":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"22":{"tf":1.0},"28":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"20":{"tf":1.0},"35":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":3,"docs":{"107":{"tf":1.0},"28":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":32,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"111":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"24":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"56":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":2.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"97":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"97":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"103":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}},"s":{"df":1,"docs":{"29":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}},"w":{"df":1,"docs":{"1":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"!":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"78":{"tf":2.0}}}},"df":0,"docs":{}},"df":35,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":15,"docs":{"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"118":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"69":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"28":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"df":5,"docs":{"123":{"tf":1.0},"125":{"tf":1.7320508075688772},"126":{"tf":1.0},"71":{"tf":2.0},"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":2.0}}},"df":0,"docs":{}},"df":13,"docs":{"117":{"tf":1.4142135623730951},"22":{"tf":2.0},"34":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"54":{"tf":2.449489742783178},"55":{"tf":3.0},"57":{"tf":2.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":2.6457513110645907},"67":{"tf":1.0},"81":{"tf":3.605551275463989}}},"y":{"df":5,"docs":{"54":{"tf":2.23606797749979},"55":{"tf":2.6457513110645907},"65":{"tf":2.6457513110645907},"67":{"tf":1.0},"81":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"109":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":14,"docs":{"102":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"92":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":13,"docs":{"106":{"tf":1.0},"127":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"20":{"tf":2.0},"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"75":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}},"r":{"df":16,"docs":{"106":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"127":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"41":{"tf":1.0},"6":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"v":{"df":4,"docs":{"20":{"tf":1.0},"75":{"tf":1.0},"86":{"tf":1.0},"99":{"tf":1.0}}}},"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"71":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}}}},"’":{"d":{"df":2,"docs":{"46":{"tf":1.4142135623730951},"71":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"109":{"tf":1.0},"115":{"tf":1.0}}}},"r":{"df":2,"docs":{"70":{"tf":1.0},"82":{"tf":1.0}}},"v":{"df":4,"docs":{"26":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}}},"z":{"df":3,"docs":{"101":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772}}}}},"breadcrumbs":{"root":{"0":{".":{".":{"2":{"5":{"6":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"2":{"5":{"5":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"46":{"tf":2.449489742783178}}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{".":{"0":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"1":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"85":{"tf":1.0}}},"8":{"df":1,"docs":{"85":{"tf":1.0}}},"df":3,"docs":{"29":{"tf":1.0},"46":{"tf":1.0},"67":{"tf":1.7320508075688772}}},"1":{".":{".":{"3":{"df":1,"docs":{"66":{"tf":1.0}}},"=":{"3":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{".":{"0":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"df":7,"docs":{"109":{"tf":1.7320508075688772},"118":{"tf":1.0},"123":{"tf":1.0},"28":{"tf":1.0},"45":{"tf":1.4142135623730951},"66":{"tf":1.0},"8":{"tf":2.23606797749979}},"f":{"3":{"2":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{"0":{"df":3,"docs":{"1":{"tf":1.0},"127":{"tf":1.0},"32":{"tf":1.0}}},"1":{"df":2,"docs":{"127":{"tf":1.0},"81":{"tf":1.0}}},"2":{"df":3,"docs":{"103":{"tf":1.0},"106":{"tf":1.0},"81":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"28":{"tf":1.0}}},"4":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"73":{"tf":1.0}}},"6":{"df":1,"docs":{"97":{"tf":1.0}}},"7":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}},"8":{"df":2,"docs":{"109":{"tf":1.0},"25":{"tf":1.0}}},"9":{"df":2,"docs":{"34":{"tf":1.0},"69":{"tf":1.0}}},"df":2,"docs":{"101":{"tf":1.0},"124":{"tf":1.0}}},"2":{".":{"3":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"0":{"df":2,"docs":{"1":{"tf":1.0},"46":{"tf":1.4142135623730951}}},"1":{"df":6,"docs":{"105":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"93":{"tf":1.0}}},"2":{"df":3,"docs":{"104":{"tf":1.0},"117":{"tf":1.4142135623730951},"28":{"tf":1.0}}},"3":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}},"4":{"df":2,"docs":{"82":{"tf":1.0},"92":{"tf":1.0}}},"5":{"df":5,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"26":{"tf":1.0},"70":{"tf":1.0}}},"6":{"df":7,"docs":{"109":{"tf":1.4142135623730951},"29":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}},"7":{"df":2,"docs":{"43":{"tf":1.0},"71":{"tf":1.0}}},"8":{".":{"0":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"122":{"tf":1.0},"81":{"tf":1.0}}},"df":2,"docs":{"123":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951}}},"3":{"0":{".":{"0":{"df":2,"docs":{"85":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"13":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"1":{"df":8,"docs":{"109":{"tf":1.4142135623730951},"18":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"74":{"tf":1.0}}},"2":{"df":2,"docs":{"24":{"tf":1.0},"79":{"tf":1.0}}},"6":{"df":1,"docs":{"54":{"tf":1.0}}},"7":{"df":1,"docs":{"79":{"tf":1.0}}},"df":1,"docs":{"114":{"tf":1.0}}},"5":{"7":{"df":0,"docs":{},"x":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":1,"docs":{"98":{"tf":1.0}}},"6":{"df":2,"docs":{"107":{"tf":1.0},"120":{"tf":1.0}}},"8":{"df":1,"docs":{"68":{"tf":1.0}}},"9":{"3":{"df":0,"docs":{},"x":{"df":1,"docs":{"97":{"tf":1.0}}}},"6":{"df":0,"docs":{},"x":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":3,"docs":{"31":{"tf":1.0},"83":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":2,"docs":{"124":{"tf":1.0},"95":{"tf":1.0}}},"df":2,"docs":{"69":{"tf":1.0},"83":{"tf":1.0}}},"1":{"df":1,"docs":{"97":{"tf":1.0}}},"2":{"3":{".":{"4":{"5":{"6":{"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"]":{"[":{".":{".":{"]":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"67":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"6":{"8":{"5":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"70":{"tf":1.4142135623730951},"71":{"tf":1.0}}},"7":{"0":{",":{"1":{"4":{"1":{",":{"1":{"8":{"3":{",":{"4":{"6":{"0":{",":{"4":{"6":{"9":{",":{"2":{"3":{"1":{",":{"7":{"3":{"1":{",":{"6":{"8":{"7":{",":{"3":{"0":{"3":{",":{"7":{"1":{"5":{",":{"8":{"8":{"4":{",":{"1":{"0":{"5":{",":{"7":{"2":{"7":{"df":1,"docs":{"67":{"tf":1.0}}},"8":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"7":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"1":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":9,"docs":{"40":{"tf":1.4142135623730951},"48":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.7320508075688772},"97":{"tf":2.0}}},"2":{".":{"0":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"0":{"1":{"5":{"/":{"2":{"0":{"1":{"8":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":27,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":2.0},"79":{"tf":1.4142135623730951},"8":{"tf":3.1622776601683795},"9":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"82":{"tf":1.0}}},"7":{"df":1,"docs":{"8":{"tf":1.0}}},"8":{"df":125,"docs":{"10":{"tf":2.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.7320508075688772},"11":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":2.449489742783178},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":2.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":2.0},"59":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":2.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":2.449489742783178},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"8":{"8":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"9":{"4":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"6":{"df":2,"docs":{"66":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}},"df":8,"docs":{"117":{"tf":1.0},"48":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"57":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"79":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"70":{"tf":1.0}}},"4":{"0":{",":{"2":{"8":{"2":{",":{"3":{"6":{"6":{",":{"9":{"2":{"0":{",":{"9":{"3":{"8":{",":{"4":{"6":{"3":{",":{"4":{"6":{"3":{",":{"3":{"7":{"4":{",":{"6":{"0":{"7":{",":{"4":{"3":{"1":{",":{"7":{"6":{"8":{",":{"2":{"1":{"1":{",":{"4":{"5":{"5":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"1":{"5":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"48":{"tf":2.23606797749979},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"66":{"tf":1.0},"81":{"tf":1.0}},"s":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}},"4":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},":":{"1":{"1":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"13":{"tf":1.0},"51":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"81":{"tf":1.0}}},"5":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"6":{"df":1,"docs":{"97":{"tf":1.0}}},"8":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}},"df":10,"docs":{"117":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"81":{"tf":1.0}}},"6":{"4":{"df":1,"docs":{"125":{"tf":1.0}}},"df":5,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"68":{"tf":1.0}}},"7":{"df":2,"docs":{"34":{"tf":1.4142135623730951},"55":{"tf":1.0}}},"8":{"df":1,"docs":{"55":{"tf":1.0}}},"9":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"9":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"_":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"!":{"(":{"$":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}}}}},"df":9,"docs":{"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"50":{"tf":3.0},"56":{"tf":1.4142135623730951},"58":{"tf":2.0},"59":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"73":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"_":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.4142135623730951}},"s":{"!":{"(":{"$":{"(":{"$":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"m":{"2":{"5":{"6":{"_":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"b":{")":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"c":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},":":{":":{"b":{":":{":":{"c":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"79":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"32":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"81":{"tf":1.4142135623730951}}}},"v":{"df":7,"docs":{"106":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.0},"79":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"47":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"1":{"tf":1.0},"95":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"59":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":2.0}}}},"df":0,"docs":{}}}},"d":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"df":19,"docs":{"1":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":2.0},"20":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":14,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"109":{"tf":1.0},"20":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":8,"docs":{"104":{"tf":1.0},"110":{"tf":1.4142135623730951},"120":{"tf":1.0},"2":{"tf":1.4142135623730951},"26":{"tf":1.0},"50":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"1":{"tf":1.0},"114":{"tf":1.4142135623730951},"52":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"2":{"tf":1.4142135623730951},"28":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"56":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"5":{"tf":1.0},"54":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":1,"docs":{"109":{"tf":1.0}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"a":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"a":{"df":2,"docs":{"42":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"1":{"6":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"69":{"tf":1.0},"70":{"tf":4.242640687119285}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":5,"docs":{"120":{"tf":1.0},"122":{"tf":3.605551275463989},"20":{"tf":1.0},"39":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":13,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":1.0},"122":{"tf":1.4142135623730951},"13":{"tf":1.0},"31":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"58":{"tf":1.0},"71":{"tf":1.4142135623730951},"84":{"tf":1.0},"99":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"20":{"tf":1.7320508075688772},"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}},"n":{"df":2,"docs":{"106":{"tf":1.0},"44":{"tf":1.4142135623730951}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":8,"docs":{"21":{"tf":1.4142135623730951},"24":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":3,"docs":{"24":{"tf":1.0},"44":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"70":{"tf":1.0}}},"y":{"df":1,"docs":{"79":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":5,"docs":{"10":{"tf":1.0},"4":{"tf":1.0},"47":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"60":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"123":{"tf":1.0},"127":{"tf":1.0},"29":{"tf":1.0},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"66":{"tf":1.0},"97":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"106":{"tf":1.0},"114":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"31":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"86":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"38":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"31":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"120":{"tf":1.4142135623730951},"122":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0}}},"df":4,"docs":{"10":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"123":{"tf":1.0},"70":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"101":{"tf":1.7320508075688772},"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"38":{"tf":1.0}},"s":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"37":{"tf":1.4142135623730951},"38":{"tf":2.0},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"31":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":2.23606797749979}}}},"df":1,"docs":{"48":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"44":{"tf":1.0}}}}},"t":{"df":1,"docs":{"114":{"tf":1.0}}}},"s":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"r":{"#":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"1":{"6":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"1":{"6":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.7320508075688772}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"41":{"tf":1.0},"46":{"tf":3.605551275463989},"61":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"106":{"tf":1.0},"63":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"/":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":2.449489742783178},"33":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"122":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"73":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"11":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"57":{"tf":1.0},"7":{"tf":2.0},"73":{"tf":1.0},"92":{"tf":1.7320508075688772}}}},"df":1,"docs":{"20":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"2":{"tf":1.7320508075688772},"28":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"24":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"2":{"df":1,"docs":{"71":{"tf":2.0}}},"df":1,"docs":{"71":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":1.7320508075688772},"33":{"tf":1.0},"4":{"tf":1.0}}}},"y":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"106":{"tf":1.7320508075688772}},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}}}}}},"b":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"1":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"100":{"tf":1.0}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":11,"docs":{"105":{"tf":2.23606797749979},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"63":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"i":{"c":{"df":2,"docs":{"71":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":1,"docs":{"8":{"tf":1.0}}}},"z":{"df":3,"docs":{"28":{"tf":1.0},"47":{"tf":1.0},"75":{"tf":2.0}}}},"df":6,"docs":{"48":{"tf":1.0},"59":{"tf":2.6457513110645907},"61":{"tf":2.23606797749979},"65":{"tf":1.4142135623730951},"71":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951}},"e":{"c":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"2":{"tf":1.0},"43":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"df":3,"docs":{"31":{"tf":1.7320508075688772},"41":{"tf":1.0},"57":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"109":{"tf":1.4142135623730951},"20":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"1":{"tf":1.0},"123":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"70":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"104":{"tf":1.0},"97":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"100":{"tf":2.449489742783178},"124":{"tf":1.7320508075688772},"126":{"tf":1.0},"127":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":2.449489742783178}}}}},"d":{"df":5,"docs":{"42":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.0}}},"df":1,"docs":{"100":{"tf":1.4142135623730951}}},"t":{"df":10,"docs":{"125":{"tf":1.0},"26":{"tf":1.0},"44":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.0},"71":{"tf":2.23606797749979},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"82":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"63":{"tf":1.0},"73":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"109":{"tf":1.0}}},"df":8,"docs":{"108":{"tf":1.0},"109":{"tf":2.8284271247461903},"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"40":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"110":{"tf":1.7320508075688772},"113":{"tf":1.0}}}}}}}},"l":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}}},"r":{"df":1,"docs":{"63":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":8,"docs":{"54":{"tf":2.8284271247461903},"55":{"tf":3.3166247903554},"56":{"tf":1.0},"57":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"81":{"tf":2.23606797749979},"9":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":11,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"83":{"tf":1.0},"85":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":2.23606797749979}}}}},"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":4,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":3,"docs":{"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0}}}}},"i":{"3":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"100":{"tf":1.0},"107":{"tf":1.0}}}},"df":2,"docs":{"34":{"tf":2.23606797749979},"38":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"18":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"120":{"tf":1.0},"28":{"tf":1.0},"57":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"31":{"tf":1.0},"4":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"l":{"d":{"df":17,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.7320508075688772},"109":{"tf":1.0},"115":{"tf":1.0},"120":{"tf":2.0},"126":{"tf":1.7320508075688772},"3":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":2.23606797749979},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"97":{"tf":2.23606797749979},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"123":{"tf":1.0},"126":{"tf":1.0},"93":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"101":{"tf":1.0},"23":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}},"c":{"1":{"df":1,"docs":{"68":{"tf":1.7320508075688772}}},"2":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"69":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":14,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"28":{"tf":2.23606797749979},"30":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"91":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"41":{"tf":1.7320508075688772}}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"38":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":7,"docs":{"105":{"tf":1.7320508075688772},"11":{"tf":1.0},"127":{"tf":1.0},"20":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"6":{"tf":1.0}}}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"106":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":28,"docs":{"100":{"tf":2.23606797749979},"101":{"tf":2.8284271247461903},"102":{"tf":1.4142135623730951},"103":{"tf":2.449489742783178},"104":{"tf":1.7320508075688772},"105":{"tf":1.7320508075688772},"106":{"tf":2.8284271247461903},"107":{"tf":1.0},"11":{"tf":2.0},"111":{"tf":2.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"20":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"6":{"tf":1.0},"7":{"tf":3.4641016151377544},"82":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"96":{"tf":2.0},"97":{"tf":3.4641016151377544},"98":{"tf":2.449489742783178},"99":{"tf":3.0}},"’":{"df":2,"docs":{"100":{"tf":1.0},"111":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":18,"docs":{"100":{"tf":1.0},"122":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"38":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.7320508075688772}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}},"df":5,"docs":{"17":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"40":{"tf":1.0},"50":{"tf":1.0}}}},"df":1,"docs":{"3":{"tf":1.0}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"s":{"df":5,"docs":{"100":{"tf":1.0},"107":{"tf":1.0},"117":{"tf":1.4142135623730951},"18":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"127":{"tf":2.0}}},"df":0,"docs":{}}}}},"df":8,"docs":{"118":{"tf":1.0},"123":{"tf":1.0},"127":{"tf":2.0},"31":{"tf":1.4142135623730951},"48":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"105":{"tf":1.0},"45":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"71":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":25,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"10":{"tf":2.0},"100":{"tf":1.4142135623730951},"105":{"tf":1.0},"12":{"tf":1.4142135623730951},"122":{"tf":1.0},"125":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"3":{"tf":1.0},"38":{"tf":1.4142135623730951},"4":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":2.0},"95":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"103":{"tf":1.0},"31":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":13,"docs":{"108":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":16,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"20":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":3.3166247903554},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"54":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"123":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":7,"docs":{"106":{"tf":1.0},"125":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"41":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"22":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"22":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.0},"18":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"78":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"r":{"df":5,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"59":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"100":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"121":{"tf":1.0},"31":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"94":{"tf":2.449489742783178}}},"y":{"'":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"78":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"109":{"tf":1.0}},"r":{"df":2,"docs":{"35":{"tf":1.0},"75":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":2.6457513110645907},"56":{"tf":1.0}}}}}}},"o":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":39,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"124":{"tf":1.0},"127":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"24":{"tf":2.23606797749979},"28":{"tf":2.449489742783178},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":2.23606797749979},"34":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.7320508075688772},"43":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":2.8284271247461903},"54":{"tf":1.7320508075688772},"56":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":3.1622776601683795},"71":{"tf":2.449489742783178},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":2.0},"94":{"tf":1.0},"97":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"110":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"52":{"tf":1.0},"69":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"96":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"90":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"100":{"tf":1.0},"29":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"118":{"tf":2.449489742783178}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"31":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"24":{"tf":1.0}}},"t":{"df":4,"docs":{"2":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":23,"docs":{"10":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":2.6457513110645907},"13":{"tf":1.0},"2":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"70":{"tf":2.0},"71":{"tf":1.7320508075688772},"78":{"tf":2.8284271247461903},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"82":{"tf":3.4641016151377544},"83":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"97":{"tf":3.0}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"117":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"2":{"tf":1.0},"97":{"tf":1.0}}},"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.4142135623730951},"120":{"tf":1.0},"24":{"tf":1.0}}},"x":{"df":3,"docs":{"104":{"tf":1.4142135623730951},"24":{"tf":1.0},"37":{"tf":1.4142135623730951}}}},"i":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"122":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":2.8284271247461903},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":2.6457513110645907}}},"s":{"df":1,"docs":{"70":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"13":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"59":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"35":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"106":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"32":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"24":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"18":{"tf":1.0},"44":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"18":{"tf":1.0}}}}},"i":{"d":{"df":13,"docs":{"117":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"46":{"tf":3.3166247903554}}}}},"df":2,"docs":{"46":{"tf":3.0},"63":{"tf":2.6457513110645907}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":10,"docs":{"103":{"tf":1.7320508075688772},"109":{"tf":1.0},"115":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0},"45":{"tf":1.4142135623730951},"60":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"90":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"109":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.0},"87":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"59":{"tf":2.0},"81":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"2":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":7,"docs":{"122":{"tf":1.0},"31":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"70":{"tf":1.0},"87":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":6,"docs":{"109":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{":":{":":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"109":{"tf":1.0},"120":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"125":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"106":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"68":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}}}}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"31":{"tf":1.0},"79":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"18":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"50":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.7320508075688772}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"_":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"!":{"(":{"$":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":22,"docs":{"10":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"127":{"tf":2.0},"18":{"tf":2.23606797749979},"2":{"tf":1.4142135623730951},"20":{"tf":4.358898943540674},"21":{"tf":3.3166247903554},"22":{"tf":3.0},"24":{"tf":2.6457513110645907},"25":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":2.449489742783178},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":3.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":12,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":2.449489742783178},"107":{"tf":2.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":12,"docs":{"100":{"tf":1.4142135623730951},"104":{"tf":1.0},"117":{"tf":1.0},"3":{"tf":2.0},"45":{"tf":1.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.4142135623730951},"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"44":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":5,"docs":{"122":{"tf":1.0},"70":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.7320508075688772},"76":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"114":{"tf":1.0}}}},"t":{"a":{"df":11,"docs":{"28":{"tf":1.4142135623730951},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":2.23606797749979},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"(":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":3,"docs":{"29":{"tf":1.0},"55":{"tf":1.0},"73":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"100":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":8,"docs":{"10":{"tf":1.0},"122":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"47":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"89":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":21,"docs":{"10":{"tf":1.0},"100":{"tf":2.449489742783178},"106":{"tf":1.0},"107":{"tf":1.0},"118":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.7320508075688772},"124":{"tf":1.0},"125":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"6":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":2.0},"89":{"tf":1.0},"90":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"118":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.4142135623730951},"18":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"75":{"tf":1.0},"77":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.7320508075688772}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}},"y":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":13,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":2.6457513110645907},"106":{"tf":1.0},"107":{"tf":2.8284271247461903},"2":{"tf":1.0},"3":{"tf":1.4142135623730951},"32":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":3,"docs":{"105":{"tf":1.0},"59":{"tf":1.0},"83":{"tf":2.6457513110645907}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"72":{"tf":1.0},"73":{"tf":2.449489742783178},"76":{"tf":1.7320508075688772}},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"68":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"106":{"tf":1.0},"46":{"tf":1.0}}}},"r":{"df":2,"docs":{"122":{"tf":1.0},"70":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":18,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"62":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":5,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"8":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.0},"24":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"123":{"tf":1.0},"24":{"tf":1.4142135623730951},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"7":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"4":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"22":{"tf":1.0},"71":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"11":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"107":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"31":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":14,"docs":{"0":{"tf":1.0},"108":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"31":{"tf":1.0},"69":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"c":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"110":{"tf":1.0},"111":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":22,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.7320508075688772},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":2.23606797749979},"116":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"76":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}}}}},"df":3,"docs":{"20":{"tf":1.4142135623730951},"28":{"tf":1.0},"32":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"122":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":9,"docs":{"105":{"tf":1.0},"31":{"tf":1.4142135623730951},"39":{"tf":1.0},"48":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"71":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"109":{"tf":1.0},"31":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"114":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"60":{"tf":1.7320508075688772},"69":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"31":{"tf":1.7320508075688772},"60":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"124":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"df":6,"docs":{"10":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":2.23606797749979},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}},"0":{"5":{"0":{"6":{"df":1,"docs":{"81":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"df":1,"docs":{"28":{"tf":1.0}}},"a":{"c":{"df":0,"docs":{},"h":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"100":{"tf":1.4142135623730951},"110":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"s":{"df":2,"docs":{"106":{"tf":1.0},"37":{"tf":1.4142135623730951}},"i":{"df":6,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":1.0},"87":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"28":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"55":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"121":{"tf":1.0}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"107":{"tf":1.0},"71":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"9":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":23,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":2.23606797749979},"10":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":3.3166247903554},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":2.8284271247461903},"3":{"tf":2.449489742783178},"4":{"tf":2.23606797749979},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"54":{"tf":1.4142135623730951},"6":{"tf":2.6457513110645907},"61":{"tf":1.0},"7":{"tf":2.8284271247461903},"78":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979},"9":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"51":{"tf":1.7320508075688772},"70":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772}},"s":{",":{"df":0,"docs":{},"w":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"i":{"d":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}},"s":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"31":{"tf":1.0}}}}}}}}},"m":{"b":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"120":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":2.6457513110645907}}}}}}}}},"df":0,"docs":{}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"106":{"tf":1.0},"118":{"tf":1.4142135623730951},"2":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}},"o":{"d":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":8,"docs":{"18":{"tf":1.0},"48":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"65":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"24":{"tf":1.0},"71":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"70":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"22":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"82":{"tf":1.0},"92":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"24":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"69":{"tf":2.0},"78":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"(":{"df":2,"docs":{"28":{"tf":2.0},"29":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}}},"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{"df":0,"docs":{},"e":{"0":{"0":{"0":{"4":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"7":{"7":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"2":{"df":2,"docs":{"54":{"tf":1.0},"55":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}},"2":{"7":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":17,"docs":{"13":{"tf":1.4142135623730951},"2":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":3.605551275463989},"29":{"tf":2.6457513110645907},"30":{"tf":1.4142135623730951},"31":{"tf":2.23606797749979},"32":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.23606797749979},"66":{"tf":1.7320508075688772},"78":{"tf":3.3166247903554},"80":{"tf":1.0},"81":{"tf":3.7416573867739413}}}}}},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"120":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"28":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"100":{"tf":1.0},"111":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0},"7":{"tf":1.4142135623730951},"94":{"tf":1.0}},"t":{"df":0,"docs":{},"u":{"df":5,"docs":{"123":{"tf":1.0},"20":{"tf":1.0},"42":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.0},"48":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"24":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"24":{"tf":1.0},"32":{"tf":1.0},"39":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":41,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":3.4641016151377544},"106":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":2.23606797749979},"117":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":2.0},"79":{"tf":1.4142135623730951},"81":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"7":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"100":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":2.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"2":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"66":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"4":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"44":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"n":{"df":3,"docs":{"109":{"tf":1.0},"39":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"2":{"tf":1.0},"24":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"s":{"df":2,"docs":{"31":{"tf":1.0},"69":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"28":{"tf":1.0},"34":{"tf":1.4142135623730951},"46":{"tf":1.0},"70":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"28":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":11,"docs":{"10":{"tf":1.0},"120":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":3.605551275463989},"21":{"tf":1.7320508075688772},"22":{"tf":2.23606797749979},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"r":{"a":{"df":4,"docs":{"46":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"f":{"(":{"df":0,"docs":{},"u":{"df":1,"docs":{"69":{"tf":1.0}}}},".":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{"df":1,"docs":{"69":{"tf":2.23606797749979}}},"2":{"df":1,"docs":{"69":{"tf":2.23606797749979}}},"3":{"2":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"46":{"tf":2.8284271247461903},"69":{"tf":1.7320508075688772}},"s":{"(":{"2":{".":{"0":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"116":{"tf":1.0},"117":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"4":{"tf":1.0},"56":{"tf":1.0},"66":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.0},"31":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"118":{"tf":1.0},"40":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":2,"docs":{"110":{"tf":1.0},"55":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"71":{"tf":2.23606797749979},"82":{"tf":1.7320508075688772},"97":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":6,"docs":{"20":{"tf":1.7320508075688772},"28":{"tf":2.23606797749979},"29":{"tf":1.7320508075688772},"41":{"tf":2.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":26,"docs":{"1":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"123":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"28":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"75":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"95":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":2.449489742783178}}}}},"w":{"df":16,"docs":{"108":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"127":{"tf":1.0}}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"11":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":2.6457513110645907},"64":{"tf":1.0},"65":{"tf":2.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{":":{"/":{"/":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"\"":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":8,"docs":{"104":{"tf":2.23606797749979},"106":{"tf":2.0},"23":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"87":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"109":{"tf":1.4142135623730951},"127":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"d":{"df":6,"docs":{"100":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"109":{"tf":1.0},"120":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":4,"docs":{"2":{"tf":1.0},"31":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"78":{"tf":1.0}},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"115":{"tf":1.0},"117":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"48":{"tf":1.7320508075688772},"50":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}},"x":{"df":4,"docs":{"105":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":3.0},"7":{"tf":4.242640687119285}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":10,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":2.0},"102":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"20":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":2.449489742783178}}}},"df":0,"docs":{},"w":{"df":4,"docs":{"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"61":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"58":{"tf":1.4142135623730951},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},":":{":":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"30":{"tf":1.0},"58":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":3,"docs":{"58":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"<":{"'":{"_":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"58":{"tf":1.4142135623730951},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"58":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951}}}},"n":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":36,"docs":{"117":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"13":{"tf":2.0},"16":{"tf":1.0},"22":{"tf":2.0},"24":{"tf":2.449489742783178},"28":{"tf":1.7320508075688772},"29":{"tf":2.0},"30":{"tf":2.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":2.0},"41":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":2.8284271247461903},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":2.0},"60":{"tf":2.23606797749979},"66":{"tf":2.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"81":{"tf":1.0},"83":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":13,"docs":{"10":{"tf":1.7320508075688772},"106":{"tf":1.0},"111":{"tf":1.0},"29":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.4142135623730951},"89":{"tf":1.0},"95":{"tf":1.0}}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"4":{"tf":1.0},"47":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},")":{"?":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{"?":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"71":{"tf":1.0}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"37":{"tf":1.0},"38":{"tf":1.0}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.0},"23":{"tf":2.23606797749979}},"s":{":":{"3":{":":{"1":{"4":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"81":{"tf":1.0}}},"4":{":":{"5":{"df":1,"docs":{"81":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"/":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"<":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{">":{"(":{"1":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"24":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"'":{"_":{"df":1,"docs":{"59":{"tf":1.0}}},"a":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"41":{"tf":1.4142135623730951}}}},"\\":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"2":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":24,"docs":{"105":{"tf":2.0},"117":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":2.23606797749979},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":2.0},"37":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"g":{"df":1,"docs":{"125":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":2.0}},"s":{"!":{"(":{"$":{"(":{"$":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"81":{"tf":1.0},"92":{"tf":1.7320508075688772}}}},"df":8,"docs":{"11":{"tf":1.0},"110":{"tf":1.0},"25":{"tf":1.7320508075688772},"31":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":3,"docs":{"113":{"tf":1.0},"13":{"tf":1.4142135623730951},"31":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"117":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":2,"docs":{"42":{"tf":1.0},"7":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{">":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}}}}},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"120":{"tf":1.4142135623730951},"125":{"tf":1.0},"2":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":2,"docs":{"1":{"tf":1.0},"124":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":1,"docs":{"24":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"2":{"df":1,"docs":{"43":{"tf":1.0}}},"df":17,"docs":{"10":{"tf":1.7320508075688772},"115":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"22":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":2.23606797749979},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"46":{"tf":2.449489742783178},"71":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"91":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"84":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"100":{"tf":1.0},"44":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":10,"docs":{"103":{"tf":2.23606797749979},"115":{"tf":1.0},"20":{"tf":2.0},"24":{"tf":1.0},"28":{"tf":1.4142135623730951},"35":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"121":{"tf":1.4142135623730951},"28":{"tf":1.0},"93":{"tf":1.0}}}}},"c":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"115":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"38":{"tf":1.0},"41":{"tf":1.0},"59":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}}}},"t":{"df":3,"docs":{"100":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":9,"docs":{"20":{"tf":1.0},"28":{"tf":1.0},"46":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"65":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}},"n":{"df":2,"docs":{"122":{"tf":1.0},"47":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"122":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":2,"docs":{"122":{"tf":1.7320508075688772},"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"123":{"tf":1.7320508075688772}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":7,"docs":{"123":{"tf":1.0},"18":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}},"e":{"df":3,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"82":{"tf":1.0}}},"n":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"d":{"df":3,"docs":{"109":{"tf":1.0},"123":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"28":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"[":{"\"":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":1,"docs":{"0":{"tf":1.0}},"n":{"df":3,"docs":{"110":{"tf":1.0},"121":{"tf":1.0},"98":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"78":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"114":{"tf":1.0}}}}},"i":{"d":{"df":17,"docs":{"0":{"tf":1.7320508075688772},"108":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"125":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"120":{"tf":1.0}},"l":{"df":11,"docs":{"122":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":2.6457513110645907},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.0},"50":{"tf":1.0},"54":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"1":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.0},"28":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"54":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"121":{"tf":1.0}}},"r":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}},"df":1,"docs":{"48":{"tf":1.4142135623730951}}}},"p":{"df":9,"docs":{"29":{"tf":1.0},"5":{"tf":1.7320508075688772},"61":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":2,"docs":{"104":{"tf":1.0},"78":{"tf":2.23606797749979}}}}}},"n":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":5,"docs":{"121":{"tf":1.0},"18":{"tf":1.0},"4":{"tf":1.0},"55":{"tf":1.0},"81":{"tf":1.7320508075688772}}},"df":23,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"120":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"44":{"tf":1.0},"48":{"tf":2.0},"54":{"tf":1.7320508075688772},"55":{"tf":2.449489742783178},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"96":{"tf":1.0},"97":{"tf":1.0}},"’":{"df":1,"docs":{"71":{"tf":1.0}}}}},"y":{"df":2,"docs":{"41":{"tf":1.0},"48":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"107":{"tf":1.0},"20":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"111":{"tf":1.0},"82":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"l":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"111":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"115":{"tf":1.0},"71":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"78":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"111":{"tf":1.0},"115":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"113":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}},"h":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}},"i":{"'":{"df":0,"docs":{},"m":{"df":3,"docs":{"114":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0}}},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"/":{"df":0,"docs":{},"o":{"df":2,"docs":{"120":{"tf":1.0},"28":{"tf":1.0}}}},"1":{"2":{"8":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"df":8,"docs":{"30":{"tf":2.0},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"65":{"tf":2.0},"68":{"tf":1.0}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"d":{"df":2,"docs":{"46":{"tf":2.23606797749979},"93":{"tf":2.23606797749979}},"e":{"a":{"df":4,"docs":{"118":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":2.6457513110645907},"14":{"tf":1.0},"2":{"tf":1.0},"50":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"7":{"tf":2.0}}}},"df":1,"docs":{"7":{"tf":3.1622776601683795}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.0},"4":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.7320508075688772},"55":{"tf":2.23606797749979}}}}},"p":{"df":0,"docs":{},"l":{"<":{"'":{"a":{"df":3,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":1,"docs":{"60":{"tf":1.0}}},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":18,"docs":{"30":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":2.23606797749979},"38":{"tf":2.0},"39":{"tf":2.23606797749979},"40":{"tf":2.0},"41":{"tf":1.7320508075688772},"42":{"tf":2.23606797749979},"43":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"68":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":21,"docs":{"118":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"124":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"68":{"tf":2.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":1,"docs":{"61":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":8,"docs":{"100":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"26":{"tf":2.0},"38":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":16,"docs":{"108":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"53":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":2.0},"9":{"tf":1.0},"96":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":10,"docs":{"114":{"tf":1.0},"127":{"tf":1.0},"22":{"tf":1.0},"31":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":2.23606797749979}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"2":{"tf":1.0},"5":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"9":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"82":{"tf":2.23606797749979}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":2,"docs":{"106":{"tf":1.7320508075688772},"31":{"tf":1.0}}}},"i":{"c":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"103":{"tf":1.0},"104":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"11":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":2.0},"70":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":2.23606797749979}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":11,"docs":{"101":{"tf":1.0},"109":{"tf":1.0},"127":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"42":{"tf":1.0},"57":{"tf":1.0},"81":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.0},"65":{"tf":1.4142135623730951}},"i":{"df":5,"docs":{"123":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0},"65":{"tf":1.0},"97":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"28":{"tf":1.0},"78":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"i":{"d":{"df":6,"docs":{"104":{"tf":1.7320508075688772},"127":{"tf":1.0},"21":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"78":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":16,"docs":{"11":{"tf":1.7320508075688772},"121":{"tf":1.0},"123":{"tf":1.7320508075688772},"125":{"tf":2.0},"84":{"tf":1.0},"85":{"tf":3.3166247903554},"86":{"tf":2.0},"88":{"tf":1.7320508075688772},"89":{"tf":3.0},"90":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"98":{"tf":2.8284271247461903},"99":{"tf":1.7320508075688772}},"l":{"'":{"d":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"c":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":21,"docs":{"106":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"109":{"tf":1.0},"121":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"4":{"tf":1.0},"50":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"76":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"125":{"tf":1.0},"7":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.7320508075688772}},"r":{"df":2,"docs":{"89":{"tf":1.0},"93":{"tf":1.7320508075688772}}}},"n":{"d":{"df":3,"docs":{"105":{"tf":1.0},"127":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"14":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"29":{"tf":1.0},"39":{"tf":1.0},"90":{"tf":1.0}}}}},"f":{"a":{"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"127":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"123":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.4142135623730951},"5":{"tf":1.0}},"t":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"27":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"c":{"df":3,"docs":{"102":{"tf":1.4142135623730951},"28":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}}},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"s":{"_":{"df":0,"docs":{},"x":{"8":{"6":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}},"e":{"d":{"!":{"(":{"\"":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"39":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"u":{"df":9,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0},"90":{"tf":1.0}}}}},"t":{"'":{"df":20,"docs":{"109":{"tf":1.0},"114":{"tf":1.0},"121":{"tf":1.7320508075688772},"123":{"tf":1.0},"125":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"24":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"75":{"tf":1.0},"83":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"<":{"'":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":6,"docs":{"28":{"tf":1.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"66":{"tf":1.0},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":10,"docs":{"1":{"tf":1.0},"111":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"85":{"tf":1.0}}}}}},"’":{"df":1,"docs":{"100":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}},"b":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"100":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"y":{"/":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":5,"docs":{"122":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.4142135623730951}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":12,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"n":{"d":{"df":7,"docs":{"109":{"tf":1.0},"117":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"75":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"109":{"tf":1.0},"41":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":3,"docs":{"121":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"111":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"g":{"df":12,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"127":{"tf":1.0},"13":{"tf":1.4142135623730951},"28":{"tf":2.0},"31":{"tf":1.4142135623730951},"34":{"tf":1.0},"4":{"tf":1.0},"57":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"0":{"tf":1.0},"24":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"78":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"70":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}},"r":{"df":3,"docs":{"2":{"tf":1.0},"55":{"tf":1.0},"78":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.0},"3":{"tf":1.0},"99":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"22":{"tf":1.4142135623730951},"31":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"113":{"tf":1.0},"30":{"tf":1.0},"52":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0}}}},"v":{"df":2,"docs":{"59":{"tf":1.0},"7":{"tf":1.0}}}},"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.7320508075688772}},"i":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.0}}}},"t":{"'":{"df":8,"docs":{"19":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"58":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.0}}},"df":4,"docs":{"106":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"71":{"tf":1.4142135623730951}},"’":{"df":1,"docs":{"105":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}},"df":8,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"114":{"tf":1.0},"120":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"78":{"tf":2.6457513110645907}}}}},"x":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"54":{"tf":2.0},"55":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"104":{"tf":1.0},"23":{"tf":1.4142135623730951}}}},"c":{"df":1,"docs":{"124":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"119":{"tf":1.0},"120":{"tf":2.8284271247461903}},"e":{"'":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":2,"docs":{"100":{"tf":1.4142135623730951},"127":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":16,"docs":{"0":{"tf":1.7320508075688772},"100":{"tf":2.23606797749979},"115":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":2.23606797749979},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"14":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"120":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":12,"docs":{"109":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":2.23606797749979},"59":{"tf":2.449489742783178},"60":{"tf":2.449489742783178},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":2.6457513110645907}}}}}},"t":{"df":5,"docs":{"23":{"tf":1.0},"28":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"69":{"tf":1.0}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":7,"docs":{"20":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"81":{"tf":1.0}}},"k":{"df":2,"docs":{"124":{"tf":1.4142135623730951},"2":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}},"t":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.7320508075688772},"94":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"x":{"df":5,"docs":{"115":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":2.0},"126":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"106":{"tf":1.0},"125":{"tf":1.0},"48":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":4,"docs":{"70":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"113":{"tf":1.0},"23":{"tf":1.4142135623730951}}}}},"l":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":2,"docs":{"71":{"tf":1.4142135623730951},"95":{"tf":2.23606797749979}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":7,"docs":{"105":{"tf":1.0},"106":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":2.23606797749979},"90":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"t":{"df":2,"docs":{"20":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"106":{"tf":2.0}}}},"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"{":{"_":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":3.0}},"i":{"c":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":2.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"100":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"47":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":14,"docs":{"1":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"28":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"p":{"df":4,"docs":{"34":{"tf":2.6457513110645907},"56":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}}},"t":{"df":6,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"29":{"tf":1.0},"63":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"3":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"w":{"df":3,"docs":{"120":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"106":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"75":{"tf":1.0},"78":{"tf":2.6457513110645907}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"75":{"tf":2.0},"78":{"tf":3.1622776601683795},"79":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.0}}}}},"df":11,"docs":{"20":{"tf":1.7320508075688772},"28":{"tf":2.23606797749979},"71":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":2.8284271247461903},"76":{"tf":2.23606797749979},"77":{"tf":1.7320508075688772},"78":{"tf":4.58257569495584},"79":{"tf":1.7320508075688772}}}}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"100":{"tf":1.0},"123":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}}},"df":16,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"13":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":3.0},"30":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"39":{"tf":1.0},"69":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"59":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":16,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.0},"78":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"9":{"tf":1.0},"97":{"tf":2.23606797749979}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"31":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":11,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"109":{"tf":1.0},"118":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.0},"29":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":2.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"28":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"v":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":1,"docs":{"71":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":2.0}}}}}},"df":3,"docs":{"122":{"tf":1.0},"58":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":15,"docs":{"123":{"tf":1.0},"13":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"28":{"tf":2.6457513110645907},"30":{"tf":1.0},"48":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":2.449489742783178},"57":{"tf":2.0},"69":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"106":{"tf":1.0},"123":{"tf":1.0},"82":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"98":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":17,"docs":{"1":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"121":{"tf":1.0},"13":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"59":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951}},"t":{"df":3,"docs":{"122":{"tf":1.0},"24":{"tf":1.0},"78":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"121":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"100":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"120":{"tf":1.0},"122":{"tf":1.7320508075688772},"31":{"tf":1.0},"70":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"106":{"tf":1.0},"125":{"tf":1.0},"42":{"tf":1.0},"7":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"28":{"tf":1.0},"30":{"tf":1.0},"78":{"tf":3.1622776601683795},"80":{"tf":1.0},"81":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":5,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":63,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"70":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"x":{"df":1,"docs":{"29":{"tf":1.0}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"18":{"tf":1.0},"23":{"tf":2.23606797749979}}}},"df":8,"docs":{"20":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":2.0},"26":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"77":{"tf":1.0}},"e":{"df":2,"docs":{"53":{"tf":1.0},"57":{"tf":2.23606797749979}},"l":{"df":3,"docs":{"111":{"tf":1.0},"18":{"tf":1.0},"57":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":20,"docs":{"103":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":2.23606797749979},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":2.449489742783178},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"31":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}},"e":{"'":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":49,"docs":{"100":{"tf":1.0},"103":{"tf":2.23606797749979},"104":{"tf":1.0},"105":{"tf":1.0},"110":{"tf":1.4142135623730951},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"122":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"44":{"tf":2.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.7320508075688772},"59":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":2.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"14":{"tf":1.7320508075688772},"31":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"24":{"tf":1.0},"75":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"g":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"v":{"c":{"df":1,"docs":{"123":{"tf":2.0}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"h":{"df":11,"docs":{"1":{"tf":1.0},"28":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"58":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.0},"8":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"24":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"104":{"tf":1.0},"28":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"l":{"df":4,"docs":{"124":{"tf":1.7320508075688772},"125":{"tf":2.6457513110645907},"126":{"tf":2.0},"88":{"tf":1.7320508075688772}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"54":{"tf":1.4142135623730951},"55":{"tf":2.0},"57":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":15,"docs":{"122":{"tf":1.0},"28":{"tf":2.449489742783178},"43":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"55":{"tf":2.0},"57":{"tf":2.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"81":{"tf":1.0}}}},"y":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":2.6457513110645907}}}}}}}}},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"109":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{">":{"_":{"_":{"<":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":19,"docs":{"125":{"tf":1.0},"13":{"tf":1.7320508075688772},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":2.23606797749979},"3":{"tf":2.0},"44":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"65":{"tf":1.4142135623730951},"73":{"tf":2.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"95":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"120":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"46":{"tf":2.23606797749979}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"98":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}}}}},"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{";":{"&":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"23":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"40":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"d":{"df":30,"docs":{"123":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":2.8284271247461903},"24":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.7320508075688772},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.7320508075688772},"61":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"54":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"97":{"tf":1.0}}}}},"w":{"df":36,"docs":{"1":{"tf":1.7320508075688772},"100":{"tf":2.23606797749979},"101":{"tf":1.0},"109":{"tf":2.0},"110":{"tf":1.0},"111":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"15":{"tf":1.7320508075688772},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":2.23606797749979},"20":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":2.0},"31":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":2.23606797749979},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"5":{"tf":2.0},"6":{"tf":2.6457513110645907},"63":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":2.0},"70":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":1,"docs":{"89":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"48":{"tf":1.4142135623730951}},"r":{"df":2,"docs":{"28":{"tf":1.0},"44":{"tf":1.0}}}},"k":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"109":{"tf":1.0},"110":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"111":{"tf":1.0},"121":{"tf":1.4142135623730951},"20":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"85":{"tf":1.7320508075688772},"87":{"tf":2.0},"89":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":2,"docs":{"120":{"tf":1.4142135623730951},"20":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"n":{"df":7,"docs":{"1":{"tf":1.0},"107":{"tf":1.0},"50":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"70":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"108":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"53":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":18,"docs":{"0":{"tf":1.0},"102":{"tf":1.4142135623730951},"117":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.7320508075688772}}},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":48,"docs":{"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.7320508075688772},"118":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"126":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"125":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":1,"docs":{"45":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"127":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"28":{"tf":1.0},"39":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"28":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":2.23606797749979},"59":{"tf":1.0},"81":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"70":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"106":{"tf":1.0},"90":{"tf":1.0}}}}}}},"k":{"(":{"_":{"df":1,"docs":{"28":{"tf":1.0}}},"df":1,"docs":{"28":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":4,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"78":{"tf":1.0}}},"l":{"d":{"df":5,"docs":{"34":{"tf":1.0},"43":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.4142135623730951},"75":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"3":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"n":{"c":{"df":4,"docs":{"121":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.0},"97":{"tf":1.0}}},"df":30,"docs":{"0":{"tf":1.4142135623730951},"100":{"tf":1.0},"103":{"tf":1.7320508075688772},"105":{"tf":1.0},"110":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":2.0},"29":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.4142135623730951},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"79":{"tf":2.23606797749979},"82":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"16":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0}}},"r":{"df":10,"docs":{"115":{"tf":1.0},"120":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.0},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"68":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"113":{"tf":1.0},"28":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"t":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"6":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}}}}},"t":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0}}}},"df":4,"docs":{"16":{"tf":1.0},"29":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"106":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":4,"docs":{"117":{"tf":1.0},"122":{"tf":1.0},"7":{"tf":1.0},"87":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":21,"docs":{"0":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"109":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"101":{"tf":1.0},"48":{"tf":2.0},"59":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"106":{"tf":1.0},"18":{"tf":1.0}}}},"df":3,"docs":{"57":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"105":{"tf":1.0},"87":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":11,"docs":{"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":12,"docs":{"1":{"tf":1.4142135623730951},"103":{"tf":2.6457513110645907},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"11":{"tf":1.0},"3":{"tf":2.0},"6":{"tf":1.0},"78":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"35":{"tf":1.0},"70":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"31":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"c":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":3.872983346207417},"32":{"tf":2.6457513110645907}},"k":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":2.0},"5":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"41":{"tf":1.7320508075688772}},"e":{"<":{"df":0,"docs":{},"f":{">":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}},"t":{"df":6,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"25":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"24":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":9,"docs":{"100":{"tf":1.0},"101":{"tf":2.0},"102":{"tf":1.0},"126":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"97":{"tf":1.7320508075688772}}}},"t":{"c":{"df":0,"docs":{},"h":{".":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":2.23606797749979}}}},"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.7320508075688772}}}}},"df":10,"docs":{"10":{"tf":2.449489742783178},"105":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"18":{"tf":2.449489742783178},"22":{"tf":1.7320508075688772},"24":{"tf":3.605551275463989},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"78":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":10,"docs":{"10":{"tf":1.0},"28":{"tf":1.4142135623730951},"48":{"tf":2.0},"50":{"tf":2.6457513110645907},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"69":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}}}},"y":{"df":1,"docs":{"39":{"tf":1.0}}}},"c":{"df":1,"docs":{"123":{"tf":1.0}}},"df":1,"docs":{"65":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":7,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"48":{"tf":1.0},"8":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"df":2,"docs":{"87":{"tf":1.0},"89":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"70":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.7320508075688772}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"73":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"48":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":6,"docs":{"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"52":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":13,"docs":{"115":{"tf":1.7320508075688772},"119":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.7320508075688772},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"98":{"tf":1.0}}}}}}},"y":{"df":2,"docs":{"100":{"tf":1.0},"70":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":9,"docs":{"103":{"tf":1.0},"109":{"tf":1.0},"117":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"83":{"tf":1.4142135623730951},"90":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"65":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"73":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"34":{"tf":1.0},"37":{"tf":2.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"107":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"28":{"tf":1.0},"46":{"tf":1.0},"84":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"105":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":1.0},"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":4,"docs":{"13":{"tf":1.0},"21":{"tf":1.4142135623730951},"28":{"tf":1.0},"78":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"106":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"s":{"df":1,"docs":{"109":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"95":{"tf":2.449489742783178}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"8":{"tf":1.0},"81":{"tf":1.4142135623730951}},"s":{"df":9,"docs":{"117":{"tf":1.0},"122":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"59":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"101":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"7":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":1,"docs":{"56":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"121":{"tf":1.0},"31":{"tf":1.0}}}}},"y":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}},"i":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"66":{"tf":2.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"h":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"46":{"tf":1.0},"48":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":2.23606797749979},"81":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"125":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":2.449489742783178},"4":{"tf":1.0},"5":{"tf":1.0}}}}}},"c":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"1":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"1":{"tf":1.0},"31":{"tf":1.4142135623730951},"4":{"tf":1.0},"97":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":8,"docs":{"1":{"tf":1.0},"121":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"81":{"tf":1.0},"97":{"tf":1.7320508075688772}},"t":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"31":{"tf":1.0},"32":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"31":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":14,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"122":{"tf":1.7320508075688772},"13":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.0},"100":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"109":{"tf":1.0},"118":{"tf":1.0},"20":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"3":{"tf":2.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"92":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"113":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}},"i":{"d":{"df":7,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"28":{"tf":1.0},"41":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"25":{"tf":1.0}}}}},"df":7,"docs":{"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"30":{"tf":1.4142135623730951},"41":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"83":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"25":{"tf":1.7320508075688772}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"70":{"tf":1.0}}}}}},"t":{"df":6,"docs":{"104":{"tf":1.0},"18":{"tf":1.0},"37":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.4142135623730951},"38":{"tf":1.0},"95":{"tf":1.0}}}}}},"r":{"#":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"107":{"tf":1.4142135623730951},"66":{"tf":3.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":2,"docs":{"13":{"tf":2.0},"14":{"tf":1.0}}}},"b":{"df":0,"docs":{},"e":{"df":1,"docs":{"113":{"tf":1.0}}}},"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"45":{"tf":1.0}}}}},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"a":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":7,"docs":{"114":{"tf":1.0},"122":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0},"90":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}},"i":{"df":4,"docs":{"121":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":2,"docs":{"29":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"71":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"121":{"tf":1.0},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"123":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.4142135623730951},"58":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"7":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":1,"docs":{"31":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"115":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"c":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"109":{"tf":1.0},"5":{"tf":1.0}},"f":{"<":{"'":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"110":{"tf":1.0},"18":{"tf":1.4142135623730951},"21":{"tf":2.6457513110645907},"45":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"<":{"'":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"107":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":3.1622776601683795}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}}}}},"df":2,"docs":{"122":{"tf":1.0},"24":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":13,"docs":{"0":{"tf":1.0},"1":{"tf":2.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"117":{"tf":1.0},"123":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":4,"docs":{"31":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"125":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":11,"docs":{"105":{"tf":1.0},"120":{"tf":1.0},"20":{"tf":1.4142135623730951},"32":{"tf":1.0},"4":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"24":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"79":{"tf":1.7320508075688772}}}}}},"l":{"a":{"c":{"df":5,"docs":{"105":{"tf":2.0},"106":{"tf":2.6457513110645907},"45":{"tf":1.0},"5":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"30":{"tf":2.0}}}}}}},"df":3,"docs":{"30":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"r":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"1":{"6":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"106":{"tf":1.0},"46":{"tf":1.0},"79":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"69":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":10,"docs":{"120":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"29":{"tf":1.0},"51":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":2.0},"70":{"tf":1.0},"77":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"35":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"106":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"23":{"tf":1.0},"28":{"tf":1.4142135623730951},"42":{"tf":1.0},"45":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}}},"t":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.0}}}},"df":7,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":2.449489742783178},"30":{"tf":2.23606797749979},"31":{"tf":1.7320508075688772},"41":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}}},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":12,"docs":{"28":{"tf":2.6457513110645907},"29":{"tf":2.23606797749979},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"37":{"tf":2.0},"39":{"tf":2.449489742783178},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.4142135623730951},"71":{"tf":1.0}},"s":{"_":{"a":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"f":{"c":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"47":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":5,"docs":{"32":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"87":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"93":{"tf":2.23606797749979}}},"o":{"a":{"d":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}},"t":{"df":5,"docs":{"120":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"20":{"tf":1.0}}}},"n":{"df":11,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"121":{"tf":1.0},"29":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"71":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.7320508075688772},"97":{"tf":2.8284271247461903}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"122":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":7,"docs":{"0":{"tf":1.0},"110":{"tf":1.0},"29":{"tf":1.0},"45":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.7320508075688772},"95":{"tf":1.0}}},"a":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"100":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":11,"docs":{"101":{"tf":2.6457513110645907},"102":{"tf":1.4142135623730951},"121":{"tf":1.0},"127":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"85":{"tf":1.0},"87":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"d":{"df":0,"docs":{},"o":{"c":{"df":4,"docs":{"112":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"117":{"tf":1.4142135623730951},"118":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"df":128,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":2.8284271247461903},"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":3.1622776601683795},"11":{"tf":1.0},"110":{"tf":2.23606797749979},"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"113":{"tf":2.449489742783178},"114":{"tf":2.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":2.23606797749979},"118":{"tf":2.23606797749979},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"120":{"tf":2.23606797749979},"121":{"tf":2.8284271247461903},"122":{"tf":2.449489742783178},"123":{"tf":2.449489742783178},"124":{"tf":2.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":2.449489742783178},"13":{"tf":1.7320508075688772},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":2.0},"20":{"tf":2.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":2.23606797749979},"24":{"tf":3.1622776601683795},"25":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":2.449489742783178},"29":{"tf":2.449489742783178},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":2.6457513110645907},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":2.6457513110645907},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.0},"55":{"tf":1.0},"56":{"tf":2.23606797749979},"57":{"tf":1.7320508075688772},"58":{"tf":2.6457513110645907},"59":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951},"60":{"tf":2.449489742783178},"61":{"tf":2.449489742783178},"62":{"tf":1.0},"63":{"tf":2.0},"64":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":2.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"69":{"tf":2.23606797749979},"7":{"tf":1.7320508075688772},"70":{"tf":2.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":2.23606797749979},"74":{"tf":1.4142135623730951},"75":{"tf":2.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":2.449489742783178},"8":{"tf":3.4641016151377544},"80":{"tf":1.0},"81":{"tf":2.449489742783178},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":2.449489742783178},"85":{"tf":2.23606797749979},"86":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":2.8284271247461903},"90":{"tf":1.7320508075688772},"91":{"tf":2.23606797749979},"92":{"tf":1.4142135623730951},"93":{"tf":2.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.7320508075688772},"98":{"tf":1.7320508075688772},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":14,"docs":{"121":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772},"85":{"tf":2.8284271247461903},"86":{"tf":1.0},"87":{"tf":2.23606797749979},"88":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"’":{"df":2,"docs":{"109":{"tf":1.0},"120":{"tf":1.4142135623730951}}}}}}},"s":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":15,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"125":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":2.0},"28":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"y":{"df":2,"docs":{"41":{"tf":1.0},"50":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":1,"docs":{"28":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}},"df":2,"docs":{"28":{"tf":2.449489742783178},"56":{"tf":2.8284271247461903}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"108":{"tf":1.0},"109":{"tf":2.449489742783178},"25":{"tf":1.0},"31":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"105":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":26,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"115":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}},"k":{"df":1,"docs":{"5":{"tf":1.0}}},"m":{"df":4,"docs":{"18":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":2.0},"71":{"tf":1.0}}},"n":{"df":1,"docs":{"45":{"tf":1.0}}}},"g":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"f":{")":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"68":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},":":{":":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":8,"docs":{"10":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":2.449489742783178},"60":{"tf":2.23606797749979},"68":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"109":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":2,"docs":{"73":{"tf":1.0},"76":{"tf":1.4142135623730951}},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":12,"docs":{"103":{"tf":1.0},"11":{"tf":1.0},"122":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"87":{"tf":2.0},"89":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"<":{"'":{"_":{"df":1,"docs":{"60":{"tf":1.0}}},"a":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"93":{"tf":1.0},"95":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"103":{"tf":1.0},"31":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"p":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"109":{"tf":1.7320508075688772},"20":{"tf":1.0},"35":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":1.0},"43":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"87":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"28":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":4,"docs":{"104":{"tf":1.0},"109":{"tf":1.0},"55":{"tf":1.0},"81":{"tf":1.7320508075688772}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"121":{"tf":1.0},"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"18":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":2,"docs":{"69":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"f":{"3":{"2":{"df":0,"docs":{},"s":{"(":{"0":{".":{"0":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"71":{"tf":3.3166247903554}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"105":{"tf":1.0},"25":{"tf":1.0},"41":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"57":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"104":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"38":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"28":{"tf":1.0},"63":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"i":{"df":3,"docs":{"123":{"tf":1.0},"30":{"tf":1.0},"79":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":5,"docs":{"18":{"tf":1.4142135623730951},"24":{"tf":1.0},"30":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"103":{"tf":1.7320508075688772},"104":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"59":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"t":{"df":9,"docs":{"111":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.7320508075688772},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"1":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":5,"docs":{"101":{"tf":1.7320508075688772},"50":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"48":{"tf":2.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"71":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"38":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"44":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"120":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0},"82":{"tf":1.4142135623730951},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"127":{"tf":1.0},"32":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"29":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"v":{"df":2,"docs":{"28":{"tf":1.0},"29":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"56":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"56":{"tf":1.0}}}}},"t":{"df":1,"docs":{"28":{"tf":1.0}}},"x":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":2.449489742783178}}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"73":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":11,"docs":{"13":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"122":{"tf":1.0},"2":{"tf":1.0},"44":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"55":{"tf":1.0},"70":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":5,"docs":{"105":{"tf":1.0},"106":{"tf":2.8284271247461903},"87":{"tf":1.0},"91":{"tf":1.7320508075688772},"97":{"tf":1.0}},"e":{".":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"120":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"45":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"127":{"tf":1.4142135623730951},"28":{"tf":1.0},"37":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.4142135623730951},"75":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.4142135623730951}},"i":{"df":5,"docs":{"11":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"97":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"71":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{"0":{":":{"5":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"4":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{":":{"1":{"3":{"df":2,"docs":{"29":{"tf":1.0},"55":{"tf":1.0}}},"8":{"df":2,"docs":{"54":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{":":{"1":{"7":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"104":{"tf":1.0},"91":{"tf":2.0}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"52":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"l":{"df":9,"docs":{"100":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"2":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":7,"docs":{"0":{"tf":1.7320508075688772},"115":{"tf":1.0},"120":{"tf":1.7320508075688772},"122":{"tf":1.0},"124":{"tf":1.0},"28":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":12,"docs":{"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"109":{"tf":1.4142135623730951},"117":{"tf":1.0},"18":{"tf":1.4142135623730951},"24":{"tf":2.0},"31":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"56":{"tf":1.0},"75":{"tf":1.0}}}}}}},"i":{"c":{"df":4,"docs":{"122":{"tf":1.4142135623730951},"124":{"tf":2.0},"63":{"tf":3.4641016151377544},"70":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"c":{"df":0,"docs":{},"h":{":":{":":{"df":0,"docs":{},"x":{"8":{"6":{":":{":":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"2":{"5":{"6":{"_":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"6":{"4":{":":{":":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"2":{"5":{"6":{"_":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":4,"docs":{"30":{"tf":1.0},"58":{"tf":1.4142135623730951},"73":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"29":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":1,"docs":{"115":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"s":{":":{":":{"a":{"d":{"d":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"y":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"31":{"tf":2.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"c":{":":{":":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"{":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.4142135623730951},"26":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"115":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0},"97":{"tf":2.23606797749979}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":14,"docs":{"106":{"tf":1.4142135623730951},"109":{"tf":1.0},"118":{"tf":1.0},"23":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.0}}},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"20":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":5,"docs":{"13":{"tf":2.449489742783178},"48":{"tf":1.0},"58":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"118":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":12,"docs":{"24":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"46":{"tf":3.605551275463989},"58":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":3.4641016151377544},"65":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"48":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"<":{"'":{"_":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"59":{"tf":1.0}}},"a":{">":{"(":{"&":{"'":{"a":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":5,"docs":{"109":{"tf":1.0},"127":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"101":{"tf":1.0},"5":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"104":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"104":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"23":{"tf":2.23606797749979},"24":{"tf":2.0}}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"30":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":10,"docs":{"100":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"18":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"24":{"tf":1.0},"39":{"tf":1.0},"71":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":25,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.7320508075688772},"120":{"tf":1.7320508075688772},"121":{"tf":2.8284271247461903},"122":{"tf":1.0},"123":{"tf":2.449489742783178},"124":{"tf":1.7320508075688772},"125":{"tf":2.6457513110645907},"126":{"tf":1.0},"127":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.7320508075688772},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"88":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"114":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"76":{"tf":1.0},"97":{"tf":2.23606797749979}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"100":{"tf":1.0},"66":{"tf":1.0}}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":12,"docs":{"16":{"tf":1.0},"28":{"tf":2.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"58":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"124":{"tf":1.0}}},"df":37,"docs":{"115":{"tf":1.0},"12":{"tf":1.7320508075688772},"120":{"tf":1.0},"122":{"tf":2.8284271247461903},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":2.23606797749979},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}}}}}}},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"a":{"b":{"df":1,"docs":{"23":{"tf":1.0}},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":7,"docs":{"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772}},"s":{"_":{"df":0,"docs":{},"u":{"8":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"k":{"df":3,"docs":{"19":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":14,"docs":{"103":{"tf":1.0},"11":{"tf":2.0},"119":{"tf":1.7320508075688772},"120":{"tf":1.0},"121":{"tf":2.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":3.0},"126":{"tf":2.0},"127":{"tf":1.0},"71":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":2.449489742783178}}}}}}},"df":5,"docs":{"38":{"tf":1.7320508075688772},"41":{"tf":2.0},"57":{"tf":1.7320508075688772},"60":{"tf":2.23606797749979},"61":{"tf":4.47213595499958}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"39":{"tf":1.0},"41":{"tf":1.0},"73":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"29":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"71":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"30":{"tf":2.23606797749979}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"]":{"df":2,"docs":{"29":{"tf":1.7320508075688772},"30":{"tf":1.0}}},"df":8,"docs":{"105":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":2.23606797749979},"20":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"97":{"tf":2.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.0}}}},"t":{"'":{"df":7,"docs":{"20":{"tf":1.4142135623730951},"28":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.4142135623730951},"90":{"tf":1.0}}},"df":0,"docs":{},"’":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"81":{"tf":1.0},"87":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":11,"docs":{"0":{"tf":1.0},"127":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"48":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"103":{"tf":1.0},"2":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}},"’":{"df":2,"docs":{"120":{"tf":1.0},"69":{"tf":1.0}}}}},"y":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"31":{"tf":1.0},"87":{"tf":1.0}}}},"r":{"df":3,"docs":{"41":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":10,"docs":{"0":{"tf":1.0},"120":{"tf":1.0},"18":{"tf":1.4142135623730951},"26":{"tf":1.0},"34":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"9":{"tf":1.0}}},"k":{"df":4,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"28":{"tf":1.0},"97":{"tf":1.0}}}},"r":{"d":{"df":2,"docs":{"71":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"120":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":9,"docs":{"100":{"tf":1.0},"111":{"tf":1.0},"28":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"7":{"tf":1.0},"84":{"tf":1.0}},"t":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"31":{"tf":3.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"51":{"tf":1.0},"66":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":11,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"113":{"tf":1.0},"121":{"tf":1.0},"127":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0}}}}},"w":{"df":1,"docs":{"31":{"tf":1.0}}}}},"u":{"df":1,"docs":{"31":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":12,"docs":{"100":{"tf":1.4142135623730951},"106":{"tf":1.0},"110":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"54":{"tf":1.0},"7":{"tf":1.4142135623730951},"78":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.0}}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":9,"docs":{"118":{"tf":1.0},"120":{"tf":1.0},"29":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.4142135623730951},"54":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"71":{"tf":1.7320508075688772}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"78":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}},"n":{"df":1,"docs":{"0":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"125":{"tf":1.0}}}}}}}}}},"df":5,"docs":{"123":{"tf":2.8284271247461903},"125":{"tf":1.7320508075688772},"87":{"tf":2.23606797749979},"89":{"tf":2.23606797749979},"90":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":10,"docs":{"1":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.0},"70":{"tf":1.0},"84":{"tf":1.4142135623730951},"89":{"tf":2.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":2.0},"98":{"tf":1.7320508075688772}}}},"p":{"df":4,"docs":{"104":{"tf":1.0},"120":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"30":{"tf":1.0},"42":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.0}}},"t":{">":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":23,"docs":{"10":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":2.449489742783178},"36":{"tf":2.0},"37":{"tf":3.0},"38":{"tf":3.1622776601683795},"39":{"tf":4.0},"4":{"tf":1.0},"40":{"tf":2.8284271247461903},"41":{"tf":2.6457513110645907},"42":{"tf":2.6457513110645907},"43":{"tf":4.0},"44":{"tf":3.4641016151377544},"45":{"tf":2.23606797749979},"46":{"tf":3.605551275463989},"47":{"tf":2.449489742783178},"5":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"7":{"tf":1.7320508075688772},"73":{"tf":2.0},"76":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":19,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"105":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"17":{"tf":2.0},"28":{"tf":2.449489742783178},"29":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.4142135623730951}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"107":{"tf":1.0},"109":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"106":{"tf":1.0}}}}},"y":{"!":{"(":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"!":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"!":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"(":{")":{")":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{")":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":6,"docs":{"19":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"44":{"tf":1.0},"82":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"111":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":15,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"103":{"tf":1.0},"109":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"71":{"tf":1.4142135623730951},"92":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":26,"docs":{"101":{"tf":2.0},"127":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.7320508075688772},"38":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":3.0},"42":{"tf":1.7320508075688772},"45":{"tf":2.23606797749979},"46":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"70":{"tf":2.0}}},"i":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{".":{"df":0,"docs":{},"f":{"1":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"1":{"2":{"8":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"df":2,"docs":{"46":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"6":{"4":{"df":2,"docs":{"41":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"66":{"tf":2.0},"71":{"tf":2.0}}},"df":1,"docs":{"69":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"1":{"tf":1.0},"59":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"u":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":2,"docs":{"40":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":3.7416573867739413}},"’":{"df":1,"docs":{"69":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"40":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":4,"docs":{"121":{"tf":2.8284271247461903},"125":{"tf":1.7320508075688772},"126":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"59":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"100":{"tf":1.0},"107":{"tf":1.0},"78":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"107":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":3,"docs":{"114":{"tf":1.4142135623730951},"69":{"tf":2.23606797749979},"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"24":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":2,"docs":{"31":{"tf":2.6457513110645907},"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.7320508075688772},"105":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":2.23606797749979},"99":{"tf":2.0}}}},"df":0,"docs":{}},"df":11,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"65":{"tf":1.0},"97":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"106":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.0},"46":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"df":75,"docs":{"10":{"tf":1.4142135623730951},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":2.23606797749979},"107":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":2.0},"120":{"tf":2.23606797749979},"121":{"tf":1.4142135623730951},"122":{"tf":2.23606797749979},"123":{"tf":1.7320508075688772},"124":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":3.3166247903554},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"24":{"tf":4.0},"25":{"tf":1.0},"26":{"tf":2.8284271247461903},"28":{"tf":3.605551275463989},"29":{"tf":2.6457513110645907},"3":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"31":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":2.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"42":{"tf":2.23606797749979},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.7320508075688772},"61":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.0},"7":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":3.4641016151377544},"73":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"78":{"tf":3.7416573867739413},"79":{"tf":1.0},"83":{"tf":2.23606797749979},"85":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"91":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"5":{"tf":1.0}}},"df":8,"docs":{"1":{"tf":1.7320508075688772},"111":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"83":{"tf":1.0},"98":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"103":{"tf":1.0}}}}}},"v":{".":{"a":{"b":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{")":{".":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{")":{".":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"1":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"0":{".":{"0":{".":{"1":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"2":{"(":{"df":1,"docs":{"24":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"109":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"30":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":14,"docs":{"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"34":{"tf":2.0},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":6,"docs":{"110":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"df":2,"docs":{"122":{"tf":1.0},"71":{"tf":1.0}},"e":{"c":{"!":{"[":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"100":{"tf":1.0},"31":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"97":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":71,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.7320508075688772},"109":{"tf":2.8284271247461903},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.449489742783178},"73":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":2.8284271247461903},"79":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.449489742783178},"85":{"tf":1.4142135623730951},"87":{"tf":2.0},"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"u":{"df":1,"docs":{"41":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"a":{"df":6,"docs":{"118":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"54":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"57":{"tf":2.0}}}},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"25":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"105":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.4142135623730951},"41":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"n":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":5,"docs":{"2":{"tf":1.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"78":{"tf":3.1622776601683795},"83":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"m":{"3":{"2":{"df":1,"docs":{"121":{"tf":2.0}}},"df":0,"docs":{}},"df":1,"docs":{"121":{"tf":1.0}}}},"y":{"df":21,"docs":{"0":{"tf":1.4142135623730951},"101":{"tf":1.0},"122":{"tf":1.7320508075688772},"18":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":2.23606797749979},"34":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"61":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"d":{"df":4,"docs":{"101":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"101":{"tf":1.0},"125":{"tf":1.0},"35":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":6,"docs":{"110":{"tf":1.0},"28":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0}}},"v":{"df":5,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0}}}},"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"121":{"tf":2.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":2,"docs":{"1":{"tf":1.0},"111":{"tf":1.0}}}},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":15,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"57":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"’":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"v":{"df":3,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"115":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":3,"docs":{"58":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.0}}}},"’":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"<":{"'":{"a":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":1,"docs":{"125":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"7":{"tf":1.0}}}}}},"w":{"df":2,"docs":{"67":{"tf":1.0},"73":{"tf":1.0}}}},"o":{"'":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"1":{"tf":1.0},"79":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"107":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"123":{"tf":2.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"31":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"22":{"tf":1.0},"28":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"20":{"tf":1.0},"35":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":3,"docs":{"107":{"tf":1.0},"28":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":32,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"111":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"24":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"56":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":2.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"97":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"97":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"103":{"tf":2.449489742783178}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}},"s":{"df":1,"docs":{"29":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}},"w":{"df":1,"docs":{"1":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"!":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"78":{"tf":2.0}}}},"df":0,"docs":{}},"df":35,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":15,"docs":{"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"118":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"69":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"28":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"df":5,"docs":{"123":{"tf":1.0},"125":{"tf":1.7320508075688772},"126":{"tf":1.0},"71":{"tf":2.0},"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":2.0}}},"df":0,"docs":{}},"df":13,"docs":{"117":{"tf":1.4142135623730951},"22":{"tf":2.0},"34":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"54":{"tf":2.449489742783178},"55":{"tf":3.0},"57":{"tf":2.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":2.6457513110645907},"67":{"tf":1.0},"81":{"tf":3.605551275463989}}},"y":{"df":5,"docs":{"54":{"tf":2.23606797749979},"55":{"tf":2.6457513110645907},"65":{"tf":2.6457513110645907},"67":{"tf":1.0},"81":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"109":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":14,"docs":{"102":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"92":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":13,"docs":{"106":{"tf":1.0},"127":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"20":{"tf":2.0},"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"75":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}},"r":{"df":16,"docs":{"106":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"127":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"41":{"tf":1.0},"6":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"v":{"df":4,"docs":{"20":{"tf":1.0},"75":{"tf":1.0},"86":{"tf":1.0},"99":{"tf":1.0}}}},"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"71":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}}}},"’":{"d":{"df":2,"docs":{"46":{"tf":1.4142135623730951},"71":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"109":{"tf":1.0},"115":{"tf":1.0}}}},"r":{"df":2,"docs":{"70":{"tf":1.0},"82":{"tf":1.0}}},"v":{"df":4,"docs":{"26":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}}},"z":{"df":3,"docs":{"101":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772}}}}},"title":{"root":{"1":{"2":{"8":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"0":{"1":{"5":{"df":1,"docs":{"8":{"tf":1.0}}},"8":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":1,"docs":{"58":{"tf":1.0}}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":2,"docs":{"47":{"tf":1.0},"58":{"tf":1.0}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"101":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"n":{"c":{"/":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"100":{"tf":1.0},"124":{"tf":1.0}}}}},"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"110":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"126":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":10,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"127":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"127":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"5":{"tf":1.0},"7":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"118":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"117":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"37":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"89":{"tf":1.0},"95":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":1,"docs":{"63":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"31":{"tf":1.0},"33":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"91":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"127":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"107":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"56":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"105":{"tf":1.0},"107":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"73":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":9,"docs":{"19":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"107":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"c":{"df":1,"docs":{"90":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"108":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}},"i":{"df":1,"docs":{"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.0},"35":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"55":{"tf":1.0},"81":{"tf":1.0}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"104":{"tf":1.0},"113":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"20":{"tf":1.0},"22":{"tf":1.0}}}}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"117":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"71":{"tf":1.0},"97":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"104":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"33":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":1,"docs":{"69":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"124":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"i":{"d":{"df":1,"docs":{"93":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"37":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"81":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"125":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"15":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"53":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"106":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.0}}}},"w":{"df":1,"docs":{"120":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":5,"docs":{"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"84":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":16,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"77":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"v":{"c":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"103":{"tf":1.0},"104":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"l":{"df":3,"docs":{"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":8,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"102":{"tf":1.0}}}},"w":{"df":2,"docs":{"117":{"tf":1.0},"68":{"tf":1.0}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.0},"68":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"27":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"101":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"18":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"115":{"tf":1.0},"119":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"39":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"o":{"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}},"w":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":2,"docs":{"105":{"tf":1.0},"106":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":1,"docs":{"70":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"37":{"tf":1.0},"39":{"tf":1.0}}}}}}},"l":{"df":1,"docs":{"93":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"91":{"tf":1.0}}},"c":{"df":1,"docs":{"101":{"tf":1.4142135623730951}}},"d":{"df":0,"docs":{},"o":{"c":{"df":3,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0}}},"df":0,"docs":{}}},"df":9,"docs":{"110":{"tf":1.0},"113":{"tf":1.0},"120":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"c":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"124":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{":":{":":{"df":0,"docs":{},"o":{"df":1,"docs":{"115":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"119":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"45":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"12":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.0},"88":{"tf":1.0}}}}}}},"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"117":{"tf":1.0},"29":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"123":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"98":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"36":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":3,"docs":{"37":{"tf":1.0},"45":{"tf":1.0},"64":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":6,"docs":{"106":{"tf":1.0},"118":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"84":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}}},"pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});