// Copyright 2014-2018 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.





#![allow(dead_code)]
#![warn(clippy::unused_io_amount)]

use std::io;

// FIXME: compiletest doesn't understand errors from macro invocation span
fn try_macro<T: io::Read + io::Write>(s: &mut T) -> io::Result<()> {
    try!(s.write(b"test"));
    let mut buf = [0u8; 4];
    try!(s.read(&mut buf));
    Ok(())
}

fn question_mark<T: io::Read + io::Write>(s: &mut T) -> io::Result<()> {
    s.write(b"test")?;
    let mut buf = [0u8; 4];
    s.read(&mut buf)?;
    Ok(())
}

fn unwrap<T: io::Read + io::Write>(s: &mut T) {
    s.write(b"test").unwrap();
    let mut buf = [0u8; 4];
    s.read(&mut buf).unwrap();
}

fn main() {
}
