/* ISC license. */

#ifndef UINT16_H
#define UINT16_H

#include <sys/types.h>
#include <stdint.h>

#define uint16_little_endian(s, n)
#define uint16_big_endian(s, n) uint16_reverse((s), (n))

#define uint16_little(u) (u)
#define uint16_big(u) uint16_bswap(u)

extern void uint16_pack (char *, uint16_t) ;
extern void uint16_pack_big (char *, uint16_t) ;
extern void uint16_unpack (char const *, uint16_t *) ;
extern void uint16_unpack_big (char const *, uint16_t *) ;
extern void uint16_reverse (char *, size_t) ;
extern uint16_t uint16_bswap (uint16_t) ;

#define UINT16_FMT 6
#define UINT16_OFMT 7
#define UINT16_XFMT 5
#define UINT16_BFMT 17

extern size_t uint16_fmt_base (char *, uint16_t, unsigned int) ;
extern size_t uint160_fmt_base (char *, uint16_t, size_t, unsigned int) ;

#define uint16_fmt(s, u) uint16_fmt_base(s, (u), 10)
#define uint160_fmt(s, u, n) uint160_fmt_base(s, u, (n), 10)
#define uint16_ofmt(s, o) uint16_fmt_base(s, (o), 8)
#define uint160_ofmt(s, o, n) uint160_fmt_base(s, o, (n), 8)
#define uint16_xfmt(s, x) uint16_fmt_base(s, (x), 16)
#define uint160_xfmt(s, x, n) uint160_fmt_base(s, x, (n), 16)
#define uint16_bfmt(s, b) uint160_fmt_base(s, (b), 2)
#define uint160_bfmt(s, b, n) uint160_fmt_base(s, b, (n), 2)

extern size_t uint16_fmtlist (char *, uint16_t const *, size_t) ;

extern size_t uint16_scan_base (char const *, uint16_t *, unsigned int) ;
extern size_t uint160_scan_base (char const *, uint16_t *, unsigned int) ;

#define uint16_scan(s, u) uint16_scan_base(s, (u), 10)
#define uint160_scan(s, u) uint160_scan_base(s, (u), 10)
#define uint16_oscan(s, u) uint16_scan_base(s, (u), 8)
#define uint160_oscan(s, u) uint160_scan_base(s, (u), 8)
#define uint16_xscan(s, u) uint16_scan_base(s, (u), 16)
#define uint160_xscan(s, u) uint160_scan_base(s, (u), 16)
#define uint16_bscan(s, u) uint16_scan_base(s, (u), 2)
#define uint160_bscan(s, u) uint160_scan_base(s, (u), 2)

extern size_t uint16_scanlist (uint16_t *, size_t, char const *, size_t *) ;

extern size_t int16_fmt (char *, int16_t) ;
extern size_t int16_fmtlist (char *, int16_t const *, size_t) ;
extern size_t int16_scan (char const *, int16_t *) ;
extern size_t int160_scan (char const *, int16_t *) ;
extern size_t int16_scanlist (int16_t *, size_t, char const *, size_t *) ;

typedef uint16_t uint16 ;

#endif
