/* ISC license. */

#ifndef UINT64_H
#define UINT64_H

#include <sys/types.h>
#include <stdint.h>

#define uint64_little_endian(s, n)
#define uint64_big_endian(s, n) uint64_reverse((s), (n))

#define uint64_little(u) (u)
#define uint64_big(u) uint64_bswap(u)

extern void uint64_pack (char *, uint64_t) ;
extern void uint64_pack_big (char *, uint64_t) ;
extern void uint64_unpack (char const *, uint64_t *) ;
extern void uint64_unpack_big (char const *, uint64_t *) ;
extern void uint64_reverse (char *, size_t) ;
extern uint64_t uint64_bswap (uint64_t) ;

#define UINT64_FMT 21
#define UINT64_OFMT 25
#define UINT64_XFMT 17
#define UINT64_BFMT 65

extern size_t uint64_fmt_base (char *, uint64_t, unsigned int) ;
extern size_t uint640_fmt_base (char *, uint64_t, size_t, unsigned int) ;

#define uint64_fmt(s, u) uint64_fmt_base(s, (u), 10)
#define uint640_fmt(s, u, n) uint640_fmt_base(s, u, (n), 10)
#define uint64_ofmt(s, o) uint64_fmt_base(s, (o), 8)
#define uint640_ofmt(s, o, n) uint640_fmt_base(s, o, (n), 8)
#define uint64_xfmt(s, x) uint64_fmt_base(s, (x), 16)
#define uint640_xfmt(s, x, n) uint640_fmt_base(s, x, (n), 16)
#define uint64_bfmt(s, b) uint640_fmt_base(s, (b), 2)
#define uint640_bfmt(s, b, n) uint640_fmt_base(s, b, (n), 2)

extern size_t uint64_fmtlist (char *, uint64_t const *, size_t) ;

extern size_t uint64_scan_base (char const *, uint64_t *, unsigned int) ;
extern size_t uint640_scan_base (char const *, uint64_t *, unsigned int) ;

#define uint64_scan(s, u) uint64_scan_base(s, (u), 10)
#define uint640_scan(s, u) uint640_scan_base(s, (u), 10)
#define uint64_oscan(s, u) uint64_scan_base(s, (u), 8)
#define uint640_oscan(s, u) uint640_scan_base(s, (u), 8)
#define uint64_xscan(s, u) uint64_scan_base(s, (u), 16)
#define uint640_xscan(s, u) uint640_scan_base(s, (u), 16)
#define uint64_bscan(s, u) uint64_scan_base(s, (u), 2)
#define uint640_bscan(s, u) uint640_scan_base(s, (u), 2)

extern size_t uint64_scanlist (uint64_t *, size_t, char const *, size_t *) ;

extern size_t int64_fmt (char *, int64_t) ;
extern size_t int64_fmtlist (char *, int64_t const *, size_t) ;
extern size_t int64_scan (char const *, int64_t *) ;
extern size_t int640_scan (char const *, int64_t *) ;
extern size_t int64_scanlist (int64_t *, size_t, char const *, size_t *) ;

typedef uint64_t uint64 ;

#endif
